/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json.gen;

import jiracloud.com.atlassian.jira.rest.client.api.domain.ServerInfo;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class LinkIssuesInputGenerator
implements JsonGenerator<LinkIssuesInput> {
    private final ServerInfo serverInfo;

    public LinkIssuesInputGenerator(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public JSONObject generate(LinkIssuesInput linkIssuesInput) throws JSONException {
        JSONObject res = new JSONObject();
        int buildNumber = this.serverInfo.getBuildNumber();
        if (buildNumber >= 700) {
            res.put("type", new JSONObject().put("name", linkIssuesInput.getLinkType()));
            res.put("inwardIssue", new JSONObject().put("key", linkIssuesInput.getFromIssueKey()));
            res.put("outwardIssue", new JSONObject().put("key", linkIssuesInput.getToIssueKey()));
        } else {
            res.put("linkType", linkIssuesInput.getLinkType());
            res.put("fromIssueKey", linkIssuesInput.getFromIssueKey());
            res.put("toIssueKey", linkIssuesInput.getToIssueKey());
        }
        if (linkIssuesInput.getComment() != null) {
            res.put("comment", new CommentJsonGenerator(this.serverInfo).generate(linkIssuesInput.getComment()));
        }
        return res;
    }
}

