/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Named;
import java.io.IOException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsDetailedException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.exception.AzureException;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.AzureError;

@Component(value="azureDevOpsExceptionHandler")
public class ExceptionHandler {
    private final MessageSource messageSource;

    public ExceptionHandler(@Named(value="azureDevOpsConnectorMessageSource") MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public BugTrackerRemoteException azureHttpError(HttpClientErrorException ex) {
        String jsonBody = ex.getResponseBodyAsString();
        try {
            AzureError error = (AzureError)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(jsonBody, AzureError.class);
            return new AzureException(error);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.genericError((Exception)ex);
        }
    }

    public BugTrackerRemoteException missingRightError() {
        String translation = this.messageSource.getMessage("interface.exception.missing-right", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException wrongProjectPath(String projectPath) {
        String translation = this.messageSource.getMessage("interface.exception.wrong-project-path", new Object[]{projectPath}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException genericError(Exception ex) {
        String translation = this.messageSource.getMessage("interface.exception.unknown-exception", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException("%s %s".formatted(translation, ex.getMessage()), ex.getCause());
    }

    public BugTrackerNoCredentialsDetailedException connexionDenied() {
        String translation = this.messageSource.getMessage("interface.exception.connexion-denied", null, LocaleContextHolder.getLocale());
        return new BugTrackerNoCredentialsDetailedException(translation, null);
    }

    public BugTrackerRemoteException projectNotFound(String projectName) {
        String translation = this.messageSource.getMessage("interface.exception.not-found.project", new Object[]{projectName}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException workItemsNotFound() {
        String translation = this.messageSource.getMessage("interface.exception.not-found.work-items", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException workItemNotFound(String workItemId) {
        String translation = this.messageSource.getMessage("interface.exception.not-found.work-item", new Object[]{workItemId}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException cantUploadFile(String fileName) {
        String translation = this.messageSource.getMessage("interface.exception.cant-upload-file", new Object[]{fileName}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public static interface ExceptionMessageKeys {
        public static final String UNKNOWN_EXCEPTION = "interface.exception.unknown-exception";
        public static final String PROJECT_NOT_FOUND = "interface.exception.not-found.project";
        public static final String WORK_ITEMS_NOT_FOUND = "interface.exception.not-found.work-items";
        public static final String WORK_ITEM_NOT_FOUND = "interface.exception.not-found.work-item";
        public static final String CANT_UPLOAD_FILE = "interface.exception.cant-upload-file";
        public static final String CONNEXION_DENIED = "interface.exception.connexion-denied";
        public static final String WRONG_PROJECT_PATH = "interface.exception.wrong-project-path";
        public static final String MISSING_RIGHT = "interface.exception.missing-right";
    }
}

