/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.azuredevops.AzureDevOpsBugtrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.AzureDevopsConnectorProvider")
public class AzureDevOpsBugtrackerConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    public static final String KIND = "azuredevops.bugtracker";
    private static final String LABEL = "Azure Devops Bugtracker REST connector";
    private final Provider<AzureDevOpsBugtrackerConnector> connectorProvider;
    private final MessageSource messageSource;

    public AzureDevOpsBugtrackerConnectorProvider(Provider<AzureDevOpsBugtrackerConnector> connectorProvider, @Named(value="azureDevOpsConnectorMessageSource") MessageSource messageSource) {
        this.connectorProvider = connectorProvider;
        this.messageSource = messageSource;
    }

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        AzureDevOpsBugtrackerConnector connector = (AzureDevOpsBugtrackerConnector)this.connectorProvider.get();
        connector.setBugtracker(bugTracker);
        return connector;
    }

    public BugTrackerProviderDescriptor getDescriptor() {
        return new BugTrackerProviderDescriptor(){

            public boolean usePathToProjects() {
                return true;
            }

            public String getProjectHelpMessage() {
                return AzureDevOpsBugtrackerConnectorProvider.this.messageSource.getMessage("interface.configuration.project-help-message", null, LocaleContextHolder.getLocale());
            }
        };
    }
}

