/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain;

import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemPath;

public class SquashCompositeKey
extends WorkItemPath {
    private static final String SEPARATOR = "~";

    public SquashCompositeKey(String organizationName, String projectName, String workItemId) {
        super(organizationName, projectName, workItemId);
    }

    public static SquashCompositeKey withProjectPath(String projectPath, String workItemId) {
        String organizationName = Project.extractOrganizationName(projectPath);
        String projectName = Project.extractProjectName(projectPath);
        return new SquashCompositeKey(organizationName, projectName, workItemId);
    }

    public String toString() {
        return this.organizationName + SEPARATOR + this.projectName + SEPARATOR + this.workItemId;
    }

    public static SquashCompositeKey fromString(String key) {
        String[] tokens = key.split(SEPARATOR);
        if (tokens.length < 3) {
            throw new RuntimeException("Could not parse as squash composite key " + key);
        }
        String organizationName = tokens[0];
        String projectName = tokens[1];
        String workItemId = tokens[2];
        return new SquashCompositeKey(organizationName, projectName, workItemId);
    }
}

