/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.api.domain.input;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.joda.time.DateTime;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicUser;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Visibility;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Worklog;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.WorklogInput;

public class WorklogInputBuilder {
    public static final String ESTIMATE_UNIT_MINUTES = "m";
    private URI self;
    private URI issueUri;
    private BasicUser author;
    private BasicUser updateAuthor;
    private String comment;
    private DateTime startDate;
    private int minutesSpent;
    private Visibility visibility;
    private WorklogInput.AdjustEstimate adjustEstimate = WorklogInput.AdjustEstimate.AUTO;
    private String adjustEstimateValue;

    public WorklogInputBuilder(URI issueUri) {
        Preconditions.checkNotNull((Object)issueUri, (Object)"The issueUri cannot be null");
        this.issueUri = issueUri;
    }

    public WorklogInputBuilder copyFromWorklog(Worklog worklog) {
        return this.setSelf(worklog.getSelf()).setIssueUri(worklog.getIssueUri()).setAuthor(worklog.getAuthor()).setUpdateAuthor(worklog.getUpdateAuthor()).setComment(worklog.getComment()).setStartDate(worklog.getStartDate()).setMinutesSpent(worklog.getMinutesSpent()).setVisibility(worklog.getVisibility());
    }

    private WorklogInputBuilder setAdjustEstimate(WorklogInput.AdjustEstimate adjustEstimate, String estimateValue) {
        this.adjustEstimate = adjustEstimate;
        this.adjustEstimateValue = estimateValue;
        return this;
    }

    public WorklogInputBuilder setAdjustEstimateNew(String newEstimate) {
        return this.setAdjustEstimate(WorklogInput.AdjustEstimate.NEW, newEstimate);
    }

    public WorklogInputBuilder setAdjustEstimateNew(int newEstimateMinutes) {
        return this.setAdjustEstimate(WorklogInput.AdjustEstimate.NEW, newEstimateMinutes + ESTIMATE_UNIT_MINUTES);
    }

    public WorklogInputBuilder setAdjustEstimateLeave() {
        return this.setAdjustEstimate(WorklogInput.AdjustEstimate.LEAVE, null);
    }

    public WorklogInputBuilder setAdjustEstimateManual(String reduceEstimateBy) {
        return this.setAdjustEstimate(WorklogInput.AdjustEstimate.MANUAL, reduceEstimateBy);
    }

    public WorklogInputBuilder setAdjustEstimateManual(int reduceEstimateByMinutes) {
        return this.setAdjustEstimate(WorklogInput.AdjustEstimate.MANUAL, reduceEstimateByMinutes + ESTIMATE_UNIT_MINUTES);
    }

    public WorklogInputBuilder setAdjustEstimateAuto() {
        return this.setAdjustEstimate(WorklogInput.AdjustEstimate.AUTO, null);
    }

    public WorklogInputBuilder setSelf(URI self) {
        this.self = self;
        return this;
    }

    public WorklogInputBuilder setIssueUri(URI issueUri) {
        this.issueUri = issueUri;
        return this;
    }

    public WorklogInputBuilder setAuthor(BasicUser author) {
        this.author = author;
        return this;
    }

    public WorklogInputBuilder setUpdateAuthor(BasicUser updateAuthor) {
        this.updateAuthor = updateAuthor;
        return this;
    }

    public WorklogInputBuilder setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public WorklogInputBuilder setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorklogInputBuilder setMinutesSpent(int minutesSpent) {
        this.minutesSpent = minutesSpent;
        return this;
    }

    public WorklogInputBuilder setVisibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public WorklogInput build() {
        return new WorklogInput(this.self, this.issueUri, this.author, this.updateAuthor, this.comment, this.startDate, this.minutesSpent, this.visibility, this.adjustEstimate, this.adjustEstimateValue);
    }
}

