/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.domain.tf.automationrequest.SynchronizableIssueStatus;
import org.squashtest.tm.plugin.workflow.automjira.domain.TestCaseToSynchronize;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.RemoteIssueFinderService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationHelperService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;

@Service
@Transactional
public class SynchronizationHelperServiceImpl
implements SynchronizationHelperService {
    private final PlatformTransactionManager transactionManager;
    private final BugTrackerFinderService serverFinder;
    private final RemoteIssueFinderService remoteIssueFinderService;
    @PersistenceContext
    private EntityManager entityManager;

    public SynchronizationHelperServiceImpl(PlatformTransactionManager transactionManager, BugTrackerFinderService serverFinder, RemoteIssueFinderService remoteIssueFinderService) {
        this.transactionManager = transactionManager;
        this.serverFinder = serverFinder;
        this.remoteIssueFinderService = remoteIssueFinderService;
    }

    @Override
    public void logSyncStarted(Long remoteSynchronizationId, Date syncDate) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronizationId);
        if (remoteSynchronisation.isSynchronisationEnable()) {
            remoteSynchronisation.setLastSyncDate(syncDate);
            remoteSynchronisation.setSynchronisationStatus(SynchronisationStatus.RUNNING);
            this.entityManager.flush();
            this.entityManager.clear();
        }
        this.transactionManager.commit(transaction);
    }

    @Override
    public void logFinalStatus(Long remoteSynchronizationId, SynchronisationStatus synchronisationStatus, Date syncDate) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronizationId);
        if (remoteSynchronisation.isSynchronisationEnable()) {
            remoteSynchronisation.setSynchronisationStatus(synchronisationStatus);
            remoteSynchronisation.setLastSynchronisationStatus(synchronisationStatus);
            if (synchronisationStatus.equals((Object)SynchronisationStatus.SUCCESS)) {
                remoteSynchronisation.setLastSuccessfulSyncDate(syncDate);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
        this.transactionManager.commit(transaction);
    }

    @Override
    public List<TestCaseToSynchronize> getListTestCaseCanBeSynchronized(List<Issue> listIssueJira, List<RemoteAutomationRequestExtender> listRareByProjectId) {
        ArrayList<TestCaseToSynchronize> listTcToSynchronize = new ArrayList<TestCaseToSynchronize>();
        for (RemoteAutomationRequestExtender rare : listRareByProjectId) {
            Optional<Issue> issueExist = listIssueJira.stream().filter(issue -> issue.getKey().equals(rare.getRemoteIssueKey())).findFirst();
            Issue remoteIssue = issueExist.orElse(null);
            if (remoteIssue != null) {
                String remoteAssignee = remoteIssue.getAssignee() != null ? remoteIssue.getAssignee().getDisplayName() : "";
                String remoteStatus = remoteIssue.getStatus() != null ? remoteIssue.getStatus().getName() : "";
                String remoteSummary = remoteIssue.getStatus() != null ? remoteIssue.getSummary() : "";
                String remoteDescription = remoteIssue.getStatus() != null ? remoteIssue.getDescription() : "";
                rare.setSynchronizableIssueStatus(SynchronizableIssueStatus.TO_SYNCHRONIZE);
                listTcToSynchronize.add(new TestCaseToSynchronize(rare.getAutomationRequest().getTestCase(), rare, remoteAssignee, remoteStatus, remoteSummary, remoteDescription));
                continue;
            }
            SynchronizableIssueStatus status = this.getSynchronizableIssueStatus(rare);
            rare.setSynchronizableIssueStatus(status);
        }
        return listTcToSynchronize;
    }

    private SynchronizableIssueStatus getSynchronizableIssueStatus(RemoteAutomationRequestExtender rare) {
        BugTracker bugtracker = this.serverFinder.findById(rare.getServer().getId().longValue());
        Issue remoteIssue = this.remoteIssueFinderService.findRemoteIssueByKey(rare.getRemoteIssueKey(), bugtracker);
        return remoteIssue == null ? SynchronizableIssueStatus.DELETED : SynchronizableIssueStatus.NON_COMPLIANT;
    }
}

