/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.plugin.workflow.automjira.domain.ConfigurationForProject;
import org.squashtest.tm.plugin.workflow.automjira.domain.CustomFieldInfo;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@Repository
public class PluginDao {
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private ProjectDao projectDao;

    public Map<String, String> storeConfigurationForProject(Long projectId, ConfigurationForProject confForProject) throws JsonProcessingException {
        HashMap<String, String> storageConf = new HashMap<String, String>();
        storageConf.put("serverForProject", String.valueOf(confForProject.getServerJira()));
        storageConf.put("projectKey", confForProject.getProjectKey());
        storageConf.put("requestType", String.valueOf(confForProject.getRequestType()));
        storageConf.put("finalState", confForProject.getFinalState());
        storageConf.put("listCufs", new ObjectMapper().writeValueAsString(confForProject.getListCufs()));
        this.projectManager.setPluginConfiguration(projectId.longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira", storageConf);
        return storageConf;
    }

    public ConfigurationForProject loadConfigurationForProject(Long projectId) throws IOException {
        ConfigurationForProject configurationForProject = new ConfigurationForProject();
        Map conf = this.projectManager.getPluginConfiguration(projectId.longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira");
        if (conf.size() != 0) {
            if (conf.get("serverForProject") != null && !((String)conf.get("serverForProject")).isEmpty()) {
                String serverIdString = (String)conf.get("serverForProject");
                Long serverId = serverIdString != null ? Long.valueOf(serverIdString) : null;
                configurationForProject.setServerJira(serverId);
            }
            if (conf.get("projectKey") != null && !((String)conf.get("projectKey")).isEmpty()) {
                String projectIdString = (String)conf.get("projectKey");
                configurationForProject.setProjectKey(projectIdString);
            }
            if (conf.get("requestType") != null && !((String)conf.get("requestType")).isEmpty()) {
                String requestTypeIdString = (String)conf.get("requestType");
                Long requestTypeId = requestTypeIdString != null ? Long.valueOf(requestTypeIdString) : null;
                configurationForProject.setRequestType(requestTypeId);
            }
            if (conf.get("listCufs") != null && !((String)conf.get("listCufs")).isEmpty()) {
                List listCufs = (List)new ObjectMapper().readValue((String)conf.get("listCufs"), (TypeReference)new TypeReference<List<CustomFieldInfo>>(){});
                configurationForProject.setListCufs(listCufs);
            }
            configurationForProject.setFinalState((String)conf.get("finalState"));
        }
        return configurationForProject;
    }

    public void removeConfigurationPlugin(Long projectId) {
        LibraryPluginBinding lpb = this.projectDao.findPluginForProject(projectId, PluginType.AUTOMATION);
        this.projectDao.removeLibraryPluginBindingProperty(Long.valueOf(lpb.getId()));
        List listRemoteSync = this.remoteSynchronisationDao.findByProjectIdAndKind(projectId, "henix.plugin.automation.workflow.automjira");
        listRemoteSync.forEach(remoteSync -> this.remoteSynchronisationDao.delete(remoteSync));
        this.projectManager.deleteAllRemoteAutomationRequestExtenders(projectId.longValue());
    }
}

