/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.sun.jersey.api.client.filter;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import workflowautomjira.com.sun.jersey.api.client.ClientHandlerException;
import workflowautomjira.com.sun.jersey.api.client.ClientRequest;
import workflowautomjira.com.sun.jersey.api.client.ClientResponse;
import workflowautomjira.com.sun.jersey.api.client.filter.ClientFilter;
import workflowautomjira.com.sun.jersey.core.util.Base64;

public final class HTTPBasicAuthFilter
extends ClientFilter {
    private final String authentication;
    private static final Charset CHARACTER_SET = Charset.forName("iso-8859-1");

    public HTTPBasicAuthFilter(String username, byte[] password) {
        try {
            byte[] prefix = (username + ":").getBytes(CHARACTER_SET);
            byte[] usernamePassword = new byte[prefix.length + password.length];
            System.arraycopy(prefix, 0, usernamePassword, 0, prefix.length);
            System.arraycopy(password, 0, usernamePassword, prefix.length, password.length);
            this.authentication = "Basic " + new String(Base64.encode(usernamePassword), "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public HTTPBasicAuthFilter(String username, String password) {
        this(username, password.getBytes(CHARACTER_SET));
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (!cr.getHeaders().containsKey("Authorization")) {
            cr.getHeaders().add("Authorization", this.authentication);
        }
        return this.getNext().handle(cr);
    }
}

