/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import org.joda.time.DateTime;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Attachment;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicUser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

public class AttachmentJsonParser
implements JsonObjectParser<Attachment> {
    private static final String THUMBNAIL = "thumbnail";

    @Override
    public Attachment parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        String filename = json.getString("filename");
        BasicUser author = JsonParseUtil.parseBasicUser(json.optJSONObject("author"));
        DateTime creationDate = JsonParseUtil.parseDateTime(json.getString("created"));
        int size = json.getInt("size");
        String mimeType = json.getString("mimeType");
        URI contentURI = JsonParseUtil.parseURI(json.getString("content"));
        URI thumbnailURI = JsonParseUtil.parseOptionalURI(json, THUMBNAIL);
        return new Attachment(selfUri, filename, author, creationDate, size, mimeType, contentURI, thumbnailURI);
    }
}

