/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.org.codehaus.jackson.map.deser.std;

import java.io.IOException;
import workflowautomjira.org.codehaus.jackson.Base64Variants;
import workflowautomjira.org.codehaus.jackson.JsonParser;
import workflowautomjira.org.codehaus.jackson.JsonProcessingException;
import workflowautomjira.org.codehaus.jackson.JsonToken;
import workflowautomjira.org.codehaus.jackson.map.DeserializationContext;
import workflowautomjira.org.codehaus.jackson.map.TypeDeserializer;
import workflowautomjira.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import workflowautomjira.org.codehaus.jackson.map.deser.std.StdScalarDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class StringDeserializer
extends StdScalarDeserializer<String> {
    public StringDeserializer() {
        super(String.class);
    }

    @Override
    public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            return jp.getText();
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = jp.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        if (curr.isScalarValue()) {
            return jp.getText();
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }

    @Override
    public String deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return this.deserialize(jp, ctxt);
    }
}

