/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.helpers;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import workflowautomjira.org.codehaus.jackson.JsonNode;
import workflowautomjira.org.codehaus.jackson.map.ObjectMapper;

@Component
@Scope(value="prototype")
public final class JiraHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraHelper.class);
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String ATLASSIAN_TOKEN_ACCESSIBLE_RESOURCES_API_ENDPOINT = "https://api.atlassian.com/oauth/token/accessible-resources";

    public String getCloudIdForOauth2ApiRequest(BugTracker bugtracker, OAuth2Credentials credentials) {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        String cloudId = null;
        String tokenType = StringUtils.capitalize((String)credentials.getTokenType());
        try {
            HttpRequest request = HttpRequest.newBuilder().header(HTTP_AUTHORIZATION, tokenType + " " + credentials.getAccessToken()).uri(new URI(ATLASSIAN_TOKEN_ACCESSIBLE_RESOURCES_API_ENDPOINT)).GET().build();
            HttpResponse<String> httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = httpResponse.body();
            int statusCode = httpResponse.statusCode();
            if (statusCode == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsJiraInstances = mapper.readTree(responseBody);
                cloudId = JiraHelper.retrieveCloudIdByInstance(bugtracker, jsJiraInstances);
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            LOGGER.error("[AUTOM-JIRA-SYNC] - [BUGTRACKER ID:{}] Error while retrieving Oauth2 Jira Cloud ID", (Object)bugtracker.getId(), (Object)e);
        }
        return cloudId;
    }

    private static String retrieveCloudIdByInstance(BugTracker server, JsonNode jsJiraInstances) {
        int i = 0;
        while (i < jsJiraInstances.size()) {
            JsonNode obj = jsJiraInstances.get(i);
            String btUrl = server.getUrl().replaceAll("\\/*$", "");
            String jiraInstanceUrl = obj.get("url").asText();
            if (jiraInstanceUrl.equals(btUrl)) {
                return obj.get("id").asText();
            }
            ++i;
        }
        return null;
    }
}

