/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.json;

import java.util.Collections;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.SearchResult;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import workflowautomjira.org.codehaus.jettison.json.JSONArray;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

public class SearchResultJsonParser
implements JsonObjectParser<SearchResult> {
    @Override
    public SearchResult parse(JSONObject json) throws JSONException {
        Iterable<Issue> issues;
        int startAt = json.getInt("startAt");
        int maxResults = json.getInt("maxResults");
        int total = json.getInt("total");
        JSONArray issuesJsonArray = json.getJSONArray("issues");
        if (issuesJsonArray.length() > 0) {
            IssueJsonParser issueParser = new IssueJsonParser(json.getJSONObject("names"), json.getJSONObject("schema"));
            GenericJsonArrayParser<Issue> issuesParser = GenericJsonArrayParser.create(issueParser);
            issues = issuesParser.parse(issuesJsonArray);
        } else {
            issues = Collections.emptyList();
        }
        return new SearchResult(startAt, maxResults, total, issues);
    }
}

