/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.async;

import java.io.IOException;
import java.net.URI;
import workflowautomjira.com.atlassian.jira.rest.client.api.AuditRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.ComponentRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.GroupRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.IssueRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.JiraRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.MetadataRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.MyPermissionsRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.ProjectRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.ProjectRolesRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.SearchRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.SessionRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.UserRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.VersionRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousAuditRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousComponentRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousGroupRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousIssueRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousMetadataRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousMyPermissionsRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRolesRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousSearchRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousSessionRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousUserRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AsynchronousVersionRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import workflowautomjira.javax.ws.rs.core.UriBuilder;

public class AsynchronousJiraRestClient
implements JiraRestClient {
    private final IssueRestClient issueRestClient;
    private final SessionRestClient sessionRestClient;
    private final UserRestClient userRestClient;
    private final GroupRestClient groupRestClient;
    private final ProjectRestClient projectRestClient;
    private final ComponentRestClient componentRestClient;
    private final MetadataRestClient metadataRestClient;
    private final SearchRestClient searchRestClient;
    private final VersionRestClient versionRestClient;
    private final ProjectRolesRestClient projectRolesRestClient;
    private final MyPermissionsRestClient myPermissionsRestClient;
    private final DisposableHttpClient httpClient;
    private final AuditRestClient auditRestClient;

    public AsynchronousJiraRestClient(URI serverUri, DisposableHttpClient httpClient) {
        URI baseUri = UriBuilder.fromUri(serverUri).path("/rest/api/latest").build(new Object[0]);
        this.httpClient = httpClient;
        this.metadataRestClient = new AsynchronousMetadataRestClient(baseUri, httpClient);
        this.sessionRestClient = new AsynchronousSessionRestClient(serverUri, httpClient);
        this.issueRestClient = new AsynchronousIssueRestClient(baseUri, httpClient, this.sessionRestClient, this.metadataRestClient);
        this.userRestClient = new AsynchronousUserRestClient(baseUri, httpClient);
        this.groupRestClient = new AsynchronousGroupRestClient(baseUri, httpClient);
        this.projectRestClient = new AsynchronousProjectRestClient(baseUri, httpClient);
        this.componentRestClient = new AsynchronousComponentRestClient(baseUri, httpClient);
        this.searchRestClient = new AsynchronousSearchRestClient(baseUri, httpClient);
        this.versionRestClient = new AsynchronousVersionRestClient(baseUri, httpClient);
        this.projectRolesRestClient = new AsynchronousProjectRolesRestClient(serverUri, httpClient);
        this.myPermissionsRestClient = new AsynchronousMyPermissionsRestClient(baseUri, httpClient);
        this.auditRestClient = new AsynchronousAuditRestClient(httpClient, baseUri);
    }

    @Override
    public IssueRestClient getIssueClient() {
        return this.issueRestClient;
    }

    @Override
    public SessionRestClient getSessionClient() {
        return this.sessionRestClient;
    }

    @Override
    public UserRestClient getUserClient() {
        return this.userRestClient;
    }

    @Override
    public GroupRestClient getGroupClient() {
        return this.groupRestClient;
    }

    @Override
    public ProjectRestClient getProjectClient() {
        return this.projectRestClient;
    }

    @Override
    public ComponentRestClient getComponentClient() {
        return this.componentRestClient;
    }

    @Override
    public MetadataRestClient getMetadataClient() {
        return this.metadataRestClient;
    }

    @Override
    public SearchRestClient getSearchClient() {
        return this.searchRestClient;
    }

    @Override
    public VersionRestClient getVersionRestClient() {
        return this.versionRestClient;
    }

    @Override
    public ProjectRolesRestClient getProjectRolesRestClient() {
        return this.projectRolesRestClient;
    }

    @Override
    public MyPermissionsRestClient getMyPermissionsRestClient() {
        return this.myPermissionsRestClient;
    }

    @Override
    public AuditRestClient getAuditRestClient() {
        return this.auditRestClient;
    }

    @Override
    public void close() throws IOException {
        try {
            this.httpClient.destroy();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }
}

