/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.plugin.rest.admin.jackson.model.TestAutomationServerDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;

@Component
public class TestAutomationServerValidator
implements Validator {
    private static final String PATCH_SERVER = "patch-server";
    private static final String POST_SERVER = "post-server";
    @Inject
    private TestAutomationServerDao serverDao;
    @Inject
    private HelpValidator helpValidator;

    public boolean supports(Class<?> aClass) {
        return TestAutomationServerDto.class.equals(aClass);
    }

    public void validate(Object o, Errors errors) {
    }

    public void automationServerPostValidator(TestAutomationServerDto serverDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)serverDto, POST_SERVER);
        if (serverDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        if (StringUtils.isBlank((CharSequence)serverDto.getName())) {
            this.helpValidator.validateAttributes("name", (Errors)validation);
        }
        if (serverDto.getUrl() == null) {
            this.helpValidator.validateAttributes("url", (Errors)validation);
        }
        if (Objects.nonNull(serverDto.getKind())) {
            try {
                TestAutomationServerKind.valueOf((String)serverDto.getKind());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                validation.rejectValue("kind", "wrong kind", "Test automation server kind can only be 'jenkins' or 'squashOrchestrator'");
            }
        }
        this.validateNameDoesNotExist((Errors)validation, serverDto);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)serverDto, errors, (String)POST_SERVER);
    }

    public void automationServerPatchValidator(TestAutomationServer server, TestAutomationServerDto serverDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)serverDto, PATCH_SERVER);
        if (serverDto.isHasName() && !server.getName().equals(serverDto.getName())) {
            this.helpValidator.validateAttributes("name", (Errors)validation);
            this.validateNameDoesNotExist((Errors)validation, serverDto);
        }
        if (StringUtils.isNotBlank((CharSequence)serverDto.getKind())) {
            validation.rejectValue("kind", "non patchable attribute", "server kind cannot be modified");
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)serverDto, errors, (String)PATCH_SERVER);
    }

    private void validateNameDoesNotExist(Errors errors, TestAutomationServerDto serverDto) {
        TestAutomationServer nameInUse = this.serverDao.findByName(serverDto.getName());
        if (nameInUse != null) {
            errors.rejectValue("name", "invalid value", "The name is already used by another automation server");
        }
    }
}

