/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmRepositoryCreationParameterDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmRepositoryDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.ScmRepositoryDao;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;

@Component
public class ScmRepositoryValidator
implements Validator {
    @PersistenceContext
    protected EntityManager entityManager;
    @Inject
    private ScmServerDao scmServerDao;
    @Inject
    private HelpValidator helpValidator;
    @Inject
    private ScmConnectorRegistry scmConnectorRegistry;
    @Inject
    private ScmRepositoryDao scmRepositoryDao;
    private static final String PATCH_SCM_REPOSITORY = "patch-scm-repository";
    private static final String POST_SCM_REPOSITORY = "post-scm-repository";

    public boolean supports(Class<?> aClass) {
        return ScmRepositoryDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void scmRepositoryPostValidator(Long serverId, ScmRepositoryDto scmRepositoryDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)scmRepositoryDto, POST_SCM_REPOSITORY);
        this.validateScmServerExistence(serverId, (BindingResult)validation);
        this.validateAttributeId(scmRepositoryDto, (BindingResult)validation);
        this.validateNameScmRepository((Errors)validation, serverId, scmRepositoryDto);
        this.validateAttributes(scmRepositoryDto, (BindingResult)validation);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)scmRepositoryDto, errors, (String)POST_SCM_REPOSITORY);
    }

    private void validateScmServerExistence(Long serverId, BindingResult validation) {
        ScmServer scmServer = (ScmServer)this.entityManager.find(ScmServer.class, (Object)serverId);
        if (Objects.isNull(scmServer)) {
            String message = "No entity known for type %s and id %d".formatted("scm-server", serverId);
            validation.rejectValue("id", "invalid id", message);
        }
    }

    private void validateAttributeId(ScmRepositoryDto scmRepositoryDto, BindingResult validation) {
        if (scmRepositoryDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
    }

    private void validateNameScmRepository(Errors errors, Long scmServerId, ScmRepositoryDto scmRepositoryDto) {
        if (StringUtils.isBlank((CharSequence)scmRepositoryDto.getName())) {
            this.helpValidator.validateAttributes("name", errors);
        } else if (this.scmRepositoryDao.isRepositoryNameAndBranchAlreadyInUse(scmServerId, scmRepositoryDto.getName(), scmRepositoryDto.getWorkingBranch())) {
            errors.rejectValue("name", "generated value", "The name and branch are already used by another server. ");
        }
    }

    private void validateAttributes(ScmRepositoryDto scmRepositoryDto, BindingResult validation) {
        ScmRepositoryCreationParameterDto creationParams = scmRepositoryDto.getParams();
        if (Objects.isNull(creationParams)) {
            this.helpValidator.validateAttributes("params", (Errors)validation);
        } else if (Objects.isNull(creationParams.isCloneRepository())) {
            validation.rejectValue("params", "required", "The attribute params.clone_repository is required.");
        } else if (!creationParams.isCloneRepository().booleanValue()) {
            this.validateNonCloningAttributes(scmRepositoryDto, validation);
        } else {
            this.validateWorkingBranch(scmRepositoryDto, validation);
        }
    }

    private void validateWorkingBranch(ScmRepositoryDto scmRepositoryDto, BindingResult validation) {
        if (StringUtils.isBlank((CharSequence)scmRepositoryDto.getWorkingBranch())) {
            this.helpValidator.validateAttributes("workingBranch", (Errors)validation);
        }
    }

    private void validateNonCloningAttributes(ScmRepositoryDto scmRepositoryDto, BindingResult validation) {
        if (StringUtils.isNotBlank((CharSequence)scmRepositoryDto.getWorkingFolderPath())) {
            validation.rejectValue("workingFolderPath", "unused attribute", "repository will not be cloned so workingFolderPath must not be filled");
        }
    }

    public void scmRepositoryPatchValidator(Long repoId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult(null, PATCH_SCM_REPOSITORY);
        this.validateScmRepositoryExistence(repoId, (BindingResult)validation);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)repoId, errors, (String)PATCH_SCM_REPOSITORY);
    }

    private void validateScmRepositoryExistence(Long repoId, BindingResult validation) {
        if (this.scmRepositoryDao.findById((Object)repoId).isEmpty()) {
            String message = "No entity known for type %s and id %d".formatted("scm-repository", repoId);
            validation.rejectValue("id", "invalid id", message);
        }
    }
}

