/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BugTrackerDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;

@Component
public class BugTrackerValidator
implements Validator {
    private static final String POST_BUGTRACKER = "post-bugtracker";
    private static final String PATCH_BUGTRACKER = "patch-bugtracker";
    @Inject
    private HelpValidator helpValidator;
    @Inject
    private BugTrackerDao btDao;
    @Inject
    private BugTrackerManagerService btManagerService;

    public boolean supports(Class<?> clazz) {
        return false;
    }

    public void validate(Object target, Errors errors) {
    }

    public void bugtrackerPostValidator(Long bugtrackerId, BugTrackerDto btDto) throws BindException {
        Set existingKinds;
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)btDto, POST_BUGTRACKER);
        this.validate(btDto, (Errors)validation);
        if (!btDto.get_type().equalsIgnoreCase("bug-tracker")) {
            String message = "type' must be 'bug-tracker'";
            validation.rejectValue("_type", "invalid type", message);
        }
        if (!(existingKinds = this.btManagerService.findBugTrackerKinds()).contains(btDto.getKind())) {
            String message = "invalid kind. available values :'" + String.join((CharSequence)",", existingKinds);
            validation.rejectValue("kind", "invalid kind", message);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)btDto, errors, (String)POST_BUGTRACKER);
    }

    public void bugtrackerPatchValidator(Long bugtrackerId, BugTrackerDto btDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)btDto, PATCH_BUGTRACKER);
        this.validate(btDto, (Errors)validation);
        BugTracker bugtracker = this.btDao.findByName(btDto.getName());
        if (bugtracker != null && !Objects.equals(bugtracker.getId(), bugtrackerId)) {
            validation.rejectValue("name", "generated value", "The name is already used by another server. ");
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)btDto, errors, (String)PATCH_BUGTRACKER);
    }
}

