/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;

public class MilestoneHolderPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private BasicResourceAssembler assembler;

    public MilestoneHolderPropertyWriter() {
    }

    public MilestoneHolderPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, BasicResourceAssembler assembler) {
        super(propDef, contextAnnotations, declaredType);
        this.assembler = assembler;
    }

    protected Object value(Object bean, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        MilestoneHolder holder = (MilestoneHolder)bean;
        Set milestones = holder.getMilestones();
        return milestones.stream().map(milestone -> this.assembler.toModel((Identified)milestone)).collect(Collectors.toList());
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> mapperConfig, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new MilestoneHolderPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.assembler);
    }
}

