/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.LegacyAiServerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.validators.AiServerValidator;
import org.squashtest.tm.plugin.rest.admin.validators.CredentialsValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;

@RestApiController(value=AiServer.class)
@UseDefaultRestApiConfiguration
public class RestAiServerController
extends BaseRestController {
    private final RestAiServerService aiServerService;
    private final ThirdPartyServerCredentialsService serverCredentialsService;
    private final AiServerValidator aiServerValidator;
    private final AiServerManagerService aiServerManagerService;
    private final ThirdPartyServerCredentialsService thirdPartyServerCredentialsService;
    private final CredentialsValidator credentialsValidator;
    private LegacyAiServerResourceAssembler legacyAiServerResourceAssembler = new LegacyAiServerResourceAssembler();
    private AiServerResourceAssembler aiServerResourceAssembler = new AiServerResourceAssembler();

    public RestAiServerController(RestAiServerService aiServerService, ThirdPartyServerCredentialsService serverCredentialsService, AiServerValidator aiServerValidator, AiServerManagerService aiServerManagerService, ThirdPartyServerCredentialsService thirdPartyServerCredentialsService, CredentialsValidator credentialsValidator) {
        this.aiServerService = aiServerService;
        this.serverCredentialsService = serverCredentialsService;
        this.aiServerValidator = aiServerValidator;
        this.aiServerManagerService = aiServerManagerService;
        this.thirdPartyServerCredentialsService = thirdPartyServerCredentialsService;
        this.credentialsValidator = credentialsValidator;
    }

    @GetMapping(value={"/ai-servers/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*, -provider, -model_name, -options")
    public ResponseEntity<EntityModel<AiServer>> findLegacyAiServerById(@PathVariable(value="id") Long aiServerId) {
        this.aiServerValidator.validateIsLegacyAiServer(aiServerId);
        AiServer server = this.aiServerService.findAiServerById(aiServerId);
        EntityModel<AiServer> res = this.customToResourceForLegacyAiServer(aiServerId, server);
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/ai-servers"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*, -provider, -model_name, -options")
    public ResponseEntity<PagedModel<EntityModel<AiServer>>> findAllLegacyAiServers(Pageable pageable) {
        Page<AiServer> pageAiServer = this.aiServerService.findAllLegacyAiServers(pageable);
        PagedModel res = this.pageAssembler.toModel(pageAiServer, (RepresentationModelAssembler)this.legacyAiServerResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/ai-servers/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -provider, -model_name, -options")
    public ResponseEntity<EntityModel<AiServer>> patchLegacyAiServer(@PathVariable(value="id") Long aiServerId, @RequestBody LegacyAiServerDto aiServerDto) throws BindException {
        this.aiServerValidator.aiServerLegacyPatchValidator(aiServerId, aiServerDto);
        AiServer aiServer = this.aiServerService.updateLegacyAiServer(aiServerId, aiServerDto);
        EntityModel<AiServer> res = this.customToResourceForLegacyAiServer(aiServerId, aiServer);
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/ai-servers/{ids}"})
    public ResponseEntity<Void> deleteAiServerByIds(@PathVariable(value="ids") List<Long> aiServerIds) {
        this.aiServerService.deleteAiServers(aiServerIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/ai-servers"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @DynamicFilterExpression(value="*, -provider,-model_name, -options")
    public ResponseEntity<EntityModel<AiServer>> addLegacyAiServer(@RequestBody LegacyAiServerDto aiServerDto) throws BindException {
        this.aiServerValidator.aiServerLegacyPostValidator(aiServerDto);
        AiServer aiServer = aiServerDto.dtoToServer();
        AiServer server = this.aiServerService.createNewLegacyAiServer(aiServer);
        EntityModel<AiServer> res = this.customToResourceForLegacyAiServer(server.getId(), server);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @GetMapping(value={"/ai-servers/{id}/credentials"})
    @DynamicFilterExpression
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EntityModel<ManageableCredentials>> getCredential(@PathVariable(value="id") Long aiServerId) {
        ManageableCredentials cred = this.serverCredentialsService.findCredentials(aiServerId.longValue());
        if (Objects.isNull(cred)) {
            return ResponseEntity.noContent().build();
        }
        EntityModel<ManageableCredentials> res = this.customToResourceForCredential(aiServerId, cred);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/ai-servers/{aiServerId}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> setAiServerCredentials(@PathVariable(value="aiServerId") long aiServerId, @RequestBody ManageableCredentialsDto credentialsDto) throws BindException {
        this.credentialsValidator.validatePostCredentialsForAiServer(aiServerId, credentialsDto);
        ManageableCredentials credentials = credentialsDto.convertDto();
        this.thirdPartyServerCredentialsService.storeCredentials(aiServerId, credentials);
        this.aiServerManagerService.forceAuditAfterCredentialsUpdate(aiServerId);
        EntityModel<ManageableCredentials> res = this.customToResourceForCredential(aiServerId, credentials);
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/new-ai-servers"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*,-json_path,-payload_template")
    public ResponseEntity<PagedModel<EntityModel<AiServer>>> getAllAiServers(Pageable pageable) {
        Page<AiServer> pageAiServer = this.aiServerService.findAllAiServers(pageable);
        PagedModel res = this.pageAssembler.toModel(pageAiServer, (RepresentationModelAssembler)this.aiServerResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/new-ai-servers/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*,-json_path,-payload_template")
    public ResponseEntity<EntityModel<AiServer>> findAiServerById(@PathVariable(value="id") Long aiServerId) {
        AiServer server = this.aiServerService.findAiServerById(aiServerId);
        EntityModel<AiServer> res = this.customToResourceForAiServer(aiServerId, server);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/new-ai-servers"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @DynamicFilterExpression(value="*,-json_path,-payload_template")
    public ResponseEntity<EntityModel<AiServer>> addAiServer(@RequestBody AiServerDto aiServerDto) throws BindException {
        this.aiServerValidator.aiServerPostValidator(aiServerDto);
        AiServer server = this.aiServerService.createNewAiServer(aiServerDto);
        EntityModel<AiServer> res = this.customToResourceForAiServer(server.getId(), server);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/new-ai-servers/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*,-json_path,-payload_template")
    public ResponseEntity<EntityModel<AiServer>> patchAiServer(@PathVariable(value="id") Long aiServerId, @RequestBody AiServerDto aiServerDto) throws BindException {
        this.aiServerValidator.aiServerPatchValidator(aiServerId, aiServerDto);
        AiServer aiServer = this.aiServerService.updateAiServer(aiServerId, aiServerDto);
        EntityModel<AiServer> res = this.customToResourceForAiServer(aiServerId, aiServer);
        return ResponseEntity.ok(res);
    }

    private EntityModel<ManageableCredentials> customToResourceForCredential(long aiServerId, ManageableCredentials credentials) {
        EntityModel res = EntityModel.of((Object)credentials);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAiServerController)((Object)WebMvcLinkBuilder.methodOn(RestAiServerController.class, (Object[])new Object[0]))).getCredential(aiServerId)));
        res.add(builder.withSelfRel());
        return res;
    }

    private EntityModel<AiServer> customToResourceForLegacyAiServer(long aiServerId, AiServer aiServer) {
        EntityModel res = EntityModel.of((Object)aiServer);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAiServerController)((Object)WebMvcLinkBuilder.methodOn(RestAiServerController.class, (Object[])new Object[0]))).findLegacyAiServerById(aiServerId)));
        res.add(builder.withSelfRel());
        return res;
    }

    private EntityModel<AiServer> customToResourceForAiServer(long aiServerId, AiServer aiServer) {
        EntityModel res = EntityModel.of((Object)aiServer);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAiServerController)((Object)WebMvcLinkBuilder.methodOn(RestAiServerController.class, (Object[])new Object[0]))).findAiServerById(aiServerId)));
        res.add(builder.withSelfRel());
        return res;
    }

    private class AiServerResourceAssembler
    implements RepresentationModelAssembler<AiServer, EntityModel<AiServer>> {
        private AiServerResourceAssembler() {
        }

        public EntityModel<AiServer> toModel(AiServer entity) {
            return RestAiServerController.this.customToResourceForAiServer(entity.getId(), entity);
        }
    }

    private class LegacyAiServerResourceAssembler
    implements RepresentationModelAssembler<AiServer, EntityModel<AiServer>> {
        private LegacyAiServerResourceAssembler() {
        }

        public EntityModel<AiServer> toModel(AiServer entity) {
            return RestAiServerController.this.customToResourceForLegacyAiServer(entity.getId(), entity);
        }
    }
}

