/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableBinding;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.TestAutomationServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAutomationServersService;
import org.squashtest.tm.plugin.rest.admin.service.RestEnvironmentVariableService;
import org.squashtest.tm.plugin.rest.admin.validators.CredentialsValidator;
import org.squashtest.tm.plugin.rest.admin.validators.TestAutomationServerValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;

@RestApiController(value=TestAutomationServer.class)
@UseDefaultRestApiConfiguration
public class RestAdminTestAutomationServerController
extends RestAdminBaseController {
    @Inject
    private RestAutomationServersService restAutomationServersService;
    @Inject
    private TestAutomationServerValidator serverValidator;
    @Inject
    private TestAutomationServerDao serverDao;
    @Inject
    private ThirdPartyServerCredentialsService serverCredentialsService;
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    private CredentialsValidator credentialsValidator;
    @Inject
    private RestEnvironmentVariableService environmentVariableService;
    @Inject
    private TestAutomationServerManagerService serverManagerService;

    @PostMapping(value={"/test-automation-servers"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @DynamicFilterExpression(value="*")
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public ResponseEntity<EntityModel<TestAutomationServer>> createNewAutomationServer(@RequestBody TestAutomationServerDto serverDto) throws BindException {
        this.serverValidator.automationServerPostValidator(serverDto);
        TestAutomationServer taServer = serverDto.dtoToServer();
        TestAutomationServer server = this.restAutomationServersService.createNewAutomationServer(taServer);
        EntityModel res = this.customResource(server, server.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/test-automation-servers/{id}"})
    @ResponseBody
    @DynamicFilterExpression
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public ResponseEntity<EntityModel<TestAutomationServer>> patchAutomationServer(@PathVariable(value="id") Long serverId, @RequestBody TestAutomationServerDto serverDto) throws BindException {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.getReferenceById((Object)serverId);
        this.serverValidator.automationServerPatchValidator(server, serverDto);
        this.restAutomationServersService.updateAutomationServer(server, serverDto);
        EntityModel<TestAutomationServer> res = this.customResource(server);
        return ResponseEntity.ok(res);
    }

    @ResponseBody
    @DeleteMapping(value={"/test-automation-servers/{ids}"})
    public ResponseEntity<Void> removeAutomationServer(@PathVariable(value="ids") List<Long> serverIds) {
        this.restAutomationServersService.deleteAutomationServer(serverIds);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/test-automation-servers/{id}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> getCredential(@PathVariable(value="id") Long testAutomationServerId) {
        ManageableCredentials cred = this.serverCredentialsService.findCredentials(testAutomationServerId.longValue());
        if (Objects.isNull(cred)) {
            return ResponseEntity.noContent().build();
        }
        EntityModel<ManageableCredentials> res = this.customResource(cred);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/test-automation-servers/{id}/credentials"})
    @DynamicFilterExpression(value="*")
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public ResponseEntity<EntityModel<ManageableCredentials>> setCredentials(@PathVariable(value="id") Long testAutomationServerId, @RequestBody ManageableCredentialsDto credentialsDto) throws BindException {
        this.credentialsValidator.validatePostCredentialsForTestAutomationServer(testAutomationServerId, credentialsDto);
        ManageableCredentials credentials = credentialsDto.convertDto();
        this.serverCredentialsService.storeCredentials(testAutomationServerId.longValue(), credentials);
        EntityModel<ManageableCredentials> res = this.customToResourceForCredential(testAutomationServerId, credentials);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"test-automation-servers/{id}/environment-variables/{evIds}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<String> bindEnvironmentVariablesToTestAutomationServer(@PathVariable(value="id") Long testAutomationServerId, @PathVariable(value="evIds") List<Long> evIds) {
        TestAutomationServer testAutomationServer = this.serverManagerService.findById(testAutomationServerId.longValue());
        if (testAutomationServer.getKind().equals((Object)TestAutomationServerKind.jenkins)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Environment variables cannot be linked to the Jenkins test automation server.");
        }
        this.environmentVariableService.bindEnvironmentVariableToTestAutomationServer(testAutomationServerId, evIds);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"test-automation-servers/{id}/environment-variables/{evIds}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> unbindEnvironmentVariablesToTestAutomationServer(@PathVariable(value="id") Long testAutomationServerId, @PathVariable(value="evIds") List<Long> evIds) {
        this.environmentVariableService.unbindEnvironmentVariableToTestAutomationServer(testAutomationServerId, evIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"test-automation-servers/{id}/environment-variables/{evId}/value"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EnvironmentVariableBinding> setDefaultValueOfAnEnvironmentVariableToTestAutomationServer(@PathVariable(value="id") Long testAutomationServerId, @PathVariable(value="evId") Long evId, @RequestBody EnvironmentVariableBinding evb) {
        EnvironmentVariableBinding environmentVariableBinding = this.environmentVariableService.setDefaultValueOfAnEnvironmentVariableToTestAutomationServer(testAutomationServerId, evId, evb.getValue());
        return ResponseEntity.ok((Object)environmentVariableBinding);
    }

    private EntityModel<ManageableCredentials> customToResourceForCredential(long testAutomationServerId, ManageableCredentials credentials) {
        EntityModel res = EntityModel.of((Object)credentials);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAdminTestAutomationServerController)WebMvcLinkBuilder.methodOn(RestAdminTestAutomationServerController.class, (Object[])new Object[0])).getCredential(testAutomationServerId)));
        res.add(builder.withSelfRel());
        return res;
    }
}

