--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-8.0.0.xml
--  Ran at: 08/01/2026 11:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-d19jc3z5 (100.64.14.156)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0::mbrugniere
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '8.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0', 'mbrugniere', '../tm/tm.changelog-8.0.0.xml', NOW(), 1, '8:3ceae00424129e084f4b6a5efee23117', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-1658-add-column-duration-in-automated-execution-extender-table::xzhao
--  Add column duration in automated execution extender table
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD DURATION INT NULL COMMENT 'the execution time of a automation test';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-1658-add-column-duration-in-automated-execution-extender-table', 'xzhao', '../tm/tm.changelog-8.0.0.xml', NOW(), 2, '8:e0e7805c08ac485fe2bbb7bf7d0d2fe2', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add column duration in automated execution extender table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-custom-field-value-update-unique-constraint::rfortoso
ALTER TABLE CUSTOM_FIELD_VALUE DROP KEY u_cfv_id_type_binding;

ALTER TABLE CUSTOM_FIELD_VALUE ADD CONSTRAINT u_cfv_type_id_binding UNIQUE (BOUND_ENTITY_TYPE, BOUND_ENTITY_ID, CFB_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-custom-field-value-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 3, '8:4f3a0b55c4df19e56041ca5c162b1008', 'dropUniqueConstraint constraintName=u_cfv_id_type_binding, tableName=CUSTOM_FIELD_VALUE; addUniqueConstraint constraintName=u_cfv_type_id_binding, tableName=CUSTOM_FIELD_VALUE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-denormalized_field_value-update-unique-constraint::rfortoso
ALTER TABLE DENORMALIZED_FIELD_VALUE DROP KEY u_dfv_id_type_code;

ALTER TABLE DENORMALIZED_FIELD_VALUE ADD CONSTRAINT u_dfv_type_id_code UNIQUE (DENORMALIZED_FIELD_HOLDER_TYPE, DENORMALIZED_FIELD_HOLDER_ID, CODE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-denormalized_field_value-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 4, '8:f3ba3ce76fbf82353da8b0415f715825', 'dropUniqueConstraint constraintName=u_dfv_id_type_code, tableName=DENORMALIZED_FIELD_VALUE; addUniqueConstraint constraintName=u_dfv_type_id_code, tableName=DENORMALIZED_FIELD_VALUE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-denormalized_environment_variable-update-unique-constraint::rfortoso
ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE DROP KEY uc_dev_id_type_name;

ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE ADD CONSTRAINT uc_dev_type_id_name UNIQUE (HOLDER_TYPE, HOLDER_ID, NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-denormalized_environment_variable-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 5, '8:2a9e5d4f18bc7db6f74d169d551f843f', 'dropUniqueConstraint constraintName=uc_dev_id_type_name, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; addUniqueConstraint constraintName=uc_dev_type_id_name, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-denormalized_environment_tag-update-unique-constraint::rfortoso
ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG DROP KEY uc_det_id_type_value;

ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG ADD CONSTRAINT uc_det_type_id_value UNIQUE (HOLDER_TYPE, HOLDER_ID, VALUE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-denormalized_environment_tag-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 6, '8:c6ad67883f7109946cf1ffff0678c076', 'dropUniqueConstraint constraintName=uc_det_id_type_value, tableName=DENORMALIZED_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uc_det_type_id_value, tableName=DENORMALIZED_ENVIRONMENT_TAG', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-environment_variable_binding-update-unique-constraint::rfortoso
ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP KEY uc_evb_id_type_ev_id_binding;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD CONSTRAINT uc_type_evb_id_ev_id_binding UNIQUE (ENTITY_TYPE, ENTITY_ID, EV_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-environment_variable_binding-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 7, '8:3b6252f797ff27d1c53207796efeac42', 'dropUniqueConstraint constraintName=uc_evb_id_type_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING; addUniqueConstraint constraintName=uc_type_evb_id_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-automation_environment_tag-update-unique-constraint::rfortoso
ALTER TABLE AUTOMATION_ENVIRONMENT_TAG DROP KEY uniq_value_entity_type_entity_id;

ALTER TABLE AUTOMATION_ENVIRONMENT_TAG ADD CONSTRAINT uniq_entity_type_entity_id_value UNIQUE (ENTITY_TYPE, ENTITY_ID, VALUE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-automation_environment_tag-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 8, '8:e0ac05807349e41c5fb24882f3256bc1', 'dropUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_entity_type_entity_id_value, tableName=AUTOMATION_ENVIRONMENT_TAG', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-modify_restrain_to_active_sprint_json_keys::pguygot
UPDATE REMOTE_SYNCHRONISATION SET REMOTE_SYNCHRONISATION_OPTIONS = REPLACE(REMOTE_SYNCHRONISATION_OPTIONS, 'restrainToActiveSprint', 'restrictedToActiveSprint');

UPDATE REMOTE_SYNCHRONISATION SET REMOTE_SYNCHRONISATION_OPTIONS = REPLACE(REMOTE_SYNCHRONISATION_OPTIONS, 'restrainSprintToActiveSprint', 'sprintRestrictedToActiveSprint');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-modify_restrain_to_active_sprint_json_keys', 'pguygot', '../tm/tm.changelog-8.0.0.xml', NOW(), 9, '8:4b4ab12e5c9115ef2734c999f0b03d75', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-remove-unnecessary-roles::jprioux
DELETE FROM CORE_PARTY_AUTHORITY WHERE authority in ('ROLE_TM_PROJECT_MANAGER', 'ROLE_TF_FUNCTIONAL_TESTER', 'ROLE_TF_AUTOMATION_PROGRAMMER');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-remove-unnecessary-roles', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 10, '8:b1310cf368e526076a4c0a3e41ea173b', 'delete tableName=CORE_PARTY_AUTHORITY', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add_remote_sync_id_in_sprint_group_table::pguygot
ALTER TABLE SPRINT_GROUP ADD REMOTE_SYNCHRONISATION_ID BIGINT NULL;

ALTER TABLE SPRINT_GROUP ADD CONSTRAINT fk_sprint_group_remote_synchronisation FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION (REMOTE_SYNCHRONISATION_ID);

CREATE INDEX idx_fk_sprint_group_remote_synchronisation ON SPRINT_GROUP(REMOTE_SYNCHRONISATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add_remote_sync_id_in_sprint_group_table', 'pguygot', '../tm/tm.changelog-8.0.0.xml', NOW(), 11, '8:ab75704ac33d88c07dc647d55a209db5', 'addColumn tableName=SPRINT_GROUP; createIndex indexName=idx_fk_sprint_group_remote_synchronisation, tableName=SPRINT_GROUP', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-manage-milestone-permission::jprioux
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             32768,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-manage-milestone-permission', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 12, '8:f63c6efd6230cf89245269e638b71e7f', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-manage-project-clearance-permission::jprioux
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             65536,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-manage-project-clearance-permission', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 13, '8:8151553eb35af33e5a046096b2fbcb92', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-active-in-acl-group::jprioux
ALTER TABLE ACL_GROUP ADD ACTIVE BIT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-active-in-acl-group', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 14, '8:a33c7db7a1b65e1600e946c9a804b3a0', 'addColumn tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-description-in-acl-group::jprioux
ALTER TABLE ACL_GROUP ADD `DESCRIPTION` LONGTEXT DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-description-in-acl-group', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 15, '8:90908be5c955b9e6f6878df7d5e99a14', 'addColumn tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-auditable-columns-in-sprint-req-version::pckerneis
ALTER TABLE SPRINT_REQ_VERSION ADD CREATED_BY VARCHAR(100) NULL, ADD CREATED_ON datetime NULL, ADD LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

UPDATE SPRINT_REQ_VERSION SET CREATED_BY = 'Upgrade Squash 8.0', CREATED_ON = NOW() WHERE CREATED_ON IS NULL;

ALTER TABLE SPRINT_REQ_VERSION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE SPRINT_REQ_VERSION MODIFY CREATED_ON datetime NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-auditable-columns-in-sprint-req-version', 'pckerneis', '../tm/tm.changelog-8.0.0.xml', NOW(), 16, '8:02201a57474d7eeb1dc41031c8ad7ef7', 'addColumn tableName=SPRINT_REQ_VERSION; update tableName=SPRINT_REQ_VERSION; addNotNullConstraint columnName=CREATED_BY, tableName=SPRINT_REQ_VERSION; addNotNullConstraint columnName=CREATED_ON, tableName=SPRINT_REQ_VERSION', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-auditable-columns-in-acl-group::jprioux
ALTER TABLE ACL_GROUP ADD CREATED_BY VARCHAR(100) NULL, ADD CREATED_ON datetime NULL, ADD LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

UPDATE ACL_GROUP SET CREATED_BY = 'Upgrade Squash 8.0', CREATED_ON = NOW() WHERE qualified_name like 'squashtest.acl.group.tm.%';

ALTER TABLE ACL_GROUP MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ACL_GROUP MODIFY CREATED_ON datetime NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-auditable-columns-in-acl-group', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 17, '8:b07db4b6d67364ca49b76d4a5c2e60dc', 'addColumn tableName=ACL_GROUP; update tableName=ACL_GROUP; addNotNullConstraint columnName=CREATED_BY, tableName=ACL_GROUP; addNotNullConstraint columnName=CREATED_ON, tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-limit-acl-group-name-to-50::jprioux
ALTER TABLE ACL_GROUP MODIFY QUALIFIED_NAME VARCHAR(50);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-limit-acl-group-name-to-50', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 18, '8:3c5bc661f688ac35d2b3ad1929342cf8', 'modifyDataType columnName=QUALIFIED_NAME, tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-created-by-column-in-api-token::mbrugniere
ALTER TABLE API_TOKEN ADD CREATED_BY VARCHAR(100) NULL;

UPDATE API_TOKEN
      SET CREATED_BY = (
        SELECT CORE_USER.LOGIN
        FROM CORE_USER
        WHERE CORE_USER.PARTY_ID = API_TOKEN.USER_ID
        AND API_TOKEN.CREATED_BY IS NULL
      );

ALTER TABLE API_TOKEN MODIFY CREATED_BY VARCHAR(100) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-created-by-column-in-api-token', 'mbrugniere', '../tm/tm.changelog-8.0.0.xml', NOW(), 19, '8:9404e667316dc61a95ac0ee404b3d0cd', 'addColumn tableName=API_TOKEN; sql; addNotNullConstraint columnName=CREATED_BY, tableName=API_TOKEN', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-table-for-pivot-format-import::dclaerhout
--  Add a pivot format import table in squash tm.
CREATE TABLE PIVOT_FORMAT_IMPORT (PFI_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(255) NOT NULL, CREATED_BY BIGINT NULL COMMENT 'Foreign key to the user that requested the pivot format import', CREATED_ON datetime NOT NULL, FILE_PATH VARCHAR(255) NOT NULL, STATUS VARCHAR(50) NOT NULL, PROJECT_ID BIGINT DEFAULT null NULL, IMPORT_TYPE VARCHAR(50) NOT NULL, SUCCESSFULLY_IMPORTED_ON datetime NULL, CONSTRAINT PK_PIVOT_FORMAT_IMPORT PRIMARY KEY (PFI_ID), CONSTRAINT fk_pivot_format_import_core_user_party_id FOREIGN KEY (CREATED_BY) REFERENCES CORE_USER(PARTY_ID) ON DELETE CASCADE, CONSTRAINT fk_pivot_format_import_project_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID) ON DELETE CASCADE);

CREATE INDEX idx_fk_pivot_format_import_created_by ON PIVOT_FORMAT_IMPORT(CREATED_BY);

CREATE INDEX idx_fk_pivot_format_import_project_id ON PIVOT_FORMAT_IMPORT(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-table-for-pivot-format-import', 'dclaerhout', '../tm/tm.changelog-8.0.0.xml', NOW(), 20, '8:182841e2348a8a1a850279ea79433dae', 'createTable tableName=PIVOT_FORMAT_IMPORT; createIndex indexName=idx_fk_pivot_format_import_created_by, tableName=PIVOT_FORMAT_IMPORT; createIndex indexName=idx_fk_pivot_format_import_project_id, tableName=PIVOT_FORMAT_IMPORT', 'Add a pivot format import table in squash tm.', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-harmonize-profile-permissions::jprioux
DELETE FROM ACL_GROUP_PERMISSION
      WHERE CLASS_ID = (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary')
      AND PERMISSION_MASK NOT IN (8192, 16384);

DELETE FROM ACL_GROUP_PERMISSION
      WHERE CLASS_ID = (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project')
      AND PERMISSION_MASK = 1024;

DELETE FROM ACL_GROUP_PERMISSION
      WHERE CLASS_ID = (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.actionword.ActionWordLibrary')
      AND PERMISSION_MASK = 256;

DELETE FROM ACL_GROUP_PERMISSION
      WHERE ACL_GROUP_ID = (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.AutomatedTestWriter')
      AND PERMISSION_MASK = 1
      AND CLASS_ID NOT IN (SELECT ID FROM ACL_CLASS WHERE CLASSNAME IN ('org.squashtest.tm.domain.project.Project', 'org.squashtest.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-harmonize-profile-permissions', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 21, '8:fc4815e7a7ebdefcda58cca7097f3c55', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-credentials_not_shared-column-in-scm-server-table::xzhao
--  Add column credentials_not_shared in scm_server table
ALTER TABLE SCM_SERVER ADD CREDENTIALS_NOT_SHARED BIT(1) DEFAULT 0 NOT NULL COMMENT 'the credentials_not_shared prevent git credentials propagation';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-credentials_not_shared-column-in-scm-server-table', 'xzhao', '../tm/tm.changelog-8.0.0.xml', NOW(), 22, '8:e88afd4ddf2c6cdc58e6c17d65b625f9', 'addColumn tableName=SCM_SERVER', 'Add column credentials_not_shared in scm_server table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-remove-the-table-denormalized_field_option-from-the-squash-database::jmarque and rfortoso
--  DENORMALIZED_FIELD_OPTION has been unused for some time
TRUNCATE TABLE DENORMALIZED_FIELD_OPTION;

DROP TABLE DENORMALIZED_FIELD_OPTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-remove-the-table-denormalized_field_option-from-the-squash-database', 'jmarque and rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 23, '8:6ea53df6b0039eb00791fdf0aebf1b37', 'sql', 'DENORMALIZED_FIELD_OPTION has been unused for some time', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-validation-status-column-in-sprint-requirement-version-table::mbrugniere
--  Add column validation_status in sprint_req_version table
ALTER TABLE SPRINT_REQ_VERSION ADD VALIDATION_STATUS VARCHAR(50) DEFAULT 'TO_BE_TESTED' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-validation-status-column-in-sprint-requirement-version-table', 'mbrugniere', '../tm/tm.changelog-8.0.0.xml', NOW(), 24, '8:4480a1f0cc522bd990a1b965452f1850', 'addColumn tableName=SPRINT_REQ_VERSION', 'Add column validation_status in sprint_req_version table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-last_modified_on-column-in-attachment-table::xzhao
--  Add column last_modified_on in attachment table
ALTER TABLE ATTACHMENT ADD LAST_MODIFIED_ON datetime NULL COMMENT 'the date when the attachment was last modified';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-last_modified_on-column-in-attachment-table', 'xzhao', '../tm/tm.changelog-8.0.0.xml', NOW(), 25, '8:08c07169b1e0c8a508a59e9dc106033e', 'addColumn tableName=ATTACHMENT', 'Add column last_modified_on in attachment table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-import-permission-to-project-manager-profile::jprioux
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             512,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-import-permission-to-project-manager-profile', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 26, '8:424f4d1d95847836a0cfbc5f01d4a5b6', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447285');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

