--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-7.0.0.xml
--  Ran at: 08/01/2026 11:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-d19jc3z5 (100.64.14.156)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0::mbrugniere
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '7.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 1, '8:4d84039428ec1c6e75236450ae5a2b45', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-45-clean-database-of-nulls-in-action-steps::mbrugniere
--  Clean database of null values in test steps and execution steps
UPDATE ACTION_TEST_STEP SET ACTION = '' WHERE ACTION IS NULL;

UPDATE ACTION_TEST_STEP SET EXPECTED_RESULT = '' WHERE EXPECTED_RESULT IS NULL;

UPDATE EXECUTION_STEP SET ACTION = '' WHERE ACTION IS NULL;

UPDATE EXECUTION_STEP SET EXPECTED_RESULT = '' WHERE EXPECTED_RESULT IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-45-clean-database-of-nulls-in-action-steps', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 2, '8:15d6f2ec592778bc044a2ec3442f2b70', 'update tableName=ACTION_TEST_STEP; update tableName=ACTION_TEST_STEP; update tableName=EXECUTION_STEP; update tableName=EXECUTION_STEP', 'Clean database of null values in test steps and execution steps', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-895-action-and-expected_result_should_not_be_nullable::mbrugniere
--  Add not null constraint on columns action and expected_result
ALTER TABLE ACTION_TEST_STEP MODIFY ACTION LONGTEXT NOT NULL;

ALTER TABLE ACTION_TEST_STEP ALTER ACTION SET DEFAULT '';

ALTER TABLE ACTION_TEST_STEP MODIFY EXPECTED_RESULT LONGTEXT NOT NULL;

ALTER TABLE ACTION_TEST_STEP ALTER EXPECTED_RESULT SET DEFAULT '';

ALTER TABLE EXECUTION_STEP MODIFY ACTION LONGTEXT NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER ACTION SET DEFAULT '';

ALTER TABLE EXECUTION_STEP MODIFY EXPECTED_RESULT LONGTEXT NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER EXPECTED_RESULT SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-895-action-and-expected_result_should_not_be_nullable', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 3, '8:c73ee0e5cd76bc2fda03748af103f49f', 'addNotNullConstraint columnName=ACTION, tableName=ACTION_TEST_STEP; addDefaultValue columnName=ACTION, tableName=ACTION_TEST_STEP; addNotNullConstraint columnName=EXPECTED_RESULT, tableName=ACTION_TEST_STEP; addDefaultValue columnName=EXPECTED_RES...', 'Add not null constraint on columns action and expected_result', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-876-update-cufs-in-column-configuration::jma
--  Delete active_column_id if it does not match any cuf code. Replace the cuf's code with the cuf's id.
DELETE
      FROM GRID_COLUMN_DISPLAY_CONFIGURATION
      WHERE active_column_id LIKE 'cuf|%'
        AND active_column_id NOT IN (SELECT CONCAT('cuf|', code) FROM CUSTOM_FIELD);

UPDATE GRID_COLUMN_DISPLAY_CONFIGURATION AS gcdc
      SET active_column_id = (SELECT CONCAT('cuf|', cf.cf_id)
                              FROM CUSTOM_FIELD AS cf
                              WHERE SUBSTRING(gcdc.active_column_id, LENGTH('cuf|') + 1) = cf.code)
      WHERE gcdc.active_column_id LIKE 'cuf|%';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-876-update-cufs-in-column-configuration', 'jma', '../tm/tm.changelog-7.0.0.xml', NOW(), 4, '8:cde1f300d157fb293173c7e75fdf4cfa', 'sql', 'Delete active_column_id if it does not match any cuf code. Replace the cuf''s code with the cuf''s id.', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-table::jprioux
--  Create the sprint table
CREATE TABLE SPRINT (CLN_ID BIGINT NOT NULL COMMENT 'Shared key with CAMPAIGN_LIBRARY_NODE table', STATUS VARCHAR(50) DEFAULT 'UPCOMING' NOT NULL, REMOTE_SYNCHRONISATION_ID BIGINT NULL, REMOTE_SPRINT_ID BIGINT NULL, REMOTE_NAME VARCHAR(255) NULL, REMOTE_STATE VARCHAR(50) NULL, START_DATE datetime NULL, END_DATE datetime NULL, `REFERENCE` VARCHAR(255) NULL, CONSTRAINT pk_sprint PRIMARY KEY (CLN_ID), CONSTRAINT fk_sprint_campaign_library_node FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID), CONSTRAINT fk_sprint_remote_synchronisation FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION(REMOTE_SYNCHRONISATION_ID));

CREATE INDEX idx_fk_sprint_remote_synchronisation ON SPRINT(REMOTE_SYNCHRONISATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-table', 'jprioux', '../tm/tm.changelog-7.0.0.xml', NOW(), 5, '8:18267a63e61cdab26f9855b65b90bd0d', 'createTable tableName=SPRINT; createIndex indexName=idx_fk_sprint_remote_synchronisation, tableName=SPRINT', 'Create the sprint table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-req-version-table::rfortoso
CREATE TABLE SPRINT_REQ_VERSION (SPRINT_REQ_VERSION_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for SPRINT_REQ_VERSION', REQ_VERSION_ID BIGINT NULL, SPRINT_ID BIGINT NOT NULL, `REFERENCE` VARCHAR(50) NULL, NAME VARCHAR(255) NULL, STATUS VARCHAR(50) NULL, CRITICALITY VARCHAR(50) NULL, CATEGORY VARCHAR(50) NULL, `DESCRIPTION` LONGTEXT NULL, MODE VARCHAR(15) DEFAULT 'NATIVE' NULL COMMENT 'Says whether a sprint req version is NATIVE or SYNCHRONIZED', CONSTRAINT pk_sprint_req_version PRIMARY KEY (SPRINT_REQ_VERSION_ID), CONSTRAINT fk_sprint_req_version_sprint_id FOREIGN KEY (SPRINT_ID) REFERENCES SPRINT(CLN_ID), CONSTRAINT fk_sprint_req_version_req_version_id FOREIGN KEY (REQ_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID));

CREATE INDEX idx_fk_sprint_req_version_req_version_id ON SPRINT_REQ_VERSION(REQ_VERSION_ID);

CREATE INDEX idx_fk_sprint_req_version_sprint_id ON SPRINT_REQ_VERSION(SPRINT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-req-version-table', 'rfortoso', '../tm/tm.changelog-7.0.0.xml', NOW(), 6, '8:d70d42ae489fc3fd45cf52013e4bfefb', 'createTable tableName=SPRINT_REQ_VERSION; createIndex indexName=idx_fk_sprint_req_version_req_version_id, tableName=SPRINT_REQ_VERSION; createIndex indexName=idx_fk_sprint_req_version_sprint_id, tableName=SPRINT_REQ_VERSION', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-requirement-sync-extender-table::dclaerhout
CREATE TABLE SPRINT_REQUIREMENT_SYNC_EXTENDER (SPRINT_REQ_SYNC_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for SPRINT_REQUIREMENT_SYNC_EXTENDER', SPRINT_REQ_VERSION_ID BIGINT NOT NULL, REMOTE_REQ_ID VARCHAR(50) NULL, REMOTE_REQ_URL VARCHAR(300) NULL, REMOTE_PROJECT_ID VARCHAR(100) NULL, REMOTE_LAST_UPDATED datetime NULL, REMOTE_SYNCHRONISATION_ID BIGINT NULL, REMOTE_PERIMETER_STATUS VARCHAR(30) DEFAULT 'UNKNOWN' NOT NULL, CONSTRAINT pk_sprint_req_sync_extender PRIMARY KEY (SPRINT_REQ_SYNC_ID), CONSTRAINT fk_sprint_req_sync_ext_remote_sync_id FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION(REMOTE_SYNCHRONISATION_ID), CONSTRAINT fk_sprint_req_sync_ext_sprint_req_version_id FOREIGN KEY (SPRINT_REQ_VERSION_ID) REFERENCES SPRINT_REQ_VERSION(SPRINT_REQ_VERSION_ID));

CREATE INDEX idx_fk_sprint_req_sync_ext_sprint_req_version_id ON SPRINT_REQUIREMENT_SYNC_EXTENDER(SPRINT_REQ_VERSION_ID);

CREATE INDEX idx_fk_sprint_req_sync_ext_remote_sync_id ON SPRINT_REQUIREMENT_SYNC_EXTENDER(REMOTE_SYNCHRONISATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-requirement-sync-extender-table', 'dclaerhout', '../tm/tm.changelog-7.0.0.xml', NOW(), 7, '8:6c4950fc89283d5d5dd18c568bd1f7ec', 'createTable tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_fk_sprint_req_sync_ext_sprint_req_version_id, tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_fk_sprint_req_sync_ext_remote_sync_id, tableName=...', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-automated-suite-workflows-table::bmsaddek
Alter table AUTOMATED_EXECUTION_EXTENDER drop constraint fk_auto_exec_suite;

Alter table AUTOMATED_EXECUTION_EXTENDER
        modify column SUITE_ID VARCHAR(50) character set utf8mb4 collate utf8mb4_bin;

Alter table AUTOMATED_SUITE
        modify column SUITE_ID VARCHAR(50) character set utf8mb4 collate utf8mb4_bin;

Alter table AUTOMATED_EXECUTION_EXTENDER
        add constraint foreign key fk_auto_exec_suite (SUITE_ID)
          references AUTOMATED_SUITE (SUITE_ID);

CREATE TABLE AUTOMATED_SUITE_WORKFLOWS (SUITE_ID VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'foreign key to AUTOMATED_SUITE', WORKFLOW_ID VARCHAR(100) NOT NULL COMMENT 'id of the workflow launched from the suite', PROJECT_ID BIGINT NOT NULL COMMENT 'original project id', CONSTRAINT fk_automated_suite_workflows_suite_id FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE(SUITE_ID), CONSTRAINT fk_automated_suite_workflows_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID));

CREATE INDEX idx_fk_automated_suite_workflows_project_id ON AUTOMATED_SUITE_WORKFLOWS(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-automated-suite-workflows-table', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 8, '8:cc52a817525ce5158a3b29a5bba15f03', 'sql; createTable tableName=AUTOMATED_SUITE_WORKFLOWS; createIndex indexName=idx_fk_automated_suite_workflows_project_id, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-ai-server-table::jmarque
--  Create the ai server table
CREATE TABLE AI_SERVER (SERVER_ID BIGINT NOT NULL COMMENT 'The id of the ai server, foreign key to third_party_server.', PAYLOAD_TEMPLATE LONGTEXT NULL COMMENT 'The body of the json sent', JSON_PATH VARCHAR(255) DEFAULT null NULL COMMENT 'Specifies the JSON path used to locate the node containing the response in AI-generated test cases.', CONSTRAINT PK_AI_SERVER PRIMARY KEY (SERVER_ID));

ALTER TABLE AI_SERVER ADD CONSTRAINT fk_ai_server_third_party_server FOREIGN KEY (SERVER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-ai-server-table', 'jmarque', '../tm/tm.changelog-7.0.0.xml', NOW(), 9, '8:76fde6bb17ff2d4b5b1579d3d154027b', 'createTable tableName=AI_SERVER; addForeignKeyConstraint baseTableName=AI_SERVER, constraintName=fk_ai_server_third_party_server, referencedTableName=THIRD_PARTY_SERVER', 'Create the ai server table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-add-column-killswitch-url-in-test-automation-server::ngouriou
--  Add killswitch_url column in test automation server table
ALTER TABLE TEST_AUTOMATION_SERVER ADD KILLSWITCH_URL VARCHAR(255) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-add-column-killswitch-url-in-test-automation-server', 'ngouriou', '../tm/tm.changelog-7.0.0.xml', NOW(), 10, '8:6bbcbe34f1b840c9d8e25847201c9676', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add killswitch_url column in test automation server table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-add-column-ai_server_id-in-project::mbrugniere
--  Add column ai_server_id in project table
ALTER TABLE PROJECT ADD AI_SERVER_ID BIGINT NULL COMMENT 'the reference to the artificial intelligence server';

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_ai_server FOREIGN KEY (AI_SERVER_ID) REFERENCES AI_SERVER (SERVER_ID);

CREATE INDEX idx_fk_project_ai_server ON PROJECT(AI_SERVER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-add-column-ai_server_id-in-project', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 11, '8:b3f8a0984f0ee0bfd3c730f22b0425a4', 'addColumn tableName=PROJECT; createIndex indexName=idx_fk_project_ai_server, tableName=PROJECT', 'Add column ai_server_id in project table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-record-info-test-case-drafted-by-artificial-intelligence::mbrugniere
--  Add column drafted_by_ai in test_case table
ALTER TABLE TEST_CASE ADD DRAFTED_BY_AI BIT(1) DEFAULT 0 NULL COMMENT 'is the test case drafted by artificial intelligence';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-record-info-test-case-drafted-by-artificial-intelligence', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 12, '8:bcaf72c1d4f8da1ae849712f9efca60b', 'addColumn tableName=TEST_CASE', 'Add column drafted_by_ai in test_case table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-filtering-on-drafted-by-ai-in-test-case-search-grid::mbrugniere
--  Add entry in QUERY_COLUMN_PROTOTYPE for filtering on TEST_CASE.drafted_by_ai
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE,
                                         ATTRIBUTE_NAME, SUBQUERY_ID)
      SELECT 'ATTRIBUTE', FALSE, 'TEST_CASE_DRAFTED_BY_AI', 'TEST_CASE', null, 'BOOLEAN', 'draftedByAi', null
      WHERE NOT EXISTS (
        SELECT 1
        FROM QUERY_COLUMN_PROTOTYPE
        WHERE LABEL = 'TEST_CASE_DRAFTED_BY_AI' AND ATTRIBUTE_NAME = 'draftedByAi'
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-filtering-on-drafted-by-ai-in-test-case-search-grid', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 13, '8:fa118be4a0a61d59568884451e47f8f0', 'sql', 'Add entry in QUERY_COLUMN_PROTOTYPE for filtering on TEST_CASE.drafted_by_ai', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-test_plan-tables::pckerneis
CREATE TABLE TEST_PLAN (TEST_PLAN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key', CL_ID BIGINT NOT NULL COMMENT 'foreign key to parent CampaignLibrary', CONSTRAINT PK_TEST_PLAN PRIMARY KEY (TEST_PLAN_ID), CONSTRAINT fk_test_plan_campaign_library FOREIGN KEY (CL_ID) REFERENCES CAMPAIGN_LIBRARY(CL_ID));

CREATE INDEX idx_fk_test_plan_campaign_library ON TEST_PLAN(CL_ID);

CREATE TABLE TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key', TEST_PLAN_ID BIGINT NOT NULL COMMENT 'fk to the parent test plan', ITEM_ORDER INT NOT NULL, EXECUTION_STATUS VARCHAR(255) DEFAULT 'READY' NOT NULL, LAST_EXECUTED_BY VARCHAR(255) DEFAULT null NULL, LAST_EXECUTED_ON datetime DEFAULT null NULL, TCLN_ID BIGINT NULL, DATASET_ID BIGINT NULL, LABEL VARCHAR(255) NOT NULL, ASSIGNEE_ID BIGINT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, CONSTRAINT PK_TEST_PLAN_ITEM PRIMARY KEY (TEST_PLAN_ITEM_ID), CONSTRAINT fk_test_plan_item_user FOREIGN KEY (ASSIGNEE_ID) REFERENCES CORE_USER(PARTY_ID), CONSTRAINT fk_test_plan_item_test_plan FOREIGN KEY (TEST_PLAN_ID) REFERENCES TEST_PLAN(TEST_PLAN_ID), CONSTRAINT fk_test_plan_item_dataset FOREIGN KEY (DATASET_ID) REFERENCES DATASET(DATASET_ID), CONSTRAINT fk_test_plan_item_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID));

CREATE INDEX idx_fk_test_plan_item_test_plan ON TEST_PLAN_ITEM(TEST_PLAN_ID);

CREATE INDEX idx_fk_test_plan_item_test_case ON TEST_PLAN_ITEM(TCLN_ID);

CREATE INDEX idx_fk_test_plan_item_dataset ON TEST_PLAN_ITEM(DATASET_ID);

CREATE INDEX idx_fk_test_plan_item_user ON TEST_PLAN_ITEM(ASSIGNEE_ID);

ALTER TABLE EXECUTION ADD TEST_PLAN_ITEM_ID BIGINT NULL, ADD EXECUTION_ORDER INT NULL;

ALTER TABLE EXECUTION ADD CONSTRAINT fk_execution_test_plan_item FOREIGN KEY (TEST_PLAN_ITEM_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

CREATE INDEX idx_fk_execution_test_plan_item ON EXECUTION(TEST_PLAN_ITEM_ID);

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW ADD TEST_PLAN_ITEM_ID BIGINT NULL;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW ADD CONSTRAINT fk_exploratory_session_test_plan_item FOREIGN KEY (TEST_PLAN_ITEM_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

CREATE INDEX idx_fk_exploratory_session_test_plan_item ON EXPLORATORY_SESSION_OVERVIEW(TEST_PLAN_ITEM_ID);

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW MODIFY ITEM_TEST_PLAN_ID BIGINT NULL;

ALTER TABLE SPRINT_REQ_VERSION ADD TEST_PLAN_ID BIGINT NOT NULL;

ALTER TABLE SPRINT_REQ_VERSION ADD CONSTRAINT fk_sprint_req_version_test_plan FOREIGN KEY (TEST_PLAN_ID) REFERENCES TEST_PLAN (TEST_PLAN_ID);

CREATE INDEX idx_fk_sprint_req_version_test_plan ON SPRINT_REQ_VERSION(TEST_PLAN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-test_plan-tables', 'pckerneis', '../tm/tm.changelog-7.0.0.xml', NOW(), 14, '8:c2fef64400785013d39a8bda01b48a35', 'createTable tableName=TEST_PLAN; createIndex indexName=idx_fk_test_plan_campaign_library, tableName=TEST_PLAN; createTable tableName=TEST_PLAN_ITEM; createIndex indexName=idx_fk_test_plan_item_test_plan, tableName=TEST_PLAN_ITEM; createIndex index...', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-tc-add-automation-req-fk::bmsaddek
ALTER TABLE TEST_CASE ADD AUTOMATION_REQUEST_ID BIGINT NULL;

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_test_case_automation_request_id FOREIGN KEY (AUTOMATION_REQUEST_ID) REFERENCES AUTOMATION_REQUEST (AUTOMATION_REQUEST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-tc-add-automation-req-fk', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 15, '8:79b633d345dc36d5c68b438189b29dd4', 'addColumn tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-tc-import-ar-fk-mariadb::bmsaddek
UPDATE TEST_CASE
        INNER JOIN (SELECT ar.AUTOMATION_REQUEST_ID, ar.TEST_CASE_ID
                    FROM AUTOMATION_REQUEST ar) AS old
        ON TEST_CASE.TCLN_ID = old.TEST_CASE_ID
      SET TEST_CASE.AUTOMATION_REQUEST_ID=old.AUTOMATION_REQUEST_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-tc-import-ar-fk-mariadb', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 16, '8:4d662401e170ff82964e8b26f49a86f3', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-tc-add-columns-indexes::bmsaddek
CREATE INDEX idx_test_case_automation_request_id ON TEST_CASE(AUTOMATION_REQUEST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-tc-add-columns-indexes', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 17, '8:05a38a10abfc634c2a9ac197cd2efc10', 'createIndex indexName=idx_test_case_automation_request_id, tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-automation-request-drop-column::bmsaddek
ALTER TABLE AUTOMATION_REQUEST DROP FOREIGN KEY fk_automation_request_test_case;

ALTER TABLE AUTOMATION_REQUEST DROP COLUMN TEST_CASE_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-automation-request-drop-column', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 18, '8:64c56c847b133ec34241efc1e34234a8', 'dropForeignKeyConstraint baseTableName=AUTOMATION_REQUEST, constraintName=fk_automation_request_test_case; dropColumn columnName=TEST_CASE_ID, tableName=AUTOMATION_REQUEST', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-group-table::jprioux
--  Create the sprint group table
CREATE TABLE SPRINT_GROUP (CLN_ID BIGINT NOT NULL COMMENT 'Shared key with CAMPAIGN_LIBRARY_NODE table', CONSTRAINT pk_sprint_group PRIMARY KEY (CLN_ID), CONSTRAINT fk_sprint_group_campaign_library_node FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-group-table', 'jprioux', '../tm/tm.changelog-7.0.0.xml', NOW(), 19, '8:fb4b09576cc2cdef18f619b0053c946e', 'createTable tableName=SPRINT_GROUP', 'Create the sprint group table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-expand_cln_relationship_ancestor_fk::jprioux
--  Expand ANCESTOR_ID from cln_relationship to include campaign library node, not only folder
ALTER TABLE CLN_RELATIONSHIP DROP FOREIGN KEY fk_cln_relationship_ancestor;

DROP INDEX dx_cln_relationship_ancestor ON CLN_RELATIONSHIP;

ALTER TABLE CLN_RELATIONSHIP ADD CONSTRAINT fk_cln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES CAMPAIGN_LIBRARY_NODE (CLN_ID);

CREATE INDEX idx_fk_cln_relationship_ancestor ON CLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-expand_cln_relationship_ancestor_fk', 'jprioux', '../tm/tm.changelog-7.0.0.xml', NOW(), 20, '8:a3838d3d4e3a8e1fb286740c4e800049', 'dropForeignKeyConstraint baseTableName=CLN_RELATIONSHIP, constraintName=fk_cln_relationship_ancestor; dropIndex indexName=dx_cln_relationship_ancestor, tableName=CLN_RELATIONSHIP; addForeignKeyConstraint baseTableName=CLN_RELATIONSHIP, constraintN...', 'Expand ANCESTOR_ID from cln_relationship to include campaign library node, not only folder', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-replace-invalid-br-tags::pckerneis
--  Replace invalid br tags in test case description
UPDATE EXECUTION_STEP SET ACTION = REPLACE(ACTION, '</br>', '<br>');

UPDATE EXECUTION SET PREREQUISITE = REPLACE(PREREQUISITE, '</br>', '<br>');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-replace-invalid-br-tags', 'pckerneis', '../tm/tm.changelog-7.0.0.xml', NOW(), 21, '8:aebb68aba075b09e4c850463b32407d7', 'sql', 'Replace invalid br tags in test case description', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-bugtracker-project-binding::bmsaddek
ALTER TABLE BUGTRACKER_PROJECT ADD PROJECT_ID BIGINT NULL;

ALTER TABLE BUGTRACKER_PROJECT ADD CONSTRAINT fk_bugtracker_project_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

ALTER TABLE PROJECT ADD BUGTRACKER_ID BIGINT DEFAULT null NULL;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_bugtracker_id FOREIGN KEY (BUGTRACKER_ID) REFERENCES BUGTRACKER (BUGTRACKER_ID);

CREATE INDEX idx_fk_bugtracker_project_project_id ON BUGTRACKER_PROJECT(PROJECT_ID);

CREATE INDEX idx_fk_project_bugtracker_id ON PROJECT(BUGTRACKER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-binding', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 22, '8:18cfd43a240330ad96073c3a5ae96319', 'addColumn tableName=BUGTRACKER_PROJECT; addColumn tableName=PROJECT; createIndex indexName=idx_fk_bugtracker_project_project_id, tableName=BUGTRACKER_PROJECT; createIndex indexName=idx_fk_project_bugtracker_id, tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-bugtracker-project-import-fk-mariadb::bmsaddek
UPDATE BUGTRACKER_PROJECT
      JOIN BUGTRACKER_BINDING ON BUGTRACKER_PROJECT.BUGTRACKER_BINDING_ID = BUGTRACKER_BINDING.BUGTRACKER_BINDING_ID
      SET BUGTRACKER_PROJECT.PROJECT_ID = BUGTRACKER_BINDING.PROJECT_ID;

UPDATE PROJECT
        JOIN BUGTRACKER_BINDING ON PROJECT.PROJECT_ID = BUGTRACKER_BINDING.PROJECT_ID
      SET PROJECT.BUGTRACKER_ID = BUGTRACKER_BINDING.BUGTRACKER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-import-fk-mariadb', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 23, '8:93c01b1fe4c597680e42c9c25e69f4ab', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-bugtracker-project-drop-table::bmsaddek
ALTER TABLE BUGTRACKER_PROJECT DROP FOREIGN KEY fk_bugtracker_project_bugtracker_binding;

ALTER TABLE BUGTRACKER_PROJECT DROP COLUMN BUGTRACKER_BINDING_ID;

DROP TABLE BUGTRACKER_BINDING;

ALTER TABLE BUGTRACKER_PROJECT MODIFY PROJECT_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-drop-table', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 24, '8:54b76e597930c56c35c72c1a8f78384a', 'dropForeignKeyConstraint baseTableName=BUGTRACKER_PROJECT, constraintName=fk_bugtracker_project_bugtracker_binding; dropColumn columnName=BUGTRACKER_BINDING_ID, tableName=BUGTRACKER_PROJECT; dropTable tableName=BUGTRACKER_BINDING; addNotNullConstr...', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-1558-add-playwright-automated_test_technologies::xzhao-meinman
--  Add automated test technology Playwright
INSERT INTO AUTOMATED_TEST_TECHNOLOGY (NAME, ACTION_PROVIDER_KEY, PREMIUM)
      SELECT 'Playwright', 'playwright/execute@v1', false
      WHERE NOT EXISTS (
        SELECT 1
        FROM AUTOMATED_TEST_TECHNOLOGY
        WHERE NAME = 'Playwright'
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-1558-add-playwright-automated_test_technologies', 'xzhao-meinman', '../tm/tm.changelog-7.0.0.xml', NOW(), 25, '8:e80a70004244bf60542d2d151dd65f72', 'sql', 'Add automated test technology Playwright', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-squash-1647-add-auditables-and-description-to-third-party-server-mariadb::jpmarque
--  Add auditables and description to THIRD_PARTY_SERVER, copy data from TEST_AUTOMATION_SERVER, remove columns from TEST_AUTOMATION_SERVER
ALTER TABLE THIRD_PARTY_SERVER
        ADD COLUMN IF NOT EXISTS CREATED_BY VARCHAR(100),
        ADD COLUMN IF NOT EXISTS CREATED_ON DATETIME,
        ADD COLUMN IF NOT EXISTS LAST_MODIFIED_BY VARCHAR(100) DEFAULT NULL,
        ADD COLUMN IF NOT EXISTS LAST_MODIFIED_ON DATETIME DEFAULT NULL,
        ADD COLUMN IF NOT EXISTS DESCRIPTION LONGTEXT DEFAULT '';

UPDATE THIRD_PARTY_SERVER tps
        JOIN TEST_AUTOMATION_SERVER tas ON tas.SERVER_ID = tps.SERVER_ID
        SET tps.CREATED_BY = tas.CREATED_BY,
          tps.CREATED_ON = tas.CREATED_ON,
          tps.LAST_MODIFIED_BY = tas.LAST_MODIFIED_BY,
          tps.LAST_MODIFIED_ON = tas.LAST_MODIFIED_ON,
          tps.DESCRIPTION = tas.DESCRIPTION;

ALTER TABLE TEST_AUTOMATION_SERVER
        DROP COLUMN IF EXISTS CREATED_BY,
        DROP COLUMN IF EXISTS CREATED_ON,
        DROP COLUMN IF EXISTS LAST_MODIFIED_BY,
        DROP COLUMN IF EXISTS LAST_MODIFIED_ON,
        DROP COLUMN IF EXISTS DESCRIPTION;

UPDATE THIRD_PARTY_SERVER
      SET CREATED_BY = 'Upgrade Squash 7.0',
          CREATED_ON = NOW()
      WHERE CREATED_BY is NULL;

ALTER TABLE THIRD_PARTY_SERVER MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE THIRD_PARTY_SERVER MODIFY CREATED_ON DATETIME NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-squash-1647-add-auditables-and-description-to-third-party-server-mariadb', 'jpmarque', '../tm/tm.changelog-7.0.0.xml', NOW(), 26, '8:77279900390dce2b9e959d5c66b07af7', 'sql', 'Add auditables and description to THIRD_PARTY_SERVER, copy data from TEST_AUTOMATION_SERVER, remove columns from TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, NULL, '4.19.0', '7869447121');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

