--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-6.0.0.xml
--  Ran at: 08/01/2026 11:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-d19jc3z5 (100.64.14.156)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0::lmurat
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '6.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0', 'lmurat', '../tm/tm.changelog-6.0.0.xml', NOW(), 1, '8:58f17ae7fc8eee68e0b45d9a115f3784', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table::lmurat
--  Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY
DELETE FROM CORE_PARTY_AUTHORITY
    WHERE AUTHORITY = 'ROLE_TM_USER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table', 'lmurat', '../tm/tm.changelog-6.0.0.xml', NOW(), 2, '8:e9c6db4305989db996f20fbc3f141c15', 'sql', 'Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-SQUASH-6284-login-up-to-100-characters::mbrugniere
--  Update login maxlength for all tables concerned (from 50 to 100)
ALTER TABLE ACTION_WORD MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE ACTION_WORD MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ACTION_WORD MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE AUTH_USER MODIFY LOGIN VARCHAR(100);

ALTER TABLE AUTH_USER MODIFY LOGIN VARCHAR(100) NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CHART_DEFINITION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CHART_DEFINITION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CHART_DEFINITION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CONNECTION_ATTEMPT_LOG MODIFY LOGIN VARCHAR(100);

ALTER TABLE CORE_TEAM MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CORE_TEAM MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CORE_TEAM MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CORE_USER MODIFY LOGIN VARCHAR(100);

ALTER TABLE CORE_USER MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CORE_USER MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CORE_USER MODIFY LOGIN VARCHAR(100) NOT NULL;

ALTER TABLE CORE_USER MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE EXECUTION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE EXECUTION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE EXECUTION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE EXECUTION_STEP MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE EXECUTION_STEP MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE EXECUTION_STEP MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE INFO_LIST MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE INFO_LIST MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE INFO_LIST MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ITERATION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE ITERATION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE ITERATION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE MILESTONE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE MILESTONE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE MILESTONE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE PROJECT MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE PROJECT MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE PROJECT MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE REPORT_DEFINITION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE REPORT_DEFINITION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE REPORT_DEFINITION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER MODIFY LAST_SYNCHRONIZED_BY VARCHAR(100);

ALTER TABLE `RESOURCE` MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE `RESOURCE` MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE `RESOURCE` MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE TEST_AUTOMATION_SERVER MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE TEST_AUTOMATION_SERVER MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE TEST_AUTOMATION_SERVER ALTER CREATED_BY SET DEFAULT '(nobody)';

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE TEST_SUITE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE TEST_SUITE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE TEST_SUITE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-SQUASH-6284-login-up-to-100-characters', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 3, '8:aa6203fbbef514e97eabeed812f50af1', 'modifyDataType columnName=CREATED_BY, tableName=ACTION_WORD; addNotNullConstraint columnName=CREATED_BY, tableName=ACTION_WORD; modifyDataType columnName=LAST_MODIFIED_BY, tableName=ACTION_WORD; modifyDataType columnName=LOGIN, tableName=AUTH_USER...', 'Update login maxlength for all tables concerned (from 50 to 100)', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-test-case::pckerneis
--  Create the exploratory test case table
CREATE TABLE EXPLORATORY_TEST_CASE (TCLN_ID BIGINT NOT NULL COMMENT 'primary key shared with TEST_CASE', CHARTER LONGTEXT DEFAULT null NULL COMMENT 'the charter for an exploratory test_case', SESSION_DURATION INT DEFAULT null NULL COMMENT 'the test session planned duration in minutes', CONSTRAINT pk_exploratory_test_case PRIMARY KEY (TCLN_ID), CONSTRAINT fk_exploratory_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-test-case', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 4, '8:d6da1d9d969d794b17ee935215a2fe51', 'createTable tableName=EXPLORATORY_TEST_CASE', 'Create the exploratory test case table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-execution::pckerneis
--  Create the exploratory execution table
CREATE TABLE EXPLORATORY_EXECUTION (EXECUTION_ID BIGINT NOT NULL COMMENT 'primary key shared with EXECUTION', ASSIGNEE_ID BIGINT DEFAULT null NULL, TASK_DIVISION VARCHAR(255) DEFAULT null NULL, REVIEWED BIT(1) DEFAULT 0 NOT NULL, CONSTRAINT pk_exploratory_execution PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_exploratory_execution_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_exploratory_execution_core_user FOREIGN KEY (ASSIGNEE_ID) REFERENCES CORE_USER(PARTY_ID));

CREATE INDEX idx_fk_exploratory_execution_assignee ON EXPLORATORY_EXECUTION(ASSIGNEE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-execution', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 5, '8:2fdd0cc5a94cb40c2062cc8582d3af5c', 'createTable tableName=EXPLORATORY_EXECUTION; createIndex indexName=idx_fk_exploratory_execution_assignee, tableName=EXPLORATORY_EXECUTION', 'Create the exploratory execution table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-session-note-for-exploratory-execution::mbrugniere
--  Create the session note table
CREATE TABLE SESSION_NOTE (NOTE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for SESSION_NOTE', EXECUTION_ID BIGINT NOT NULL COMMENT 'foreign key to EXECUTION', KIND VARCHAR(30) DEFAULT 'COMMENT' NOT NULL, CONTENT LONGTEXT DEFAULT '' NOT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to attachment list', ISSUE_LIST_ID BIGINT NULL COMMENT 'Foreign key to issue list', NOTE_ORDER INT NULL COMMENT 'Order in the note list', CONSTRAINT pk_session_note PRIMARY KEY (NOTE_ID), CONSTRAINT fk_session_note_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_session_note_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_session_note_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID));

CREATE INDEX idx_fk_session_note_execution ON SESSION_NOTE(EXECUTION_ID);

CREATE INDEX idx_fk_session_note_issue_list_id ON SESSION_NOTE(ISSUE_LIST_ID);

CREATE INDEX idx_session_note_created_by ON SESSION_NOTE(CREATED_BY);

CREATE INDEX idx_session_note_last_modified_by ON SESSION_NOTE(LAST_MODIFIED_BY);

CREATE INDEX idx_fk_session_note_attachment_list ON SESSION_NOTE(ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-session-note-for-exploratory-execution', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 6, '8:5d4e3cbd2cd18de34195e9c16bc613b3', 'createTable tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_execution, tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_issue_list_id, tableName=SESSION_NOTE; createIndex indexName=idx_session_note_created_by, ta...', 'Create the session note table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference::dclaerhout
--  Increase max size for automated test reference in test case table
ALTER TABLE TEST_CASE MODIFY AUTOMATED_TEST_REFERENCE VARCHAR(512);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference', 'dclaerhout', '../tm/tm.changelog-6.0.0.xml', NOW(), 7, '8:a21dc7000c7d5844f60f7b8095bc3bfd', 'modifyDataType columnName=AUTOMATED_TEST_REFERENCE, tableName=TEST_CASE', 'Increase max size for automated test reference in test case table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server::fahadi
--  Add additional configuration to the test automation server
ALTER TABLE TEST_AUTOMATION_SERVER ADD ADDITIONAL_CONFIGURATION LONGTEXT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server', 'fahadi', '../tm/tm.changelog-6.0.0.xml', NOW(), 8, '8:ae13402136cbb1b79a45e90dec8a42b0', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add additional configuration to the test automation server', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-update-execution_issues_closure::mbrugniere
--  Consider session notes to get all known issues for an execution
DROP VIEW EXECUTION_ISSUES_CLOSURE;

CREATE VIEW EXECUTION_ISSUES_CLOSURE AS select exec.execution_id, issue.issue_id
      from EXECUTION exec
         inner join ISSUE issue on exec.issue_list_id = issue.issue_list_id
      UNION
      select eesteps.execution_id, issue.issue_id
      from EXECUTION_EXECUTION_STEPS eesteps
             inner join EXECUTION_STEP estep on eesteps.execution_step_id = estep.execution_step_id
             inner join ISSUE issue on estep.issue_list_id = issue.issue_list_id
      UNION
      select sn.execution_id, ISSUE.issue_id
      from SESSION_NOTE sn
             inner join ISSUE on ISSUE.issue_list_id = sn.issue_list_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-update-execution_issues_closure', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 9, '8:63142af44781509e4550973a244cc317', 'dropView viewName=EXECUTION_ISSUES_CLOSURE; createView viewName=EXECUTION_ISSUES_CLOSURE', 'Consider session notes to get all known issues for an execution', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-grid-column-display-reference-table::jmarque
--  Create the grid reference table
CREATE TABLE GRID_COLUMN_DISPLAY_REFERENCE (GCDR_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for GRID_COLUMN_DISPLAY_REFERENCE', PARTY_ID BIGINT NOT NULL COMMENT 'foreign key to CORE_USER', GRID_ID VARCHAR(100) NOT NULL, PROJECT_ID BIGINT NULL COMMENT 'foreign key to PROJECT', CONSTRAINT pk_grid_column_display_reference PRIMARY KEY (GCDR_ID), CONSTRAINT fk_grid_column_display_reference_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_grid_column_display_reference_core_user FOREIGN KEY (PARTY_ID) REFERENCES CORE_USER(PARTY_ID));

CREATE INDEX idx_fk_grid_column_display_reference_party_id ON GRID_COLUMN_DISPLAY_REFERENCE(PARTY_ID);

CREATE INDEX idx_fk_grid_column_display_reference_project_id ON GRID_COLUMN_DISPLAY_REFERENCE(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-grid-column-display-reference-table', 'jmarque', '../tm/tm.changelog-6.0.0.xml', NOW(), 10, '8:e47ff361f4ee9d8fd94b75322b9692ba', 'createTable tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_party_id, tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_project_id, tableName=GRI...', 'Create the grid reference table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-grid-column-display-configuration-table::jmarque
--  Create the grid configuration table
CREATE TABLE GRID_COLUMN_DISPLAY_CONFIGURATION (GCDC_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for GRID_COLUMN_DISPLAY_CONFIGURATION', GCDR_ID BIGINT NOT NULL COMMENT 'foreign key to GRID_COLUMN_DISPLAY_REFERENCE', ACTIVE_COLUMN_ID VARCHAR(100) NOT NULL, CONSTRAINT pk_grid_column_display_configuration PRIMARY KEY (GCDC_ID), CONSTRAINT fk_grid_col_display_config_grid_col_display_ref FOREIGN KEY (GCDR_ID) REFERENCES GRID_COLUMN_DISPLAY_REFERENCE(GCDR_ID));

CREATE INDEX idx_fk_grid_column_display_configuration_gcdr_id ON GRID_COLUMN_DISPLAY_CONFIGURATION(GCDR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-grid-column-display-configuration-table', 'jmarque', '../tm/tm.changelog-6.0.0.xml', NOW(), 11, '8:e95b4bb90b311b5f84648616241b6e5d', 'createTable tableName=GRID_COLUMN_DISPLAY_CONFIGURATION; createIndex indexName=idx_fk_grid_column_display_configuration_gcdr_id, tableName=GRID_COLUMN_DISPLAY_CONFIGURATION', 'Create the grid configuration table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-execution-event-table::pckerneis
--  Create the exploratory session event table
CREATE TABLE EXPLORATORY_EXECUTION_EVENT (EVENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for EXPLORATORY_EXECUTION_EVENT', EXECUTION_ID BIGINT NOT NULL COMMENT 'foreign key to EXECUTION', EVENT_DATE datetime(3) NOT NULL, AUTHOR VARCHAR(100) NOT NULL, EVENT_TYPE VARCHAR(30) NOT NULL, CONSTRAINT pk_exploratory_execution_event PRIMARY KEY (EVENT_ID), CONSTRAINT fk_exploratory_execution_event_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID));

ALTER TABLE EXPLORATORY_EXECUTION_EVENT ADD CONSTRAINT uc_exploratory_execution_event_execution_id_event_date UNIQUE (EXECUTION_ID, EVENT_DATE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-execution-event-table', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 12, '8:3244ed07a4fbf493862937af300edcf9', 'createTable tableName=EXPLORATORY_EXECUTION_EVENT; addUniqueConstraint constraintName=uc_exploratory_execution_event_execution_id_event_date, tableName=EXPLORATORY_EXECUTION_EVENT', 'Create the exploratory session event table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-dataset-parameter-order::pckerneis
--  add an order to parameters
ALTER TABLE PARAMETER ADD PARAM_ORDER INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-dataset-parameter-order', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 13, '8:4009792036fb3f54151827a230cca8cf', 'addColumn tableName=PARAMETER', 'add an order to parameters', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-dataset-parameter-order-generation::pckerneis
UPDATE PARAMETER P1
      SET PARAM_ORDER = (
        SELECT SUBQUERY.COMPUTED_ORDER - 1
        FROM (
               SELECT P2.PARAM_ID as ID2,
                      ROW_NUMBER() over (PARTITION BY TEST_CASE_ID ORDER BY PARAM_ID) as COMPUTED_ORDER
               FROM PARAMETER P2) SUBQUERY
        WHERE SUBQUERY.ID2 = P1.PARAM_ID
      );

ALTER TABLE PARAMETER MODIFY PARAM_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-dataset-parameter-order-generation', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 14, '8:d4ce63dae76f992f49574be99c6bdcd7', 'sql; addNotNullConstraint columnName=PARAM_ORDER, tableName=PARAMETER', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-exploratory-session-overview::mbrugniere
--  Create the exploratory session overview table
CREATE TABLE EXPLORATORY_SESSION_OVERVIEW (OVERVIEW_ID BIGINT AUTO_INCREMENT NOT NULL, ITEM_TEST_PLAN_ID BIGINT NOT NULL COMMENT 'foreign key to ITERATION_TEST_PLAN_ITEM', CHARTER LONGTEXT DEFAULT null NULL COMMENT 'the charter for an exploratory session overview', SESSION_DURATION INT DEFAULT null NULL COMMENT 'the test session planned duration in minutes', NAME VARCHAR(255) NOT NULL, `REFERENCE` VARCHAR(50) DEFAULT '' NOT NULL, DUE_DATE datetime DEFAULT null NULL, SESSION_STATUS VARCHAR(50) DEFAULT 'TO_DO' NOT NULL, COMMENTS LONGTEXT DEFAULT null NULL, ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to attachment list', CONSTRAINT pk_exploratory_session_overview PRIMARY KEY (OVERVIEW_ID), CONSTRAINT fk_exploratory_session_overview_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_exploratory_session_overview FOREIGN KEY (ITEM_TEST_PLAN_ID) REFERENCES ITERATION_TEST_PLAN_ITEM(ITEM_TEST_PLAN_ID));

CREATE INDEX idx_fk_exploratory_session_overview_itpi ON EXPLORATORY_SESSION_OVERVIEW(ITEM_TEST_PLAN_ID);

CREATE INDEX idx_fk_exploratory_session_overview_attachment_list ON EXPLORATORY_SESSION_OVERVIEW(ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-exploratory-session-overview', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 15, '8:ee55c8c1aa5423a03523dc4b5f506522', 'createTable tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_itpi, tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_attachment_list, tableName=EXPLOR...', 'Create the exploratory session overview table', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-squash-remove-resultpublisher-plugin-binding::bms
DELETE FROM LIBRARY_PLUGIN_BINDING_PROPERTY
      WHERE PLUGIN_BINDING_ID IN (
        SELECT PLUGIN_BINDING_ID
        FROM LIBRARY_PLUGIN_BINDING WHERE PLUGIN_ID = 'squash.tm.plugin.resultpublisher'
      );

DELETE FROM LIBRARY_PLUGIN_BINDING WHERE PLUGIN_ID = 'squash.tm.plugin.resultpublisher';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-squash-remove-resultpublisher-plugin-binding', 'bms', '../tm/tm.changelog-6.0.0.xml', NOW(), 16, '8:0b1332faad6e21410756b12d60f8ff92', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-667-rename-squashautom-ta-server-kind::jprioux
UPDATE TEST_AUTOMATION_SERVER SET KIND = 'squashOrchestrator' WHERE KIND = 'squashAutom';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-667-rename-squashautom-ta-server-kind', 'jprioux', '../tm/tm.changelog-6.0.0.xml', NOW(), 17, '8:a0980811d3c54a8db982dc315e878f94', 'update tableName=TEST_AUTOMATION_SERVER', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869447053');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

