--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: global.changelog-master.xml
--  Ran at: 08/01/2026 11:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Create Database Lock Table
CREATE TABLE DATABASECHANGELOGLOCK (ID INT NOT NULL, `LOCKED` BIT(1) NOT NULL, LOCKGRANTED datetime NULL, LOCKEDBY VARCHAR(255) NULL, CONSTRAINT PK_DATABASECHANGELOGLOCK PRIMARY KEY (ID)) ENGINE = INNODB;

--  Initialize Database Lock Table
DELETE FROM DATABASECHANGELOGLOCK;

INSERT INTO DATABASECHANGELOGLOCK (ID, `LOCKED`) VALUES (1, 0);

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-d19jc3z5 (100.64.14.156)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Create Database Change Log Table
CREATE TABLE DATABASECHANGELOG (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED datetime NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35) NULL, `DESCRIPTION` VARCHAR(255) NULL, COMMENTS VARCHAR(255) NULL, TAG VARCHAR(255) NULL, LIQUIBASE VARCHAR(20) NULL, CONTEXTS VARCHAR(255) NULL, LABELS VARCHAR(255) NULL, DEPLOYMENT_ID VARCHAR(10) NULL) ENGINE = INNODB;

--  Changeset auth/auth.changelog-1.0.xml::1::gfouquet
CREATE TABLE AUTH_USER (LOGIN VARCHAR(50) NOT NULL COMMENT 'The user''s unique identifier', PASSWORD CHAR(40) NOT NULL COMMENT 'SHA-1 hash of the user''s password', ACTIVE BIT(1) DEFAULT 1 NOT NULL, CONSTRAINT PK_AUTH_USER PRIMARY KEY (LOGIN)) COMMENT='Stores users credentials' ENGINE = INNODB;

CREATE UNIQUE INDEX IDX_AUTHENTICATION ON AUTH_USER(LOGIN);

INSERT INTO AUTH_USER (LOGIN, PASSWORD, ACTIVE) VALUES ('admin', 'd033e22ae348aeb5660fc2140aec35850c4da997', 1);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'gfouquet', 'auth/auth.changelog-1.0.xml', NOW(), 1, '8:3d9ef6ff908a32ab0bbf37a6a87b4998', 'createTable tableName=AUTH_USER; createIndex indexName=IDX_AUTHENTICATION, tableName=AUTH_USER; insert tableName=AUTH_USER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::1::gfouquet
CREATE TABLE CORE_USER (ID BIGINT AUTO_INCREMENT NOT NULL, LOGIN VARCHAR(50) NOT NULL COMMENT 'The user''s login as provided by the authentication system', FIRST_NAME VARCHAR(50) DEFAULT '' NOT NULL COMMENT 'The user''s first name', LAST_NAME VARCHAR(50) DEFAULT '' NOT NULL COMMENT 'The user''s last name', EMAIL VARCHAR(50) DEFAULT '' NOT NULL COMMENT 'The user''s e-mail', ACTIVE BIT(1) DEFAULT 0 NOT NULL COMMENT 'User is active or not', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du createur de cet utilisateur.', CREATED_ON datetime NOT NULL COMMENT 'Date de creation de cet utilisateur. Il s''agit de la date de creation de l''entree dans       la base, non d''une date metier.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere mise a jour de cette instance.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis a jour cet instance.', CONSTRAINT PK_CORE_USER PRIMARY KEY (ID), CONSTRAINT CT_UNIQUE_USER_LOGIN UNIQUE (LOGIN)) ENGINE = INNODB;

CREATE UNIQUE INDEX DX_USER_LOGIN ON CORE_USER(LOGIN);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 2, '8:055dd90ad38219f8193c6a49a1791387', 'createTable tableName=CORE_USER; createIndex indexName=DX_USER_LOGIN, tableName=CORE_USER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::2::gfouquet
CREATE TABLE CORE_GROUP (ID BIGINT AUTO_INCREMENT NOT NULL, QUALIFIED_NAME VARCHAR(255) NOT NULL COMMENT 'Qualified name of the group, both used as a functional key and a localization key. Should be something like ''squashtest.authz.group._app module_._GroupName_''', CONSTRAINT PK_CORE_GROUP PRIMARY KEY (ID), CONSTRAINT CT_UN_GRP_QUAL_NAME UNIQUE (QUALIFIED_NAME)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 3, '8:3524c5f35c59cdac07e97f678410c887', 'createTable tableName=CORE_GROUP', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::3::gfouquet
CREATE TABLE CORE_GROUP_AUTHORITY (GROUP_ID BIGINT NOT NULL COMMENT 'Shared key with CORE_GROUP table', AUTHORITY VARCHAR(50) NOT NULL COMMENT 'The authority', CONSTRAINT FK_GRP_AUTH_GRP FOREIGN KEY (GROUP_ID) REFERENCES CORE_GROUP(ID)) ENGINE = INNODB;

CREATE INDEX DX_GRP_ID ON CORE_GROUP_AUTHORITY(GROUP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 4, '8:37a3be801f407c743188a5c35ddab6fb', 'createTable tableName=CORE_GROUP_AUTHORITY; createIndex indexName=DX_GRP_ID, tableName=CORE_GROUP_AUTHORITY', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::4::gfouquet
CREATE TABLE CORE_GROUP_MEMBER (USER_ID BIGINT NOT NULL, GROUP_ID BIGINT NOT NULL, CONSTRAINT FK_GRP_MEMBER_GRP FOREIGN KEY (GROUP_ID) REFERENCES CORE_GROUP(ID), CONSTRAINT FK_GRP_MEMBER_USR FOREIGN KEY (USER_ID) REFERENCES CORE_USER(ID)) ENGINE = INNODB;

CREATE UNIQUE INDEX DX_GRP_MEMBER ON CORE_GROUP_MEMBER(USER_ID, GROUP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 5, '8:8ed24313055b9c1061e6598f1ecfb40d', 'createTable tableName=CORE_GROUP_MEMBER; createIndex indexName=DX_GRP_MEMBER, tableName=CORE_GROUP_MEMBER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::5::gfouquet
INSERT INTO CORE_GROUP (QUALIFIED_NAME) VALUES ('squashtest.authz.group.core.Admin');

INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select max(ID) from CORE_GROUP), 'ROLE_ADMIN');

INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select max(ID) from CORE_GROUP), 'ROLE_USER');

INSERT INTO CORE_USER (LOGIN, LAST_NAME, EMAIL, CREATED_ON, CREATED_BY) VALUES ('admin', 'Squash Administrator', 'admin@squashtest.org', NOW(), 'liquibase');

INSERT INTO CORE_GROUP_MEMBER (USER_ID, GROUP_ID) VALUES ((select max(ID) from CORE_USER), (select max(ID) from CORE_GROUP));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 6, '8:498253d8a7b4423f27ab556d6b567e1d', 'insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_USER; insert tableName=CORE_GROUP_MEMBER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::7::gfouquet
CREATE TABLE ACL_CLASS (ID BIGINT AUTO_INCREMENT NOT NULL, CLASSNAME VARCHAR(255) NOT NULL COMMENT 'Fully qualified classname', CONSTRAINT PK_ACL_CLASS PRIMARY KEY (ID), CONSTRAINT CT_UN_CLASSNAME UNIQUE (CLASSNAME)) ENGINE = INNODB;

CREATE UNIQUE INDEX DX_CLASS_NAME ON ACL_CLASS(CLASSNAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 7, '8:17b7a3610b14cac414514bd80adfbe60', 'createTable tableName=ACL_CLASS; createIndex indexName=DX_CLASS_NAME, tableName=ACL_CLASS', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::8::gfouquet
CREATE TABLE ACL_OBJECT_IDENTITY (ID BIGINT AUTO_INCREMENT NOT NULL, IDENTITY BIGINT NOT NULL COMMENT 'The id of the target entity', CLASS_ID BIGINT NOT NULL, CONSTRAINT PK_ACL_OBJECT_ID PRIMARY KEY (ID), CONSTRAINT FK_ACL_OBJ_ID_ACL_CLASS FOREIGN KEY (CLASS_ID) REFERENCES ACL_CLASS(ID)) ENGINE = INNODB;

ALTER TABLE ACL_OBJECT_IDENTITY ADD UNIQUE (IDENTITY, CLASS_ID);

CREATE INDEX DX_OBJ_ID_IDENTITY ON ACL_OBJECT_IDENTITY(IDENTITY);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 8, '8:6430e03210e17fc411d599f1c44ed253', 'createTable tableName=ACL_OBJECT_IDENTITY; addUniqueConstraint tableName=ACL_OBJECT_IDENTITY; createIndex indexName=DX_OBJ_ID_IDENTITY, tableName=ACL_OBJECT_IDENTITY', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::9::gfouquet
CREATE TABLE ACL_GROUP (ID BIGINT AUTO_INCREMENT NOT NULL, QUALIFIED_NAME VARCHAR(255) NOT NULL COMMENT 'Group''s qualified name, both used as a functional key and a localization key. Should be something like ''squashtest.acl.group._app module_._GroupName_''', CONSTRAINT PK_ACL_GRP PRIMARY KEY (ID), CONSTRAINT CT_UN_ACL_GRP_QUAL_NAME UNIQUE (QUALIFIED_NAME)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 9, '8:484cb95f2ebb0b80cbc9e84a82326b71', 'createTable tableName=ACL_GROUP', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::10::gfouquet
CREATE TABLE ACL_GROUP_PERMISSION (ACL_GROUP_ID BIGINT NOT NULL, PERMISSION_MASK INT DEFAULT 0 NOT NULL COMMENT 'Mask of permissions as defined by spring security', CLASS_ID BIGINT NOT NULL COMMENT 'The class to which the permissions apply', PERMISSION_ORDER INT DEFAULT 0 NOT NULL, GRANTING BIT(1) DEFAULT 1 NOT NULL, CONSTRAINT FK_SC_AUTH_ACL_CLASS FOREIGN KEY (CLASS_ID) REFERENCES ACL_CLASS(ID), CONSTRAINT FK_ACL_GRP_PERMISSION_ACL_GRP FOREIGN KEY (ACL_GROUP_ID) REFERENCES ACL_GROUP(ID)) ENGINE = INNODB;

ALTER TABLE ACL_GROUP_PERMISSION ADD PRIMARY KEY (ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('10', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 10, '8:b20818cdcce60e485ac93f35dff82fa6', 'createTable tableName=ACL_GROUP_PERMISSION; addPrimaryKey constraintName=PK_ACL_GRP_PERMISSION, tableName=ACL_GROUP_PERMISSION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.15.0.xml::11::gfouquet
CREATE TABLE ACL_RESPONSIBILITY_SCOPE_ENTRY (ID BIGINT AUTO_INCREMENT NOT NULL, USER_ID BIGINT NOT NULL, ACL_GROUP_ID BIGINT NOT NULL, OBJECT_IDENTITY_ID BIGINT NOT NULL, CONSTRAINT PK_RESP_SCOPE_ENTRY PRIMARY KEY (ID), CONSTRAINT FK_RESP_SCOPE_USER FOREIGN KEY (USER_ID) REFERENCES CORE_USER(ID), CONSTRAINT FK_RESP_SCOPE_OBJ_ID FOREIGN KEY (OBJECT_IDENTITY_ID) REFERENCES ACL_OBJECT_IDENTITY(ID), CONSTRAINT FK_RESP_SCOPE_ACL_GRP FOREIGN KEY (ACL_GROUP_ID) REFERENCES ACL_GROUP(ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('11', 'gfouquet', 'core/core.changelog-0.15.0.xml', NOW(), 11, '8:72cc4523a501dbbe41a564861b9f781d', 'createTable tableName=ACL_RESPONSIBILITY_SCOPE_ENTRY', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.20.0.xml::core-0.20.0.01::ramoussou
--  Creation of a new table CORE_CONFIG containing Application configuration
CREATE TABLE CORE_CONFIG (STR_KEY VARCHAR(255) NOT NULL COMMENT 'Configuration Key', VALUE TEXT NULL COMMENT 'Configuration value', CONSTRAINT PK_CORE_CONFIG PRIMARY KEY (STR_KEY)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-0.20.0.01', 'ramoussou', 'core/core.changelog-0.20.0.xml', NOW(), 12, '8:2cd6847655e834de27ab193dd6dce68e', 'createTable tableName=CORE_CONFIG', 'Creation of a new table CORE_CONFIG containing Application configuration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-0.20.0.xml::core-0.20.0.02::gfouquet
--  Default welcome message
insert into CORE_CONFIG (STR_KEY, VALUE) values ('WELCOME_MESSAGE', '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the upper right corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-0.20.0.02', 'gfouquet', 'core/core.changelog-0.20.0.xml', NOW(), 13, '8:ef79d86b09bba9709eec0c58596b246a', 'sql', 'Default welcome message', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-1.1.1.xml::core-1.1.1.RELEASE.01::mpagnon
--  Add new line in CORE_CONFIG for LOGIN_MESSAGE
insert into CORE_CONFIG (STR_KEY, VALUE) select 'LOGIN_MESSAGE', VALUE from CORE_CONFIG where STR_KEY = 'WELCOME_MESSAGE';

update CORE_CONFIG set VALUE = '1.1.1' where STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-1.1.1.RELEASE.01', 'mpagnon', 'core/core.changelog-1.1.1.xml', NOW(), 14, '8:e3ba4fe0cda3717bd05b71f091b7e4ec', 'sql', 'Add new line in CORE_CONFIG for LOGIN_MESSAGE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset core/core.changelog-1.4.0.xml::core-feat-327::mpagnon
--  Because admin was not active , need to make sure that all user active in auth_user are active in core_user
update CORE_USER
					set ACTIVE = true
					where CORE_USER.LOGIN in (select AUTH_USER.LOGIN from AUTH_USER where AUTH_USER.ACTIVE = true);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-feat-327', 'mpagnon', 'core/core.changelog-1.4.0.xml', NOW(), 15, '8:323c895a060d7f87a79287ea2c7d1489', 'sql', 'Because admin was not active , need to make sure that all user active in auth_user are active in core_user', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.01::bsiri
--  This table maintains the mapping between an issue in Squash and an
--  			issue in the remote bugtracker
CREATE TABLE ISSUE (ISSUE_ID BIGINT AUTO_INCREMENT NOT NULL, REMOTE_ISSUE_ID VARCHAR(255) NOT NULL COMMENT 'considering the different types    a bugtracker may use for its own primary keys, we use here a varchar type as it is generic enough', CONSTRAINT PK_ISSUE PRIMARY KEY (ISSUE_ID)) ENGINE = INNODB;

CREATE INDEX idx_issue ON ISSUE(ISSUE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.01', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 16, '8:5d3b93c579ca3e2716f45d1e1860fb7f', 'createTable tableName=ISSUE; createIndex indexName=idx_issue, tableName=ISSUE', 'This table maintains the mapping between an issue in Squash and an
			issue in the remote bugtracker', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.02::bsiri
--  each Squash entity that may be attached to one or several bugs will be given an issue list. This table will maintain that list, an entry means that some entity refering to it have several.
CREATE TABLE ISSUE_LIST (ISSUE_LIST_ID BIGINT AUTO_INCREMENT NOT NULL, CONSTRAINT PK_ISSUE_LIST PRIMARY KEY (ISSUE_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_issue_list ON ISSUE_LIST(ISSUE_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.02', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 17, '8:3ab8c4e40f4a554ed9bb8aec931e9f8e', 'createTable tableName=ISSUE_LIST; createIndex indexName=idx_issue_list, tableName=ISSUE_LIST', 'each Squash entity that may be attached to one or several bugs will be given an issue list. This table will maintain that list, an entry means that some entity refering to it have several.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.03::bsiri
--  This table will map one issue_list to (0,several) issues
CREATE TABLE ISSUE_LIST_CONTENT (ISSUE_LIST_ID BIGINT NOT NULL COMMENT 'fk to the issue list', ISSUE_ID BIGINT NOT NULL COMMENT 'fk to an issue', CONSTRAINT fk_list_issue_issue FOREIGN KEY (ISSUE_ID) REFERENCES ISSUE(ISSUE_ID), CONSTRAINT fk_list_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.03', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 18, '8:2020ecc2a7f9697b1bcbcdc950764a11', 'createTable tableName=ISSUE_LIST_CONTENT', 'This table will map one issue_list to (0,several) issues', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.04::bsiri
--  Cette table contient le contenu d'une pièce jointe, dont les meta infos sont stockees dans la
--  			table ATTACHMENT. La relation entre les deux tables est 1-1
CREATE TABLE ATTACHMENT_CONTENT (ATTACHMENT_CONTENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire du contenu de la piece jointe. Devrait être autogénérée.', STREAM_CONTENT BLOB DEFAULT 'NULL' NULL COMMENT 'Le contenu de la piece jointe.', CONSTRAINT PK_ATTACHMENT_CONTENT PRIMARY KEY (ATTACHMENT_CONTENT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.04', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 19, '8:7d216543a6e43252c9d9a6c7f39f4b2b', 'createTable tableName=ATTACHMENT_CONTENT', 'Cette table contient le contenu d''une pièce jointe, dont les meta infos sont stockees dans la
			table ATTACHMENT. La relation entre les deux tables est 1-1', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.05::bsiri
--  Cette table stockera les pieces jointes. La piece elle même est un blob stocke a part dans
--  					la table ATTACHMENT_CONTENT. La relation entre les deux tables est 1-1
CREATE TABLE ATTACHMENT (ATTACHMENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire de la piece jointe. Devrait être autogénérée.', NAME VARCHAR(255) NOT NULL COMMENT 'nom de la piece jointe', TYPE VARCHAR(10) NOT NULL COMMENT 'type de la piece jointe. Cette information pourrait etre trivialement deduite du nom de fichier', SIZE BIGINT NOT NULL COMMENT 'taille de la piece jointe en octet. Cette information est déterminée au moment de l''upload et doit etre fournie a la base     dès sa création', ADDED_ON datetime NOT NULL COMMENT 'Date de l''ajout de la piece jointe.', CONTENT_ID BIGINT NULL COMMENT 'cle etrangere vers la table ATTACHMENT_CONTENT', CONSTRAINT PK_ATTACHMENT PRIMARY KEY (ATTACHMENT_ID), CONSTRAINT fk_attachment_content FOREIGN KEY (CONTENT_ID) REFERENCES ATTACHMENT_CONTENT(ATTACHMENT_CONTENT_ID)) ENGINE = INNODB;

CREATE INDEX idx_attachment ON ATTACHMENT(ATTACHMENT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.05', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 20, '8:4f375dd25e0120e0392f4869f59e92d1', 'createTable tableName=ATTACHMENT; createIndex indexName=idx_attachment, tableName=ATTACHMENT', 'Cette table stockera les pieces jointes. La piece elle même est un blob stocke a part dans
					la table ATTACHMENT_CONTENT. La relation entre les deux tables est 1-1', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.06::bsiri
--  Cette table matérialise une liste d'ATTACHMENT. Bien qu'elle ne contienne que sa clé primaire, sa raison d'exister est, au niveau de l'application, de fournir une entité indépendante des entités métier auquel on rajoute les pièces jointes.
CREATE TABLE ATTACHMENT_LIST (ATTACHMENT_LIST_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire, devrait être autogénérée.', CONSTRAINT PK_ATTACHMENT_LIST PRIMARY KEY (ATTACHMENT_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.06', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 21, '8:5e04a2b804609a1feae02e24bd6a1500', 'createTable tableName=ATTACHMENT_LIST', 'Cette table matérialise une liste d''ATTACHMENT. Bien qu''elle ne contienne que sa clé primaire, sa raison d''exister est, au niveau de l''application, de fournir une entité indépendante des entités métier auquel on rajoute les pièces jointes.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.07::bsiri
--  Table d'association entre un cas de test et ses pieces jointes
CREATE TABLE ATTACHMENT_LIST_CONTENT (AL_ID BIGINT NOT NULL COMMENT 'clé étrangère vers ATTACHMENT_LIST.', ATTACHMENT_ID BIGINT NOT NULL COMMENT 'clé étrangère vers la table ATTACHMENT', CONSTRAINT fk_list_attachment_list FOREIGN KEY (AL_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_list_attachment_attachment FOREIGN KEY (ATTACHMENT_ID) REFERENCES ATTACHMENT(ATTACHMENT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.07', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 22, '8:ecc4ab3f7d2a383d967c43687264b78b', 'createTable tableName=ATTACHMENT_LIST_CONTENT', 'Table d''association entre un cas de test et ses pieces jointes', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.08::ramoussou
--  Table representant les projets englobants les libraries d'entite que nous utilisons.
CREATE TABLE PROJECT (PROJECT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire de la table', NAME VARCHAR(255) NOT NULL COMMENT 'nom du projet', `DESCRIPTION` LONGTEXT NULL COMMENT 'description du projet', LABEL VARCHAR(255) NULL COMMENT 'Label du projet', ACTIVE BIT(1) DEFAULT 1 NOT NULL COMMENT 'si le projet est actif ou non', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du createur du projet.', CREATED_ON datetime NOT NULL COMMENT 'Date de creation de ce projet. Il s''agit de la date de creation de l''entree dans la base, non d''une date metier.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis a jour cet instance.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere mise a jour de cette instance.', CL_ID BIGINT NULL COMMENT 'cle etrangere de la table campaign-Library', TCL_ID BIGINT NULL COMMENT 'cle etrangere de la table TESTCASE-Library', RL_ID BIGINT NULL COMMENT 'cle etrangere de la table REQUIREMENT-Library', CONSTRAINT PK_PROJECT PRIMARY KEY (PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_project ON PROJECT(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.08', 'ramoussou', 'tm/tm.changelog-0.15.0.xml', NOW(), 23, '8:a8b05b7b8080db15350f486b617a659c', 'createTable tableName=PROJECT; createIndex indexName=idx_project, tableName=PROJECT', 'Table representant les projets englobants les libraries d''entite que nous utilisons.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.09::bsiri
--  Cette table gere les bibliotheques de cas de test. Une bibliotheque de cas de test peut contenir plusieurs
--  		repertoires et/ou cas de test, ces deux entites etant regroupees sous l'appellation generique d'element de bibliotheque
--  		de cas de test (test case library nodes).
CREATE TABLE TEST_CASE_LIBRARY (TCL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree', PROJECT_ID BIGINT NULL COMMENT 'cle etrangere de la table Project', CONSTRAINT PK_TEST_CASE_LIBRARY PRIMARY KEY (TCL_ID), CONSTRAINT fk_tcl_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_test_case_library ON TEST_CASE_LIBRARY(TCL_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.09', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 24, '8:fd1c7bb9ed332c714dd2b5010e0b12c4', 'createTable tableName=TEST_CASE_LIBRARY; createIndex indexName=idx_test_case_library, tableName=TEST_CASE_LIBRARY', 'Cette table gere les bibliotheques de cas de test. Une bibliotheque de cas de test peut contenir plusieurs
		repertoires et/ou cas de test, ces deux entites etant regroupees sous l''appellation generique d''element de bibliotheque
		de cas de test (...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.10::bsiri
--  Cette table gere les bibliotheques d'exigences. Une bibliotheque d'exigences peut contenir plusieurs repertoires
--  				et/ou exigences, ces deux entites etant regroupees sous l'appellation generique d'element de bibliotheque d'exigences (requirement
--  				library nodes).
CREATE TABLE REQUIREMENT_LIBRARY (RL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree', PROJECT_ID BIGINT NULL COMMENT 'cle etrangere de la table Project', CONSTRAINT PK_REQUIREMENT_LIBRARY PRIMARY KEY (RL_ID), CONSTRAINT fk_rl_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_requirement_library ON REQUIREMENT_LIBRARY(RL_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.10', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 25, '8:016e5344da49c0996032a6e8906d01c6', 'createTable tableName=REQUIREMENT_LIBRARY; createIndex indexName=idx_requirement_library, tableName=REQUIREMENT_LIBRARY', 'Cette table gere les bibliotheques d''exigences. Une bibliotheque d''exigences peut contenir plusieurs repertoires
				et/ou exigences, ces deux entites etant regroupees sous l''appellation generique d''element de bibliotheque d''exigences (requirement...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.11::bsiri
--  Cette table gere les bibliotheques de campagnes. Une bibliotheque
--  		de campagnes peut contenir plusieurs repertoires et/ou campagnes, ces deux
--  		entites etant regroupees sous l'appellation generique d'element de bibliotheque
--  		de campagnes (campaign library nodes).
CREATE TABLE CAMPAIGN_LIBRARY (CL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree', PROJECT_ID BIGINT NULL COMMENT 'cle etrangere de la table Project', CONSTRAINT PK_CAMPAIGN_LIBRARY PRIMARY KEY (CL_ID), CONSTRAINT fk_cl_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_campaign_library ON CAMPAIGN_LIBRARY(CL_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.11', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 26, '8:d7c016fa07a3268e2c27c88b7e975a26', 'createTable tableName=CAMPAIGN_LIBRARY; createIndex indexName=idx_campaign_library, tableName=CAMPAIGN_LIBRARY', 'Cette table gere les bibliotheques de campagnes. Une bibliotheque
		de campagnes peut contenir plusieurs repertoires et/ou campagnes, ces deux
		entites etant regroupees sous l''appellation generique d''element de bibliotheque
		de campagnes (campai...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.12::ramoussou
ALTER TABLE PROJECT ADD CONSTRAINT fk_project_cl FOREIGN KEY (CL_ID) REFERENCES CAMPAIGN_LIBRARY (CL_ID);

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_tcl FOREIGN KEY (TCL_ID) REFERENCES TEST_CASE_LIBRARY (TCL_ID);

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_rl FOREIGN KEY (RL_ID) REFERENCES REQUIREMENT_LIBRARY (RL_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.12', 'ramoussou', 'tm/tm.changelog-0.15.0.xml', NOW(), 27, '8:36341a758e071e22a1ab1b8988c9f4a2', 'addForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_cl, referencedTableName=CAMPAIGN_LIBRARY; addForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_tcl, referencedTableName=TEST_CASE_LIBRARY; addForeignKeyCo...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.13::bsiri
--  Cette table represente un element (generique) faisant partie d'une bibliotheque de cas de test. Cet element
--  		generique peut representer soit un repertoire, soit un cas de test. Pour cette raison, que l'utilisateur cree l'un ou
--  		l'autre cette table sera necessairement alimentee, et contiendra la cle primaire de l'element en question.
--  		Toutefois le type reel de l'element cas de test ou repertoire) n'est pas renseigne, il est necessaire de rechercher
--  		si la cle est referencee dans la table TEST_CASE_FOLDER ou TEST_CASE pour determiner si cet element releve de l'un ou l'autre.
CREATE TABLE TEST_CASE_LIBRARY_NODE (TCLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree.', DELETED_ON datetime DEFAULT null NULL COMMENT 'drapeau indiquant si l''element est actif (NULL) ou logiquement supprime (not NULL).', `DESCRIPTION` LONGTEXT DEFAULT null NULL COMMENT 'Une description associee a cet element. Devrait etre un champ texte long ou un clob.', NAME VARCHAR(255) NOT NULL COMMENT 'Le nom/label de l''element en question.', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du createur de ce cas de test.', CREATED_ON datetime NOT NULL COMMENT 'Date de creation de ce cas de test. Il s''agit de la date de creation de l''entree dans la base, non d''une date metier.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis a jour cet instance.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere mise a jour de cette instance.', PROJECT_ID BIGINT NULL COMMENT 'FK to the Project to which belongs this resource', CONSTRAINT PK_TEST_CASE_LIBRARY_NODE PRIMARY KEY (TCLN_ID), CONSTRAINT fk_tcln_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.13', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 28, '8:e79b3efcef7b253333fd8bfab54ba5bf', 'createTable tableName=TEST_CASE_LIBRARY_NODE', 'Cette table represente un element (generique) faisant partie d''une bibliotheque de cas de test. Cet element
		generique peut representer soit un repertoire, soit un cas de test. Pour cette raison, que l''utilisateur cree l''un ou
		l''autre cette tab...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.14::bsiri
--  Cette table represente un element (generique) faisant partie d'une bibliotheque d'exigences. Cet element
--  				generique peut representer soit un repertoire, soit une exigence. Pour cette raison, que l'utilisateur cree l'un ou l'autre
--  				cette table sera necessairement alimentee, et contiendra la cle primaire de l'element en question. Toutefois le type reel
--  				de l'element (exigence ou repertoire) n'est pas renseigne, il est necessaire de rechercher si la cle est referencee dans
--  				la table REQUIREMENT_FOLDER ou REQUIREMENT pour determiner si cet element releve de l'un ou l'autre.
CREATE TABLE REQUIREMENT_LIBRARY_NODE (RLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree', DELETED_ON datetime DEFAULT null NULL COMMENT 'drapeau indiquant si l''element est actif (NULL) ou logiquement supprime (not NULL).', `DESCRIPTION` LONGTEXT DEFAULT null NULL COMMENT 'Une description associee a cet element. Devrait etre un champ texte long ou un clob.', NAME VARCHAR(255) NOT NULL COMMENT 'Le nom/label de l''element en question.', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du createur de ce cas de test.', CREATED_ON datetime NOT NULL COMMENT 'Date de creation de cette exigence. Il s''agit de la date de creation de l''entree dans la base, non d''une date metier.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis a jour cet instance.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere mise a jour de cette instance.', PROJECT_ID BIGINT NULL COMMENT 'FK to the Project to which belongs this resource', CONSTRAINT PK_REQUIREMENT_LIBRARY_NODE PRIMARY KEY (RLN_ID), CONSTRAINT fk_rln_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.14', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 29, '8:40263cfeea6dcd999fb700b91afd9196', 'createTable tableName=REQUIREMENT_LIBRARY_NODE', 'Cette table represente un element (generique) faisant partie d''une bibliotheque d''exigences. Cet element
				generique peut representer soit un repertoire, soit une exigence. Pour cette raison, que l''utilisateur cree l''un ou l''autre
				cette tabl...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.15::bsiri
--  Cette table represente un element (generique) faisant partie
--  				d'une bibliotheque de campagne. Cet element generique peut representer soit
--  				un repertoire, soit une campagne. Pour cette raison, que l'utilisateur cree
--  				l'un ou l'autre cette table sera necessairement alimentee, et contiendra
--  				la cle primaire de l'element en question. Toutefois le type reel de l'element
--  				(campagne ou repertoire) n'est pas renseigne, il est necessaire de rechercher
--  				si la cle est referencee dans la table CAMPAIGN_FOLDER ou CAMPAIGN pour determiner
--  				si cet element releve de l'un ou l'autre.
CREATE TABLE CAMPAIGN_LIBRARY_NODE (CLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree', DELETED_ON datetime DEFAULT null NULL COMMENT 'drapeau indiquant si l''element est actif (NULL) ou logiquement supprime (not NULL).', `DESCRIPTION` LONGTEXT DEFAULT null NULL COMMENT 'Une description associee a cet element. Devrait etre un champ texte long ou un clob.', NAME VARCHAR(255) NOT NULL COMMENT 'Le nom/label de l''element en question.', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du createur de cette campagne.', CREATED_ON datetime NOT NULL COMMENT 'Date de creation de cette campagne. Il s''agit de la date de creation de l''entree dans    la base, non d''une date metier.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere mise a jour de cette instance.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis a jour cet instance.', PROJECT_ID BIGINT DEFAULT null NULL COMMENT 'FK to the Project to which belongs this resource', CONSTRAINT PK_CAMPAIGN_LIBRARY_NODE PRIMARY KEY (CLN_ID), CONSTRAINT fk_cln_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.15', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 30, '8:8bdf4f59505a4bdecf8b5e030079cd27', 'createTable tableName=CAMPAIGN_LIBRARY_NODE', 'Cette table represente un element (generique) faisant partie
				d''une bibliotheque de campagne. Cet element generique peut representer soit
				un repertoire, soit une campagne. Pour cette raison, que l''utilisateur cree
				l''un ou l''autre cette ...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.16::bsiri
--  Cette table gere les cas de test proprement dits. Une entree dans cette table indique que l'element reference dans la table TEST_CASE_LIBRARY_NODE par la cle primaire (egalement cle etrangere) est de type cas de test.
CREATE TABLE TEST_CASE (TCLN_ID BIGINT NOT NULL COMMENT 'cle primaire, qui est aussi une cle etrangere vers la table TEST_CASE_LIBRARY_NODE. Ne doit donc pas etre autogeneree.', VERSION INT NOT NULL COMMENT 'Le numero de version de ce cas de test', EXECUTION_MODE VARCHAR(255) DEFAULT null NULL COMMENT 'Mode d''execution du test case. Bien que ce champs soit caractere variable, les donnees reelles seront la representation texte d''un type enumere.', ATTACHMENT_LIST_ID BIGINT NOT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', CONSTRAINT PK_TEST_CASSE PRIMARY KEY (TCLN_ID), CONSTRAINT fk_test_case_test_case_node FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE_LIBRARY_NODE(TCLN_ID), CONSTRAINT fk_test_case_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_test_case ON TEST_CASE(TCLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.16', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 31, '8:4abfcdf848e74b00431338408a53f696', 'createTable tableName=TEST_CASE; createIndex indexName=idx_test_case, tableName=TEST_CASE', 'Cette table gere les cas de test proprement dits. Une entree dans cette table indique que l''element reference dans la table TEST_CASE_LIBRARY_NODE par la cle primaire (egalement cle etrangere) est de type cas de test.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.17::bsiri
--  Cette table est rudimentaire. La cle primaire est simplement une cle etrangere vers la table TEST_CASE_LIBRARY_NODE (relation qualifiante).
--  		Une entree dans cette table indique que l'element indexe par cette cle est de type repertoire.
CREATE TABLE TEST_CASE_FOLDER (TCLN_ID BIGINT NOT NULL COMMENT 'cle primaire, qui est une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE. Ne doit donc pas etre autogeneree.', CONSTRAINT PK_TEST_CASE_FOLDER PRIMARY KEY (TCLN_ID), CONSTRAINT fk_folder_test_case_node FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE_LIBRARY_NODE(TCLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_tc_folder ON TEST_CASE_FOLDER(TCLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.17', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 32, '8:f23e095ddd7fb06a8ed0d7e8c38eb496', 'createTable tableName=TEST_CASE_FOLDER; createIndex indexName=idx_tc_folder, tableName=TEST_CASE_FOLDER', 'Cette table est rudimentaire. La cle primaire est simplement une cle etrangere vers la table TEST_CASE_LIBRARY_NODE (relation qualifiante).
		Une entree dans cette table indique que l''element indexe par cette cle est de type repertoire.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.18::bsiri
--  Cette table associe les bibliotheques de cas de test a leur contenu (elements de bibliotheques de cas de test).
--  		Le contenu d'une bibliotheque de cas de test est arborescent et est represente suivant un patron composite
--  		(voire TEST_CASE_LIBRARY_NODE, TEST_CASE_FOLDER, TEST_CASE). Par defaut la presente table peut contenir uniquement
--  		les references vers les elements fils directs; on peut aussi mettre en relation une bibliotheque de cas de test avec
--  		n'importe quel element de son contenu (quelque soit sa profondeur hierarchique) pour des raisons d'optimisation.
CREATE TABLE TEST_CASE_LIBRARY_CONTENT (LIBRARY_ID BIGINT NOT NULL COMMENT 'cle etrangere vers une bibliotheque de cas de test.', CONTENT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers un noeud de la bibliotheque de cas de test.', CONSTRAINT fk_test_case_lib_content_content FOREIGN KEY (CONTENT_ID) REFERENCES TEST_CASE_LIBRARY_NODE(TCLN_ID), CONSTRAINT fk_test_case_lib_content_lib FOREIGN KEY (LIBRARY_ID) REFERENCES TEST_CASE_LIBRARY(TCL_ID), UNIQUE (CONTENT_ID)) ENGINE = INNODB;

CREATE INDEX idx_test_case_lib_content_content ON TEST_CASE_LIBRARY_CONTENT(CONTENT_ID);

CREATE INDEX idx_test_case_lib_content_lib ON TEST_CASE_LIBRARY_CONTENT(LIBRARY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.18', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 33, '8:84a56cc824a8768759d99b80cd666d1e', 'createTable tableName=TEST_CASE_LIBRARY_CONTENT; createIndex indexName=idx_test_case_lib_content_content, tableName=TEST_CASE_LIBRARY_CONTENT; createIndex indexName=idx_test_case_lib_content_lib, tableName=TEST_CASE_LIBRARY_CONTENT', 'Cette table associe les bibliotheques de cas de test a leur contenu (elements de bibliotheques de cas de test).
		Le contenu d''une bibliotheque de cas de test est arborescent et est represente suivant un patron composite
		(voire TEST_CASE_LIBRARY...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.19::bsiri
--  Cette table gere la hierarchie entre elements d'une bibliotheque de cas de test, associant un element fils a
--  		un repertoire parent (si non NULL) ou eventuellement aucun (NULL, dans le cas ou l'element est a la racine de la bibliotheque
--  		de cas de test).
CREATE TABLE TCLN_RELATIONSHIP (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le repertoire parent (il s''agit necessairement d''un repertoire).', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. ', CONSTRAINT fk_tcln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES TEST_CASE_FOLDER(TCLN_ID), CONSTRAINT fk_tcln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES TEST_CASE_LIBRARY_NODE(TCLN_ID), UNIQUE (DESCENDANT_ID)) ENGINE = INNODB;

CREATE INDEX idx_tcln_relationship_descendant ON TCLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX idx_tcln_relationship_ancestor ON TCLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.19', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 34, '8:3148598af5a9a91deeed6281bb250afa', 'createTable tableName=TCLN_RELATIONSHIP; createIndex indexName=idx_tcln_relationship_descendant, tableName=TCLN_RELATIONSHIP; createIndex indexName=idx_tcln_relationship_ancestor, tableName=TCLN_RELATIONSHIP', 'Cette table gere la hierarchie entre elements d''une bibliotheque de cas de test, associant un element fils a
		un repertoire parent (si non NULL) ou eventuellement aucun (NULL, dans le cas ou l''element est a la racine de la bibliotheque
		de cas d...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.20::bsiri
--  Cette table gere les campagnes proprement dites. Une entree
--  				dans cette table indique que l'element reference dans la table CAMPAIGN_LIBRARY_NODE
--  				par la cle primaire (egalement cle etrangere) est de type campagne.
CREATE TABLE CAMPAIGN (CLN_ID BIGINT NOT NULL, ACTUAL_END_AUTO BIT(1) NOT NULL COMMENT 'Drapeau indiquant si l''utilisateur a choisit une determination automatique de la date de depart effective ou non.', ACTUAL_END_DATE datetime DEFAULT null NULL COMMENT 'Date de fin effective (reelle) de la campagne.', ACTUAL_START_AUTO BIT(1) NOT NULL COMMENT 'Drapeau indiquant si l''utilisateur a choisit une determination automatique de la date de fin effective ou non.', ACTUAL_START_DATE datetime DEFAULT null NULL COMMENT 'Date de depar effective (reelle) de la campagne.', SCHEDULED_END_DATE datetime DEFAULT null NULL COMMENT 'Date planifiee de fin de la campagne.', SCHEDULED_START_DATE datetime DEFAULT null NULL COMMENT 'Date planifiee de debut de la campagne.', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', CONSTRAINT PK_CAMPAIGN PRIMARY KEY (CLN_ID), CONSTRAINT FK_CAMPAIGN_CL_NODE FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID), CONSTRAINT fk_campaign_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.20', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 35, '8:1e3cbed34f0726277e26243cda1bacdd', 'createTable tableName=CAMPAIGN', 'Cette table gere les campagnes proprement dites. Une entree
				dans cette table indique que l''element reference dans la table CAMPAIGN_LIBRARY_NODE
				par la cle primaire (egalement cle etrangere) est de type campagne.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.21::bsiri
--  Cette table est rudimentaire. La cle primaire est simplement
--  				une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE (relation qualifiante).
--  				Une entree dans cette table indique que l'element indexe par cette cle est
--  				de type repertoire.
CREATE TABLE CAMPAIGN_FOLDER (CLN_ID BIGINT NOT NULL COMMENT 'cle primaire, qui est une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE. Ne doit donc pas etre autogeneree.', CONSTRAINT PK_CAMPAIGN_FOLDER PRIMARY KEY (CLN_ID), CONSTRAINT FK_CAMPAIGN_FOLDER_CL_NODE FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.21', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 36, '8:08391f23434a77a19409938d033a4840', 'createTable tableName=CAMPAIGN_FOLDER', 'Cette table est rudimentaire. La cle primaire est simplement
				une cle etrangere vers la table CAMPAIGN_LIBRARY_NODE (relation qualifiante).
				Une entree dans cette table indique que l''element indexe par cette cle est
				de type repertoire.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.22::bsiri
--  Cette table gere les bibliotheques de campagnes. Une bibliotheque
--  				de campagnes peut contenir plusieurs repertoires et/ou campagnes, ces deux
--  				entites etant regroupees sous l'appellation generique d'element de bibliotheque
--  				de campagnes (campaign library nodes).
CREATE TABLE CAMPAIGN_LIBRARY_CONTENT (LIBRARY_ID BIGINT NOT NULL COMMENT 'cle etrangere vers une bibliotheque de campagnes.', CONTENT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers un noeud de la bibliotheque de campagnes.', CONSTRAINT fk_cl_content_lib FOREIGN KEY (LIBRARY_ID) REFERENCES CAMPAIGN_LIBRARY(CL_ID), CONSTRAINT fk_cl_content_content FOREIGN KEY (CONTENT_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID), UNIQUE (CONTENT_ID)) ENGINE = INNODB;

CREATE UNIQUE INDEX dx_cl_content_cl_node ON CAMPAIGN_LIBRARY_CONTENT(CONTENT_ID);

CREATE INDEX dx_cl_content_campaign_lib ON CAMPAIGN_LIBRARY_CONTENT(LIBRARY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.22', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 37, '8:f9f47b93e7c62712769f4e658b49ba0d', 'createTable tableName=CAMPAIGN_LIBRARY_CONTENT; createIndex indexName=dx_cl_content_cl_node, tableName=CAMPAIGN_LIBRARY_CONTENT; createIndex indexName=dx_cl_content_campaign_lib, tableName=CAMPAIGN_LIBRARY_CONTENT', 'Cette table gere les bibliotheques de campagnes. Une bibliotheque
				de campagnes peut contenir plusieurs repertoires et/ou campagnes, ces deux
				entites etant regroupees sous l''appellation generique d''element de bibliotheque
				de campagnes (...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.23::bsiri
--  Cette table gere la hierarchie entre elements d'une bibliotheque
--  				de campagne, associant un element fils a un repertoire parent (si non NULL)
--  				ou eventuellement aucun (NULL, dans le cas ou l'element est a la racine de
--  				la bibliotheque de campagne).
CREATE TABLE CLN_RELATIONSHIP (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le repertoire parent (il s''agit necessairement d''un repertoire).', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils.', CONSTRAINT idx_cln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID), CONSTRAINT fk_cln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES CAMPAIGN_FOLDER(CLN_ID), UNIQUE (DESCENDANT_ID)) ENGINE = INNODB;

CREATE INDEX dx_cln_relationship_descendant ON CLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX dx_cln_relationship_ancestor ON CLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.23', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 38, '8:610f40da3f5d51f9c509df03a469cf89', 'createTable tableName=CLN_RELATIONSHIP; createIndex indexName=dx_cln_relationship_descendant, tableName=CLN_RELATIONSHIP; createIndex indexName=dx_cln_relationship_ancestor, tableName=CLN_RELATIONSHIP', 'Cette table gere la hierarchie entre elements d''une bibliotheque
				de campagne, associant un element fils a un repertoire parent (si non NULL)
				ou eventuellement aucun (NULL, dans le cas ou l''element est a la racine de
				la bibliotheque de ...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.24::bsiri
CREATE TABLE ITERATION (ITERATION_ID BIGINT AUTO_INCREMENT NOT NULL, DELETED_ON datetime DEFAULT null NULL, `DESCRIPTION` LONGTEXT DEFAULT null NULL, NAME VARCHAR(255) NOT NULL, CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, ACTUAL_END_AUTO BIT(1) NOT NULL, ACTUAL_END_DATE datetime DEFAULT null NULL, ACTUAL_START_AUTO BIT(1) NOT NULL, ACTUAL_START_DATE datetime DEFAULT null NULL, SCHEDULED_END_DATE datetime DEFAULT null NULL, SCHEDULED_START_DATE datetime DEFAULT null NULL, ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', CONSTRAINT PK_ITERATION PRIMARY KEY (ITERATION_ID), CONSTRAINT fk_iteration__attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.24', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 39, '8:df334bc9e9238ad2869a538b20e056a7', 'createTable tableName=ITERATION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.25::bsiri
CREATE TABLE CAMPAIGN_ITERATION (CAMPAIGN_ID BIGINT NOT NULL, ITERATION_ID BIGINT NOT NULL, ITERATION_ORDER INT NOT NULL, CONSTRAINT fk_camp_iter_iteration FOREIGN KEY (ITERATION_ID) REFERENCES ITERATION(ITERATION_ID), CONSTRAINT fk_camp_iter_campaign FOREIGN KEY (CAMPAIGN_ID) REFERENCES CAMPAIGN(CLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.25', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 40, '8:c139a8e6808bf6ea2a43a0de3557b7ac', 'createTable tableName=CAMPAIGN_ITERATION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.26::bsiri
--  Cette table gere les pas de test d'un cas de test.
CREATE TABLE TEST_STEP (TEST_STEP_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'cle primaire autogeneree.', EXPECTED_RESULT LONGTEXT DEFAULT null NULL COMMENT 'le resultat attendu de l''action effectuee.', ACTION LONGTEXT NOT NULL COMMENT 'action a realiser dans ce pas de test.', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', CONSTRAINT PK_TEST_STEP PRIMARY KEY (TEST_STEP_ID), CONSTRAINT fk_test_step__attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.26', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 41, '8:4e9bed3b356f31dda9baa615f8cc6371', 'createTable tableName=TEST_STEP', 'Cette table gere les pas de test d''un cas de test.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.27::bsiri
--  Cette table associe un cas de test a ses pas de test. Cette table d'association existe pour ajouter un attribut d'ordre (la liste des pas de test est ordonnee). La cle primaire est ici composite, et ne doit pas etre autogeneree.
CREATE TABLE TEST_CASE_STEPS (TEST_CASE_ID BIGINT NOT NULL COMMENT 'cle etrangere vers TEST_CASE.', STEP_ID BIGINT NOT NULL COMMENT 'cle etrangere vers la table TEST_STEP.', STEP_ORDER INT NOT NULL COMMENT 'numero d''ordre d''un pas de test dans la liste des pas de test d''un cas de test.', CONSTRAINT fk_tc_steps_step FOREIGN KEY (STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_tc_steps_tc FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_tc_steps_step ON TEST_CASE_STEPS(STEP_ID);

CREATE INDEX idx_tc_steps_tc ON TEST_CASE_STEPS(TEST_CASE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.27', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 42, '8:d21e2ddc45e4d0d37921acafcf001819', 'createTable tableName=TEST_CASE_STEPS; createIndex indexName=idx_tc_steps_step, tableName=TEST_CASE_STEPS; createIndex indexName=idx_tc_steps_tc, tableName=TEST_CASE_STEPS', 'Cette table associe un cas de test a ses pas de test. Cette table d''association existe pour ajouter un attribut d''ordre (la liste des pas de test est ordonnee). La cle primaire est ici composite, et ne doit pas etre autogeneree.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.28::xpr
CREATE TABLE PROJECT_FILTER (PROJECT_FILTER_ID BIGINT AUTO_INCREMENT NOT NULL, ACTIVATED BIT(1) DEFAULT 0 NOT NULL COMMENT 'filter activated yes or no', USER_LOGIN VARCHAR(255) NOT NULL COMMENT 'unique user login', CONSTRAINT PK_PROJECT_FILTER PRIMARY KEY (PROJECT_FILTER_ID)) ENGINE = INNODB;

CREATE INDEX DX_UN_PROJECT_FILTER_USER ON PROJECT_FILTER(USER_LOGIN);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.28', 'xpr', 'tm/tm.changelog-0.15.0.xml', NOW(), 43, '8:6751ed9d2dc5a49ebde66b5840692425', 'createTable tableName=PROJECT_FILTER; createIndex indexName=DX_UN_PROJECT_FILTER_USER, tableName=PROJECT_FILTER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.29::xpr
CREATE TABLE PROJECT_FILTER_ENTRY (PROJECT_ID BIGINT NOT NULL COMMENT 'foreign key to project', FILTER_ID BIGINT NOT NULL COMMENT 'foreign key to filter', CONSTRAINT FK_PROJ_FILTER_ENTRY_PROJ FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT FK_PROJ_FILTER_ENTRY_PROJ_FILTER FOREIGN KEY (FILTER_ID) REFERENCES PROJECT_FILTER(PROJECT_FILTER_ID)) ENGINE = INNODB;

ALTER TABLE PROJECT_FILTER_ENTRY ADD PRIMARY KEY (PROJECT_ID, FILTER_ID);

CREATE INDEX dx_pfp_project ON PROJECT_FILTER_ENTRY(PROJECT_ID);

CREATE INDEX dx_pfp_filter ON PROJECT_FILTER_ENTRY(FILTER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.29', 'xpr', 'tm/tm.changelog-0.15.0.xml', NOW(), 44, '8:e834c57168097eaac73da92840dd6303', 'createTable tableName=PROJECT_FILTER_ENTRY; addPrimaryKey constraintName=PK_PROJ_FILTER_ENTRY, tableName=PROJECT_FILTER_ENTRY; createIndex indexName=dx_pfp_project, tableName=PROJECT_FILTER_ENTRY; createIndex indexName=dx_pfp_filter, tableName=PRO...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.30::bsiri
--  Cette table gere les exigences proprement dites. Une entree dans cette table indique que l'element reference
--  				dans la table REQUIREMENT_LIBRARY_NODE par la cle primaire (egalement cle etrangere) est de type exigence.
CREATE TABLE REQUIREMENT (RLN_ID BIGINT NOT NULL COMMENT 'cle primaire, qui est aussi une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE. Ne doit donc pas etre autogeneree.', `REFERENCE` VARCHAR(20) NULL COMMENT 'Identifiant de l''exigence', CRITICALITY VARCHAR(255) DEFAULT 'UNDEFINED' NOT NULL COMMENT 'Requirement criticality. Althought this field is a variable character, the data will be the text representation of an enumeration', ATTACHMENT_LIST_ID BIGINT NOT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', CONSTRAINT PK_REQUIREMENT PRIMARY KEY (RLN_ID), CONSTRAINT fk_requirement_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_requirement_requirement_node FOREIGN KEY (RLN_ID) REFERENCES REQUIREMENT_LIBRARY_NODE(RLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_requirement ON REQUIREMENT(RLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.30', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 45, '8:f11d50d3c4ba925807be95b3da868cd4', 'createTable tableName=REQUIREMENT; createIndex indexName=idx_requirement, tableName=REQUIREMENT', 'Cette table gere les exigences proprement dites. Une entree dans cette table indique que l''element reference
				dans la table REQUIREMENT_LIBRARY_NODE par la cle primaire (egalement cle etrangere) est de type exigence.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.31::bsiri
--  Cette table est rudimentaire. La cle primaire est simplement une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE
--  				(relation qualifiante). Une entree dans cette table indique que l'element indexe par cette cle est de type repertoire.
CREATE TABLE REQUIREMENT_FOLDER (RLN_ID BIGINT NOT NULL COMMENT 'cle primaire, qui est une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE. Ne doit donc pas etre autogeneree.', CONSTRAINT PK_REQUIREMENT_FOLDER PRIMARY KEY (RLN_ID), CONSTRAINT fk_folder_requirement_node FOREIGN KEY (RLN_ID) REFERENCES REQUIREMENT_LIBRARY_NODE(RLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_req_folder ON REQUIREMENT_FOLDER(RLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.31', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 46, '8:05a1d246c9664dc19a17e52bd07ce978', 'createTable tableName=REQUIREMENT_FOLDER; createIndex indexName=idx_req_folder, tableName=REQUIREMENT_FOLDER', 'Cette table est rudimentaire. La cle primaire est simplement une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE
				(relation qualifiante). Une entree dans cette table indique que l''element indexe par cette cle est de type repertoire.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.32::bsiri
--  Cette table associe les bibliotheques d'exigences a leur contenu (elements de bibliotheques d'exigence).
--  		Le contenu d'une bibliotheque d'exigence est arborescent et est represente suivant un patron composite (voire REQUIREMENT_LIBRARY_NODE,
--  		REQUIREMENT_FOLDER, REQUIREMENT). Par defaut la presente table peut contenir uniquement les references vers les elements
--  		fils directs; on peut aussi mettre en relation une bibliotheque d'exigence avec n'importe quel element de son contenu (quelque
--  		soit sa profondeur hierarchique) pour des raisons d'optimisation.
CREATE TABLE REQUIREMENT_LIBRARY_CONTENT (LIBRARY_ID BIGINT NOT NULL COMMENT 'cle etrangere vers une bibliotheque d''exigence.', CONTENT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers un noeud de la bibliotheque d''exigences.', CONSTRAINT fk_requirement_lib_content_content FOREIGN KEY (CONTENT_ID) REFERENCES REQUIREMENT_LIBRARY_NODE(RLN_ID), CONSTRAINT fk_requirement_lib_content_lib FOREIGN KEY (LIBRARY_ID) REFERENCES REQUIREMENT_LIBRARY(RL_ID), UNIQUE (CONTENT_ID)) ENGINE = INNODB;

CREATE INDEX idx_requirement_lib_content_content ON REQUIREMENT_LIBRARY_CONTENT(CONTENT_ID);

CREATE INDEX idx_requirement_lib_content_lib ON REQUIREMENT_LIBRARY_CONTENT(LIBRARY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.32', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 47, '8:8991560988f2b0dac1c7cc5eec4c02a8', 'createTable tableName=REQUIREMENT_LIBRARY_CONTENT; createIndex indexName=idx_requirement_lib_content_content, tableName=REQUIREMENT_LIBRARY_CONTENT; createIndex indexName=idx_requirement_lib_content_lib, tableName=REQUIREMENT_LIBRARY_CONTENT', 'Cette table associe les bibliotheques d''exigences a leur contenu (elements de bibliotheques d''exigence).
		Le contenu d''une bibliotheque d''exigence est arborescent et est represente suivant un patron composite (voire REQUIREMENT_LIBRARY_NODE,
		RE...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.33::bsiri
--  Cette table gere la hierarchie entre elements d'une bibliotheque d'exigences, associant un element fils
--  				a un repertoire parent.
CREATE TABLE RLN_RELATIONSHIP (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le repertoire parent (il s''agit necessairement d''un repertoire).', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils.', CONSTRAINT fk_rln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES REQUIREMENT_FOLDER(RLN_ID), CONSTRAINT fk_rln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES REQUIREMENT_LIBRARY_NODE(RLN_ID), UNIQUE (DESCENDANT_ID)) ENGINE = INNODB;

CREATE INDEX idx_rln_relationship_descendant ON RLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX idx_rln_relationship_ancestor ON RLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.33', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 48, '8:854410f19a07111ac4eb5b10cf9cb66a', 'createTable tableName=RLN_RELATIONSHIP; createIndex indexName=idx_rln_relationship_descendant, tableName=RLN_RELATIONSHIP; createIndex indexName=idx_rln_relationship_ancestor, tableName=RLN_RELATIONSHIP', 'Cette table gere la hierarchie entre elements d''une bibliotheque d''exigences, associant un element fils
				a un repertoire parent.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.34::bsiri
--  Cette table associe un cas de test avec une liste d'execution. Elle conserve également
--  		en mémoire le status d'execution, qui devra sera mis à jour au fur et à mesure qu'une execution
--  		est ajoutée ou exécutée.
CREATE TABLE ITEM_TEST_PLAN (ITEM_TEST_PLAN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire du test plan. Devrait être autogénérée.', EXECUTION_STATUS VARCHAR(255) DEFAULT null NULL COMMENT 'Status d''execution de ce plan de test. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré. Sera recalculé en fonction du status de    sa derniere execution', LAST_EXECUTED_BY VARCHAR(255) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant execute cet instance.', LAST_EXECUTED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere execution de cette instance.', TCLN_ID BIGINT NULL COMMENT 'Clé étrangère vers le cas de test référencé', LABEL VARCHAR(255) NULL COMMENT 'Le label (duplicata du nom du cas de test) du test plan', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du créateur du testplan', CREATED_ON datetime NOT NULL COMMENT 'Date de création du test plan. Il s''agit de la date de création de l''entrée dans la base, non d''une date métier.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis à jour cet instance.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de dernière mise à jour de cette instance.', CONSTRAINT PK_ITEM_TEST_PLAN PRIMARY KEY (ITEM_TEST_PLAN_ID), CONSTRAINT fk_itertestplan_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_itertestplan ON ITEM_TEST_PLAN(ITEM_TEST_PLAN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.34', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 49, '8:4627a9de93c1c4a2147036f8c9d403a5', 'createTable tableName=ITEM_TEST_PLAN; createIndex indexName=idx_itertestplan, tableName=ITEM_TEST_PLAN', 'Cette table associe un cas de test avec une liste d''execution. Elle conserve également
		en mémoire le status d''execution, qui devra sera mis à jour au fur et à mesure qu''une execution
		est ajoutée ou exécutée.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.35::bsiri
--  Cette table associe une iteration a ses test plans. Cette table d'association existe pour ajouter un attribut d'ordre (la liste des test plans est ordonnée). La clé primaire est ici composite, et ne doit pas être autogénérée.
CREATE TABLE ITEM_TEST_PLAN_LIST (ITERATION_ID BIGINT NOT NULL COMMENT 'clé étrangère vers ITERATION.', ITEM_TEST_PLAN_ID BIGINT NOT NULL COMMENT 'clé étrangère vers la table ITEM_TEST_PLAN', ITEM_TEST_PLAN_ORDER INT NOT NULL COMMENT 'numéro d''ordre d''une execution dans la liste des test plans d''une itération.', CONSTRAINT fk_ITEM_TESTplan_testplan FOREIGN KEY (ITEM_TEST_PLAN_ID) REFERENCES ITEM_TEST_PLAN(ITEM_TEST_PLAN_ID), CONSTRAINT fk_item_test_plan_iteration FOREIGN KEY (ITERATION_ID) REFERENCES ITERATION(ITERATION_ID)) ENGINE = INNODB;

CREATE INDEX idx_ITEM_TESTplan_iteration ON ITEM_TEST_PLAN_LIST(ITERATION_ID);

CREATE INDEX idx_ITEM_TESTplan_testplan ON ITEM_TEST_PLAN_LIST(ITEM_TEST_PLAN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.35', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 50, '8:28a12dbdd4437ee8892579c9c9e22c6e', 'createTable tableName=ITEM_TEST_PLAN_LIST; createIndex indexName=idx_ITEM_TESTplan_iteration, tableName=ITEM_TEST_PLAN_LIST; createIndex indexName=idx_ITEM_TESTplan_testplan, tableName=ITEM_TEST_PLAN_LIST', 'Cette table associe une iteration a ses test plans. Cette table d''association existe pour ajouter un attribut d''ordre (la liste des test plans est ordonnée). La clé primaire est ici composite, et ne doit pas être autogénérée.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.36::bsiri
--  Table des executions. Une execution correspond à un cas de test, et ses pas d'execution correspondent à des pas de test. Pour assurer un contrôle sur les modifications de l'entité source une référence est gardée vers le cas de test source.
CREATE TABLE EXECUTION (EXECUTION_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire de l''execution. Devrait être autogénérée.', TCLN_ID BIGINT NULL COMMENT 'Clé étrangère vers le cas de test référencé. Cette information est redondante puisque     il s''agit toujours du même que celui du test plan, cependant cette information ne devant     jamais évoluer il n''y a pas de risque à dénormaliser', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du créateur de l''execution.', CREATED_ON datetime NOT NULL COMMENT 'Date de création de cette execution. Il s''agit de la date de création de l''entrée dans la base, non d''une date métier.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis à jour cet instance.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de dernière mise à jour de cette instance.', `DESCRIPTION` LONGTEXT DEFAULT null NULL COMMENT 'Une description associée à cet élément. Devrait être un champ texte long ou un clob.', NAME VARCHAR(255) NOT NULL COMMENT 'Le nom/label de l''élément en question.', EXECUTION_MODE VARCHAR(255) DEFAULT null NULL COMMENT 'Mode d''execution de cette execution. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré. C''est une copie du mode d''execution du cas de test référencé.', EXECUTION_STATUS VARCHAR(255) DEFAULT null NULL COMMENT 'Status d''execution de ce plan de test. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré. Sera recalculé en fonction du status de    sa derniere execution', LAST_EXECUTED_BY VARCHAR(255) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant execute cet instance.', LAST_EXECUTED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere execution de cette instance.', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', ISSUE_LIST_ID BIGINT NOT NULL COMMENT 'clé étrangère vers un ISSUE_LIST, l''entité qui gère les listes d''issues. ', CONSTRAINT PK_EXECUTION PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_execution_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID), CONSTRAINT fk_execution_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_execution_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_execution ON EXECUTION(EXECUTION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.36', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 51, '8:d266e227f26cef64aa9d63917b89f4e4', 'createTable tableName=EXECUTION; createIndex indexName=idx_execution, tableName=EXECUTION', 'Table des executions. Une execution correspond à un cas de test, et ses pas d''execution correspondent à des pas de test. Pour assurer un contrôle sur les modifications de l''entité source une référence est gardée vers le cas de test source.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.37::bsiri
--  Associe les executions aux test plans
CREATE TABLE ITEM_TEST_PLAN_EXECUTION (ITEM_TEST_PLAN_ID BIGINT NOT NULL COMMENT 'clé étrangère vers ITEM_TEST_PLAN.', EXECUTION_ID BIGINT NOT NULL COMMENT 'clé étrangère vers la table EXECUTION', EXECUTION_ORDER INT NOT NULL COMMENT 'numéro d''ordre d''une execution dans la liste des test plans d''une itération.', CONSTRAINT fk_testplan_exec_testplan FOREIGN KEY (ITEM_TEST_PLAN_ID) REFERENCES ITEM_TEST_PLAN(ITEM_TEST_PLAN_ID), CONSTRAINT fk_testplan_exec_exec FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID)) ENGINE = INNODB;

CREATE INDEX idx_testplan_exec_testplan ON ITEM_TEST_PLAN_EXECUTION(ITEM_TEST_PLAN_ID);

CREATE INDEX idx_testplan_exec_exec ON ITEM_TEST_PLAN_EXECUTION(EXECUTION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.37', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 52, '8:f33084c7ffae3c6ed7a1d3e81b451973', 'createTable tableName=ITEM_TEST_PLAN_EXECUTION; createIndex indexName=idx_testplan_exec_testplan, tableName=ITEM_TEST_PLAN_EXECUTION; createIndex indexName=idx_testplan_exec_exec, tableName=ITEM_TEST_PLAN_EXECUTION', 'Associe les executions aux test plans', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.38::bsiri
--  Cette table gère les pas d'execution d'une execution. Voir la table EXECUTION pour plus de détails.
CREATE TABLE EXECUTION_STEP (EXECUTION_STEP_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire autogénérée.', EXPECTED_RESULT LONGTEXT DEFAULT null NULL COMMENT 'le résultat attendu de l''action effectuée.', ACTION LONGTEXT NOT NULL COMMENT 'action à réaliser dans ce pas d''execution.', EXECUTION_STATUS VARCHAR(255) DEFAULT null NULL COMMENT 'Status de l''execution de ce pas d''execution. Bien que ce champs soit caractère variable, les données réelles    seront la représentation texte d''un type énuméré.', LAST_EXECUTED_BY VARCHAR(255) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant execute cet instance.', LAST_EXECUTED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere execution de cette instance.', COMMENT LONGTEXT NULL COMMENT 'commentaire libre du recetteur.', TEST_STEP_ID BIGINT NULL COMMENT 'Clé étrangère vers le pas de test référencé', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'nom du créateur du pas d''execution.', CREATED_ON datetime NOT NULL COMMENT 'Date de création de ce pas d''execution. Il s''agit de la date de création de l''entrée dans la base, non d''une date métier.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis à jour cet instance.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de dernière mise à jour de cette instance.', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', ISSUE_LIST_ID BIGINT NOT NULL COMMENT 'clé étrangère vers un ISSUE_LIST, l''entité qui gère les listes d''issues. ', CONSTRAINT PK_EXECUTION_STEP PRIMARY KEY (EXECUTION_STEP_ID), CONSTRAINT fk_executionstep_teststep FOREIGN KEY (TEST_STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_execution_step__attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_execution_step_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_executionstep ON EXECUTION_STEP(EXECUTION_STEP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.38', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 53, '8:3938ae5e9a0b4bd3212655e86fb2704d', 'createTable tableName=EXECUTION_STEP; createIndex indexName=idx_executionstep, tableName=EXECUTION_STEP', 'Cette table gère les pas d''execution d''une execution. Voir la table EXECUTION pour plus de détails.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.39::bsiri
--  Cette table associe une executions à ses pas d'execution. Cette table d'association existe pour ajouter un attribut d'ordre (la liste des pas executions est ordonnée). La clé primaire est ici composite, et ne doit pas être autogénérée.
CREATE TABLE EXECUTION_EXECUTION_STEPS (EXECUTION_ID BIGINT NOT NULL COMMENT 'clé étrangère vers la table EXECUTION.', EXECUTION_STEP_ID BIGINT NOT NULL COMMENT 'clé étrangère vers EXECUTION_STEP', EXECUTION_STEP_ORDER INT NOT NULL COMMENT 'numéro d''ordre d''un pas d''execution dans la liste des pas d''executions d''une execution.', CONSTRAINT fk_exec_exec_step_exec FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_exec_exec_step_exec_step FOREIGN KEY (EXECUTION_STEP_ID) REFERENCES EXECUTION_STEP(EXECUTION_STEP_ID)) ENGINE = INNODB;

CREATE INDEX idx_exec_exec_step_exec ON EXECUTION_EXECUTION_STEPS(EXECUTION_ID);

CREATE INDEX idx_exec_exec_step_exec_step ON EXECUTION_EXECUTION_STEPS(EXECUTION_STEP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.39', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 54, '8:bc70b347adec2a2ffb481e0d1dd7ba0f', 'createTable tableName=EXECUTION_EXECUTION_STEPS; createIndex indexName=idx_exec_exec_step_exec, tableName=EXECUTION_EXECUTION_STEPS; createIndex indexName=idx_exec_exec_step_exec_step, tableName=EXECUTION_EXECUTION_STEPS', 'Cette table associe une executions à ses pas d''execution. Cette table d''association existe pour ajouter un attribut d''ordre (la liste des pas executions est ordonnée). La clé primaire est ici composite, et ne doit pas être autogénérée.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.40::bsiri
--  Cette table gere les associations entre cas de test et exigences.
--  				La cle primaire est composite et ne doit pas etre autogeneree.
CREATE TABLE TEST_CASE_REQUIREMENT_LINK (TEST_CASE_ID BIGINT NOT NULL COMMENT 'cle etrangere vers TEST_CASE', REQUIREMENT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers REQUIREMENT', CONSTRAINT fk_tc_req_tc FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID), CONSTRAINT fk_tc_req_req FOREIGN KEY (REQUIREMENT_ID) REFERENCES REQUIREMENT(RLN_ID)) ENGINE = INNODB;

ALTER TABLE TEST_CASE_REQUIREMENT_LINK ADD PRIMARY KEY (TEST_CASE_ID, REQUIREMENT_ID);

CREATE INDEX idx_tc_req_tc ON TEST_CASE_REQUIREMENT_LINK(TEST_CASE_ID);

CREATE INDEX idx_tc_req_req ON TEST_CASE_REQUIREMENT_LINK(REQUIREMENT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.40', 'bsiri', 'tm/tm.changelog-0.15.0.xml', NOW(), 55, '8:58262c6d8f1291e2eafb30508a7377cf', 'createTable tableName=TEST_CASE_REQUIREMENT_LINK; addPrimaryKey constraintName=pk_tc_req_link, tableName=TEST_CASE_REQUIREMENT_LINK; createIndex indexName=idx_tc_req_tc, tableName=TEST_CASE_REQUIREMENT_LINK; createIndex indexName=idx_tc_req_req, t...', 'Cette table gere les associations entre cas de test et exigences.
				La cle primaire est composite et ne doit pas etre autogeneree.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.41::adurand
--  Cette table gere les associations entre les campagnes et les cas de test (= les plans de test des campagnes).La cle primaire est composite et ne doit pas etre autogeneree.
CREATE TABLE CAMPAIGN_TEST_PLAN (CAMPAIGN_ID BIGINT NOT NULL COMMENT 'cle etrangere vers CAMPAIGN', TEST_CASE_ID BIGINT NOT NULL COMMENT 'cle etrangere vers TEST_CASE', CONSTRAINT fk_camp_tp_camp FOREIGN KEY (CAMPAIGN_ID) REFERENCES CAMPAIGN(CLN_ID), CONSTRAINT fk_camp_tp_tc FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

ALTER TABLE CAMPAIGN_TEST_PLAN ADD PRIMARY KEY (CAMPAIGN_ID, TEST_CASE_ID);

CREATE INDEX idx_camp_tp_camp ON CAMPAIGN_TEST_PLAN(CAMPAIGN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.41', 'adurand', 'tm/tm.changelog-0.15.0.xml', NOW(), 56, '8:afd6c698b88ab38465f010b2e15b1e6f', 'createTable tableName=CAMPAIGN_TEST_PLAN; addPrimaryKey constraintName=pk_camp_tp, tableName=CAMPAIGN_TEST_PLAN; createIndex indexName=idx_camp_tp_camp, tableName=CAMPAIGN_TEST_PLAN', 'Cette table gere les associations entre les campagnes et les cas de test (= les plans de test des campagnes).La cle primaire est composite et ne doit pas etre autogeneree.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.42::bsiri
--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.43::xpr
alter table ATTACHMENT_CONTENT modify column STREAM_CONTENT MEDIUMBLOB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.43', 'xpr', 'tm/tm.changelog-0.15.0.xml', NOW(), 57, '8:5d49f7b9a14768e1d2a69b901eb72369', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.44::gfouquet
INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select ID from CORE_GROUP where QUALIFIED_NAME='squashtest.authz.group.core.Admin'), 'ROLE_TM_USER');

INSERT INTO CORE_GROUP (QUALIFIED_NAME) VALUES ('squashtest.tm.group.User');

INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select max(ID) from CORE_GROUP), 'ROLE_TM_USER');

INSERT INTO CORE_GROUP (QUALIFIED_NAME) VALUES ('squashtest.authz.group.tm.ProjectManager');

INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select max(ID) from CORE_GROUP), 'ROLE_TM_PROJECT_MANAGER');

INSERT INTO ACL_CLASS (CLASSNAME) VALUES ('org.squashtest.csp.tm.domain.project.Project');

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.ProjectManager');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '15', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.TestEditor');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '15', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.TestRunner');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.44', 'gfouquet', 'tm/tm.changelog-0.15.0.xml', NOW(), 58, '8:84af8be16b16c30984d3a48cf12ff34c', 'insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY; insert tableName=ACL_CLASS; insert tableName=ACL_GROUP; insert tableName...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.15.0.xml::tm-0.14.0.45::gfouquet
INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.ProjectViewer');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectViewer'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.14.0.45', 'gfouquet', 'tm/tm.changelog-0.15.0.xml', NOW(), 59, '8:b87f2918468fac72651eccadb2898192', 'insert tableName=ACL_GROUP; insert tableName=ACL_GROUP_PERMISSION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.17.0.xml::tm-0.17.0.01::gfouquet
--  This table stores "action" tests steps, i.e. steps with an action and expected result, which were formerly stored in TEST_STEP
CREATE TABLE ACTION_TEST_STEP (TEST_STEP_ID BIGINT NOT NULL COMMENT 'Shared key with TEST_STEP table', ACTION LONGTEXT NOT NULL COMMENT 'The step''s action', EXPECTED_RESULT LONGTEXT DEFAULT null NULL COMMENT 'The step''s expected result', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes. ', CONSTRAINT pk_action_step PRIMARY KEY (TEST_STEP_ID), CONSTRAINT fk_action_step_test_step FOREIGN KEY (TEST_STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_action_test_step_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.17.0.01', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', NOW(), 60, '8:3605a3f2fdb2c5f88f12d05f99f657dd', 'createTable tableName=ACTION_TEST_STEP', 'This table stores "action" tests steps, i.e. steps with an action and expected result, which were formerly stored in TEST_STEP', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.17.0.xml::tm-0.17.0.02::gfouquet
--  Data migration from TEST_STEP to ACTION_TEST_STEP
insert into ACTION_TEST_STEP (TEST_STEP_ID, ACTION, EXPECTED_RESULT, ATTACHMENT_LIST_ID) select TEST_STEP_ID, ACTION, EXPECTED_RESULT, ATTACHMENT_LIST_ID from TEST_STEP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.17.0.02', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', NOW(), 61, '8:5b3ee015db37a18baf9cf10b687b471e', 'sql', 'Data migration from TEST_STEP to ACTION_TEST_STEP', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.17.0.xml::tm-0.17.0.03::gfouquet
--  Removes useless comlumns from TEST_STEP
ALTER TABLE TEST_STEP DROP FOREIGN KEY fk_test_step__attachment_list;

ALTER TABLE TEST_STEP DROP COLUMN ACTION;

ALTER TABLE TEST_STEP DROP COLUMN EXPECTED_RESULT;

ALTER TABLE TEST_STEP DROP COLUMN ATTACHMENT_LIST_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.17.0.03', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', NOW(), 62, '8:f1d9345092fa7b2269da4794be68a972', 'dropForeignKeyConstraint baseTableName=TEST_STEP, constraintName=fk_test_step__attachment_list; dropColumn columnName=ACTION, tableName=TEST_STEP; dropColumn columnName=EXPECTED_RESULT, tableName=TEST_STEP; dropColumn columnName=ATTACHMENT_LIST_ID...', 'Removes useless comlumns from TEST_STEP', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.17.0.xml::tm-0.17.0.04::gfouquet
--  This table stores "call" tests steps, i.e. steps which call an entire test case
CREATE TABLE CALL_TEST_STEP (TEST_STEP_ID BIGINT NOT NULL COMMENT 'Shared key with TEST_STEP table', CALLED_TEST_CASE_ID BIGINT NOT NULL COMMENT 'ID of called test case', CONSTRAINT pk_call_step PRIMARY KEY (TEST_STEP_ID), CONSTRAINT fk_call_step_test_step FOREIGN KEY (TEST_STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_call_step_called_test_case FOREIGN KEY (CALLED_TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.17.0.04', 'gfouquet', 'tm/tm.changelog-0.17.0.xml', NOW(), 63, '8:c840200146ebff14aaa673695e2c082c', 'createTable tableName=CALL_TEST_STEP', 'This table stores "call" tests steps, i.e. steps which call an entire test case', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.01::ramoussou
--  We have to set campaign_ID and Test_plan_order to "true" to let hibernate persist new items
CREATE TABLE CAMPAIGN_TEST_PLAN_ITEM (CTPI_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'clé primaire du test plan. Devrait être autogénérée.', CAMPAIGN_ID BIGINT NULL COMMENT 'cle etrangere vers CAMPAIGN', TEST_CASE_ID BIGINT NOT NULL COMMENT 'cle etrangere vers TEST_CASE', USER_ID BIGINT NULL COMMENT 'Id de l''utilisateur assigné a ce cas de test reférenncé', TEST_PLAN_ORDER INT NULL COMMENT 'numéro d''ordre d''une execution dans la liste des test plans d''une itération.', CONSTRAINT PK_CAMPAIGN_TEST_PLAN_ITEM PRIMARY KEY (CTPI_ID), CONSTRAINT fk_camp_tp_campaign FOREIGN KEY (CAMPAIGN_ID) REFERENCES CAMPAIGN(CLN_ID), CONSTRAINT fk_camp_tp_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER(ID), CONSTRAINT fk_camp_tp_testcase FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_camptestplan ON CAMPAIGN_TEST_PLAN_ITEM(CTPI_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.19.0.01', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', NOW(), 64, '8:ad46b14330533a66289110f0391edec8', 'createTable tableName=CAMPAIGN_TEST_PLAN_ITEM; createIndex indexName=idx_camptestplan, tableName=CAMPAIGN_TEST_PLAN_ITEM', 'We have to set campaign_ID and Test_plan_order to "true" to let hibernate persist new items', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.02::ramoussou
--  Migrates data from unordered campaign test plan table to ordered test plan table.
--  	 		Items which references (soft) deleted test cases and which should not be in the table are not migrated
insert into CAMPAIGN_TEST_PLAN_ITEM (CAMPAIGN_ID, TEST_CASE_ID)
			select tp.CAMPAIGN_ID, tp.TEST_CASE_ID
			from CAMPAIGN_TEST_PLAN tp
				inner join TEST_CASE_LIBRARY_NODE tc on tc.TCLN_ID = tp.TEST_CASE_ID
			where tc.DELETED_ON is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.19.0.02', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', NOW(), 65, '8:ab232337d4ea59b9517418f86ce936e8', 'sql', 'Migrates data from unordered campaign test plan table to ordered test plan table.
	 		Items which references (soft) deleted test cases and which should not be in the table are not migrated', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.03::ramoussou
--  Calculate and insert and add Not null constraint on order for Campaign Test Plan For H2
--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.04::ramoussou
--  Calculate and insert and add Not null constraint on order for Campaign Test Plan for myssql
CREATE TEMPORARY TABLE `MIGRATION_CAMPAIGN_TEST_PLAN` (
			`TEST_PLAN_ORDER` BIGINT NULL DEFAULT NULL,
			`CAMPAIGN_ID` BIGINT NULL DEFAULT NULL,
			`TEST_CASE_ID` BIGINT NULL DEFAULT NULL,
			`DUMMY` BIGINT NULL DEFAULT NULL
			);

insert into MIGRATION_CAMPAIGN_TEST_PLAN (TEST_PLAN_ORDER, CAMPAIGN_ID, TEST_CASE_ID, DUMMY)
			select if(@prevcamp=CAMPAIGN_ID, @rownum:=@rownum+1, @rownum:=0) TEST_PLAN_ORDER, CAMPAIGN_ID, TEST_CASE_ID, (@prevcamp:=CAMPAIGN_ID)
			from CAMPAIGN_TEST_PLAN_ITEM ctp, (SELECT @rownum:=0) r, (SELECT @prevcamp:=0) c
			order by CAMPAIGN_ID;

update CAMPAIGN_TEST_PLAN_ITEM citp set TEST_PLAN_ORDER =
				(select mctp.TEST_PLAN_ORDER from MIGRATION_CAMPAIGN_TEST_PLAN mctp
				where mctp.CAMPAIGN_ID = citp.CAMPAIGN_ID
				and mctp.TEST_CASE_ID = citp.TEST_CASE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.19.0.04', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', NOW(), 66, '8:8a22997a222ba3d4795b8d3205bb3b3a', 'sql', 'Calculate and insert and add Not null constraint on order for Campaign Test Plan for myssql', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.04-postgres::mpagnon
--  Calculate and insert and add Not null constraint on order for Campaign Test Plan for postgresql
--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.06::ramoussou
--  Drop table CAMPAIGN_TEST_PLAN
DROP TABLE CAMPAIGN_TEST_PLAN;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.19.0.06', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', NOW(), 67, '8:1513496bc6e7e42d55289448d23a5ce1', 'dropTable tableName=CAMPAIGN_TEST_PLAN', 'Drop table CAMPAIGN_TEST_PLAN', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.19.0.xml::tm-0.19.0.07::ramoussou
ALTER TABLE ITEM_TEST_PLAN ADD USER_ID BIGINT NULL COMMENT 'Id de l''utilisateur assigné a ce cas de test reférenncé';

ALTER TABLE ITEM_TEST_PLAN ADD CONSTRAINT fk_itertestplan_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER (ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.19.0.07', 'ramoussou', 'tm/tm.changelog-0.19.0.xml', NOW(), 68, '8:46ca6a04862330a49c334f13e897abf8', 'addColumn tableName=ITEM_TEST_PLAN', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.01::gfouquet
--  The PROJECT_ID foreign key in TEST_CASE_LIBRARY is useless, the useful one is in the PROJECT table
ALTER TABLE TEST_CASE_LIBRARY DROP FOREIGN KEY fk_tcl_project;

ALTER TABLE TEST_CASE_LIBRARY DROP COLUMN PROJECT_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.01', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', NOW(), 69, '8:54c3ebe91db56778cde9e87d8d4d77db', 'dropForeignKeyConstraint baseTableName=TEST_CASE_LIBRARY, constraintName=fk_tcl_project; dropColumn columnName=PROJECT_ID, tableName=TEST_CASE_LIBRARY', 'The PROJECT_ID foreign key in TEST_CASE_LIBRARY is useless, the useful one is in the PROJECT table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.02::gfouquet
--  The PROJECT_ID foreign key in REQUIREMENT_LIBRARY is useless, the useful one is in the PROJECT table
ALTER TABLE REQUIREMENT_LIBRARY DROP FOREIGN KEY fk_rl_project;

ALTER TABLE REQUIREMENT_LIBRARY DROP COLUMN PROJECT_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.02', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', NOW(), 70, '8:f0ef7eed1568f2722690dc4270632b72', 'dropForeignKeyConstraint baseTableName=REQUIREMENT_LIBRARY, constraintName=fk_rl_project; dropColumn columnName=PROJECT_ID, tableName=REQUIREMENT_LIBRARY', 'The PROJECT_ID foreign key in REQUIREMENT_LIBRARY is useless, the useful one is in the PROJECT table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.03::gfouquet
--  The PROJECT_ID foreign key in CAMPAIGN_LIBRARY is useless, the useful one is in the PROJECT table
ALTER TABLE CAMPAIGN_LIBRARY DROP FOREIGN KEY fk_cl_project;

ALTER TABLE CAMPAIGN_LIBRARY DROP COLUMN PROJECT_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.03', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', NOW(), 71, '8:7f782a7a9ea306ffaa6cf58433ab21cb', 'dropForeignKeyConstraint baseTableName=CAMPAIGN_LIBRARY, constraintName=fk_cl_project; dropColumn columnName=PROJECT_ID, tableName=CAMPAIGN_LIBRARY', 'The PROJECT_ID foreign key in CAMPAIGN_LIBRARY is useless, the useful one is in the PROJECT table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.05::bsiri
ALTER TABLE EXECUTION MODIFY ISSUE_LIST_ID BIGINT NULL;

ALTER TABLE EXECUTION_STEP MODIFY ISSUE_LIST_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.05', 'bsiri', 'tm/tm.changelog-0.20.0.xml', NOW(), 72, '8:0969ff7e63508bf077c77d3161274cc6', 'dropNotNullConstraint columnName=ISSUE_LIST_ID, tableName=EXECUTION; dropNotNullConstraint columnName=ISSUE_LIST_ID, tableName=EXECUTION_STEP', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.07::bsiri
--  add an ondelete set null to the fk campaign test plan item  -> core user
ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM DROP FOREIGN KEY fk_camp_tp_user;

ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM ADD CONSTRAINT fk_camp_tp_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER (ID) ON DELETE SET NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.07', 'bsiri', 'tm/tm.changelog-0.20.0.xml', NOW(), 73, '8:2a0ba7e062dba6f26d6b3a92d7583ea5', 'dropForeignKeyConstraint baseTableName=CAMPAIGN_TEST_PLAN_ITEM, constraintName=fk_camp_tp_user; addForeignKeyConstraint baseTableName=CAMPAIGN_TEST_PLAN_ITEM, constraintName=fk_camp_tp_user, referencedTableName=CORE_USER', 'add an ondelete set null to the fk campaign test plan item  -> core user', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.40::gfouquet
--  Replace the ATTACHMENT_LIST_CONTENT table by a FK in ATTACHMENT
ALTER TABLE ATTACHMENT ADD ATTACHMENT_LIST_ID BIGINT NULL;

update ATTACHMENT a set ATTACHMENT_LIST_ID = (select AL_ID from ATTACHMENT_LIST_CONTENT alc where
			alc.ATTACHMENT_ID = a.ATTACHMENT_ID);

DROP TABLE ATTACHMENT_LIST_CONTENT;

ALTER TABLE ATTACHMENT ADD CONSTRAINT fk_attachment_att_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE ATTACHMENT MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.40', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', NOW(), 74, '8:bba76e65c8a5a74eba758644e9772461', 'addColumn tableName=ATTACHMENT; sql; dropTable tableName=ATTACHMENT_LIST_CONTENT; addForeignKeyConstraint baseTableName=ATTACHMENT, constraintName=fk_attachment_att_list, referencedTableName=ATTACHMENT_LIST; addNotNullConstraint columnName=ATTACHM...', 'Replace the ATTACHMENT_LIST_CONTENT table by a FK in ATTACHMENT', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.41::gfouquet
--  Replace the ISSUE_LIST_CONTENT table by a FK in ISSUE
ALTER TABLE ISSUE ADD ISSUE_LIST_ID BIGINT NULL COMMENT 'References the list of issue to which an issue belongs';

update ISSUE i set ISSUE_LIST_ID = (select ISSUE_LIST_ID from ISSUE_LIST_CONTENT ilc where ilc.ISSUE_ID =
			i.ISSUE_ID);

DROP TABLE ISSUE_LIST_CONTENT;

ALTER TABLE ISSUE ADD CONSTRAINT fk_issue_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST (ISSUE_LIST_ID);

ALTER TABLE ISSUE MODIFY ISSUE_LIST_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.41', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', NOW(), 75, '8:725e99af4ddae5c100b82592a8690917', 'addColumn tableName=ISSUE; sql; dropTable tableName=ISSUE_LIST_CONTENT; addForeignKeyConstraint baseTableName=ISSUE, constraintName=fk_issue_issue_list, referencedTableName=ISSUE_LIST; addNotNullConstraint columnName=ISSUE_LIST_ID, tableName=ISSUE', 'Replace the ISSUE_LIST_CONTENT table by a FK in ISSUE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.20.0.xml::tm-0.20.0.42::gfouquet
--  Rename ITEM_TEST_PLAN into ITERATION_TEST_PLAN_ITEM
ALTER TABLE ITEM_TEST_PLAN RENAME ITERATION_TEST_PLAN_ITEM;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.20.0.42', 'gfouquet', 'tm/tm.changelog-0.20.0.xml', NOW(), 76, '8:fbfd69634e8ded997ef0474b29ac9013', 'renameTable newTableName=ITERATION_TEST_PLAN_ITEM, oldTableName=ITEM_TEST_PLAN', 'Rename ITEM_TEST_PLAN into ITERATION_TEST_PLAN_ITEM', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.23.0.xml::tm-0.23.0.01::bsiri
--  remove ProjectManager and TestRunner from the ACL permission table
delete from ACL_GROUP_PERMISSION where ACL_GROUP_ID in 
			(select id from ACL_GROUP where qualified_name='squashtest.acl.group.tm.ProjectManager' 
			or qualified_name='squashtest.acl.group.tm.TestRunner');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.23.0.01', 'bsiri', 'tm/tm.changelog-0.23.0.xml', NOW(), 77, '8:dec41aae12984def474e0c8ba00d0414', 'sql', 'remove ProjectManager and TestRunner from the ACL permission table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.23.0.xml::tm-0.23.0.02::bsiri
--  all users that were ProjectManager or TestRunner on anything are now TestEditor
update ACL_RESPONSIBILITY_SCOPE_ENTRY
			set ACL_GROUP_ID = (select id from ACL_GROUP where qualified_name='squashtest.acl.group.tm.TestEditor')
			where ACL_GROUP_ID in (select id from ACL_GROUP where qualified_name='squashtest.acl.group.tm.ProjectManager' 
									or qualified_name='squashtest.acl.group.tm.TestRunner');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.23.0.02', 'bsiri', 'tm/tm.changelog-0.23.0.xml', NOW(), 78, '8:df0ccbd27da3fa11f2252a61948a5150', 'sql', 'all users that were ProjectManager or TestRunner on anything are now TestEditor', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-0.23.0.xml::tm-0.23.0.03::bsiri
--  remove ProjectManager and TestRunner from the existing acl groups
delete from ACL_GROUP
			where qualified_name='squashtest.acl.group.tm.ProjectManager' 
			or qualified_name='squashtest.acl.group.tm.TestRunner';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-0.23.0.03', 'bsiri', 'tm/tm.changelog-0.23.0.xml', NOW(), 79, '8:e8510b02716b7df4ca8bc71c30b7f762', 'sql', 'remove ProjectManager and TestRunner from the existing acl groups', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.01::gfouquet
--  Corrects status to BLOCKED in EXECUTION table
UPDATE EXECUTION SET EXECUTION_STATUS = 'BLOCKED' WHERE EXECUTION_STATUS='BLOQUED';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.01', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 80, '8:79711f5ccac1251f0be10867d4f9b8d9', 'update tableName=EXECUTION', 'Corrects status to BLOCKED in EXECUTION table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.02::gfouquet
--  Corrects status to BLOCKED in EXECUTION_STEP table
UPDATE EXECUTION_STEP SET EXECUTION_STATUS = 'BLOCKED' WHERE EXECUTION_STATUS='BLOQUED';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.02', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 81, '8:bb74182fc3b1d8ac8e7e5b5bb3bd1e65', 'update tableName=EXECUTION_STEP', 'Corrects status to BLOCKED in EXECUTION_STEP table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.03::gfouquet
--  Corrects status to BLOCKED in EXECUTION_STEP table
UPDATE ITERATION_TEST_PLAN_ITEM SET EXECUTION_STATUS = 'BLOCKED' WHERE EXECUTION_STATUS='BLOQUED';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.03', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 82, '8:2bdda49f84cdd5586893510ee798110d', 'update tableName=ITERATION_TEST_PLAN_ITEM', 'Corrects status to BLOCKED in EXECUTION_STEP table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.04::gfouquet
--  Adds an importance to test cases
ALTER TABLE TEST_CASE ADD IMPORTANCE VARCHAR(20) DEFAULT 'LOW' NOT NULL COMMENT 'The importance of the test case';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.04', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 83, '8:e6a1b1f7191a69c48f641e1e5f859c64', 'addColumn tableName=TEST_CASE', 'Adds an importance to test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.05::gfouquet
--  Adds a auto compute importance property to test cases
ALTER TABLE TEST_CASE ADD IMPORTANCE_AUTO BIT(1) DEFAULT 0 NOT NULL COMMENT 'Should the importance be automatically computed';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.05', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 84, '8:94a92b8fcfbf7311a600a96350337f6e', 'addColumn tableName=TEST_CASE', 'Adds a auto compute importance property to test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.06::gfouquet
--  Adds a TM database version number
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('squashtest.tm.database.version', '1.1.0');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.06', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 85, '8:bbdcf879786a1e72a9b0c46f67ae75d7', 'insert tableName=CORE_CONFIG', 'Adds a TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.07::gfouquet
--  A tree node organizes resources. These are stored in the RESOURCE table
CREATE TABLE `RESOURCE` (RES_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'generated surrogate key', NAME VARCHAR(255) NOT NULL COMMENT 'Resource''s name', `DESCRIPTION` LONGTEXT DEFAULT null NULL COMMENT 'Resource''s description', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'Who created this requirement''s version', CREATED_ON datetime NOT NULL COMMENT 'When this requirement''s version was created', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Who modified this requirement''s version last', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'When this requirement''s version was last modified', CONSTRAINT PK_RESOURCE PRIMARY KEY (RES_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.07', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 86, '8:342f29e07b846b0a75c82fa8abc00bc7', 'createTable tableName=RESOURCE', 'A tree node organizes resources. These are stored in the RESOURCE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.08::gfouquet
--  SIMPLE_RESOURCE stores "concrete" resources with a name and a description
CREATE TABLE SIMPLE_RESOURCE (RES_ID BIGINT NOT NULL COMMENT 'shared key with RESOURCE table', CONSTRAINT pk_simple_resource PRIMARY KEY (RES_ID), CONSTRAINT fk_resource FOREIGN KEY (RES_ID) REFERENCES RESOURCE(RES_ID)) ENGINE = INNODB;

ALTER TABLE REQUIREMENT_FOLDER ADD RES_ID BIGINT NULL COMMENT 'FK to SIMPLE_RESOURCE table';

ALTER TABLE REQUIREMENT_FOLDER ADD CONSTRAINT fk_req_folder_simple_resource FOREIGN KEY (RES_ID) REFERENCES SIMPLE_RESOURCE (RES_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.08', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 87, '8:17221cba8034de0f0634f1626b6f6c9d', 'createTable tableName=SIMPLE_RESOURCE; addColumn tableName=REQUIREMENT_FOLDER', 'SIMPLE_RESOURCE stores "concrete" resources with a name and a description', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.09::gfouquet
--  Moves requirement folder data into SIMPLE_RESOURCE table
insert into RESOURCE (RES_ID, NAME, DESCRIPTION, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON) 
			select f.RLN_ID, NAME, DESCRIPTION, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON
			from REQUIREMENT_LIBRARY_NODE n
			inner join REQUIREMENT_FOLDER f on n.RLN_Id = f.RLN_ID
			where n.DELETED_ON is null;

insert into SIMPLE_RESOURCE (RES_ID) 
			select res.RES_ID
			from REQUIREMENT_LIBRARY_NODE n
			inner join REQUIREMENT_FOLDER f on n.RLN_Id = f.RLN_ID
			inner join RESOURCE res on res.RES_ID = f.RLN_ID
			where n.DELETED_ON is null;

update REQUIREMENT_FOLDER 
			set RES_ID = RLN_ID
			where exists (select 1 from REQUIREMENT_LIBRARY_NODE where REQUIREMENT_LIBRARY_NODE.RLN_ID = REQUIREMENT_FOLDER.RLN_ID and DELETED_ON is null);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.09', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 88, '8:729b3829b5a9762ae664b759726487de', 'sql; sql; sql', 'Moves requirement folder data into SIMPLE_RESOURCE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.10::gfouquet
--  Creates REQUIREMENT_VERSION table in which we store the versions of requirements
CREATE TABLE REQUIREMENT_VERSION (RES_ID BIGINT NOT NULL COMMENT 'shared key with RESOURCE table', REQUIREMENT_ID BIGINT NULL COMMENT 'FK to the requirement. Should not be null but is nullable because of cyclic association REQ - REQ_VER', `REFERENCE` VARCHAR(20) NULL COMMENT 'The requirement''s reference', VERSION_NUMBER INT DEFAULT 1 NULL COMMENT 'This requirement''s version number', CRITICALITY VARCHAR(50) DEFAULT 'UNDEFINED' NOT NULL COMMENT 'Requirement criticality. Althought this field is a variable character, the data will be the text representation of an enumeration', REQUIREMENT_STATUS VARCHAR(50) DEFAULT 'WORK_IN_PROGRESS' NOT NULL, ATTACHMENT_LIST_ID BIGINT NOT NULL COMMENT 'FK to a requirement''s list of attachments', CONSTRAINT pk_requirement_version PRIMARY KEY (RES_ID), CONSTRAINT fk_requirement_version_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_req_version_resource FOREIGN KEY (RES_ID) REFERENCES RESOURCE(RES_ID), CONSTRAINT fk_requirement_version_requirement FOREIGN KEY (REQUIREMENT_ID) REFERENCES REQUIREMENT(RLN_ID)) ENGINE = INNODB;

ALTER TABLE REQUIREMENT_VERSION ADD CONSTRAINT cu_version_of_requirement UNIQUE (REQUIREMENT_ID, VERSION_NUMBER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.10', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 89, '8:75b1b57b1635f22bfb9db311487bb714', 'createTable tableName=REQUIREMENT_VERSION; addUniqueConstraint constraintName=cu_version_of_requirement, tableName=REQUIREMENT_VERSION', 'Creates REQUIREMENT_VERSION table in which we store the versions of requirements', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.11::gfouquet
--  Migrates requirement data into REQUIREMENT_VERSION table
insert into RESOURCE 
				(RES_ID, NAME, DESCRIPTION, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON) 
			select r.RLN_ID, NAME, DESCRIPTION, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON
			from REQUIREMENT_LIBRARY_NODE n
			inner join REQUIREMENT r on n.RLN_Id = r.RLN_ID
			where n.DELETED_ON is null;

insert into REQUIREMENT_VERSION 
				(RES_ID, REQUIREMENT_ID, REFERENCE, CRITICALITY, ATTACHMENT_LIST_ID) 
			select res.RES_ID, r.RLN_ID, REFERENCE, CRITICALITY, ATTACHMENT_LIST_ID
			from REQUIREMENT_LIBRARY_NODE n
			inner join REQUIREMENT r on n.RLN_Id = r.RLN_ID
			inner join RESOURCE res on res.RES_ID = r.RLN_ID
			where n.DELETED_ON is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.11', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 90, '8:09e0e1815b7746adbceb0863d16626b8', 'sql; sql', 'Migrates requirement data into REQUIREMENT_VERSION table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.12::gfouquet
--  Adds the 'latest version' relationship between REQUIREMENT and REQUIREMENT_VERSION tables
ALTER TABLE REQUIREMENT ADD CURRENT_VERSION_ID BIGINT NULL COMMENT 'FK to REQUIREMENT_VERSION linking to the requirement''s latest version. Should not be null but the column is nullable because of cyclic relationship between the tables.';

ALTER TABLE REQUIREMENT ADD CONSTRAINT fk_requirement_current_version FOREIGN KEY (CURRENT_VERSION_ID) REFERENCES REQUIREMENT_VERSION (RES_ID);

update REQUIREMENT r
			set CURRENT_VERSION_ID = (
				select RES_ID 
				from REQUIREMENT_VERSION rv 
				where rv.REQUIREMENT_ID = r.RLN_ID
			);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.12', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 91, '8:4d48b4d8f39e94e6c1e50c4fe6eb1ce5', 'addColumn tableName=REQUIREMENT; sql', 'Adds the ''latest version'' relationship between REQUIREMENT and REQUIREMENT_VERSION tables', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.13::gfouquet
--  Test Cases now cover Requirements versions. We create a new association table and populate it from TEST_CASE_REQUIREMENT_LINK
CREATE TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION (VERIFIED_REQ_VERSION_ID BIGINT NULL COMMENT 'FK to the verified requirement', VERIFYING_TEST_CASE_ID BIGINT NULL COMMENT 'FK to the verifying test case', CONSTRAINT fk_verified_req_version FOREIGN KEY (VERIFIED_REQ_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID), CONSTRAINT fk_verifying_test_case FOREIGN KEY (VERIFYING_TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

insert into TEST_CASE_VERIFIED_REQUIREMENT_VERSION (VERIFYING_TEST_CASE_ID, VERIFIED_REQ_VERSION_ID)
			select TEST_CASE_ID, RES_ID
			from TEST_CASE_REQUIREMENT_LINK tcrl
			inner join REQUIREMENT_VERSION rv on rv.REQUIREMENT_ID = tcrl.REQUIREMENT_ID;

ALTER TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION MODIFY VERIFIED_REQ_VERSION_ID BIGINT NOT NULL;

ALTER TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION MODIFY VERIFYING_TEST_CASE_ID BIGINT NOT NULL;

ALTER TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION ADD CONSTRAINT uc_tc_verifies_req_version UNIQUE (VERIFIED_REQ_VERSION_ID, VERIFYING_TEST_CASE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.13', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 92, '8:9c4699c8a8acaf98c44dd69ef58fef6e', 'createTable tableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION; sql; addNotNullConstraint columnName=VERIFIED_REQ_VERSION_ID, tableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION; addNotNullConstraint columnName=VERIFYING_TEST_CASE_ID, tableName=TEST_CA...', 'Test Cases now cover Requirements versions. We create a new association table and populate it from TEST_CASE_REQUIREMENT_LINK', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.14::gfouquet
--  Trashes the now useless TEST_CASE_REQUIREMENT_LINK table
ALTER TABLE TEST_CASE_REQUIREMENT_LINK DROP FOREIGN KEY fk_tc_req_tc;

ALTER TABLE TEST_CASE_REQUIREMENT_LINK DROP FOREIGN KEY fk_tc_req_req;

DROP TABLE TEST_CASE_REQUIREMENT_LINK;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.14', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 93, '8:bb06fbe90bd75bbe215e7966b280e55a', 'dropForeignKeyConstraint baseTableName=TEST_CASE_REQUIREMENT_LINK, constraintName=fk_tc_req_tc; dropForeignKeyConstraint baseTableName=TEST_CASE_REQUIREMENT_LINK, constraintName=fk_tc_req_req; dropTable tableName=TEST_CASE_REQUIREMENT_LINK', 'Trashes the now useless TEST_CASE_REQUIREMENT_LINK table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.15::bsiri
--  This table is the main table of the event logging system, in other words the history of a business entity. As for Squash TM
--  		version 1.1.0 and until further notice, we log here requirement modifications only. It may grows to log other entities in the future, ie test cases.
--  		Note : the application will fill this table itself, since we don't want triggers in the database.
CREATE TABLE REQUIREMENT_AUDIT_EVENT (EVENT_ID BIGINT AUTO_INCREMENT NOT NULL, REQ_VERSION_ID BIGINT NOT NULL COMMENT 'the ID of the target entity. As for 1.1.0 and until further notice, the target is always a requirement version.', EVENT_DATE datetime NOT NULL COMMENT 'the timestamp of the log entry', AUTHOR VARCHAR(255) NOT NULL COMMENT 'the login of the user who generated the event', CONSTRAINT PK_REQUIREMENT_AUDIT_EVENT PRIMARY KEY (EVENT_ID), CONSTRAINT fk_audit_event_requirement_version FOREIGN KEY (REQ_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.15', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 94, '8:44d2544f57717e78e4b98d69816653b7', 'createTable tableName=REQUIREMENT_AUDIT_EVENT', 'This table is the main table of the event logging system, in other words the history of a business entity. As for Squash TM
		version 1.1.0 and until further notice, we log here requirement modifications only. It may grows to log other entities in...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.16::bsiri
--  It is a child table of REQUIREMENT_AUDIT_EVENT. This table exists for the sole purpose of qualifying a given event in a creation event, as such its content is empty (the sheer presence
--  		of an entry in this table is sufficient)
CREATE TABLE REQUIREMENT_CREATION (EVENT_ID BIGINT NOT NULL COMMENT 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).', CONSTRAINT PK_CREATION_EVENT PRIMARY KEY (EVENT_ID), CONSTRAINT fk_create_audit FOREIGN KEY (EVENT_ID) REFERENCES REQUIREMENT_AUDIT_EVENT(EVENT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.16', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 95, '8:6574b3e3b2628237cf94e751854f48c4', 'createTable tableName=REQUIREMENT_CREATION', 'It is a child table of REQUIREMENT_AUDIT_EVENT. This table exists for the sole purpose of qualifying a given event in a creation event, as such its content is empty (the sheer presence
		of an entry in this table is sufficient)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.17::bsiri
--  This is a child table of REQUIREMENT_AUDIT_EVENT. This table will log updates on the target entity. Not every operations will be logged. 
--  			Note 1 : As for version 1.1.0 and until further notice for the sake of simplicity we log both the former and the new value. It may change in the future.
--  			Note 2 : For technical reasons this table exists in two flavors. The twin table is REQUIREMENT_LARGE_PROPERTY_CHANGE. This table will log standard attributes, 
--  			while the other one will log blobs.
CREATE TABLE REQUIREMENT_PROPERTY_CHANGE (EVENT_ID BIGINT NOT NULL COMMENT 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).', OLD_VALUE VARCHAR(100) NULL, NEW_VALUE VARCHAR(100) NULL, PROPERTY_NAME VARCHAR(100) NULL, CONSTRAINT PK_PPT_CHANGE PRIMARY KEY (EVENT_ID), CONSTRAINT fk_PPT_change_audit FOREIGN KEY (EVENT_ID) REFERENCES REQUIREMENT_AUDIT_EVENT(EVENT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.17', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 96, '8:1d1e9e5f9fa68541dc488dc7721a3cbc', 'createTable tableName=REQUIREMENT_PROPERTY_CHANGE', 'This is a child table of REQUIREMENT_AUDIT_EVENT. This table will log updates on the target entity. Not every operations will be logged. 
			Note 1 : As for version 1.1.0 and until further notice for the sake of simplicity we log both the former a...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.18::bsiri
--  This is a child table of REQUIREMENT_AUDIT_EVENT. This table will log updates on the target entity. Not every operations will be logged. 
--  			Note 1 : As for version 1.1.0 and until further notice for the sake of simplicity we log both the former and the new value. It may change in the future.
--  			Note 2 : For technical reasons this table exists in two flavors. The twin table is REQUIREMENT_PROPERTY_CHANGE. This table will log blobs, 
--  			while the other one will log standard attributes.
CREATE TABLE REQUIREMENT_LARGE_PROPERTY_CHANGE (EVENT_ID BIGINT NOT NULL COMMENT 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).', OLD_VALUE LONGTEXT DEFAULT null NULL, NEW_VALUE LONGTEXT DEFAULT null NULL, PROPERTY_NAME VARCHAR(100) NULL, CONSTRAINT PK_LARGE_PPT_CHANGE PRIMARY KEY (EVENT_ID), CONSTRAINT fk_lPPT_change_audit FOREIGN KEY (EVENT_ID) REFERENCES REQUIREMENT_AUDIT_EVENT(EVENT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.18', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 97, '8:309bef213b6d1d108841560a4246d15e', 'createTable tableName=REQUIREMENT_LARGE_PROPERTY_CHANGE', 'This is a child table of REQUIREMENT_AUDIT_EVENT. This table will log updates on the target entity. Not every operations will be logged. 
			Note 1 : As for version 1.1.0 and until further notice for the sake of simplicity we log both the former a...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.19::bsiri
--  Will immediately update the tables with the create_events of existing requirements.
insert into REQUIREMENT_AUDIT_EVENT (REQ_VERSION_ID, EVENT_DATE, AUTHOR) 
			select rv.RES_ID, CREATED_ON, CREATED_BY  
			from REQUIREMENT_VERSION rv 
			inner join RESOURCE r on r.RES_ID = rv.RES_ID;

insert into REQUIREMENT_CREATION (event_id) select event_id from REQUIREMENT_AUDIT_EVENT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.19', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 98, '8:a1c790a9625973f23e6486620edb3ef5', 'sql; sql', 'Will immediately update the tables with the create_events of existing requirements.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.20::gfouquet
--  Remove obsolete columns from REQUIREMENT and REQUIREMENT_LIBRARY_NODE table. 
--  			Data is now in REQUIREMENT_VERSION and REQUIREMENT_FOLDER tables.
ALTER TABLE REQUIREMENT DROP COLUMN `REFERENCE`;

ALTER TABLE REQUIREMENT DROP COLUMN CRITICALITY;

ALTER TABLE REQUIREMENT DROP FOREIGN KEY fk_requirement_attachment_list;

ALTER TABLE REQUIREMENT DROP COLUMN ATTACHMENT_LIST_ID;

ALTER TABLE REQUIREMENT_LIBRARY_NODE DROP COLUMN NAME;

ALTER TABLE REQUIREMENT_LIBRARY_NODE DROP COLUMN `DESCRIPTION`;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.20', 'gfouquet', 'tm/tm.changelog-1.1.0.xml', NOW(), 99, '8:88439c6c1d08d203621902dd7c5b4700', 'dropColumn columnName=REFERENCE, tableName=REQUIREMENT; dropColumn columnName=CRITICALITY, tableName=REQUIREMENT; dropForeignKeyConstraint baseTableName=REQUIREMENT, constraintName=fk_requirement_attachment_list; dropColumn columnName=ATTACHMENT_L...', 'Remove obsolete columns from REQUIREMENT and REQUIREMENT_LIBRARY_NODE table. 
			Data is now in REQUIREMENT_VERSION and REQUIREMENT_FOLDER tables.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.21::fogaillard
--  Add Prerequisite collumn to the test_case table
ALTER TABLE TEST_CASE ADD PREREQUISITE LONGTEXT DEFAULT null NULL COMMENT 'the prerequisite for a test_case';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.21', 'fogaillard', 'tm/tm.changelog-1.1.0.xml', NOW(), 100, '8:03bf284d5de34979ee98fcac237c5185', 'addColumn tableName=TEST_CASE', 'Add Prerequisite collumn to the test_case table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.22::bsiri
--  Add the table TEST_SUITE. A TEST_SUITE is basically a view on a subset of ITERATION_TEST_PLAN_ITEMs.
CREATE TABLE TEST_SUITE (ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(100) NULL, `DESCRIPTION` LONGTEXT DEFAULT null NULL, ATTACHMENT_LIST_ID BIGINT NOT NULL, CREATED_BY VARCHAR(50) NOT NULL COMMENT 'Who created this test suite', CREATED_ON datetime NOT NULL COMMENT 'When this test suite was created', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Who modified this test suite last', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'When this test suite was last modified', CONSTRAINT PK_TEST_SUITE PRIMARY KEY (ID), CONSTRAINT fk_test_suite_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.22', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 101, '8:75a63f617964c60504d4b4f74538326b', 'createTable tableName=TEST_SUITE', 'Add the table TEST_SUITE. A TEST_SUITE is basically a view on a subset of ITERATION_TEST_PLAN_ITEMs.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.23::bsiri
--  Association table between ITERATION and TEST_SUITE. Like in many other places here, the purpose of this association table is not to model a n-n cardinality between ITERATION and 
--  			TEST_SUITE, but 1-n. We thus gain performance at the expense of the model quality.
CREATE TABLE ITERATION_TEST_SUITE (ITERATION_ID BIGINT NOT NULL, TEST_SUITE_ID BIGINT NOT NULL, CONSTRAINT fk_iteration_test_suite_suite FOREIGN KEY (TEST_SUITE_ID) REFERENCES TEST_SUITE(ID), CONSTRAINT fk_iteration_test_suite_iteration FOREIGN KEY (ITERATION_ID) REFERENCES ITERATION(ITERATION_ID), UNIQUE (TEST_SUITE_ID)) ENGINE = INNODB;

CREATE INDEX dx_iteration_test_suite_iteration ON ITERATION_TEST_SUITE(ITERATION_ID);

CREATE INDEX dx_iteration_test_suite_suite ON ITERATION_TEST_SUITE(TEST_SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.23', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 102, '8:63216caca4ea5bc08a3dd61771acfd15', 'createTable tableName=ITERATION_TEST_SUITE; createIndex indexName=dx_iteration_test_suite_iteration, tableName=ITERATION_TEST_SUITE; createIndex indexName=dx_iteration_test_suite_suite, tableName=ITERATION_TEST_SUITE', 'Association table between ITERATION and TEST_SUITE. Like in many other places here, the purpose of this association table is not to model a n-n cardinality between ITERATION and 
			TEST_SUITE, but 1-n. We thus gain performance at the expense of t...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.24::bsiri
--  Hereby an ITERATION_TEST_PLAN_ITEM shalt reference 0 or 1 TEST_SUITE
ALTER TABLE ITERATION_TEST_PLAN_ITEM ADD TEST_SUITE BIGINT DEFAULT null NULL;

ALTER TABLE ITERATION_TEST_PLAN_ITEM ADD CONSTRAINT fk_itpi_testsuite FOREIGN KEY (TEST_SUITE) REFERENCES TEST_SUITE (ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.24', 'bsiri', 'tm/tm.changelog-1.1.0.xml', NOW(), 103, '8:69633e16af59a99ff6f92ca1c17cc960', 'addColumn tableName=ITERATION_TEST_PLAN_ITEM', 'Hereby an ITERATION_TEST_PLAN_ITEM shalt reference 0 or 1 TEST_SUITE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.1.0.xml::tm-1.1.0.25::fogaillard
--  Add Prerequisite collumn to the execution table
ALTER TABLE EXECUTION ADD PREREQUISITE LONGTEXT DEFAULT null NULL COMMENT 'the prerequisite for a test_case execution';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.1.0.25', 'fogaillard', 'tm/tm.changelog-1.1.0.xml', NOW(), 104, '8:64beff4d7a26329a9dc5fb98a5f5a797', 'addColumn tableName=EXECUTION', 'Add Prerequisite collumn to the execution table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.32::mpagnon
INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.ProjectManager');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '32', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.32', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 105, '8:ea6c2c957bd92325cba5ee9c85c3f71a', 'insert tableName=ACL_GROUP; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-1::mpagnon
--  add acl-class and acl-groups
INSERT INTO ACL_CLASS (CLASSNAME) VALUES ('org.squashtest.csp.tm.domain.requirement.RequirementLibrary');

INSERT INTO ACL_CLASS (CLASSNAME) VALUES ('org.squashtest.csp.tm.domain.testcase.TestCaseLibrary');

INSERT INTO ACL_CLASS (CLASSNAME) VALUES ('org.squashtest.csp.tm.domain.campaign.CampaignLibrary');

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.TestRunner');

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.TestDesigner');

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.AdvanceTester');

INSERT INTO ACL_GROUP (QUALIFIED_NAME) VALUES ('squashtest.acl.group.tm.Validator');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-1', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 106, '8:df895c0ab60666290d00fcc5d85b4350', 'insert tableName=ACL_CLASS; insert tableName=ACL_CLASS; insert tableName=ACL_CLASS; insert tableName=ACL_GROUP; insert tableName=ACL_GROUP; insert tableName=ACL_GROUP; insert tableName=ACL_GROUP', 'add acl-class and acl-groups', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-2::mpagnon
--  remove existing permissions and redefine them
TRUNCATE TABLE ACL_GROUP_PERMISSION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-2', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 107, '8:0a20e77cd60ff8192cb3f4eab1fd1330', 'sql', 'remove existing permissions and redefine them', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-3::mpagnon
--  ProjectManager / Project
--  ProjectManager / RequirementLibrary
--  ProjectManager / TestCaseLibrary
--  ProjectManager / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '32', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '512', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '512', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '128', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-3', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 108, '8:2c4154d3dedd5a2d5ad03d815625f719', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'ProjectManager / Project
ProjectManager / RequirementLibrary
ProjectManager / TestCaseLibrary
ProjectManager / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-4::mpagnon
--  TestEditor / Project
--  TestEditor / RequirementLibrary
--  TestEditor / TestCaseLibrary
--  TestEditor / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '128', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-4', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 109, '8:80fc9728f9ecf5729d91d51a55683db5', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'TestEditor / Project
TestEditor / RequirementLibrary
TestEditor / TestCaseLibrary
TestEditor / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-5::mpagnon
--  ProjectViewer / Project
--  ProjectViewer / RequirementLibrary
--  ProjectViewer / TestCaseLibrary
--  ProjectViewer / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectViewer'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectViewer'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectViewer'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectViewer'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-5', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 110, '8:442fecf2d0d1649958c7cf17e0150f14', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', 'ProjectViewer / Project
ProjectViewer / RequirementLibrary
ProjectViewer / TestCaseLibrary
ProjectViewer / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-6::mpagnon
--  TestRunner / RequirementLibrary
--  TestRunner / TestCaseLibrary
--  TestRunner / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '128', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-6', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 111, '8:e9a6938cb60760fbc4f1a7ae6ebae60c', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', 'TestRunner / RequirementLibrary
TestRunner / TestCaseLibrary
TestRunner / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-7::mpagnon
--  TestDesigner / Project
--  TestDesigner / RequirementLibrary
--  TestDesigner / TestCaseLibrary
--  TestDesigner / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-7', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 112, '8:5196f954a29ec7833620d2d2d8001690', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'TestDesigner / Project
TestDesigner / RequirementLibrary
TestDesigner / TestCaseLibrary
TestDesigner / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-8::mpagnon
--  AdvanceTester / Project
--  AdvanceTester / RequirementLibrary
--  AdvanceTester / TestCaseLibrary
--  AdvanceTester / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '128', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-8', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 113, '8:0a85c048a69744ab0eff91190e40fe75', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableN...', 'AdvanceTester / Project
AdvanceTester / RequirementLibrary
AdvanceTester / TestCaseLibrary
AdvanceTester / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-9::mpagnon
--  Validator / Project
--  Validator / RequirementLibrary
--  Validator / TestCaseLibrary
--  Validator / CampaignLibrary
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-9', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 114, '8:5b83193a8c1b7b387f50935278853e20', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION', 'Validator / Project
Validator / RequirementLibrary
Validator / TestCaseLibrary
Validator / CampaignLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-10::mpagnon
--  Existing Data Update: Delete acls for deleted projects in 1.1.1
DELETE FROM ACL_RESPONSIBILITY_SCOPE_ENTRY
			 WHERE OBJECT_IDENTITY_ID not in (
				select aoi.ID from  ACL_OBJECT_IDENTITY aoi, ACL_CLASS ac , PROJECT p
				where ac.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project' 
				and ac.ID = aoi.CLASS_ID
				and aoi.IDENTITY = p.PROJECT_ID
			);

DELETE FROM ACL_OBJECT_IDENTITY
			WHERE IDENTITY not in (
				select  p.PROJECT_ID from PROJECT p
			)
			and CLASS_ID in (
				select ac.ID from ACL_CLASS ac where ac.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project' 
			);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-10', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 115, '8:7166ec234158f10ae406f272eb810666', 'sql; sql', 'Existing Data Update: Delete acls for deleted projects in 1.1.1', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-11::mpagnon
--  Existing Data Update for ACL_OBJECT_IDENTITY / REQUIREMENT_LIBRARY
insert into ACL_OBJECT_IDENTITY (IDENTITY, CLASS_ID)
			select p.RL_ID, ac2.ID
			from  ACL_CLASS ac1, ACL_CLASS ac2, PROJECT p, ACL_OBJECT_IDENTITY aoi
			where ac2.CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary'
			and p.PROJECT_ID = aoi.IDENTITY
			and aoi.CLASS_ID = ac1.ID 
			and ac1.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-11', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 116, '8:12fca5f06a2e5c12fad9adde57337512', 'sql', 'Existing Data Update for ACL_OBJECT_IDENTITY / REQUIREMENT_LIBRARY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-12::mpagnon
--  Existing Data Update for ACL_OBJECT_IDENTITY / TEST_CASE_LIBRARY
insert into ACL_OBJECT_IDENTITY (IDENTITY, CLASS_ID)
			select p.TCL_ID, ac2.ID
			from  ACL_CLASS ac1, ACL_CLASS ac2, PROJECT p, ACL_OBJECT_IDENTITY aoi
			where ac2.CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary'
			and p.PROJECT_ID = aoi.IDENTITY
			and aoi.CLASS_ID = ac1.ID 
			and ac1.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-12', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 117, '8:450b3049fc6157e097e52ca7e1b138e7', 'sql', 'Existing Data Update for ACL_OBJECT_IDENTITY / TEST_CASE_LIBRARY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-13::mpagnon
--  Existing Data Update for ACL_OBJECT_IDENTITY / CAMPAIGN_LIBRARY
insert into ACL_OBJECT_IDENTITY (IDENTITY, CLASS_ID)
			select p.CL_ID, ac2.ID
			from  ACL_CLASS ac1, ACL_CLASS ac2, PROJECT p, ACL_OBJECT_IDENTITY aoi
			where ac2.CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary'
			and p.PROJECT_ID = aoi.IDENTITY
			and aoi.CLASS_ID = ac1.ID 
			and ac1.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-13', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 118, '8:4455aaa5dff6c7c21a1247ec49da92cd', 'sql', 'Existing Data Update for ACL_OBJECT_IDENTITY / CAMPAIGN_LIBRARY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-14::mpagnon
--  Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / REQUIREMENT_LIBRARY
insert into ACL_RESPONSIBILITY_SCOPE_ENTRY (USER_ID, ACL_GROUP_ID, OBJECT_IDENTITY_ID)
			select arse.USER_ID, arse.ACL_GROUP_ID, aoiRequirement.ID
			from ACL_RESPONSIBILITY_SCOPE_ENTRY arse, ACL_OBJECT_IDENTITY aoiProject, ACL_CLASS aclassProject, ACL_OBJECT_IDENTITY aoiRequirement, ACL_CLASS aclassRequirement, PROJECT p
			where arse.OBJECT_IDENTITY_ID = aoiProject.ID
			and aoiProject.CLASS_ID = aclassProject.ID
			and aclassProject.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'
			and p.PROJECT_ID = aoiProject.IDENTITY
			and aoiRequirement.IDENTITY = p.RL_ID
			and aoiRequirement.CLASS_ID = aclassRequirement.ID
			and aclassRequirement.CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-14', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 119, '8:44f2b72ee88e0aa842f272db57e0d15c', 'sql', 'Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / REQUIREMENT_LIBRARY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-15::mpagnon
--  Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / TEST_CASE_LIBRARY
insert into ACL_RESPONSIBILITY_SCOPE_ENTRY (USER_ID, ACL_GROUP_ID, OBJECT_IDENTITY_ID)
			select arse.USER_ID, arse.ACL_GROUP_ID, aoiTestCase.ID
			from ACL_RESPONSIBILITY_SCOPE_ENTRY arse, ACL_OBJECT_IDENTITY aoiProject, ACL_CLASS aclassProject, ACL_OBJECT_IDENTITY aoiTestCase, ACL_CLASS aclassTestCase, PROJECT p
			where arse.OBJECT_IDENTITY_ID = aoiProject.ID
			and aoiProject.CLASS_ID = aclassProject.ID
			and aclassProject.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'
			and p.PROJECT_ID = aoiProject.IDENTITY
			and aoiTestCase.IDENTITY = p.TCL_ID
			and aoiTestCase.CLASS_ID = aclassTestCase.ID
			and aclassTestCase.CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-15', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 120, '8:9f26b152572e99793d1ac6816a43c81d', 'sql', 'Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / TEST_CASE_LIBRARY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.34-16::mpagnon
--  Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / CAMPAIGN_LIBRARY
insert into ACL_RESPONSIBILITY_SCOPE_ENTRY (USER_ID, ACL_GROUP_ID, OBJECT_IDENTITY_ID)
			select arse.USER_ID, arse.ACL_GROUP_ID, aoiCampaign.ID
			from ACL_RESPONSIBILITY_SCOPE_ENTRY arse, ACL_OBJECT_IDENTITY aoiProject, ACL_CLASS aclassProject, ACL_OBJECT_IDENTITY aoiCampaign, ACL_CLASS aclassCampaign, PROJECT p
			where arse.OBJECT_IDENTITY_ID = aoiProject.ID
			and aoiProject.CLASS_ID = aclassProject.ID
			and aclassProject.CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project'
			and p.PROJECT_ID = aoiProject.IDENTITY
			and aoiCampaign.IDENTITY = p.CL_ID
			and aoiCampaign.CLASS_ID = aclassCampaign.ID
			and aclassCampaign.CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.34-16', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 121, '8:0bb69c3d56cfb4e35be396ac5e58c112', 'sql', 'Existing Data Update for ACL_RESPONSIBILITY_SCOPE_ENTRY / CAMPAIGN_LIBRARY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.35-01::bsiri
--  table ISSUE nows holds the bugtracker name where the remote issues are hosted
ALTER TABLE ISSUE ADD BT_NAME VARCHAR(60) NULL;

UPDATE ISSUE SET BT_NAME = 'default';

ALTER TABLE ISSUE MODIFY BT_NAME VARCHAR(60) NOT NULL;

CREATE INDEX idx_bt_name ON ISSUE(BT_NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.35-01', 'bsiri', 'tm/tm.changelog-1.2.0.xml', NOW(), 122, '8:e747523846c5ed292fb6c7bfb9740da1', 'addColumn tableName=ISSUE; createIndex indexName=idx_bt_name, tableName=ISSUE', 'table ISSUE nows holds the bugtracker name where the remote issues are hosted', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.36-01::mpagnon
--  table RequirementVersion nows holds a Category attribute
ALTER TABLE REQUIREMENT_VERSION ADD CATEGORY VARCHAR(50) DEFAULT 'UNDEFINED' NOT NULL COMMENT 'Requirement category. Althought this field is a variable character, the data will be the text representation of an enumeration';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.36-01', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 123, '8:25ffc75b0ead3aa18d43d3d241262ca9', 'addColumn tableName=REQUIREMENT_VERSION', 'table RequirementVersion nows holds a Category attribute', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.2.0.xml::tm-1.2.0.36-02::mpagnon
--  table Test-Case nows holds a Reference attribute
ALTER TABLE TEST_CASE ADD `REFERENCE` VARCHAR(20) DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.2.0.36-02', 'mpagnon', 'tm/tm.changelog-1.2.0.xml', NOW(), 124, '8:5e1f96983c7cb1a0e83ae376619c3f84', 'addColumn tableName=TEST_CASE', 'table Test-Case nows holds a Reference attribute', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0.01::gfouquet
--  Adds a TM database version number
UPDATE CORE_CONFIG SET STR_KEY = 'squashtest.tm.database.version', VALUE = '1.3.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0.01', 'gfouquet', 'tm/tm.changelog-1.3.0.xml', NOW(), 125, '8:d67bb6124a9935b8167b1b4662927757', 'update tableName=CORE_CONFIG', 'Adds a TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0.2::gfouquet
--  Add a default group to users who do not have one (should be users from alpha versions)
create temporary table GROUPLESS_USERS (USER_ID INTEGER);

insert
			into GROUPLESS_USERS (USER_ID)
			select cu.ID from CORE_USER cu
			where
			cu.ID not in (select cgm.USER_ID from CORE_GROUP_MEMBER cgm);

insert
			into CORE_GROUP_MEMBER (USER_ID, GROUP_ID)
			select cu.ID, cg.ID
			from
			CORE_USER cu, CORE_GROUP cg
			where cg.QUALIFIED_NAME =
			'squashtest.tm.group.User'
			and cu.ID in (select USER_ID from
			GROUPLESS_USERS);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0.2', 'gfouquet', 'tm/tm.changelog-1.3.0.xml', NOW(), 126, '8:0ec33fb5aa2c59df7bfc6cdc8cddfff0', 'sql', 'Add a default group to users who do not have one (should be users from alpha versions)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.0::bsiri
--  The following serie of changeset labelled tm-1.3-feat-1112.x implements the closure table
--  			modelization for tree-like data	at
--  			http://www.mysqlperformanceblog.com/2011/02/14/moving-subtrees-in-closure-table/,
--  			with a focus on the mysql-specifics shortcomings regarding modifying a table already
--  			under modification.
--  
--  			Big kudos to you Bill Karwin !
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.0', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 127, '8:d41d8cd98f00b204e9800998ecf8427e', 'empty', 'The following serie of changeset labelled tm-1.3-feat-1112.x implements the closure table
			modelization for tree-like data	at
			http://www.mysqlperformanceblog.com/2011/02/14/moving-subtrees-in-closure-table/,
			with a focus on the mysql-speci...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.01::bsiri
--  closure table for test case library nodes. Its content is set and modified by four triggers, see
--  			changeset 'tm-1.3-feat-1112.05-mysql' or 'tm-1.3-feat-1112.05-h2'.
CREATE TABLE TCLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_tcln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES TEST_CASE_LIBRARY_NODE(TCLN_ID), CONSTRAINT fk_tcln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES TEST_CASE_LIBRARY_NODE(TCLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_tcln_relationship_clos_desc ON TCLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_tcln_relationship_clos_anc ON TCLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 128, '8:b6e7e58a746810a5b5f47ff5b7eba060', 'createTable tableName=TCLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_tcln_relationship_clos_desc, tableName=TCLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_tcln_relationship_clos_anc, tableName=TCLN_RELATIONSHIP_CLOSURE', 'closure table for test case library nodes. Its content is set and modified by four triggers, see
			changeset ''tm-1.3-feat-1112.05-mysql'' or ''tm-1.3-feat-1112.05-h2''.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.02::bsiri
--  closure table for requirement library nodes. Its content is set and modified by four triggers, see
--  			changeset 'tm-1.3-feat-1112.06-mysql' or 'tm-1.3-feat-1112.06-h2'.
CREATE TABLE RLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_rln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES REQUIREMENT_LIBRARY_NODE(RLN_ID), CONSTRAINT fk_rln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES REQUIREMENT_LIBRARY_NODE(RLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_rln_relationship_clos_desc ON RLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_rln_relationship_clos_anc ON RLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 129, '8:5f2965c6052880bcc7b620a324442bef', 'createTable tableName=RLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_rln_relationship_clos_desc, tableName=RLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_rln_relationship_clos_anc, tableName=RLN_RELATIONSHIP_CLOSURE', 'closure table for requirement library nodes. Its content is set and modified by four triggers, see
			changeset ''tm-1.3-feat-1112.06-mysql'' or ''tm-1.3-feat-1112.06-h2''.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.03::bsiri
--  closure table for campaign library nodes. Its content is set and modified by four triggers, see
--  			changeset 'tm-1.3-feat-1112.07-mysql' or 'tm-1.3-feat-1112.07-h2'.
CREATE TABLE CLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_cln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID), CONSTRAINT fk_cln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_cln_relationship_clos_desc ON CLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_cln_relationship_clos_anc ON CLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.03', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 130, '8:c0f7ef97f02b9034218ee874a8e37664', 'createTable tableName=CLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_cln_relationship_clos_desc, tableName=CLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_cln_relationship_clos_anc, tableName=CLN_RELATIONSHIP_CLOSURE', 'closure table for campaign library nodes. Its content is set and modified by four triggers, see
			changeset ''tm-1.3-feat-1112.07-mysql'' or ''tm-1.3-feat-1112.07-h2''.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.04::bsiri
--  first step of the migration : creation of temporary tables in which we will dump
--  			the X_RELATIONSHIP tables, then truncate the later. We will reinsert the data once
--  			the triggers are all set.
CREATE TABLE TCLN_RELATIONSHIP_TMP (ANCESTOR_ID BIGINT NULL, DESCENDANT_ID BIGINT NULL) ENGINE = INNODB;

CREATE TABLE RLN_RELATIONSHIP_TMP (ANCESTOR_ID BIGINT NULL, DESCENDANT_ID BIGINT NULL) ENGINE = INNODB;

CREATE TABLE CLN_RELATIONSHIP_TMP (ANCESTOR_ID BIGINT NULL, DESCENDANT_ID BIGINT NULL) ENGINE = INNODB;

insert into TCLN_RELATIONSHIP_TMP
			select * from TCLN_RELATIONSHIP;

insert into RLN_RELATIONSHIP_TMP
			select * from RLN_RELATIONSHIP;

insert into CLN_RELATIONSHIP_TMP
			select * from CLN_RELATIONSHIP;

delete from TCLN_RELATIONSHIP;

delete from RLN_RELATIONSHIP;

delete from CLN_RELATIONSHIP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.04', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 131, '8:82390dab2ef8d88d92b5633ceaa105e1', 'createTable tableName=TCLN_RELATIONSHIP_TMP; createTable tableName=RLN_RELATIONSHIP_TMP; createTable tableName=CLN_RELATIONSHIP_TMP; sql; sql; sql; sql; sql; sql', 'first step of the migration : creation of temporary tables in which we will dump
			the X_RELATIONSHIP tables, then truncate the later. We will reinsert the data once
			the triggers are all set.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.05-mysql::bsiri
--  mysql-triggers for TCLN_RELATIONSHIP_CLOSURE table
create trigger ins_tcln_after after insert on
			TEST_CASE_LIBRARY_NODE
			for each row insert into
			TCLN_RELATIONSHIP_CLOSURE values (new.tcln_id, new.tcln_id, 0);

create trigger del_tcln_before before delete on
			TEST_CASE_LIBRARY_NODE
			for each row delete from
			TCLN_RELATIONSHIP_CLOSURE where ancestor_id=old.tcln_id and
			descendant_id=old.tcln_id;

create trigger attach_tcln_after after insert on
			TCLN_RELATIONSHIP
			for each row insert into TCLN_RELATIONSHIP_CLOSURE
			select c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
			from
			TCLN_RELATIONSHIP_CLOSURE c1
			cross join TCLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id =
			new.descendant_id;

create trigger detach_tcln_before before delete on
			TCLN_RELATIONSHIP
			for each row delete clos1 from
			TCLN_RELATIONSHIP_CLOSURE clos1
			join TCLN_RELATIONSHIP_CLOSURE clos2
			on clos1.descendant_id=clos2.descendant_id
			left join
			TCLN_RELATIONSHIP_CLOSURE clos3
			on clos3.ancestor_id =
			clos2.ancestor_id
			and clos3.descendant_id = clos1.ancestor_id
			where
			clos2.ancestor_id = old.descendant_id
			and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.05-mysql', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 132, '8:17123de05225585b1b9cc62306b44334', 'sql; sql; sql; sql', 'mysql-triggers for TCLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.06-mysql::bsiri
--  mysql-triggers for RLN_RELATIONSHIP_CLOSURE table
create trigger ins_rln_after after insert on
			REQUIREMENT_LIBRARY_NODE
			for each row insert into
			RLN_RELATIONSHIP_CLOSURE values (new.rln_id, new.rln_id, 0);

create trigger del_rln_before before delete on
			REQUIREMENT_LIBRARY_NODE
			for each row delete from
			RLN_RELATIONSHIP_CLOSURE where ancestor_id=old.rln_id and
			descendant_id=old.rln_id;

create trigger attach_rln_after after insert on RLN_RELATIONSHIP
			for each row insert into RLN_RELATIONSHIP_CLOSURE
			select
			c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
			from
			RLN_RELATIONSHIP_CLOSURE c1
			cross join RLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id =
			new.descendant_id;

create trigger detach_rln_before before delete on
			RLN_RELATIONSHIP
			for each row delete clos1
            from RLN_RELATIONSHIP_CLOSURE clos1

            join RLN_RELATIONSHIP_CLOSURE clos2
			on clos1.descendant_id=clos2.descendant_id

            left join RLN_RELATIONSHIP_CLOSURE clos3
			on clos3.ancestor_id = clos2.ancestor_id
			and clos3.descendant_id = clos1.ancestor_id

            where clos2.ancestor_id = old.descendant_id
			and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.06-mysql', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 133, '8:5ee5e18c073ca7ac1880dc5f9470ddb8', 'sql; sql; sql; sql', 'mysql-triggers for RLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.07-mysql::bsiri
--  mysql-triggers for CLN_RELATIONSHIP_CLOSURE table
create trigger ins_cln_after after insert on
			CAMPAIGN_LIBRARY_NODE
			for each row insert into
			CLN_RELATIONSHIP_CLOSURE values (new.cln_id, new.cln_id, 0);

create trigger del_cln_before before delete on
			CAMPAIGN_LIBRARY_NODE
			for each row delete from
			CLN_RELATIONSHIP_CLOSURE where ancestor_id=old.cln_id and
			descendant_id=old.cln_id;

create trigger attach_cln_after after insert on CLN_RELATIONSHIP
			for each row insert into CLN_RELATIONSHIP_CLOSURE
			select
			c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
			from
			CLN_RELATIONSHIP_CLOSURE c1
			cross join CLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id = new.descendant_id;

create trigger detach_cln_before before delete on
			CLN_RELATIONSHIP
			for each row delete clos1 from
			CLN_RELATIONSHIP_CLOSURE clos1
			join CLN_RELATIONSHIP_CLOSURE clos2
			on
			clos1.descendant_id=clos2.descendant_id
			left join
			CLN_RELATIONSHIP_CLOSURE clos3
			on clos3.ancestor_id = clos2.ancestor_id
			and clos3.descendant_id = clos1.ancestor_id
			where
			clos2.ancestor_id = old.descendant_id
			and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.07-mysql', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 134, '8:53d0b3d696f4e77145aa14e4fe55ecc4', 'sql; sql; sql; sql', 'mysql-triggers for CLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.08::bsiri
--  this step is mandatory if we want the next one to work (triggers need the nodes to have self-reference in the closure tables)
insert into TCLN_RELATIONSHIP_CLOSURE
			select tcln_id, tcln_id, 0
			from TEST_CASE_LIBRARY_NODE
			where deleted_on is null;

insert into RLN_RELATIONSHIP_CLOSURE
			select rln_id, rln_id, 0
			from
			REQUIREMENT_LIBRARY_NODE
			where deleted_on is null;

insert into CLN_RELATIONSHIP_CLOSURE
			select cln_id, cln_id, 0
			from
			CAMPAIGN_LIBRARY_NODE
			where deleted_on is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.08', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 135, '8:5f54649ea2e1588ab1b315322a5f4a66', 'sql; sql; sql', 'this step is mandatory if we want the next one to work (triggers need the nodes to have self-reference in the closure tables)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.09::bsiri
--  we can now reinsert our data from the tmp tables and let the triggers do the job
insert into TCLN_RELATIONSHIP
			select * from TCLN_RELATIONSHIP_TMP;

insert into RLN_RELATIONSHIP
			select * from RLN_RELATIONSHIP_TMP;

insert into CLN_RELATIONSHIP
			select * from CLN_RELATIONSHIP_TMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.09', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 136, '8:1094739e703332e8b458be2316f88e61', 'sql; sql; sql', 'we can now reinsert our data from the tmp tables and let the triggers do the job', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1112.10::bsiri
--  If success, we can now drop our temp tables and complete the migration
DROP TABLE TCLN_RELATIONSHIP_TMP;

DROP TABLE RLN_RELATIONSHIP_TMP;

DROP TABLE CLN_RELATIONSHIP_TMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1112.10', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 137, '8:ac6c51cee3c0dacc8f67971cb3ac85a2', 'dropTable tableName=TCLN_RELATIONSHIP_TMP; dropTable tableName=RLN_RELATIONSHIP_TMP; dropTable tableName=CLN_RELATIONSHIP_TMP', 'If success, we can now drop our temp tables and complete the migration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1209.01::mpagnon
--  To connect Squash TM to a bugtracker, you must provide the name and the url of the bugtracker. The mantis plugin is shipped with the application
--  	 IFRAME_FRIENDLY :tells if the bugtracker page can be accessed through an iframe : if the response header of the bugtracker page has the property [X-Frame-Options = DENY] the answer is false
--  	 URL : must point to the base name of the end point. Eg : http://www.yourdomain.com/mantis . Tips : Prefer IPs over localhost and domain names over IPs. If you don't some minor issues may occur when reporting an issue.
CREATE TABLE BUGTRACKER (BUGTRACKER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, should be auto-generated.', NAME VARCHAR(50) NOT NULL COMMENT 'identifies the instance configured.', KIND VARCHAR(50) DEFAULT 'mantis' NOT NULL COMMENT 'tells what kind of connector should be used', URL VARCHAR(255) NOT NULL COMMENT 'the bugtracker url', IFRAME_FRIENDLY BIT(1) DEFAULT 0 NOT NULL COMMENT 'tells if the bugtracker page can be accessed through an iframe', CONSTRAINT PK_BUGTRACKER PRIMARY KEY (BUGTRACKER_ID)) COMMENT='stores bugtrackers informations' ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1209.01', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 138, '8:51f3aec0712253ff164f236ab0673307', 'createTable tableName=BUGTRACKER', 'To connect Squash TM to a bugtracker, you must provide the name and the url of the bugtracker. The mantis plugin is shipped with the application
	 IFRAME_FRIENDLY :tells if the bugtracker page can be accessed through an iframe : if the response he...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1181.01::bsiri
--  creating table TEST_AUTOMATION_SERVER
CREATE TABLE TEST_AUTOMATION_SERVER (SERVER_ID BIGINT AUTO_INCREMENT NOT NULL, BASE_URL VARCHAR(255) NOT NULL COMMENT 'the url of the server', LOGIN VARCHAR(50) NOT NULL COMMENT 'the login TM will use', PASSWORD VARCHAR(255) NOT NULL COMMENT 'yes, this is a plain clear password in the database. Until we have what it takes to make it better.', KIND VARCHAR(30) DEFAULT 'jenkins' NOT NULL COMMENT 'the kind of automated test server TM will deal with.', CONSTRAINT PK_TEST_AUTOMATION_SERVER PRIMARY KEY (SERVER_ID)) ENGINE = INNODB;

CREATE INDEX idx_autotest_server ON TEST_AUTOMATION_SERVER(SERVER_ID);

ALTER TABLE TEST_AUTOMATION_SERVER ADD CONSTRAINT uni_autotest_server UNIQUE (BASE_URL, LOGIN);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1181.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 139, '8:59851e575739afe2883bde38b98a826c', 'createTable tableName=TEST_AUTOMATION_SERVER; createIndex indexName=idx_autotest_server, tableName=TEST_AUTOMATION_SERVER; addUniqueConstraint constraintName=uni_autotest_server, tableName=TEST_AUTOMATION_SERVER', 'creating table TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1181.02::bsiri
--  creating table TEST_AUTOMATION_PROJECT
CREATE TABLE TEST_AUTOMATION_PROJECT (PROJECT_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(50) NOT NULL, SERVER_ID BIGINT NULL COMMENT 'foreign key to an automated test server', CONSTRAINT PK_TEST_AUTOMATION_PROJECT PRIMARY KEY (PROJECT_ID), CONSTRAINT fk_auto_test_project FOREIGN KEY (SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER(SERVER_ID)) ENGINE = INNODB;

CREATE INDEX idx_auto_test_project ON TEST_AUTOMATION_PROJECT(PROJECT_ID);

ALTER TABLE TEST_AUTOMATION_PROJECT ADD CONSTRAINT uni_autotest_project UNIQUE (NAME, SERVER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1181.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 140, '8:ee88a2e8cd8c855b038614fbf673969d', 'createTable tableName=TEST_AUTOMATION_PROJECT; createIndex indexName=idx_auto_test_project, tableName=TEST_AUTOMATION_PROJECT; addUniqueConstraint constraintName=uni_autotest_project, tableName=TEST_AUTOMATION_PROJECT', 'creating table TEST_AUTOMATION_PROJECT', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1181.03::bsiri
--  now a PROJECT may or may not have test automation enabled
ALTER TABLE PROJECT ADD TEST_AUTOMATION_ENABLED BIT(1) DEFAULT 0 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1181.03', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 141, '8:964bf60732b6b169049b8c69aef3a44d', 'addColumn tableName=PROJECT', 'now a PROJECT may or may not have test automation enabled', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1181.04::bsiri
--  table where TM projects and TA projects are bound to each others
CREATE TABLE TM_TA_PROJECTS (TM_PROJECT_ID BIGINT NOT NULL, TA_PROJECT_ID BIGINT NOT NULL, CONSTRAINT fk_tm_ta_projects_tm FOREIGN KEY (TM_PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_tm_ta_projects_ta FOREIGN KEY (TA_PROJECT_ID) REFERENCES TEST_AUTOMATION_PROJECT(PROJECT_ID)) ENGINE = INNODB;

ALTER TABLE TM_TA_PROJECTS ADD PRIMARY KEY (TM_PROJECT_ID, TA_PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1181.04', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 142, '8:f02d1949114f3ad883bebf32826222f1', 'createTable tableName=TM_TA_PROJECTS; addPrimaryKey constraintName=pk_tm_ta_projects, tableName=TM_TA_PROJECTS', 'table where TM projects and TA projects are bound to each others', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1194.01::mpagnon
--  Bugtracker project represent the project's name in a configured bugtracker
CREATE TABLE BUGTRACKER_BINDING (BUGTRACKER_BINDING_ID BIGINT AUTO_INCREMENT NOT NULL, BUGTRACKER_ID BIGINT NOT NULL, PROJECT_NAME VARCHAR(255) NULL COMMENT 'project-name in the bugtracker', PROJECT_ID BIGINT NOT NULL, CONSTRAINT PK_BUGTRACKER_BINDING PRIMARY KEY (BUGTRACKER_BINDING_ID), CONSTRAINT FK_BUGTRACKER_BINDING_BUGTRACKER FOREIGN KEY (BUGTRACKER_ID) REFERENCES BUGTRACKER(BUGTRACKER_ID), CONSTRAINT FK_BUGTRACKER_BINDING_PROJECT FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1194.01', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 143, '8:17c48fe1bc427eb11dcef751a5d425b4', 'createTable tableName=BUGTRACKER_BINDING', 'Bugtracker project represent the project''s name in a configured bugtracker', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1194.04::mpagnon
--  Data migration: add all bugtrackers that had an issue
insert into BUGTRACKER (NAME, KIND, URL, IFRAME_FRIENDLY)
			select distinct issues.BT_NAME , 'mantis', 'TO BE DEFINED', true
			from ISSUE issues;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1194.04', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 144, '8:86f6d7c670961034792a94bcd19d47fc', 'sql', 'Data migration: add all bugtrackers that had an issue', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1194.05::mpagnon
--  New foreign key in ISSUE table that points to a BUGTRACKER
ALTER TABLE ISSUE ADD BUGTRACKER_ID BIGINT NULL COMMENT 'Issue''s bugtracker';

ALTER TABLE ISSUE ADD CONSTRAINT fk_issue_bugtracker FOREIGN KEY (BUGTRACKER_ID) REFERENCES BUGTRACKER (BUGTRACKER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1194.05', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 145, '8:9988978cd539cad5825d4d38c13025af', 'addColumn tableName=ISSUE', 'New foreign key in ISSUE table that points to a BUGTRACKER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1194.06::mpagnon
--  Data migration : update issue's bugtracker FK with migrated BTs
CREATE TABLE ISSUEBT
			(
			ISSUEID BIGINT,
			BTID BIGINT
			);

Insert into ISSUEBT (ISSUEID, BTID)
			select distinct iss.ISSUE_ID,
			bt.BUGTRACKER_ID
			from ISSUE as iss, BUGTRACKER as bt
			where iss.BT_NAME = bt.NAME;

update ISSUE
			set BUGTRACKER_ID = (
				select BTID from ISSUEBT
				where ISSUEBT.ISSUEID = ISSUE.ISSUE_ID
			);

DROP table ISSUEBT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1194.06', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 146, '8:e5e998d9314b8c63dd1b0cf4b277e596', 'sql', 'Data migration : update issue''s bugtracker FK with migrated BTs', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1194.07::mpagnon
--  Drop of column "BT_NAME" on table issue because it is not used anymore => use of FK to table BUGTRACKER instead
ALTER TABLE ISSUE DROP COLUMN BT_NAME;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1194.07', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 147, '8:b78973176d167ccbd820a55e90aad2e3', 'dropColumn columnName=BT_NAME, tableName=ISSUE', 'Drop of column "BT_NAME" on table issue because it is not used anymore => use of FK to table BUGTRACKER instead', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1194.08::mpagnon
--  After Data migration : issue's bugtracker must not be null
ALTER TABLE ISSUE MODIFY BUGTRACKER_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1194.08', 'mpagnon', 'tm/tm.changelog-1.3.0.xml', NOW(), 148, '8:89f404e6ddfe747a5ab83b985af561a7', 'addNotNullConstraint columnName=BUGTRACKER_ID, tableName=ISSUE', 'After Data migration : issue''s bugtracker must not be null', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1210.01::bsiri
--  Creation of the table AUTOMATED_TEST
CREATE TABLE AUTOMATED_TEST (TEST_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(255) NULL, PROJECT_ID BIGINT NULL, CONSTRAINT PK_AUTOMATED_TEST PRIMARY KEY (TEST_ID), CONSTRAINT fk_automated_test_project FOREIGN KEY (PROJECT_ID) REFERENCES TEST_AUTOMATION_PROJECT(PROJECT_ID)) ENGINE = INNODB;

ALTER TABLE AUTOMATED_TEST ADD CONSTRAINT uni_auto_test UNIQUE (NAME, PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1210.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 149, '8:2c1f6c7ed17779b0c35a44d1d6d5e8b3', 'createTable tableName=AUTOMATED_TEST; addUniqueConstraint constraintName=uni_auto_test, tableName=AUTOMATED_TEST', 'Creation of the table AUTOMATED_TEST', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1210.02::bsiri
--  a TEST_CASE can now refer to 0 or 1 AUTOMATED_TEST
ALTER TABLE TEST_CASE ADD TA_TEST BIGINT DEFAULT null NULL;

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_test_case_ta_test FOREIGN KEY (TA_TEST) REFERENCES AUTOMATED_TEST (TEST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1210.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 150, '8:57c3dcb67b055fe67cb7314528cbe1aa', 'addColumn tableName=TEST_CASE', 'a TEST_CASE can now refer to 0 or 1 AUTOMATED_TEST', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1210.03::gfouquet
--  Added a role / group for test automation clients
INSERT INTO CORE_GROUP (QUALIFIED_NAME) VALUES ('squashtest.authz.group.tm.TestAutomationServer');

INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select max(ID) from CORE_GROUP), 'ROLE_TA_API_CLIENT');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1210.03', 'gfouquet', 'tm/tm.changelog-1.3.0.xml', NOW(), 151, '8:b2a3d3a51d970eb38c67a0fb63421388', 'insert tableName=CORE_GROUP; insert tableName=CORE_GROUP_AUTHORITY', 'Added a role / group for test automation clients', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1211.01::bsiri
--  Creation of the automated suites table. Note that althought its ID is
--  			still the primary key, it won't be autogenerated : the system will supply it
--  			along the rest instead.
--  
--  			A automated suite groups together a bunch of test automation executions,
--  			which themselves refer to test automation tests.
CREATE TABLE AUTOMATED_SUITE (SUITE_ID VARCHAR(50) NOT NULL, CONSTRAINT PK_AUTOMATED_SUITE PRIMARY KEY (SUITE_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1211.01', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 152, '8:ecf1e42d21760d8ffc8bc23631fdeb54', 'createTable tableName=AUTOMATED_SUITE', 'Creation of the automated suites table. Note that althought its ID is
			still the primary key, it won''t be autogenerated : the system will supply it
			along the rest instead.

			A automated suite groups together a bunch of test automation execu...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.3.0.xml::tm-1.3.0-feat-1211.02::bsiri
--  Table for the automated executions extender. An automated execution is
--  			an extension to Executions that handles things related to test automation.
--  
--  			The correct business model would have been that an automated execution is a specialization of
--  			execution, thus inherited from it. Sadly Hibernates got in the way so we came
--  			up with that solution instead.
CREATE TABLE AUTOMATED_EXECUTION_EXTENDER (EXTENDER_ID BIGINT AUTO_INCREMENT NOT NULL, MASTER_EXECUTION_ID BIGINT NOT NULL COMMENT 'foreign key to the Execution it attaches to.', TEST_ID BIGINT NOT NULL COMMENT 'we save that information as soon as the auto execution is created,             because it may change in the future (even if the test case that this execution             is linked to stays otherwhise the same)', RESULT_URL VARCHAR(300) NULL COMMENT 'urls longer than 300 chars should go to hell', SUITE_ID VARCHAR(50) NULL COMMENT 'foreignkey of the suite this execution belongs to', RESULT_SUMMARY LONGTEXT DEFAULT null NULL COMMENT 'a short debriefing of a test once it has been       executed, for instance an error message', CONSTRAINT PK_AUTOMATED_EXECUTION_EXTENDER PRIMARY KEY (EXTENDER_ID), CONSTRAINT fk_auto_exec_exec FOREIGN KEY (MASTER_EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_auto_exec_auto_test FOREIGN KEY (TEST_ID) REFERENCES AUTOMATED_TEST(TEST_ID), CONSTRAINT fk_auto_exec_suite FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE(SUITE_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.3.0-feat-1211.02', 'bsiri', 'tm/tm.changelog-1.3.0.xml', NOW(), 153, '8:8d5db31f6c48476056b0b087e474d41e', 'createTable tableName=AUTOMATED_EXECUTION_EXTENDER', 'Table for the automated executions extender. An automated execution is
			an extension to Executions that handles things related to test automation.

			The correct business model would have been that an automated execution is a specialization of
...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.00::gfouquet
--  Adds a TM database version number
UPDATE CORE_CONFIG SET STR_KEY = 'squashtest.tm.database.version', VALUE = '1.4.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.00', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', NOW(), 154, '8:47d4503dc22d75c6e4340159a517bdc8', 'update tableName=CORE_CONFIG', 'Adds a TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0-feat-1109.01::gfouquet
--  Creates a table for Custom Fields
CREATE TABLE CUSTOM_FIELD (CF_ID BIGINT AUTO_INCREMENT NOT NULL, FIELD_TYPE CHAR(3) NOT NULL COMMENT 'CF : simple, SSF : multiple-choice', NAME VARCHAR(255) NOT NULL, LABEL VARCHAR(255) DEFAULT '' NOT NULL, OPTIONAL BIT(1) DEFAULT 1 NOT NULL, DEFAULT_VALUE VARCHAR(255) NULL, INPUT_TYPE CHAR(30) NOT NULL, CONSTRAINT pk_custom_field PRIMARY KEY (CF_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0-feat-1109.01', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', NOW(), 155, '8:5f0d873c1d91b85e3774ab6c07edc713', 'createTable tableName=CUSTOM_FIELD', 'Creates a table for Custom Fields', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0-feat-1109.02::gfouquet
--  Creates a table for Custom Fields Options
CREATE TABLE CUSTOM_FIELD_OPTION (CF_ID BIGINT NOT NULL, LABEL VARCHAR(255) NOT NULL, POSITION INT NOT NULL, CONSTRAINT fk_cf_option_cf FOREIGN KEY (CF_ID) REFERENCES CUSTOM_FIELD(CF_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0-feat-1109.02', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', NOW(), 156, '8:b26d04016cf7e30c5677b5e270bae690', 'createTable tableName=CUSTOM_FIELD_OPTION', 'Creates a table for Custom Fields Options', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0-feat-1390.01::gfouquet
--  Creates a table for Custom Fields Binding
CREATE TABLE CUSTOM_FIELD_BINDING (CFB_ID BIGINT AUTO_INCREMENT NOT NULL, CF_ID BIGINT NOT NULL, BOUND_ENTITY VARCHAR(30) NOT NULL, BOUND_PROJECT_ID BIGINT NOT NULL, POSITION INT NULL, CONSTRAINT pk_cfb_option PRIMARY KEY (CFB_ID), CONSTRAINT fk_cfb_bound_project FOREIGN KEY (BOUND_PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_cfb_cf FOREIGN KEY (CF_ID) REFERENCES CUSTOM_FIELD(CF_ID)) ENGINE = INNODB;

ALTER TABLE CUSTOM_FIELD_BINDING ADD CONSTRAINT uc_cf_entity_proj_bnd UNIQUE (BOUND_PROJECT_ID, BOUND_ENTITY, CF_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0-feat-1390.01', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', NOW(), 157, '8:1f63580988cd0ac375147c25b71db8ac', 'createTable tableName=CUSTOM_FIELD_BINDING; addUniqueConstraint constraintName=uc_cf_entity_proj_bnd, tableName=CUSTOM_FIELD_BINDING', 'Creates a table for Custom Fields Binding', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0-feat-1390.02::gfouquet
--  Creates a table for rendering locations of a bound custom field
CREATE TABLE CUSTOM_FIELD_RENDERING_LOCATION (CFB_ID BIGINT NOT NULL, RENDERING_LOCATION VARCHAR(30) NOT NULL, CONSTRAINT fk_cfb_render_loc_cfb FOREIGN KEY (CFB_ID) REFERENCES CUSTOM_FIELD_BINDING(CFB_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0-feat-1390.02', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', NOW(), 158, '8:3dfbb528ef03de65f14eb152014c2bdc', 'createTable tableName=CUSTOM_FIELD_RENDERING_LOCATION', 'Creates a table for rendering locations of a bound custom field', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.01::mpagnon
--  Add property attachment list in library nodes, projects and libraries
ALTER TABLE TEST_CASE_LIBRARY_NODE ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE TEST_CASE_LIBRARY_NODE ADD CONSTRAINT fk_tcNode_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE CAMPAIGN_LIBRARY_NODE ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE CAMPAIGN_LIBRARY_NODE ADD CONSTRAINT fk_campNode_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE `RESOURCE` ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE `RESOURCE` ADD CONSTRAINT fk_resource_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE PROJECT ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE REQUIREMENT_LIBRARY ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE REQUIREMENT_LIBRARY ADD CONSTRAINT fk_reqLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE TEST_CASE_LIBRARY ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE TEST_CASE_LIBRARY ADD CONSTRAINT fk_tcLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

ALTER TABLE CAMPAIGN_LIBRARY ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'clé étrangère vers un ATTACHMENT_LIST, l''entité qui gère les pièces jointes.';

ALTER TABLE CAMPAIGN_LIBRARY ADD CONSTRAINT fk_campLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.01', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 159, '8:1e5fe54adc3e7b02dbaba826944fd900', 'addColumn tableName=TEST_CASE_LIBRARY_NODE; addColumn tableName=CAMPAIGN_LIBRARY_NODE; addColumn tableName=RESOURCE; addColumn tableName=PROJECT; addColumn tableName=REQUIREMENT_LIBRARY; addColumn tableName=TEST_CASE_LIBRARY; addColumn tableName=C...', 'Add property attachment list in library nodes, projects and libraries', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.02::mpagnon
--  Migrate existing attachment lists
update TEST_CASE_LIBRARY_NODE
			set ATTACHMENT_LIST_ID = (select TEST_CASE.ATTACHMENT_LIST_ID from TEST_CASE where TEST_CASE.TCLN_ID = TEST_CASE_LIBRARY_NODE.TCLN_ID);

update CAMPAIGN_LIBRARY_NODE
			set ATTACHMENT_LIST_ID = (select CAMPAIGN.ATTACHMENT_LIST_ID from CAMPAIGN where CAMPAIGN.CLN_ID = CAMPAIGN_LIBRARY_NODE.CLN_ID);

update RESOURCE
			set ATTACHMENT_LIST_ID = (select REQUIREMENT_VERSION.ATTACHMENT_LIST_ID from REQUIREMENT_VERSION where REQUIREMENT_VERSION.RES_ID = RESOURCE.RES_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.02', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 160, '8:a544746773f1033e47515a544c9b18e3', 'sql; sql; sql', 'Migrate existing attachment lists', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.03::mpagnon
--  Add attachment lists to test_case_folders
ALTER TABLE ATTACHMENT_LIST ADD TCLN_ID BIGINT NULL COMMENT 'colonne provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_tcln FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE_LIBRARY_NODE (TCLN_ID);

insert into ATTACHMENT_LIST (TCLN_ID)
			select TEST_CASE_FOLDER.TCLN_ID from TEST_CASE_FOLDER;

update TEST_CASE_LIBRARY_NODE
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.TCLN_ID = TEST_CASE_LIBRARY_NODE.TCLN_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_tcln;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN TCLN_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.03', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 161, '8:a921fd0f39ba6cce8100d1874fe5f202', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_tcln; dropColumn columnName=TCLN_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to test_case_folders', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.04::mpagnon
--  Add attachment lists to campaign_folders
ALTER TABLE ATTACHMENT_LIST ADD CLN_ID BIGINT NULL COMMENT 'table provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_cln FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE (CLN_ID);

insert into ATTACHMENT_LIST (CLN_ID)
			select CAMPAIGN_FOLDER.CLN_ID from CAMPAIGN_FOLDER;

update CAMPAIGN_LIBRARY_NODE
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.CLN_ID = CAMPAIGN_LIBRARY_NODE.CLN_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_cln;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN CLN_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.04', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 162, '8:76838efd394db1c0516055a81a6e4035', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_cln; dropColumn columnName=CLN_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to campaign_folders', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.05::mpagnon
--  Add attachment lists to requirement folders
ALTER TABLE ATTACHMENT_LIST ADD RES_ID BIGINT NULL COMMENT 'table provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_sr FOREIGN KEY (RES_ID) REFERENCES `RESOURCE` (RES_ID);

insert into ATTACHMENT_LIST (RES_ID)
			select SIMPLE_RESOURCE.RES_ID from SIMPLE_RESOURCE;

update RESOURCE
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.RES_ID = RESOURCE.RES_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_sr;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN RES_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.05', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 163, '8:1d57bcfb9f9178e1fe76e1232dda8418', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_sr; dropColumn columnName=RES_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to requirement folders', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.06::mpagnon
--  Add attachment lists to projects
ALTER TABLE ATTACHMENT_LIST ADD PROJECT_ID BIGINT NULL COMMENT 'table provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

insert into ATTACHMENT_LIST (PROJECT_ID)
			select PROJECT.PROJECT_ID from PROJECT;

update PROJECT
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.PROJECT_ID = PROJECT.PROJECT_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_project;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN PROJECT_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.06', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 164, '8:17f4c1960e10e28b5e1d8452233cbe10', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_project; dropColumn columnName=PROJECT_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to projects', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.07::mpagnon
--  Add attachment lists to reqLib
ALTER TABLE ATTACHMENT_LIST ADD RL_ID BIGINT NULL COMMENT 'table provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_rLib FOREIGN KEY (RL_ID) REFERENCES REQUIREMENT_LIBRARY (RL_ID);

insert into ATTACHMENT_LIST (RL_ID)
			select REQUIREMENT_LIBRARY.RL_ID from REQUIREMENT_LIBRARY;

update REQUIREMENT_LIBRARY
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.RL_ID = REQUIREMENT_LIBRARY.RL_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_rLib;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN RL_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.07', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 165, '8:741b34777bada69e897109fac527cd34', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_rLib; dropColumn columnName=RL_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to reqLib', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.08::mpagnon
--  Add attachment lists to test_case_library
ALTER TABLE ATTACHMENT_LIST ADD TCL_ID BIGINT NULL COMMENT 'table provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_tcLib FOREIGN KEY (TCL_ID) REFERENCES TEST_CASE_LIBRARY (TCL_ID);

insert into ATTACHMENT_LIST (TCL_ID)
			select TEST_CASE_LIBRARY.TCL_ID from TEST_CASE_LIBRARY;

update TEST_CASE_LIBRARY
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.TCL_ID = TEST_CASE_LIBRARY.TCL_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_tcLib;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN TCL_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.08', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 166, '8:83934b979af1c904fa5c961f67e16d26', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_tcLib; dropColumn columnName=TCL_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to test_case_library', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.09::mpagnon
--  Add attachment lists to campaign libraries
ALTER TABLE ATTACHMENT_LIST ADD CL_ID BIGINT NULL COMMENT 'table provisoire pour se rapeller de à qui était destinée la nouvelle attachment_list';

ALTER TABLE ATTACHMENT_LIST ADD CONSTRAINT fk_cLib FOREIGN KEY (CL_ID) REFERENCES CAMPAIGN_LIBRARY (CL_ID);

insert into ATTACHMENT_LIST (CL_ID)
			select CAMPAIGN_LIBRARY.CL_ID from CAMPAIGN_LIBRARY;

update CAMPAIGN_LIBRARY
			set ATTACHMENT_LIST_ID = (select ATTACHMENT_LIST.ATTACHMENT_LIST_ID from ATTACHMENT_LIST where ATTACHMENT_LIST.CL_ID = CAMPAIGN_LIBRARY.CL_ID)
			where ATTACHMENT_LIST_ID is null;

ALTER TABLE ATTACHMENT_LIST DROP FOREIGN KEY fk_cLib;

ALTER TABLE ATTACHMENT_LIST DROP COLUMN CL_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.09', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 167, '8:80471c4ed7a864008f3780723581604c', 'addColumn tableName=ATTACHMENT_LIST; sql; sql; dropForeignKeyConstraint baseTableName=ATTACHMENT_LIST, constraintName=fk_cLib; dropColumn columnName=CL_ID, tableName=ATTACHMENT_LIST', 'Add attachment lists to campaign libraries', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.010::mpagnon
--  Make attachment_list_ids new fks not nullable
ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

ALTER TABLE `RESOURCE` MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

ALTER TABLE PROJECT MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

ALTER TABLE REQUIREMENT_LIBRARY MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

ALTER TABLE CAMPAIGN_LIBRARY MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

ALTER TABLE TEST_CASE_LIBRARY MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.010', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 168, '8:910e041f846e1c2f0e9797e7c3e0db09', 'addNotNullConstraint columnName=ATTACHMENT_LIST_ID, tableName=TEST_CASE_LIBRARY_NODE; addNotNullConstraint columnName=ATTACHMENT_LIST_ID, tableName=CAMPAIGN_LIBRARY_NODE; addNotNullConstraint columnName=ATTACHMENT_LIST_ID, tableName=RESOURCE; addN...', 'Make attachment_list_ids new fks not nullable', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1513.11::mpagnon
--  Drop previous attachment list ids
ALTER TABLE TEST_CASE DROP FOREIGN KEY fk_test_case_attachment_list;

ALTER TABLE CAMPAIGN DROP FOREIGN KEY fk_campaign_attachment_list;

ALTER TABLE REQUIREMENT_VERSION DROP FOREIGN KEY fk_requirement_version_attachment_list;

ALTER TABLE TEST_CASE DROP COLUMN ATTACHMENT_LIST_ID;

ALTER TABLE CAMPAIGN DROP COLUMN ATTACHMENT_LIST_ID;

ALTER TABLE REQUIREMENT_VERSION DROP COLUMN ATTACHMENT_LIST_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1513.11', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 169, '8:3cb3532cce4a9ba7a85d2bd935735d13', 'dropForeignKeyConstraint baseTableName=TEST_CASE, constraintName=fk_test_case_attachment_list; dropForeignKeyConstraint baseTableName=CAMPAIGN, constraintName=fk_campaign_attachment_list; dropForeignKeyConstraint baseTableName=REQUIREMENT_VERSION,...', 'Drop previous attachment list ids', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1392.01::bsiri
--  The table CUSTOM_FIELD_VALUE holds instances of a CUSTOM_FIELD that are bound to instances of :
--  			test cases, requirement version, campagnes, iterations and test suites. A custom field value is created
--  			when a custom field binding is created or an entity subject to an existing custom field binding is created.
--  			A custom field value is destroyed when the bound entity instance is destroyed or the custom field binding
--  			is destroyed.
--  
--  			Note that in this table the coupling between the custom field value and the bound entity is week : it consists of a pair
--  			of Type/ID (BINDABLE_ENTITY_TYPE and BINDABLE_ENTITY_ID) rather than a foreign key to the said entity, nor is true
--  			the opposite ( ie no FK from a test case to a custom field value).
CREATE TABLE CUSTOM_FIELD_VALUE (CFV_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', BOUND_ENTITY_ID BIGINT NOT NULL COMMENT 'the id of the bound entity', BOUND_ENTITY_TYPE VARCHAR(30) NOT NULL COMMENT 'the kind of entity. Note that this information is also contained by the                  custom field binding.', CFB_ID BIGINT NOT NULL COMMENT 'the custom field binding that holds all the data', VALUE VARCHAR(255) NULL COMMENT 'the value of that particular custom field value', CONSTRAINT pk_custom_field_value PRIMARY KEY (CFV_ID), CONSTRAINT fk_cfv_cf_binding FOREIGN KEY (CFB_ID) REFERENCES CUSTOM_FIELD_BINDING(CFB_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1392.01', 'bsiri', 'tm/tm.changelog-1.4.0.xml', NOW(), 170, '8:e419045701cd1d660c290d9cebc96d71', 'createTable tableName=CUSTOM_FIELD_VALUE', 'The table CUSTOM_FIELD_VALUE holds instances of a CUSTOM_FIELD that are bound to instances of :
			test cases, requirement version, campagnes, iterations and test suites. A custom field value is created
			when a custom field binding is created or...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1553.00::flaurens
--  Adds a nature field to test cases
ALTER TABLE TEST_CASE ADD TC_NATURE VARCHAR(30) DEFAULT 'UNDEFINED' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1553.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', NOW(), 171, '8:687080f9bf005ab2a5ee3064e3a9235b', 'addColumn tableName=TEST_CASE', 'Adds a nature field to test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1554.00::flaurens
--  Adds a type field to test cases
ALTER TABLE TEST_CASE ADD TC_TYPE VARCHAR(30) DEFAULT 'UNDEFINED' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1554.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', NOW(), 172, '8:1c43b37cb04adca934b62633b595ed08', 'addColumn tableName=TEST_CASE', 'Adds a type field to test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1609.00::flaurens
--  Adds a status field to test cases
ALTER TABLE TEST_CASE ADD TC_STATUS VARCHAR(30) DEFAULT 'WORK_IN_PROGRESS' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1609.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', NOW(), 173, '8:7d3c71ee41d2af7a983ca1855ff775f3', 'addColumn tableName=TEST_CASE', 'Adds a status field to test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1596.00::flaurens
--  Adds test case related fields to executions for denormalization
ALTER TABLE EXECUTION ADD TC_NATURE VARCHAR(30) DEFAULT 'UNDEFINED' NOT NULL, ADD TC_TYPE VARCHAR(30) DEFAULT 'UNDEFINED' NOT NULL, ADD TC_STATUS VARCHAR(30) DEFAULT 'WORK_IN_PROGRESS' NOT NULL, ADD IMPORTANCE VARCHAR(20) DEFAULT 'LOW' NOT NULL, ADD `REFERENCE` VARCHAR(20) DEFAULT null NULL, ADD TC_DESCRIPTION LONGTEXT DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1596.00', 'flaurens', 'tm/tm.changelog-1.4.0.xml', NOW(), 174, '8:98717315ac63d2f0ec87d045f9a0e7fd', 'addColumn tableName=EXECUTION', 'Adds test case related fields to executions for denormalization', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1596.01::flaurens
--  adds test case information to executions created prior to the changeset tm-1.4.0.feat-1596.00
create table EXECUTION_TEST_CASE_DATA (TCLN_ID BIGINT, TC_DESCRIPTION TEXT, REFERENCE VARCHAR(20), IMPORTANCE VARCHAR(20), TC_NATURE VARCHAR(30), TC_TYPE VARCHAR(30), TC_STATUS VARCHAR(30));

insert into EXECUTION_TEST_CASE_DATA (TCLN_ID, TC_DESCRIPTION, REFERENCE, IMPORTANCE, TC_NATURE, TC_TYPE, TC_STATUS)
				select
					tc.tcln_id AS TCLN_ID,
					tcln.description AS DESCRIPTION,
					tc.reference AS REFERENCE,
					tc.importance AS IMPORTANCE,
					tc.tc_nature AS TCNATURE,
					tc.tc_type AS TCTYPE,
					tc.tc_status AS TCSTATUS
				from TEST_CASE tc
				join TEST_CASE_LIBRARY_NODE tcln on tcln.tcln_id = tc.tcln_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1596.01', 'flaurens', 'tm/tm.changelog-1.4.0.xml', NOW(), 175, '8:0746b8b92b662185b04724e135518a48', 'sql', 'adds test case information to executions created prior to the changeset tm-1.4.0.feat-1596.00', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1596.01-a::mpagnon
--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1596.01-b::mpagnon
--  this grammar is not supported by h2 and is more efficient
UPDATE EXECUTION exe
			JOIN EXECUTION_TEST_CASE_DATA etcd ON etcd.TCLN_ID = exe.TCLN_ID
			SET
			exe.TC_DESCRIPTION=etcd.tc_description,
			exe.REFERENCE=etcd.reference,
			exe.IMPORTANCE=etcd.importance,
			exe.TC_NATURE=etcd.tc_nature,
			exe.TC_TYPE=etcd.tc_type,
			exe.TC_STATUS=etcd.tc_status;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1596.01-b', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 176, '8:f9eb3cff4afa408a01c77ed552491ea7', 'sql', 'this grammar is not supported by h2 and is more efficient', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1110.01::gfouquet
--  Adds a type discriminator column on PROJECT
ALTER TABLE PROJECT ADD PROJECT_TYPE CHAR(1) DEFAULT 'P' NOT NULL COMMENT 'P: project, T: project template';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1110.01', 'gfouquet', 'tm/tm.changelog-1.4.0.xml', NOW(), 177, '8:a6f68a8239f86c9e6fdbee0610d4a558', 'addColumn tableName=PROJECT', 'Adds a type discriminator column on PROJECT', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1393.01::mpagnon
--  Adds a className for the ProjectTemplate, this is needed so that a project template can hold user's permissions
INSERT INTO ACL_CLASS (CLASSNAME) VALUES ('org.squashtest.csp.tm.domain.project.ProjectTemplate');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1393.01', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 178, '8:d379b785e3df9b3bfe8ddd40e32cc75b', 'insert tableName=ACL_CLASS', 'Adds a className for the ProjectTemplate, this is needed so that a project template can hold user''s permissions', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1628.01::flaurens
ALTER TABLE REQUIREMENT_VERSION ALTER `REFERENCE` SET DEFAULT '';

ALTER TABLE TEST_CASE ALTER `REFERENCE` SET DEFAULT '';

ALTER TABLE EXECUTION ALTER `REFERENCE` SET DEFAULT '';

ALTER TABLE REQUIREMENT_VERSION MODIFY `REFERENCE` VARCHAR(50);

ALTER TABLE TEST_CASE MODIFY `REFERENCE` VARCHAR(50);

ALTER TABLE EXECUTION MODIFY `REFERENCE` VARCHAR(50);

ALTER TABLE REQUIREMENT_VERSION ALTER `REFERENCE` SET DEFAULT '';

ALTER TABLE TEST_CASE ALTER `REFERENCE` SET DEFAULT '';

ALTER TABLE EXECUTION ALTER `REFERENCE` SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1628.01', 'flaurens', 'tm/tm.changelog-1.4.0.xml', NOW(), 179, '8:cc41991917196a77889b24836899a3f0', 'addDefaultValue columnName=REFERENCE, tableName=REQUIREMENT_VERSION; addDefaultValue columnName=REFERENCE, tableName=TEST_CASE; addDefaultValue columnName=REFERENCE, tableName=EXECUTION; modifyDataType columnName=REFERENCE, tableName=REQUIREMENT_V...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1638.01::mpagnon
ALTER TABLE CUSTOM_FIELD ADD CODE VARCHAR(30) DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1638.01', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 180, '8:ec3f5d309c82e25742b70c9cb60b2530', 'addColumn tableName=CUSTOM_FIELD', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.0.xml::tm-1.4.0.feat-1638.02::mpagnon
ALTER TABLE CUSTOM_FIELD_OPTION ADD CODE VARCHAR(30) DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.0.feat-1638.02', 'mpagnon', 'tm/tm.changelog-1.4.0.xml', NOW(), 181, '8:32a32aad58ccb2a3d1e4f8353ac51c6f', 'addColumn tableName=CUSTOM_FIELD_OPTION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.1.xml::tm-1.4.1.00::mpagnon
--  Adds a TM database version number
UPDATE CORE_CONFIG SET STR_KEY = 'squashtest.tm.database.version', VALUE = '1.4.1' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.1.00', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', NOW(), 182, '8:e64714660838abe288858a785b925c7a', 'update tableName=CORE_CONFIG', 'Adds a TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.1.xml::tm-1.4.1.issue-1864-01::mpagnon
--  fixed database integrity for execution importance
update EXECUTION exe
			set importance = 'LOW'
			where exe.importance <>
			'LOW'
			and exe.importance <> 'HIGH'
			and exe.importance <>
			'MEDIUM'
			and exe.importance <> 'VERY_HIGH';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.1.issue-1864-01', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', NOW(), 183, '8:24a3af879eb0b03292ab5e34fc4e1547', 'sql', 'fixed database integrity for execution importance', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.1.xml::tm-1.4.1.issue-1864-02::mpagnon
--  fixed database integrity for execution tc_nature
update EXECUTION exe
			set tc_nature = 'UNDEFINED'
			where exe.tc_nature <>
			'ATDD'
			and exe.tc_nature <> 'BUSINESS_TESTING'
			and exe.tc_nature <> 'FUNCTIONAL_TESTING'
			and exe.tc_nature <> 'NON_FUNCTIONAL_TESTING'
			and exe.tc_nature <> 'PERFORMANCE_TESTING'
			and exe.tc_nature <> 'SECURITY_TESTING'
			and exe.tc_nature <> 'UNDEFINED'
			and exe.tc_nature <> 'USER_TESTING';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.1.issue-1864-02', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', NOW(), 184, '8:0d0369cdf5535f7c8549757e3df6d8c1', 'sql', 'fixed database integrity for execution tc_nature', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.1.xml::tm-1.4.1.issue-1864-03::mpagnon
--  fixed database integrity for execution tc_type
update EXECUTION exe
			set tc_type = 'UNDEFINED'
			where exe.tc_type <>
			'COMPLIANCE_TESTING'
			and exe.tc_type <> 'CORRECTION_TESTING'
			and exe.tc_type <> 'END_TO_END_TESTING'
			and exe.tc_type <> 'EVOLUTION_TESTING'
			and exe.tc_type <> 'PARTNER_TESTING'
			and exe.tc_type <> 'REGRESSION_TESTING'
			and exe.tc_type <> 'UNDEFINED';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.1.issue-1864-03', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', NOW(), 185, '8:b56f8d7e673cc2c1967de32a86ae3929', 'sql', 'fixed database integrity for execution tc_type', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.4.1.xml::tm-1.4.1.issue-1864-04::mpagnon
--  fixed database integrity for execution tc_status
update EXECUTION exe
			set tc_status = 'WORK_IN_PROGRESS'
			where exe.tc_status
			<> 'APPROVED'
			and exe.tc_status <> 'OBSOLETE'
			and exe.tc_status <> 'TO_BE_UPDATED'
			and exe.tc_status <> 'UNDER_REVIEW'
			and exe.tc_status <> 'WORK_IN_PROGRESS';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.4.1.issue-1864-04', 'mpagnon', 'tm/tm.changelog-1.4.1.xml', NOW(), 186, '8:d9c21801b86b940f5e8370048c6e2ae6', 'sql', 'fixed database integrity for execution tc_status', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00::mpagnon
--  Update TM database version number
UPDATE CORE_CONFIG SET STR_KEY = 'squashtest.tm.database.version', VALUE = '1.5.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 187, '8:e21f74e20ec335f77a64538102408c85', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.feat-1596.02::bsiri
--  dropping the temp table from changest tm-1.4.0.feat-1596.01
DROP TABLE EXECUTION_TEST_CASE_DATA;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.feat-1596.02', 'bsiri', 'tm/tm.changelog-1.5.0.xml', NOW(), 188, '8:3ccf3fe5de209e1556bb8d0be7bf2661', 'dropTable tableName=EXECUTION_TEST_CASE_DATA', 'dropping the temp table from changest tm-1.4.0.feat-1596.01', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-issue-1838.01::mpagnon
--  Update table custom-field-value so that all mandatory cuf have a value
update CUSTOM_FIELD_VALUE
			set VALUE = (
			select cf.DEFAULT_VALUE
			from CUSTOM_FIELD_BINDING cfb
			join CUSTOM_FIELD cf on cfb.CF_ID =
			cf.CF_ID
			where cfb.CFB_ID = CUSTOM_FIELD_VALUE.CFB_ID
			)
			where
			(CUSTOM_FIELD_VALUE.VALUE is null or
			LTRIM(RTRIM(CUSTOM_FIELD_VALUE.VALUE)) = '' )
			and exists (
			select *
			from CUSTOM_FIELD_BINDING cfb
			join CUSTOM_FIELD cf on cfb.CF_ID =
			cf.CF_ID
			where cfb.CFB_ID = CUSTOM_FIELD_VALUE.CFB_ID
			and cf.OPTIONAL =
			false);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-issue-1838.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 189, '8:a52132e64716ffdf7220ef3a69d67f7a', 'sql', 'Update table custom-field-value so that all mandatory cuf have a value', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1390.03::bsiri
--  adding cascade delete on the rendering locations when custom field bindings are removed (prune the orphans)
ALTER TABLE CUSTOM_FIELD_RENDERING_LOCATION DROP FOREIGN KEY fk_cfb_render_loc_cfb;

ALTER TABLE CUSTOM_FIELD_RENDERING_LOCATION ADD CONSTRAINT fk_cfb_render_loc_cfb FOREIGN KEY (CFB_ID) REFERENCES CUSTOM_FIELD_BINDING (CFB_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1390.03', 'bsiri', 'tm/tm.changelog-1.5.0.xml', NOW(), 190, '8:f3faf7e95d011321140d9e6385ef2cd6', 'dropForeignKeyConstraint baseTableName=CUSTOM_FIELD_RENDERING_LOCATION, constraintName=fk_cfb_render_loc_cfb; addForeignKeyConstraint baseTableName=CUSTOM_FIELD_RENDERING_LOCATION, constraintName=fk_cfb_render_loc_cfb, referencedTableName=CUSTOM_F...', 'adding cascade delete on the rendering locations when custom field bindings are removed (prune the orphans)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1850.01::mpagnon
--  The table DENORMALIZED_FIELD_VALUE holds instances of a FIELD that are bound to instances of :
--  			executions, execution-steps	when they are created from test-cases or test-case-steps holding CUSTOM_FIELDS.
--  			A "denormalized field value" is destroyed when the "denormalized field holder" instance is destroyed.
--  
--  			Note that in this table the coupling between the "denormalized field value" and the "denormalized field holder" is week : it consists of a pair
--  			of Type/ID (DENORMALIZED_FIELD_HOLDER_TYPE and DENORMALIZED_FIELD_HOLDER_ID) rather than a foreign key to the said entity, nor is true
--  			the opposite ( ie no FK from an execution to a denormalized field value).
CREATE TABLE DENORMALIZED_FIELD_VALUE (DFV_ID BIGINT AUTO_INCREMENT NOT NULL, CFV_ID BIGINT NULL COMMENT 'the custom field value where the denormalized field is copied from', CODE VARCHAR(30) DEFAULT '' NOT NULL, DENORMALIZED_FIELD_HOLDER_ID BIGINT NOT NULL COMMENT 'the id of the denormalized field holder.', DENORMALIZED_FIELD_HOLDER_TYPE VARCHAR(30) NOT NULL COMMENT 'the kind of entity.', INPUT_TYPE CHAR(30) NOT NULL, LABEL VARCHAR(255) DEFAULT '' NOT NULL, POSITION INT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular custom field value', CONSTRAINT pk_denormalized_field PRIMARY KEY (DFV_ID)) ENGINE = INNODB;

ALTER TABLE DENORMALIZED_FIELD_VALUE ADD CONSTRAINT fk_dfv_cfv_binding FOREIGN KEY (CFV_ID) REFERENCES CUSTOM_FIELD_VALUE (CFV_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1850.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 191, '8:db8ccd6b71ac152fd69424e36c783041', 'createTable tableName=DENORMALIZED_FIELD_VALUE; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_VALUE, constraintName=fk_dfv_cfv_binding, referencedTableName=CUSTOM_FIELD_VALUE', 'The table DENORMALIZED_FIELD_VALUE holds instances of a FIELD that are bound to instances of :
			executions, execution-steps	when they are created from test-cases or test-case-steps holding CUSTOM_FIELDS.
			A "denormalized field value" is destro...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1850.02::mpagnon
--  Create table for denormalized field rendering location
CREATE TABLE DENORMALIZED_FIELD_RENDERING_LOCATION (DFV_ID BIGINT NOT NULL, RENDERING_LOCATION VARCHAR(30) NOT NULL) ENGINE = INNODB;

ALTER TABLE DENORMALIZED_FIELD_RENDERING_LOCATION ADD CONSTRAINT fk_dfb_render_loc_dfb FOREIGN KEY (DFV_ID) REFERENCES DENORMALIZED_FIELD_VALUE (DFV_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1850.02', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 192, '8:c90694cb598e087cd8be205d61f88578', 'createTable tableName=DENORMALIZED_FIELD_RENDERING_LOCATION; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_RENDERING_LOCATION, constraintName=fk_dfb_render_loc_dfb, referencedTableName=DENORMALIZED_FIELD_VALUE', 'Create table for denormalized field rendering location', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0-feat-821::gfouquet
--  Change class names in ACL system
UPDATE ACL_CLASS SET CLASSNAME = 'org.squashtest.tm.domain.project.Project' WHERE CLASSNAME = 'org.squashtest.csp.tm.domain.project.Project';

UPDATE ACL_CLASS SET CLASSNAME = 'org.squashtest.tm.domain.requirement.RequirementLibrary' WHERE CLASSNAME = 'org.squashtest.csp.tm.domain.requirement.RequirementLibrary';

UPDATE ACL_CLASS SET CLASSNAME = 'org.squashtest.tm.domain.testcase.TestCaseLibrary' WHERE CLASSNAME = 'org.squashtest.csp.tm.domain.testcase.TestCaseLibrary';

UPDATE ACL_CLASS SET CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary' WHERE CLASSNAME = 'org.squashtest.csp.tm.domain.campaign.CampaignLibrary';

UPDATE ACL_CLASS SET CLASSNAME = 'org.squashtest.tm.domain.project.ProjectTemplate' WHERE CLASSNAME = 'org.squashtest.csp.tm.domain.project.ProjectTemplate';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0-feat-821', 'gfouquet', 'tm/tm.changelog-1.5.0.xml', NOW(), 193, '8:9b0a858bca6a4a9bf0a86c6d6a18b0b1', 'update tableName=ACL_CLASS; update tableName=ACL_CLASS; update tableName=ACL_CLASS; update tableName=ACL_CLASS; update tableName=ACL_CLASS', 'Change class names in ACL system', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1864.01::mpagnon
--  Create tables CORE_PARTY, CORE_TEAM
CREATE TABLE CORE_PARTY (PARTY_ID BIGINT AUTO_INCREMENT NOT NULL, CONSTRAINT pk_party PRIMARY KEY (PARTY_ID)) ENGINE = INNODB;

CREATE TABLE CORE_TEAM (PARTY_ID BIGINT NOT NULL COMMENT 'cle primaire, qui est aussi une cle etrangere vers la table PARTY_ID Ne doit donc pas etre autogeneree.', NAME VARCHAR(50) NOT NULL, `DESCRIPTION` VARCHAR(255) NULL, CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL COMMENT 'Date de creation. Il s''agit de la date de creation de l''entree dans      la base, non d''une date metier.', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date de derniere mise a jour de cette instance.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Nom du dernier utilisateur ayant mis a jour cet instance.', CONSTRAINT pk_team PRIMARY KEY (PARTY_ID), CONSTRAINT fk_team_party FOREIGN KEY (PARTY_ID) REFERENCES CORE_PARTY(PARTY_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1864.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 194, '8:6ac26b6e93872549457b02672218bdd5', 'createTable tableName=CORE_PARTY; createTable tableName=CORE_TEAM', 'Create tables CORE_PARTY, CORE_TEAM', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1864.02::mpagnon
--  change name of USER_ID into PARTY_ID in CORE_USER, ACL_RESPONSIBILITY_SCOPE_ENTRY and CORE_GROUP_MEMBER. We need to drop FKs on user first.
ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM DROP FOREIGN KEY fk_camp_tp_user;

ALTER TABLE ITERATION_TEST_PLAN_ITEM DROP FOREIGN KEY fk_itertestplan_user;

ALTER TABLE ACL_RESPONSIBILITY_SCOPE_ENTRY DROP FOREIGN KEY FK_RESP_SCOPE_USER;

ALTER TABLE CORE_GROUP_MEMBER DROP FOREIGN KEY FK_GRP_MEMBER_USR;

ALTER TABLE CORE_USER CHANGE ID PARTY_ID BIGINT;

ALTER TABLE ACL_RESPONSIBILITY_SCOPE_ENTRY CHANGE USER_ID PARTY_ID BIGINT;

ALTER TABLE CORE_GROUP_MEMBER CHANGE USER_ID PARTY_ID BIGINT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1864.02', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 195, '8:ccee6a16065b0bd3a8b2e9d446979e1d', 'dropForeignKeyConstraint baseTableName=CAMPAIGN_TEST_PLAN_ITEM, constraintName=fk_camp_tp_user; dropForeignKeyConstraint baseTableName=ITERATION_TEST_PLAN_ITEM, constraintName=fk_itertestplan_user; dropForeignKeyConstraint baseTableName=ACL_RESPON...', 'change name of USER_ID into PARTY_ID in CORE_USER, ACL_RESPONSIBILITY_SCOPE_ENTRY and CORE_GROUP_MEMBER. We need to drop FKs on user first.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1864.04::mpagnon
--  Create a PARTY for each CORE_USER
insert into CORE_PARTY(PARTY_ID)
			select PARTY_ID from CORE_USER;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1864.04', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 196, '8:a1007915d3c3e3d68a49d416b23c9c48', 'sql', 'Create a PARTY for each CORE_USER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1864.05::mpagnon
--  Replace reference on user with reference on party
ALTER TABLE ACL_RESPONSIBILITY_SCOPE_ENTRY ADD CONSTRAINT fk_arse_party FOREIGN KEY (PARTY_ID) REFERENCES CORE_PARTY (PARTY_ID);

ALTER TABLE CORE_GROUP_MEMBER ADD CONSTRAINT fk_group_member_party FOREIGN KEY (PARTY_ID) REFERENCES CORE_PARTY (PARTY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1864.05', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 197, '8:114d2114c5421dc19d25d68de87e989c', 'addForeignKeyConstraint baseTableName=ACL_RESPONSIBILITY_SCOPE_ENTRY, constraintName=fk_arse_party, referencedTableName=CORE_PARTY; addForeignKeyConstraint baseTableName=CORE_GROUP_MEMBER, constraintName=fk_group_member_party, referencedTableName=...', 'Replace reference on user with reference on party', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1864.06::mpagnon
--  Remove autoIncrement on core_user pk and add fk on Party table
ALTER TABLE CORE_USER DROP PRIMARY KEY;

ALTER TABLE CORE_USER ADD PRIMARY KEY (PARTY_ID);

ALTER TABLE CORE_USER ADD CONSTRAINT fk_core_user_party FOREIGN KEY (PARTY_ID) REFERENCES CORE_PARTY (PARTY_ID);

ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM ADD CONSTRAINT fk_camp_tp_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER (PARTY_ID);

ALTER TABLE ITERATION_TEST_PLAN_ITEM ADD CONSTRAINT fk_itertestplan_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER (PARTY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1864.06', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 198, '8:007750c2047ec9e3736fc4d66421407a', 'dropPrimaryKey tableName=CORE_USER; addPrimaryKey constraintName=pk_core_user, tableName=CORE_USER; addForeignKeyConstraint baseTableName=CORE_USER, constraintName=fk_core_user_party, referencedTableName=CORE_PARTY; addForeignKeyConstraint baseTab...', 'Remove autoIncrement on core_user pk and add fk on Party table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1864.03::mpagnon
--  create table team member
CREATE TABLE CORE_TEAM_MEMBER (TEAM_ID BIGINT NOT NULL, USER_ID BIGINT NOT NULL, CONSTRAINT fk_team_member_team FOREIGN KEY (TEAM_ID) REFERENCES CORE_TEAM(PARTY_ID), CONSTRAINT fk_team_member_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER(PARTY_ID)) ENGINE = INNODB;

CREATE UNIQUE INDEX DX_TEAM_MEMBER ON CORE_TEAM_MEMBER(TEAM_ID, USER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1864.03', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 199, '8:19e2f95851cfb6a5c61f8f12bd333114', 'createTable tableName=CORE_TEAM_MEMBER; createIndex indexName=DX_TEAM_MEMBER, tableName=CORE_TEAM_MEMBER', 'create table team member', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1984.01::flaurens
--  create table item_test_plan_test_suite
CREATE TABLE TEST_SUITE_TEST_PLAN_ITEM (TPI_ID BIGINT NOT NULL, SUITE_ID BIGINT NOT NULL, CONSTRAINT fk_test_suite_test_plan_item_test_plan_item FOREIGN KEY (TPI_ID) REFERENCES ITERATION_TEST_PLAN_ITEM(ITEM_TEST_PLAN_ID), CONSTRAINT fk_test_suite_test_plan_item_test_suite FOREIGN KEY (SUITE_ID) REFERENCES TEST_SUITE(ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1984.01', 'flaurens', 'tm/tm.changelog-1.5.0.xml', NOW(), 200, '8:93c290514f581af3cd51df75bb065da9', 'createTable tableName=TEST_SUITE_TEST_PLAN_ITEM', 'create table item_test_plan_test_suite', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1984.02::flaurens
--  migrate data to table test_suite_test_plan_item
insert into TEST_SUITE_TEST_PLAN_ITEM (TPI_ID, SUITE_ID)
			select ITEM_TEST_PLAN_ID, TEST_SUITE from ITERATION_TEST_PLAN_ITEM
			where TEST_SUITE IS NOT NULL;

ALTER TABLE ITERATION_TEST_PLAN_ITEM DROP FOREIGN KEY fk_itpi_testsuite;

ALTER TABLE ITERATION_TEST_PLAN_ITEM DROP COLUMN TEST_SUITE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1984.02', 'flaurens', 'tm/tm.changelog-1.5.0.xml', NOW(), 201, '8:3ffa83eebe5e3b17e2f783e06c1bc8fe', 'sql; dropForeignKeyConstraint baseTableName=ITERATION_TEST_PLAN_ITEM, constraintName=fk_itpi_testsuite; dropColumn columnName=TEST_SUITE, tableName=ITERATION_TEST_PLAN_ITEM', 'migrate data to table test_suite_test_plan_item', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1902.01::bsiri
--  creating the tables and references for the workspace plugins
CREATE TABLE TEST_CASE_LIBRARY_PLUGINS (LIBRARY_ID BIGINT NOT NULL, PLUGIN_ID VARCHAR(100) NOT NULL, CONSTRAINT fk_plugin_tclib FOREIGN KEY (LIBRARY_ID) REFERENCES TEST_CASE_LIBRARY(TCL_ID)) ENGINE = INNODB;

CREATE TABLE REQUIREMENT_LIBRARY_PLUGINS (LIBRARY_ID BIGINT NOT NULL, PLUGIN_ID VARCHAR(100) NOT NULL, CONSTRAINT fk_plugin_rlib FOREIGN KEY (LIBRARY_ID) REFERENCES REQUIREMENT_LIBRARY(RL_ID)) ENGINE = INNODB;

CREATE TABLE CAMPAIGN_LIBRARY_PLUGINS (LIBRARY_ID BIGINT NOT NULL, PLUGIN_ID VARCHAR(100) NOT NULL, CONSTRAINT fk_plugin_clib FOREIGN KEY (LIBRARY_ID) REFERENCES CAMPAIGN_LIBRARY(CL_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1902.01', 'bsiri', 'tm/tm.changelog-1.5.0.xml', NOW(), 202, '8:cc49ba7569341dba54c4287e4b6ef1ca', 'createTable tableName=TEST_CASE_LIBRARY_PLUGINS; createTable tableName=REQUIREMENT_LIBRARY_PLUGINS; createTable tableName=CAMPAIGN_LIBRARY_PLUGINS', 'creating the tables and references for the workspace plugins', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1984.03::flaurens
--  add column for ordering to table TEST_SUITE_TEST_PLAN_ITEM
ALTER TABLE TEST_SUITE_TEST_PLAN_ITEM ADD TEST_PLAN_ORDER INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1984.03', 'flaurens', 'tm/tm.changelog-1.5.0.xml', NOW(), 203, '8:12bf0cc7b35d36d35ec5a8def84bb07c', 'addColumn tableName=TEST_SUITE_TEST_PLAN_ITEM', 'add column for ordering to table TEST_SUITE_TEST_PLAN_ITEM', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-2003.01::mpagnon
--  Action Steps now cover Requirements versions. We need to create a new table that will be an enhancement of the TEST_CASE_VERIFIED_REQUIREMENT_VERSION one.
--  We drop the constraint of the old TEST_CASE_VERIFIED_REQUIREMENT_VERSION so that we can create ones with the same names on the new REQUIREMENT_VERSION_COVERAGE table
--  The new table is called  "REQUIREMENT_VERSION_COVERAGE"
ALTER TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION DROP FOREIGN KEY fk_verified_req_version;

ALTER TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION DROP FOREIGN KEY fk_verifying_test_case;

ALTER TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION DROP KEY uc_tc_verifies_req_version;

CREATE TABLE REQUIREMENT_VERSION_COVERAGE (REQUIREMENT_VERSION_COVERAGE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'generated surrogate key', VERIFIED_REQ_VERSION_ID BIGINT NULL COMMENT 'FK to the verified requirement version', VERIFYING_TEST_CASE_ID BIGINT NULL COMMENT 'FK to the verifying test case', CONSTRAINT pk_requirement_version_coverage PRIMARY KEY (REQUIREMENT_VERSION_COVERAGE_ID), CONSTRAINT fk_verifying_test_case FOREIGN KEY (VERIFYING_TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID), CONSTRAINT fk_verified_req_version FOREIGN KEY (VERIFIED_REQ_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID)) ENGINE = INNODB;

ALTER TABLE REQUIREMENT_VERSION_COVERAGE MODIFY VERIFIED_REQ_VERSION_ID BIGINT NOT NULL;

ALTER TABLE REQUIREMENT_VERSION_COVERAGE MODIFY VERIFYING_TEST_CASE_ID BIGINT NOT NULL;

ALTER TABLE REQUIREMENT_VERSION_COVERAGE ADD CONSTRAINT uc_tc_verifies_req_version UNIQUE (VERIFIED_REQ_VERSION_ID, VERIFYING_TEST_CASE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-2003.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 204, '8:f6880055add614f749f7cc30aa109492', 'dropForeignKeyConstraint baseTableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION, constraintName=fk_verified_req_version; dropForeignKeyConstraint baseTableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION, constraintName=fk_verifying_test_case; dropUnique...', 'Action Steps now cover Requirements versions. We need to create a new table that will be an enhancement of the TEST_CASE_VERIFIED_REQUIREMENT_VERSION one.
We drop the constraint of the old TEST_CASE_VERIFIED_REQUIREMENT_VERSION so that we can crea...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-2003.02::mpagnon
--  We migrate datas from TEST_CASE_VERIFIED_REQUIREMENT_VERSION to REQUIREMENT_VERSION_COVERAGE.
Insert into REQUIREMENT_VERSION_COVERAGE(VERIFIED_REQ_VERSION_ID, VERIFYING_TEST_CASE_ID)
			select VERIFIED_REQ_VERSION_ID, VERIFYING_TEST_CASE_ID from TEST_CASE_VERIFIED_REQUIREMENT_VERSION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-2003.02', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 205, '8:c11e14595441a13056edc8f8c4eff9da', 'sql', 'We migrate datas from TEST_CASE_VERIFIED_REQUIREMENT_VERSION to REQUIREMENT_VERSION_COVERAGE.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-2003.03::mpagnon
--  We drop the old TEST_CASE_VERIFIED_REQUIREMENT_VERSION table.
DROP TABLE TEST_CASE_VERIFIED_REQUIREMENT_VERSION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-2003.03', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 206, '8:ead4924b2d9a1ad541aa904ff47be503', 'dropTable tableName=TEST_CASE_VERIFIED_REQUIREMENT_VERSION', 'We drop the old TEST_CASE_VERIFIED_REQUIREMENT_VERSION table.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-2003.04::mpagnon
--  Let's add a table VERIFYING_STEPS to hold the steps that are concerned by the requirement coverage
CREATE TABLE VERIFYING_STEPS (REQUIREMENT_VERSION_COVERAGE_ID BIGINT NOT NULL COMMENT 'FK to the concerned requirement-version-coverage', TEST_STEP_ID BIGINT NOT NULL COMMENT 'FK to the concerned action test step', CONSTRAINT fk_verifying_step_requirement_version_coverage FOREIGN KEY (REQUIREMENT_VERSION_COVERAGE_ID) REFERENCES REQUIREMENT_VERSION_COVERAGE(REQUIREMENT_VERSION_COVERAGE_ID), CONSTRAINT fk_verifying_step_action_test_step FOREIGN KEY (TEST_STEP_ID) REFERENCES ACTION_TEST_STEP(TEST_STEP_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-2003.04', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 207, '8:d394f967b4143695a514bef61a8e648c', 'createTable tableName=VERIFYING_STEPS', 'Let''s add a table VERIFYING_STEPS to hold the steps that are concerned by the requirement coverage', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-feat-1966.01::bsiri
--  fixing mysql text data type for Squash schema version 1.4.x and before (see issue 1966). Dev note : it would have been best to use
--  		the tag <modifyColumn> instead of raw sql, because the xml could have been efficiently parsed by the dbdoc generator.
--  		However the dbdoc does not tell which datatype the columns anyway (for now), so let us say that the following raw sql is just fine.
ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY DESCRIPTION longtext;

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY DESCRIPTION longtext;

ALTER TABLE ITERATION MODIFY DESCRIPTION longtext;

ALTER TABLE TEST_SUITE MODIFY DESCRIPTION longtext;

ALTER TABLE PROJECT MODIFY DESCRIPTION longtext;

ALTER TABLE TEST_CASE MODIFY PREREQUISITE longtext;

ALTER TABLE RESOURCE MODIFY DESCRIPTION longtext;

ALTER TABLE REQUIREMENT_LARGE_PROPERTY_CHANGE MODIFY OLD_VALUE longtext;

ALTER TABLE REQUIREMENT_LARGE_PROPERTY_CHANGE MODIFY NEW_VALUE longtext;

ALTER TABLE EXECUTION MODIFY DESCRIPTION longtext;

ALTER TABLE EXECUTION MODIFY PREREQUISITE longtext;

ALTER TABLE EXECUTION_STEP MODIFY ACTION longtext;

ALTER TABLE EXECUTION_STEP MODIFY EXPECTED_RESULT longtext;

ALTER TABLE EXECUTION_STEP MODIFY COMMENT longtext;

ALTER TABLE ACTION_TEST_STEP MODIFY ACTION longtext;

ALTER TABLE ACTION_TEST_STEP MODIFY EXPECTED_RESULT longtext;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-feat-1966.01', 'bsiri', 'tm/tm.changelog-1.5.0.xml', NOW(), 208, '8:767ece40938d9f4eb9d7fa938bdc580a', 'sql', 'fixing mysql text data type for Squash schema version 1.4.x and before (see issue 1966). Dev note : it would have been best to use
		the tag <modifyColumn> instead of raw sql, because the xml could have been efficiently parsed by the dbdoc generat...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-issue-2061.01::mpagnon
--  Because imported test-cases did not have custom-field-values we need to fix the database.
insert into CUSTOM_FIELD_VALUE (BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, CFB_ID, VALUE)
			select tc.TCLN_ID, 'TEST_CASE', binding.CFB_ID, cuf.DEFAULT_VALUE
			from TEST_CASE tc
			join TEST_CASE_LIBRARY_NODE tcln ON tc.TCLN_ID = tcln.TCLN_ID
			join PROJECT project ON tcln.PROJECT_ID = project.PROJECT_ID
			join CUSTOM_FIELD_BINDING binding ON binding.BOUND_PROJECT_ID = project.PROJECT_ID
			join CUSTOM_FIELD cuf ON binding.CF_ID = cuf.CF_ID
			where not exists (
				select * from CUSTOM_FIELD_VALUE val
				where val.BOUND_ENTITY_ID = tc.TCLN_ID
				and val.BOUND_ENTITY_TYPE='TEST_CASE'
				and val.CFB_ID = binding.CFB_ID
			);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-issue-2061.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 209, '8:23803de2900584e5ecb5fe684ab76954', 'sql', 'Because imported test-cases did not have custom-field-values we need to fix the database.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.0.xml::tm-1.5.0.00-issue-2146.01::mpagnon
--  This issue is due to null values in database when @NotNull constraint is present in the bean.
--  		This changeSet we will make all java @NotNull be present in database
--  --------------------REQUIREMENT_PROPERTY_CHANGE----------------------------
--  -------------------REQUIREMENT_LARGE_PROPERTY_CHANGE--------------------
--  ----------------------EXECUTION--------------------------
--  -----------------------REQUIREMENT_VERSION-------------------------
--  ----------------------TEST_CASES-----------------------
--  also fix for [Issue 1895]
UPDATE REQUIREMENT_PROPERTY_CHANGE
			SET PROPERTY_NAME = ''
			WHERE PROPERTY_NAME is null;

ALTER TABLE REQUIREMENT_PROPERTY_CHANGE MODIFY PROPERTY_NAME VARCHAR(100) NOT NULL;

UPDATE REQUIREMENT_LARGE_PROPERTY_CHANGE
			SET PROPERTY_NAME = ''
			WHERE PROPERTY_NAME is null;

ALTER TABLE REQUIREMENT_LARGE_PROPERTY_CHANGE MODIFY PROPERTY_NAME VARCHAR(100) NOT NULL;

UPDATE EXECUTION
			SET REFERENCE = ''
			WHERE REFERENCE is null;

ALTER TABLE EXECUTION MODIFY `REFERENCE` VARCHAR(50) NOT NULL;

ALTER TABLE EXECUTION ALTER `REFERENCE` SET DEFAULT '';

UPDATE EXECUTION
			SET PREREQUISITE = ''
			WHERE PREREQUISITE is null;

ALTER TABLE EXECUTION MODIFY PREREQUISITE LONGTEXT NOT NULL;

UPDATE REQUIREMENT_VERSION
			SET REFERENCE = ''
			WHERE REFERENCE is null;

ALTER TABLE REQUIREMENT_VERSION MODIFY `REFERENCE` VARCHAR(50) NOT NULL;

ALTER TABLE REQUIREMENT_VERSION ALTER `REFERENCE` SET DEFAULT '';

UPDATE TEST_CASE
			SET PREREQUISITE= ''
			WHERE PREREQUISITE is null;

ALTER TABLE TEST_CASE MODIFY PREREQUISITE LONGTEXT NOT NULL;

UPDATE TEST_CASE
			SET REFERENCE = ''
			WHERE REFERENCE is null;

ALTER TABLE TEST_CASE MODIFY `REFERENCE` VARCHAR(50) NOT NULL;

ALTER TABLE TEST_CASE ALTER `REFERENCE` SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.00-issue-2146.01', 'mpagnon', 'tm/tm.changelog-1.5.0.xml', NOW(), 210, '8:480994cb73b1f307f015655b5f5a1f13', 'sql; addNotNullConstraint columnName=PROPERTY_NAME, tableName=REQUIREMENT_PROPERTY_CHANGE; sql; addNotNullConstraint columnName=PROPERTY_NAME, tableName=REQUIREMENT_LARGE_PROPERTY_CHANGE; sql; addNotNullConstraint columnName=REFERENCE, tableName=E...', 'This issue is due to null values in database when @NotNull constraint is present in the bean.
		This changeSet we will make all java @NotNull be present in database
--------------------REQUIREMENT_PROPERTY_CHANGE----------------------------
------...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.1.xml::tm-1.5.1::mpagnon
--  Update TM database version number
UPDATE CORE_CONFIG SET STR_KEY = 'squashtest.tm.database.version', VALUE = '1.5.1' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.1', 'mpagnon', 'tm/tm.changelog-1.5.1.xml', NOW(), 211, '8:d667debef895d572025fd75862960353', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.1.xml::tm-1.5.0.issue-2261-01::mpagnon,bsiri
--  This issue is due to null values in test_suite_test_plan_item.test_plan_order after migration to 1.5.0
--  First we create help table that will help us match the iteration test plan orders with the test-suite's test plan items.
-- ------------------------------------------------------------------------------
			-- create the temporary tables
			-- ------------------------------------------------------------------------------

			create table TEMP_DISCONTINUOUS_SUITE_ITEM(ITEM_ID BIGINT NOT NULL, SUITE_ID BIGINT NOT NULL);

create table TEMP_CONTINUOUS_SUITE_ITEM(ITEM_ID BIGINT NOT NULL, SUITE_ID BIGINT NOT NULL, TP_ORDER INT NOT NULL, DUMMY BIGINT NOT NULL);

-- ------------------------------------------------------------------------------
			-- gather the data that need migration
			-- ------------------------------------------------------------------------------


			insert into TEMP_DISCONTINUOUS_SUITE_ITEM (SUITE_ID, ITEM_ID)
			select tstpitem.SUITE_ID, tstpitem.TPI_ID
			from TEST_SUITE_TEST_PLAN_ITEM tstpitem
			where
				tstpitem.SUITE_ID in (
					select distinct tstpi2.suite_id
					from TEST_SUITE_TEST_PLAN_ITEM tstpi2
					where tstpi2.TEST_PLAN_ORDER is null
				);

-- ------------------------------------------------------------------------------
			-- Code for mysql database to find continuous orders for test suite test plan.
			-- Then we compute continuous orders for test-suite test plan items
			-- ------------------------------------------------------------------------------

			insert into TEMP_CONTINUOUS_SUITE_ITEM ( TP_ORDER, SUITE_ID, ITEM_ID, DUMMY)
			select if(@prevsuite=SUITE_ID,
					  @rownum:=@rownum+1,
				      @rownum:=0)
			TP_ORDER, SUITE_ID, ITEM_ID, (@prevsuite:=SUITE_ID)
			from
			TEMP_DISCONTINUOUS_SUITE_ITEM tdsi, (SELECT @rownum:=0) r, (SELECT @prevsuite:=0) s
			order by SUITE_ID, TP_ORDER;

-- ------------------------------------------------------------------------------
			-- And finally we set the right orders in the concerned table without forgetting to delete the help tables.
			-- ------------------------------------------------------------------------------

			update TEST_SUITE_TEST_PLAN_ITEM
			set TEST_PLAN_ORDER =
				(select TEMP_CONTINUOUS_SUITE_ITEM.TP_ORDER
				from  TEMP_CONTINUOUS_SUITE_ITEM
				where TEMP_CONTINUOUS_SUITE_ITEM.SUITE_ID = TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID
				and TEST_SUITE_TEST_PLAN_ITEM.TPI_ID = TEMP_CONTINUOUS_SUITE_ITEM.ITEM_ID)
			where
				SUITE_ID in (
					select distinct tcsi2.SUITE_ID from TEMP_CONTINUOUS_SUITE_ITEM tcsi2
				);

-- ------------------------------------------------------------------------------
			-- drop the temp tables
			-- ------------------------------------------------------------------------------

			drop table TEMP_DISCONTINUOUS_SUITE_ITEM;

drop table TEMP_CONTINUOUS_SUITE_ITEM;

-- ------------------------------------------------------------------------------
			-- enforce the security on that column
			-- ------------------------------------------------------------------------------

			alter table TEST_SUITE_TEST_PLAN_ITEM modify TEST_PLAN_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.5.0.issue-2261-01', 'mpagnon,bsiri', 'tm/tm.changelog-1.5.1.xml', NOW(), 212, '8:5cdd869204dac97550e46b24fc71985d', 'sql', 'This issue is due to null values in test_suite_test_plan_item.test_plan_order after migration to 1.5.0
First we create help table that will help us match the iteration test plan orders with the test-suite''s test plan items.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.5.1.xml::tm-1.5.0.issue-2261-02-postgresql::mpagnon,bsiri
--  This issue is due to null values in test_suite_test_plan_item.test_plan_order after migration to 1.5.0
--  First we create help table that will help us match the iteration test plan orders with the test-suite's test plan items.
--  drop the temp tables
--  enforce the security on that column
--  Changeset tm/tm.changelog-1.5.1.xml::tm-1.5.0.issue-2261-02::mpagnon,bsiri
--  This issue is due to null values in test_suite_test_plan_item.test_plan_order after migration to 1.5.0
--  First we create help table that will help us match the iteration test plan orders with the test-suite's test plan items.
--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0::mpagnon
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.6.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', NOW(), 213, '8:84970f7425d89df00712293dba61866a', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2334-01::flaurens
--  Change type of column description in table core_team
CREATE TABLE CORE_TEAM_TEMP (ID BIGINT DEFAULT null NULL, `DESCRIPTION` LONGTEXT DEFAULT null NULL) ENGINE = INNODB;

insert into CORE_TEAM_TEMP (ID, DESCRIPTION)
			select PARTY_ID, DESCRIPTION from CORE_TEAM;

ALTER TABLE CORE_TEAM DROP COLUMN `DESCRIPTION`;

ALTER TABLE CORE_TEAM ADD `DESCRIPTION` LONGTEXT DEFAULT null NULL;

update CORE_TEAM ct
            set DESCRIPTION = (select ctt.DESCRIPTION
                               from CORE_TEAM_TEMP ctt
                               where ctt.ID = ct.PARTY_ID);

DROP TABLE CORE_TEAM_TEMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2334-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', NOW(), 214, '8:694074944d1b6e20e367f03d838e7f77', 'createTable tableName=CORE_TEAM_TEMP; sql; dropColumn columnName=DESCRIPTION, tableName=CORE_TEAM; addColumn tableName=CORE_TEAM; sql; dropTable tableName=CORE_TEAM_TEMP', 'Change type of column description in table core_team', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.feat-1101-01::mpagnon
--  Add table to handle test cases PARAMETERS
CREATE TABLE PARAMETER (PARAM_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'the PARAMETER primary key', NAME VARCHAR(255) DEFAULT '' NOT NULL COMMENT 'the parameter name, should be unique among parameters of the same test case', TEST_CASE_ID BIGINT NOT NULL COMMENT 'the test case where the parameter is declared', `DESCRIPTION` LONGTEXT NOT NULL COMMENT 'the description of the parameter', CONSTRAINT pk_parameter PRIMARY KEY (PARAM_ID), CONSTRAINT fk_parameter_test_case FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

ALTER TABLE PARAMETER ADD UNIQUE (NAME, TEST_CASE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.feat-1101-01', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', NOW(), 215, '8:7e472cea2bfbeb95236406d8d5ca915f', 'createTable tableName=PARAMETER; addUniqueConstraint tableName=PARAMETER', 'Add table to handle test cases PARAMETERS', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.feat-1101-02::mpagnon
--  Add tables to handle test cases DATASETS
CREATE TABLE DATASET (DATASET_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'the DATASET primary key', NAME VARCHAR(255) DEFAULT '' NOT NULL COMMENT 'the dataset name, should be unique among parameters of the same test case', TEST_CASE_ID BIGINT NOT NULL COMMENT 'the test case where the parameter is declared', CONSTRAINT pk_dataset PRIMARY KEY (DATASET_ID), CONSTRAINT fk_dataset_test_case FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

ALTER TABLE DATASET ADD UNIQUE (NAME, TEST_CASE_ID);

CREATE TABLE DATASET_PARAM_VALUE (DATASET_PARAM_VALUE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'the DATASET_PARAM_VALUE primary key', DATASET_ID BIGINT NOT NULL COMMENT 'the dataset holding the value for the parameter', PARAM_ID BIGINT NOT NULL COMMENT 'the parameter to set the value of', PARAM_VALUE VARCHAR(255) DEFAULT '' NOT NULL COMMENT 'the value for the parameter in the dataset', CONSTRAINT pk_dataset_param_value PRIMARY KEY (DATASET_PARAM_VALUE_ID), CONSTRAINT fk_dataset_param_value_dataset FOREIGN KEY (DATASET_ID) REFERENCES DATASET(DATASET_ID), CONSTRAINT fk_dataset_param_value_param FOREIGN KEY (PARAM_ID) REFERENCES PARAMETER(PARAM_ID)) ENGINE = INNODB;

ALTER TABLE DATASET_PARAM_VALUE ADD UNIQUE (DATASET_ID, PARAM_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.feat-1101-02', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', NOW(), 216, '8:2467d49174e0943b8d5906d10c36acb3', 'createTable tableName=DATASET; addUniqueConstraint tableName=DATASET; createTable tableName=DATASET_PARAM_VALUE; addUniqueConstraint tableName=DATASET_PARAM_VALUE', 'Add tables to handle test cases DATASETS', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.feat-1128-01::mpagnon
--  Add column to bind a test plan item to a DATASET
ALTER TABLE ITERATION_TEST_PLAN_ITEM ADD DATASET_ID BIGINT NULL COMMENT 'the dataset the test plan item should use to replace the parameters in new execution steps';

ALTER TABLE ITERATION_TEST_PLAN_ITEM ADD CONSTRAINT fk_iteration_test_plan_item_dataset FOREIGN KEY (DATASET_ID) REFERENCES DATASET (DATASET_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.feat-1128-01', 'mpagnon', 'tm/tm.changelog-1.6.0.xml', NOW(), 217, '8:073426e993c97f1e37629c0d6f6c2ef9', 'addColumn tableName=ITERATION_TEST_PLAN_ITEM', 'Add column to bind a test plan item to a DATASET', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2203-01::flaurens
--  remove inactive users from all teams
delete from CORE_TEAM_MEMBER
			where USER_ID in (select cu.PARTY_ID
			                  from CORE_USER cu
			                  where cu.ACTIVE = false);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2203-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', NOW(), 218, '8:58fb190c17063540b58234793162b412', 'sql', 'remove inactive users from all teams', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2203-02::flaurens
--  remove core rights of inactive users
delete from CORE_GROUP_MEMBER
			where PARTY_ID in (select cu.PARTY_ID
			                   from CORE_USER cu
			                   where cu.ACTIVE = false);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2203-02', 'flaurens', 'tm/tm.changelog-1.6.0.xml', NOW(), 219, '8:794203f439413516472851390612f223', 'sql', 'remove core rights of inactive users', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2203-03::flaurens
--  remove acl rights of inactive users
delete from ACL_RESPONSIBILITY_SCOPE_ENTRY
			where PARTY_ID in (select cu.PARTY_ID
			                   from CORE_USER cu
			                   where cu.ACTIVE = false);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2203-03', 'flaurens', 'tm/tm.changelog-1.6.0.xml', NOW(), 220, '8:702109314d54d654f8702d9294c0a1ee', 'sql', 'remove acl rights of inactive users', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2454-01::bsiri
--  cleaning test suite test plan ordering : some collections have non-contiguous elements. This
--  		is due to issue #2454, because of shortcomings in the code in charge of deleting test cases and dependent
--  		entities.
--  			It looks pretty much like tm-1.5.0.issue-2261-01 (in the 1.5.1 changelog), except we're not dealing with order = null.
--  
--  			Note : this script might already have been executed if at some point Squash 1.5.2 was used.
-- ------------------------------------------------------------------------------
			-- create the temporary tables
			-- ------------------------------------------------------------------------------

			create table TEMP_DISCONTINUOUS_SUITE_ITEM(ITEM_ID BIGINT NOT NULL, SUITE_ID BIGINT NOT NULL);

create table TEMP_CONTINUOUS_SUITE_ITEM(ITEM_ID BIGINT NOT NULL, SUITE_ID BIGINT NOT NULL, TP_ORDER INT NOT NULL, DUMMY BIGINT NOT NULL);

-- ------------------------------------------------------------------------------
			-- gather the data that need migration
			-- ------------------------------------------------------------------------------

			insert into TEMP_DISCONTINUOUS_SUITE_ITEM (SUITE_ID, ITEM_ID)
			select tstpitem.suite_id, tstpitem.tpi_id
			from TEST_SUITE_TEST_PLAN_ITEM tstpitem
			order by tstpitem.suite_id,  tstpitem.test_plan_order;

-- ------------------------------------------------------------------------------
			-- Code for mysql database to find continuous orders for test suite test plan.
			-- Then we compute continuous orders for test-suite test plan items
			-- ------------------------------------------------------------------------------

			insert into TEMP_CONTINUOUS_SUITE_ITEM ( TP_ORDER, SUITE_ID, ITEM_ID, DUMMY)
			select if(@prevsuite=SUITE_ID,
					  @rownum:=@rownum+1,
				      @rownum:=0)
			TP_ORDER, SUITE_ID, ITEM_ID, (@prevsuite:=SUITE_ID)
			from
			TEMP_DISCONTINUOUS_SUITE_ITEM tdsi, (SELECT @rownum:=0) r, (SELECT @prevsuite:=0) s
			order by SUITE_ID, TP_ORDER;

-- ------------------------------------------------------------------------------
			-- And finally we set the right orders in the concerned table without forgetting to delete the help tables.
			-- ------------------------------------------------------------------------------

			update TEST_SUITE_TEST_PLAN_ITEM
			set TEST_PLAN_ORDER =
				(select TEMP_CONTINUOUS_SUITE_ITEM.TP_ORDER
				from  TEMP_CONTINUOUS_SUITE_ITEM
				where TEMP_CONTINUOUS_SUITE_ITEM.SUITE_ID = TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID
				and TEST_SUITE_TEST_PLAN_ITEM.TPI_ID = TEMP_CONTINUOUS_SUITE_ITEM.ITEM_ID)
			where
				SUITE_ID in (
					select distinct tcsi2.SUITE_ID from TEMP_CONTINUOUS_SUITE_ITEM tcsi2
				);

-- ------------------------------------------------------------------------------
			-- drop the temp tables
			-- ------------------------------------------------------------------------------

			drop table TEMP_DISCONTINUOUS_SUITE_ITEM;

drop table TEMP_CONTINUOUS_SUITE_ITEM;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2454-01', 'bsiri', 'tm/tm.changelog-1.6.0.xml', NOW(), 221, '8:79608767aec1d03030279efb78f23813', 'sql', 'cleaning test suite test plan ordering : some collections have non-contiguous elements. This
		is due to issue #2454, because of shortcomings in the code in charge of deleting test cases and dependent
		entities.
			It looks pretty much like tm-1....', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2454-02::bsiri
--  cleaning test suite test plan ordering : some collections have non-contiguous elements. This
--  		is due to issue #2454, because of shortcomings in the code in charge of deleting test cases and dependent
--  		entities.
--  			It looks pretty much like tm-1.5.0.issue-2261-01 (in the 1.5.1 changelog), except we're not dealing with order = null.
--  
--  			Note : this script might already have been executed if at some point Squash 1.5.2 was used.
--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2454-02-postgresql::mpagnon
--  cleaning test suite test plan ordering : some collections have non-contiguous elements. This
--  		is due to issue #2454, because of shortcomings in the code in charge of deleting test cases and dependent
--  		entities.
--  			It looks pretty much like tm-1.5.0.issue-2261-01 (in the 1.5.1 changelog), except we're not dealing with order = null.
--  
--  			Note : this script might already have been executed if at some point Squash 1.5.2 was used.
--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2474-01::bsiri
--  fixes the action test steps having no custom fields when copied from one project to another. Works for both mysql and h2.
insert into CUSTOM_FIELD_VALUE(bound_entity_id, bound_entity_type, cfb_id, value)
			select ats.test_step_id, 'TEST_STEP',  cfb.cfb_id, cf.default_value
			from ACTION_TEST_STEP ats
			inner join TEST_CASE_STEPS tcs on ats.test_step_id = tcs.step_id
			inner join TEST_CASE_LIBRARY_NODE tcln on tcs.test_case_id = tcln.tcln_id
			inner join CUSTOM_FIELD_BINDING cfb on tcln.project_id = cfb.bound_project_id
			inner join CUSTOM_FIELD cf on cfb.cf_id = cf.cf_id
			where cfb.bound_entity = 'TEST_STEP'
			and ats.test_step_id not in (
				select cfv2.bound_entity_id
				from CUSTOM_FIELD_VALUE cfv2
				inner join CUSTOM_FIELD_BINDING cfb2 on cfv2.cfb_id = cfb2.cfb_id
				where cfb2.bound_entity = 'TEST_STEP'
				and cfb2.bound_project_id = cfb.bound_project_id
			);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2474-01', 'bsiri', 'tm/tm.changelog-1.6.0.xml', NOW(), 222, '8:09ab8b482d1a03ac958f883056b52a8c', 'sql', 'fixes the action test steps having no custom fields when copied from one project to another. Works for both mysql and h2.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2485-01::flaurens
--  replaces fk-constraint which wrongly cascades the deletion of denormalized field values
ALTER TABLE DENORMALIZED_FIELD_VALUE DROP FOREIGN KEY fk_dfv_cfv_binding;

ALTER TABLE DENORMALIZED_FIELD_VALUE ADD CONSTRAINT fk_dfv_cfv_binding FOREIGN KEY (CFV_ID) REFERENCES CUSTOM_FIELD_VALUE (CFV_ID) ON DELETE SET NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2485-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', NOW(), 223, '8:2e2b194d7eb3af45f3c9d92a3eb26c8e', 'dropForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_VALUE, constraintName=fk_dfv_cfv_binding; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_VALUE, constraintName=fk_dfv_cfv_binding, referencedTableName=CUSTOM_FIELD_VALUE', 'replaces fk-constraint which wrongly cascades the deletion of denormalized field values', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.6.0.xml::tm-1.6.0.issue-2536-01::flaurens
--  giving testrunners reading rights on projects
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.project.Project'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.6.0.issue-2536-01', 'flaurens', 'tm/tm.changelog-1.6.0.xml', NOW(), 224, '8:85bbad401d41bee173273597b6d6809b', 'insert tableName=ACL_GROUP_PERMISSION', 'giving testrunners reading rights on projects', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.7.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0', 'bsiri', 'tm/tm.changelog-1.7.0.xml', NOW(), 225, '8:2bc98fe63621679dd7cc8436de5b62d8', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1107-01::bsiri
--  Modifying RLN_RELATIONSHIP and RLN_RELATIONSHIP_CLOSURE : requirements can now accept more requirements 
--  		(but no folders). Cautious : there is no way to express that a a requirement can only accept requirements as children.
ALTER TABLE RLN_RELATIONSHIP DROP FOREIGN KEY fk_rln_relationship_ancestor;

ALTER TABLE RLN_RELATIONSHIP DROP FOREIGN KEY fk_rln_relationship_descendant;

ALTER TABLE RLN_RELATIONSHIP ADD CONSTRAINT fk_rln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES REQUIREMENT_LIBRARY_NODE (RLN_ID);

ALTER TABLE RLN_RELATIONSHIP ADD CONSTRAINT fk_rln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES REQUIREMENT_LIBRARY_NODE (RLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1107-01', 'bsiri', 'tm/tm.changelog-1.7.0.xml', NOW(), 226, '8:38f2b9ae47fb1c6f007b81044945d8fc', 'dropForeignKeyConstraint baseTableName=RLN_RELATIONSHIP, constraintName=fk_rln_relationship_ancestor; dropForeignKeyConstraint baseTableName=RLN_RELATIONSHIP, constraintName=fk_rln_relationship_descendant; addForeignKeyConstraint baseTableName=RLN...', 'Modifying RLN_RELATIONSHIP and RLN_RELATIONSHIP_CLOSURE : requirements can now accept more requirements 
		(but no folders). Cautious : there is no way to express that a a requirement can only accept requirements as children.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1090-01::flaurens
--  adding entries for indexing dates in table core_config
INSERT INTO CORE_CONFIG (STR_KEY) VALUES ('lastindexing.requirement.date');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1090-01', 'flaurens', 'tm/tm.changelog-1.7.0.xml', NOW(), 227, '8:5b695760ae999387bf5ec72c3bf62a5c', 'insert tableName=CORE_CONFIG', 'adding entries for indexing dates in table core_config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1090-02::flaurens
--  adding entries for indexing dates in table core_config
INSERT INTO CORE_CONFIG (STR_KEY) VALUES ('lastindexing.testcase.date');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1090-02', 'flaurens', 'tm/tm.changelog-1.7.0.xml', NOW(), 228, '8:d4e5119ff3110db39b779b3c0666adbf', 'insert tableName=CORE_CONFIG', 'adding entries for indexing dates in table core_config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1090-03::flaurens
--  adding entries for indexing dates in table core_config
INSERT INTO CORE_CONFIG (STR_KEY) VALUES ('lastindexing.campaign.date');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1090-03', 'flaurens', 'tm/tm.changelog-1.7.0.xml', NOW(), 229, '8:05ed2acfebdcc619c59b89495a1a796d', 'insert tableName=CORE_CONFIG', 'adding entries for indexing dates in table core_config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1090-04::flaurens
--  adding entries for indexing versions in table core_config
INSERT INTO CORE_CONFIG (STR_KEY) VALUES ('lastindexing.requirement.version');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1090-04', 'flaurens', 'tm/tm.changelog-1.7.0.xml', NOW(), 230, '8:f7c58d0ed017d1deab7db7332cc80bc3', 'insert tableName=CORE_CONFIG', 'adding entries for indexing versions in table core_config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1090-05::flaurens
--  adding entries for indexing versions in table core_config
INSERT INTO CORE_CONFIG (STR_KEY) VALUES ('lastindexing.testcase.version');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1090-05', 'flaurens', 'tm/tm.changelog-1.7.0.xml', NOW(), 231, '8:7088947921b455d7ae7f4bba555f77c3', 'insert tableName=CORE_CONFIG', 'adding entries for indexing versions in table core_config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-1090-06::flaurens
--  adding entries for indexing versions in table core_config
INSERT INTO CORE_CONFIG (STR_KEY) VALUES ('lastindexing.campaign.version');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-1090-06', 'flaurens', 'tm/tm.changelog-1.7.0.xml', NOW(), 232, '8:69f283ea9cfaf80cfac57360dd3b2fd3', 'insert tableName=CORE_CONFIG', 'adding entries for indexing versions in table core_config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.0.xml::tm-1.7.0.feat-2648::mpagnon
--  add permission EXTENDED_DELETE to Project Manager on Campaign library
--  add permission EXPORT to Test Runner on Requirement library
--  add permission EXPORT to Test Runner on Test-case library
--  remove permission WRITE to Advance tester on Campaign library
--  remove permission CREATE to Advance tester on Campaign library
--  remove permission DELETE to Advance tester on Campaign library
--  remove permission LINK to Advance tester on Campaign library
--  add permission EXPORT to Advance tester on Requirement library
--  add permission LINK to Advance tester on Requirement library
--  remove permission ATTACH to Advance tester on Test-case library
--  add permission LINK to Advance tester on Test-case library
--  add permission WRITE to Validator on Requirement library
--  add permission ATTACH to Validator on Requirement library
--  add permission WRITE to Validator on Test-case library
--  add permission ATTACH to Validator on Test-case library
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2048', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.testcase.TestCaseLibrary'));

DELETE FROM ACL_GROUP_PERMISSION WHERE ACL_GROUP_ID = (select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester')
				and PERMISSION_MASK = 2
				and CLASS_ID = (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary');

DELETE FROM ACL_GROUP_PERMISSION WHERE ACL_GROUP_ID = (select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester')
				and PERMISSION_MASK = 4
				and CLASS_ID = (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary');

DELETE FROM ACL_GROUP_PERMISSION WHERE ACL_GROUP_ID = (select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester')
				and PERMISSION_MASK = 8
				and CLASS_ID = (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary');

DELETE FROM ACL_GROUP_PERMISSION WHERE ACL_GROUP_ID = (select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester')
				and PERMISSION_MASK = 256
				and CLASS_ID = (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '64', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.requirement.RequirementLibrary'));

DELETE FROM ACL_GROUP_PERMISSION WHERE ACL_GROUP_ID = (select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester')
				and PERMISSION_MASK = 1024
				and CLASS_ID = (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.testcase.TestCaseLibrary');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '256', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.requirement.RequirementLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.0.feat-2648', 'mpagnon', 'tm/tm.changelog-1.7.0.xml', NOW(), 233, '8:9e14362311c84e802e1b7dd0a76a96fd', 'insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; insert tableName=ACL_GROUP_PERMISSION; delete tableName=ACL_GROUP_PERMISSION; delete tableName=ACL_GROUP_PERMISSION; delete tableName=ACL_GROUP_PERMISSION; delete tableN...', 'add permission EXTENDED_DELETE to Project Manager on Campaign library
add permission EXPORT to Test Runner on Requirement library
add permission EXPORT to Test Runner on Test-case library
remove permission WRITE to Advance tester on Campaign libra...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1::mpagnon
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.7.1' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 234, '8:9fb57c775efdc1df8328e60e9451dbfe', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-01::mpagnon
--  Delete ghost executions
--  create table to store the id of entities to delete
CREATE TABLE ENTITIES_TO_DELETE (ENTITY_NAME VARCHAR(30) NULL, ENTITY_ID BIGINT NULL) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-01', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 235, '8:7272f8f2270ba64bde072ffb28e34500', 'createTable tableName=ENTITIES_TO_DELETE', 'Delete ghost executions
create table to store the id of entities to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-02::mpagnon
--  Store the ids of the ghost executions
insert into ENTITIES_TO_DELETE (ENTITY_NAME, ENTITY_ID)
			select distinct 'EXECUTION', E.EXECUTION_ID
			from EXECUTION E left outer join ITEM_TEST_PLAN_EXECUTION ITPE
			on E.EXECUTION_ID = ITPE.EXECUTION_ID
			where ITPE.EXECUTION_ID is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-02', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 236, '8:c15f92dd81b0c9c31614090a8c56978c', 'sql', 'Store the ids of the ghost executions', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-03::mpagnon
--  Store the ids of the execution steps
insert into ENTITIES_TO_DELETE (ENTITY_NAME, ENTITY_ID)
			select
			'EXECUTION_STEP', ES.EXECUTION_STEP_ID
			from EXECUTION_STEP ES, EXECUTION_EXECUTION_STEPS EES, ENTITIES_TO_DELETE ETD
			where ES.EXECUTION_STEP_ID = EES.EXECUTION_STEP_ID
			and EES.EXECUTION_ID =	ETD.ENTITY_ID
			and ETD.ENTITY_NAME = 'EXECUTION';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-03', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 237, '8:5ef52276cc018068dc1991cfd87d619a', 'sql', 'Store the ids of the execution steps', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-04::mpagnon
--  Store the ids of the issue lists to delete
insert into ENTITIES_TO_DELETE (ENTITY_NAME, ENTITY_ID)
			select 'ISSUE_LIST', E.ISSUE_LIST_ID
			from EXECUTION E,  ENTITIES_TO_DELETE ETD
			where E.EXECUTION_ID = ETD.ENTITY_ID
			and ETD.ENTITY_NAME = 'EXECUTION';

insert into ENTITIES_TO_DELETE (ENTITY_NAME, ENTITY_ID)
			select 'ISSUE_LIST', ES.ISSUE_LIST_ID
			from   EXECUTION_STEP ES,  ENTITIES_TO_DELETE ETD2
			where ES.EXECUTION_STEP_ID = ETD2.ENTITY_ID
			and	ETD2.ENTITY_NAME = 'EXECUTION_STEP';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-04', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 238, '8:71001eefb8d42caf4254974e320560f9', 'sql; sql', 'Store the ids of the issue lists to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-05::mpagnon
--  Store the ids of the issue lists to delete
insert into ENTITIES_TO_DELETE (ENTITY_NAME, ENTITY_ID)
			select 'ATTACHMENT_LIST', E.ATTACHMENT_LIST_ID
			from EXECUTION E,  ENTITIES_TO_DELETE ETD
			where  E.EXECUTION_ID = ETD.ENTITY_ID
			and ETD.ENTITY_NAME = 'EXECUTION';

insert into ENTITIES_TO_DELETE (ENTITY_NAME, ENTITY_ID)
			select 'ATTACHMENT_LIST', ES.ATTACHMENT_LIST_ID
			from  EXECUTION_STEP ES,  ENTITIES_TO_DELETE ETD2
			where  ES.EXECUTION_STEP_ID = ETD2.ENTITY_ID
			and	ETD2.ENTITY_NAME = 'EXECUTION_STEP';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-05', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 239, '8:d863755915078c39df6ba89e904decb3', 'sql; sql', 'Store the ids of the issue lists to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-06::mpagnon
--  DELETE Issues of execution and execution steps to delete
DELETE FROM ISSUE WHERE exists (
				select 1
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'ISSUE_LIST'
				and ENTITY_ID = ISSUE_LIST_ID
				);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-06', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 240, '8:2a83700005cdc28dea66c8c684614489', 'delete tableName=ISSUE', 'DELETE Issues of execution and execution steps to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-07::mpagnon
--  DELETE Automated execution extender of executions to delete
DELETE FROM AUTOMATED_EXECUTION_EXTENDER WHERE exists (
				select	1 
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'EXECUTION'
				and ENTITY_ID = MASTER_EXECUTION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-07', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 241, '8:ff7b8bc5a12da202bc90530ec6cb4fdd', 'delete tableName=AUTOMATED_EXECUTION_EXTENDER', 'DELETE Automated execution extender of executions to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-08::mpagnon
--  DELETE automated suites that are not linked to any automated execution extender
DELETE FROM AUTOMATED_SUITE WHERE not exists (
				select 1
				from AUTOMATED_EXECUTION_EXTENDER
				where AUTOMATED_SUITE.SUITE_ID = AUTOMATED_EXECUTION_EXTENDER.SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-08', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 242, '8:f4bdb1e5374512923e80ab8d71eb4373', 'delete tableName=AUTOMATED_SUITE', 'DELETE automated suites that are not linked to any automated execution extender', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-09::mpagnon
--  Delete execution steps of ghost executions
DELETE FROM EXECUTION_EXECUTION_STEPS WHERE exists (
				select 1 
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'EXECUTION_STEP'
				and ENTITY_ID = EXECUTION_STEP_ID);

DELETE FROM EXECUTION_STEP WHERE exists (
				select 1 
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'EXECUTION_STEP'
				and EXECUTION_STEP_ID = ENTITY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-09', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 243, '8:c5721418be2eb4249876cbce4e4c88eb', 'delete tableName=EXECUTION_EXECUTION_STEPS; delete tableName=EXECUTION_STEP', 'Delete execution steps of ghost executions', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-10::mpagnon
--  Delete ghost executions
DELETE FROM EXECUTION WHERE exists (
				select 1 
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'EXECUTION'
				and EXECUTION_ID = ENTITY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-10', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 244, '8:1156cb430ad5b69595e8d19502495cde', 'delete tableName=EXECUTION', 'Delete ghost executions', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-11::mpagnon
--  DELETE Attachments of execution and execution steps to delete
DELETE FROM ATTACHMENT WHERE exists (
				select 1
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'ATTACHMENT_LIST'
				and ENTITY_ID = ATTACHMENT_LIST_ID
				);

DELETE FROM ATTACHMENT_CONTENT WHERE not exists (
				select 1
				from ATTACHMENT
				where CONTENT_ID = ATTACHMENT_CONTENT_ID
				);

DELETE FROM ATTACHMENT_LIST WHERE exists (
				select 1
				from ENTITIES_TO_DELETE
				where ENTITY_NAME = 'ATTACHMENT_LIST'
				and ATTACHMENT_LIST_ID = ENTITY_ID
				);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-11', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 245, '8:c0efea33fdf229f3f19da5016117e61f', 'delete tableName=ATTACHMENT; delete tableName=ATTACHMENT_CONTENT; delete tableName=ATTACHMENT_LIST', 'DELETE Attachments of execution and execution steps to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-12::mpagnon
--  DELETE issue lists of executions and execution-steps to delete
DELETE FROM ISSUE_LIST WHERE exists (
				select 1 
				from ENTITIES_TO_DELETE
				where ENTITY_NAME ='ISSUE_LIST'
				and ENTITY_ID = ISSUE_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-12', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 246, '8:469b75e66f5a61c58781b5d1580b8b49', 'delete tableName=ISSUE_LIST', 'DELETE issue lists of executions and execution-steps to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.7.1.xml::tm-1.7.1.issue-2873-13::mpagnon
--  Drop table used to store the ids of the entities to delete
DROP TABLE ENTITIES_TO_DELETE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.7.1.issue-2873-13', 'mpagnon', 'tm/tm.changelog-1.7.1.xml', NOW(), 247, '8:dc231f69059c5088b3d1a2c631639652', 'dropTable tableName=ENTITIES_TO_DELETE', 'Drop table used to store the ids of the entities to delete', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0::mpagnon
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.8.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.0', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', NOW(), 248, '8:8b6b499d7389ff8110221970eb80c9a7', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0.feat-2688::mpagnon
--  add permission READ_UNASSIGNED on Campaign library for all users but TestRunners
insert into ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      select ACL_GROUP.ID, 4096, ACL_CLASS.ID
      from ACL_GROUP , ACL_CLASS
      where ACL_GROUP.QUALIFIED_NAME != 'squashtest.acl.group.tm.TestRunner'
      and ACL_CLASS.CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.0.feat-2688', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', NOW(), 249, '8:56601fe862e0e0ba8c8a4815ab83b5f7', 'sql', 'add permission READ_UNASSIGNED on Campaign library for all users but TestRunners', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0.issue-1846-02::mpagnon
--  Remove the DELETED_ON columns
ALTER TABLE CAMPAIGN_LIBRARY_NODE DROP COLUMN DELETED_ON;

ALTER TABLE TEST_CASE_LIBRARY_NODE DROP COLUMN DELETED_ON;

ALTER TABLE REQUIREMENT_LIBRARY_NODE DROP COLUMN DELETED_ON;

ALTER TABLE ITERATION DROP COLUMN DELETED_ON;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.0.issue-1846-02', 'mpagnon', 'tm/tm.changelog-1.8.0.xml', NOW(), 250, '8:6673cb98a415026d6fef23212ce1eeb2', 'dropColumn columnName=DELETED_ON, tableName=CAMPAIGN_LIBRARY_NODE; dropColumn columnName=DELETED_ON, tableName=TEST_CASE_LIBRARY_NODE; dropColumn columnName=DELETED_ON, tableName=REQUIREMENT_LIBRARY_NODE; dropColumn columnName=DELETED_ON, tableNam...', 'Remove the DELETED_ON columns', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0.issue-3009-01::bsiri
--  As of 1.8.0 anyone that executes a test becomes de facto its assignee. This changeset will update the iteration
--  			test plan items and assign it to the last executor (if any) if it hasn't an assignee already
update ITERATION_TEST_PLAN_ITEM itpi
      set USER_ID = (select cu.PARTY_ID from CORE_USER cu where cu.LOGIN = itpi.LAST_EXECUTED_BY)
      where itpi.USER_ID IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.0.issue-3009-01', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 251, '8:a0cfe094f7eb99ad49cd260803846c5e', 'sql', 'As of 1.8.0 anyone that executes a test becomes de facto its assignee. This changeset will update the iteration
			test plan items and assign it to the last executor (if any) if it hasn''t an assignee already', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::core-1.8.0-feat-2699-00::bsiri
--  actually remove user accounts that were deactivated
delete from CORE_TEAM_MEMBER
      where USER_ID in (
      select PARTY_ID from CORE_USER
      where ACTIVE= false
      );

delete from CORE_GROUP_MEMBER
      where PARTY_ID in (
      select PARTY_ID from CORE_USER
      where ACTIVE= false
      );

update ITERATION_TEST_PLAN_ITEM SET USER_ID = NULL WHERE USER_ID IN (SELECT PARTY_ID FROM CORE_USER WHERE active = false );

update CAMPAIGN_TEST_PLAN_ITEM SET USER_ID = NULL WHERE USER_ID IN (SELECT PARTY_ID FROM CORE_USER WHERE active =
      false );

delete from CORE_USER where active = false;

delete from CORE_PARTY where PARTY_ID not in
      (select PARTY_ID from CORE_USER)
      and PARTY_ID not in
      (select PARTY_ID from CORE_TEAM);

delete from AUTH_USER where active= false;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-1.8.0-feat-2699-00', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 252, '8:bf8b1e3ef0b1c9b26541538750aeb153', 'sql', 'actually remove user accounts that were deactivated', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::core-1.8.0-feat-2699-01::bsiri
--  the CORE_GROUP squashtest.tm.group.User is now renamed to the normalized squashtest.authz.group.tm.User
UPDATE CORE_GROUP SET QUALIFIED_NAME = 'squashtest.authz.group.tm.User' WHERE ID = 2;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-1.8.0-feat-2699-01', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 253, '8:164df9ae9d3f977b88d2ab101b6ccb1f', 'update tableName=CORE_GROUP', 'the CORE_GROUP squashtest.tm.group.User is now renamed to the normalized squashtest.authz.group.tm.User', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::core-1.8.0-feat-2699-02::bsiri
--  the CORE_GROUP squashtest.authz.tm.group.ProjectManager is deleted and the users belonging to that group are now
--  		demoted to squashtest.authz.group.tm.User
UPDATE CORE_GROUP_MEMBER SET GROUP_ID = '2' WHERE GROUP_ID = 3;

DELETE FROM CORE_GROUP_AUTHORITY WHERE GROUP_ID = 3;

DELETE FROM CORE_GROUP WHERE ID = 3;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-1.8.0-feat-2699-02', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 254, '8:bca2911749887a9a1b375d20a595dc83', 'update tableName=CORE_GROUP_MEMBER; delete tableName=CORE_GROUP_AUTHORITY; delete tableName=CORE_GROUP', 'the CORE_GROUP squashtest.authz.tm.group.ProjectManager is deleted and the users belonging to that group are now
		demoted to squashtest.authz.group.tm.User', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::core-1.8.0-feat-2699-03::bsiri
--  The table CORE_PARY_AUTHORITY stores personal authorities. As for TM 1.8.0 the users and teams now have blanket permissions
--  			(aka authorities) for themselves, not only via core_group membership. However, a user will still belong to one of the CORE_GROUPs and
--  			the personal authorities will stack with the authorities of the group they belong to.
CREATE TABLE CORE_PARTY_AUTHORITY (PARTY_ID BIGINT NOT NULL COMMENT 'The CORE_PARTY ', AUTHORITY VARCHAR(50) NOT NULL COMMENT 'The authority', CONSTRAINT FK_PARTY_AUTHORITY_PARTY FOREIGN KEY (PARTY_ID) REFERENCES CORE_PARTY(PARTY_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-1.8.0-feat-2699-03', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 255, '8:be47ff6ce0b7158c0ca139853ce283fd', 'createTable tableName=CORE_PARTY_AUTHORITY', 'The table CORE_PARY_AUTHORITY stores personal authorities. As for TM 1.8.0 the users and teams now have blanket permissions
			(aka authorities) for themselves, not only via core_group membership. However, a user will still belong to one of the CO...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::core-1.8.0-feat-2699-04::bsiri
--  we have now to set the role ROLE_TM_PROJECT_MANAGER to the corresponding users
insert into CORE_PARTY_AUTHORITY(PARTY_ID, AUTHORITY)
      select distinct cu.PARTY_ID, 'ROLE_TM_PROJECT_MANAGER' from CORE_USER cu
      where cu.PARTY_ID in (
      select cu1.PARTY_ID from CORE_USER cu1
      inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse1 on arse1.PARTY_ID = cu1.PARTY_ID
      where arse1.ACL_GROUP_ID = 5
      )
      or cu.PARTY_ID in (
      select cu2.PARTY_ID from CORE_USER cu2
      inner join CORE_TEAM_MEMBER ctm on ctm.USER_ID = cu2.PARTY_ID
      inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse2 on arse2.PARTY_ID = ctm.TEAM_ID
      where arse2.ACL_GROUP_ID = 5
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('core-1.8.0-feat-2699-04', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 256, '8:02d8d2b9728de4c3bbc5b692bff3ef6d', 'sql', 'we have now to set the role ROLE_TM_PROJECT_MANAGER to the corresponding users', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0.issue-2899-1::bsiri
--  Clean up the database from dead entities that slipped through the deletion routines (mysql, postgresql)
SET foreign_key_checks = 0;

delete RESOURCE.* , SIMPLE_RESOURCE.*
      from RESOURCE inner join SIMPLE_RESOURCE on RESOURCE.RES_ID = SIMPLE_RESOURCE.RES_ID
      where SIMPLE_RESOURCE.RES_ID NOT IN (
      select RES_ID from REQUIREMENT_FOLDER
      );

delete ATTACHMENT_LIST.*, ATTACHMENT.*, ATTACHMENT_CONTENT.*
      from ATTACHMENT_LIST
      left join ATTACHMENT on ATTACHMENT_LIST.ATTACHMENT_LIST_ID = ATTACHMENT.ATTACHMENT_LIST_ID
      left join ATTACHMENT_CONTENT on ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID = ATTACHMENT.CONTENT_ID
      where ATTACHMENT_LIST.ATTACHMENT_LIST_ID NOT IN(
      select ATTACHMENT_LIST_ID from ACTION_TEST_STEP UNION
      select ATTACHMENT_LIST_ID from CAMPAIGN_LIBRARY UNION
      select ATTACHMENT_LIST_ID from CAMPAIGN_LIBRARY_NODE UNION
      select ATTACHMENT_LIST_ID from EXECUTION UNION
      select ATTACHMENT_LIST_ID from EXECUTION_STEP UNION
      select ATTACHMENT_LIST_ID from ITERATION UNION
      select ATTACHMENT_LIST_ID from PROJECT UNION
      select ATTACHMENT_LIST_ID from REQUIREMENT_LIBRARY UNION
      select ATTACHMENT_LIST_ID from RESOURCE UNION
      select ATTACHMENT_LIST_ID from TEST_CASE_LIBRARY UNION
      select ATTACHMENT_LIST_ID from TEST_CASE_LIBRARY_NODE UNION
      select ATTACHMENT_LIST_ID from TEST_SUITE
      );

SET foreign_key_checks = 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.0.issue-2899-1', 'bsiri', 'tm/tm.changelog-1.8.0.xml', NOW(), 257, '8:a545daa4cad19216cee6121b1e4f5db8', 'sql', 'Clean up the database from dead entities that slipped through the deletion routines (mysql, postgresql)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0.issue-2899-2::bsiri
--  Clean up the database from dead entities that slipped through the deletion routines (h2). Note :
--  			There is no way to perform multi table delete so we must delete the tables one by one.
--  
--  			Since h2 doesn't support multi table delete we must delete the entries one table after the other
--  			and this will cost quite a bit.
--  Changeset tm/tm.changelog-1.8.0.xml::tm-1.8.0.issue-2899-2-postgresql::mpagnon
--  Clean up the database from dead entities that slipped through the deletion routines (postgresql).
--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2::flaurens
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.8.2' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2', 'flaurens', 'tm/tm.changelog-1.8.2.xml', NOW(), 258, '8:59a000b04124198fe97e3146a18c7a39', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2.feature-3120-01::flaurens
--  Adding denormalized field option table for editable denormalized list valued cufs
CREATE TABLE DENORMALIZED_FIELD_OPTION (DFV_ID BIGINT NOT NULL, LABEL VARCHAR(255) NOT NULL, POSITION INT NOT NULL, CODE VARCHAR(30) NOT NULL, CONSTRAINT fk_df_option_dfv FOREIGN KEY (DFV_ID) REFERENCES DENORMALIZED_FIELD_VALUE(DFV_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2.feature-3120-01', 'flaurens', 'tm/tm.changelog-1.8.2.xml', NOW(), 259, '8:954fdde75f17f05fb0b2b93c03fda108', 'createTable tableName=DENORMALIZED_FIELD_OPTION', 'Adding denormalized field option table for editable denormalized list valued cufs', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2.feature-3120-02::flaurens
--  Old list valued cufs are editable as simple text cufs
UPDATE DENORMALIZED_FIELD_VALUE SET INPUT_TYPE = 'PLAIN_TEXT' WHERE INPUT_TYPE = 'DROPDOWN_LIST';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2.feature-3120-02', 'flaurens', 'tm/tm.changelog-1.8.2.xml', NOW(), 260, '8:02169d341d58170c037f44ad29505421', 'update tableName=DENORMALIZED_FIELD_VALUE', 'Old list valued cufs are editable as simple text cufs', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2.feature-3120-03::flaurens
--  Adding a field type column to denormalized field value table
ALTER TABLE DENORMALIZED_FIELD_VALUE ADD FIELD_TYPE CHAR(3) DEFAULT 'CF' NOT NULL COMMENT 'CF : simple, SSF : multiple-choice';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2.feature-3120-03', 'flaurens', 'tm/tm.changelog-1.8.2.xml', NOW(), 261, '8:2b9cc750f49093e0a2ff6b166276b400', 'addColumn tableName=DENORMALIZED_FIELD_VALUE', 'Adding a field type column to denormalized field value table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2-feat-3127-01::bsiri
--  As of now X_LIBRARY_PLUGINS are merged in the single table LIBRARY_PLUGIN_BINDING
CREATE TABLE LIBRARY_PLUGIN_BINDING (PLUGIN_BINDING_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key (autogenerated)', LIBRARY_ID BIGINT NULL COMMENT 'ID of the library. It is explicitely nullable because hibernate will first create the row then update this column.', LIBRARY_TYPE CHAR(1) NOT NULL COMMENT 'discriminator of the library. T: test case library, R : requirement library, C : campaign library', PLUGIN_ID VARCHAR(50) NOT NULL COMMENT 'id of the plugin. Note that those plugins aren''t stored in the database and the plugin registry is purely software                (it is basically based on the presence/absence of an OSGI services published by each plugin) so we cannot really enforce referential               integrity. Still, although technically that column cannot be a foreign key, the application uses it as if.', CONSTRAINT PK_LIBRARY_PLUGIN_BINDING PRIMARY KEY (PLUGIN_BINDING_ID)) ENGINE = INNODB;

ALTER TABLE LIBRARY_PLUGIN_BINDING ADD CONSTRAINT uniq_plugin_binding UNIQUE (LIBRARY_ID, LIBRARY_TYPE, PLUGIN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2-feat-3127-01', 'bsiri', 'tm/tm.changelog-1.8.2.xml', NOW(), 262, '8:8baba4afe1f2d7ec386e93a862f5c76a', 'createTable tableName=LIBRARY_PLUGIN_BINDING; addUniqueConstraint constraintName=uniq_plugin_binding, tableName=LIBRARY_PLUGIN_BINDING', 'As of now X_LIBRARY_PLUGINS are merged in the single table LIBRARY_PLUGIN_BINDING', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2-feat-3127-02::bsiri
--  create the table LIBRARY_PLUGIN_PROPERTY
CREATE TABLE LIBRARY_PLUGIN_BINDING_PROPERTY (PLUGIN_BINDING_ID BIGINT NOT NULL COMMENT 'foreign key to LIBRARY_PLUGIN_BINDING', PLUGIN_BINDING_KEY VARCHAR(30) NOT NULL COMMENT 'key of this property', PLUGIN_BINDING_VALUE VARCHAR(255) NOT NULL COMMENT 'value of this property', CONSTRAINT fk_libplugin_property_libplugin FOREIGN KEY (PLUGIN_BINDING_ID) REFERENCES LIBRARY_PLUGIN_BINDING(PLUGIN_BINDING_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2-feat-3127-02', 'bsiri', 'tm/tm.changelog-1.8.2.xml', NOW(), 263, '8:d94b6b9ae66e4f1c3059141d80c3f56d', 'createTable tableName=LIBRARY_PLUGIN_BINDING_PROPERTY', 'create the table LIBRARY_PLUGIN_PROPERTY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.8.2.xml::tm-1.8.2-feat-3127-03::bsiri
--  drop the old tables
DROP TABLE TEST_CASE_LIBRARY_PLUGINS;

DROP TABLE REQUIREMENT_LIBRARY_PLUGINS;

DROP TABLE CAMPAIGN_LIBRARY_PLUGINS;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.8.2-feat-3127-03', 'bsiri', 'tm/tm.changelog-1.8.2.xml', NOW(), 264, '8:16874602945dba14e36c5a38ea0f6d57', 'dropTable tableName=TEST_CASE_LIBRARY_PLUGINS; dropTable tableName=REQUIREMENT_LIBRARY_PLUGINS; dropTable tableName=CAMPAIGN_LIBRARY_PLUGINS', 'drop the old tables', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0::flaurens
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.9.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 265, '8:322d58b4cb09062ece234d4788512f7c', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-1::flaurens
--  Adding columns to order descendants in node relationship tables
ALTER TABLE CLN_RELATIONSHIP ADD CONTENT_ORDER INT NULL;

ALTER TABLE RLN_RELATIONSHIP ADD CONTENT_ORDER INT NULL;

ALTER TABLE TCLN_RELATIONSHIP ADD CONTENT_ORDER INT NULL;

ALTER TABLE REQUIREMENT_LIBRARY_CONTENT ADD CONTENT_ORDER INT NULL;

ALTER TABLE TEST_CASE_LIBRARY_CONTENT ADD CONTENT_ORDER INT NULL;

ALTER TABLE CAMPAIGN_LIBRARY_CONTENT ADD CONTENT_ORDER INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-1', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 266, '8:367fbd54470e1f23e19a32a235663f8c', 'addColumn tableName=CLN_RELATIONSHIP; addColumn tableName=RLN_RELATIONSHIP; addColumn tableName=TCLN_RELATIONSHIP; addColumn tableName=REQUIREMENT_LIBRARY_CONTENT; addColumn tableName=TEST_CASE_LIBRARY_CONTENT; addColumn tableName=CAMPAIGN_LIBRARY...', 'Adding columns to order descendants in node relationship tables', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-2::jsimon
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-2::flaurens
--  Creating default order which is identical with the alphabetical order
create table TEMP_CLN_CONTENT_ORDER(
        CONTENT_ORDER BIGINT NOT NULL,
        ANCESTOR_ID BIGINT NOT NULL,
        DESCENDANT_ID BIGINT NOT NULL,
        DUMMY BIGINT NOT NULL
      );

insert into TEMP_CLN_CONTENT_ORDER (CONTENT_ORDER, ANCESTOR_ID, DESCENDANT_ID, DUMMY)
      select
        if(@prevtcs=ANCESTOR_ID, @rownum:=@rownum+1, @rownum:=0) as RANK,
        clnr.ANCESTOR_ID,
        clnr.DESCENDANT_ID,
        (@prevtcs:=ANCESTOR_ID)
      from (
      	select cr.ancestor_id, cr.descendant_id
      	from CLN_RELATIONSHIP cr
        join CAMPAIGN_LIBRARY_NODE cln on cr.DESCENDANT_ID = cln.CLN_ID
        order by cr.ANCESTOR_ID, cln.NAME
       ) as clnr,
        (SELECT @rownum:=0) r,
        (SELECT @prevtcs:=0) s;

insert into TEMP_CLN_CONTENT_ORDER (CONTENT_ORDER, ANCESTOR_ID, DESCENDANT_ID, DUMMY)
      select
        if(@prevtcs=LIBRARY_ID, @rownum:=@rownum+1, @rownum:=0) as RANK,
        clnrr.LIBRARY_ID, clnrr.CONTENT_ID, (@prevtcs:=LIBRARY_ID)
      from (
      	select clc.LIBRARY_ID, clc.CONTENT_ID
      	from CAMPAIGN_LIBRARY_CONTENT clc
        join CAMPAIGN_LIBRARY_NODE cln on clc.CONTENT_ID = cln.CLN_ID
        order by clc.LIBRARY_ID, cln.NAME
        ) as clnrr,
        (SELECT @rownum:=0) r,
        (SELECT @prevtcs:=0) s;

update CLN_RELATIONSHIP
      set CONTENT_ORDER = (
        select TEMP_CLN_CONTENT_ORDER.CONTENT_ORDER
        from TEMP_CLN_CONTENT_ORDER
        where TEMP_CLN_CONTENT_ORDER.ANCESTOR_ID = CLN_RELATIONSHIP.ANCESTOR_ID
          and TEMP_CLN_CONTENT_ORDER.DESCENDANT_ID = CLN_RELATIONSHIP.DESCENDANT_ID
      );

update CAMPAIGN_LIBRARY_CONTENT
      set CONTENT_ORDER = (
        select TEMP_CLN_CONTENT_ORDER.CONTENT_ORDER
        from TEMP_CLN_CONTENT_ORDER
        where TEMP_CLN_CONTENT_ORDER.ANCESTOR_ID = CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID
          and TEMP_CLN_CONTENT_ORDER.DESCENDANT_ID = CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID
      );

drop table TEMP_CLN_CONTENT_ORDER;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-2', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 267, '8:d08125b31e4e2b61a3d4299136c95cfb', 'sql', 'Creating default order which is identical with the alphabetical order', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-3::flaurens
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-4::jsimon
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-4::flaurens
--  Creating default order which is identical with the alphabetical order
create table TEMP_RLN_CONTENT_ORDER(CONTENT_ORDER BIGINT NOT NULL, ANCESTOR_ID BIGINT NOT NULL, DESCENDANT_ID BIGINT NOT
	      NULL, DUMMY BIGINT NOT NULL);

create table TMP_MAP_RLN_RESOURCE(RLN_ID BIGINT NOT NULL,
		NAME VARCHAR(255));

insert into TMP_MAP_RLN_RESOURCE(rln_id, name)
	select f.rln_id, res.name
	from REQUIREMENT_FOLDER f
	inner join RESOURCE res on f.res_id = res.res_id;

insert into TMP_MAP_RLN_RESOURCE(rln_id,  name)
	select r.rln_id,  res.name
	from REQUIREMENT r
	inner join RESOURCE res on  r.current_version_id = res.res_id;

insert into TEMP_RLN_CONTENT_ORDER (CONTENT_ORDER, ANCESTOR_ID, DESCENDANT_ID, DUMMY)
	      select if(@prevtcs=ANCESTOR_ID,
	      @rownum:=@rownum+1,
	      @rownum:=0) as RANK,
	      rlnr.ANCESTOR_ID, rlnr.DESCENDANT_ID, (@prevtcs:=ANCESTOR_ID)
	      from (
	      	select rln.ancestor_id, rln.descendant_id
	      	from RLN_RELATIONSHIP rln
	      	inner join TMP_MAP_RLN_RESOURCE tmp on rln.descendant_id = tmp.rln_id
	      	order by rln.ancestor_id, tmp.name
	      ) as rlnr,
	      (SELECT @rownum:=0) r, (SELECT @prevtcs:=0) s;

insert into TEMP_RLN_CONTENT_ORDER (CONTENT_ORDER, ANCESTOR_ID, DESCENDANT_ID, DUMMY)
	      select if(@prevtcs=LIBRARY_ID,
	      @rownum:=@rownum+1,
	      @rownum:=0) as RANK,
	      rlnr.LIBRARY_ID, rlnr.CONTENT_ID, (@prevtcs:=rlnr.LIBRARY_ID)
	      from (
	      	select rlc.library_id, rlc.content_id
	      	from REQUIREMENT_LIBRARY_CONTENT rlc
	      	inner join TMP_MAP_RLN_RESOURCE tmp on rlc.content_id = tmp.rln_id
	      	order by rlc.library_id, tmp.name
	      ) as rlnr,
		(SELECT @rownum:=0) r, (SELECT @prevtcs:=0) s;

update RLN_RELATIONSHIP
	      set CONTENT_ORDER = (select TEMP_RLN_CONTENT_ORDER.CONTENT_ORDER
	      from TEMP_RLN_CONTENT_ORDER
	      where TEMP_RLN_CONTENT_ORDER.ANCESTOR_ID = RLN_RELATIONSHIP.ANCESTOR_ID
	      and TEMP_RLN_CONTENT_ORDER.DESCENDANT_ID = RLN_RELATIONSHIP.DESCENDANT_ID);

update REQUIREMENT_LIBRARY_CONTENT
	      set CONTENT_ORDER = (select TEMP_RLN_CONTENT_ORDER.CONTENT_ORDER
	      from TEMP_RLN_CONTENT_ORDER
	      where TEMP_RLN_CONTENT_ORDER.ANCESTOR_ID = REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID
	      and TEMP_RLN_CONTENT_ORDER.DESCENDANT_ID = REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID);

drop table TEMP_RLN_CONTENT_ORDER;

drop table TMP_MAP_RLN_RESOURCE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-4', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 268, '8:53a891c33e5e7ed3f88c420186dff341', 'sql', 'Creating default order which is identical with the alphabetical order', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-5::flaurens
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-6::jsimon
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-6::flaurens
--  Creating default order which is identical with the alphabetical order
create table TEMP_TCLN_CONTENT_ORDER(CONTENT_ORDER BIGINT NOT NULL, ANCESTOR_ID BIGINT NOT NULL, DESCENDANT_ID BIGINT NOT
      NULL, DUMMY BIGINT NOT NULL);

insert into TEMP_TCLN_CONTENT_ORDER (CONTENT_ORDER, ANCESTOR_ID, DESCENDANT_ID, DUMMY)
      select if(@prevtcs=ANCESTOR_ID,
      @rownum:=@rownum+1,
      @rownum:=0) as RANK,
      tclnr.ANCESTOR_ID, tclnr.DESCENDANT_ID, (@prevtcs:=ANCESTOR_ID)
      from (
      select tr.ancestor_id, tr.descendant_id
      from TCLN_RELATIONSHIP tr
      join TEST_CASE_LIBRARY_NODE tcln on tr.DESCENDANT_ID = tcln.TCLN_ID
      order by tr.ancestor_id, tcln.name
      ) as tclnr,
      (SELECT @rownum:=0) r, (SELECT @prevtcs:=0) s;

insert into TEMP_TCLN_CONTENT_ORDER (CONTENT_ORDER, ANCESTOR_ID, DESCENDANT_ID, DUMMY)
      select if(@prevtcs=LIBRARY_ID,
      @rownum:=@rownum+1,
      @rownum:=0) as RANK,
      tclnr.LIBRARY_ID, tclnr.CONTENT_ID, (@prevtcs:=LIBRARY_ID)
      from (
      	select tc.library_id, tc.content_id
      	from TEST_CASE_LIBRARY_CONTENT tc
      	join TEST_CASE_LIBRARY_NODE tcln on tc.CONTENT_ID = tcln.TCLN_ID
      	order by tc.library_id, tcln.name
      ) as tclnr,
      (SELECT @rownum:=0) r, (SELECT @prevtcs:=0) s;

update TCLN_RELATIONSHIP
      set CONTENT_ORDER = (select TEMP_TCLN_CONTENT_ORDER.CONTENT_ORDER
      from TEMP_TCLN_CONTENT_ORDER
      where TEMP_TCLN_CONTENT_ORDER.ANCESTOR_ID = TCLN_RELATIONSHIP.ANCESTOR_ID
      and TEMP_TCLN_CONTENT_ORDER.DESCENDANT_ID = TCLN_RELATIONSHIP.DESCENDANT_ID);

update TEST_CASE_LIBRARY_CONTENT
      set CONTENT_ORDER = (select TEMP_TCLN_CONTENT_ORDER.CONTENT_ORDER
      from TEMP_TCLN_CONTENT_ORDER
      where TEMP_TCLN_CONTENT_ORDER.ANCESTOR_ID = TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID
      and TEMP_TCLN_CONTENT_ORDER.DESCENDANT_ID = TEST_CASE_LIBRARY_CONTENT.CONTENT_ID);

drop table TEMP_TCLN_CONTENT_ORDER;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-6', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 269, '8:d60812dc550399c79cc003382144cfcf', 'sql', 'Creating default order which is identical with the alphabetical order', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-7::flaurens
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3138-8::flaurens
ALTER TABLE REQUIREMENT_VERSION_COVERAGE MODIFY VERIFIED_REQ_VERSION_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-8', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 270, '8:508181d596694554bf432e21fbcbec5d', 'dropNotNullConstraint columnName=VERIFIED_REQ_VERSION_ID, tableName=REQUIREMENT_VERSION_COVERAGE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3211-1::flaurens
CREATE TABLE DISABLED_EXECUTION_STATUS (CL_ID BIGINT NOT NULL, EXECUTION_STATUS VARCHAR(255) NOT NULL, CONSTRAINT FK_DISABLED_EXEC_STATUS_CL_ID FOREIGN KEY (CL_ID) REFERENCES CAMPAIGN_LIBRARY(CL_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3211-1', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 271, '8:a3dce417956fd22e92fea138eb4bb622', 'createTable tableName=DISABLED_EXECUTION_STATUS', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0.feature-3211-2::flaurens
--  Inserting default disabled execution statuses for existing libraries
insert into DISABLED_EXECUTION_STATUS (CL_ID, EXECUTION_STATUS)
	select cl_id, 'ERROR' from CAMPAIGN_LIBRARY;

insert into DISABLED_EXECUTION_STATUS (CL_ID, EXECUTION_STATUS)
	select cl_id, 'WARNING' from CAMPAIGN_LIBRARY;

insert into DISABLED_EXECUTION_STATUS (CL_ID, EXECUTION_STATUS)
	select cl_id, 'NOT_RUN' from CAMPAIGN_LIBRARY;

insert into DISABLED_EXECUTION_STATUS (CL_ID, EXECUTION_STATUS)
	select cl_id, 'SETTLED' from CAMPAIGN_LIBRARY;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3211-2', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 272, '8:90362fe008c552c0fca71fe4e8cce9ea', 'sql', 'Inserting default disabled execution statuses for existing libraries', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0-issue-3236-01::flaurens
update DENORMALIZED_FIELD_VALUE
		set FIELD_TYPE = 'CF'
		where FIELD_TYPE = '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0-issue-3236-01', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 273, '8:5107cca5ee7718d74f9e2b7a3d7b345d', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0-issue--01::flaurens
ALTER TABLE ACTION_TEST_STEP MODIFY ACTION LONGTEXT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0-issue--01', 'flaurens', 'tm/tm.changelog-1.9.0.xml', NOW(), 274, '8:805ca0dfc2a467ecdc3c9b7c6ffa6a77', 'dropNotNullConstraint columnName=ACTION, tableName=ACTION_TEST_STEP', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.9.0.xml::tm-1.9.0-issue-3140-01::mpagnon
create table TEMP_VS(
          RVC_ID BIGINT NOT NULL,
          TS_ID BIGINT NOT NULL
        );

insert into TEMP_VS(RVC_ID, TS_ID)
        select vs.REQUIREMENT_VERSION_COVERAGE_ID, vs.TEST_STEP_ID
        from VERIFYING_STEPS as vs
        group by vs.REQUIREMENT_VERSION_COVERAGE_ID, vs.TEST_STEP_ID;

delete from VERIFYING_STEPS;

insert into  VERIFYING_STEPS (REQUIREMENT_VERSION_COVERAGE_ID, TEST_STEP_ID)
        select RVC_ID , TS_ID
        from TEMP_VS;

drop table TEMP_VS;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0-issue-3140-01', 'mpagnon', 'tm/tm.changelog-1.9.0.xml', NOW(), 275, '8:03ec8252a7f4865c8475438733a5f1b3', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.10.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 276, '8:c9fb10720986837eae47c3661483c684', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-1::bsiri
--  before the cleanup, we need to relax some constraints
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER MODIFY TEST_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-1', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 277, '8:61f9a82add8930097376054289b700f4', 'dropNotNullConstraint columnName=TEST_ID, tableName=AUTOMATED_EXECUTION_EXTENDER', 'before the cleanup, we need to relax some constraints', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-2::bsiri
--  cleaning up unused entities
create temporary table UNUSED_TA_PROJECT as
  			(
  				select taproj.project_id as project_id
  				from TEST_AUTOMATION_PROJECT taproj
  				where taproj.project_id not in (
  					select ta_project_id from TM_TA_PROJECTS
  				)
  			);

update AUTOMATED_EXECUTION_EXTENDER extender
  			set result_url = null,
  				test_id = null
  			where extender.test_id in (
  				select tatest.test_id
  				from  AUTOMATED_TEST tatest
  				inner join UNUSED_TA_PROJECT unused on tatest.project_id = unused.project_id
  			);

update TEST_CASE tc
  			set ta_test = null
  			where tc.ta_test in (
  				select tatest.test_id
  				from AUTOMATED_TEST tatest
  				inner join UNUSED_TA_PROJECT unused on tatest.project_id = unused.project_id
  			);

delete from AUTOMATED_TEST
			where project_id in (
				select unused.project_id from UNUSED_TA_PROJECT unused
			);

delete from TEST_AUTOMATION_PROJECT
  			where project_id in (
  				select p.project_id from UNUSED_TA_PROJECT p
  			);

delete from TEST_AUTOMATION_SERVER
  			where server_id not in (
  				select distinct taproj.server_id
  				from TM_TA_PROJECTS binding
  				inner join TEST_AUTOMATION_PROJECT taproj on binding.ta_project_id = taproj.project_id
  			);

drop table UNUSED_TA_PROJECT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-2', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 278, '8:ac8a755f09a91815588ee6fdc79b989c', 'sql; sql; sql; sql; sql; sql; sql', 'cleaning up unused entities', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-3::bsiri
--  The test automation servers are now 'auditable' (dates and authors of creation/modification are recorded) and has
--  		several other attributes
ALTER TABLE TEST_AUTOMATION_SERVER ADD NAME VARCHAR(50) NULL COMMENT 'The name of the server' , ADD `DESCRIPTION` LONGTEXT NULL COMMENT 'A description for the server. Since its of type ''CLOB'' it might not be so short after all.' , ADD CREATED_BY VARCHAR(50) DEFAULT '(nobody)' NULL COMMENT 'Who created this test automation server' , ADD CREATED_ON datetime NULL COMMENT 'When was created that server' , ADD LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'Author of last edition' , ADD LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Last date of edition' , ADD MANUAL_SLAVE_SELECTION BIT(1) DEFAULT 0 NOT NULL COMMENT 'Should the user select which slave will run the tests (if there are some) ?';

update TEST_AUTOMATION_SERVER
			set name = concat_ws('-', base_url, server_id);

update TEST_AUTOMATION_SERVER
			set CREATED_ON = NOW();

ALTER TABLE TEST_AUTOMATION_SERVER MODIFY NAME VARCHAR(50) NOT NULL;

ALTER TABLE TEST_AUTOMATION_SERVER ADD UNIQUE (NAME);

ALTER TABLE TEST_AUTOMATION_SERVER MODIFY CREATED_ON datetime NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-3', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 279, '8:d70380277307269a80a90d9f420bf0a7', 'addColumn tableName=TEST_AUTOMATION_SERVER; sql; sql; addNotNullConstraint columnName=NAME, tableName=TEST_AUTOMATION_SERVER; addUniqueConstraint tableName=TEST_AUTOMATION_SERVER; addNotNullConstraint columnName=CREATED_ON, tableName=TEST_AUTOMATI...', 'The test automation servers are now ''auditable'' (dates and authors of creation/modification are recorded) and has
		several other attributes', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-4::bsiri
--  The associative table TM_TA_PROJECTS is totally re-purposed as TEST_AUTOMATION_PROJECT
--  			(and the former table is ditched).
CREATE TABLE PROTO_TEST_AUTOMATION_PROJECT (TA_PROJECT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'the primary key', TM_PROJECT_ID BIGINT NOT NULL COMMENT 'the reference to the TM project', LABEL VARCHAR(50) NOT NULL COMMENT 'the (friendly) alias for that TA project ', REMOTE_NAME VARCHAR(50) NOT NULL COMMENT 'the (real) name of the remote test automation project', SERVER_ID BIGINT NOT NULL COMMENT 'foreign key to the automated test server', EXECUTION_ENVIRONMENTS VARCHAR(255) DEFAULT '' NOT NULL COMMENT 'the list of approved slaves servers', FORMER_ID BIGINT NOT NULL COMMENT 'the former primary key', CONSTRAINT PK_PROTO_TEST_AUTOMATION_PROJECT PRIMARY KEY (TA_PROJECT_ID), CONSTRAINT fk_ta_project_tm_project FOREIGN KEY (TM_PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_ta_project_ta_server FOREIGN KEY (SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER(SERVER_ID)) ENGINE = INNODB;

insert into PROTO_TEST_AUTOMATION_PROJECT(TM_PROJECT_ID, LABEL, REMOTE_NAME, SERVER_ID, FORMER_ID)
			select binding.tm_project_id,
				   concat_ws('-', proj.name, binding.tm_project_id, binding.ta_project_id),
				   proj.name,
				   proj.server_id,
				   proj.project_id
			from TM_TA_PROJECTS binding
			inner join TEST_AUTOMATION_PROJECT proj on binding.ta_project_id = proj.project_id;

DROP TABLE TM_TA_PROJECTS;

ALTER TABLE AUTOMATED_TEST DROP FOREIGN KEY fk_automated_test_project;

DROP TABLE TEST_AUTOMATION_PROJECT;

ALTER TABLE PROTO_TEST_AUTOMATION_PROJECT RENAME TEST_AUTOMATION_PROJECT;

update AUTOMATED_TEST
			set PROJECT_ID = (
				select tap.TA_PROJECT_ID
				from TEST_AUTOMATION_PROJECT tap
                  inner join TEST_CASE_LIBRARY_NODE tcln on tcln.PROJECT_ID = tap.TM_PROJECT_ID
                  inner join TEST_CASE tc on tc.TCLN_ID = tcln.TCLN_ID
				where PROJECT_ID = tap.FORMER_ID
				  and TEST_ID = tc.TA_TEST
				group by tc.TA_TEST, tap.TA_PROJECT_ID
			);

ALTER TABLE TEST_AUTOMATION_PROJECT DROP COLUMN FORMER_ID;

ALTER TABLE AUTOMATED_TEST ADD CONSTRAINT fk_automated_test_project FOREIGN KEY (PROJECT_ID) REFERENCES TEST_AUTOMATION_PROJECT (TA_PROJECT_ID);

ALTER TABLE TEST_AUTOMATION_PROJECT ADD CONSTRAINT uniq_tm_ta_project_job UNIQUE (TM_PROJECT_ID, REMOTE_NAME, SERVER_ID);

ALTER TABLE TEST_AUTOMATION_PROJECT ADD CONSTRAINT uniq_tm_ta_project_label UNIQUE (TM_PROJECT_ID, LABEL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-4', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 280, '8:a3af1d22d24b1669302c99277c43fcaa', 'createTable tableName=PROTO_TEST_AUTOMATION_PROJECT; sql; dropTable tableName=TM_TA_PROJECTS; dropForeignKeyConstraint baseTableName=AUTOMATED_TEST, constraintName=fk_automated_test_project; dropTable tableName=TEST_AUTOMATION_PROJECT; renameTable...', 'The associative table TM_TA_PROJECTS is totally re-purposed as TEST_AUTOMATION_PROJECT
			(and the former table is ditched).', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-5::bsiri
--  A TM project is now hard-bound to a TA server
ALTER TABLE PROJECT ADD TA_SERVER_ID BIGINT NULL COMMENT 'the reference to the test automation server';

ALTER TABLE PROJECT ADD CONSTRAINT tm_project_ta_server FOREIGN KEY (TA_SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE PROJECT DROP COLUMN TEST_AUTOMATION_ENABLED;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-5', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 281, '8:fd037f2b007d78a30201b94b45d6474b', 'addColumn tableName=PROJECT; dropColumn columnName=TEST_AUTOMATION_ENABLED, tableName=PROJECT', 'A TM project is now hard-bound to a TA server', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-6::bsiri
--  migrating existing data to the new schema
update PROJECT
			set ta_server_id = (
				select max(server.server_id)
				from TEST_AUTOMATION_SERVER server
				inner join TEST_AUTOMATION_PROJECT taproj on server.server_id = taproj.server_id
				where taproj.tm_project_id = project_id
			);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-6', 'bsiri', 'tm/tm.changelog-1.10.0.xml', NOW(), 282, '8:7de916fc08d5d87e6c2fe34026c35886', 'sql', 'migrating existing data to the new schema', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-6::gfouquet
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD NODE_NAME VARCHAR(50) DEFAULT '' NULL COMMENT 'Name of the node which ran the test';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-6', 'gfouquet', 'tm/tm.changelog-1.10.0.xml', NOW(), 283, '8:39460d77595f309783bb7344142d2174', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-7::flaurens
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD EXECUTION_EXTENDER_ORDER BIGINT NULL COMMENT 'order of automated executions extenders within an automated suite';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-7', 'flaurens', 'tm/tm.changelog-1.10.0.xml', NOW(), 284, '8:827045ccc204c7f602bddfc6869147f2', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-8::flaurens
--  Creating default order which is identical with the alphabetical order
create table TEMP_EXECUTION_EXTENDER_ORDER(
	        EXECUTION_EXTENDER_ORDER BIGINT NOT NULL,
	        SUITE_ID BIGINT NOT NULL,
	        EXTENDER_ID BIGINT NOT NULL,
	        DUMMY BIGINT NOT NULL
	      );

insert into TEMP_EXECUTION_EXTENDER_ORDER (EXECUTION_EXTENDER_ORDER, SUITE_ID, EXTENDER_ID, DUMMY)
	      select
	        if(@prevtcs=SUITE_ID, @rownum:=@rownum+1, @rownum:=0) as RANK,
	        clnr.SUITE_ID,
	        clnr.EXTENDER_ID,
	        (@prevtcs:=SUITE_ID)
	      from (
	      	select cr.SUITE_ID, cr.EXTENDER_ID
	      	from AUTOMATED_EXECUTION_EXTENDER cr
	        order by cr.SUITE_ID, cr.EXTENDER_ID
	       ) as clnr,
	        (SELECT @rownum:=0) r,
	        (SELECT @prevtcs:=0) s;

update AUTOMATED_EXECUTION_EXTENDER
	      set EXECUTION_EXTENDER_ORDER = (
	        select TEMP_EXECUTION_EXTENDER_ORDER.EXECUTION_EXTENDER_ORDER
	        from TEMP_EXECUTION_EXTENDER_ORDER
	        where TEMP_EXECUTION_EXTENDER_ORDER.SUITE_ID = AUTOMATED_EXECUTION_EXTENDER.SUITE_ID
	          and TEMP_EXECUTION_EXTENDER_ORDER.EXTENDER_ID = AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID
	      );

drop table TEMP_EXECUTION_EXTENDER_ORDER;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0.feature-3481-8', 'flaurens', 'tm/tm.changelog-1.10.0.xml', NOW(), 285, '8:70da0f476b1b6dec60cd259db677686e', 'sql', 'Creating default order which is identical with the alphabetical order', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-9::flaurens
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.10.0.xml::tm-1.10.0.feature-3481-postgresql::mpagnon
--  Creating default order which is identical with the alphabetical order
--  Changeset tm/tm.changelog-1.10.3.xml::tm-1.10.0::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.10.3' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.0', 'bsiri', 'tm/tm.changelog-1.10.3.xml', NOW(), 286, '8:cbfd539884ec003142f31bf813f3a6bb', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.3.xml::tm-1.10.3-issue-3807-3808-1::bsiri
--  Adding much needed indexes
CREATE INDEX idx_cfv_entity_id ON CUSTOM_FIELD_VALUE(BOUND_ENTITY_ID);

CREATE INDEX idx_cfv_entity_type ON CUSTOM_FIELD_VALUE(BOUND_ENTITY_TYPE);

CREATE INDEX idx_dfv_entity_id ON DENORMALIZED_FIELD_VALUE(DENORMALIZED_FIELD_HOLDER_ID);

CREATE INDEX idx_dfv_entity_type ON DENORMALIZED_FIELD_VALUE(DENORMALIZED_FIELD_HOLDER_TYPE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.3-issue-3807-3808-1', 'bsiri', 'tm/tm.changelog-1.10.3.xml', NOW(), 287, '8:df7e7fa2dd744c966480e94215f8aa60', 'createIndex indexName=idx_cfv_entity_id, tableName=CUSTOM_FIELD_VALUE; createIndex indexName=idx_cfv_entity_type, tableName=CUSTOM_FIELD_VALUE; createIndex indexName=idx_dfv_entity_id, tableName=DENORMALIZED_FIELD_VALUE; createIndex indexName=idx_...', 'Adding much needed indexes', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.5.xml::tm-1.10.5::mpagnon
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.10.5' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.5', 'mpagnon', 'tm/tm.changelog-1.10.5.xml', NOW(), 288, '8:94e53469ea62b14c641753493dd73aca', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.5.xml::tm-1.10.5-issue-3860-1::mpagnon
--  Removing duplicate values
CREATE TABLE CUF_VALUES_TO_SAVE (id BIGINT NULL) ENGINE = INNODB;

CREATE UNIQUE INDEX idx_cuf_values_to_save ON CUF_VALUES_TO_SAVE(id);

insert into CUF_VALUES_TO_SAVE (id)
      select min(CFV_ID)
      from CUSTOM_FIELD_VALUE cfv
      where cfv.BOUND_ENTITY_TYPE = 'TEST_STEP'
      group by cfv.BOUND_ENTITY_ID, cfv.CFB_ID;

delete from CUSTOM_FIELD_VALUE
      where BOUND_ENTITY_TYPE = 'TEST_STEP' and
      not exists (select 1 from CUF_VALUES_TO_SAVE cfvts where cfvts.id = cfv_id);

DROP INDEX idx_cuf_values_to_save ON CUF_VALUES_TO_SAVE;

DROP TABLE CUF_VALUES_TO_SAVE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.5-issue-3860-1', 'mpagnon', 'tm/tm.changelog-1.10.5.xml', NOW(), 289, '8:e916e83acb708a8b24351be70ff2728e', 'createTable tableName=CUF_VALUES_TO_SAVE; createIndex indexName=idx_cuf_values_to_save, tableName=CUF_VALUES_TO_SAVE; sql; sql; dropIndex indexName=idx_cuf_values_to_save, tableName=CUF_VALUES_TO_SAVE; dropTable tableName=CUF_VALUES_TO_SAVE', 'Removing duplicate values', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.10.5.xml::tm-1.10.5-issue-3860-3::mpagnon
--  add missing custom field values
CREATE TABLE STEPS_SHOULD_HAVE_CUF_VALUES (cuf_binding_id BIGINT NULL, step_id BIGINT NULL, default_value VARCHAR(255) NULL, optional BIT(1) NULL) ENGINE = INNODB;

insert into STEPS_SHOULD_HAVE_CUF_VALUES (cuf_binding_id , step_id , default_value , optional )
      select
      cfb.CFB_ID, ats.TEST_STEP_ID, cf.default_value, cf.optional
      from ACTION_TEST_STEP ats, TEST_CASE_STEPS tcs,
      TEST_CASE_LIBRARY_NODE tcln, CUSTOM_FIELD_BINDING cfb, CUSTOM_FIELD cf
      where ats.TEST_STEP_ID = tcs.STEP_ID
      and
      tcln.TCLN_ID = tcs.TEST_CASE_ID
      and tcln.PROJECT_ID = cfb.BOUND_PROJECT_ID
      and cfb.CF_ID = cf.CF_ID
      and cfb.BOUND_ENTITY = 'TEST_STEP'
      and not exists (
      select 1
      from CUSTOM_FIELD_VALUE cfv
      where cfv.CFB_ID = cfb.CFB_ID
      and cfv.BOUND_ENTITY_TYPE = 'TEST_STEP'
      and
      cfv.BOUND_ENTITY_ID = ats.TEST_STEP_ID
      );

insert into CUSTOM_FIELD_VALUE ( BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, CFB_ID, VALUE)
      select sshcv.step_id ,
      'TEST_STEP', sshcv.cuf_binding_id, ''
      from STEPS_SHOULD_HAVE_CUF_VALUES sshcv
      where sshcv.optional = true;

insert into CUSTOM_FIELD_VALUE ( BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, CFB_ID, VALUE)
      select sshcv.step_id ,
      'TEST_STEP', sshcv.cuf_binding_id, sshcv.default_value
      from STEPS_SHOULD_HAVE_CUF_VALUES sshcv
      where sshcv.optional
      = false;

DROP TABLE STEPS_SHOULD_HAVE_CUF_VALUES;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.10.5-issue-3860-3', 'mpagnon', 'tm/tm.changelog-1.10.5.xml', NOW(), 290, '8:b1b7e409663ab6da95cb4f9aa21fdba2', 'createTable tableName=STEPS_SHOULD_HAVE_CUF_VALUES; sql; sql; sql; dropTable tableName=STEPS_SHOULD_HAVE_CUF_VALUES', 'add missing custom field values', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0::flaurens
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.11.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0', 'flaurens', 'tm/tm.changelog-1.11.0.xml', NOW(), 291, '8:03a0d2fab9cdab890310d899b02e884f', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3576-1::bsiri
--  Prepares the table CUSTOM_FIELD for possible default_values of type TEXT.
--    		Also accepts now a new value for the column FIELD_TYPE : RTF (for rich text fields) - no structural changes for that though.
ALTER TABLE CUSTOM_FIELD ADD LARGE_DEFAULT_VALUE TEXT DEFAULT null NULL COMMENT 'this column is used by rich text cufs. It contains HTML data.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3576-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 292, '8:046be71c438101fd3b919c2c57f4507e', 'addColumn tableName=CUSTOM_FIELD', 'Prepares the table CUSTOM_FIELD for possible default_values of type TEXT.
  		Also accepts now a new value for the column FIELD_TYPE : RTF (for rich text fields) - no structural changes for that though.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3576-2::bsiri
--  prepares the table CUSTOM_FIELD_VALUE for values of type CLOB, and adds support for inheritance to that end.
ALTER TABLE CUSTOM_FIELD_VALUE ADD LARGE_VALUE TEXT DEFAULT null NULL COMMENT 'this column is used by rich text cufs. It contains HTML data.' , ADD FIELD_TYPE VARCHAR(3) DEFAULT 'CF' NOT NULL COMMENT 'CF : simple, RTF : rich text field';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3576-2', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 293, '8:e8e15c8f5b92d56655543e59bf88c57e', 'addColumn tableName=CUSTOM_FIELD_VALUE', 'prepares the table CUSTOM_FIELD_VALUE for values of type CLOB, and adds support for inheritance to that end.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3576-3::bsiri
--  Prepares the table DENORMALIZED_FIELD_VALUE for values of type CLOB, and adds support for inheritance to that end.
--    		Also accepts now a new value for the column FIELD_TYPE : RTF (for rich text fields) - no structural changes for that though.
ALTER TABLE DENORMALIZED_FIELD_VALUE ADD LARGE_VALUE TEXT DEFAULT null NULL COMMENT 'this column is used by rich text cufs. It contains HTML data.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3576-3', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 294, '8:275f19eeecd96b3df5a5768f7d75a0c5', 'addColumn tableName=DENORMALIZED_FIELD_VALUE', 'Prepares the table DENORMALIZED_FIELD_VALUE for values of type CLOB, and adds support for inheritance to that end.
  		Also accepts now a new value for the column FIELD_TYPE : RTF (for rich text fields) - no structural changes for that though.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3556-4::kdrifi
--  Cleaning duplicates of column ROLE_USER in table core_group _authority
DELETE FROM CORE_GROUP_AUTHORITY WHERE AUTHORITY='ROLE_USER';

DELETE FROM CORE_GROUP_AUTHORITY WHERE GROUP_ID = 1
        and AUTHORITY='ROLE_TM_USER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3556-4', 'kdrifi', 'tm/tm.changelog-1.11.0.xml', NOW(), 295, '8:4ef890c9a78f75194ffba62010194127', 'delete tableName=CORE_GROUP_AUTHORITY; delete tableName=CORE_GROUP_AUTHORITY', 'Cleaning duplicates of column ROLE_USER in table core_group _authority', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3577-1::mpagnon
--  Fix columns with CHAR(X) types to VARCHAR(X) type to avoid blank space filling by Postgresql
ALTER TABLE CUSTOM_FIELD MODIFY INPUT_TYPE VARCHAR(30);

ALTER TABLE CUSTOM_FIELD MODIFY FIELD_TYPE VARCHAR(3);

ALTER TABLE DENORMALIZED_FIELD_VALUE MODIFY FIELD_TYPE VARCHAR(3);

ALTER TABLE DENORMALIZED_FIELD_VALUE MODIFY INPUT_TYPE VARCHAR(30);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3577-1', 'mpagnon', 'tm/tm.changelog-1.11.0.xml', NOW(), 296, '8:3f8e023b7e017ef8467ec2b398a0ecb6', 'modifyDataType columnName=INPUT_TYPE, tableName=CUSTOM_FIELD; modifyDataType columnName=FIELD_TYPE, tableName=CUSTOM_FIELD; modifyDataType columnName=FIELD_TYPE, tableName=DENORMALIZED_FIELD_VALUE; modifyDataType columnName=INPUT_TYPE, tableName=D...', 'Fix columns with CHAR(X) types to VARCHAR(X) type to avoid blank space filling by Postgresql', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.9.0.feature-3138-2::jsimon
ALTER TABLE CAMPAIGN_LIBRARY_CONTENT MODIFY CONTENT_ORDER INT NOT NULL;

ALTER TABLE CLN_RELATIONSHIP MODIFY CONTENT_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-2', 'jsimon', 'tm/tm.changelog-1.11.0.xml', NOW(), 297, '8:481e650cd1e40f2a7642889911903e39', 'addNotNullConstraint columnName=CONTENT_ORDER, tableName=CAMPAIGN_LIBRARY_CONTENT; addNotNullConstraint columnName=CONTENT_ORDER, tableName=CLN_RELATIONSHIP', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.9.0.feature-3138-4::jsimon
ALTER TABLE RLN_RELATIONSHIP MODIFY CONTENT_ORDER INT NOT NULL;

ALTER TABLE REQUIREMENT_LIBRARY_CONTENT MODIFY CONTENT_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-4', 'jsimon', 'tm/tm.changelog-1.11.0.xml', NOW(), 298, '8:9377d668adfd32c2a981d69615b54d04', 'addNotNullConstraint columnName=CONTENT_ORDER, tableName=RLN_RELATIONSHIP; addNotNullConstraint columnName=CONTENT_ORDER, tableName=REQUIREMENT_LIBRARY_CONTENT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.9.0.feature-3138-6::jsimon
ALTER TABLE TCLN_RELATIONSHIP MODIFY CONTENT_ORDER INT NOT NULL;

ALTER TABLE TEST_CASE_LIBRARY_CONTENT MODIFY CONTENT_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.9.0.feature-3138-6', 'jsimon', 'tm/tm.changelog-1.11.0.xml', NOW(), 299, '8:1b5f45c17e669616d5ba536cc9452d02', 'addNotNullConstraint columnName=CONTENT_ORDER, tableName=TCLN_RELATIONSHIP; addNotNullConstraint columnName=CONTENT_ORDER, tableName=TEST_CASE_LIBRARY_CONTENT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3693-1::bsiri
--  Adding support for call-step level management of datasets
ALTER TABLE CALL_TEST_STEP ADD CALLED_DATASET BIGINT DEFAULT null NULL COMMENT 'A reference to the called dataset (if any). The fk constraint must set null when the dataset is deleted.' , ADD DELEGATE_PARAMETER_VALUES BIT(1) DEFAULT 0 NOT NULL COMMENT 'Says whether the parameters of the called test case must be set by the caller test case or not';

ALTER TABLE CALL_TEST_STEP ADD CONSTRAINT fk_call_step_dataset FOREIGN KEY (CALLED_DATASET) REFERENCES DATASET (DATASET_ID) ON DELETE SET NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3693-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 300, '8:3d28fc731b1b0df5b42e60edd0a21c6b', 'addColumn tableName=CALL_TEST_STEP; addForeignKeyConstraint baseTableName=CALL_TEST_STEP, constraintName=fk_call_step_dataset, referencedTableName=DATASET', 'Adding support for call-step level management of datasets', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3693-2::bsiri
--  For back compatibility, the call steps migrating from an existing DB will now be set to delegate the parameters
UPDATE CALL_TEST_STEP SET DELEGATE_PARAMETER_VALUES = 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3693-2', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 301, '8:dd832c6cfeba03cdd1024f942f566970', 'update tableName=CALL_TEST_STEP', 'For back compatibility, the call steps migrating from an existing DB will now be set to delegate the parameters', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3700-1::bsiri
--  Items of a campaign test plan can now reference Datasets
ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM ADD DATASET_ID BIGINT NULL COMMENT 'the dataset the test plan item should use so that new iterations will now use those datasets';

ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM ADD CONSTRAINT fk_camp_test_plan_item_dataset FOREIGN KEY (DATASET_ID) REFERENCES DATASET (DATASET_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3700-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 302, '8:5ff62c57bf0c4707cbf77606d1c0eff0', 'addColumn tableName=CAMPAIGN_TEST_PLAN_ITEM', 'Items of a campaign test plan can now reference Datasets', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.11.0.xml::tm-1.11.0.feature-3701-1::bsiri
--  An execution now remembers which dataset was used (or not). That new column encodes three states :
--  				"" -> no dataset used,
--  				somelabel -> the label of the dataset used,
--  				null -> the test case had no parameters anyway
ALTER TABLE EXECUTION ADD DATASET_LABEL VARCHAR(255) NULL COMMENT 'the name of the dataset used';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.11.0.feature-3701-1', 'bsiri', 'tm/tm.changelog-1.11.0.xml', NOW(), 303, '8:81dfe5232f8d4d181dd151c922e82950', 'addColumn tableName=EXECUTION', 'An execution now remembers which dataset was used (or not). That new column encodes three states :
				"" -> no dataset used,
				somelabel -> the label of the dataset used,
				null -> the test case had no parameters anyway', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0::jsimon
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.12.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0', 'jsimon', 'tm/tm.changelog-1.12.0.xml', NOW(), 304, '8:88dcb691497aee7858074ead96323310', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feature-3607-1::jsimon
--  Table for Milestones
CREATE TABLE MILESTONE (MILESTONE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'Primary key', LABEL VARCHAR(30) NOT NULL COMMENT 'Milestone label', STATUS VARCHAR(30) NULL COMMENT 'Milestone status', END_DATE datetime NOT NULL COMMENT 'Term date', `DESCRIPTION` LONGTEXT NULL COMMENT 'Milestone description', M_RANGE VARCHAR(30) NOT NULL COMMENT 'Milestone range', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'Name of the milestone creator', CREATED_ON datetime NOT NULL COMMENT 'Date of creation.', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'last modified by', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Date of last update', USER_ID BIGINT NOT NULL COMMENT 'the user that own the milestone', CONSTRAINT PK_MILESTONE PRIMARY KEY (MILESTONE_ID), CONSTRAINT fk_milestone_owner FOREIGN KEY (USER_ID) REFERENCES CORE_USER(PARTY_ID), UNIQUE (LABEL)) ENGINE = INNODB;

CREATE INDEX idx_milestone ON MILESTONE(MILESTONE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feature-3607-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', NOW(), 305, '8:ff298f12a8e741d51cb3663d01d766b9', 'createTable tableName=MILESTONE; createIndex indexName=idx_milestone, tableName=MILESTONE', 'Table for Milestones', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feature-3608-1::jsimon
--  Table for MilestoneBinding
CREATE TABLE MILESTONE_BINDING (MILESTONE_BINDING_ID BIGINT AUTO_INCREMENT NOT NULL, MILESTONE_ID BIGINT NOT NULL, PROJECT_ID BIGINT NOT NULL, CONSTRAINT PK_MILESTONE_BINDING PRIMARY KEY (MILESTONE_BINDING_ID), CONSTRAINT FK_MILESTONE_BINDING_MILESTONE FOREIGN KEY (MILESTONE_ID) REFERENCES MILESTONE(MILESTONE_ID), CONSTRAINT FK_MILESTONE_BINDING_PROJECT FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feature-3608-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', NOW(), 306, '8:7014f97d59bcedceceffac2ed37cb395', 'createTable tableName=MILESTONE_BINDING', 'Table for MilestoneBinding', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feature-3609-1::jsimon
--  Table for MilestoneBindingPerimeter
CREATE TABLE MILESTONE_BINDING_PERIMETER (MILESTONE_BINDING_PERIMETER_ID BIGINT AUTO_INCREMENT NOT NULL, MILESTONE_ID BIGINT NOT NULL, PROJECT_ID BIGINT NOT NULL, CONSTRAINT PK_MILESTONE_BINDING_PERIMETER PRIMARY KEY (MILESTONE_BINDING_PERIMETER_ID), CONSTRAINT FK_MILESTONE_BINDING_PERIMETER_PROJECT FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT FK_MILESTONE_BINDING_PERIMETER_MILESTONE FOREIGN KEY (MILESTONE_ID) REFERENCES MILESTONE(MILESTONE_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feature-3609-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', NOW(), 307, '8:2e3d1a102954dddc6cc105b918d2f0dd', 'createTable tableName=MILESTONE_BINDING_PERIMETER', 'Table for MilestoneBindingPerimeter', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feature-3823-1::bsiri
--  Creating the values table for multi-valued custom fields, much like CUSTOM_FIELD_OPTION is. 
--    	Note : the DELETE CASCADE on the foreign key is necessary because Hibernate won't do it (as specified, see HHH-5529)
CREATE TABLE CUSTOM_FIELD_VALUE_OPTION (CFV_ID BIGINT NOT NULL, LABEL VARCHAR(255) NOT NULL, POSITION INT NOT NULL, CONSTRAINT fk_cfv_option_cfv FOREIGN KEY (CFV_ID) REFERENCES CUSTOM_FIELD_VALUE(CFV_ID) ON DELETE CASCADE) COMMENT='The table.' ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feature-3823-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 308, '8:bbcf8622b215aa6f1c3c19862268a45e', 'createTable tableName=CUSTOM_FIELD_VALUE_OPTION', 'Creating the values table for multi-valued custom fields, much like CUSTOM_FIELD_OPTION is. 
  	Note : the DELETE CASCADE on the foreign key is necessary because Hibernate won''t do it (as specified, see HHH-5529)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feature-3823-2::bsiri
--  Same table for the denormalized field values
CREATE TABLE DENORMALIZED_FIELD_VALUE_OPTION (DFV_ID BIGINT NOT NULL, LABEL VARCHAR(255) NOT NULL, POSITION INT NOT NULL, CONSTRAINT fk_dfv_option_dfv FOREIGN KEY (DFV_ID) REFERENCES DENORMALIZED_FIELD_VALUE(DFV_ID) ON DELETE CASCADE) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feature-3823-2', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 309, '8:c6894fb57d027f3243603da4a04e65ee', 'createTable tableName=DENORMALIZED_FIELD_VALUE_OPTION', 'Same table for the denormalized field values', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feature-3823-3::bsiri
--  tables CUSTOM_FIELD_OPTION and DENORMALIZED_FIELD_OPTION no longer enforce the option position.
ALTER TABLE CUSTOM_FIELD_OPTION MODIFY POSITION INT NULL;

ALTER TABLE DENORMALIZED_FIELD_OPTION MODIFY POSITION INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feature-3823-3', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 310, '8:f3f4cbfade0669a80a7b3eedf09efe65', 'dropNotNullConstraint columnName=POSITION, tableName=CUSTOM_FIELD_OPTION; dropNotNullConstraint columnName=POSITION, tableName=DENORMALIZED_FIELD_OPTION', 'tables CUSTOM_FIELD_OPTION and DENORMALIZED_FIELD_OPTION no longer enforce the option position.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.issue-4017-1::bsiri
--  Some columns in REQUIREMENT_PROPERTY_CHANGE are too short compared to what 
--    	they are supposed to store. This changeset makes them bigger.
ALTER TABLE REQUIREMENT_PROPERTY_CHANGE MODIFY OLD_VALUE VARCHAR(255);

ALTER TABLE REQUIREMENT_PROPERTY_CHANGE MODIFY NEW_VALUE VARCHAR(255);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.issue-4017-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 311, '8:fd4099f77e0d72f3912b5c487ca698ed', 'modifyDataType columnName=OLD_VALUE, tableName=REQUIREMENT_PROPERTY_CHANGE; modifyDataType columnName=NEW_VALUE, tableName=REQUIREMENT_PROPERTY_CHANGE', 'Some columns in REQUIREMENT_PROPERTY_CHANGE are too short compared to what 
  	they are supposed to store. This changeset makes them bigger.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-1::bsiri
--  creating the table structure for parameterized list
CREATE TABLE INFO_LIST (INFO_LIST_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'the ID', LABEL VARCHAR(100) NULL COMMENT 'the label for this list. Would noly be displayed in the administration page as the name  actually displayed to regular uses would depend on the role of that list on a given projet (criticality, nature etc)', `DESCRIPTION` TEXT NULL COMMENT 'a description for that list', CODE VARCHAR(30) NOT NULL COMMENT 'a code that helps identifying that list', CREATED_BY VARCHAR(50) NOT NULL COMMENT 'username of the user who created that list', CREATED_ON datetime NOT NULL COMMENT 'the time at when that list was created', LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'username of the last user who modified one of the list attributes', LAST_MODIFIED_ON datetime DEFAULT null NULL COMMENT 'Time when the list was touched last', CONSTRAINT PK_INFO_LIST PRIMARY KEY (INFO_LIST_ID), UNIQUE (LABEL), UNIQUE (CODE)) ENGINE = INNODB;

CREATE INDEX idx_info_list_code ON INFO_LIST(CODE);

CREATE TABLE INFO_LIST_ITEM (ITEM_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'an ID, what did you expect ?', ITEM_TYPE VARCHAR(3) NOT NULL COMMENT 'discriminator telling whether this item is user-made or builtin in the app. Pick one of ''USR'' or ''SYS''', LIST_ID BIGINT NULL COMMENT 'foreign key to the list this item belongs to. Allows ''NULL'' for Hibernate to work.', ITEM_INDEX INT NULL COMMENT 'the position of that item in the list. Allows ''NULL'' for Hibernate to work.', LABEL VARCHAR(100) NOT NULL COMMENT 'a label to be displayed. If the item is builtin this label will be a i18n key, else the label will be displayed verbatim', CODE VARCHAR(30) NOT NULL COMMENT 'a code that helps identifying that item', IS_DEFAULT BIT(1) DEFAULT 0 NOT NULL COMMENT 'whether this item is the default item for         its list. Only one item per list should have it true ', ICON_NAME VARCHAR(100) NULL COMMENT 'the identifier of the icon to be displayed', CONSTRAINT PK_INFO_LIST_ITEM PRIMARY KEY (ITEM_ID), CONSTRAINT fk_info_item_list FOREIGN KEY (LIST_ID) REFERENCES INFO_LIST(INFO_LIST_ID), UNIQUE (CODE)) ENGINE = INNODB;

CREATE INDEX idx_info_list_item_code ON INFO_LIST_ITEM(CODE);

CREATE INDEX idx_info_list_label ON INFO_LIST(LABEL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 312, '8:699c9f1d850fa6df903852d0ffe93348', 'createTable tableName=INFO_LIST; createIndex indexName=idx_info_list_code, tableName=INFO_LIST; createTable tableName=INFO_LIST_ITEM; createIndex indexName=idx_info_list_item_code, tableName=INFO_LIST_ITEM; createIndex indexName=idx_info_list_labe...', 'creating the table structure for parameterized list', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-2::bsiri
--  Updating the definition of an execution
ALTER TABLE EXECUTION ADD TC_NAT_LABEL VARCHAR(100) NULL COMMENT 'a label to be displayed. If the item is builtin this label will be a i18n key, else the label will        be displayed verbatim' , ADD TC_NAT_CODE VARCHAR(30) NULL COMMENT 'a code that helps identifying that item. Note that unlike the original version the values for       that column will not be unique.' , ADD TC_NAT_ICON_NAME VARCHAR(100) NULL COMMENT 'the identifier of the icon to be displayed' , ADD TC_TYP_LABEL VARCHAR(100) NULL COMMENT 'a label to be displayed. If the item is builtin this label will be a i18n key, else the label will  be displayed verbatim' , ADD TC_TYP_CODE VARCHAR(30) NULL COMMENT 'a code that helps identifying that item. Note that unlike the original version the values for       that column will not be unique.' , ADD TC_TYP_ICON_NAME VARCHAR(100) NULL COMMENT 'the identifier of the icon to be displayed';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-2', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 313, '8:227e13ef4bed0445d8266877b348765c', 'addColumn tableName=EXECUTION', 'Updating the definition of an execution', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-3::bsiri
--  inserting the default lists in the database
INSERT INTO INFO_LIST (INFO_LIST_ID, LABEL, `DESCRIPTION`, CODE, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON) VALUES ('1', 'infolist.category.default', '', 'DEF_REQ_CAT', 'system', '2010-01-01 00:00:00', 'system', '2010-01-01 00:00:00');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('1', 'SYS', '1', '0', 'requirement.category.CAT_FUNCTIONAL', 'CAT_FUNCTIONAL', 0, 'def_cat_functional');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('2', 'SYS', '1', '1', 'requirement.category.CAT_NON_FUNCTIONAL', 'CAT_NON_FUNCTIONAL', 0, 'def_cat_non-functional');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('3', 'SYS', '1', '2', 'requirement.category.CAT_USE_CASE', 'CAT_USE_CASE', 0, 'def_cat_use-case');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('4', 'SYS', '1', '3', 'requirement.category.CAT_BUSINESS', 'CAT_BUSINESS', 0, 'def_cat_business');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('5', 'SYS', '1', '4', 'requirement.category.CAT_TEST_REQUIREMENT', 'CAT_TEST_REQUIREMENT', 0, 'def_cat_test-requirement');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('6', 'SYS', '1', '5', 'requirement.category.CAT_UNDEFINED', 'CAT_UNDEFINED', 1, 'def_cat_undefined');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('7', 'SYS', '1', '6', 'requirement.category.CAT_ERGONOMIC', 'CAT_ERGONOMIC', 0, 'def_cat_ergonomic');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('8', 'SYS', '1', '7', 'requirement.category.CAT_PERFORMANCE', 'CAT_PERFORMANCE', 0, 'def_cat_performance');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('9', 'SYS', '1', '8', 'requirement.category.CAT_TECHNICAL', 'CAT_TECHNICAL', 0, 'def_cat_technical');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('10', 'SYS', '1', '9', 'requirement.category.CAT_USER_STORY', 'CAT_USER_STORY', 0, 'def_cat_user-story');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('11', 'SYS', '1', '10', 'requirement.category.CAT_SECURITY', 'CAT_SECURITY', 0, 'def_cat_security');

INSERT INTO INFO_LIST (INFO_LIST_ID, LABEL, `DESCRIPTION`, CODE, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON) VALUES ('2', 'infolist.nature.default', '', 'DEF_TC_NAT', 'system', '2010-01-01 00:00:00', 'system', '2010-01-01 00:00:00');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('12', 'SYS', '2', '0', 'test-case.nature.NAT_UNDEFINED', 'NAT_UNDEFINED', 1, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('13', 'SYS', '2', '1', 'test-case.nature.NAT_FUNCTIONAL_TESTING', 'NAT_FUNCTIONAL_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('14', 'SYS', '2', '2', 'test-case.nature.NAT_BUSINESS_TESTING', 'NAT_BUSINESS_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('15', 'SYS', '2', '3', 'test-case.nature.NAT_USER_TESTING', 'NAT_USER_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('16', 'SYS', '2', '4', 'test-case.nature.NAT_NON_FUNCTIONAL_TESTING', 'NAT_NON_FUNCTIONAL_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('17', 'SYS', '2', '5', 'test-case.nature.NAT_PERFORMANCE_TESTING', 'NAT_PERFORMANCE_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('18', 'SYS', '2', '6', 'test-case.nature.NAT_SECURITY_TESTING', 'NAT_SECURITY_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('19', 'SYS', '2', '7', 'test-case.nature.NAT_ATDD', 'NAT_ATDD', 0, 'noicon');

INSERT INTO INFO_LIST (INFO_LIST_ID, LABEL, `DESCRIPTION`, CODE, CREATED_BY, CREATED_ON, LAST_MODIFIED_BY, LAST_MODIFIED_ON) VALUES ('3', 'infolist.type.default', '', 'DEF_TC_TYP', 'system', '2010-01-01 00:00:00', 'system', '2010-01-01 00:00:00');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('20', 'SYS', '3', '0', 'test-case.type.TYP_UNDEFINED', 'TYP_UNDEFINED', 1, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('21', 'SYS', '3', '1', 'test-case.type.TYP_COMPLIANCE_TESTING', 'TYP_COMPLIANCE_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('22', 'SYS', '3', '2', 'test-case.type.TYP_CORRECTION_TESTING', 'TYP_CORRECTION_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('23', 'SYS', '3', '3', 'test-case.type.TYP_EVOLUTION_TESTING', 'TYP_EVOLUTION_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('24', 'SYS', '3', '4', 'test-case.type.TYP_REGRESSION_TESTING', 'TYP_REGRESSION_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('25', 'SYS', '3', '5', 'test-case.type.TYP_END_TO_END_TESTING', 'TYP_END_TO_END_TESTING', 0, 'noicon');

INSERT INTO INFO_LIST_ITEM (ITEM_ID, ITEM_TYPE, LIST_ID, ITEM_INDEX, LABEL, CODE, IS_DEFAULT, ICON_NAME) VALUES ('26', 'SYS', '3', '6', 'test-case.type.TYP_PARTNER_TESTING', 'TYP_PARTNER_TESTING', 0, 'noicon');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-3', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 314, '8:50774e205e67740e4e184d893efd86a3', 'insert tableName=INFO_LIST; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO_LIST_ITEM; insert tableName=INFO...', 'inserting the default lists in the database', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-4::bsiri
--  other structural modifications
ALTER TABLE PROJECT ADD REQ_CATEGORIES_LIST BIGINT DEFAULT 1 NOT NULL COMMENT 'foreign key to the requirement categories used in that project' , ADD TC_NATURES_LIST BIGINT DEFAULT 2 NOT NULL COMMENT 'foreign key to the test case natures used in that project' , ADD TC_TYPES_LIST BIGINT DEFAULT 3 NOT NULL COMMENT 'foreign key to the test case types used in that project';

ALTER TABLE PROJECT ADD CONSTRAINT proj_req_categories FOREIGN KEY (REQ_CATEGORIES_LIST) REFERENCES INFO_LIST (INFO_LIST_ID);

ALTER TABLE PROJECT ADD CONSTRAINT proj_tc_natures FOREIGN KEY (TC_NATURES_LIST) REFERENCES INFO_LIST (INFO_LIST_ID);

ALTER TABLE PROJECT ADD CONSTRAINT proj_tc_types FOREIGN KEY (TC_TYPES_LIST) REFERENCES INFO_LIST (INFO_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-4', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 315, '8:932e211beea488279ced250ca90e7797', 'addColumn tableName=PROJECT', 'other structural modifications', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-6::bsiri
--  migrate the test cases
ALTER TABLE TEST_CASE CHANGE TC_NATURE TC_NATURE_OLD VARCHAR(30);

ALTER TABLE TEST_CASE ADD TC_NATURE BIGINT DEFAULT 12 NOT NULL COMMENT 'foreign key to the info list item';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_tc_nature FOREIGN KEY (TC_NATURE) REFERENCES INFO_LIST_ITEM (ITEM_ID);

update TEST_CASE set TC_NATURE = 12 where TC_NATURE_OLD = 'UNDEFINED';

update TEST_CASE set TC_NATURE = 13 where TC_NATURE_OLD = 'FUNCTIONAL_TESTING';

update TEST_CASE set TC_NATURE = 14 where TC_NATURE_OLD = 'BUSINESS_TESTING';

update TEST_CASE set TC_NATURE = 15 where TC_NATURE_OLD = 'USER_TESTING';

update TEST_CASE set TC_NATURE = 16 where TC_NATURE_OLD = 'NON_FUNCTIONAL_TESTING';

update TEST_CASE set TC_NATURE = 17 where TC_NATURE_OLD = 'PERFORMANCE_TESTING';

update TEST_CASE set TC_NATURE = 18 where TC_NATURE_OLD = 'SECURITY_TESTING';

update TEST_CASE set TC_NATURE = 19 where TC_NATURE_OLD = 'ATDD';

ALTER TABLE TEST_CASE DROP COLUMN TC_NATURE_OLD;

ALTER TABLE TEST_CASE CHANGE TC_TYPE TC_TYPE_OLD VARCHAR(30);

ALTER TABLE TEST_CASE ADD TC_TYPE BIGINT DEFAULT 20 NOT NULL COMMENT 'foreign key to the info list item';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_tc_type FOREIGN KEY (TC_TYPE) REFERENCES INFO_LIST_ITEM (ITEM_ID);

update TEST_CASE set TC_TYPE = 20 where TC_TYPE_OLD = 'UNDEFINED';

update TEST_CASE set TC_TYPE = 21 where TC_TYPE_OLD = 'COMPLIANCE_TESTING';

update TEST_CASE set TC_TYPE = 22 where TC_TYPE_OLD = 'CORRECTION_TESTING';

update TEST_CASE set TC_TYPE = 23 where TC_TYPE_OLD = 'EVOLUTION_TESTING';

update TEST_CASE set TC_TYPE = 24 where TC_TYPE_OLD = 'REGRESSION_TESTING';

update TEST_CASE set TC_TYPE = 25 where TC_TYPE_OLD = 'END_TO_END_TESTING';

update TEST_CASE set TC_TYPE = 26 where TC_TYPE_OLD = 'PARTNER_TESTING';

ALTER TABLE TEST_CASE DROP COLUMN TC_TYPE_OLD;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-6', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 316, '8:97a9a415af4e8d507a458dc6fe0f379f', 'renameColumn newColumnName=TC_NATURE_OLD, oldColumnName=TC_NATURE, tableName=TEST_CASE; addColumn tableName=TEST_CASE; sql; dropColumn columnName=TC_NATURE_OLD, tableName=TEST_CASE; renameColumn newColumnName=TC_TYPE_OLD, oldColumnName=TC_TYPE, ta...', 'migrate the test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-7::bsiri
--  migrate the requirements
ALTER TABLE REQUIREMENT_VERSION CHANGE CATEGORY CATEGORY_OLD VARCHAR(30);

ALTER TABLE REQUIREMENT_VERSION ADD CATEGORY BIGINT DEFAULT 1 NOT NULL COMMENT 'foreign key to the info list item';

ALTER TABLE REQUIREMENT_VERSION ADD CONSTRAINT fk_req_nature FOREIGN KEY (CATEGORY) REFERENCES INFO_LIST_ITEM (ITEM_ID);

update REQUIREMENT_VERSION set CATEGORY = 1 where CATEGORY_OLD = 'FUNCTIONAL';

update REQUIREMENT_VERSION set CATEGORY = 2 where CATEGORY_OLD = 'NON_FUNCTIONAL';

update REQUIREMENT_VERSION set CATEGORY = 3 where CATEGORY_OLD = 'USE_CASE';

update REQUIREMENT_VERSION set CATEGORY = 4 where CATEGORY_OLD = 'BUSINESS';

update REQUIREMENT_VERSION set CATEGORY = 5 where CATEGORY_OLD = 'TEST_REQUIREMENT';

update REQUIREMENT_VERSION set CATEGORY = 6 where CATEGORY_OLD = 'UNDEFINED';

update REQUIREMENT_VERSION set CATEGORY = 7 where CATEGORY_OLD = 'ERGONOMIC';

update REQUIREMENT_VERSION set CATEGORY = 8 where CATEGORY_OLD = 'PERFORMANCE';

update REQUIREMENT_VERSION set CATEGORY = 9 where CATEGORY_OLD = 'TECHNICAL';

update REQUIREMENT_VERSION set CATEGORY = 10 where CATEGORY_OLD = 'USER_STORY';

update REQUIREMENT_VERSION set CATEGORY = 11 where CATEGORY_OLD = 'SECURITY';

ALTER TABLE REQUIREMENT_VERSION DROP COLUMN CATEGORY_OLD;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-7', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 317, '8:6cf6f64c283662f01379ae8a0d0c25f9', 'renameColumn newColumnName=CATEGORY_OLD, oldColumnName=CATEGORY, tableName=REQUIREMENT_VERSION; addColumn tableName=REQUIREMENT_VERSION; sql; dropColumn columnName=CATEGORY_OLD, tableName=REQUIREMENT_VERSION', 'migrate the requirements', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4068-8::bsiri
--  migrating the columns from EXECUTION
update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_UNDEFINED',
      TC_NAT_CODE = 'NAT_UNDEFINED',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='UNDEFINED';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_FUNCTIONAL_TESTING',
      TC_NAT_CODE = 'NAT_FUNCTIONAL_TESTING',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='FUNCTIONAL_TESTING';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_BUSINESS_TESTING',
      TC_NAT_CODE = 'NAT_BUSINESS_TESTING',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='BUSINESS_TESTING';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_USER_TESTING',
      TC_NAT_CODE = 'NAT_USER_TESTING',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='USER_TESTING';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_NON_FUNCTIONAL_TESTING',
      TC_NAT_CODE = 'NAT_NON_FUNCTIONAL_TESTING',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='NON_FUNCTIONAL_TESTING';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_PERFORMANCE_TESTING',
      TC_NAT_CODE = 'NAT_PERFORMANCE_TESTING',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='PERFORMANCE_TESTING';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_SECURITY_TESTING',
      TC_NAT_CODE = 'NAT_SECURITY_TESTING',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='SECURITY_TESTING';

update EXECUTION
      set TC_NAT_LABEL = 'test-case.nature.NAT_ATDD',
      TC_NAT_CODE = 'NAT_ATDD',
      TC_NAT_ICON_NAME = 'noicon'
      where TC_NATURE='ATDD';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_UNDEFINED',
      TC_TYP_CODE = 'TYP_UNDEFINED',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='UNDEFINED';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_COMPLIANCE_TESTING',
      TC_TYP_CODE = 'TYP_COMPLIANCE_TESTING',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='COMPLIANCE_TESTING';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_CORRECTION_TESTING',
      TC_TYP_CODE = 'TYP_CORRECTION_TESTING',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='CORRECTION_TESTING';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_EVOLUTION_TESTING',
      TC_TYP_CODE = 'TYP_EVOLUTION_TESTING',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='EVOLUTION_TESTING';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_REGRESSION_TESTING',
      TC_TYP_CODE = 'TYP_REGRESSION_TESTING',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='REGRESSION_TESTING';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_END_TO_END_TESTING',
      TC_TYP_CODE = 'TYP_END_TO_END_TESTING',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='END_TO_END_TESTING';

update EXECUTION
      set TC_TYP_LABEL = 'test-case.type.TYP_PARTNER_TESTING',
      TC_TYP_CODE = 'TYP_PARTNER_TESTING',
      TC_TYP_ICON_NAME = 'noicon'
      where TC_TYPE='PARTNER_TESTING';

ALTER TABLE EXECUTION DROP COLUMN TC_NATURE;

ALTER TABLE EXECUTION DROP COLUMN TC_TYPE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4068-8', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 318, '8:1989bab44697afb24e198d91d88c6a73', 'sql; dropColumn columnName=TC_NATURE, tableName=EXECUTION; dropColumn columnName=TC_TYPE, tableName=EXECUTION', 'migrating the columns from EXECUTION', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-3764-1::flaurens
--  Tables for OAuth2 Support
CREATE TABLE oauth_client_details (CLIENT_ID VARCHAR(255) NOT NULL, CLIENT_SECRET VARCHAR(255) NULL, RESOURCE_IDS VARCHAR(255) DEFAULT null NULL, SCOPE VARCHAR(255) DEFAULT 'location,locationhistory' NULL, AUTHORIZED_GRANT_TYPES VARCHAR(255) DEFAULT 'password,authorization_code,refresh_token,implicit' NULL, WEB_SERVER_REDIRECT_URI VARCHAR(255) DEFAULT null NULL, AUTHORITIES VARCHAR(255) DEFAULT 'ROLE_CLIENT, ROLE_TRUSTED_CLIENT' NULL, ACCESS_TOKEN_VALIDITY BIGINT DEFAULT 60 NULL, REFRESH_TOKEN_VALIDITY BIGINT DEFAULT null NULL, ADDITIONAL_INFORMATION LONGTEXT DEFAULT null NULL, AUTOAPPROVE VARCHAR(255) NULL, CONSTRAINT PK_OAUTH_CLIENT_DETAILS PRIMARY KEY (CLIENT_ID)) ENGINE = INNODB;

CREATE TABLE oauth_client_token (TOKEN_ID VARCHAR(255) NOT NULL, TOKEN LONGBLOB NULL, AUTHENTICATION_ID VARCHAR(255) NULL, USER_NAME VARCHAR(255) NULL, CLIENT_ID VARCHAR(255) NULL, CONSTRAINT PK_OAUTH_CLIENT_TOKEN PRIMARY KEY (TOKEN_ID), UNIQUE (AUTHENTICATION_ID)) ENGINE = INNODB;

CREATE TABLE oauth_access_token (TOKEN_ID VARCHAR(255) NOT NULL, TOKEN LONGBLOB NULL, AUTHENTICATION_ID VARCHAR(255) NULL, USER_NAME VARCHAR(255) NULL, CLIENT_ID VARCHAR(255) NULL, AUTHENTICATION LONGBLOB NULL, REFRESH_TOKEN VARCHAR(255) NULL, CONSTRAINT PK_OAUTH_ACCESS_TOKEN PRIMARY KEY (TOKEN_ID), UNIQUE (AUTHENTICATION_ID)) ENGINE = INNODB;

CREATE TABLE oauth_refresh_token (TOKEN_ID VARCHAR(255) NOT NULL, TOKEN LONGBLOB NULL, AUTHENTICATION LONGBLOB NULL, CONSTRAINT PK_OAUTH_REFRESH_TOKEN PRIMARY KEY (TOKEN_ID)) ENGINE = INNODB;

CREATE TABLE oauth_code (CODE VARCHAR(255) NOT NULL, AUTHENTICATION LONGBLOB NULL, CONSTRAINT PK_OAUTH_CODE PRIMARY KEY (CODE)) ENGINE = INNODB;

CREATE TABLE oauth_approvals (USERID VARCHAR(255) NOT NULL, CLIENTID VARCHAR(255) NOT NULL, SCOPE VARCHAR(255) NULL, STATUS VARCHAR(10) NULL, EXPIRESAT datetime NULL, LASTMODIFIEDAT datetime NULL) ENGINE = INNODB;

ALTER TABLE oauth_approvals ADD PRIMARY KEY (USERID, CLIENTID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-3764-1', 'flaurens', 'tm/tm.changelog-1.12.0.xml', NOW(), 319, '8:e76f4c9d87bcdf267ec3edc0b42876da', 'createTable tableName=oauth_client_details; createTable tableName=oauth_client_token; createTable tableName=oauth_access_token; createTable tableName=oauth_refresh_token; createTable tableName=oauth_code; createTable tableName=oauth_approvals; add...', 'Tables for OAuth2 Support', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-4171-1::jsimon
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('uploadfilter.fileExtensions.whitelist', 'txt, doc, xls, ppt, docx, xlsx, pptx, odt, ods, odp, pdf');

INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('uploadfilter.upload.sizeLimitInBytes', '4000000');

INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('uploadfilter.upload.import.sizeLimitInBytes', '2000000');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-4171-1', 'jsimon', 'tm/tm.changelog-1.12.0.xml', NOW(), 320, '8:ca6c8021a7f62cb1fdc93baf4e19470e', 'insert tableName=CORE_CONFIG; insert tableName=CORE_CONFIG; insert tableName=CORE_CONFIG', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.0.xml::tm-1.12.0.feat-3611-1::bsiri
--  Creating the tables modeling the relationships between milestones and test cases, requirement versions 
--      		and campaigns
CREATE TABLE MILESTONE_TEST_CASE (MILESTONE_ID BIGINT NOT NULL COMMENT 'foreign key to table MILESTONE', TEST_CASE_ID BIGINT NOT NULL COMMENT 'foreign key to table TEST_CASE', CONSTRAINT milestone_tc_milestone FOREIGN KEY (MILESTONE_ID) REFERENCES MILESTONE(MILESTONE_ID), CONSTRAINT milestone_tc_tc FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

CREATE TABLE MILESTONE_REQ_VERSION (MILESTONE_ID BIGINT NOT NULL COMMENT 'foreign key to table MILESTONE', REQ_VERSION_ID BIGINT NOT NULL COMMENT 'foreign key to table REQUIREMENT_VERSION', CONSTRAINT milestone_rqv_rqv FOREIGN KEY (REQ_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID), CONSTRAINT milestone_rqv_milestone FOREIGN KEY (MILESTONE_ID) REFERENCES MILESTONE(MILESTONE_ID)) ENGINE = INNODB;

CREATE TABLE MILESTONE_CAMPAIGN (MILESTONE_ID BIGINT NOT NULL COMMENT 'foreign key to table MILESTONE', CAMPAIGN_ID BIGINT NOT NULL COMMENT 'foreign key to table CAMPAIGN', CONSTRAINT milestone_camp_milestone FOREIGN KEY (MILESTONE_ID) REFERENCES MILESTONE(MILESTONE_ID), CONSTRAINT milestone_camp_camp FOREIGN KEY (CAMPAIGN_ID) REFERENCES CAMPAIGN(CLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.0.feat-3611-1', 'bsiri', 'tm/tm.changelog-1.12.0.xml', NOW(), 321, '8:a8873f6339b44d8d0309c4b7c080e739', 'createTable tableName=MILESTONE_TEST_CASE; createTable tableName=MILESTONE_REQ_VERSION; createTable tableName=MILESTONE_CAMPAIGN', 'Creating the tables modeling the relationships between milestones and test cases, requirement versions 
    		and campaigns', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.12.3' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 322, '8:dc6d2d6170ded24cc95fc871d154fb67', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-5965-1-1-mysql::bsiri
--  Fixing data in TCLN_RELATIONSHIP_CLOSURE that need to be
create table CLOSURECOPY as
			select distinct * from TCLN_RELATIONSHIP_CLOSURE
			group by ancestor_id, descendant_id
			having count(*) > 1;

delete clos
			from TCLN_RELATIONSHIP_CLOSURE clos
			inner join CLOSURECOPY cop on (cop.ancestor_id = clos.ancestor_id
			and cop.descendant_id = clos.descendant_id
			and cop.depth = clos.depth);

insert into TCLN_RELATIONSHIP_CLOSURE
			select * from CLOSURECOPY;

drop table CLOSURECOPY;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-5965-1-1-mysql', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 323, '8:d503967dc40ddb816822f91c9f7b8dab', 'sql', 'Fixing data in TCLN_RELATIONSHIP_CLOSURE that need to be', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-5965-1-2-mysql::bsiri
--  Fixing data in RLN_RELATIONSHIP_CLOSURE that need to be
create table CLOSURECOPY as
			select distinct * from RLN_RELATIONSHIP_CLOSURE
			group by ancestor_id, descendant_id
			having count(*) > 1;

delete clos
			from RLN_RELATIONSHIP_CLOSURE clos
			inner join CLOSURECOPY cop on (cop.ancestor_id = clos.ancestor_id
			and cop.descendant_id = clos.descendant_id
			and cop.depth = clos.depth);

insert into RLN_RELATIONSHIP_CLOSURE
			select * from CLOSURECOPY;

drop table CLOSURECOPY;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-5965-1-2-mysql', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 324, '8:8caf1c706891a32c2dc5c03d4cab6b31', 'sql', 'Fixing data in RLN_RELATIONSHIP_CLOSURE that need to be', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-5965-1-3-mysql::bsiri
--  Fixing data in CLN_RELATIONSHIP_CLOSURE that need to be
create table CLOSURECOPY as
			select distinct * from CLN_RELATIONSHIP_CLOSURE
			group by ancestor_id, descendant_id
			having count(*) > 1;

delete clos
			from CLN_RELATIONSHIP_CLOSURE clos
			inner join CLOSURECOPY cop on (cop.ancestor_id = clos.ancestor_id
			and cop.descendant_id = clos.descendant_id
			and cop.depth = clos.depth);

insert into CLN_RELATIONSHIP_CLOSURE
			select * from CLOSURECOPY;

drop table CLOSURECOPY;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-5965-1-3-mysql', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 325, '8:1c2e6953ad3a54e81ac0e35bd7243a59', 'sql', 'Fixing data in CLN_RELATIONSHIP_CLOSURE that need to be', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-5965-2-1::bsiri
--  now we can add the unique constraints on the closure tables
ALTER TABLE TCLN_RELATIONSHIP_CLOSURE ADD CONSTRAINT uniq_tcln_clos UNIQUE (ancestor_id, descendant_id);

ALTER TABLE RLN_RELATIONSHIP_CLOSURE ADD CONSTRAINT uniq_rln_clos UNIQUE (ancestor_id, descendant_id);

ALTER TABLE CLN_RELATIONSHIP_CLOSURE ADD CONSTRAINT uniq_cln_clos UNIQUE (ancestor_id, descendant_id);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-5965-2-1', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 326, '8:6df9afbc155d2a2f2a8eeaa99293695a', 'addUniqueConstraint constraintName=uniq_tcln_clos, tableName=TCLN_RELATIONSHIP_CLOSURE; addUniqueConstraint constraintName=uniq_rln_clos, tableName=RLN_RELATIONSHIP_CLOSURE; addUniqueConstraint constraintName=uniq_cln_clos, tableName=CLN_RELATIONS...', 'now we can add the unique constraints on the closure tables', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-3-1::bsiri
--  redefining some triggers for table TCLN_RELATIONHIP and TEST_CASE_LIBRARY_NODE
drop trigger if exists ins_tcln_after;

create trigger ins_tcln_after after insert on
			TEST_CASE_LIBRARY_NODE
			for each row insert ignore into
			TCLN_RELATIONSHIP_CLOSURE values (new.tcln_id, new.tcln_id, 0);

drop trigger if exists attach_tcln_after;

create trigger attach_tcln_after after insert on
			TCLN_RELATIONSHIP
			for each row insert ignore into TCLN_RELATIONSHIP_CLOSURE
			select c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
			from
			TCLN_RELATIONSHIP_CLOSURE c1
			cross join TCLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id =
			new.descendant_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-3-1', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 327, '8:45f6005adfd2eb582c2a2e0363b2bd19', 'sql; sql', 'redefining some triggers for table TCLN_RELATIONHIP and TEST_CASE_LIBRARY_NODE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-3-2::bsiri
--  redefining some triggers for table RLN_RELATIONHIP and REQUIREMENT_LIBRARY_NODE
drop trigger if exists ins_rln_after;

create trigger ins_rln_after after insert on
			REQUIREMENT_LIBRARY_NODE
			for each row insert ignore into
			RLN_RELATIONSHIP_CLOSURE values (new.rln_id, new.rln_id, 0);

drop trigger if exists attach_rln_after;

create trigger attach_rln_after after insert on RLN_RELATIONSHIP
			for each row insert ignore into RLN_RELATIONSHIP_CLOSURE
			select
			c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
			from
			RLN_RELATIONSHIP_CLOSURE c1
			cross join RLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id =
			new.descendant_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-3-2', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 328, '8:e96af54bacfc057629f3bb3467ff9b94', 'sql; sql', 'redefining some triggers for table RLN_RELATIONHIP and REQUIREMENT_LIBRARY_NODE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.12.3.xml::tm-1.12.3-issue-3-3::bsiri
--  redefining some triggers for table CLN_RELATIONHIP and CAMPAIGN_LIBRARY_NODE
drop trigger if exists ins_cln_after;

create trigger ins_cln_after after insert on
			CAMPAIGN_LIBRARY_NODE
			for each row insert ignore into
			CLN_RELATIONSHIP_CLOSURE values (new.cln_id, new.cln_id, 0);

drop trigger if exists attach_cln_after;

create trigger attach_cln_after after insert on CLN_RELATIONSHIP
			for each row insert ignore into CLN_RELATIONSHIP_CLOSURE
			select
			c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
			from
			CLN_RELATIONSHIP_CLOSURE c1
			cross join CLN_RELATIONSHIP_CLOSURE c2
			where c1.descendant_id = new.ancestor_id
			and c2.ancestor_id = new.descendant_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.12.3-issue-3-3', 'bsiri', 'tm/tm.changelog-1.12.3.xml', NOW(), 329, '8:6a6dc999aafc298928ad7355b260551f', 'sql; sql', 'redefining some triggers for table CLN_RELATIONHIP and CAMPAIGN_LIBRARY_NODE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.13.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 330, '8:13996fdeedbab45a870eeca858068c0f', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5155-1::jsimon
CREATE TABLE BUGTRACKER_PROJECT (BUGTRACKER_PROJECT_ID BIGINT AUTO_INCREMENT NOT NULL, BUGTRACKER_BINDING_ID BIGINT NOT NULL, BUGTRACKER_PROJECT_NAME VARCHAR(255) NULL, BUGTRACKER_PROJECT_ORDER INT NOT NULL, CONSTRAINT PK_BUGTRACKER_PROJECT PRIMARY KEY (BUGTRACKER_PROJECT_ID), CONSTRAINT fk_bugtracker_project_bugtracker_binding FOREIGN KEY (BUGTRACKER_BINDING_ID) REFERENCES BUGTRACKER_BINDING(BUGTRACKER_BINDING_ID)) ENGINE = INNODB;

CREATE INDEX idx_bugtracker_project ON BUGTRACKER_PROJECT(BUGTRACKER_PROJECT_ID);

insert into BUGTRACKER_PROJECT(BUGTRACKER_BINDING_ID,
			BUGTRACKER_PROJECT_NAME, BUGTRACKER_PROJECT_ORDER) select
			BUGTRACKER_BINDING_ID, PROJECT_NAME, 0 from BUGTRACKER_BINDING;

ALTER TABLE BUGTRACKER_BINDING DROP COLUMN PROJECT_NAME;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5155-1', 'jsimon', 'tm/tm.changelog-1.13.0.xml', NOW(), 331, '8:e397bd92c3bdcfc84dfca4fc0b205734', 'createTable tableName=BUGTRACKER_PROJECT; createIndex indexName=idx_bugtracker_project, tableName=BUGTRACKER_PROJECT; sql; dropColumn columnName=PROJECT_NAME, tableName=BUGTRACKER_BINDING', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5162-1::bsiri
--  Now campaigns and iterations have a reference too
ALTER TABLE CAMPAIGN ADD `REFERENCE` VARCHAR(50) DEFAULT '' NULL COMMENT 'a reference lavel for a campaign';

ALTER TABLE ITERATION ADD `REFERENCE` VARCHAR(50) DEFAULT '' NULL COMMENT 'a reference lavel for an iteration';

update ITERATION i
			set reference = (select (ci.iteration_order +
			1) from
			CAMPAIGN_ITERATION ci where ci.iteration_id = i.iteration_id
			);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5162-1', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 332, '8:8e09f2a6da2c3c1149758c74ecadf01f', 'addColumn tableName=CAMPAIGN; addColumn tableName=ITERATION; sql', 'Now campaigns and iterations have a reference too', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-4022-1::jsimon
ALTER TABLE PROJECT ADD ALLOW_TC_MODIF_DURING_EXEC BIT(1) DEFAULT 0 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-4022-1', 'jsimon', 'tm/tm.changelog-1.13.0.xml', NOW(), 333, '8:cba1a6c81e923e30998ae40ded91abe5', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5292-issues::bsiri
--  creating a view that helps querying on all the issues reported in an execution because
--  			querying EXECUTION and EXECUTION_STEP separately is just a pain in the ass.
CREATE VIEW EXECUTION_ISSUES_CLOSURE AS select exec.execution_id, issue.issue_id
			from EXECUTION exec
			inner join ISSUE issue on exec.issue_list_id = issue.issue_list_id
			UNION
			select eesteps.execution_id, issue.issue_id
			from EXECUTION_EXECUTION_STEPS eesteps
			inner join EXECUTION_STEP estep on eesteps.execution_step_id = estep.execution_step_id
			inner join ISSUE issue on estep.issue_list_id = issue.issue_list_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5292-issues', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 334, '8:691090d097e12d381b20397fd41df475', 'createView viewName=EXECUTION_ISSUES_CLOSURE', 'creating a view that helps querying on all the issues reported in an execution because
			querying EXECUTION and EXECUTION_STEP separately is just a pain in the ass.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5375-1::jsimon, bsiri
--  The table CHART_QUERY aggregates 1..* CHART_MEASURE_COLUMN, 1..* CHART_AXIS_COLUMN and 0..* CHART_FILTER
--  			(see these table for more informations). It may be referenced by either a CHART_DEFINITION (as a query),
--  			either a COLUMN_PROTOTYPE (as a subquery).
--  The table CHART_DEFINITION describes the custom charts created by the user. Along with
--  			the informations stored in this table a CHART_DEFINITION refers to a CHART_QUERY,
--  			which aggregates the unit blocks that constitute the data elligible for plotting.
--  This table holds referential data only (users cannot populate it) :
--  			it lists every single columns that can be used in a custom chart.
--  			Here, a column is basically an attribute from an entity. Theses columns
--  			are merely options proposed to the user. Once the user confirmed that he
--  			wants to include a particular column in a custom chart, and in which
--  			context (as a measure, an axis or applying a filter on it), the entries
--  			from this table will be referenced by entries in tables FILTER,
--  			AXIS_COLUMN or MEASURE_COLUMN.
--  
--  			Some columns aren't proper attributes of an entity but rather the result of
--  			an expression. This expression is itself expressed as a CHART_QUERY.
--  			For this reason a COLUMN_PROTOTYPE may point to a CHART_QUERY via a
--  			(nullable) foreign key.
--  
--  			Last, some columns aren't supposed to be available to the user and used
--  			in a chart. The attribute 'BUSINESS' = true indicates that the user is allowed
--  			to use them.
--  The CHART_COLUMN_ROLES precises in which roles a particular CHART_COLUMN_PROTOTYPE can
--  			be used : 'AXIS', 'FILTER' or 'MEASURE'.
--  This table store which columns are the measures the user is interested to see.
--  			They consists of an aggregation operation applied to a CHART_COLUMN_PROTOTYPE.
--  A CHART_FILTER restricts the values a CHART_COLUMN_PROTOTYPE may have for a given chart.
--  			A CHART_FILTER will compare the value of a CHART_COLUMN_PROTOTYPE with one or several
--  			CHART_FILTER_VALUES using a comparison operator.
--  This table holds the values used in a CHART_FILTER.
--  This table holds which CHART_COLUMN_PROTOTYPE are the axes for a given chart.
--  The scope is a particular filter on the data : it restrict the perimeter from which the measured entities can be chosen,
--  			for example from project X and folder Y
CREATE TABLE CHART_QUERY (CHART_QUERY_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', NAME VARCHAR(100) NULL COMMENT 'internal usage, when this CHART_QUERY is a    CHART_COLUMN_PROTOTYPE subquery the name helps identify which one', STRATEGY VARCHAR(20) NULL COMMENT 'says how the query builder should integrate this query    to a main query. Accepts values : MAIN, SUBQUERY or INLINED', JOIN_STYLE VARCHAR(10) NULL COMMENT 'generally indicate whether should use inner join or left join when a    natural join is possible. Possible values : INNER_JOIN or LEFT_JOIN', CONSTRAINT PK_CHART_QUERY PRIMARY KEY (CHART_QUERY_ID)) ENGINE = INNODB;

CREATE TABLE CHART_DEFINITION (CHART_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', USER_ID BIGINT NOT NULL COMMENT 'foreign key to the owner of this chart definition', QUERY_ID BIGINT NOT NULL COMMENT 'foreign key to a CHART_QUERY', NAME VARCHAR(50) NULL COMMENT 'The name of this chart', VISIBILITY VARCHAR(20) NULL COMMENT 'whether this chart is ''PRIVATE'' or ''PUBLIC''', CHART_TYPE VARCHAR(20) NULL COMMENT 'whether this chart is a ''PIE'', ''BAR'' etc', `DESCRIPTION` LONGTEXT NULL COMMENT 'additional informations about this chart', PROJECT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le projet. ', CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, CONSTRAINT PK_CHART_DEFINITION PRIMARY KEY (CHART_ID), CONSTRAINT fk_chart_query FOREIGN KEY (QUERY_ID) REFERENCES CHART_QUERY(CHART_QUERY_ID), CONSTRAINT fk_chart_owner FOREIGN KEY (USER_ID) REFERENCES CORE_USER(PARTY_ID), CONSTRAINT fk_project_chart_definition_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_chart_definition ON CHART_DEFINITION(CHART_ID);

CREATE TABLE CHART_COLUMN_PROTOTYPE (CHART_COLUMN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'the column ID', COLUMN_TYPE VARCHAR(15) NULL COMMENT 'complementary information about the nature of this column : native attribute (''ATTRIBUTE''),     computed field (''CALCULATED'') - often as a subquery -, or custom field (''CUF'')', SUBQUERY_ID BIGINT NULL COMMENT 'optional foreign key to a (sub) CHART_QUERY', LABEL VARCHAR(255) NULL COMMENT 'The default label for this column.', ENTITY_TYPE VARCHAR(30) NULL COMMENT 'The kind of entities this column belongs to', ENTITY_ROLE VARCHAR(40) NULL COMMENT 'a complementary qualifier for ENTITY_TYPE,           used when an entity has an auxialiary role regarding another entity.           For instance an InfoListItem may have a role of nature for a TestCase,           or category for a RequirementVersion. May be null if nothing special about it.', ATTRIBUTE_NAME VARCHAR(255) NULL COMMENT 'The name of the attribute of the entity', DATA_TYPE VARCHAR(50) NULL COMMENT 'Data type of the attribute', BUSINESS BIT(1) DEFAULT 1 NULL COMMENT 'tells whether this column is public or internal.', ATTRIBUTE_TYPE VARCHAR(15) NULL COMMENT 'complementary information about the nature of this column : native attribute (''ATTRIBUTE''),     computed field (''CALCULATED'') - often as a subquery -, or custom field (''CUF'')', CONSTRAINT PK_CHART_COLUMN_PROTOTYPE PRIMARY KEY (CHART_COLUMN_ID), CONSTRAINT fk_column_query FOREIGN KEY (SUBQUERY_ID) REFERENCES CHART_QUERY(CHART_QUERY_ID)) ENGINE = INNODB;

CREATE INDEX idx_column_prototype ON CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID);

CREATE TABLE CHART_COLUMN_ROLE (CHART_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to CHART_COLUMN_PROTOTYPE', `ROLE` VARCHAR(255) NULL COMMENT 'name of a role for the referenced column', CONSTRAINT fk_column_role_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID)) ENGINE = INNODB;

CREATE TABLE CHART_MEASURE_COLUMN (CHART_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to the CHART_COLUMN_PROTOTYPE this measure applies to', QUERY_ID BIGINT NOT NULL COMMENT 'foreign key to a CHART_QUERY', LABEL VARCHAR(30) NULL COMMENT 'a label for this measure. Will override the default label of the column prototype if non null.', MEASURE_OPERATION VARCHAR(20) NULL COMMENT 'the measure applied to the column', MEASURE_RANK INT NULL COMMENT 'the order in which the measure will be displayed when the chart is rendered.', CONSTRAINT fk_chart_measure_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID), CONSTRAINT fk_chart_measure_chart_query FOREIGN KEY (QUERY_ID) REFERENCES CHART_QUERY(CHART_QUERY_ID)) ENGINE = INNODB;

CREATE TABLE CHART_FILTER (FILTER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', CHART_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to a CHART_COLUMN_PROTOTYPE', QUERY_ID BIGINT NOT NULL COMMENT 'foreign key to a CHART_QUERY', FILTER_OPERATION VARCHAR(20) NULL COMMENT 'a comparison operator', CONSTRAINT PK_CHART_FILTER PRIMARY KEY (FILTER_ID), CONSTRAINT fk_chart_filter_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID), CONSTRAINT fk_chart_FILTER_chart_query FOREIGN KEY (QUERY_ID) REFERENCES CHART_QUERY(CHART_QUERY_ID)) ENGINE = INNODB;

CREATE INDEX idx_chart_filter ON CHART_FILTER(FILTER_ID);

CREATE TABLE CHART_FILTER_VALUES (FILTER_ID BIGINT NOT NULL COMMENT 'foreign key to CHART_FILTER', FILTER_VALUE VARCHAR(255) NULL COMMENT 'a value for this filter', CONSTRAINT fk_chart_filter_value_chart_column FOREIGN KEY (FILTER_ID) REFERENCES CHART_FILTER(FILTER_ID)) ENGINE = INNODB;

CREATE TABLE CHART_AXIS_COLUMN (CHART_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to CHART_COLUMN_PROTOTYPE', QUERY_ID BIGINT NOT NULL COMMENT 'foreign key to a CHART_QUERY', LABEL VARCHAR(100) NULL COMMENT 'a label for this axis. If non null, will override the default label in the CHART_COLUMN_PROTOTYPE', AXIS_OPERATION VARCHAR(20) NULL COMMENT 'may define an additional operation about how data are grouped on this axis, most of the time ''NONE'' is fine, however     for Timestamp columns an adequate aggregation (day, month etc) may be useful', AXIS_RANK INT NULL COMMENT 'in which order the axis are processed (if relevant)', CONSTRAINT fk_axis_column_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID), CONSTRAINT fk_chart_axis_chart_query FOREIGN KEY (QUERY_ID) REFERENCES CHART_QUERY(CHART_QUERY_ID)) ENGINE = INNODB;

CREATE TABLE CHART_SCOPE (CHART_ID BIGINT NOT NULL COMMENT 'foreign key to a CHART_DEFINITION', ENTITY_REFERENCE_TYPE VARCHAR(50) NULL COMMENT 'the type of the referenced entity', ENTITY_REFERENCE_ID INT NULL COMMENT 'the id of the referenced entity', CONSTRAINT fk_chart_scope_chart_definition FOREIGN KEY (CHART_ID) REFERENCES CHART_DEFINITION(CHART_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5375-1', 'jsimon, bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 335, '8:0c44a4f407fc0b126fdafe12412717f1', 'createTable tableName=CHART_QUERY; createTable tableName=CHART_DEFINITION; createIndex indexName=idx_chart_definition, tableName=CHART_DEFINITION; createTable tableName=CHART_COLUMN_PROTOTYPE; createIndex indexName=idx_column_prototype, tableName=...', 'The table CHART_QUERY aggregates 1..* CHART_MEASURE_COLUMN, 1..* CHART_AXIS_COLUMN and 0..* CHART_FILTER
			(see these table for more informations). It may be referenced by either a CHART_DEFINITION (as a query),
			either a COLUMN_PROTOTYPE (as a...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5375-2::bsiri
--  populate the column prototype referential data (generated from src/main/script/MakeChartColumns.groovy)
-- --------------------------------------------
		-- Chart Column Prototype Definition --
		--
		-- generated by src/main/script/MakeChartColumns.groovy
		-- --------------------------------------------

		-- -------------------------------------------
		-- section 1 :  basic attribute columns
		-- -------------------------------------------


		-- columns for entity : REQUIREMENT --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(1, 'ATTRIBUTE', TRUE, 'REQUIREMENT_ID', 'REQUIREMENT', null, 'NUMERIC', 'id', null),
			(3, 'ATTRIBUTE', FALSE, 'REQUIREMENT_PROJECT', 'REQUIREMENT', null, 'NUMERIC', 'project.id', null),
			(4, 'ATTRIBUTE', TRUE, 'REQUIREMENT_CRITICALITY', 'REQUIREMENT', null, 'LEVEL_ENUM', 'resource.criticality', null),
			(5, 'ATTRIBUTE', TRUE, 'REQUIREMENT_STATUS', 'REQUIREMENT', null, 'LEVEL_ENUM', 'resource.status', null),
			(6, 'ATTRIBUTE', TRUE, 'REQUIREMENT_CATEGORY', 'REQUIREMENT', null, 'INFO_LIST_ITEM', 'resource.category.code', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (1, 'MEASURE'), (1, 'AXIS'), (1, 'FILTER'),
			 (4, 'MEASURE'), (4, 'AXIS'), (4, 'FILTER'),
			 (5, 'MEASURE'), (5, 'AXIS'), (5, 'FILTER'),
			 (6, 'MEASURE'), (6, 'AXIS'), (6, 'FILTER');

-- columns for entity : REQUIREMENT_VERSION --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(7, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_ID', 'REQUIREMENT_VERSION', null, 'NUMERIC', 'id', null),
			(8, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_REFERENCE', 'REQUIREMENT_VERSION', null, 'STRING', 'reference', null),
			(9, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_CATEGORY', 'REQUIREMENT_VERSION', null, 'INFO_LIST_ITEM', 'category.code', null),
			(10, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_CRITICALITY', 'REQUIREMENT_VERSION', null, 'LEVEL_ENUM', 'criticality', null),
			(11, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_STATUS', 'REQUIREMENT_VERSION', null, 'LEVEL_ENUM', 'status', null),
			(12, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_CREATED_BY', 'REQUIREMENT_VERSION', null, 'STRING', 'audit.createdBy', null),
			(13, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_CREATED_ON', 'REQUIREMENT_VERSION', null, 'DATE', 'audit.createdOn', null),
			(14, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_MODIFIED_BY', 'REQUIREMENT_VERSION', null, 'STRING', 'audit.lastModifiedBy', null),
			(15, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_MODIFIED_ON', 'REQUIREMENT_VERSION', null, 'DATE', 'audit.lastModifiedOn', null),
			(16, 'ATTRIBUTE', TRUE, 'REQUIREMENT_VERSION_VERS_NUM', 'REQUIREMENT_VERSION', null, 'NUMERIC', 'versionNumber', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (7, 'MEASURE'), (7, 'AXIS'), (7, 'FILTER'),
			 (8, 'FILTER'), (8, 'AXIS'),
			 (9, 'MEASURE'), (9, 'AXIS'), (9, 'FILTER'),
			 (10, 'MEASURE'), (10, 'AXIS'), (10, 'FILTER'),
			 (11, 'MEASURE'), (11, 'AXIS'), (11, 'FILTER'),
			 (12, 'AXIS'), (12, 'FILTER'),
			 (13, 'AXIS'), (13, 'FILTER'),
			 (14, 'AXIS'), (14, 'FILTER'),
			 (15, 'AXIS'), (15, 'FILTER'),
			 (16, 'FILTER'), (16, 'MEASURE');

-- columns for entity : TEST_CASE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(19, 'ATTRIBUTE', TRUE, 'TEST_CASE_ID', 'TEST_CASE', null, 'NUMERIC', 'id', null),
			(20, 'ATTRIBUTE', TRUE, 'TEST_CASE_REFERENCE', 'TEST_CASE', null, 'STRING', 'reference', null),
			(21, 'ATTRIBUTE', TRUE, 'TEST_CASE_IMPORTANCE', 'TEST_CASE', null, 'LEVEL_ENUM', 'importance', null),
			(22, 'ATTRIBUTE', TRUE, 'TEST_CASE_NATURE', 'TEST_CASE', null, 'INFO_LIST_ITEM', 'nature.code', null),
			(23, 'ATTRIBUTE', TRUE, 'TEST_CASE_TYPE', 'TEST_CASE', null, 'INFO_LIST_ITEM', 'type.code', null),
			(24, 'ATTRIBUTE', TRUE, 'TEST_CASE_STATUS', 'TEST_CASE', null, 'LEVEL_ENUM', 'status', null),
			(25, 'ATTRIBUTE', TRUE, 'TEST_CASE_CREATED_BY', 'TEST_CASE', null, 'STRING', 'audit.createdBy', null),
			(26, 'ATTRIBUTE', TRUE, 'TEST_CASE_CREATED_ON', 'TEST_CASE', null, 'DATE', 'audit.createdOn', null),
			(27, 'ATTRIBUTE', TRUE, 'TEST_CASE_MODIFIED_BY', 'TEST_CASE', null, 'STRING', 'audit.lastModifiedBy', null),
			(28, 'ATTRIBUTE', TRUE, 'TEST_CASE_MODIFIED_ON', 'TEST_CASE', null, 'DATE', 'audit.lastModifiedOn', null),
			(29, 'ATTRIBUTE', FALSE, 'TEST_CASE_PROJECT', 'TEST_CASE', null, 'NUMERIC', 'project.id', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (19, 'MEASURE'), (19, 'AXIS'), (19, 'FILTER'),
			 (20, 'FILTER'), (20, 'AXIS'),
			 (21, 'MEASURE'), (21, 'AXIS'), (21, 'FILTER'),
			 (22, 'MEASURE'), (22, 'AXIS'), (22, 'FILTER'),
			 (23, 'MEASURE'), (23, 'AXIS'), (23, 'FILTER'),
			 (24, 'MEASURE'), (24, 'AXIS'), (24, 'FILTER'),
			 (25, 'AXIS'), (25, 'FILTER'),
			 (26, 'AXIS'), (26, 'FILTER'),
			 (27, 'AXIS'), (27, 'FILTER'),
			 (28, 'AXIS'), (28, 'FILTER');

-- columns for entity : CAMPAIGN --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(37, 'ATTRIBUTE', TRUE, 'CAMPAIGN_ID', 'CAMPAIGN', null, 'NUMERIC', 'id', null),
			(38, 'ATTRIBUTE', FALSE, 'CAMPAIGN_PROJECT', 'CAMPAIGN', null, 'NUMERIC', 'project.id', null),
			(39, 'ATTRIBUTE', TRUE, 'CAMPAIGN_REFERENCE', 'CAMPAIGN', null, 'STRING', 'reference', null),
			(40, 'ATTRIBUTE', TRUE, 'CAMPAIGN_SCHED_START', 'CAMPAIGN', null, 'DATE', 'scheduledPeriod.scheduledStartDate', null),
			(41, 'ATTRIBUTE', TRUE, 'CAMPAIGN_SCHED_END', 'CAMPAIGN', null, 'DATE', 'scheduledPeriod.scheduledEndDate', null),
			(42, 'ATTRIBUTE', TRUE, 'CAMPAIGN_ACTUAL_START', 'CAMPAIGN', null, 'DATE', 'actualPeriod.actualStartDate', null),
			(43, 'ATTRIBUTE', TRUE, 'CAMPAIGN_ACTUAL_END', 'CAMPAIGN', null, 'DATE', 'actualPeriod.actualEndDate', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (37, 'MEASURE'), (37, 'AXIS'), (37, 'FILTER'),
			 (39, 'FILTER'), (39, 'MEASURE'),
			 (40, 'AXIS'), (40, 'FILTER'),
			 (41, 'AXIS'), (41, 'FILTER'),
			 (42, 'AXIS'), (42, 'FILTER'),
			 (43, 'AXIS'), (43, 'FILTER');

-- columns for entity : ITERATION --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(46, 'ATTRIBUTE', TRUE, 'ITERATION_ID', 'ITERATION', null, 'NUMERIC', 'id', null),
			(47, 'ATTRIBUTE', TRUE, 'ITERATION_REFERENCE', 'ITERATION', null, 'STRING', 'reference', null),
			(48, 'ATTRIBUTE', TRUE, 'ITERATION_SCHED_START', 'ITERATION', null, 'DATE', 'scheduledPeriod.scheduledStartDate', null),
			(49, 'ATTRIBUTE', TRUE, 'ITERATION_SCHED_END', 'ITERATION', null, 'DATE', 'scheduledPeriod.scheduledEndDate', null),
			(50, 'ATTRIBUTE', TRUE, 'ITERATION_ACTUAL_START', 'ITERATION', null, 'DATE', 'actualPeriod.actualStartDate', null),
			(51, 'ATTRIBUTE', TRUE, 'ITERATION_ACTUAL_END', 'ITERATION', null, 'DATE', 'actualPeriod.actualEndDate', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (46, 'MEASURE'), (46, 'AXIS'), (46, 'FILTER'),
			 (47, 'FILTER'), (47, 'MEASURE'),
			 (48, 'AXIS'), (48, 'FILTER'),
			 (49, 'AXIS'), (49, 'FILTER'),
			 (50, 'AXIS'), (50, 'FILTER'),
			 (51, 'AXIS'), (51, 'FILTER');

-- columns for entity : ITEM_TEST_PLAN --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(54, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_ID', 'ITEM_TEST_PLAN', null, 'NUMERIC', 'id', null),
			(55, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_LABEL', 'ITEM_TEST_PLAN', null, 'STRING', 'label', null),
			(56, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_STATUS', 'ITEM_TEST_PLAN', null, 'EXECUTION_STATUS', 'executionStatus', null),
			(57, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_LASTEXECON', 'ITEM_TEST_PLAN', null, 'DATE', 'lastExecutedOn', null),
			(58, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_DATASET_LABEL', 'ITEM_TEST_PLAN', null, 'STRING', 'referencedDataset.name', null),
			(59, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_TESTER', 'ITEM_TEST_PLAN', null, 'STRING', 'user.login', null),
			(60, 'ATTRIBUTE', TRUE, 'ITEM_TEST_PLAN_TC_ID', 'ITEM_TEST_PLAN', null, 'NUMERIC', 'referencedTestCase.id', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (54, 'MEASURE'), (54, 'AXIS'), (54, 'FILTER'),
			 (55, 'MEASURE'), (55, 'AXIS'), (55, 'FILTER'),
			 (56, 'MEASURE'), (56, 'AXIS'), (56, 'FILTER'),
			 (57, 'MEASURE'), (57, 'AXIS'), (57, 'FILTER'),
			 (58, 'MEASURE'), (58, 'AXIS'), (58, 'FILTER'),
			 (59, 'MEASURE'), (59, 'AXIS'), (59, 'FILTER'),
			 (60, 'MEASURE'), (60, 'AXIS'), (60, 'FILTER');

-- columns for entity : EXECUTION --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(66, 'ATTRIBUTE', TRUE, 'EXECUTION_ID', 'EXECUTION', null, 'NUMERIC', 'id', null),
			(67, 'ATTRIBUTE', TRUE, 'EXECUTION_LABEL', 'EXECUTION', null, 'STRING', 'name', null),
			(68, 'ATTRIBUTE', TRUE, 'EXECUTION_DS_LABEL', 'EXECUTION', null, 'STRING', 'datasetLabel', null),
			(69, 'ATTRIBUTE', TRUE, 'EXECUTION_LASTEXEC', 'EXECUTION', null, 'DATE', 'lastExecutedOn', null),
			(70, 'ATTRIBUTE', TRUE, 'EXECUTION_TESTER_LOGIN', 'EXECUTION', null, 'STRING', 'lastExecutedBy', null),
			(71, 'ATTRIBUTE', TRUE, 'EXECUTION_STATUS', 'EXECUTION', null, 'EXECUTION_STATUS', 'executionStatus', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (66, 'MEASURE'), (66, 'AXIS'), (66, 'FILTER'),
			 (67, 'AXIS'), (67, 'FILTER'),
			 (68, 'AXIS'), (68, 'FILTER'),
			 (69, 'AXIS'), (69, 'FILTER'),
			 (70, 'AXIS'), (70, 'FILTER'),
			 (71, 'MEASURE'), (71, 'AXIS'), (71, 'FILTER');

-- columns for entity : ISSUE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(74, 'ATTRIBUTE', FALSE, 'ISSUE_ID', 'ISSUE', null, 'NUMERIC', 'id', null),
			(75, 'ATTRIBUTE', FALSE, 'ISSUE_REMOTE_ID', 'ISSUE', null, 'STRING', 'remoteIssueId', null),
			(76, 'ATTRIBUTE', FALSE, 'ISSUE_STATUS', 'ISSUE', null, 'STRING', 'status', null),
			(77, 'ATTRIBUTE', FALSE, 'ISSUE_SEVERITY', 'ISSUE', null, 'STRING', 'severity', null),
			(78, 'ATTRIBUTE', FALSE, 'ISSUE_BUGTRACKER', 'ISSUE', null, 'STRING', 'bugtracker', null);

-- columns for entity : TEST_CASE_STEP --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(79, 'ATTRIBUTE', FALSE, 'TEST_CASE_STEP_ID', 'TEST_CASE_STEP', null, 'NUMERIC', 'id', null),
			(80, 'ATTRIBUTE', FALSE, 'TEST_CASE_STEP_CLASS', 'TEST_CASE_STEP', null, 'NUMERIC', 'class', null);

-- columns for entity : TEST_CASE_NATURE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(81, 'ATTRIBUTE', FALSE, 'TEST_CASE_NATURE_ID', 'INFO_LIST_ITEM', 'TEST_CASE_NATURE', 'NUMERIC', 'id', null),
			(82, 'ATTRIBUTE', FALSE, 'TEST_CASE_NATURE_LABEL', 'INFO_LIST_ITEM', 'TEST_CASE_NATURE', 'STRING', 'label', null);

-- columns for entity : TEST_CASE_TYPE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(83, 'ATTRIBUTE', FALSE, 'TEST_CASE_TYPE_ID', 'INFO_LIST_ITEM', 'TEST_CASE_TYPE', 'NUMERIC', 'id', null),
			(84, 'ATTRIBUTE', FALSE, 'TEST_CASE_TYPE_LABEL', 'INFO_LIST_ITEM', 'TEST_CASE_TYPE', 'STRING', 'label', null);

-- columns for entity : REQUIREMENT_VERSION_CATEGORY --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(85, 'ATTRIBUTE', FALSE, 'REQUIREMENT_VERSION_CATEGORY_ID', 'INFO_LIST_ITEM', 'REQUIREMENT_VERSION_CATEGORY', 'NUMERIC', 'id', null),
			(86, 'ATTRIBUTE', FALSE, 'REQUIREMENT_VERSION_CATEGORY_LABEL', 'INFO_LIST_ITEM', 'REQUIREMENT_VERSION_CATEGORY', 'STRING', 'label', null);

-- columns for entity : TEST_CASE_MILESTONE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(87, 'ATTRIBUTE', FALSE, 'TEST_CASE_MILESTONE_ID', 'MILESTONE', 'TEST_CASE_MILESTONE', 'NUMERIC', 'id', null),
			(88, 'ATTRIBUTE', FALSE, 'TEST_CASE_MILESTONE_LABEL', 'MILESTONE', 'TEST_CASE_MILESTONE', 'STRING', 'label', null);

-- columns for entity : REQUIREMENT_VERSION_MILESTONE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(89, 'ATTRIBUTE', FALSE, 'REQUIREMENT_VERSION_MILESTONE_ID', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'NUMERIC', 'id', null),
			(90, 'ATTRIBUTE', FALSE, 'REQUIREMENT_VERSION_MILESTONE_LABEL', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'STRING', 'label', null);

-- columns for entity : ITERATION_TEST_PLAN_ASSIGNED_USER --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(91, 'ATTRIBUTE', FALSE, 'ITERATION_TEST_PLAN_ASSIGNED_USER_ID', 'USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER', 'NUMERIC', 'id', null),
			(92, 'ATTRIBUTE', FALSE, 'ITERATION_TEST_PLAN_ASSIGNED_USER_LOGIN', 'USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER', 'STRING', 'login', null);

-- columns for entity : AUTOMATED_TEST --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(93, 'ATTRIBUTE', FALSE, 'AUTOMATED_TEST_ID', 'AUTOMATED_TEST', null, 'NUMERIC', 'id', null);

-- columns for entity : AUTOMATED_EXECUTION_EXTENDER --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(94, 'ATTRIBUTE', FALSE, 'AUTOMATED_EXECUTION_EXTENDER_ID', 'AUTOMATED_EXECUTION_EXTENDER', null, 'NUMERIC', 'id', null);

-- -------------------------------------------
		-- section 2 :  subqueries
		-- -------------------------------------------

		-- subqueries for entity REQUIREMENT --

		-- subquery reqVCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (1, 'REQUIREMENT_NB_VERSIONS_SUBQUERY', 'SUBQUERY', 'INNER_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (7, 1, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (1, 1, 'NONE', 0);

-- subqueries for entity REQUIREMENT_VERSION --

		-- subquery rvVerifTCCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (2, 'REQUIREMENT_VERSION_TCCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (19, 2, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (7, 2, 'NONE', 0);

-- subquery rvMilesCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (3, 'REQUIREMENT_VERSION_MILCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (89, 3, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (7, 3, 'NONE', 0);

-- subqueries for entity TEST_CASE --

		-- subquery tcVerifVersionCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (4, 'TEST_CASE_VERSCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (7, 4, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 4, 'NONE', 0);

-- subquery tcCallStepsCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (5, 'TEST_CASE_CALLSTEPCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (79, 5, 'COUNT', 0);

insert into CHART_FILTER(FILTER_ID, CHART_COLUMN_ID, QUERY_ID, FILTER_OPERATION) values (1, 80, 5, 'EQUALS');

insert into CHART_FILTER_VALUES(FILTER_ID, FILTER_VALUE)
		values
			(1,'2');

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 5, 'NONE', 0);

-- subquery tcStepsCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (6, 'TEST_CASE_STEPCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (79, 6, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 6, 'NONE', 0);

-- subquery tcMilesCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (7, 'TEST_CASE_VERSION_MILCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (87, 7, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 7, 'NONE', 0);

-- subquery tcIterCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (8, 'TEST_CASE_ITERCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (46, 8, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 8, 'NONE', 0);

-- subquery tcExeCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (9, 'TEST_CASE_EXECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (66, 9, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 9, 'NONE', 0);

-- subquery tcHasAutoSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (10, 'TEST_CASE_HASAUTOSCRIPT_SUBQUERY', 'INLINED', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (93, 10, 'NOT_NULL', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (19, 10, 'NONE', 0);

-- subqueries for entity CAMPAIGN --

		-- subquery cIterCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (11, 'CAMPAIGN_ITERCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (46, 11, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (37, 11, 'NONE', 0);

-- subquery cIssueCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (12, 'CAMPAIGN_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (75, 12, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (37, 12, 'NONE', 0);

-- subqueries for entity ITERATION --

		-- subquery itItemCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (13, 'ITERATION_ITEMCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (54, 13, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (46, 13, 'NONE', 0);

-- subquery itIssueCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (14, 'ITERATION_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (75, 14, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (46, 14, 'NONE', 0);

-- subqueries for entity ITEM_TEST_PLAN --

		-- subquery itpTcDeletedSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (15, 'ITEM_TEST_PLAN_TCDELETED_SUBQUERY', 'INLINED', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (19, 15, 'IS_NULL', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (54, 15, 'NONE', 0);

-- subquery itpIsExecutedSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (16, 'ITEM_TEST_PLAN_ISEXECUTED_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (66, 16, 'NOT_NULL', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (54, 16, 'NONE', 0);

-- subquery itpManExCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (17, 'ITEM_TEST_PLAN_MANEXCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (66, 17, 'COUNT', 0);

insert into CHART_FILTER(FILTER_ID, CHART_COLUMN_ID, QUERY_ID, FILTER_OPERATION) values (2, 94, 17, 'NOT_NULL');

insert into CHART_FILTER_VALUES(FILTER_ID, FILTER_VALUE)
		values
			(2,'FALSE');

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (54, 17, 'NONE', 0);

-- subquery itpAutoExCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (18, 'ITEM_TEST_PLAN_AUTOEXCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (66, 18, 'COUNT', 0);

insert into CHART_FILTER(FILTER_ID, CHART_COLUMN_ID, QUERY_ID, FILTER_OPERATION) values (3, 94, 18, 'NOT_NULL');

insert into CHART_FILTER_VALUES(FILTER_ID, FILTER_VALUE)
		values
			(3,'TRUE');

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (54, 18, 'NONE', 0);

-- subquery itpIssueCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (19, 'ITEM_TEST_PLAN_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (75, 19, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (54, 19, 'NONE', 0);

-- subqueries for entity EXECUTION --

		-- subquery exIsAutoSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (20, 'EXECUTION_ISAUTO_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (94, 20, 'NOT_NULL', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (66, 20, 'NONE', 0);

-- subquery exIssueCountSub --

		insert into CHART_QUERY(CHART_QUERY_ID, NAME, STRATEGY, JOIN_STYLE) values (21, 'EXECUTION_ISSUECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

insert into CHART_MEASURE_COLUMN(CHART_COLUMN_ID, QUERY_ID, MEASURE_OPERATION, MEASURE_RANK) values (75, 21, 'COUNT', 0);

insert into CHART_AXIS_COLUMN(CHART_COLUMN_ID, QUERY_ID, AXIS_OPERATION, AXIS_RANK)  values (66, 21, 'NONE', 0);

-- subqueries for entity ISSUE --

		-- subqueries for entity TEST_CASE_STEP --

		-- subqueries for entity TEST_CASE_NATURE --

		-- subqueries for entity TEST_CASE_TYPE --

		-- subqueries for entity REQUIREMENT_VERSION_CATEGORY --

		-- subqueries for entity TEST_CASE_MILESTONE --

		-- subqueries for entity REQUIREMENT_VERSION_MILESTONE --

		-- subqueries for entity ITERATION_TEST_PLAN_ASSIGNED_USER --

		-- subqueries for entity AUTOMATED_TEST --

		-- subqueries for entity AUTOMATED_EXECUTION_EXTENDER --


		-- -------------------------------------------
		-- section 3 :  calculated columns
		-- -------------------------------------------


		-- columns for entity : REQUIREMENT --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(2, 'CALCULATED', TRUE, 'REQUIREMENT_NB_VERSIONS', 'REQUIREMENT', null, 'NUMERIC', 'count(requirementVersionCoverages)', 1);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (2, 'MEASURE'), (2, 'AXIS'), (2, 'FILTER');

-- columns for entity : REQUIREMENT_VERSION --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(17, 'CALCULATED', TRUE, 'REQUIREMENT_VERSION_TCCOUNT', 'REQUIREMENT_VERSION', null, 'NUMERIC', 'count(requirementVersionCoverages)', 2),
			(18, 'CALCULATED', TRUE, 'REQUIREMENT_VERSION_MILCOUNT', 'REQUIREMENT_VERSION', null, 'NUMERIC', 'count(milestones)', 3);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (17, 'MEASURE'), (17, 'AXIS'), (17, 'FILTER'),
			 (18, 'MEASURE'), (18, 'AXIS'), (18, 'FILTER');

-- columns for entity : TEST_CASE --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(30, 'CALCULATED', TRUE, 'TEST_CASE_VERSCOUNT', 'TEST_CASE', null, 'NUMERIC', 'count(requirementVersionCoverages)', 4),
			(31, 'CALCULATED', TRUE, 'TEST_CASE_CALLSTEPCOUNT', 'TEST_CASE', null, 'NUMERIC', 'count(steps[class="CallTestStep"])', 5),
			(32, 'CALCULATED', TRUE, 'TEST_CASE_STEPCOUNT', 'TEST_CASE', null, 'NUMERIC', 'count(steps)', 6),
			(33, 'CALCULATED', TRUE, 'TEST_CASE_MILCOUNT', 'TEST_CASE', null, 'NUMERIC', 'count(milestones)', 7),
			(34, 'CALCULATED', TRUE, 'TEST_CASE_ITERCOUNT', 'TEST_CASE', null, 'NUMERIC', 'count(iterations)', 8),
			(35, 'CALCULATED', TRUE, 'TEST_CASE_EXECOUNT', 'TEST_CASE', null, 'NUMERIC', 'count(executions)', 9),
			(36, 'CALCULATED', TRUE, 'TEST_CASE_HASAUTOSCRIPT', 'TEST_CASE', null, 'BOOLEAN', 'notnull(automatedTest)', 10);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (30, 'MEASURE'), (30, 'AXIS'), (30, 'FILTER'),
			 (31, 'MEASURE'), (31, 'AXIS'), (31, 'FILTER'),
			 (32, 'MEASURE'), (32, 'AXIS'), (32, 'FILTER'),
			 (33, 'MEASURE'), (33, 'AXIS'), (33, 'FILTER'),
			 (34, 'MEASURE'), (34, 'AXIS'), (34, 'FILTER'),
			 (35, 'MEASURE'), (35, 'AXIS'), (35, 'FILTER'),
			 (36, 'MEASURE'), (36, 'AXIS'), (36, 'FILTER');

-- columns for entity : CAMPAIGN --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(44, 'CALCULATED', TRUE, 'CAMPAIGN_ITERCOUNT', 'CAMPAIGN', null, 'NUMERIC', 'count(iterations)', 11),
			(45, 'CALCULATED', TRUE, 'CAMPAIGN_ISSUECOUNT', 'CAMPAIGN', null, 'NUMERIC', 'count(issues)', 12);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (44, 'MEASURE'), (44, 'AXIS'), (44, 'FILTER'),
			 (45, 'MEASURE'), (45, 'AXIS'), (45, 'FILTER');

-- columns for entity : ITERATION --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(52, 'CALCULATED', TRUE, 'ITERATION_ITEMCOUNT', 'ITERATION', null, 'NUMERIC', 'count(testPlans)', 13),
			(53, 'CALCULATED', TRUE, 'ITERATION_ISSUECOUNT', 'ITERATION', null, 'NUMERIC', 'count(issues)', 14);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (52, 'MEASURE'), (52, 'AXIS'), (52, 'FILTER'),
			 (53, 'MEASURE'), (53, 'AXIS'), (53, 'FILTER');

-- columns for entity : ITEM_TEST_PLAN --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(61, 'CALCULATED', TRUE, 'ITEM_TEST_PLAN_TC_DELETED', 'ITEM_TEST_PLAN', null, 'BOOLEAN', 'isnull(referencedTestCase)', 15),
			(62, 'CALCULATED', TRUE, 'ITEM_TEST_PLAN_IS_EXECUTED', 'ITEM_TEST_PLAN', null, 'BOOLEAN', 'notnull(executions)', 16),
			(63, 'CALCULATED', TRUE, 'ITEM_TEST_PLAN_MANEXCOUNT', 'ITEM_TEST_PLAN', null, 'NUMERIC', 'count(executions[auto="false"])', 17),
			(64, 'CALCULATED', TRUE, 'ITEM_TEST_PLAN_AUTOEXCOUNT', 'ITEM_TEST_PLAN', null, 'NUMERIC', 'count(executions[auto="true"])', 18),
			(65, 'CALCULATED', TRUE, 'ITEM_TEST_PLAN_ISSUECOUNT', 'ITEM_TEST_PLAN', null, 'NUMERIC', 'count(issues)', 19);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (61, 'MEASURE'), (61, 'AXIS'), (61, 'FILTER'),
			 (62, 'MEASURE'), (62, 'AXIS'), (62, 'FILTER'),
			 (63, 'MEASURE'), (63, 'AXIS'), (63, 'FILTER'),
			 (64, 'MEASURE'), (64, 'AXIS'), (64, 'FILTER'),
			 (65, 'MEASURE'), (65, 'AXIS'), (65, 'FILTER');

-- columns for entity : EXECUTION --

		insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID, COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
		values
			(72, 'CALCULATED', TRUE, 'EXECUTION_ISAUTO', 'EXECUTION', null, 'BOOLEAN', 'notnull(automatedExecutionExtender)', 20),
			(73, 'CALCULATED', TRUE, 'EXECUTION_ISSUECOUNT', 'EXECUTION', null, 'NUMERIC', 'count(issues)', 21);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
		values
			 (72, 'FILTER'),
			 (73, 'MEASURE'), (73, 'AXIS'), (73, 'FILTER');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5375-2', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 336, '8:5e79060c1b57a7082052eb0a99d2b68d', 'sql', 'populate the column prototype referential data (generated from src/main/script/MakeChartColumns.groovy)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5292-1::jthebault
--  This table contains the relations between two custom reports nodes. If a node is root, parent id will be null and descendant id will be itself.
--  		a given node can be referenced as descendant only one time so we can map the join with hibernate
--  closure table for custom report library nodes. Its content is set and modified by four triggers
CREATE TABLE CUSTOM_REPORT_LIBRARY (CRL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'pk genere', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'FK to ATTACHMENT_LIST', CONSTRAINT PK_CUSTOM_REPORT_LIBRARY PRIMARY KEY (CRL_ID)) ENGINE = INNODB;

CREATE INDEX IDX_CUSTOM_REPORT_LIBRARY ON CUSTOM_REPORT_LIBRARY(CRL_ID);

CREATE TABLE CUSTOM_REPORT_LIBRARY_NODE (CRLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'pk genere', NAME VARCHAR(255) NULL, ENTITY_TYPE VARCHAR(50) NULL, ENTITY_ID BIGINT NULL, CRL_ID BIGINT NULL COMMENT 'fk to the containing CUSTOM_REPORT_LIBRARY', CONSTRAINT PK_CUSTOM_REPORT_LIBRARY_NODE PRIMARY KEY (CRLN_ID), CONSTRAINT fk_crln_custom_report_library_crl_id FOREIGN KEY (CRL_ID) REFERENCES CUSTOM_REPORT_LIBRARY(CRL_ID)) ENGINE = INNODB;

CREATE TABLE CRLN_RELATIONSHIP (ANCESTOR_ID BIGINT NULL COMMENT 'cle etrangere vers le noeud parent', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. ', CONTENT_ORDER BIGINT NULL COMMENT 'numéro d''ordre du noeud dans son parent', CONSTRAINT fk_crln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES CUSTOM_REPORT_LIBRARY_NODE(CRLN_ID), CONSTRAINT fk_crln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES CUSTOM_REPORT_LIBRARY_NODE(CRLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_crln_relationship_descendant ON CRLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX idx_crln_relationship_ancestor ON CRLN_RELATIONSHIP(ANCESTOR_ID);

CREATE TABLE CUSTOM_REPORT_FOLDER (CRF_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'pk genere', NAME VARCHAR(255) NULL, `DESCRIPTION` LONGTEXT NULL, PROJECT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le projet. ', CONSTRAINT PK_CRF_ID PRIMARY KEY (CRF_ID), CONSTRAINT fk_project_custom_report_folder_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE TABLE CUSTOM_REPORT_DASHBOARD (CRD_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'pk genere', NAME VARCHAR(255) NULL, PROJECT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le projet. ', CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, CONSTRAINT PK_CRD_ID PRIMARY KEY (CRD_ID), CONSTRAINT fk_project_custom_report_dashboard_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE TABLE CUSTOM_REPORT_CHART_BINDING (CRCB_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'pk genere', CRD_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le dashboard. ', CHART_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le chart. ', ROW INT NULL, COL INT NULL, SIZE_X INT NULL, SIZE_Y INT NULL, CONSTRAINT PK_CRCB_ID PRIMARY KEY (CRCB_ID), CONSTRAINT fk_chart_bindind_custom_report_dashboard_crd_id FOREIGN KEY (CRD_ID) REFERENCES CUSTOM_REPORT_DASHBOARD(CRD_ID), CONSTRAINT fk_chart_bindind_chart_definition_chart_id FOREIGN KEY (CHART_ID) REFERENCES CHART_DEFINITION(CHART_ID)) ENGINE = INNODB;

ALTER TABLE PROJECT ADD CRL_ID BIGINT NULL COMMENT 'FK FOR CUSTOM_REPORT_LIBRARY.CRL_ID';

ALTER TABLE ATTACHMENT_LIST ADD TMP_CRL_ID BIGINT NULL COMMENT 'TMP FK FOR CUSTOM_REPORT_LIBRARY.CRL_ID';

CREATE TABLE CRLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_crln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES CUSTOM_REPORT_LIBRARY_NODE(CRLN_ID), CONSTRAINT fk_crln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES CUSTOM_REPORT_LIBRARY_NODE(CRLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_crln_relationship_clos_desc ON CRLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_crln_relationship_clos_anc ON CRLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

ALTER TABLE CRLN_RELATIONSHIP_CLOSURE ADD UNIQUE (ANCESTOR_ID, DESCENDANT_ID);

INSERT INTO ACL_CLASS (CLASSNAME) VALUES ('org.squashtest.tm.domain.customreport.CustomReportLibrary');

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '2', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '4', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '8', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestEditor'), '1024', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectViewer'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestRunner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.TestDesigner'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.AdvanceTester'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID) VALUES ((select ID from ACL_GROUP where QUALIFIED_NAME = 'squashtest.acl.group.tm.Validator'), '1', (select ID from ACL_CLASS where CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5292-1', 'jthebault', 'tm/tm.changelog-1.13.0.xml', NOW(), 337, '8:b14a1ed4742e92aaf267d903b94432fb', 'createTable tableName=CUSTOM_REPORT_LIBRARY; createIndex indexName=IDX_CUSTOM_REPORT_LIBRARY, tableName=CUSTOM_REPORT_LIBRARY; createTable tableName=CUSTOM_REPORT_LIBRARY_NODE; createTable tableName=CRLN_RELATIONSHIP; createIndex indexName=idx_crl...', 'This table contains the relations between two custom reports nodes. If a node is root, parent id will be null and descendant id will be itself.
		a given node can be referenced as descendant only one time so we can map the join with hibernate
clos...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feat-5292-2-mysql::jthebault
--  mysql-triggers for CRLN_RELATIONSHIP_CLOSURE table
create trigger ins_crln_after after insert on
		CUSTOM_REPORT_LIBRARY_NODE
		for each row insert ignore into
		CRLN_RELATIONSHIP_CLOSURE values (new.crln_id, new.crln_id, 0);

create trigger del_crln_before before delete on
		CUSTOM_REPORT_LIBRARY_NODE
		for each row delete from
		CRLN_RELATIONSHIP_CLOSURE where ancestor_id=old.crln_id and
		descendant_id=old.crln_id;

create trigger attach_crln_after after insert on CRLN_RELATIONSHIP
		for each row insert ignore into CRLN_RELATIONSHIP_CLOSURE
		select
		c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
		from
		CRLN_RELATIONSHIP_CLOSURE c1
		cross join CRLN_RELATIONSHIP_CLOSURE c2
		where c1.descendant_id = new.ancestor_id
		and c2.ancestor_id = new.descendant_id;

create trigger detach_crln_before before delete on
		CRLN_RELATIONSHIP
		for each row delete clos1 from
		CRLN_RELATIONSHIP_CLOSURE clos1
		join CRLN_RELATIONSHIP_CLOSURE clos2
		on
		clos1.descendant_id=clos2.descendant_id
		left join
		CRLN_RELATIONSHIP_CLOSURE clos3
		on clos3.ancestor_id = clos2.ancestor_id
		and clos3.descendant_id = clos1.ancestor_id
		where
		clos2.ancestor_id = old.descendant_id
		and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feat-5292-2-mysql', 'jthebault', 'tm/tm.changelog-1.13.0.xml', NOW(), 338, '8:77ab09adfc0906d841d57624e46f455f', 'sql; sql; sql; sql', 'mysql-triggers for CRLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feat-5292-3::jthebault
--  Migration for custom report workspace evolution. Mainly create the Library entities and their nodes, attachement list...
insert into CUSTOM_REPORT_LIBRARY (CRL_ID)
		select p.PROJECT_ID
		from PROJECT p;

update PROJECT p
		set CRL_ID = PROJECT_ID;

insert into ACL_OBJECT_IDENTITY (IDENTITY,CLASS_ID)
		  select CRL_ID, ID from CUSTOM_REPORT_LIBRARY,ACL_CLASS
		  where ACL_CLASS.CLASSNAME LIKE 'org.squashtest.tm.domain.customreport.CustomReportLibrary';

insert into ATTACHMENT_LIST (TMP_CRL_ID)
		select CRL_ID
		from CUSTOM_REPORT_LIBRARY crl;

update CUSTOM_REPORT_LIBRARY crl
		set ATTACHMENT_LIST_ID = (
			select ATTACHMENT_LIST_ID
			from ATTACHMENT_LIST al
			where crl.CRL_ID = al.TMP_CRL_ID
	);

insert into CUSTOM_REPORT_LIBRARY_NODE (ENTITY_ID,CRL_ID,ENTITY_TYPE)
		select CRL_ID,CRL_ID,'LIBRARY'
		from CUSTOM_REPORT_LIBRARY;

update CUSTOM_REPORT_LIBRARY_NODE
		set NAME = (
				select p.NAME
				from PROJECT p
				where ENTITY_ID = p.CRL_ID
			)
		where ENTITY_TYPE = 'LIBRARY';

ALTER TABLE ATTACHMENT_LIST DROP COLUMN TMP_CRL_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feat-5292-3', 'jthebault', 'tm/tm.changelog-1.13.0.xml', NOW(), 339, '8:5884d6c41307e073b4b162814fbd26f5', 'sql; sql; sql; sql; dropColumn columnName=TMP_CRL_ID, tableName=ATTACHMENT_LIST', 'Migration for custom report workspace evolution. Mainly create the Library entities and their nodes, attachement list...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5292-4::bsiri
--  set the foreign key constraints from project to custom report library, and from custom report_library to attachment_list
ALTER TABLE PROJECT ADD CONSTRAINT fk_project_crl FOREIGN KEY (CRL_ID) REFERENCES CUSTOM_REPORT_LIBRARY (CRL_ID);

ALTER TABLE CUSTOM_REPORT_LIBRARY ADD CONSTRAINT fk_crl_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5292-4', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 340, '8:0cea90188e94c0803f7a72648a525b19', 'addForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_crl, referencedTableName=CUSTOM_REPORT_LIBRARY; addForeignKeyConstraint baseTableName=CUSTOM_REPORT_LIBRARY, constraintName=fk_crl_attachment_list, referencedTableName=ATTACH...', 'set the foreign key constraints from project to custom report library, and from custom report_library to attachment_list', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5375-4::jsimon
CREATE TABLE CHART_PROJECT_SCOPE (CHART_PROJECT_SCOPE_ID BIGINT AUTO_INCREMENT NOT NULL, CHART_ID BIGINT NOT NULL, PROJECT_SCOPE VARCHAR(15) NULL, CONSTRAINT PK_CHART_PROJECT_SCOPE PRIMARY KEY (CHART_PROJECT_SCOPE_ID), CONSTRAINT fk_chart_project_scope_chart_definition FOREIGN KEY (CHART_ID) REFERENCES CHART_DEFINITION(CHART_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5375-4', 'jsimon', 'tm/tm.changelog-1.13.0.xml', NOW(), 341, '8:8d03e54c82ce1a0365b8bff9db1813ef', 'createTable tableName=CHART_PROJECT_SCOPE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5265-1::bsiri
--  This table holds the optional extension for requirement, that flags them as synchronized requirement
CREATE TABLE REQUIREMENT_SYNC_EXTENDER (REQ_SYNC_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated key', REQUIREMENT_ID BIGINT NOT NULL COMMENT 'foreign key to the (now synchronized) requirement', BUGTRACKER_ID BIGINT NOT NULL COMMENT 'foreign key to the source bugtracker', REMOTE_REQ_ID VARCHAR(15) NULL COMMENT 'ID of the remote requirement', REMOTE_PROJECT_ID VARCHAR(15) NULL COMMENT 'ID of the remote project that hosts the remote requirement', REMOTE_REQ_URL VARCHAR(300) NULL COMMENT 'the url of the remote requirement', LAST_SYNCHRONIZED_BY VARCHAR(50) DEFAULT null NULL COMMENT 'the last used that synchronized that requirement with the remote manager', CONSTRAINT PK_REQUIREMENT_SYNC_EXTENDER PRIMARY KEY (REQ_SYNC_ID), CONSTRAINT fk_sync_extender_bugtracker FOREIGN KEY (BUGTRACKER_ID) REFERENCES BUGTRACKER(BUGTRACKER_ID), CONSTRAINT fk_sync_extender_requirement FOREIGN KEY (REQUIREMENT_ID) REFERENCES REQUIREMENT(RLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5265-1', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 342, '8:4803f8b36971e183b131933ef8c57853', 'createTable tableName=REQUIREMENT_SYNC_EXTENDER', 'This table holds the optional extension for requirement, that flags them as synchronized requirement', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.0.xml::tm-1.13.0-feature-5265-2::bsiri
--  adding a column recording how a requirement should be managed
ALTER TABLE REQUIREMENT ADD MODE VARCHAR(15) DEFAULT 'NATIVE' NULL COMMENT 'Says whether a requirement is NATIVE or SYNCHRONIZED';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.0-feature-5265-2', 'bsiri', 'tm/tm.changelog-1.13.0.xml', NOW(), 343, '8:eb46a85670d8df585dd9799feb298151', 'addColumn tableName=REQUIREMENT', 'adding a column recording how a requirement should be managed', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.1.xml::tm-1.13.1::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.13.1' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.1', 'jthebault', 'tm/tm.changelog-1.13.1.xml', NOW(), 344, '8:5dfe51f4e5794497122d0883a79ea680', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.1.xml::tm-1.13.1-ACL-Custom-Report-Library::jthebault
DROP TABLE IF EXISTS ACL_RSE_TMP;

CREATE TEMPORARY TABLE ACL_RSE_TMP
	(
		PARTY_ID bigint,
		ACL_GROUP_ID bigint,
		OBJECT_IDENTITY_ID bigint,
		PROJECT_ID bigint,
		CRL_ID bigint,
		CRL_CLASS_ID bigint,
		CRL_OBJECT_IDENTITY_ID bigint
	);

insert into ACL_RSE_TMP (PARTY_ID,ACL_GROUP_ID,OBJECT_IDENTITY_ID,PROJECT_ID)
		select PARTY_ID,ACL_GROUP_ID,OBJECT_IDENTITY_ID,ACL_OBJECT_IDENTITY.IDENTITY
		from ACL_RESPONSIBILITY_SCOPE_ENTRY
		inner join ACL_OBJECT_IDENTITY on ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID = ACL_OBJECT_IDENTITY.ID
		inner join ACL_CLASS on ACL_OBJECT_IDENTITY.CLASS_ID = ACL_CLASS.ID
		where ACL_CLASS.CLASSNAME like 'org.squashtest.tm.domain.project.Project%';

update ACL_RSE_TMP 
		set CRL_ID = (select CRL_ID from PROJECT where PROJECT.PROJECT_ID = ACL_RSE_TMP.PROJECT_ID);

update ACL_RSE_TMP 
		set CRL_CLASS_ID = (select ACL_CLASS.ID from ACL_CLASS where ACL_CLASS.CLASSNAME like 'org.squashtest.tm.domain.customreport.CustomReportLibrary');

update ACL_RSE_TMP 
		set CRL_OBJECT_IDENTITY_ID = 
			(select ACL_OBJECT_IDENTITY.ID from ACL_OBJECT_IDENTITY where ACL_OBJECT_IDENTITY.CLASS_ID = 
				(select ACL_CLASS.ID from ACL_CLASS where ACL_CLASS.CLASSNAME like 'org.squashtest.tm.domain.customreport.CustomReportLibrary')
				and ACL_OBJECT_IDENTITY.IDENTITY = ACL_RSE_TMP.CRL_ID
			);

delete from ACL_RESPONSIBILITY_SCOPE_ENTRY where ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID in (select CRL_OBJECT_IDENTITY_ID from ACL_RSE_TMP);

insert into ACL_RESPONSIBILITY_SCOPE_ENTRY (PARTY_ID,ACL_GROUP_ID,OBJECT_IDENTITY_ID)
		select PARTY_ID,ACL_GROUP_ID,CRL_OBJECT_IDENTITY_ID
		from ACL_RSE_TMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.1-ACL-Custom-Report-Library', 'jthebault', 'tm/tm.changelog-1.13.1.xml', NOW(), 345, '8:b3353aee971b32f7a206730a99b71913', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.3.xml::tm-1.13.3::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.13.3' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.3', 'bsiri', 'tm/tm.changelog-1.13.3.xml', NOW(), 346, '8:583d37bd7df8df56d447daace1221115', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.3.xml::tm-1.13.3-feature-5265-1::bsiri
--  making the capacity of plugin configuration items larger
ALTER TABLE LIBRARY_PLUGIN_BINDING_PROPERTY MODIFY PLUGIN_BINDING_VALUE LONGTEXT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.3-feature-5265-1', 'bsiri', 'tm/tm.changelog-1.13.3.xml', NOW(), 347, '8:ad3d502b277a0e8dda58acdbe2fdd508', 'modifyDataType columnName=PLUGIN_BINDING_VALUE, tableName=LIBRARY_PLUGIN_BINDING_PROPERTY', 'making the capacity of plugin configuration items larger', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.3.xml::tm-1.13.3-feature-5265-2::bsiri
--  reworking table REQUIREMENT_SYNC_EXTENDER
ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD REMOTE_FILTER_NAME VARCHAR(150) NOT NULL COMMENT 'name of a filter (not its ID)';

ALTER TABLE REQUIREMENT_SYNC_EXTENDER DROP FOREIGN KEY fk_sync_extender_bugtracker;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER CHANGE BUGTRACKER_ID SERVER_ID BIGINT;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD CONSTRAINT fk_sync_extender_server FOREIGN KEY (SERVER_ID) REFERENCES BUGTRACKER (BUGTRACKER_ID) ON DELETE CASCADE;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER DROP FOREIGN KEY fk_sync_extender_requirement;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD CONSTRAINT fk_sync_extender_requirement FOREIGN KEY (REQUIREMENT_ID) REFERENCES REQUIREMENT (RLN_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.3-feature-5265-2', 'bsiri', 'tm/tm.changelog-1.13.3.xml', NOW(), 348, '8:35006cedc4c73243a67d4c2cf2f40f24', 'addColumn tableName=REQUIREMENT_SYNC_EXTENDER; dropForeignKeyConstraint baseTableName=REQUIREMENT_SYNC_EXTENDER, constraintName=fk_sync_extender_bugtracker; renameColumn newColumnName=SERVER_ID, oldColumnName=BUGTRACKER_ID, tableName=REQUIREMENT_S...', 'reworking table REQUIREMENT_SYNC_EXTENDER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.3.xml::tm-1.13.3-feature-5265-3::bsiri
--  adding useful indexes
CREATE INDEX idx_sync_remote_req_id ON REQUIREMENT_SYNC_EXTENDER(REMOTE_REQ_ID);

CREATE INDEX idx_sync_remote_projfilter ON REQUIREMENT_SYNC_EXTENDER(REMOTE_PROJECT_ID, REMOTE_FILTER_NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.3-feature-5265-3', 'bsiri', 'tm/tm.changelog-1.13.3.xml', NOW(), 349, '8:fe6f4a07b70b8d871d45343bc60e2ba1', 'createIndex indexName=idx_sync_remote_req_id, tableName=REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_sync_remote_projfilter, tableName=REQUIREMENT_SYNC_EXTENDER', 'adding useful indexes', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.3.xml::tm-1.13.3-feature-5265-4::bsiri
--  This view maps a requirement library node to its main resource. Some would say 
--  			it is redundant with what can be found in tables REQUIREMENT or REQUIREMENT_FOLDER
--  			but seriously it makes simple things likes getting the name of a generic 
--  			REQUIREMENT_LIBRARY_NODE much simpler.
CREATE VIEW RLN_RESOURCE AS select fold.rln_id as rln_id, fold.res_id as res_id
			from REQUIREMENT_FOLDER fold 
			UNION
			select req.rln_id as rln_id, req.current_version_id as res_id
			from REQUIREMENT req;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.3-feature-5265-4', 'bsiri', 'tm/tm.changelog-1.13.3.xml', NOW(), 350, '8:2e16043bb6f1dd0782f3b9e2ef3df413', 'createView viewName=RLN_RESOURCE', 'This view maps a requirement library node to its main resource. Some would say 
			it is redundant with what can be found in tables REQUIREMENT or REQUIREMENT_FOLDER
			but seriously it makes simple things likes getting the name of a generic 
			R...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.3.xml::tm-1.13.3-feature-5265-5::bsiri
--  new requirement audit trail tables for synchronization events
CREATE TABLE SYNC_REQUIREMENT_CREATION (EVENT_ID BIGINT NOT NULL COMMENT 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).', SOURCE VARCHAR(255) NOT NULL COMMENT 'the url of the synchronized requirement at the time of creation', CONSTRAINT PK_SYNC_CREATE PRIMARY KEY (EVENT_ID), CONSTRAINT fk_sync_create_audit FOREIGN KEY (EVENT_ID) REFERENCES REQUIREMENT_AUDIT_EVENT(EVENT_ID)) ENGINE = INNODB;

CREATE TABLE SYNC_REQUIREMENT_UPDATE (EVENT_ID BIGINT NOT NULL COMMENT 'primary key, which is also a foreign key to REQUIREMENT_AUDIT_EVENT (they share that key : do not make this table autoincrement it).', SOURCE VARCHAR(255) NOT NULL COMMENT 'the url of the synchronized requirement at the time of update', CONSTRAINT PK_SYNC_UPDATE PRIMARY KEY (EVENT_ID), CONSTRAINT fk_sync_update_audit FOREIGN KEY (EVENT_ID) REFERENCES REQUIREMENT_AUDIT_EVENT(EVENT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.3-feature-5265-5', 'bsiri', 'tm/tm.changelog-1.13.3.xml', NOW(), 351, '8:1a73b17e530c2ca172ada8511878181a', 'createTable tableName=SYNC_REQUIREMENT_CREATION; createTable tableName=SYNC_REQUIREMENT_UPDATE', 'new requirement audit trail tables for synchronization events', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.5.xml::tm-1.13.5::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.13.5' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.5', 'jthebault', 'tm/tm.changelog-1.13.5.xml', NOW(), 352, '8:73c40d201987202855e9197795ed789d', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.13.5.xml::tm-1.13.5-issue-6291::jthebault
--  Delete orphan lines in cuf values. Only for cuf values bind to a removed execution.
DELETE FROM CUSTOM_FIELD_VALUE
      WHERE cfv_id IN (
        SELECT implicit.cfv_id FROM (
          SELECT cfv.cfv_id
          FROM CUSTOM_FIELD_VALUE cfv
          LEFT JOIN EXECUTION exec
          ON exec.execution_id = cfv.bound_entity_id
          WHERE cfv.bound_entity_type = 'EXECUTION'
          AND exec.execution_id IS NULL
      ) implicit
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.13.5-issue-6291', 'jthebault', 'tm/tm.changelog-1.13.5.xml', NOW(), 353, '8:648348de98c9cf73908fcff0911ec3ab', 'sql', 'Delete orphan lines in cuf values. Only for cuf values bind to a removed execution.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.14.0.xml::tm-1.14.0::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.14.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.14.0', 'bsiri', 'tm/tm.changelog-1.14.0.xml', NOW(), 354, '8:b8a4cc8d0b66bdc42ac118684ecde133', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.14.0.xml::tm-1.14.0-feature-5416::jthebault
CREATE TABLE PARTY_PREFERENCE (PREFERENCE_ID BIGINT AUTO_INCREMENT NOT NULL, PARTY_ID BIGINT NOT NULL COMMENT 'foreign key to the core_party table', PREFERENCE_KEY VARCHAR(50) NULL, PREFERENCE_VALUE VARCHAR(5000) NULL, CONSTRAINT PK_PARTY_PREFERENCE PRIMARY KEY (PREFERENCE_ID), CONSTRAINT fk_party_preference_core_party_party_id FOREIGN KEY (PARTY_ID) REFERENCES CORE_PARTY(PARTY_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.14.0-feature-5416', 'jthebault', 'tm/tm.changelog-1.14.0.xml', NOW(), 355, '8:fdc67ca09020a062cad0e5cde3c582c2', 'createTable tableName=PARTY_PREFERENCE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.14.1.xml::tm-1.14.1::bsiri
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.14.1' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.14.1', 'bsiri', 'tm/tm.changelog-1.14.1.xml', NOW(), 356, '8:a4951c9aab722dc6da389d1fbbea4de6', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.14.1.xml::tm-1.14.1-issue-6340-1::bsiri
--  For the purpose of the cleanup to come, we must activate on delete cascade
--              between DENORMALIZED_FIELD_OPTION and DENORMALIZED_FIELD_VALUE
ALTER TABLE DENORMALIZED_FIELD_OPTION DROP FOREIGN KEY fk_df_option_dfv;

ALTER TABLE DENORMALIZED_FIELD_OPTION ADD CONSTRAINT fk_df_option_dfv FOREIGN KEY (DFV_ID) REFERENCES DENORMALIZED_FIELD_VALUE (DFV_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.14.1-issue-6340-1', 'bsiri', 'tm/tm.changelog-1.14.1.xml', NOW(), 357, '8:2a456f87ed5132be98b83b0d7e8e28c7', 'dropForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_OPTION, constraintName=fk_df_option_dfv; addForeignKeyConstraint baseTableName=DENORMALIZED_FIELD_OPTION, constraintName=fk_df_option_dfv, referencedTableName=DENORMALIZED_FIELD_VALUE', 'For the purpose of the cleanup to come, we must activate on delete cascade
            between DENORMALIZED_FIELD_OPTION and DENORMALIZED_FIELD_VALUE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.14.1.xml::tm-1.14.1-issue-6340-2b::bsiri
--  Fixing the extraneous custom field values (for test cases) and denormalized field values (for executions)
--            for MySQL
create temporary table DFV_DELETE as
        (
                SELECT MAX( DFV_ID ) as DFV_ID
                FROM DENORMALIZED_FIELD_VALUE
                WHERE DENORMALIZED_FIELD_HOLDER_TYPE = 'EXECUTION'
                GROUP BY DENORMALIZED_FIELD_HOLDER_ID, DENORMALIZED_FIELD_HOLDER_TYPE, CODE
        );

delete from DENORMALIZED_FIELD_VALUE
        where DENORMALIZED_FIELD_HOLDER_TYPE = 'EXECUTION'
        and DFV_ID not in (
                select DFV_ID from DFV_DELETE
        );

create temporary table CFV_DELETE as
        (
                SELECT MAX( CFV_ID ) as CFV_ID
                FROM CUSTOM_FIELD_VALUE
                WHERE BOUND_ENTITY_TYPE = 'TEST_CASE'
                GROUP BY BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, CFB_ID
        );

delete from CUSTOM_FIELD_VALUE
        where BOUND_ENTITY_TYPE = 'TEST_CASE'
        and CFV_ID not in (
                select CFV_ID from CFV_DELETE
        );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.14.1-issue-6340-2b', 'bsiri', 'tm/tm.changelog-1.14.1.xml', NOW(), 358, '8:6a477771aaff19c16ab84dca9a8cfa8c', 'sql', 'Fixing the extraneous custom field values (for test cases) and denormalized field values (for executions)
          for MySQL', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.14.1.xml::tm-1.14.1-issue-6340-3::bsiri
--  enforcing uniticy on the custom field values and denormalized field values -
--            if later on there are more double insert let it fail fast
ALTER TABLE DENORMALIZED_FIELD_VALUE ADD CONSTRAINT u_dfv_id_type_code UNIQUE (DENORMALIZED_FIELD_HOLDER_ID, DENORMALIZED_FIELD_HOLDER_TYPE, CODE);

ALTER TABLE CUSTOM_FIELD_VALUE ADD CONSTRAINT u_cfv_id_type_binding UNIQUE (BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, CFB_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.14.1-issue-6340-3', 'bsiri', 'tm/tm.changelog-1.14.1.xml', NOW(), 359, '8:33fe9e5bafdda2bd39ccdacb36ed1e1c', 'addUniqueConstraint constraintName=u_dfv_id_type_code, tableName=DENORMALIZED_FIELD_VALUE; addUniqueConstraint constraintName=u_cfv_id_type_binding, tableName=CUSTOM_FIELD_VALUE', 'enforcing uniticy on the custom field values and denormalized field values -
          if later on there are more double insert let it fail fast', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.15.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 360, '8:5f0abce44da7fdf9a9c5af45b1896931', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0-feature-6365::jthebault
--  column for numeric cufs
ALTER TABLE CUSTOM_FIELD ADD NUMERIC_DEFAULT_VALUE DECIMAL(20, 5) NULL COMMENT 'a column to persist numeric cuf';

ALTER TABLE CUSTOM_FIELD_VALUE ADD NUMERIC_VALUE DECIMAL(20, 5) NULL COMMENT 'a column to persist numeric cuf';

ALTER TABLE DENORMALIZED_FIELD_VALUE ADD NUMERIC_VALUE DECIMAL(20, 5) NULL COMMENT 'a column to persist denormalized numeric cuf';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0-feature-6365', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 361, '8:5e2d4acbeca777f1468dc2a16ec2e1d5', 'addColumn tableName=CUSTOM_FIELD; addColumn tableName=CUSTOM_FIELD_VALUE; addColumn tableName=DENORMALIZED_FIELD_VALUE', 'column for numeric cufs', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0-cuf-custom-report-1::jthebault
--  Denormalize the cuf ID inside the cuf values, so we don't have to make two more joins in custom reports
CREATE TABLE TEMP_CUF_ID (CFV_ID BIGINT NULL, CF_ID BIGINT NULL) ENGINE = INNODB;

CREATE INDEX idx_tmp_cuf_cuf_id ON TEMP_CUF_ID(CF_ID);

CREATE INDEX idx_tmp_cuf_cfv_id ON TEMP_CUF_ID(CFV_ID);

ALTER TABLE CUSTOM_FIELD_VALUE ADD CF_ID BIGINT NULL COMMENT 'dernomalize the custom field id for custom report queries';

CREATE INDEX idx_cfv_custom_field_id ON CUSTOM_FIELD_VALUE(CF_ID);

insert into TEMP_CUF_ID (CFV_ID,CF_ID)
        select cfv.CFV_ID, cfb.CF_ID
        from CUSTOM_FIELD_VALUE cfv
        join CUSTOM_FIELD_BINDING cfb on cfv.CFB_ID = cfb.CFB_ID;

update CUSTOM_FIELD_VALUE
      set CF_ID = (
        select TEMP_CUF_ID.CF_ID
        from TEMP_CUF_ID
        where TEMP_CUF_ID.CFV_ID = CUSTOM_FIELD_VALUE.CFV_ID
      );

DROP TABLE TEMP_CUF_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0-cuf-custom-report-1', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 362, '8:48fde32bf41c5ebb21d3b82d80887134', 'createTable tableName=TEMP_CUF_ID; createIndex indexName=idx_tmp_cuf_cuf_id, tableName=TEMP_CUF_ID; createIndex indexName=idx_tmp_cuf_cfv_id, tableName=TEMP_CUF_ID; addColumn tableName=CUSTOM_FIELD_VALUE; createIndex indexName=idx_cfv_custom_field...', 'Denormalize the cuf ID inside the cuf values, so we don''t have to make two more joins in custom reports', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0-cuf-custom-report-2::jthebault
--  columns prototypes for custom fields bound to requirement version.
--  columns prototypes for custom fields bound to test case.
--  columns prototypes for custom fields bound to campaign.
--  columns prototypes for custom fields bound to iteration.
--  columns prototypes for custom fields bound to execution.
insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID,COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      values
      (95,'CUF', TRUE, 'REQUIREMENT_VERSION_CUF_TEXT', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'STRING', 'value', null),
      (96,'CUF', TRUE, 'REQUIREMENT_VERSION_CUF_CHECKBOX', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'BOOLEAN_AS_STRING', 'value', null),
      (97,'CUF', TRUE, 'REQUIREMENT_VERSION_CUF_LIST', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'LIST', 'value', null),
      (98,'CUF', TRUE, 'REQUIREMENT_VERSION_CUF_DATE', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'DATE_AS_STRING', 'value', null),
      (99,'CUF', TRUE, 'REQUIREMENT_VERSION_CUF_TAG', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'TAG', 'value', null),
      (100,'CUF', TRUE, 'REQUIREMENT_VERSION_CUF_NUMERIC', 'REQUIREMENT_VERSION', 'CUSTOM_FIELD', 'NUMERIC', 'value', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      values
      (95, 'MEASURE'), (95, 'AXIS'), (95, 'FILTER'),
      (96, 'MEASURE'), (96, 'AXIS'), (96, 'FILTER'),
      (97, 'MEASURE'), (97, 'AXIS'), (97, 'FILTER'),
      (98, 'MEASURE'), (98, 'AXIS'), (98, 'FILTER'),
      (99, 'MEASURE'), (99, 'AXIS'), (99, 'FILTER'),
      (100, 'MEASURE'), (100, 'AXIS'), (100, 'FILTER');

insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID,COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      values
      (101,'CUF', TRUE, 'TEST_CASE_CUF_TEXT', 'TEST_CASE', 'CUSTOM_FIELD', 'STRING', 'value', null),
      (102,'CUF', TRUE, 'TEST_CASE_CUF_CHECKBOX', 'TEST_CASE', 'CUSTOM_FIELD', 'BOOLEAN_AS_STRING', 'value', null),
      (103,'CUF', TRUE, 'TEST_CASE_CUF_LIST', 'TEST_CASE', 'CUSTOM_FIELD', 'LIST', 'value', null),
      (104,'CUF', TRUE, 'TEST_CASE_CUF_DATE', 'TEST_CASE', 'CUSTOM_FIELD', 'DATE_AS_STRING', 'value', null),
      (105,'CUF', TRUE, 'TEST_CASE_CUF_TAG', 'TEST_CASE', 'CUSTOM_FIELD', 'TAG', 'value', null),
      (106,'CUF', TRUE, 'TEST_CASE_CUF_NUMERIC', 'TEST_CASE', 'CUSTOM_FIELD', 'NUMERIC', 'value', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      values
      (101, 'MEASURE'), (101, 'AXIS'), (101, 'FILTER'),
      (102, 'MEASURE'), (102, 'AXIS'), (102, 'FILTER'),
      (103, 'MEASURE'), (103, 'AXIS'), (103, 'FILTER'),
      (104, 'MEASURE'), (104, 'AXIS'), (104, 'FILTER'),
      (105, 'MEASURE'), (105, 'AXIS'), (105, 'FILTER'),
      (106, 'MEASURE'), (106, 'AXIS'), (106, 'FILTER');

insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID,COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      values
      (107,'CUF', TRUE, 'CAMPAIGN_CUF_TEXT', 'CAMPAIGN', 'CUSTOM_FIELD', 'STRING', 'value', null),
      (108,'CUF', TRUE, 'CAMPAIGN_CUF_CHECKBOX', 'CAMPAIGN', 'CUSTOM_FIELD', 'BOOLEAN_AS_STRING', 'value', null),
      (109,'CUF', TRUE, 'CAMPAIGN_CUF_LIST', 'CAMPAIGN', 'CUSTOM_FIELD', 'LIST', 'value', null),
      (110,'CUF', TRUE, 'CAMPAIGN_CUF_DATE', 'CAMPAIGN', 'CUSTOM_FIELD', 'DATE_AS_STRING', 'value', null),
      (111,'CUF', TRUE, 'CAMPAIGN_CUF_TAG', 'CAMPAIGN', 'CUSTOM_FIELD', 'TAG', 'value', null),
      (112,'CUF', TRUE, 'CAMPAIGN_CUF_NUMERIC', 'CAMPAIGN', 'CUSTOM_FIELD', 'NUMERIC', 'value', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      values
      (107, 'MEASURE'), (107, 'AXIS'), (107, 'FILTER'),
      (108, 'MEASURE'), (108, 'AXIS'), (108, 'FILTER'),
      (109, 'MEASURE'), (109, 'AXIS'), (109, 'FILTER'),
      (110, 'MEASURE'), (110, 'AXIS'), (110, 'FILTER'),
      (111, 'MEASURE'), (111, 'AXIS'), (111, 'FILTER'),
      (112, 'MEASURE'), (112, 'AXIS'), (112, 'FILTER');

insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID,COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      values
      (113,'CUF', TRUE, 'ITERATION_CUF_TEXT', 'ITERATION', 'CUSTOM_FIELD', 'STRING', 'value', null),
      (114,'CUF', TRUE, 'ITERATION_CUF_CHECKBOX', 'ITERATION', 'CUSTOM_FIELD', 'BOOLEAN_AS_STRING', 'value', null),
      (115,'CUF', TRUE, 'ITERATION_CUF_LIST', 'ITERATION', 'CUSTOM_FIELD', 'LIST', 'value', null),
      (116,'CUF', TRUE, 'ITERATION_CUF_DATE', 'ITERATION', 'CUSTOM_FIELD', 'DATE_AS_STRING', 'value', null),
      (117,'CUF', TRUE, 'ITERATION_CUF_TAG', 'ITERATION', 'CUSTOM_FIELD', 'TAG', 'value', null),
      (118,'CUF', TRUE, 'ITERATION_CUF_NUMERIC', 'ITERATION', 'CUSTOM_FIELD', 'NUMERIC', 'value', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      values
      (113, 'MEASURE'), (113, 'AXIS'), (113, 'FILTER'),
      (114, 'MEASURE'), (114, 'AXIS'), (114, 'FILTER'),
      (115, 'MEASURE'), (115, 'AXIS'), (115, 'FILTER'),
      (116, 'MEASURE'), (116, 'AXIS'), (116, 'FILTER'),
      (117, 'MEASURE'), (117, 'AXIS'), (117, 'FILTER'),
      (118, 'MEASURE'), (118, 'AXIS'), (118, 'FILTER');

insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID,COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      values
      (119,'CUF', TRUE, 'EXECUTION_CUF_TEXT', 'EXECUTION', 'CUSTOM_FIELD', 'STRING', 'value', null),
      (120,'CUF', TRUE, 'EXECUTION_CUF_CHECKBOX', 'EXECUTION', 'CUSTOM_FIELD', 'BOOLEAN_AS_STRING', 'value', null),
      (121,'CUF', TRUE, 'EXECUTION_CUF_LIST', 'EXECUTION', 'CUSTOM_FIELD', 'LIST', 'value', null),
      (122,'CUF', TRUE, 'EXECUTION_CUF_DATE', 'EXECUTION', 'CUSTOM_FIELD', 'DATE_AS_STRING', 'value', null),
      (123,'CUF', TRUE, 'EXECUTION_CUF_TAG', 'EXECUTION', 'CUSTOM_FIELD', 'TAG', 'value', null),
      (124,'CUF', TRUE, 'EXECUTION_CUF_NUMERIC', 'EXECUTION', 'CUSTOM_FIELD', 'NUMERIC', 'value', null);

insert into CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      values
      (119, 'MEASURE'), (119, 'AXIS'), (119, 'FILTER'),
      (120, 'MEASURE'), (120, 'AXIS'), (120, 'FILTER'),
      (121, 'MEASURE'), (121, 'AXIS'), (121, 'FILTER'),
      (122, 'MEASURE'), (122, 'AXIS'), (122, 'FILTER'),
      (123, 'MEASURE'), (123, 'AXIS'), (123, 'FILTER'),
      (124, 'MEASURE'), (124, 'AXIS'), (124, 'FILTER');

ALTER TABLE CHART_MEASURE_COLUMN ADD CUF_ID BIGINT NULL COMMENT 'a column to persist cuf id relative to this measure';

ALTER TABLE CHART_AXIS_COLUMN ADD CUF_ID BIGINT NULL COMMENT 'a column to persist cuf id relative to this axis';

ALTER TABLE CHART_FILTER ADD CUF_ID BIGINT NULL COMMENT 'a column to persist cuf id relative to this filter';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0-cuf-custom-report-2', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 363, '8:4e194cffc73cc151ca615ab0189f82bd', 'sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; addColumn tableName=CHART_MEASURE_COLUMN; addColumn tableName=CHART_AXIS_COLUMN; addColumn tableName=CHART_FILTER', 'columns prototypes for custom fields bound to requirement version.
columns prototypes for custom fields bound to test case.
columns prototypes for custom fields bound to campaign.
columns prototypes for custom fields bound to iteration.
columns pr...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0-feat-5417::jthebault
ALTER TABLE CHART_DEFINITION ADD SCOPE_TYPE VARCHAR(20) NULL COMMENT 'a column to persist the scope type';

update CHART_DEFINITION
      set SCOPE_TYPE = 'PROJECTS'
      where CHART_ID in
      (select CHART_ID from CHART_SCOPE where ENTITY_REFERENCE_TYPE like 'PROJECT');

update CHART_DEFINITION
      set SCOPE_TYPE = 'CUSTOM'
      where SCOPE_TYPE IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0-feat-5417', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 364, '8:b8cad20d9086d2e3aa076b1897eaecf1', 'addColumn tableName=CHART_DEFINITION; sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0-feat-5417-2::jthebault
update PARTY_PREFERENCE
      set PREFERENCE_VALUE = 'default'
      where PREFERENCE_VALUE = 'message' and PREFERENCE_KEY = 'squash.core.home.content';

update PARTY_PREFERENCE
      set PREFERENCE_KEY = 'squash.core.dashboard.content.home'
      where PREFERENCE_KEY = 'squash.core.home.content';

update PARTY_PREFERENCE
      set PREFERENCE_KEY = 'squash.core.favorite.dashboard.home'
      where PREFERENCE_KEY = 'squash.core.favorite.dashboard';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0-feat-5417-2', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 365, '8:acbefa25edb59180ef38ac904e8c4252', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.15.0.xml::tm-1.15.0-feat-5417-3::jthebault
insert into CHART_COLUMN_PROTOTYPE(CHART_COLUMN_ID,COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      values
      (125,'ATTRIBUTE', FALSE, 'CAMPAIGN_MILESTONE_ID', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'NUMERIC', 'id', null);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.15.0-feat-5417-3', 'jthebault', 'tm/tm.changelog-1.15.0.xml', NOW(), 366, '8:0d03bc0eac56362f6ffd647868a39f21', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.16.0.xml::tm-1.16.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.16.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.16.0.xml', NOW(), 367, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.16.0.xml::tm-1.16.0::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.16.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.16.0', 'jprioux', 'tm/tm.changelog-1.16.0.xml', NOW(), 368, '8:ef2d0b4d85aa73343955979430857140', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.16.0.xml::tm-1.16.0-feature-6763::jprioux
--  column for last connected on
ALTER TABLE CORE_USER ADD LAST_CONNECTED_ON datetime NULL COMMENT 'a column to persist the last connection date';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.16.0-feature-6763', 'jprioux', 'tm/tm.changelog-1.16.0.xml', NOW(), 369, '8:9177032ded7ea353d8e4f8e87eafe649', 'addColumn tableName=CORE_USER', 'column for last connected on', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.16.0.xml::tm-1.16.0-feature-6799::jlor
CREATE TABLE REQUIREMENT_VERSION_LINK_TYPE (TYPE_ID BIGINT AUTO_INCREMENT NOT NULL, ROLE_1 VARCHAR(50) NULL, ROLE_1_CODE VARCHAR(30) NULL, ROLE_2 VARCHAR(50) NULL, ROLE_2_CODE VARCHAR(30) NULL, IS_DEFAULT BIT(1) DEFAULT 0 NOT NULL COMMENT 'Only one item per list should have it true ', CONSTRAINT PK_REQUIREMENT_VERSION_LINK_TYPE PRIMARY KEY (TYPE_ID)) ENGINE = INNODB;

CREATE TABLE REQUIREMENT_VERSION_LINK (LINK_ID BIGINT AUTO_INCREMENT NOT NULL, LINK_TYPE_ID BIGINT NOT NULL COMMENT 'foreign key to the requirement_version_link_type table', LINK_DIRECTION BIT(1) DEFAULT 0 NOT NULL, REQUIREMENT_VERSION_ID BIGINT NOT NULL COMMENT 'foreign key for requirement version to requirement_version table', RELATED_REQUIREMENT_VERSION_ID BIGINT NOT NULL COMMENT 'foreign key for related requirement version to requirement_version table', CONSTRAINT PK_REQUIREMENT_VERSION_LINK PRIMARY KEY (LINK_ID), CONSTRAINT fk_requirement_version_link_related_requirement_version_id FOREIGN KEY (RELATED_REQUIREMENT_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID), CONSTRAINT fk_req_version_link_req_version_link_type_link_type_id FOREIGN KEY (LINK_TYPE_ID) REFERENCES REQUIREMENT_VERSION_LINK_TYPE(TYPE_ID), CONSTRAINT fk_requirement_version_link_requirement_version_id FOREIGN KEY (REQUIREMENT_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID)) ENGINE = INNODB;

INSERT INTO REQUIREMENT_VERSION_LINK_TYPE (ROLE_1, ROLE_1_CODE, ROLE_2, ROLE_2_CODE, IS_DEFAULT) VALUES ('requirement-version.link.type.related', 'RELATED', 'requirement-version.link.type.related', 'RELATED', 1);

INSERT INTO REQUIREMENT_VERSION_LINK_TYPE (ROLE_1, ROLE_1_CODE, ROLE_2, ROLE_2_CODE, IS_DEFAULT) VALUES ('requirement-version.link.type.parent', 'PARENT', 'requirement-version.link.type.child', 'CHILD', 0);

INSERT INTO REQUIREMENT_VERSION_LINK_TYPE (ROLE_1, ROLE_1_CODE, ROLE_2, ROLE_2_CODE, IS_DEFAULT) VALUES ('requirement-version.link.type.duplicate', 'DUPLICATE', 'requirement-version.link.type.duplicate', 'DUPLICATE', 0);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.16.0-feature-6799', 'jlor', 'tm/tm.changelog-1.16.0.xml', NOW(), 370, '8:2c2333c7188e9c02b475b74e2b5408fe', 'createTable tableName=REQUIREMENT_VERSION_LINK_TYPE; createTable tableName=REQUIREMENT_VERSION_LINK; insert tableName=REQUIREMENT_VERSION_LINK_TYPE; insert tableName=REQUIREMENT_VERSION_LINK_TYPE; insert tableName=REQUIREMENT_VERSION_LINK_TYPE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.17.0.xml', NOW(), 371, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.17.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0', 'jthebault', 'tm/tm.changelog-1.17.0.xml', NOW(), 372, '8:635106608f9ea0995f9c28da565b8652', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-feature-6921::zyang
--  Adds a status field to campaign and iteration
ALTER TABLE CAMPAIGN ADD CAMPAIGN_STATUS VARCHAR(30) DEFAULT 'UNDEFINED' NOT NULL;

ALTER TABLE ITERATION ADD ITERATION_STATUS VARCHAR(30) DEFAULT 'UNDEFINED' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-feature-6921', 'zyang', 'tm/tm.changelog-1.17.0.xml', NOW(), 373, '8:7c2bee7c946ec37dcf1c94a8edeb197f', 'addColumn tableName=CAMPAIGN; addColumn tableName=ITERATION', 'Adds a status field to campaign and iteration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0::zyang
CREATE TABLE REPORT_DEFINITION (REPORT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', NAME VARCHAR(255) NULL COMMENT 'The name of this chart', `DESCRIPTION` LONGTEXT NULL COMMENT 'additional informations about this report', PLUGIN_NAMESPACE VARCHAR(255) NULL COMMENT 'The namespace of the report plugin', PARAMETERS LONGTEXT NULL COMMENT 'parameters to generate the report', USER_ID BIGINT NOT NULL COMMENT 'foreign key to the owner of this report definition', PROJECT_ID BIGINT NOT NULL COMMENT 'foreign key to the projet', CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, CONSTRAINT PK_REPORT_DEFINITION PRIMARY KEY (REPORT_ID), CONSTRAINT fk_report_owner FOREIGN KEY (USER_ID) REFERENCES CORE_USER(PARTY_ID), CONSTRAINT fk_project_report_definition_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0', 'zyang', 'tm/tm.changelog-1.17.0.xml', NOW(), 374, '8:a51a3bbf6dfc42620313e2eef68df1cb', 'createTable tableName=REPORT_DEFINITION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-feature-6921::cholc
--  Adds a execution status field to the test suites
ALTER TABLE TEST_SUITE ADD EXECUTION_STATUS VARCHAR(255) DEFAULT 'READY' NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-feature-6921', 'cholc', 'tm/tm.changelog-1.17.0.xml', NOW(), 375, '8:7ecf63ab62a5066758ac61daadb4b949', 'addColumn tableName=TEST_SUITE', 'Adds a execution status field to the test suites', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-feature-sqtm-167::bsiri
--  Adding the ability to use application-level credentials that allows Squash interact with a bugtracker on its own
--        (ie instead of requiring the current user to authenticate).
CREATE TABLE STORED_CREDENTIALS (CREDENTIAL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key', ENC_VERSION SMALLINT NULL COMMENT 'the version of encryption service used. Possibly the value will remain to 1 forever.', ENC_CREDENTIALS TEXT NULL COMMENT 'the credentials as an encrypted string', AUTHENTICATED_SERVER BIGINT NULL COMMENT 'foreign key to the server to authenticate', CONSTRAINT PK_STORED_CREDENTIALS PRIMARY KEY (CREDENTIAL_ID), CONSTRAINT fk_stored_credentials_authenticated_server FOREIGN KEY (AUTHENTICATED_SERVER) REFERENCES BUGTRACKER(BUGTRACKER_ID) ON DELETE CASCADE) ENGINE = INNODB;

ALTER TABLE BUGTRACKER ADD AUTH_POLICY VARCHAR(30) DEFAULT 'USER' NULL COMMENT 'the policy that decides who needs to authenticate';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-feature-sqtm-167', 'bsiri', 'tm/tm.changelog-1.17.0.xml', NOW(), 376, '8:dae8f23fb21f93b77c6246708ce0d72d', 'createTable tableName=STORED_CREDENTIALS; addColumn tableName=BUGTRACKER', 'Adding the ability to use application-level credentials that allows Squash interact with a bugtracker on its own
      (ie instead of requiring the current user to authenticate).', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-jira-sync-01::jthebault
--  Add a remote synchronisation table in squash tm.
CREATE TABLE REMOTE_SYNCHRONISATION (REMOTE_SYNCHRONISATION_ID BIGINT AUTO_INCREMENT NOT NULL, PROJECT_ID BIGINT NOT NULL, SERVER_ID BIGINT NOT NULL, REMOTE_SYNCHRONISATION_NAME VARCHAR(255) NOT NULL, KIND VARCHAR(50) NOT NULL, REMOTE_SELECT_TYPE VARCHAR(50) NULL, REMOTE_SELECT_VALUE VARCHAR(1000) NULL, LAST_SUCCESSFUL_SYNC_DATE datetime NULL, LAST_SYNC_DATE datetime NULL, LAST_SYNC_STATUS VARCHAR(20) NULL, SYNC_STATUS VARCHAR(20) NULL, REMOTE_SYNCHRONISATION_OPTIONS LONGTEXT NULL, CONSTRAINT PK_REMOTE_SYNCHRONISATION PRIMARY KEY (REMOTE_SYNCHRONISATION_ID), CONSTRAINT fk_remote_sync__project__project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_remote_sync__bugtracker__bugtracker_id FOREIGN KEY (SERVER_ID) REFERENCES BUGTRACKER(BUGTRACKER_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-jira-sync-01', 'jthebault', 'tm/tm.changelog-1.17.0.xml', NOW(), 377, '8:b70c85f02dd90cf9d8ce3b2a6e9cf76d', 'createTable tableName=REMOTE_SYNCHRONISATION', 'Add a remote synchronisation table in squash tm.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-jira-sync-02::jthebault
--  Add a remote folder synchronisation table in squash tm.
CREATE TABLE REQUIREMENT_FOLDER_SYNC_EXTENDER (RF_SYNC_EXTENDER_ID BIGINT AUTO_INCREMENT NOT NULL, REMOTE_SYNCHRONISATION_ID BIGINT NOT NULL COMMENT 'Only one master folder should be targeted by a given synchronisation', REMOTE_FOLDER_ID VARCHAR(255) NULL, REMOTE_FOLDER_STATUS VARCHAR(50) NULL, REQUIREMENT_FOLDER_ID BIGINT NOT NULL COMMENT 'Only one extender for any folder in Squash TM', TYPE VARCHAR(30) NOT NULL, CONSTRAINT PK_REQUIREMENT_FOLDER_SYNC_EXTENDER PRIMARY KEY (RF_SYNC_EXTENDER_ID), CONSTRAINT fk_req_folder_sync_extender__remote_sync_remote_sync_id FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION(REMOTE_SYNCHRONISATION_ID), CONSTRAINT fk_req_folder_sync_extender__req_folder__rln_id FOREIGN KEY (REQUIREMENT_FOLDER_ID) REFERENCES REQUIREMENT_FOLDER(RLN_ID), UNIQUE (REQUIREMENT_FOLDER_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-jira-sync-02', 'jthebault', 'tm/tm.changelog-1.17.0.xml', NOW(), 378, '8:77686424e0ff386fcc4e120065c7c6fc', 'createTable tableName=REQUIREMENT_FOLDER_SYNC_EXTENDER', 'Add a remote folder synchronisation table in squash tm.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-jira-sync-03::jthebault
ALTER TABLE REQUIREMENT_SYNC_EXTENDER MODIFY REMOTE_FILTER_NAME VARCHAR(150) NULL;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD REMOTE_SYNCHRONISATION_ID BIGINT NULL, ADD REMOTE_LAST_UPDATED datetime NULL, ADD REMOTE_PARENT_ID VARCHAR(30) NULL;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD CONSTRAINT fk_req_sync_extender__remote_sync_remote_sync_id FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION (REMOTE_SYNCHRONISATION_ID);

CREATE INDEX req_sync_extender_remote_parent_id_idx ON REQUIREMENT_SYNC_EXTENDER(REMOTE_PARENT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-jira-sync-03', 'jthebault', 'tm/tm.changelog-1.17.0.xml', NOW(), 379, '8:98f597ab35b289fca921d3062ea9795e', 'dropNotNullConstraint columnName=REMOTE_FILTER_NAME, tableName=REQUIREMENT_SYNC_EXTENDER; addColumn tableName=REQUIREMENT_SYNC_EXTENDER; createIndex indexName=req_sync_extender_remote_parent_id_idx, tableName=REQUIREMENT_SYNC_EXTENDER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.17.0.xml::tm-1.17.0-Issue-6967::jthebault
CREATE INDEX tcln_name_idx ON TEST_CASE_LIBRARY_NODE(NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.17.0-Issue-6967', 'jthebault', 'tm/tm.changelog-1.17.0.xml', NOW(), 380, '8:3cdbf1b9fd528540de692dda7c1b941e', 'createIndex indexName=tcln_name_idx, tableName=TEST_CASE_LIBRARY_NODE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.18.0.xml', NOW(), 381, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.18.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0', 'jthebault', 'tm/tm.changelog-1.18.0.xml', NOW(), 382, '8:c007b82557a1da7abdfc8a0a8dd981ef', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-connection-log-table::aguilhem
--  Create Connection Attempt Log Table
CREATE TABLE CONNECTION_ATTEMPT_LOG (ATTEMPT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', LOGIN VARCHAR(50) NULL COMMENT 'login used to connect', CONNECTION_DATE datetime NOT NULL COMMENT 'Date of connection', SUCCESS BIT(1) NOT NULL COMMENT 'if connection succeeded or not', CONSTRAINT PK_CONNECTION_ATTEMPT_LOG PRIMARY KEY (ATTEMPT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-connection-log-table', 'aguilhem', 'tm/tm.changelog-1.18.0.xml', NOW(), 383, '8:0fc79047ba04c43e0002af165e25172d', 'createTable tableName=CONNECTION_ATTEMPT_LOG', 'Create Connection Attempt Log Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-project-template-link::jlor
--  Adding a column to keep the link between a Project and a Project Template
ALTER TABLE PROJECT ADD TEMPLATE_ID BIGINT NULL;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_template_id FOREIGN KEY (TEMPLATE_ID) REFERENCES PROJECT (PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-project-template-link', 'jlor', 'tm/tm.changelog-1.18.0.xml', NOW(), 384, '8:e24e3c9048470677dbd774874095f7c1', 'addColumn tableName=PROJECT', 'Adding a column to keep the link between a Project and a Project Template', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-feature-7183.1-mysql::jprioux
--  mysql - add unique constraint for ordered list : test case steps
drop table if exists TEST_CASE_STEPS_TMP;

create table TEST_CASE_STEPS_TMP
                    (select TEST_CASE_ID, STEP_ID, min(STEP_ORDER) STEP_ORDER
                       from TEST_CASE_STEPS
                   group by TEST_CASE_ID, STEP_ID);

create index idx1 on TEST_CASE_STEPS_TMP(TEST_CASE_ID,STEP_ID);

update TEST_CASE_STEPS_TMP t1,
              (select TEST_CASE_ID, STEP_ID, (select count(*)
                                     from TEST_CASE_STEPS_TMP b
                                    where a.TEST_CASE_ID = b.TEST_CASE_ID
                                      and a.STEP_ORDER >= b.STEP_ORDER) ligne
                 from TEST_CASE_STEPS_TMP a) t2
        set t1.STEP_ORDER = t2.ligne - 1
         where t1.TEST_CASE_ID = t2.TEST_CASE_ID and t1.STEP_ID = t2.STEP_ID;

truncate table TEST_CASE_STEPS;

insert into TEST_CASE_STEPS
        select a.TEST_CASE_ID, a.STEP_ID,
               a.STEP_ORDER + 1 - (select count(*) from TEST_CASE_STEPS_TMP b
                                where a.TEST_CASE_ID = b.TEST_CASE_ID
                                  and a.STEP_ORDER = b.STEP_ORDER
                                  and a.STEP_ID <= b.STEP_ID
                             group by b.TEST_CASE_ID, b.STEP_ORDER) STEP_ORDER
          from TEST_CASE_STEPS_TMP a;

drop table TEST_CASE_STEPS_TMP;

ALTER TABLE TEST_CASE_STEPS ADD CONSTRAINT uc_test_case_steps_order UNIQUE (TEST_CASE_ID, STEP_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-feature-7183.1-mysql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', NOW(), 385, '8:713d639a95dc96a1169e2dac3b7acfac', 'sql; addUniqueConstraint constraintName=uc_test_case_steps_order, tableName=TEST_CASE_STEPS', 'mysql - add unique constraint for ordered list : test case steps', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-feature-7183.2-mysql::jprioux
--  mysql - add unique constraint for ordered list : tcs in iteration
drop table if exists ITEM_TEST_PLAN_LIST_TMP;

create table ITEM_TEST_PLAN_LIST_TMP
                    (select ITERATION_ID, ITEM_TEST_PLAN_ID, min(ITEM_TEST_PLAN_ORDER) ITEM_TEST_PLAN_ORDER
                       from ITEM_TEST_PLAN_LIST
                   group by ITERATION_ID, ITEM_TEST_PLAN_ID);

create index idx2 on ITEM_TEST_PLAN_LIST_TMP(ITERATION_ID, ITEM_TEST_PLAN_ID);

update ITEM_TEST_PLAN_LIST_TMP t1,
              (select ITERATION_ID, ITEM_TEST_PLAN_ID, (select count(*)
                                     from ITEM_TEST_PLAN_LIST_TMP b
                                    where a.ITERATION_ID = b.ITERATION_ID
                                      and a.ITEM_TEST_PLAN_ORDER >= b.ITEM_TEST_PLAN_ORDER) ligne
                 from ITEM_TEST_PLAN_LIST_TMP a) t2
        set t1.ITEM_TEST_PLAN_ORDER = t2.ligne - 1
         where t1.ITERATION_ID = t2.ITERATION_ID and t1.ITEM_TEST_PLAN_ID = t2.ITEM_TEST_PLAN_ID;

truncate table ITEM_TEST_PLAN_LIST;

insert into ITEM_TEST_PLAN_LIST
        select a.ITERATION_ID, a.ITEM_TEST_PLAN_ID,
               a.ITEM_TEST_PLAN_ORDER + 1 - (select count(*) from ITEM_TEST_PLAN_LIST_TMP b
                                where a.ITERATION_ID = b.ITERATION_ID
                                  and a.ITEM_TEST_PLAN_ORDER = b.ITEM_TEST_PLAN_ORDER
                                  and a.ITEM_TEST_PLAN_ID <= b.ITEM_TEST_PLAN_ID
                             group by b.ITERATION_ID, b.ITEM_TEST_PLAN_ORDER) ITEM_TEST_PLAN_ORDER
          from ITEM_TEST_PLAN_LIST_TMP a;

drop table ITEM_TEST_PLAN_LIST_TMP;

ALTER TABLE ITEM_TEST_PLAN_LIST ADD CONSTRAINT uc_item_test_plan_list_order UNIQUE (ITERATION_ID, ITEM_TEST_PLAN_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-feature-7183.2-mysql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', NOW(), 386, '8:9612f16af003129d5ab212a0a1afdbcb', 'sql; addUniqueConstraint constraintName=uc_item_test_plan_list_order, tableName=ITEM_TEST_PLAN_LIST', 'mysql - add unique constraint for ordered list : tcs in iteration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-feature-7183.3-mysql::jprioux
--  mysql - add unique constraint for ordered list : tcs in test suite
drop table if exists TEST_SUITE_TEST_PLAN_ITEM_TMP;

create table TEST_SUITE_TEST_PLAN_ITEM_TMP
                    (select SUITE_ID, TPI_ID, min(TEST_PLAN_ORDER) TEST_PLAN_ORDER
                       from TEST_SUITE_TEST_PLAN_ITEM
                   group by SUITE_ID, TPI_ID);

create index idx2 on TEST_SUITE_TEST_PLAN_ITEM_TMP(SUITE_ID, TPI_ID);

update TEST_SUITE_TEST_PLAN_ITEM_TMP t1,
              (select SUITE_ID, TPI_ID, (select count(*)
                                     from TEST_SUITE_TEST_PLAN_ITEM_TMP b
                                    where a.SUITE_ID = b.SUITE_ID
                                      and a.TEST_PLAN_ORDER >= b.TEST_PLAN_ORDER) ligne
                 from TEST_SUITE_TEST_PLAN_ITEM_TMP a) t2
        set t1.TEST_PLAN_ORDER = t2.ligne - 1
         where t1.SUITE_ID = t2.SUITE_ID and t1.TPI_ID = t2.TPI_ID;

truncate table TEST_SUITE_TEST_PLAN_ITEM;

insert into TEST_SUITE_TEST_PLAN_ITEM
        select a.TPI_ID, a.SUITE_ID,
               a.TEST_PLAN_ORDER + 1 - (select count(*) from TEST_SUITE_TEST_PLAN_ITEM_TMP b
                                where a.SUITE_ID = b.SUITE_ID
                                  and a.TEST_PLAN_ORDER = b.TEST_PLAN_ORDER
                                  and a.TPI_ID <= b.TPI_ID
                             group by b.SUITE_ID, b.TEST_PLAN_ORDER) TEST_PLAN_ORDER
          from TEST_SUITE_TEST_PLAN_ITEM_TMP a;

drop table TEST_SUITE_TEST_PLAN_ITEM_TMP;

ALTER TABLE TEST_SUITE_TEST_PLAN_ITEM ADD CONSTRAINT uc_test_suite_test_plan_item_order UNIQUE (SUITE_ID, TEST_PLAN_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-feature-7183.3-mysql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', NOW(), 387, '8:7f432b6d0794f9f2f6fbf97a9f4dbada', 'sql; addUniqueConstraint constraintName=uc_test_suite_test_plan_item_order, tableName=TEST_SUITE_TEST_PLAN_ITEM', 'mysql - add unique constraint for ordered list : tcs in test suite', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-feature-7183.4-mysql::jprioux
--  mysql - add unique constraint for ordered list : tcs in campaign
drop table if exists CAMPAIGN_TEST_PLAN_ITEM_TMP;

create table CAMPAIGN_TEST_PLAN_ITEM_TMP
                    (select CTPI_ID, CAMPAIGN_ID, TEST_CASE_ID, USER_ID, min(TEST_PLAN_ORDER) TEST_PLAN_ORDER, DATASET_ID
                       from CAMPAIGN_TEST_PLAN_ITEM
                   group by CAMPAIGN_ID, CTPI_ID);

create index idx2 on CAMPAIGN_TEST_PLAN_ITEM_TMP(CAMPAIGN_ID, CTPI_ID);

update CAMPAIGN_TEST_PLAN_ITEM_TMP t1,
              (select CTPI_ID, CAMPAIGN_ID, TEST_CASE_ID, USER_ID, (select count(*)
                                     from CAMPAIGN_TEST_PLAN_ITEM_TMP b
                                    where a.CAMPAIGN_ID = b.CAMPAIGN_ID
                                      and a.TEST_PLAN_ORDER >= b.TEST_PLAN_ORDER) ligne, DATASET_ID
                 from CAMPAIGN_TEST_PLAN_ITEM_TMP a) t2
        set t1.TEST_PLAN_ORDER = t2.ligne - 1
         where t1.CAMPAIGN_ID = t2.CAMPAIGN_ID and t1.CTPI_ID = t2.CTPI_ID;

truncate table CAMPAIGN_TEST_PLAN_ITEM;

insert into CAMPAIGN_TEST_PLAN_ITEM
        select a.CTPI_ID, a.CAMPAIGN_ID, a.TEST_CASE_ID, a.USER_ID,
               a.TEST_PLAN_ORDER + 1 - (select count(*) from CAMPAIGN_TEST_PLAN_ITEM_TMP b
                                where a.CAMPAIGN_ID = b.CAMPAIGN_ID
                                  and a.TEST_PLAN_ORDER = b.TEST_PLAN_ORDER
                                  and a.CTPI_ID <= b.CTPI_ID
                             group by b.CAMPAIGN_ID, b.TEST_PLAN_ORDER) TEST_PLAN_ORDER, a.DATASET_ID
          from CAMPAIGN_TEST_PLAN_ITEM_TMP a;

drop table CAMPAIGN_TEST_PLAN_ITEM_TMP;

ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM ADD CONSTRAINT uc_campaign_test_plan_item_order UNIQUE (CAMPAIGN_ID, TEST_PLAN_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-feature-7183.4-mysql', 'jprioux', 'tm/tm.changelog-1.18.0.xml', NOW(), 388, '8:96bd6445c0ddca1b37d16f5c18f84481', 'sql; addUniqueConstraint constraintName=uc_campaign_test_plan_item_order, tableName=CAMPAIGN_TEST_PLAN_ITEM', 'mysql - add unique constraint for ordered list : tcs in campaign', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-binding-report-to-dashboard::zyang
CREATE TABLE CUSTOM_REPORT_REPORT_BINDING (CRRB_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'pk genere', CRD_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le dashboard. ', REPORT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le report. ', ROW INT NULL, COL INT NULL, SIZE_X INT NULL, SIZE_Y INT NULL, CONSTRAINT PK_CRRB_ID PRIMARY KEY (CRRB_ID), CONSTRAINT fk_chart_bindind_report_definition_report_id FOREIGN KEY (REPORT_ID) REFERENCES REPORT_DEFINITION(REPORT_ID), CONSTRAINT fk_report_bindind_custom_report_dashboard_crd_id FOREIGN KEY (CRD_ID) REFERENCES CUSTOM_REPORT_DASHBOARD(CRD_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-binding-report-to-dashboard', 'zyang', 'tm/tm.changelog-1.18.0.xml', NOW(), 389, '8:3d397a73a7554ac2dec23e806278fc3f', 'createTable tableName=CUSTOM_REPORT_REPORT_BINDING', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-scripted-test-case::jthebault
--  Create the scripted test case table
--  Create the scripted execution table
CREATE TABLE SCRIPTED_TC_EXTENDER (SCRIPTED_TC_EXTENDER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', SCRIPT LONGTEXT NULL COMMENT 'the test case script', LANGUAGE VARCHAR(50) NULL COMMENT 'scriptLanguage of script', TEST_CASE_ID BIGINT NOT NULL COMMENT 'foreign key to TEST_CASE', CONSTRAINT PK_SCRIPTED_TC_EXTENDER PRIMARY KEY (SCRIPTED_TC_EXTENDER_ID), CONSTRAINT fk_scripted_extender_test_case FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

CREATE INDEX scripted_tc_extender_test_case_id_idx ON SCRIPTED_TC_EXTENDER(TEST_CASE_ID);

CREATE TABLE SCRIPTED_EXECUTION_EXTENDER (SCRIPTED_EXECUTION_EXTENDER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', LANGUAGE VARCHAR(50) NULL COMMENT 'scriptLanguage of script', SCRIPT_NAME VARCHAR(255) NULL COMMENT 'script name,by example feature name for Gherkin', EXECUTION_ID BIGINT NOT NULL COMMENT 'foreign key to EXECUTION', CONSTRAINT PK_SCRIPTED_EXECUTION_EXTENDER PRIMARY KEY (SCRIPTED_EXECUTION_EXTENDER_ID), CONSTRAINT fk_scripted_extender_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID)) ENGINE = INNODB;

CREATE INDEX scripted_execution_extender_execution_id_idx ON SCRIPTED_EXECUTION_EXTENDER(EXECUTION_ID);

ALTER TABLE TEST_CASE ADD TC_KIND VARCHAR(30) DEFAULT 'STANDARD' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-scripted-test-case', 'jthebault', 'tm/tm.changelog-1.18.0.xml', NOW(), 390, '8:d5249b00e7375b24091e878316a2492b', 'createTable tableName=SCRIPTED_TC_EXTENDER; createIndex indexName=scripted_tc_extender_test_case_id_idx, tableName=SCRIPTED_TC_EXTENDER; createTable tableName=SCRIPTED_EXECUTION_EXTENDER; createIndex indexName=scripted_execution_extender_execution...', 'Create the scripted test case table
Create the scripted execution table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-modification-report::zyang
--  Adds a summary field to report definition
ALTER TABLE REPORT_DEFINITION ADD SUMMARY VARCHAR(255) DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-modification-report', 'zyang', 'tm/tm.changelog-1.18.0.xml', NOW(), 391, '8:d18f312340f2a9695467f8b970bd18c4', 'addColumn tableName=REPORT_DEFINITION', 'Adds a summary field to report definition', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-oauth1a-consumer-1::bsiri
--  StoredCredentials can now store either credentials, either general configuration.
--          A new column appear so we can hint what is the type of the payload.
--          Also, users can now have stored credentials (even though they can't manage them yet).
--          Only one credentials can be created for a given user and a given server (bugtracker)
ALTER TABLE STORED_CREDENTIALS ADD CONTENT_TYPE VARCHAR(4) DEFAULT 'CRED' NULL COMMENT 'the role of the content, either CRED or CONF' , ADD AUTHENTICATED_USER BIGINT DEFAULT null NULL COMMENT 'Foreign key to the user account that owns the credentials. A NULL value means that Squash-TM               owns the credentials (app-level credentials).';

ALTER TABLE STORED_CREDENTIALS ADD CONSTRAINT fk_stored_credentials_user FOREIGN KEY (AUTHENTICATED_USER) REFERENCES CORE_USER (PARTY_ID);

ALTER TABLE STORED_CREDENTIALS ADD CONSTRAINT uniq_stored_credentials_server_user UNIQUE (AUTHENTICATED_SERVER, AUTHENTICATED_USER, CONTENT_TYPE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-oauth1a-consumer-1', 'bsiri', 'tm/tm.changelog-1.18.0.xml', NOW(), 392, '8:40cf2cb2853a3de0486875b356e99208', 'addColumn tableName=STORED_CREDENTIALS; addUniqueConstraint constraintName=uniq_stored_credentials_server_user, tableName=STORED_CREDENTIALS', 'StoredCredentials can now store either credentials, either general configuration.
        A new column appear so we can hint what is the type of the payload.
        Also, users can now have stored credentials (even though they can''t manage them y...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-oauth1a-consumer-2::bsiri
--  Bugtracker now declare which authentication protocol should be used upfront.
ALTER TABLE BUGTRACKER ADD AUTH_PROTOCOL VARCHAR(30) DEFAULT 'BASIC_AUTH' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-oauth1a-consumer-2', 'bsiri', 'tm/tm.changelog-1.18.0.xml', NOW(), 393, '8:7ef0a187573741b67e5c7d67d737ca66', 'addColumn tableName=BUGTRACKER', 'Bugtracker now declare which authentication protocol should be used upfront.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.18.0.xml::tm-1.18.0-email-column-resizing::aguilhem
ALTER TABLE CORE_USER MODIFY EMAIL VARCHAR(255);

ALTER TABLE CORE_USER ALTER EMAIL SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.18.0-email-column-resizing', 'aguilhem', 'tm/tm.changelog-1.18.0.xml', NOW(), 394, '8:1459ae06e7ed1049f85d05dba10c783a', 'modifyDataType columnName=EMAIL, tableName=CORE_USER; addDefaultValue columnName=EMAIL, tableName=CORE_USER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.19.0.xml', NOW(), 395, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0::cholc
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.19.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 396, '8:79d344adec29f8523acb83f31ca09402', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-400-info-list-item::cholc
--  Adds a colour field to info list items
ALTER TABLE INFO_LIST_ITEM ADD COLOUR VARCHAR(7) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-400-info-list-item', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 397, '8:69536af651c134f813bc37a03070beea', 'addColumn tableName=INFO_LIST_ITEM', 'Adds a colour field to info list items', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-400-custom-field-option::cholc
--  Adds a colour field to custom field options
ALTER TABLE CUSTOM_FIELD_OPTION ADD COLOUR VARCHAR(7) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-400-custom-field-option', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 398, '8:067e8b87f39929938617cd84c0930654', 'addColumn tableName=CUSTOM_FIELD_OPTION', 'Adds a colour field to custom field options', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-409-iteration-test-suite-remove-constraint::cholc
--  To drop an unique constraint, you need the constraint's name, which we don't have, so here we copy the
--        column and delete the original
ALTER TABLE ITERATION_TEST_SUITE ADD TEST_SUITE_ID_TEMP BIGINT NULL;

ALTER TABLE ITERATION_TEST_SUITE DROP FOREIGN KEY fk_iteration_test_suite_suite;

UPDATE ITERATION_TEST_SUITE SET TEST_SUITE_ID_TEMP = TEST_SUITE_ID;

ALTER TABLE ITERATION_TEST_SUITE DROP COLUMN TEST_SUITE_ID;

ALTER TABLE ITERATION_TEST_SUITE CHANGE TEST_SUITE_ID_TEMP TEST_SUITE_ID BIGINT;

ALTER TABLE ITERATION_TEST_SUITE MODIFY TEST_SUITE_ID BIGINT NOT NULL;

ALTER TABLE ITERATION_TEST_SUITE ADD CONSTRAINT fk_iteration_test_suite_suite FOREIGN KEY (TEST_SUITE_ID) REFERENCES TEST_SUITE (ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-409-iteration-test-suite-remove-constraint', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 399, '8:47251f14e90438d1cf29942477eac5ac', 'addColumn tableName=ITERATION_TEST_SUITE; dropForeignKeyConstraint baseTableName=ITERATION_TEST_SUITE, constraintName=fk_iteration_test_suite_suite; update tableName=ITERATION_TEST_SUITE; dropColumn columnName=TEST_SUITE_ID, tableName=ITERATION_TE...', 'To drop an unique constraint, you need the constraint''s name, which we don''t have, so here we copy the
      column and delete the original', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-409-iteration-test-suite-order::cholc
--  add an order to iterations' test suites
ALTER TABLE ITERATION_TEST_SUITE ADD ITERATION_TEST_SUITE_ORDER INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-409-iteration-test-suite-order', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 400, '8:c604993a6bcdbb239a2d95791e071a41', 'addColumn tableName=ITERATION_TEST_SUITE', 'add an order to iterations'' test suites', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-409-iteration-test-suite-order-generation::cholc
--  will compute the order of the test suites in the iterations, should work for all databases
UPDATE ITERATION_TEST_SUITE ITS
      SET
      ITERATION_TEST_SUITE_ORDER = (SELECT
      SUB_QUERY.ORDER_DEF
      FROM
      (SELECT
      ITS1.ITERATION_ID AS I_ID,
      ITS1.TEST_SUITE_ID AS TS_ID,
      (COUNT(*) - 1) AS ORDER_DEF
      FROM
      ITERATION_TEST_SUITE ITS1
      INNER JOIN ITERATION_TEST_SUITE ITS2 ON ITS1.ITERATION_ID = ITS2.ITERATION_ID
      AND ITS1.TEST_SUITE_ID >= ITS2.TEST_SUITE_ID
      GROUP BY ITS1.ITERATION_ID , ITS1.TEST_SUITE_ID) AS SUB_QUERY
      WHERE
      SUB_QUERY.I_ID = ITS.ITERATION_ID
      AND SUB_QUERY.TS_ID = ITS.TEST_SUITE_ID);

ALTER TABLE ITERATION_TEST_SUITE ADD CONSTRAINT uc_iteration_iteration_test_suite_order UNIQUE (ITERATION_ID, ITERATION_TEST_SUITE_ORDER);

ALTER TABLE ITERATION_TEST_SUITE MODIFY ITERATION_TEST_SUITE_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-409-iteration-test-suite-order-generation', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 401, '8:d05b4845192d3b6f3f38ee79045e259b', 'sql; addUniqueConstraint constraintName=uc_iteration_iteration_test_suite_order, tableName=ITERATION_TEST_SUITE; addNotNullConstraint columnName=ITERATION_TEST_SUITE_ORDER, tableName=ITERATION_TEST_SUITE', 'will compute the order of the test suites in the iterations, should work for all databases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-up-sb2-1::bsiri
--  Passwords are now much longer since we also store the salt.
ALTER TABLE AUTH_USER MODIFY PASSWORD VARCHAR(255);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-up-sb2-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 402, '8:4fec87dfb8b26d239bda1ae3f6573939', 'modifyDataType columnName=PASSWORD, tableName=AUTH_USER', 'Passwords are now much longer since we also store the salt.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-399-infolist-items-default-colours::cholc
--  Requirement categories colours
--  Test cases natures colours
--  Test cases types colours
UPDATE INFO_LIST_ITEM SET COLOUR = '#C3AB77' WHERE CODE = 'CAT_TEST_REQUIREMENT';

UPDATE INFO_LIST_ITEM SET COLOUR = '#CDCDCD' WHERE CODE = 'CAT_UNDEFINED';

UPDATE INFO_LIST_ITEM SET COLOUR = '#8F6057' WHERE CODE = 'CAT_ERGONOMIC';

UPDATE INFO_LIST_ITEM SET COLOUR = '#FCCA46' WHERE CODE = 'CAT_PERFORMANCE';

UPDATE INFO_LIST_ITEM SET COLOUR = '#233D4D' WHERE CODE = 'CAT_TECHNICAL';

UPDATE INFO_LIST_ITEM SET COLOUR = '#094C75' WHERE CODE = 'CAT_USER_STORY';

UPDATE INFO_LIST_ITEM SET COLOUR = '#FE7F2D' WHERE CODE = 'CAT_SECURITY';

UPDATE INFO_LIST_ITEM SET COLOUR = '#7594CD' WHERE CODE = 'CAT_FUNCTIONAL';

UPDATE INFO_LIST_ITEM SET COLOUR = '#BB5759' WHERE CODE = 'CAT_NON_FUNCTIONAL';

UPDATE INFO_LIST_ITEM SET COLOUR = '#A1C181' WHERE CODE = 'CAT_USE_CASE';

UPDATE INFO_LIST_ITEM SET COLOUR = '#619B8A' WHERE CODE = 'CAT_BUSINESS';

UPDATE INFO_LIST_ITEM SET COLOUR = '#A1C181' WHERE CODE = 'NAT_USER_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#FCCA46' WHERE CODE = 'NAT_PERFORMANCE_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#FE7F2D' WHERE CODE = 'NAT_SECURITY_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#233D4D' WHERE CODE = 'NAT_ATDD';

UPDATE INFO_LIST_ITEM SET COLOUR = '#CDCDCD' WHERE CODE = 'NAT_UNDEFINED';

UPDATE INFO_LIST_ITEM SET COLOUR = '#7594CD' WHERE CODE = 'NAT_FUNCTIONAL_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#BB5759' WHERE CODE = 'NAT_NON_FUNCTIONAL_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#619B8A' WHERE CODE = 'NAT_BUSINESS_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#CDCDCD' WHERE CODE = 'TYP_UNDEFINED';

UPDATE INFO_LIST_ITEM SET COLOUR = '#5B9367' WHERE CODE = 'TYP_COMPLIANCE_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#CD533B' WHERE CODE = 'TYP_CORRECTION_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#D8A86E' WHERE CODE = 'TYP_EVOLUTION_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#F2E77E' WHERE CODE = 'TYP_REGRESSION_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#2D5635' WHERE CODE = 'TYP_END_TO_END_TESTING';

UPDATE INFO_LIST_ITEM SET COLOUR = '#F2E2CE' WHERE CODE = 'TYP_PARTNER_TESTING';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-399-infolist-items-default-colours', 'cholc', 'tm/tm.changelog-1.19.0.xml', NOW(), 403, '8:024f29efbde813cf2093f9a88524ebde', 'update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName=INFO_LIST_ITEM; update tableName...', 'Requirement categories colours
Test cases natures colours
Test cases types colours', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-453-execution-name-maxlength::jprioux
--  Increase max length for execution name
ALTER TABLE EXECUTION MODIFY NAME VARCHAR(308);

ALTER TABLE EXECUTION MODIFY NAME VARCHAR(308) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-453-execution-name-maxlength', 'jprioux', 'tm/tm.changelog-1.19.0.xml', NOW(), 404, '8:3cb1611a1b730b40a0cb7703b48af530', 'modifyDataType columnName=NAME, tableName=EXECUTION; addNotNullConstraint columnName=NAME, tableName=EXECUTION', 'Increase max length for execution name', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-508-automation-request::aboittiaux
--  Create table AUTOMATION_REQUEST to Gherkin's test cases
CREATE TABLE AUTOMATION_REQUEST (AUTOMATION_REQUEST_ID BIGINT AUTO_INCREMENT NOT NULL, REQUEST_STATUS VARCHAR(25) DEFAULT 'WORK_IN_PROGRESS' NOT NULL, TRANSMITTED_ON datetime NULL, ASSIGNED_TO BIGINT NULL, AUTOMATION_PRIORITY INT NULL, ASSIGNED_ON datetime NULL, TEST_CASE_ID BIGINT NULL, CREATED_BY BIGINT NULL, TRANSMITTED_BY BIGINT NULL, PROJECT_ID BIGINT NOT NULL COMMENT 'fk to the host project', CONSTRAINT PK_AUTOMATION_REQUEST PRIMARY KEY (AUTOMATION_REQUEST_ID), CONSTRAINT fk_automation_request_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX automation_request_assigned_to_idx ON AUTOMATION_REQUEST(ASSIGNED_TO);

CREATE INDEX automation_request_created_by_idx ON AUTOMATION_REQUEST(CREATED_BY);

CREATE INDEX automation_request_transmitted_by_idx ON AUTOMATION_REQUEST(TRANSMITTED_BY);

CREATE INDEX automation_request_test_case_id_idx ON AUTOMATION_REQUEST(TEST_CASE_ID);

ALTER TABLE AUTOMATION_REQUEST ADD CONSTRAINT fk_automation_request_automation_assigned_to FOREIGN KEY (ASSIGNED_TO) REFERENCES CORE_USER (PARTY_ID) ON DELETE SET NULL;

ALTER TABLE AUTOMATION_REQUEST ADD CONSTRAINT fk_automation_request_transmitted_by FOREIGN KEY (TRANSMITTED_BY) REFERENCES CORE_USER (PARTY_ID) ON DELETE SET NULL;

ALTER TABLE AUTOMATION_REQUEST ADD CONSTRAINT fk_automation_request_created_by FOREIGN KEY (CREATED_BY) REFERENCES CORE_USER (PARTY_ID) ON DELETE SET NULL;

ALTER TABLE AUTOMATION_REQUEST ADD CONSTRAINT fk_automation_request_test_case FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE (TCLN_ID) ON DELETE SET NULL;

ALTER TABLE TEST_CASE ADD AUTOMATABLE CHAR DEFAULT 'M' NULL COMMENT 'Y: Yes, N: No, M: Maybe';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-508-automation-request', 'aboittiaux', 'tm/tm.changelog-1.19.0.xml', NOW(), 405, '8:5748276926c63e23884eab6c5bec0219', 'createTable tableName=AUTOMATION_REQUEST; createIndex indexName=automation_request_assigned_to_idx, tableName=AUTOMATION_REQUEST; createIndex indexName=automation_request_created_by_idx, tableName=AUTOMATION_REQUEST; createIndex indexName=automati...', 'Create table AUTOMATION_REQUEST to Gherkin''s test cases', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-519-automation-request-library-1::bsiri
--  Creating the AutomationRequestLibrary
CREATE TABLE AUTOMATION_REQUEST_LIBRARY (ARL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autoincremented primary key', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'fk to the attachment list', CONSTRAINT PK_AUTOMATION_REQUEST_LIBRARY PRIMARY KEY (ARL_ID), CONSTRAINT fk_autorequestLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_automation_request_library ON AUTOMATION_REQUEST_LIBRARY(ARL_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 406, '8:d50286a3e29feee52710b1b901b61221', 'createTable tableName=AUTOMATION_REQUEST_LIBRARY; createIndex indexName=idx_automation_request_library, tableName=AUTOMATION_REQUEST_LIBRARY', 'Creating the AutomationRequestLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-519-automation-request-library-2::bsiri
--  New entries in the ACL infrastructure.
insert into ACL_CLASS(ID, CLASSNAME) values(7,
      'org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary');

insert into ACL_GROUP(ID, QUALIFIED_NAME) values(10, 'squashtest.acl.group.tm.AutomatedTestWriter');

insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      select AGP2.ACL_GROUP_ID, AGP2.PERMISSION_MASK, 7
      from ACL_GROUP_PERMISSION AGP2
      where CLASS_ID = 3;

insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values
      (2, 7, 8192),
      (5, 7, 8192),
      (5, 7, 16384),
      (7, 7, 8192),
      (8, 7, 8192),
      (9, 7, 8192),
      (10, 2, 1),
      (10, 3, 1),
      (10, 4, 1),
      (10, 6, 1),
      (10, 7, 1),
      (10, 7, 2),
      (10, 7, 4),
      (10, 7, 8),
      (10, 7, 64),
      (10, 7, 256),
      (10, 7, 1024),
      (10, 7, 4096),
      (10, 7, 16384);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-2', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 407, '8:180f840f2a84db732425975563ea575b', 'sql', 'New entries in the ACL infrastructure.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-519-automation-request-library-3::bsiri
--  The automation request library content table
CREATE TABLE AUTOMATION_REQUEST_LIBRARY_CONTENT (LIBRARY_ID BIGINT NOT NULL COMMENT 'Foreign key to the library', CONTENT_ID BIGINT NOT NULL COMMENT 'Foreign key to the content', CONSTRAINT fk_automation_request_lib_content_content FOREIGN KEY (CONTENT_ID) REFERENCES AUTOMATION_REQUEST(AUTOMATION_REQUEST_ID), CONSTRAINT fk_automation_rquest_lib_content_lib FOREIGN KEY (LIBRARY_ID) REFERENCES AUTOMATION_REQUEST_LIBRARY(ARL_ID), UNIQUE (CONTENT_ID)) ENGINE = INNODB;

CREATE INDEX idx_automation_request_lib_content_content ON AUTOMATION_REQUEST_LIBRARY_CONTENT(CONTENT_ID);

CREATE INDEX idx_automation_request_lib_content_lib ON AUTOMATION_REQUEST_LIBRARY_CONTENT(LIBRARY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-3', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 408, '8:5cbe1b343b76e479c1690c7740b57a66', 'createTable tableName=AUTOMATION_REQUEST_LIBRARY_CONTENT; createIndex indexName=idx_automation_request_lib_content_content, tableName=AUTOMATION_REQUEST_LIBRARY_CONTENT; createIndex indexName=idx_automation_request_lib_content_lib, tableName=AUTOM...', 'The automation request library content table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-519-automation-request-library-4::bsiri
--  Add a Project fk to the AutomationRequestLibrary
ALTER TABLE PROJECT ADD ARL_ID BIGINT NULL COMMENT 'fk to the automation request library';

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_arl FOREIGN KEY (ARL_ID) REFERENCES AUTOMATION_REQUEST_LIBRARY (ARL_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-4', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 409, '8:8ab0815e2d2f628387e03680cac07cb5', 'addColumn tableName=PROJECT', 'Add a Project fk to the AutomationRequestLibrary', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-519-automation-request-library-5::bsiri
--  Create one such library for each existing projects
-- create the libraries

      insert into AUTOMATION_REQUEST_LIBRARY (ARL_ID)
      select p.PROJECT_ID from PROJECT p;

-- attachments, step 1 :
      -- create a ranking table, akin to what would ROW_NUMBER() order by id desc would say

      create table ARL_RANK as
      select alib.arl_id, count(alib2.arl_id)  as ranking
      from AUTOMATION_REQUEST_LIBRARY alib,
      AUTOMATION_REQUEST_LIBRARY alib2
      where alib.arl_id <= alib2.arl_id
      group by alib.arl_id
      order by ranking asc;

-- attachments, step 2 :
      -- create a table that pairs library ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier

      create table ARL_ATTACHLIST_PAIRING as
      select arl.arl_id, (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + arl.ranking as attachment_list_id
      from ARL_RANK arl;

-- attachments, step 3 :
      -- insert the attachment lists and update fk in the automation request library
      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
      select pair.attachment_list_id from ARL_ATTACHLIST_PAIRING pair;

update AUTOMATION_REQUEST_LIBRARY arl
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id from ARL_ATTACHLIST_PAIRING pair where pair.arl_id = arl.arl_id);

-- attachments, step 4 and final :
      -- drop the temporary tables

      drop table ARL_ATTACHLIST_PAIRING;

drop table ARL_RANK;

-- wire the project to the ARL library

      update PROJECT P
      set ARL_ID = PROJECT_ID;

-- insert the acl object identities
      insert into ACL_OBJECT_IDENTITY(IDENTITY, CLASS_ID)
      select arl.arl_id, 7 from AUTOMATION_REQUEST_LIBRARY arl;

-- add the user/team permissions in ACL_RESPONSIBILITY_SCOPE_ENTRY
      -- each user will receive the same acl_group on each arl library than on the project it depends on
      -- (this last sentence is the idea behind the auto join on acl_object_identity in this query)
      insert into ACL_RESPONSIBILITY_SCOPE_ENTRY(party_id, acl_group_id, object_identity_id)
      select distinct arse.party_id, arse.acl_group_id, arl_oid.id
      from ACL_RESPONSIBILITY_SCOPE_ENTRY arse
      inner join ACL_OBJECT_IDENTITY oid on (arse.object_identity_id = oid.id and oid.class_id = 1)
      inner join ACL_OBJECT_IDENTITY arl_oid on (oid.identity = arl_oid.identity and arl_oid.class_id = 7);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-519-automation-request-library-5', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 410, '8:6ff106ef30e97bcc441802c7e131a5f9', 'sql', 'Create one such library for each existing projects', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-510-add-roles-automation::aboittiaux
insert into CORE_PARTY_AUTHORITY(PARTY_ID, AUTHORITY)
      select distinct cu.PARTY_ID, 'ROLE_TF_FUNCTIONAL_TESTER' from CORE_USER cu
      left join CORE_PARTY_AUTHORITY cpa on cu.PARTY_ID = cpa.PARTY_ID
      left join CORE_GROUP_MEMBER ctm on ctm.PARTY_ID = cu.PARTY_ID
      where cpa.AUTHORITY is null and ctm.GROUP_ID = 2;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-510-add-roles-automation', 'aboittiaux', 'tm/tm.changelog-1.19.0.xml', NOW(), 411, '8:a3bdb0be7bc17d10b27d23bfc7066a98', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-524-automation-workflow-by-project::jprioux
--  add a boolean in project table to activate or not the automation workflow
ALTER TABLE PROJECT ADD ALLOW_AUTOMATION_WORKFLOW BIT(1) DEFAULT 0 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-524-automation-workflow-by-project', 'jprioux', 'tm/tm.changelog-1.19.0.xml', NOW(), 412, '8:11beffcb803f2a36c49f51746e8e80bd', 'addColumn tableName=PROJECT', 'add a boolean in project table to activate or not the automation workflow', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-create-auth-users::bsiri
--  add the missing entries in AUTH_USER for users that only exist in CORE_USER (eg a user created by LDAP)
insert into AUTH_USER (login, password, active)
      select cu.LOGIN, '', cu.active
      from CORE_USER cu
      left join AUTH_USER au on cu.login = au.login
      where au.login is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-create-auth-users', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 413, '8:de146a8d54324c093d99ec78aadced43', 'sql', 'add the missing entries in AUTH_USER for users that only exist in CORE_USER (eg a user created by LDAP)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-Mantis-7833::jprioux
--  Increase remote project id limit to 100 for redmine bt project keys
ALTER TABLE REQUIREMENT_SYNC_EXTENDER MODIFY REMOTE_PROJECT_ID VARCHAR(100);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-Mantis-7833', 'jprioux', 'tm/tm.changelog-1.19.0.xml', NOW(), 414, '8:bf7e3cd98a3544c6515edcf56cc27f1a', 'modifyDataType columnName=REMOTE_PROJECT_ID, tableName=REQUIREMENT_SYNC_EXTENDER', 'Increase remote project id limit to 100 for redmine bt project keys', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-536-autoexec-gherkin-1::bsiri
--  Add a flag to the test automation project that tells whether it is able to run Gherkin tests.
ALTER TABLE TEST_AUTOMATION_PROJECT ADD CAN_RUN_GHERKIN BIT(1) DEFAULT 0 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-536-autoexec-gherkin-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 415, '8:744d6d83f37e99e23cba94af126c24b5', 'addColumn tableName=TEST_AUTOMATION_PROJECT', 'Add a flag to the test automation project that tells whether it is able to run Gherkin tests.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-543-third-party-server-1::bsiri
--  Create the table THIRD_PARTY_SERVER
CREATE TABLE THIRD_PARTY_SERVER (SERVER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, autogenerated', NAME VARCHAR(50) NOT NULL COMMENT 'name of the server', URL VARCHAR(400) NOT NULL COMMENT 'the base url', AUTH_POLICY VARCHAR(30) DEFAULT 'USER' NULL COMMENT 'the policy that decides who needs to authenticate', AUTH_PROTOCOL VARCHAR(30) DEFAULT 'BASIC_AUTH' NOT NULL COMMENT 'the protocol that should be used for that server', CONSTRAINT PK_THIRD_PARTY_SERVER PRIMARY KEY (SERVER_ID)) COMMENT='base table for third party servers' ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-543-third-party-server-1', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 416, '8:ce4477c2e4c807d6dc8b136dc6bba2c9', 'createTable tableName=THIRD_PARTY_SERVER', 'Create the table THIRD_PARTY_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-543-third-party-server-2::bsiri
--  migrate data from table BUGTRACKER to table THIRD_PARTY_SERVER
insert into THIRD_PARTY_SERVER(SERVER_ID, NAME, URL, AUTH_POLICY, AUTH_PROTOCOL)
      select BUGTRACKER_ID, NAME, URL, AUTH_POLICY, AUTH_PROTOCOL
      from BUGTRACKER;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-543-third-party-server-2', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 417, '8:f06ca5fee15abe6e10e53e2847d0a3f3', 'sql', 'migrate data from table BUGTRACKER to table THIRD_PARTY_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-543-third-party-server-3::bsiri
--  Drop the now unused columns from BUGTRACKER and create the FK from BUGTRACKER to THIRD_PARTY_SERVER
ALTER TABLE BUGTRACKER DROP COLUMN NAME;

ALTER TABLE BUGTRACKER DROP COLUMN URL;

ALTER TABLE BUGTRACKER DROP COLUMN AUTH_POLICY;

ALTER TABLE BUGTRACKER DROP COLUMN AUTH_PROTOCOL;

ALTER TABLE BUGTRACKER ADD CONSTRAINT fk_bugtracker_third_party_server FOREIGN KEY (BUGTRACKER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-543-third-party-server-3', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 418, '8:0528f96f8480293d795ddda1dd55c913', 'dropColumn columnName=NAME, tableName=BUGTRACKER; dropColumn columnName=URL, tableName=BUGTRACKER; dropColumn columnName=AUTH_POLICY, tableName=BUGTRACKER; dropColumn columnName=AUTH_PROTOCOL, tableName=BUGTRACKER; addForeignKeyConstraint baseTabl...', 'Drop the now unused columns from BUGTRACKER and create the FK from BUGTRACKER to THIRD_PARTY_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-543-third-party-server-4::bsiri
--  change the foreign key stored_credentials -> bugtracker to stored_credentials -> third_party_server
ALTER TABLE STORED_CREDENTIALS DROP FOREIGN KEY fk_stored_credentials_authenticated_server;

CREATE INDEX idx_fk_stored_credentials_authenticated_server ON STORED_CREDENTIALS(AUTHENTICATED_SERVER);

ALTER TABLE STORED_CREDENTIALS ADD CONSTRAINT fk_stored_credentials_authenticated_server FOREIGN KEY (AUTHENTICATED_SERVER) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-543-third-party-server-4', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 419, '8:e97abf79dc8bc186c5d90e1ea4fe71fc', 'dropForeignKeyConstraint baseTableName=STORED_CREDENTIALS, constraintName=fk_stored_credentials_authenticated_server; createIndex indexName=idx_fk_stored_credentials_authenticated_server, tableName=STORED_CREDENTIALS; addForeignKeyConstraint baseT...', 'change the foreign key stored_credentials -> bugtracker to stored_credentials -> third_party_server', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-534-third-party-server-5-mysql::bsiri
--  For Mysql / Maria DB, remove the autoincrement on bugtracker_id
set foreign_key_checks=0;

alter table BUGTRACKER modify column BUGTRACKER_ID BIGINT not null;

set foreign_key_checks=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-534-third-party-server-5-mysql', 'bsiri', 'tm/tm.changelog-1.19.0.xml', NOW(), 420, '8:20978d49f03b16ebab5174b63af793a3', 'sql', 'For Mysql / Maria DB, remove the autoincrement on bugtracker_id', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-512-scm-server-management::jlor
--  Add new table for scm (source code management) server.
CREATE TABLE SCM_SERVER (SERVER_ID BIGINT NOT NULL COMMENT 'The id of the scm server.', KIND VARCHAR(30) NOT NULL COMMENT 'The kind of scm server.', CONSTRAINT PK_SCM_SERVER PRIMARY KEY (SERVER_ID)) ENGINE = INNODB;

ALTER TABLE SCM_SERVER ADD CONSTRAINT fk_scm_server_third_party_server FOREIGN KEY (SERVER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-512-scm-server-management', 'jlor', 'tm/tm.changelog-1.19.0.xml', NOW(), 421, '8:dc5c89d7514ccc3ed65c24da7b28c501', 'createTable tableName=SCM_SERVER; addForeignKeyConstraint baseTableName=SCM_SERVER, constraintName=fk_scm_server_third_party_server, referencedTableName=THIRD_PARTY_SERVER', 'Add new table for scm (source code management) server.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-512-scm-repository-management::jlor
--  Add new table for scm (source code management) repository.
CREATE TABLE SCM_REPOSITORY (SCM_REPOSITORY_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id of the scm repository.', SERVER_ID BIGINT NOT NULL COMMENT 'The foreign key to the related SCM_SEVER', NAME VARCHAR(255) NOT NULL COMMENT 'The name of the repository.', REPOSITORY_PATH VARCHAR(255) NOT NULL COMMENT 'The absolute path to the local repository on the local server.', WORKING_FOLDER_PATH VARCHAR(255) NULL COMMENT 'The relative path of the working folder in which SquashTM will push.', WORKING_BRANCH VARCHAR(255) NOT NULL COMMENT 'The name of the working branch on which SquashTM will push.', CONSTRAINT PK_SCM_REPOSITORY PRIMARY KEY (SCM_REPOSITORY_ID), CONSTRAINT fk_scm_repository_scm_server FOREIGN KEY (SERVER_ID) REFERENCES SCM_SERVER(SERVER_ID)) ENGINE = INNODB;

ALTER TABLE SCM_REPOSITORY ADD UNIQUE (NAME, SERVER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-512-scm-repository-management', 'jlor', 'tm/tm.changelog-1.19.0.xml', NOW(), 422, '8:1f223494883f21790714bfbcbe72a98f', 'createTable tableName=SCM_REPOSITORY; addUniqueConstraint tableName=SCM_REPOSITORY', 'Add new table for scm (source code management) repository.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-SQTM-512-project-scm-repository-binding::jlor
--  Add foreign key in project table to reference a scm (source code management) repository.
ALTER TABLE PROJECT ADD SCM_REPOSITORY_ID BIGINT NULL;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-SQTM-512-project-scm-repository-binding', 'jlor', 'tm/tm.changelog-1.19.0.xml', NOW(), 423, '8:51a65c795e339379daf7294e51333ef5', 'addColumn tableName=PROJECT', 'Add foreign key in project table to reference a scm (source code management) repository.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.19.0.xml::tm-1.19.0-Mantis-7547::jprioux
--  Increase remote req id limit to 50 for jira
ALTER TABLE REQUIREMENT_SYNC_EXTENDER MODIFY REMOTE_REQ_ID VARCHAR(50);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.19.0-Mantis-7547', 'jprioux', 'tm/tm.changelog-1.19.0.xml', NOW(), 424, '8:6126f9f59100826dc05c3555f38986a5', 'modifyDataType columnName=REMOTE_REQ_ID, tableName=REQUIREMENT_SYNC_EXTENDER', 'Increase remote req id limit to 50 for jira', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.20.0.xml', NOW(), 425, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.20.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0', 'jprioux', 'tm/tm.changelog-1.20.0.xml', NOW(), 426, '8:40a4910e6e1ed25cb552ea9738932b45', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-176-custom-report-custom-export::jlor
--  Create new object CustomExport in Custom Report Workspace
CREATE TABLE CUSTOM_REPORT_CUSTOM_EXPORT (CRCE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', NAME VARCHAR(255) NULL COMMENT 'The name of the Custom Export', PROJECT_ID BIGINT NOT NULL COMMENT 'Foreign key to the Project', CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, CONSTRAINT PK_CUSTOM_REPORT_CUSTOM_EXPORT PRIMARY KEY (CRCE_ID), CONSTRAINT fk_custom_export_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_custom_export_project_id ON CUSTOM_REPORT_CUSTOM_EXPORT(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-176-custom-report-custom-export', 'jlor', 'tm/tm.changelog-1.20.0.xml', NOW(), 427, '8:f7f4ef7509454043f88ab0a7e31c37cf', 'createTable tableName=CUSTOM_REPORT_CUSTOM_EXPORT; createIndex indexName=idx_fk_custom_export_project_id, tableName=CUSTOM_REPORT_CUSTOM_EXPORT', 'Create new object CustomExport in Custom Report Workspace', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-125-use-tm-tree-structure-in-scm-repository::jlor
--  Add an option in Project automation settings to use the tm tree structure when transmitting test cases to a scm repository
ALTER TABLE PROJECT ADD USE_TREE_STRUCTURE_IN_SCM_REPO BIT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-125-use-tm-tree-structure-in-scm-repository', 'jlor', 'tm/tm.changelog-1.20.0.xml', NOW(), 428, '8:57cc3d196516127155dcb5bf59c55623', 'addColumn tableName=PROJECT', 'Add an option in Project automation settings to use the tm tree structure when transmitting test cases to a scm repository', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-220-add-missing-role-automation::agu
--  Add missing automation role following changeset tm-1.19.0-SQTM-510-add-roles-automation
INSERT INTO CORE_PARTY_AUTHORITY(PARTY_ID, AUTHORITY)
      SELECT cpa.PARTY_ID, 'ROLE_TF_FUNCTIONAL_TESTER' from CORE_PARTY_AUTHORITY cpa
      INNER JOIN CORE_PARTY_AUTHORITY cpa2 on cpa.PARTY_ID = cpa2.PARTY_ID
      WHERE cpa.AUTHORITY = 'ROLE_TM_USER'
      GROUP BY cpa.PARTY_ID
      HAVING COUNT(cpa.PARTY_ID) = 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-220-add-missing-role-automation', 'agu', 'tm/tm.changelog-1.20.0.xml', NOW(), 429, '8:c3fa6d2a8e11cdb916bc12fba2e614a6', 'sql', 'Add missing automation role following changeset tm-1.19.0-SQTM-510-add-roles-automation', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-91-custom-export-column::jlor
--  Create new tables to store the scope and the columns of a custom export
CREATE TABLE CUSTOM_EXPORT_SCOPE (CUSTOM_EXPORT_ID BIGINT NOT NULL COMMENT 'Foreign key to the Custom Export', ENTITY_REFERENCE_TYPE VARCHAR(50) NULL, ENTITY_REFERENCE_ID BIGINT NULL, CONSTRAINT fk_custom_export_scope_custom_export_id FOREIGN KEY (CUSTOM_EXPORT_ID) REFERENCES CUSTOM_REPORT_CUSTOM_EXPORT (CRCE_ID)) ENGINE = INNODB;

CREATE TABLE CUSTOM_EXPORT_COLUMN (CUSTOM_EXPORT_ID BIGINT NOT NULL COMMENT 'Foreign key to the Custom Export', LABEL VARCHAR(255) NULL, CUF_ID BIGINT NULL, CONSTRAINT fk_custom_export_column_custom_export_id FOREIGN KEY (CUSTOM_EXPORT_ID) REFERENCES CUSTOM_REPORT_CUSTOM_EXPORT (CRCE_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-91-custom-export-column', 'jlor', 'tm/tm.changelog-1.20.0.xml', NOW(), 430, '8:8ab1ff8e93d87f1a9a392a91f2f40aee', 'createTable tableName=CUSTOM_EXPORT_SCOPE; createTable tableName=CUSTOM_EXPORT_COLUMN', 'Create new tables to store the scope and the columns of a custom export', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-13-add-conflict-association-ismanual::amk
ALTER TABLE AUTOMATION_REQUEST ADD CONFLICT_ASSOCIATION TEXT DEFAULT null NULL, ADD IS_MANUAL BIT(1) DEFAULT 0 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-13-add-conflict-association-ismanual', 'amk', 'tm/tm.changelog-1.20.0.xml', NOW(), 431, '8:512da79f1ba13b4d90f93330f55e4857', 'addColumn tableName=AUTOMATION_REQUEST', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-13-update-is-manual::amk
UPDATE AUTOMATION_REQUEST ar SET IS_MANUAL = true
      WHERE TEST_CASE_ID in (SELECT tc.TCLN_ID FROM TEST_CASE tc WHERE ar.TEST_CASE_ID = tc.TCLN_ID AND tc.TA_TEST IS NOT null);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-13-update-is-manual', 'amk', 'tm/tm.changelog-1.20.0.xml', NOW(), 432, '8:8f1f6b0e92ea901ba36e05c5e8c5f284', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-13-association-auto-cdt-script-auto::amk
ALTER TABLE TEST_CASE ADD UUID VARCHAR(36) NULL;

ALTER TABLE TEST_CASE ADD CONSTRAINT uc_test_case_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-13-association-auto-cdt-script-auto', 'amk', 'tm/tm.changelog-1.20.0.xml', NOW(), 433, '8:cc29599f706535058f452efde830f808', 'addColumn tableName=TEST_CASE; addUniqueConstraint constraintName=uc_test_case_uuid, tableName=TEST_CASE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-13-update-uuid-mysql::amk
--  generate uuid if it's null
UPDATE TEST_CASE SET UUID =  uuid() WHERE UUID is NULL;

ALTER TABLE TEST_CASE MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-13-update-uuid-mysql', 'amk', 'tm/tm.changelog-1.20.0.xml', NOW(), 434, '8:d7350144f0a4ef6254338b0ae64c8761', 'sql', 'generate uuid if it''s null', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-503-clean-campaign-test-plan-item-table::aguilhem
--  Clean CAMPAIGN_TEST_PLAN_ITEM table from line with null value in CAMPAIGN_ID
DELETE FROM CAMPAIGN_TEST_PLAN_ITEM WHERE CAMPAIGN_ID IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-503-clean-campaign-test-plan-item-table', 'aguilhem', 'tm/tm.changelog-1.20.0.xml', NOW(), 435, '8:543a8baa8a796d8a02bda9e1481eb5c3', 'sql', 'Clean CAMPAIGN_TEST_PLAN_ITEM table from line with null value in CAMPAIGN_ID', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-180::abo
--  Change dataType for RequirementStatus
UPDATE CHART_COLUMN_PROTOTYPE SET DATA_TYPE = 'REQUIREMENT_STATUS'
      WHERE LABEL = 'REQUIREMENT_STATUS' OR LABEL = 'REQUIREMENT_VERSION_STATUS';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-180', 'abo', 'tm/tm.changelog-1.20.0.xml', NOW(), 436, '8:fae81432b7f1592c40f09cc4a8a3671d', 'sql', 'Change dataType for RequirementStatus', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-00::bsiri
--  Preparatory step : dropping foreign keys pointing to CHART_QUERY and CHART_COLUMN_PROTOTYPE.
ALTER TABLE CHART_DEFINITION DROP FOREIGN KEY fk_chart_query;

ALTER TABLE CHART_COLUMN_PROTOTYPE DROP FOREIGN KEY fk_column_query;

ALTER TABLE CHART_AXIS_COLUMN DROP FOREIGN KEY fk_chart_axis_chart_query;

ALTER TABLE CHART_FILTER DROP FOREIGN KEY fk_chart_FILTER_chart_query;

ALTER TABLE CHART_MEASURE_COLUMN DROP FOREIGN KEY fk_chart_measure_chart_query;

ALTER TABLE CHART_COLUMN_ROLE DROP FOREIGN KEY fk_column_role_chart_column;

ALTER TABLE CHART_AXIS_COLUMN DROP FOREIGN KEY fk_axis_column_chart_column;

ALTER TABLE CHART_FILTER DROP FOREIGN KEY fk_chart_filter_chart_column;

ALTER TABLE CHART_MEASURE_COLUMN DROP FOREIGN KEY fk_chart_measure_chart_column;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-00', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 437, '8:1a34d66e86ff4d4792fd83f59f6b4f7e', 'dropForeignKeyConstraint baseTableName=CHART_DEFINITION, constraintName=fk_chart_query; dropForeignKeyConstraint baseTableName=CHART_COLUMN_PROTOTYPE, constraintName=fk_column_query; dropForeignKeyConstraint baseTableName=CHART_AXIS_COLUMN, constr...', 'Preparatory step : dropping foreign keys pointing to CHART_QUERY and CHART_COLUMN_PROTOTYPE.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-01b-mysql::bsiri
--  Rename CHART_QUERY and CHART_COLUMN_PROTOTYPE and their primary keys
ALTER TABLE CHART_QUERY RENAME QUERY_MODEL;

ALTER TABLE CHART_COLUMN_PROTOTYPE RENAME QUERY_COLUMN_PROTOTYPE;

ALTER TABLE QUERY_MODEL CHANGE CHART_QUERY_ID QUERY_MODEL_ID BIGINT;

ALTER TABLE QUERY_COLUMN_PROTOTYPE CHANGE CHART_COLUMN_ID QUERY_COLUMN_ID BIGINT;

ALTER TABLE QUERY_MODEL MODIFY QUERY_MODEL_ID BIGINT AUTO_INCREMENT;

ALTER TABLE QUERY_COLUMN_PROTOTYPE MODIFY QUERY_COLUMN_ID BIGINT AUTO_INCREMENT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-01b-mysql', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 438, '8:354101a838039ece2fa9ef61df1babfe', 'renameTable newTableName=QUERY_MODEL, oldTableName=CHART_QUERY; renameTable newTableName=QUERY_COLUMN_PROTOTYPE, oldTableName=CHART_COLUMN_PROTOTYPE; renameColumn newColumnName=QUERY_MODEL_ID, oldColumnName=CHART_QUERY_ID, tableName=QUERY_MODEL; r...', 'Rename CHART_QUERY and CHART_COLUMN_PROTOTYPE and their primary keys', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-01c::bsiri
--  Adding unique constraint on QUERY_COLUMN_PROTOTYPE.LABEL since its likely to act as
--    		a surrogate primary key.
ALTER TABLE QUERY_COLUMN_PROTOTYPE MODIFY LABEL VARCHAR(255) NOT NULL;

ALTER TABLE QUERY_COLUMN_PROTOTYPE ADD UNIQUE (LABEL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-01c', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 439, '8:0838e295a67421777980d4cf6f27687d', 'addNotNullConstraint columnName=LABEL, tableName=QUERY_COLUMN_PROTOTYPE; addUniqueConstraint tableName=QUERY_COLUMN_PROTOTYPE', 'Adding unique constraint on QUERY_COLUMN_PROTOTYPE.LABEL since its likely to act as
  		a surrogate primary key.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-02::bsiri
--  Create the new tables that hosts the query components.
--  This table define which columns are part of tuple returned by a query.
--  This table indicates which projected columns are aggregated on for a given query.
--  This table defines the columns on which one want to filter the data.
--  This table holds the values used by a QUERY_FILTER_COLUMN.
--  This table indicates how the projected columns are ordered.
CREATE TABLE QUERY_PROJECTION_COLUMN (QUERY_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to the QUERY_COLUMN_PROTOTYPE this projection applies to', QUERY_MODEL_ID BIGINT NOT NULL COMMENT 'foreign key to a QUERY_MODEL', LABEL VARCHAR(30) NULL COMMENT 'A label for this projected column. Will override the default label of the column prototype if non null.', PROJECTION_OPERATION VARCHAR(20) NULL COMMENT 'the operation applied to the column, if any.', PROJECTION_RANK INT NULL COMMENT 'the order in which this projected column in the returned tuple.', CUF_ID BIGINT NULL COMMENT 'the custom field id for this projection column, if the referenced column is a custom field.', CONSTRAINT fk_query_projection_query_model FOREIGN KEY (QUERY_MODEL_ID) REFERENCES QUERY_MODEL(QUERY_MODEL_ID), CONSTRAINT fk_query_projection_query_column FOREIGN KEY (QUERY_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE(QUERY_COLUMN_ID)) ENGINE = INNODB;

CREATE TABLE QUERY_AGGREGATION_COLUMN (QUERY_MODEL_ID BIGINT NOT NULL COMMENT 'foreign key to a QUERY_MODEL. ', QUERY_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to the QUERY_COLUMN_PROTOTYPE which must be aggregated on', LABEL VARCHAR(30) NULL COMMENT 'A label for this projected column. Will override the default label of the column prototype if non null.', AGGREGATION_OPERATION VARCHAR(20) NULL COMMENT 'the operation applied to the column, if any.', AGGREGATION_RANK INT NULL COMMENT 'the order in which this projected column in the returned tuple.', CUF_ID BIGINT NULL COMMENT 'the custom field id for this projection column, if the referenced column is a custom field.', CONSTRAINT fk_query_aggr_query_column FOREIGN KEY (QUERY_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE(QUERY_COLUMN_ID), CONSTRAINT fk_query_aggr_query_model FOREIGN KEY (QUERY_MODEL_ID) REFERENCES QUERY_MODEL(QUERY_MODEL_ID)) ENGINE = INNODB;

CREATE TABLE QUERY_FILTER_COLUMN (QUERY_FILTER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'autogenerated ID', QUERY_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to a QUERY_COLUMN_PROTOTYPE', QUERY_MODEL_ID BIGINT NOT NULL COMMENT 'foreign key to a QUERY_MODEL', FILTER_OPERATION VARCHAR(20) NULL COMMENT 'a comparison operator', CUF_ID BIGINT NULL COMMENT 'the custom field id for this filter column, if the referenced column is a custom field.', CONSTRAINT PK_QUERY_FILTER_COLUMN PRIMARY KEY (QUERY_FILTER_ID), CONSTRAINT fk_query_filter_query_model FOREIGN KEY (QUERY_MODEL_ID) REFERENCES QUERY_MODEL(QUERY_MODEL_ID), CONSTRAINT fk_query_filter_query_column FOREIGN KEY (QUERY_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE(QUERY_COLUMN_ID)) ENGINE = INNODB;

CREATE INDEX idx_query_filter ON QUERY_FILTER_COLUMN(QUERY_FILTER_ID);

CREATE TABLE QUERY_FILTER_VALUES (QUERY_FILTER_ID BIGINT NOT NULL COMMENT 'foreign key to QUERY_FILTER_COLUMN', FILTER_VALUE VARCHAR(255) NULL COMMENT 'a value for this filter', CONSTRAINT fk_query_filter_value_query_filter FOREIGN KEY (QUERY_FILTER_ID) REFERENCES QUERY_FILTER_COLUMN(QUERY_FILTER_ID)) ENGINE = INNODB;

CREATE TABLE QUERY_ORDERING_COLUMN (QUERY_MODEL_ID BIGINT NOT NULL COMMENT 'foreign key to a QUERY_MODEL. Note that this is a denormalization : that value could be retrieved via the referenced projection column', QUERY_COLUMN_ID BIGINT NOT NULL COMMENT 'foreign key to the QUERY_COLUMN_PROTOTYPE which must be ordered', ORDER_OPERATION VARCHAR(20) NULL COMMENT 'the operation applied to the column, if any. It must mirror the operation applied to the column they reference in the projection/aggregation clause.', ORDER_RANK INT NULL COMMENT 'the order in which this ordering instruction must be treated.', ORDER_DIR CHAR(3) DEFAULT 'ASC' NULL COMMENT 'either ASC or DESC', CUF_ID BIGINT NULL COMMENT 'the custom field id for this filter column, if the referenced column is a custom field.', CONSTRAINT fk_query_order_query_column FOREIGN KEY (QUERY_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE(QUERY_COLUMN_ID), CONSTRAINT fk_query_order_query_model FOREIGN KEY (QUERY_MODEL_ID) REFERENCES QUERY_MODEL(QUERY_MODEL_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-02', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 440, '8:832719b04afe3992b84846699fec71c0', 'createTable tableName=QUERY_PROJECTION_COLUMN; createTable tableName=QUERY_AGGREGATION_COLUMN; createTable tableName=QUERY_FILTER_COLUMN; createIndex indexName=idx_query_filter, tableName=QUERY_FILTER_COLUMN; createTable tableName=QUERY_FILTER_VAL...', 'Create the new tables that hosts the query components.
This table define which columns are part of tuple returned by a query.
This table indicates which projected columns are aggregated on for a given query.
This table defines the columns on which...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-03::bsiri
--  Now the fun part : migrate the former content into the new content
-- --------------------
      -- migration of axis --
      -- --------------------

      insert into QUERY_AGGREGATION_COLUMN (query_model_id, label, aggregation_operation, aggregation_rank, cuf_id, query_column_id)
      select cac.query_id, cac.label, cac.axis_operation, cac.axis_rank, cac.cuf_id, cac.chart_column_id
      from CHART_AXIS_COLUMN cac
      inner join QUERY_MODEL qm on cac.query_id = qm.query_model_id
      where qm.strategy != 'MAIN';

insert into QUERY_ORDERING_COLUMN (query_model_id, query_column_id, order_rank, order_dir, cuf_id, order_operation)
      select qac.query_model_id, qac.query_column_id, qac.aggregation_rank, 'ASC', qac.cuf_id, qac.aggregation_operation
      from QUERY_AGGREGATION_COLUMN qac;

-- ------------------------
      -- migration of measures --
      -- ------------------------

      insert into QUERY_PROJECTION_COLUMN (query_column_id, query_model_id, label, projection_operation, cuf_id, projection_rank)
      select cmc.chart_column_id, cmc.query_id, cmc.label, cmc.measure_operation, cmc.cuf_id, cmc.measure_rank
      from CHART_MEASURE_COLUMN cmc
      inner join QUERY_MODEL qm on cmc.query_id = qm.query_model_id
      where qm.strategy != 'MAIN';

insert into QUERY_ORDERING_COLUMN(query_model_id, query_column_id, order_dir, cuf_id, order_operation, order_rank)
      select cmc.query_id, cmc.chart_column_id, 'ASC', cmc.cuf_id, cmc.measure_operation, cmc.measure_rank + (
        select count(*) from CHART_AXIS_COLUMN cac where cac.query_id = cmc.query_id
      ) as adjust_rank
      from CHART_MEASURE_COLUMN cmc
      inner join QUERY_MODEL qm on cmc.query_id = qm.query_model_id
      where qm.strategy != 'MAIN';

-- -----------------------
      -- migration of filters --
      -- -----------------------

      insert into QUERY_FILTER_COLUMN (query_column_id, query_model_id, filter_operation, cuf_id)
      select cfc.chart_column_id, cfc.query_id, cfc.filter_operation, cfc.cuf_id
      from CHART_FILTER cfc
      inner join QUERY_MODEL qm on cfc.query_id = qm.query_model_id
      where qm.strategy != 'MAIN';

insert into QUERY_FILTER_VALUES (filter_value, query_filter_id)
      select cfv.filter_value, qfc.query_filter_id
      from CHART_FILTER_VALUES cfv
      inner join CHART_FILTER cfc on cfv.filter_id = cfc.filter_id
      inner join QUERY_MODEL qm on cfc.query_id = qm.query_model_id
      inner join QUERY_FILTER_COLUMN qfc on (
        cfc.chart_column_id = qfc.query_column_id and
        cfc.query_id = qfc.query_model_id and
        cfc.filter_operation = qfc.filter_operation
      )
      where qm.strategy != 'MAIN';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-03', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 441, '8:887d59d3b19a71e685aa3b4180e9066d', 'sql', 'Now the fun part : migrate the former content into the new content', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-04a::bsiri
--  Creating the new foreign keys from CHART_X_COLUMNS tables, to CHART_DEFINITION. Initially nullable.
ALTER TABLE CHART_AXIS_COLUMN ADD CHART_DEFINITION_ID BIGINT NULL COMMENT 'foreign key to the chart_definition';

ALTER TABLE CHART_AXIS_COLUMN ADD CONSTRAINT fk_chart_axis_chart_def FOREIGN KEY (CHART_DEFINITION_ID) REFERENCES CHART_DEFINITION (CHART_ID);

ALTER TABLE CHART_FILTER ADD CHART_DEFINITION_ID BIGINT NULL COMMENT 'foreign key to the chart_definition';

ALTER TABLE CHART_FILTER ADD CONSTRAINT fk_chart_filter_chart_def FOREIGN KEY (CHART_DEFINITION_ID) REFERENCES CHART_DEFINITION (CHART_ID);

ALTER TABLE CHART_MEASURE_COLUMN ADD CHART_DEFINITION_ID BIGINT NULL COMMENT 'foreign key to the chart_definition';

ALTER TABLE CHART_MEASURE_COLUMN ADD CONSTRAINT fk_chart_meas_chart_def FOREIGN KEY (CHART_DEFINITION_ID) REFERENCES CHART_DEFINITION (CHART_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-04a', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 442, '8:5c7c1eccf7a59321ea28a78ecabf7d2e', 'addColumn tableName=CHART_AXIS_COLUMN; addColumn tableName=CHART_FILTER; addColumn tableName=CHART_MEASURE_COLUMN', 'Creating the new foreign keys from CHART_X_COLUMNS tables, to CHART_DEFINITION. Initially nullable.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-04b::bsiri
--  Populating the new foreign keys from the tables CHART_X_COLUMN  to CHART_DEFINITION
update CHART_AXIS_COLUMN cac
      set cac.chart_definition_id = (
      select cd.chart_id
      from QUERY_MODEL qm
      inner join CHART_DEFINITION cd on qm.query_model_id = cd.query_id
      where qm.strategy = 'MAIN'
      and cac.query_id = qm.query_model_id
      );

update CHART_FILTER cf
      set cf.chart_definition_id = (
      select cd.chart_id
      from QUERY_MODEL qm
      inner join CHART_DEFINITION cd on qm.query_model_id = cd.query_id
      where qm.strategy = 'MAIN'
      and cf.query_id = qm.query_model_id
      );

update CHART_MEASURE_COLUMN cmc
      set cmc.chart_definition_id = (
      select cd.chart_id
      from QUERY_MODEL qm
      inner join CHART_DEFINITION cd on qm.query_model_id = cd.query_id
      where qm.strategy = 'MAIN'
      and cmc.query_id = qm.query_model_id
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-04b', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 443, '8:bc982fa1e771287e287bd82f5b0f201b', 'sql', 'Populating the new foreign keys from the tables CHART_X_COLUMN  to CHART_DEFINITION', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-04c::bsiri
--  Deleting the former referential data (that now exist in the new QUERY_X tables)
--  also delete the former QUERY_MODELs that previously had user data,
--        because now the CHART_X_COLUMNS now solely rely on their CHART_DEFINITION
delete from CHART_FILTER_VALUES
      where filter_id in (
      select filter_id from CHART_FILTER where chart_definition_id is null
      );

delete from CHART_FILTER where chart_definition_id is null;

delete from CHART_AXIS_COLUMN where chart_definition_id is null;

delete from CHART_MEASURE_COLUMN where chart_definition_id is null;

delete from QUERY_MODEL where strategy = 'MAIN';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-04c', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 444, '8:fdbd961549d616f6d0a079569fe07518', 'sql; sql', 'Deleting the former referential data (that now exist in the new QUERY_X tables)
also delete the former QUERY_MODELs that previously had user data,
      because now the CHART_X_COLUMNS now solely rely on their CHART_DEFINITION', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-04d::bsiri
--  Now dropping the now useless columns that pointed to QUERY_MODEL
ALTER TABLE CHART_AXIS_COLUMN DROP COLUMN QUERY_ID;

ALTER TABLE CHART_FILTER DROP COLUMN QUERY_ID;

ALTER TABLE CHART_MEASURE_COLUMN DROP COLUMN QUERY_ID;

ALTER TABLE CHART_DEFINITION DROP COLUMN QUERY_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-04d', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 445, '8:3ce40d83b308578a642dcc9906ca0f3d', 'dropColumn columnName=QUERY_ID, tableName=CHART_AXIS_COLUMN; dropColumn columnName=QUERY_ID, tableName=CHART_FILTER; dropColumn columnName=QUERY_ID, tableName=CHART_MEASURE_COLUMN; dropColumn columnName=QUERY_ID, tableName=CHART_DEFINITION', 'Now dropping the now useless columns that pointed to QUERY_MODEL', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-05::bsiri
--  Rewiring the remaining foreign keys.
ALTER TABLE QUERY_COLUMN_PROTOTYPE ADD CONSTRAINT fk_query_col_query_model FOREIGN KEY (SUBQUERY_ID) REFERENCES QUERY_MODEL (QUERY_MODEL_ID);

ALTER TABLE CHART_COLUMN_ROLE ADD CONSTRAINT fk_column_role_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE (QUERY_COLUMN_ID);

ALTER TABLE CHART_AXIS_COLUMN ADD CONSTRAINT fk_axis_column_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE (QUERY_COLUMN_ID);

ALTER TABLE CHART_FILTER ADD CONSTRAINT fk_chart_filter_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE (QUERY_COLUMN_ID);

ALTER TABLE CHART_MEASURE_COLUMN ADD CONSTRAINT fk_chart_measure_chart_column FOREIGN KEY (CHART_COLUMN_ID) REFERENCES QUERY_COLUMN_PROTOTYPE (QUERY_COLUMN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-05', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 446, '8:9884b527e4d8e3a558375cf9f9ce7c26', 'addForeignKeyConstraint baseTableName=QUERY_COLUMN_PROTOTYPE, constraintName=fk_query_col_query_model, referencedTableName=QUERY_MODEL; addForeignKeyConstraint baseTableName=CHART_COLUMN_ROLE, constraintName=fk_column_role_chart_column, referenced...', 'Rewiring the remaining foreign keys.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-06::bsiri
--  Inserting now the new columns and querymodels in the database
--  For the subqueries we have to use (w)hacky SQL. This is because we need to select-insert from no table,
--      which is supported with specific syntax by each table but aren't compatible together (we would need to
--        'select from dual' in postgresql for example).
-- ----------------------------------------------- --
      -- Inserting first the attribute columns. Some of  --
      -- them will be used in new query models, declared --
      -- just after them.                                --
      -- 												 --
      -- Also the first new columns declared are Entity  --
      -- columns : they represent the entity itself and  --
      -- have a COLUMN_TYPE = 'ENTITY'. Only the most 	 --
      -- common entities are represented, entities like  --
      -- RequirementVersionCoverage (for example) aren't --
      -- declared.
      -- ----------------------------------------------- --

      INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS) VALUES

      ('ENTITY', 'REQUIREMENT', NULL, 'REQUIREMENT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'REQUIREMENT_VERSION', NULL, 'REQUIREMENT_VERSION_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'TEST_CASE', NULL, 'TEST_CASE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'CAMPAIGN', NULL, 'CAMPAIGN_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ITERATION', NULL, 'ITERATION_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ITEM_TEST_PLAN', NULL, 'ITEM_TEST_PLAN_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'EXECUTION', NULL, 'EXECUTION_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ISSUE', NULL, 'ISSUE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'TEST_CASE_STEP', NULL, 'TEST_CASE_STEP_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'INFO_LIST_ITEM', 'TEST_CASE_NATURE', 'TEST_CASE_NATURE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'INFO_LIST_ITEM', 'TEST_CASE_TYPE', 'TEST_CASE_TYPE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'INFO_LIST_ITEM', 'REQUIREMENT_VERSION_CATEGORY', 'REQUIREMENT_VERSION_CATEGORY_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER', 'ITERATION_TEST_PLAN_ASSIGNED_USER_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'MILESTONE', 'TEST_CASE_MILESTONE', 'TEST_CASE_MILESTONE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'REQUIREMENT_VERSION_MILESTONE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'CAMPAIGN_MILESTONE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'AUTOMATED_TEST', NULL, 'AUTOMATED_TEST_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'AUTOMATED_EXECUTION_EXTENDER', NULL, 'AUTOMATED_EXECUTION_EXTENDER_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ATTACHMENT_LIST', 'TEST_CASE_ATTLIST', 'TEST_CASE_ATTLIST_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ATTACHMENT_LIST', 'REQUIREMENT_VERSION_ATTLIST', 'REQUIREMENT_VERSION_ATTLIST_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ATTACHMENT_LIST', 'CAMPAIGN_ATTLIST', 'CAMPAIGN_ATTLIST_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ATTACHMENT', 'TEST_CASE_ATTACHMENT', 'TEST_CASE_ATTACHMENT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ATTACHMENT', 'CAMPAIGN_ATTACHMENT', 'CAMPAIGN_ATTACHMENT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'ATTACHMENT', 'REQUIREMENT_VERSION_ATTACHMENT', 'REQUIREMENT_VERSION_ATTACHMENT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'DATASET', NULL, 'DATASET_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'PARAMETER', NULL, 'PARAMETER_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'PROJECT', 'TEST_CASE_PROJECT', 'TEST_CASE_PROJECT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'PROJECT', 'REQUIREMENT_PROJECT', 'REQUIREMENT_PROJECT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'PROJECT', 'CAMPAIGN_PROJECT', 'CAMPAIGN_PROJECT_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'TEST_SUITE', 'ITEM_SUITE', 'ITEM_SUITE_ENTITY', NULL, 'ENTITY', FALSE),
      ('ENTITY', 'AUTOMATION_REQUEST', NULL, 'AUTOMATION_REQUEST_ENTITY', NULL, 'ENTITY', FALSE),


      ('ATTRIBUTE', 'MILESTONE', 'CAMPAIGN_MILESTONE', 'CAMPAIGN_MILESTONE_LABEL', 'label', 'STRING', FALSE),


      ('ATTRIBUTE', 'PROJECT', 'TEST_CASE_PROJECT', 'TEST_CASE_PROJECT_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'PROJECT', 'TEST_CASE_PROJECT', 'TEST_CASE_PROJECT_NAME', 'name', 'STRING', FALSE),
      ('ATTRIBUTE', 'PROJECT', 'REQUIREMENT_PROJECT', 'REQUIREMENT_PROJECT_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'PROJECT', 'REQUIREMENT_PROJECT', 'REQUIREMENT_PROJECT_NAME', 'name', 'STRING', FALSE),
      ('ATTRIBUTE', 'PROJECT', 'CAMPAIGN_PROJECT', 'CAMPAIGN_PROJECT_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'PROJECT', 'CAMPAIGN_PROJECT', 'CAMPAIGN_PROJECT_NAME', 'name', 'STRING', FALSE),


      ('ATTRIBUTE', 'ATTACHMENT_LIST', 'TEST_CASE_ATTLIST', 'TEST_CASE_ATTLIST_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'ATTACHMENT_LIST', 'REQUIREMENT_VERSION_ATTLIST', 'REQUIREMENT_VERSION_ATTLIST_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'ATTACHMENT_LIST', 'CAMPAIGN_ATTLIST', 'CAMPAIGN_ATTLIST_ID', 'id', 'NUMERIC', FALSE),

      ('ATTRIBUTE', 'ATTACHMENT', 'TEST_CASE_ATTACHMENT', 'TEST_CASE_ATTACHMENT_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'ATTACHMENT', 'REQUIREMENT_VERSION_ATTACHMENT', 'REQUIREMENT_VERSION_ATTACHMENT_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'ATTACHMENT', 'CAMPAIGN_ATTACHMENT', 'CAMPAIGN_ATTACHMENT_ID', 'id', 'NUMERIC', FALSE),

      ('ATTRIBUTE', 'DATASET', NULL, 'DATASET_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'PARAMETER', NULL, 'PARAMETER_ID', 'id', 'NUMERIC', FALSE),

      ('ATTRIBUTE', 'MILESTONE', 'TEST_CASE_MILESTONE',   'TEST_CASE_MILESTONE_STATUS', 'status', 'LEVEL_ENUM', FALSE),
      ('ATTRIBUTE', 'MILESTONE', 'TEST_CASE_MILESTONE',   'TEST_CASE_MILESTONE_END_DATE', 'endDate', 'DATE', FALSE),
      ('ATTRIBUTE', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'REQUIREMENT_VERSION_MILESTONE_STATUS', 'status', 'LEVEL_ENUM', FALSE),
      ('ATTRIBUTE', 'MILESTONE', 'REQUIREMENT_VERSION_MILESTONE', 'REQUIREMENT_VERSION_MILESTONE_END_DATE', 'endDate', 'DATE', FALSE),
      ('ATTRIBUTE', 'MILESTONE', 'CAMPAIGN_MILESTONE',    'CAMPAIGN_MILESTONE_STATUS', 'status', 'LEVEL_ENUM', FALSE),
      ('ATTRIBUTE', 'MILESTONE', 'CAMPAIGN_MILESTONE',    'CAMPAIGN_MILESTONE_END_DATE', 'endDate', 'DATE', FALSE),

      ('ATTRIBUTE', 'AUTOMATION_REQUEST', NULL, 'AUTOMATION_REQUEST_ID', 'id', 'NUMERIC', FALSE),
      ('ATTRIBUTE', 'AUTOMATION_REQUEST', NULL, 'AUTOMATION_REQUEST_STATUS', 'requestStatus', 'LEVEL_ENUM', FALSE),

      ('ATTRIBUTE', 'REQUIREMENT_VERSION', NULL, 'REQUIREMENT_VERSION_NAME', 'name', 'STRING', FALSE),
      ('ATTRIBUTE', 'REQUIREMENT_VERSION', NULL, 'REQUIREMENT_VERSION_DESCRIPTION', 'description', 'STRING', FALSE),

      ('ATTRIBUTE', 'TEST_CASE', NULL, 'TEST_CASE_NAME', 'name', 'STRING', FALSE),
      ('ATTRIBUTE', 'TEST_CASE', NULL, 'TEST_CASE_DESCRIPTION', 'description', 'STRING', FALSE),
      ('ATTRIBUTE', 'TEST_CASE', NULL, 'TEST_CASE_KIND', 'kind', 'LEVEL_ENUM', FALSE),
      ('ATTRIBUTE', 'TEST_CASE', NULL, 'TEST_CASE_PREQUISITE', 'prerequisite', 'STRING', FALSE),
      ('ATTRIBUTE', 'TEST_CASE', NULL, 'TEST_CASE_AUTOMATABLE', 'automatable', 'LEVEL_ENUM', FALSE),

      ('ATTRIBUTE', 'CAMPAIGN', NULL, 'CAMPAIGN_NAME', 'name', 'STRING', FALSE),

      ('ATTRIBUTE', 'ITERATION', NULL, 'ITERATION_NAME', 'name', 'STRING', FALSE),

      ('ATTRIBUTE', 'TEST_SUITE', 'ITEM_SUITE', 'ITEM_SUITE_ID', 'id', 'NUMERIC', FALSE),

      ('ATTRIBUTE', 'EXECUTION', NULL, 'EXECUTION_EXECUTION_MODE', 'executionMode', 'LEVEL_ENUM', FALSE),
      ('ATTRIBUTE', 'EXECUTION', NULL, 'EXECUTION_LAST_EXECUTED_ON', 'lastExecutedOn', 'DATE', FALSE),

      ('ATTRIBUTE', 'EXECUTION', NULL, 'ITEM_TEST_PLAN_LASTEXECBY', 'lastExecutedBy', 'STRING', FALSE);

-- ----------------------------------------------- --
      -- Inserting subqueries that implement the         --
      -- 'CALCULATED' columns defined right after them   --
      -- ----------------------------------------------- --


      -- requirement version attachment count subquery
      -- the inserts follow the order : query_model, aggregation, projection and finally the query_column_prototype

      INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) values ('REQUIREMENT_VERSION_ATTCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, AGGREGATION_OPERATION, AGGREGATION_RANK)
        select
          (select max(QUERY_MODEL_ID) from QUERY_MODEL),
          (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'REQUIREMENT_VERSION_ID'),
          'NONE', 0
        from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, PROJECTION_OPERATION, PROJECTION_RANK)
        select
          (select max(QUERY_MODEL_ID) from QUERY_MODEL),
          (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'REQUIREMENT_VERSION_ATTACHMENT_ID'),
          'COUNT', 0
        from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS, SUBQUERY_ID)
        select
          'CALCULATED', 'REQUIREMENT_VERSION', NULL, 'REQUIREMENT_VERSION_ATTCOUNT', 'count(attachment)', 'NUMERIC', FALSE,
          (select max(QUERY_MODEL_ID) from QUERY_MODEL)
        from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

-- test case attachment count subquery
      -- the inserts follow the order : query_model, aggregation, projection and finally the query_column_prototype

      INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) values ('TEST_CASE_ATTCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, AGGREGATION_OPERATION, AGGREGATION_RANK)
        select
          (select max(QUERY_MODEL_ID) from QUERY_MODEL),
          (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
          'NONE', 0
        from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, PROJECTION_OPERATION, PROJECTION_RANK)
        select
          (select max(QUERY_MODEL_ID) from QUERY_MODEL),
          (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ATTACHMENT_ID'),
          'COUNT', 0
        from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS, SUBQUERY_ID)
      select
      'CALCULATED', 'TEST_CASE', NULL, 'TEST_CASE_ATTCOUNT', 'count(attachment)', 'NUMERIC', FALSE,
      (select max(QUERY_MODEL_ID) from QUERY_MODEL)
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

-- test case parameter count subquery
      -- the inserts follow the order : query_model, aggregation, projection and finally the query_column_prototype

      INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) values ('TEST_CASE_PARAMCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, AGGREGATION_OPERATION, AGGREGATION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
      'NONE', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, PROJECTION_OPERATION, PROJECTION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'PARAMETER_ID'),
      'COUNT', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS, SUBQUERY_ID)
      select
      'CALCULATED', 'TEST_CASE', NULL, 'TEST_CASE_PARAMCOUNT', 'count(parameter)', 'NUMERIC', FALSE,
      (select max(QUERY_MODEL_ID) from QUERY_MODEL)
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

-- test case dataset count subquery
      -- the inserts follow the order : query_model, aggregation, projection and finally the query_column_prototype

      INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) values ('TEST_CASE_DATASETCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, AGGREGATION_OPERATION, AGGREGATION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
      'NONE', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, PROJECTION_OPERATION, PROJECTION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'DATASET_ID'),
      'COUNT', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS, SUBQUERY_ID)
      select
      'CALCULATED', 'TEST_CASE', NULL, 'TEST_CASE_DATASETCOUNT', 'count(dataset)', 'NUMERIC', FALSE,
      (select max(QUERY_MODEL_ID) from QUERY_MODEL)
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

-- item suite count subquery
      -- the inserts follow the order : query_model, aggregation, projection and finally the query_column_prototype

      INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) values ('ITEM_TEST_PLAN_SUITECOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, AGGREGATION_OPERATION, AGGREGATION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'ITEM_TEST_PLAN_ID'),
      'NONE', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, PROJECTION_OPERATION, PROJECTION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'ITEM_SUITE_ID'),
      'COUNT', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS, SUBQUERY_ID)
      select
      'CALCULATED', 'ITEM_TEST_PLAN', NULL, 'ITEM_TEST_PLAN_SUITECOUNT', 'count(testSuites)', 'NUMERIC', FALSE,
      (select max(QUERY_MODEL_ID) from QUERY_MODEL)
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

-- item dataset count subquery
      -- the inserts follow the order : query_model, aggregation, projection and finally the query_column_prototype

      INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) values ('ITEM_TEST_PLAN_DSCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, AGGREGATION_OPERATION, AGGREGATION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'ITEM_TEST_PLAN_ID'),
      'NONE', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, PROJECTION_OPERATION, PROJECTION_RANK)
      select
      (select max(QUERY_MODEL_ID) from QUERY_MODEL),
      (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'DATASET_ID'),
      'COUNT', 0
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS, SUBQUERY_ID)
      select
      'CALCULATED', 'ITEM_TEST_PLAN', NULL, 'ITEM_TEST_PLAN_DSCOUNT', 'count(datasets)', 'NUMERIC', FALSE,
      (select max(QUERY_MODEL_ID) from QUERY_MODEL)
      from QUERY_COLUMN_PROTOTYPE where query_column_id = 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-06', 'bsiri', 'tm/tm.changelog-1.20.0.xml', NOW(), 447, '8:9ae050474bd9ce20d62e8fea9039fc4e', 'sql', 'Inserting now the new columns and querymodels in the database
For the subqueries we have to use (w)hacky SQL. This is because we need to select-insert from no table,
    which is supported with specific syntax by each table but aren''t compatible t...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::create_index_fulltext_mysql::abo
--  Create fulltext index on specific columns to search on it
CREATE FULLTEXT INDEX resource_description_fulltext_idx ON RESOURCE(DESCRIPTION);

CREATE FULLTEXT INDEX tcln_description_fulltext_idx ON TEST_CASE_LIBRARY_NODE(DESCRIPTION);

CREATE FULLTEXT INDEX tc_prerequisite_fulltext_idx ON TEST_CASE(PREREQUISITE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('create_index_fulltext_mysql', 'abo', 'tm/tm.changelog-1.20.0.xml', NOW(), 448, '8:9e6d73b1d057e921627bd735554fbdb8', 'sql', 'Create fulltext index on specific columns to search on it', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::update_datatype_to_fulltext_search::abo
UPDATE QUERY_COLUMN_PROTOTYPE SET DATA_TYPE = 'TEXT' WHERE LABEL IN ('TEST_CASE_DESCRIPTION', 'REQUIREMENT_VERSION_DESCRIPTION', 'TEST_CASE_PREQUISITE');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('update_datatype_to_fulltext_search', 'abo', 'tm/tm.changelog-1.20.0.xml', NOW(), 449, '8:4479991d949f86f34672dd9e9cd9d400', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.20.0.xml::tm-1.20.0-TM-282-delete-lastindexing-properties::jprioux
--  Delete all lastindexing properties from core config
DELETE FROM CORE_CONFIG WHERE STR_KEY LIKE 'lastindexing.%';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.20.0-TM-282-delete-lastindexing-properties', 'jprioux', 'tm/tm.changelog-1.20.0.xml', NOW(), 450, '8:70c0bf3c3e6f269fc3e7b0cf662451de', 'sql', 'Delete all lastindexing properties from core config', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.21.0.xml', NOW(), 451, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.21.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0', 'jprioux', 'tm/tm.changelog-1.21.0.xml', NOW(), 452, '8:eb3feb01de277a67ff0cd5e29967db76', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-244-remote-automation-request-extender::jlor
--  Create new table for RemoteAutomationRequestExtender
CREATE TABLE REMOTE_AUTOMATION_REQUEST_EXTENDER (REMOTE_AUTOMATION_REQUEST_EXTENDER_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', AUTOMATION_REQUEST_ID BIGINT NOT NULL COMMENT 'The automation request this extender extends', SERVER_ID BIGINT NULL COMMENT 'The bugtracker to which the automation request is linked', REMOTE_STATUS VARCHAR(255) NULL COMMENT 'The remote status as defined in the bugtracker', REMOTE_ISSUE_KEY VARCHAR(255) NOT NULL COMMENT 'The remote issue key as generated by Jira', REMOTE_REQUEST_URL VARCHAR(300) NULL COMMENT 'The Url to the remote request', REMOTE_ASSIGNED_TO VARCHAR(300) NOT NULL COMMENT 'email of the assigned', CONSTRAINT PK_REMOTE_AUTOMATION_REQUEST_EXTENDER PRIMARY KEY (REMOTE_AUTOMATION_REQUEST_EXTENDER_ID), CONSTRAINT fk_remote_automation_request_extender_server_id FOREIGN KEY (SERVER_ID) REFERENCES BUGTRACKER (BUGTRACKER_ID), CONSTRAINT fk_remote_automation_request_extender_automation_request_id FOREIGN KEY (AUTOMATION_REQUEST_ID) REFERENCES AUTOMATION_REQUEST (AUTOMATION_REQUEST_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_remote_automation_request_extender_automation_request_id ON REMOTE_AUTOMATION_REQUEST_EXTENDER(AUTOMATION_REQUEST_ID);

CREATE INDEX idx_fk_remote_automation_request_extender_server_id ON REMOTE_AUTOMATION_REQUEST_EXTENDER(SERVER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-244-remote-automation-request-extender', 'jlor', 'tm/tm.changelog-1.21.0.xml', NOW(), 453, '8:d884d1b527d71e6732d90ae44a006dfe', 'createTable tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER; createIndex indexName=idx_fk_remote_automation_request_extender_automation_request_id, tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER; createIndex indexName=idx_fk_remote_automation_request_e...', 'Create new table for RemoteAutomationRequestExtender', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-248-automation-workflow-type::jlor
--  Modify column ALLOW_AUTOMATION_WORKFLOW into AUTOMATION_WORKFLOW_TYPE
ALTER TABLE PROJECT ADD AUTOMATION_WORKFLOW_TYPE VARCHAR(25) DEFAULT 'NONE' NOT NULL COMMENT 'This column precises which workflow type is used.';

update PROJECT
      set AUTOMATION_WORKFLOW_TYPE =
      case
      when ALLOW_AUTOMATION_WORKFLOW = true then 'NATIVE'
      else 'NONE'
      end;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-248-automation-workflow-type', 'jlor', 'tm/tm.changelog-1.21.0.xml', NOW(), 454, '8:929763da9d90be57088f04868ad02201', 'addColumn tableName=PROJECT; sql', 'Modify column ALLOW_AUTOMATION_WORKFLOW into AUTOMATION_WORKFLOW_TYPE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-248-plugin-type::amk
--  add new column PLUGIN_TYPE into LIBRARY_PLUGIN_BINDING
ALTER TABLE LIBRARY_PLUGIN_BINDING ADD PLUGIN_TYPE VARCHAR(25) NULL COMMENT 'This column specifies which type of plugin is used. for now only one type used: Automation.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-248-plugin-type', 'amk', 'tm/tm.changelog-1.21.0.xml', NOW(), 455, '8:4d58d15572c268a50ac2fbddbec509f9', 'addColumn tableName=LIBRARY_PLUGIN_BINDING', 'add new column PLUGIN_TYPE into LIBRARY_PLUGIN_BINDING', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-211-active::amk
--  add new column ACTIVE into LIBRARY_PLUGIN_BINDING
ALTER TABLE LIBRARY_PLUGIN_BINDING ADD ACTIVE BIT(1) DEFAULT 1 NULL COMMENT 'This column specifies if plugin is enable or disable for a project .';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-211-active', 'amk', 'tm/tm.changelog-1.21.0.xml', NOW(), 456, '8:240329fdd9d27baee14fd0958332c569', 'addColumn tableName=LIBRARY_PLUGIN_BINDING', 'add new column ACTIVE into LIBRARY_PLUGIN_BINDING', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-649-sync-enable::api
--  add new column Sync_Enable into REMOTE_SYNCHONISATION
ALTER TABLE REMOTE_SYNCHRONISATION ADD SYNC_ENABLE BIT(1) DEFAULT 1 NOT NULL COMMENT 'This column specifies if synchronisation is enable or disable for a project';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-649-sync-enable', 'api', 'tm/tm.changelog-1.21.0.xml', NOW(), 457, '8:57636328da4d9f5b75fab99241fa5eb4', 'addColumn tableName=REMOTE_SYNCHRONISATION', 'add new column Sync_Enable into REMOTE_SYNCHONISATION', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-211-last-sync-date::amk
--  add new column LAST-SYNC-DATE into REMOTE_AUTOMATION_REQUEST_EXTENDER
ALTER TABLE REMOTE_AUTOMATION_REQUEST_EXTENDER ADD LAST_SYNC_DATE datetime DEFAULT null NULL COMMENT 'Date of the last synchronisation.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-211-last-sync-date', 'amk', 'tm/tm.changelog-1.21.0.xml', NOW(), 458, '8:07cf71a79269ade079ea39832560652a', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column LAST-SYNC-DATE into REMOTE_AUTOMATION_REQUEST_EXTENDER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-725-add-committer-mail-in-scm-server::jlor
--  Add column COMMITTER_MAIL in SCM_SERVER
ALTER TABLE SCM_SERVER ADD COMMITTER_MAIL VARCHAR(255) DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-725-add-committer-mail-in-scm-server', 'jlor', 'tm/tm.changelog-1.21.0.xml', NOW(), 459, '8:e051e8ad2d2a6220a258ad3240ebf823', 'addColumn tableName=SCM_SERVER', 'Add column COMMITTER_MAIL in SCM_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-713-add-axis_and_measure-to-execution_is_auto::abo
INSERT INTO CHART_COLUMN_ROLE (CHART_COLUMN_ID, ROLE) values ((SELECT QUERY_COLUMN_ID FROM QUERY_COLUMN_PROTOTYPE WHERE QUERY_COLUMN_PROTOTYPE.LABEL = 'EXECUTION_ISAUTO'), 'MEASURE'),
      ((SELECT QUERY_COLUMN_ID FROM QUERY_COLUMN_PROTOTYPE WHERE QUERY_COLUMN_PROTOTYPE.LABEL = 'EXECUTION_ISAUTO'), 'AXIS');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-713-add-axis_and_measure-to-execution_is_auto', 'abo', 'tm/tm.changelog-1.21.0.xml', NOW(), 460, '8:081013621cd9074ccda595855ece98c2', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-211-sent-value-for-sync::amk
--  add new column SENT_VALUE_FOR_SYNC into REMOTE_AUTOMATION_REQUEST_EXTENDER
ALTER TABLE REMOTE_AUTOMATION_REQUEST_EXTENDER ADD SENT_VALUE_FOR_SYNC LONGTEXT DEFAULT null NULL COMMENT 'The values ​​of the test case fields sent during synchronization.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-211-sent-value-for-sync', 'amk', 'tm/tm.changelog-1.21.0.xml', NOW(), 461, '8:2ef2dfed74f847f837a5b81aa7025619', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column SENT_VALUE_FOR_SYNC into REMOTE_AUTOMATION_REQUEST_EXTENDER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-916-918-synchronizable-issue-status::amk
--  add new column SYNCHRONIZABLE_ISSUE_STATUS into REMOTE_AUTOMATION_REQUEST_EXTENDER
ALTER TABLE REMOTE_AUTOMATION_REQUEST_EXTENDER ADD SYNCHRONIZABLE_ISSUE_STATUS VARCHAR(25) NULL COMMENT 'this column can be set to: TO SYNCHRONIZE, DELETED, MOVED_PROJECT and MOVED_ISSUE_TYPE ; and it is updated after each synchronization.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-916-918-synchronizable-issue-status', 'amk', 'tm/tm.changelog-1.21.0.xml', NOW(), 462, '8:cd8dc13f182fe565a72a4c00d95763c6', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column SYNCHRONIZABLE_ISSUE_STATUS into REMOTE_AUTOMATION_REQUEST_EXTENDER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-875-last-sync-date-squash::amk
--  add new column LAST-SYNC-DATE into REMOTE_AUTOMATION_REQUEST_EXTENDER
ALTER TABLE REMOTE_AUTOMATION_REQUEST_EXTENDER ADD LAST_SYNC_DATE_SQUASH datetime DEFAULT null NULL COMMENT 'Date of the last synchronisation squash to remote server.';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-875-last-sync-date-squash', 'amk', 'tm/tm.changelog-1.21.0.xml', NOW(), 463, '8:caa74bc72f5abd3467117e5ba0887a01', 'addColumn tableName=REMOTE_AUTOMATION_REQUEST_EXTENDER', 'add new column LAST-SYNC-DATE into REMOTE_AUTOMATION_REQUEST_EXTENDER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-846.1-mysql::jlor
--  MySQL - Add unique constraint on order column for iterations in campaign
drop table if exists CAMPAIGN_ITERATION_TMP;

create table CAMPAIGN_ITERATION_TMP
          (select
            CAMPAIGN_ID,
            ITERATION_ID,
            min(ITERATION_ORDER) ITERATION_ORDER
          from CAMPAIGN_ITERATION
          group by CAMPAIGN_ID, ITERATION_ID);

create index idx1 on CAMPAIGN_ITERATION_TMP(CAMPAIGN_ID, ITERATION_ID);

update CAMPAIGN_ITERATION_TMP t1,
          (select
            CAMPAIGN_ID,
            ITERATION_ID,
            (select count(*)
            from CAMPAIGN_ITERATION_TMP b
            where a.CAMPAIGN_ID = b.CAMPAIGN_ID
            and a.ITERATION_ORDER >= b.ITERATION_ORDER) line
          from CAMPAIGN_ITERATION_TMP a) t2
        set ITERATION_ORDER = t2.line - 1
        where t1.CAMPAIGN_ID = t2.CAMPAIGN_ID
        and t1.ITERATION_ID = t2.ITERATION_ID;

truncate table CAMPAIGN_ITERATION;

insert into CAMPAIGN_ITERATION
        select
          a.CAMPAIGN_ID,
          a.ITERATION_ID,
          a.ITERATION_ORDER + 1 - (select count(*)
                              from CAMPAIGN_ITERATION_TMP b
                              where a.CAMPAIGN_ID = b.CAMPAIGN_ID
                              and a.ITERATION_ORDER = b.ITERATION_ORDER
                              and a.ITERATION_ID <= b.ITERATION_ID
                              group by
                                b.CAMPAIGN_ID,
                                b.ITERATION_ORDER) ITERATION_ORDER
          from CAMPAIGN_ITERATION_TMP a;

drop table CAMPAIGN_ITERATION_TMP;

ALTER TABLE CAMPAIGN_ITERATION ADD UNIQUE (CAMPAIGN_ID, ITERATION_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-846.1-mysql', 'jlor', 'tm/tm.changelog-1.21.0.xml', NOW(), 464, '8:20f810e0edc0d3c9cda10b434a15d304', 'sql; addUniqueConstraint tableName=CAMPAIGN_ITERATION', 'MySQL - Add unique constraint on order column for iterations in campaign', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-846.2-mysql::jlor
--  MySQL - Add unique constraint on order column for executions in itpi
drop table if exists ITEM_TEST_PLAN_EXECUTION_TMP;

create table ITEM_TEST_PLAN_EXECUTION_TMP
          (select
            ITEM_TEST_PLAN_ID,
            EXECUTION_ID,
            min(EXECUTION_ORDER) EXECUTION_ORDER
          from ITEM_TEST_PLAN_EXECUTION
          group by ITEM_TEST_PLAN_ID, EXECUTION_ID);

create index idx1 on ITEM_TEST_PLAN_EXECUTION_TMP(ITEM_TEST_PLAN_ID, EXECUTION_ID);

update ITEM_TEST_PLAN_EXECUTION_TMP t1,
          (select
            ITEM_TEST_PLAN_ID,
            EXECUTION_ID,
            (select count(*)
            from ITEM_TEST_PLAN_EXECUTION_TMP b
            where a.ITEM_TEST_PLAN_ID = b.ITEM_TEST_PLAN_ID
            and a.EXECUTION_ORDER >= b.EXECUTION_ORDER) line
          from ITEM_TEST_PLAN_EXECUTION_TMP a) t2
        set EXECUTION_ORDER = t2.line - 1
        where t1.ITEM_TEST_PLAN_ID = t2.ITEM_TEST_PLAN_ID
        and t1.EXECUTION_ID = t2.EXECUTION_ID;

truncate table ITEM_TEST_PLAN_EXECUTION;

insert into ITEM_TEST_PLAN_EXECUTION
        select
          a.ITEM_TEST_PLAN_ID,
          a.EXECUTION_ID,
          a.EXECUTION_ORDER + 1 - (select count(*)
                              from ITEM_TEST_PLAN_EXECUTION_TMP b
                              where a.ITEM_TEST_PLAN_ID = b.ITEM_TEST_PLAN_ID
                              and a.EXECUTION_ORDER = b.EXECUTION_ORDER
                              and a.EXECUTION_ID <= b.EXECUTION_ID
                              group by
                                b.ITEM_TEST_PLAN_ID,
                                b.EXECUTION_ORDER) EXECUTION_ORDER
          from ITEM_TEST_PLAN_EXECUTION_TMP a;

drop table ITEM_TEST_PLAN_EXECUTION_TMP;

ALTER TABLE ITEM_TEST_PLAN_EXECUTION ADD UNIQUE (ITEM_TEST_PLAN_ID, EXECUTION_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-846.2-mysql', 'jlor', 'tm/tm.changelog-1.21.0.xml', NOW(), 465, '8:4e7fa40628e3b1331d9d1f4ee61ae87d', 'sql; addUniqueConstraint tableName=ITEM_TEST_PLAN_EXECUTION', 'MySQL - Add unique constraint on order column for executions in itpi', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-846.3-mysql::jlor
--  MySQL - Add unique constraint on order column for steps in execution
drop table if exists EXECUTION_EXECUTION_STEPS_TMP;

create table EXECUTION_EXECUTION_STEPS_TMP
          (select
            EXECUTION_ID,
            EXECUTION_STEP_ID,
            min(EXECUTION_STEP_ORDER) STEP_ORDER
          from EXECUTION_EXECUTION_STEPS
          group by EXECUTION_ID, EXECUTION_STEP_ID);

create index idx1 on EXECUTION_EXECUTION_STEPS_TMP(EXECUTION_ID, EXECUTION_STEP_ID);

update EXECUTION_EXECUTION_STEPS_TMP t1,
          (select
            EXECUTION_ID,
            EXECUTION_STEP_ID,
            (select count(*)
            from EXECUTION_EXECUTION_STEPS_TMP b
            where a.EXECUTION_ID = b.EXECUTION_ID
            and a.STEP_ORDER >= b.STEP_ORDER) line
          from EXECUTION_EXECUTION_STEPS_TMP a) t2
        set STEP_ORDER = t2.line - 1
        where t1.EXECUTION_ID = t2.EXECUTION_ID
        and t1.EXECUTION_STEP_ID = t2.EXECUTION_STEP_ID;

truncate table EXECUTION_EXECUTION_STEPS;

insert into EXECUTION_EXECUTION_STEPS
        select
          a.EXECUTION_ID,
          a.EXECUTION_STEP_ID,
          a.STEP_ORDER + 1 - (select count(*)
                              from EXECUTION_EXECUTION_STEPS_TMP b
                              where a.EXECUTION_ID = b.EXECUTION_ID
                              and a.STEP_ORDER = b.STEP_ORDER
                              and a.EXECUTION_STEP_ID <= b.EXECUTION_STEP_ID
                              group by
                                b.EXECUTION_ID,
                                b.STEP_ORDER) STEP_ORDER
          from EXECUTION_EXECUTION_STEPS_TMP a;

drop table EXECUTION_EXECUTION_STEPS_TMP;

ALTER TABLE EXECUTION_EXECUTION_STEPS ADD UNIQUE (EXECUTION_ID, EXECUTION_STEP_ORDER);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-846.3-mysql', 'jlor', 'tm/tm.changelog-1.21.0.xml', NOW(), 466, '8:ee3f3cbacf44f1577a761ed928b6f6ac', 'sql; addUniqueConstraint tableName=EXECUTION_EXECUTION_STEPS', 'MySQL - Add unique constraint on order column for steps in execution', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.21.0.xml::tm-1.21.0-TM-996-modify-entity-reference-id-type::jprioux
--  Modify ENTITY_REFERENCE_ID data type in CHART_SCOPE
ALTER TABLE CHART_SCOPE MODIFY ENTITY_REFERENCE_ID BIGINT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.21.0-TM-996-modify-entity-reference-id-type', 'jprioux', 'tm/tm.changelog-1.21.0.xml', NOW(), 467, '8:4820a152f32a0acb2441cd5c55d5e2a6', 'modifyDataType columnName=ENTITY_REFERENCE_ID, tableName=CHART_SCOPE', 'Modify ENTITY_REFERENCE_ID data type in CHART_SCOPE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.0.xml', NOW(), 468, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0', 'jthebault', 'tm/tm.changelog-1.22.0.xml', NOW(), 469, '8:b0881e9c070a0a75173bd86d509cb25a', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger::edegenetais
ALTER TABLE ITERATION ADD UUID VARCHAR(36) NULL;

ALTER TABLE ITERATION ADD CONSTRAINT uc_iteration_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger', 'edegenetais', 'tm/tm.changelog-1.22.0.xml', NOW(), 470, '8:cb55e1be7759db53ef699f33ecf14b6b', 'addColumn tableName=ITERATION; addUniqueConstraint constraintName=uc_iteration_uuid, tableName=ITERATION', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-167-update-iteration-uuid-mysql::edegenetais
--  Created missing UUIDs on upgrade to add the not-null constraint.
UPDATE ITERATION SET UUID = uuid() WHERE UUID is NULL;

ALTER TABLE ITERATION MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-167-update-iteration-uuid-mysql', 'edegenetais', 'tm/tm.changelog-1.22.0.xml', NOW(), 471, '8:97ee959eb14b87fce015a7304edb4329', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-action-word-table::jlor
--  Add action word table
CREATE TABLE ACTION_WORD (ACTION_WORD_ID BIGINT AUTO_INCREMENT NOT NULL, `DESCRIPTION` LONGTEXT NULL, CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, TOKEN VARCHAR(766) NOT NULL, PROJECT_ID BIGINT NOT NULL, CONSTRAINT PK_ACTION_WORD PRIMARY KEY (ACTION_WORD_ID), CONSTRAINT fk_action_word_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_action_word_project ON ACTION_WORD(PROJECT_ID);

ALTER TABLE ACTION_WORD ADD CONSTRAINT uc_aw_token_project_id UNIQUE (TOKEN, PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-action-word-table', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 472, '8:9b22e3a2765e31b9300ba49843d31cda', 'createTable tableName=ACTION_WORD; createIndex indexName=idx_fk_action_word_project, tableName=ACTION_WORD; addUniqueConstraint constraintName=uc_aw_token_project_id, tableName=ACTION_WORD', 'Add action word table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-keyword-test-step-table::jlor
--  Add keyword test step table
CREATE TABLE KEYWORD_TEST_STEP (TEST_STEP_ID BIGINT NOT NULL COMMENT 'Shared key with TEST_STEP table', ACTION_WORD_ID BIGINT NOT NULL COMMENT 'The action word which this test step uses', KEYWORD VARCHAR(20) NOT NULL COMMENT 'A keyword test step keyword', DATATABLE TEXT NULL COMMENT 'A keyword test step datatable', DOCSTRING TEXT NULL COMMENT 'A keyword test step docstring', COMMENT TEXT NULL COMMENT 'A keyword test step comment', CONSTRAINT pk_keyword_test_step PRIMARY KEY (TEST_STEP_ID), CONSTRAINT fk_keyword_test_step_test_step FOREIGN KEY (TEST_STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_keyword_test_step_action_word_id FOREIGN KEY (ACTION_WORD_ID) REFERENCES ACTION_WORD (ACTION_WORD_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_keyword_test_step_action_word ON KEYWORD_TEST_STEP(ACTION_WORD_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-keyword-test-step-table', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 473, '8:9ea4af57ac8717e4d6e9cbb765ba10a3', 'createTable tableName=KEYWORD_TEST_STEP; createIndex indexName=idx_fk_keyword_test_step_action_word, tableName=KEYWORD_TEST_STEP', 'Add keyword test step table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-update-query-filter::jlor
--  Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder
update QUERY_FILTER_VALUES set FILTER_VALUE='org.squashtest.tm.domain.testcase.CallTestStep' where QUERY_FILTER_ID=1;

update QUERY_FILTER_COLUMN set QUERY_COLUMN_ID=134, FILTER_OPERATION='IS_CLASS' where QUERY_FILTER_ID=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-update-query-filter', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 474, '8:f73428381928dfb4b5c813c715ea5b36', 'sql; sql', 'Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION::jlor
--  Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column
CREATE TABLE KEYWORD_TEST_CASE (TCLN_ID BIGINT NOT NULL, CONSTRAINT PK_KEYWORD_TEST_CASE PRIMARY KEY (TCLN_ID), CONSTRAINT fk_keyword_tc_tc FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

ALTER TABLE SCRIPTED_TC_EXTENDER DROP COLUMN SCRIPTED_TC_EXTENDER_ID;

ALTER TABLE SCRIPTED_TC_EXTENDER RENAME SCRIPTED_TEST_CASE;

ALTER TABLE SCRIPTED_TEST_CASE DROP FOREIGN KEY fk_scripted_extender_test_case;

ALTER TABLE SCRIPTED_TEST_CASE CHANGE TEST_CASE_ID TCLN_ID BIGINT;

ALTER TABLE SCRIPTED_TEST_CASE ADD CONSTRAINT fk_scripted_extender_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE (TCLN_ID);

ALTER TABLE SCRIPTED_TEST_CASE ADD PRIMARY KEY (TCLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 475, '8:c1de3a0f1654209d41c56f4a0ced4cf0', 'createTable tableName=KEYWORD_TEST_CASE; dropColumn columnName=SCRIPTED_TC_EXTENDER_ID, tableName=SCRIPTED_TC_EXTENDER; renameTable newTableName=SCRIPTED_TEST_CASE, oldTableName=SCRIPTED_TC_EXTENDER; dropForeignKeyConstraint baseTableName=SCRIPTED...', 'Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype::jlor
--  In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity
update QUERY_COLUMN_PROTOTYPE set DATA_TYPE='ENTITY', COLUMN_TYPE='ENTITY' where QUERY_COLUMN_ID=184;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 476, '8:19a7c2029b3655a03380376c7ee16a34', 'sql', 'In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-drop-tc-kind-column::jlor
ALTER TABLE TEST_CASE DROP COLUMN TC_KIND;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-drop-tc-kind-column', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 477, '8:4301a9f6570c32fb97dc2adf1def1008', 'dropColumn columnName=TC_KIND, tableName=TEST_CASE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc::jlor
--  LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.
ALTER TABLE SCRIPTED_TEST_CASE DROP COLUMN LANGUAGE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 478, '8:02a9a59bb06bf18ebf59e78d9d8473f6', 'dropColumn columnName=LANGUAGE, tableName=SCRIPTED_TEST_CASE', 'LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-421-add-test-suite-uuid::aguilhem
ALTER TABLE TEST_SUITE ADD UUID VARCHAR(36) NULL;

ALTER TABLE TEST_SUITE ADD CONSTRAINT uc_test_suite_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-421-add-test-suite-uuid', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 479, '8:509ab177ee49be7eda3b756e636500c2', 'addColumn tableName=TEST_SUITE; addUniqueConstraint constraintName=uc_test_suite_uuid, tableName=TEST_SUITE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-421-update-test-suite-uuid-mysql::aguilhem
--  Created missing UUIDs on upgrade to add the not-null constraint.
UPDATE TEST_SUITE SET UUID = uuid() WHERE UUID is NULL;

ALTER TABLE TEST_SUITE MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-421-update-test-suite-uuid-mysql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 480, '8:5d54095afb8aee7def6d702b5361149c', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION::jlor
--  Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.
ALTER TABLE SCRIPTED_EXECUTION_EXTENDER RENAME SCRIPTED_EXECUTION;

ALTER TABLE SCRIPTED_EXECUTION DROP COLUMN SCRIPTED_EXECUTION_EXTENDER_ID;

ALTER TABLE SCRIPTED_EXECUTION ADD PRIMARY KEY (EXECUTION_ID);

ALTER TABLE SCRIPTED_EXECUTION DROP COLUMN LANGUAGE;

CREATE TABLE KEYWORD_EXECUTION (EXECUTION_ID BIGINT NOT NULL, CONSTRAINT PK_KEYWORD_EXECUTION PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_keyword_exec_exec FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 481, '8:06fcfa3a3c883a223c1adbe236167088', 'renameTable newTableName=SCRIPTED_EXECUTION, oldTableName=SCRIPTED_EXECUTION_EXTENDER; dropColumn columnName=SCRIPTED_EXECUTION_EXTENDER_ID, tableName=SCRIPTED_EXECUTION; addPrimaryKey tableName=SCRIPTED_EXECUTION; dropColumn columnName=LANGUAGE, ...', 'Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD::qtran
--  Create ACTION_WORD_FRAGMENT table
--  Create new table for Action word text elements
--  Create new table for Action word parameter elements
--  Create new table for Action word parameter value
CREATE TABLE ACTION_WORD_FRAGMENT (ACTION_WORD_FRAGMENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, auto-generated', ACTION_WORD_ID BIGINT NULL COMMENT 'Foreign key to the action word', FRAGMENT_ORDER INT NULL COMMENT 'the fragment order in action word fragment list', CONSTRAINT PK_ACTION_WORD_FRAGMENT PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_fragment_action_word_id FOREIGN KEY (ACTION_WORD_ID) REFERENCES ACTION_WORD(ACTION_WORD_ID)) COMMENT='base table for Action word fragments' ENGINE = INNODB;

CREATE INDEX idx_fk_action_word_fragment_action_word_id ON ACTION_WORD_FRAGMENT(ACTION_WORD_ID);

ALTER TABLE ACTION_WORD_FRAGMENT ADD CONSTRAINT uc_action_word_fragment_order UNIQUE (ACTION_WORD_ID, FRAGMENT_ORDER);

CREATE TABLE ACTION_WORD_TEXT (ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'Shared key with ACTION_WORD_FRAGMENT table', TEXT VARCHAR(255) NOT NULL COMMENT 'the content of the action word text', CONSTRAINT PK_ACTION_WORD_TEXT PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_text_action_word_fragment FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_FRAGMENT(ACTION_WORD_FRAGMENT_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_action_word_text_action_word_fragment ON ACTION_WORD_TEXT(ACTION_WORD_FRAGMENT_ID);

CREATE TABLE ACTION_WORD_PARAMETER (ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'Shared key with ACTION_WORD_FRAGMENT table', NAME VARCHAR(255) NOT NULL COMMENT 'the name of the action word parameter', DEFAULT_VALUE VARCHAR(255) NOT NULL COMMENT 'the default value of the action word parameter', CONSTRAINT PK_ACTION_WORD_PARAMETER PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_parameter_action_word_fragment FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_FRAGMENT(ACTION_WORD_FRAGMENT_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_action_word_parameter_action_word_fragment ON ACTION_WORD_PARAMETER(ACTION_WORD_FRAGMENT_ID);

CREATE TABLE ACTION_WORD_PARAMETER_VALUE (ACTION_WORD_PARAMETER_VALUE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, auto-generated', VALUE VARCHAR(255) NOT NULL COMMENT 'the value of the action word parameter value', ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'the action word parameter by which this value replaces', KEYWORD_TEST_STEP_ID BIGINT NOT NULL COMMENT 'the keyword test step in which this value is used', CONSTRAINT PK_ACTION_WORD_PARAMETER_VALUE PRIMARY KEY (ACTION_WORD_PARAMETER_VALUE_ID), CONSTRAINT fk_action_word_parameter_value_action_word_fragment_id FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_PARAMETER(ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_parameter_value_keyword_test_step_id FOREIGN KEY (KEYWORD_TEST_STEP_ID) REFERENCES KEYWORD_TEST_STEP(TEST_STEP_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_action_word_parameter_value_action_word_fragment_id ON ACTION_WORD_PARAMETER_VALUE(ACTION_WORD_FRAGMENT_ID);

CREATE INDEX idx_fk_action_word_parameter_value_keyword_test_step_id ON ACTION_WORD_PARAMETER_VALUE(KEYWORD_TEST_STEP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD', 'qtran', 'tm/tm.changelog-1.22.0.xml', NOW(), 482, '8:80490faa749274bfe39edad0ff1b28cd', 'createTable tableName=ACTION_WORD_FRAGMENT; createIndex indexName=idx_fk_action_word_fragment_action_word_id, tableName=ACTION_WORD_FRAGMENT; addUniqueConstraint constraintName=uc_action_word_fragment_order, tableName=ACTION_WORD_FRAGMENT; createT...', 'Create ACTION_WORD_FRAGMENT table
Create new table for Action word text elements
Create new table for Action word parameter elements
Create new table for Action word parameter value', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-302-action-word-workspace::jlor
--  Create action word library table
--  Insert corresponding entries in ACL tables
--  Add foreign key to the library in a project
--  Create one action word library for each existing project
CREATE TABLE ACTION_WORD_LIBRARY (AWL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to ATTACHMENT_LIST', CONSTRAINT PK_ACTION_WORD_LIBRARY PRIMARY KEY (AWL_ID), CONSTRAINT fk_awLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_action_word_library ON ACTION_WORD_LIBRARY(AWL_ID);

CREATE INDEX idx_fk_awl_attachment_list ON ACTION_WORD_LIBRARY(ATTACHMENT_LIST_ID);

insert into ACL_CLASS(ID, CLASSNAME)
      values(8, 'org.squashtest.tm.domain.actionword.ActionWordLibrary');

insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      select AGP2.ACL_GROUP_ID, AGP2.PERMISSION_MASK, 8
      from ACL_GROUP_PERMISSION AGP2
      where CLASS_ID = 3;

ALTER TABLE PROJECT ADD AWL_ID BIGINT NULL;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_awl FOREIGN KEY (AWL_ID) REFERENCES ACTION_WORD_LIBRARY (AWL_ID);

CREATE INDEX idx_fk_project_awl ON PROJECT(AWL_ID);

-- Create the libraries --

      insert into ACTION_WORD_LIBRARY (AWL_ID)
        select p.PROJECT_ID
        from PROJECT p;

-- Attachments, Step 1 --
      -- Create a ranking table, akin to what would ROW_NUMBER() order by id desc would say --

      create table AWL_RANK as
        select awl.awl_id,
               count(awl2.awl_id) as ranking
        from ACTION_WORD_LIBRARY awl,
             ACTION_WORD_LIBRARY awl2
        where awl.awl_id <= awl2.awl_id
        group by awl.awl_id
        order by ranking asc;

-- Attachments, Step 2 --
      -- Create a table that pairs library ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier --

      create table AWL_ATTACHMENT_LIST_PAIRING as
        select awl_rank.awl_id,
               (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + awl_rank.ranking as attachment_list_id
        from AWL_RANK awl_rank;

-- Attachments, Step 3 --
      -- Insert the attachment lists and update fk in the action word library --

      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
        select pair.attachment_list_id
        from AWL_ATTACHMENT_LIST_PAIRING pair;

update ACTION_WORD_LIBRARY awl
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id
                                from AWL_ATTACHMENT_LIST_PAIRING pair
                                where pair.awl_id = awl.awl_id);

-- Attachments, Step 4 and final --
      -- Drop the temporary tables --

      drop table AWL_ATTACHMENT_LIST_PAIRING;

drop table AWL_RANK;

-- Bind the project to the AWL library --

      update PROJECT P
      set AWL_ID = PROJECT_ID;

-- Insert the acl object identities --

      insert into ACL_OBJECT_IDENTITY(IDENTITY, CLASS_ID)
        select awl.awl_id, 8 from ACTION_WORD_LIBRARY awl;

-- Add the user/team permissions in ACL_RESPONSIBILITY_SCOPE_ENTRY
      -- Each user will receive the same acl_group on each action word library than on the project it depends on
      -- (this last sentence is the idea behind the auto join on acl_object_identity in this query) --

      insert into ACL_RESPONSIBILITY_SCOPE_ENTRY(party_id, acl_group_id, object_identity_id)
        select distinct arse.party_id, arse.acl_group_id, awl_oid.id
        from ACL_RESPONSIBILITY_SCOPE_ENTRY arse
        inner join ACL_OBJECT_IDENTITY oid on (arse.object_identity_id = oid.id and oid.class_id = 1)
        inner join ACL_OBJECT_IDENTITY awl_oid on (oid.identity = awl_oid.identity and awl_oid.class_id = 8);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 483, '8:357323374c8bd4022311dccdc360f8de', 'createTable tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_action_word_library, tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_fk_awl_attachment_list, tableName=ACTION_WORD_LIBRARY; sql; addColumn tableName=PROJECT; createIndex...', 'Create action word library table
Insert corresponding entries in ACL tables
Add foreign key to the library in a project
Create one action word library for each existing project', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-302-action-word-workspace-2::jlor
--  Create action word library node table
--  Create one action word library node for each library created
--  Create action word library node relationship table
CREATE TABLE ACTION_WORD_LIBRARY_NODE (AWLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', NAME VARCHAR(255) NULL, ENTITY_TYPE VARCHAR(50) NULL, ENTITY_ID BIGINT NULL, AWL_ID BIGINT NULL COMMENT 'Foreign key to the ACTION_WORD_LIBRARY', CONSTRAINT PK_ACTION_WORD_LIBRARY_NODE PRIMARY KEY (AWLN_ID), CONSTRAINT fk_awln_awl FOREIGN KEY (AWL_ID) REFERENCES ACTION_WORD_LIBRARY(AWL_ID)) ENGINE = INNODB;

CREATE INDEX idx_action_word_library_node ON ACTION_WORD_LIBRARY_NODE(AWLN_ID);

CREATE INDEX idx_fk_awln_awl ON ACTION_WORD_LIBRARY_NODE(AWL_ID);

insert into ACTION_WORD_LIBRARY_NODE (AWL_ID, ENTITY_ID, ENTITY_TYPE)
      select AWL_ID, AWL_ID, 'LIBRARY'
      from ACTION_WORD_LIBRARY;

update ACTION_WORD_LIBRARY_NODE
      set NAME = (select p.NAME from PROJECT p where ENTITY_ID = p.AWL_ID)
      where ENTITY_TYPE = 'LIBRARY';

CREATE TABLE AWLN_RELATIONSHIP (ANCESTOR_ID BIGINT NULL COMMENT 'Foreign key to parent node', DESCENDANT_ID BIGINT NOT NULL COMMENT 'Foreign key to child node', CONTENT_ORDER BIGINT NULL COMMENT 'Order in its parent node', CONSTRAINT fk_awln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID), CONSTRAINT fk_awln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_awln_relationship_descendant ON AWLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX idx_awln_relationship_ancestor ON AWLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace-2', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 484, '8:a8b4c9d2a4a0d9192a220a0cf5bac889', 'createTable tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_action_word_library_node, tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_fk_awln_awl, tableName=ACTION_WORD_LIBRARY_NODE; sql; createTable tableName=AWLN_RELA...', 'Create action word library node table
Create one action word library node for each library created
Create action word library node relationship table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-794-auditable-automated-suite::aguilhem
--  Make Automated Suite auditable
ALTER TABLE AUTOMATED_SUITE ADD CREATED_BY VARCHAR(50) NULL;

ALTER TABLE AUTOMATED_SUITE ADD CREATED_ON datetime NULL;

ALTER TABLE AUTOMATED_SUITE ADD LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL;

ALTER TABLE AUTOMATED_SUITE ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-794-auditable-automated-suite', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 485, '8:89c3edca29fb9158d99f47df8644e662', 'addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', 'Make Automated Suite auditable', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-794-automated-suite-migration-mysql::aguilhem
--  Add audit data on automated suite for mysql
UPDATE AUTOMATED_SUITE asuite
      INNER JOIN (
        select ex.CREATED_ON, ex.CREATED_BY, ex.LAST_MODIFIED_BY, ex.LAST_MODIFIED_ON, ext.SUITE_ID
        from AUTOMATED_EXECUTION_EXTENDER ext
        inner join EXECUTION ex on ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
        order by ex.LAST_MODIFIED_ON desc
      ) AS exec
      ON exec.SUITE_ID = asuite.SUITE_ID
      SET asuite.CREATED_ON = exec.CREATED_ON,
          asuite.CREATED_BY = exec.CREATED_BY,
          asuite.LAST_MODIFIED_BY = exec.LAST_MODIFIED_BY,
          asuite.LAST_MODIFIED_ON = exec.LAST_MODIFIED_ON;

UPDATE AUTOMATED_SUITE
      SET CREATED_ON = '2000-01-01 00:00:00.0',
      CREATED_BY = 'admin'
      WHERE CREATED_ON IS NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_ON DATETIME NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(50) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-794-automated-suite-migration-mysql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 486, '8:1b6acb827f4de7609109c660d2b81581', 'sql', 'Add audit data on automated suite for mysql', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-795::aguilhem
--  Adds a execution status field to the automated suites
ALTER TABLE AUTOMATED_SUITE ADD EXECUTION_STATUS VARCHAR(255) DEFAULT 'READY' NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-795', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 487, '8:2545fb692f41e233d959e25f061768bd', 'addColumn tableName=AUTOMATED_SUITE', 'Adds a execution status field to the automated suites', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-795-migration-mysql::aguilhem
--  Compute preexisting automated suites status for mysql
UPDATE AUTOMATED_SUITE asuite
      INNER JOIN
      (
        SELECT automated_suite.SUITE_ID,
              blocked_count.counter as blocked_count,
              untestable_count.counter as untestable_count,
              settled_count.counter as settled_count,
              failure_count.counter as failure_count,
              success_count.counter as success_count,
              running_count.counter as running_count,
              total_count.counter as total_count
        FROM AUTOMATED_SUITE as automated_suite
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('BLOCKED', 'ERROR', 'NOT_RUN')
          GROUP BY ext.SUITE_ID) as blocked_count
        ON automated_suite.SUITE_ID = blocked_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('UNTESTABLE', 'NOT_FOUND')
          GROUP BY ext.SUITE_ID) as untestable_count
        ON automated_suite.SUITE_ID = untestable_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SETTLED', 'UNTESTABLE', 'NOT_FOUND')
          GROUP BY ext.SUITE_ID) as settled_count
        ON automated_suite.SUITE_ID = settled_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS = 'FAILURE'
          GROUP BY ext.SUITE_ID) as failure_count
        ON automated_suite.SUITE_ID = failure_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SUCCESS', 'UNTESTABLE', 'SETTLED', 'NOT_FOUND', 'WARNING')
          GROUP BY ext.SUITE_ID) as success_count
        ON automated_suite.SUITE_ID = success_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SUCCESS', 'UNTESTABLE', 'SETTLED', 'NOT_FOUND', 'WARNING')
          GROUP BY ext.SUITE_ID) as running_count
        ON automated_suite.SUITE_ID = running_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          GROUP BY ext.SUITE_ID) as total_count
          ON automated_suite.SUITE_ID = total_count.SUITE_ID
      ) as count_table
      ON asuite.SUITE_ID = count_table.SUITE_ID
      SET asuite.EXECUTION_STATUS = (
        CASE
          WHEN (count_table.blocked_count IS NOT NULL AND count_table.blocked_count > 0) THEN 'BLOCKED'
          WHEN (count_table.untestable_count IS NOT NULL AND count_table.untestable_count = count_table.total_count) THEN 'UNTESTABLE'
          WHEN (count_table.settled_count IS NOT NULL AND count_table.settled_count = count_table.total_count) THEN 'SETTLED'
          WHEN (count_table.failure_count IS NOT NULL AND count_table.failure_count > 0) THEN 'FAILURE'
          WHEN (count_table.success_count IS NOT NULL AND count_table.success_count = count_table.total_count) THEN 'SUCCESS'
          WHEN (count_table.running_count IS NOT NULL AND count_table.running_count > 0) THEN 'RUNNING'
          ELSE 'READY'
        END
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-795-migration-mysql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 488, '8:ed56340d2b40dff22b2ed9fffaf528f4', 'sql', 'Compute preexisting automated suites status for mysql', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns::jprioux
--  add indexes on default search sort columns
CREATE INDEX idx_project_name ON PROJECT(NAME);

CREATE INDEX idx_tc_reference ON TEST_CASE(`REFERENCE`);

CREATE INDEX idx_tc_importance ON TEST_CASE(IMPORTANCE);

CREATE INDEX idx_req_reference ON REQUIREMENT_VERSION(`REFERENCE`);

CREATE INDEX idx_req_status ON REQUIREMENT_VERSION(REQUIREMENT_STATUS);

CREATE INDEX idx_req_criticality ON REQUIREMENT_VERSION(CRITICALITY);

CREATE INDEX idx_iteration_name ON ITERATION(NAME);

CREATE INDEX idx_cln_name ON CAMPAIGN_LIBRARY_NODE(NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns', 'jprioux', 'tm/tm.changelog-1.22.0.xml', NOW(), 489, '8:ddd3e53dd0db6e2388b067f003d2af0c', 'createIndex indexName=idx_project_name, tableName=PROJECT; createIndex indexName=idx_tc_reference, tableName=TEST_CASE; createIndex indexName=idx_tc_importance, tableName=TEST_CASE; createIndex indexName=idx_req_reference, tableName=REQUIREMENT_VE...', 'add indexes on default search sort columns', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-891::aguilhem
--  Automated Suite can be directly linked to an iteration or a test suite
ALTER TABLE AUTOMATED_SUITE ADD ITERATION_ID BIGINT NULL, ADD TEST_SUITE_ID BIGINT NULL;

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_iteration FOREIGN KEY (ITERATION_ID) REFERENCES ITERATION (ITERATION_ID);

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_test_suite FOREIGN KEY (TEST_SUITE_ID) REFERENCES TEST_SUITE (ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-891', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 490, '8:3c63dafa6caa65c87bf1c2fb2e276184', 'addColumn tableName=AUTOMATED_SUITE', 'Automated Suite can be directly linked to an iteration or a test suite', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language::jlor
ALTER TABLE PROJECT ADD BDD_IMPLEMENTATION_TECHNOLOGY VARCHAR(30) DEFAULT 'CUCUMBER' NOT NULL, ADD BDD_SCRIPT_LANGUAGE VARCHAR(30) DEFAULT 'ENGLISH' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 491, '8:e6b7e355cdf35114da07e367b3f8a4b1', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-306-create-closure-table::mqtran
--  closure table for action word library nodes. Its content is set and modified by 4 triggers
CREATE TABLE AWLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_awln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID), CONSTRAINT fk_awln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_awln_relationship_clos_desc ON AWLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_awln_relationship_clos_anc ON AWLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

ALTER TABLE AWLN_RELATIONSHIP_CLOSURE ADD UNIQUE (ANCESTOR_ID, DESCENDANT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-306-create-closure-table', 'mqtran', 'tm/tm.changelog-1.22.0.xml', NOW(), 492, '8:06bcc0cfcc52a9439894246fb1e2e7d7', 'createTable tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_desc, tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_anc, tableName=AWLN_RELATIONSHIP_CLOSURE; addUniqueConstr...', 'closure table for action word library nodes. Its content is set and modified by 4 triggers', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-306-closure-mysql-trigger::mqtran
--  mysql-triggers for AWLN_RELATIONSHIP_CLOSURE table
create trigger ins_awln_after after insert on
      ACTION_WORD_LIBRARY_NODE
      for each row insert ignore into
      AWLN_RELATIONSHIP_CLOSURE values (new.awln_id, new.awln_id, 0);

create trigger del_awln_before before delete on
      ACTION_WORD_LIBRARY_NODE
      for each row delete from
      AWLN_RELATIONSHIP_CLOSURE where ancestor_id=old.awln_id and
      descendant_id=old.awln_id;

create trigger attach_awln_after after insert on AWLN_RELATIONSHIP
      for each row insert ignore into AWLN_RELATIONSHIP_CLOSURE
      select
      c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
      from
      AWLN_RELATIONSHIP_CLOSURE c1
      cross join AWLN_RELATIONSHIP_CLOSURE c2
      where c1.descendant_id = new.ancestor_id
      and c2.ancestor_id = new.descendant_id;

create trigger detach_awln_before before delete on
      AWLN_RELATIONSHIP
      for each row delete clos1 from
      AWLN_RELATIONSHIP_CLOSURE clos1
      join AWLN_RELATIONSHIP_CLOSURE clos2
      on
      clos1.descendant_id=clos2.descendant_id
      left join
      AWLN_RELATIONSHIP_CLOSURE clos3
      on clos3.ancestor_id = clos2.ancestor_id
      and clos3.descendant_id = clos1.ancestor_id
      where
      clos2.ancestor_id = old.descendant_id
      and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-306-closure-mysql-trigger', 'mqtran', 'tm/tm.changelog-1.22.0.xml', NOW(), 493, '8:99c94bd8dee7684f5708cbdd8be51714', 'sql; sql; sql; sql', 'mysql-triggers for AWLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date::jlor
ALTER TABLE ACTION_WORD ADD LAST_IMPLEMENTATION_TECHNOLOGY VARCHAR(30) NULL COMMENT 'Technology used for last implementation' , ADD LAST_IMPLEMENTATION_DATE datetime NULL COMMENT 'Date of last implementation';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 494, '8:fa4f55442bdc4ef925b0f0f7b47241e6', 'addColumn tableName=ACTION_WORD', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1284-migration-mysql::qtran
--  Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
--  Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
--  Remove all CUF values and CUF value options attaching to any deleted Requirement folder for postgresql
DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN TEST_CASE_FOLDER tcf
        ON cfv.BOUND_ENTITY_ID = tcf.TCLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER'
        AND tcf.TCLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER') AS cfv
        LEFT JOIN TEST_CASE_FOLDER tcf
        ON cfv.BOUND_ENTITY_ID = tcf.TCLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER'
        AND tcf.TCLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN CAMPAIGN_FOLDER cf
        ON cfv.BOUND_ENTITY_ID = cf.CLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER'
        AND cf.CLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER') AS cfv
        LEFT JOIN CAMPAIGN_FOLDER cf
        ON cfv.BOUND_ENTITY_ID = cf.CLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER'
        AND cf.CLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN REQUIREMENT_FOLDER rf
        ON cfv.BOUND_ENTITY_ID = rf.RLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER'
        AND rf.RLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER') AS cfv
        LEFT JOIN REQUIREMENT_FOLDER rf
        ON cfv.BOUND_ENTITY_ID = rf.RLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER'
        AND rf.RLN_ID is null
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1284-migration-mysql', 'qtran', 'tm/tm.changelog-1.22.0.xml', NOW(), 495, '8:844ad09002420d65905a1f0cb00722a0', 'sql; sql; sql', 'Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
Remove all CUF values and CUF value options at...', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url::akatz
ALTER TABLE TEST_CASE ADD SOURCE_CODE_REPOSITORY_URL VARCHAR(255) NULL COMMENT 'The url of the source code repository where the test lies' , ADD AUTOMATED_TEST_REFERENCE VARCHAR(255) NULL COMMENT 'The path to the test';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url', 'akatz', 'tm/tm.changelog-1.22.0.xml', NOW(), 496, '8:424581cf54ca82b5e98d6b7a11d5ece9', 'addColumn tableName=TEST_CASE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-1::aguilhem
--  Preparation for data migration
CREATE TABLE MIG_SQUASH_1975 (OLD_ID BIGINT NOT NULL, NEW_ID BIGINT NULL, CONSTRAINT PK_MIG_SQUASH_1975 PRIMARY KEY (OLD_ID)) ENGINE = INNODB;

ALTER TABLE TEST_AUTOMATION_PROJECT DROP FOREIGN KEY fk_ta_project_ta_server;

ALTER TABLE PROJECT DROP FOREIGN KEY tm_project_ta_server;

INSERT INTO MIG_SQUASH_1975 (OLD_ID, NEW_ID)
      SELECT TEST_AUTOMATION_SERVER.SERVER_ID, coalesce(max(THIRD_PARTY_SERVER.SERVER_ID),0) + TAS.TAS_MAX_ID + TEST_AUTOMATION_SERVER.SERVER_ID as NEW_ID
      FROM TEST_AUTOMATION_SERVER
      LEFT JOIN THIRD_PARTY_SERVER ON 1=1
      LEFT JOIN (SELECT coalesce(max(TEST_AUTOMATION_SERVER.SERVER_ID),0) AS TAS_MAX_ID FROM TEST_AUTOMATION_SERVER) AS TAS ON  1 = 1
      GROUP BY TEST_AUTOMATION_SERVER.SERVER_ID, TAS.TAS_MAX_ID
      ORDER BY TEST_AUTOMATION_SERVER.SERVER_ID;

INSERT INTO THIRD_PARTY_SERVER (SERVER_ID, NAME, URL, AUTH_POLICY, AUTH_PROTOCOL)
      SELECT MIG_SQUASH_1975.NEW_ID, TEST_AUTOMATION_SERVER.NAME, TEST_AUTOMATION_SERVER.BASE_URL, 'APP_LEVEL', 'BASIC_AUTH'
      FROM TEST_AUTOMATION_SERVER
      INNER JOIN MIG_SQUASH_1975 on MIG_SQUASH_1975.OLD_ID = TEST_AUTOMATION_SERVER.SERVER_ID
      ORDER BY TEST_AUTOMATION_SERVER.SERVER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-1', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 497, '8:2abe3a47754f5fabba4f030020b0b6e3', 'createTable tableName=MIG_SQUASH_1975; dropForeignKeyConstraint baseTableName=TEST_AUTOMATION_PROJECT, constraintName=fk_ta_project_ta_server; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=tm_project_ta_server; sql', 'Preparation for data migration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-2-mysql::aguilhem
--  Transform Test Automation Server to Third Party Server
UPDATE TEST_AUTOMATION_SERVER ta_server
      INNER JOIN MIG_SQUASH_1975 mig
      ON ta_server.SERVER_ID = mig.OLD_ID
      SET ta_server.SERVER_ID = mig.NEW_ID;

UPDATE TEST_AUTOMATION_PROJECT ta_proj
      INNER JOIN MIG_SQUASH_1975 mig
      ON ta_proj.SERVER_ID = mig.OLD_ID
      SET ta_proj.SERVER_ID = mig.NEW_ID;

UPDATE PROJECT proj
      INNER JOIN MIG_SQUASH_1975 mig
      ON proj.TA_SERVER_ID = mig.OLD_ID
      SET proj.TA_SERVER_ID = mig.NEW_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-2-mysql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 498, '8:7e59a4918ea64e2b44459c1ac6fce782', 'sql', 'Transform Test Automation Server to Third Party Server', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-3::aguilhem
--  Finalisation of test automation server data migration
ALTER TABLE TEST_AUTOMATION_SERVER DROP KEY UNI_AUTOTEST_SERVER;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN NAME;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN BASE_URL;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN LOGIN;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN PASSWORD;

ALTER TABLE TEST_AUTOMATION_PROJECT ADD CONSTRAINT fk_ta_project_ta_server FOREIGN KEY (SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE PROJECT ADD CONSTRAINT tm_project_ta_server FOREIGN KEY (TA_SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE TEST_AUTOMATION_SERVER ADD CONSTRAINT fk_test_automation_server_third_party_server FOREIGN KEY (SERVER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

DROP TABLE MIG_SQUASH_1975;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-3', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 499, '8:54e999b15137f7b0ea516c8f04d4aefe', 'dropUniqueConstraint constraintName=UNI_AUTOTEST_SERVER, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=NAME, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=BASE_URL, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=LOGIN,...', 'Finalisation of test automation server data migration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-4-mysql::aguilhem
--  For Mysql / Maria DB, remove the autoincrement on server_id
set foreign_key_checks=0;

alter table TEST_AUTOMATION_SERVER modify column SERVER_ID BIGINT not null;

set foreign_key_checks=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-4-mysql', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 500, '8:3c57a8bd44361b4d2a171cccef22573e', 'sql', 'For Mysql / Maria DB, remove the autoincrement on server_id', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-808-automated-suites-lifetime::jlor
ALTER TABLE PROJECT ADD AUTOMATED_SUITES_LIFETIME INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-808-automated-suites-lifetime', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 501, '8:686610a61a21f666f4433fe91d6d4f37', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement::jlor
--  Replace null descriptions by empty strings in requirements
update RESOURCE
      set DESCRIPTION = ''
      where DESCRIPTION is NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement', 'jlor', 'tm/tm.changelog-1.22.0.xml', NOW(), 502, '8:016cf5b75e98acf9ad9a2156392d1158', 'sql', 'Replace null descriptions by empty strings in requirements', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2106-automated-suite-attachment::aguilhem
--  Give possibility to AUTOMATED_SUITE to have ATTACHMENT
ALTER TABLE AUTOMATED_SUITE ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'foreign key to ATTACHMENT_LIST, entity dealing with attachment.';

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 503, '8:3a1e95ebd72330ea10047f0e5eb063b0', 'addColumn tableName=AUTOMATED_SUITE', 'Give possibility to AUTOMATED_SUITE to have ATTACHMENT', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2106-automated-suite-attachment-2::aguilhem
--  Create one attachment list for each automated suite
-- attachments, step 1 :
      -- create a ranking table, akin to what would ROW_NUMBER() order by id desc would say

      create table ASUITE_RANK as
      select asuite.suite_id, count(asuite2.suite_id)  as ranking
      from AUTOMATED_SUITE asuite,
      AUTOMATED_SUITE asuite2
      where asuite.suite_id <= asuite2.suite_id
      group by asuite.suite_id
      order by ranking asc;

-- attachments, step 2 :
      -- create a table that pairs suite ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier

      create table ASUITE_ATTACHLIST_PAIRING as
      select asuite.suite_id, (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + asuite.ranking as attachment_list_id
      from ASUITE_RANK asuite;

-- attachments, step 3 :
      -- insert the attachment lists and update fk in the automated suite
      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
      select pair.attachment_list_id from ASUITE_ATTACHLIST_PAIRING pair;

update AUTOMATED_SUITE asuite
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id from ASUITE_ATTACHLIST_PAIRING pair where pair.suite_id = asuite.suite_id);

-- attachments, step 4 and final :
      -- drop the temporary tables

      drop table ASUITE_ATTACHLIST_PAIRING;

drop table ASUITE_RANK;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment-2', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 504, '8:1f936d07cc345e9989ad30ba2003bd60', 'sql', 'Create one attachment list for each automated suite', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2141-automated-test-technology::aguilhem
--  create automated test technology table
CREATE TABLE AUTOMATED_TEST_TECHNOLOGY (AT_TECHNOLOGY_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(50) NOT NULL, ACTION_PROVIDER_KEY VARCHAR(50) NOT NULL, CONSTRAINT PK_AUTOMATED_TEST_TECHNOLOGY PRIMARY KEY (AT_TECHNOLOGY_ID)) ENGINE = INNODB;

insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('Robot Framework', 'robotframework/execute@v1'),
      ('Cypress', 'cypress/execute@v1'),
      ('JUnit', 'junit/execute@v1'),
      ('Cucumber', 'cucumber/execute@v1');

ALTER TABLE TEST_CASE ADD AUTOMATED_TEST_TECHNOLOGY BIGINT NULL COMMENT 'foreign key to AUTOMATED_TEST_TECHNOLOGY';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_test_case_automated_test_technology FOREIGN KEY (AUTOMATED_TEST_TECHNOLOGY) REFERENCES AUTOMATED_TEST_TECHNOLOGY (AT_TECHNOLOGY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2141-automated-test-technology', 'aguilhem', 'tm/tm.changelog-1.22.0.xml', NOW(), 505, '8:0004b1046102aac90079cfed96744a61', 'createTable tableName=AUTOMATED_TEST_TECHNOLOGY; sql; addColumn tableName=TEST_CASE', 'create automated test technology table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.0.xml::tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config::jprioux
--  add system parameter for autoconnect on connection configuration
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('autoconnect.on.connection.enabled', 'false');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config', 'jprioux', 'tm/tm.changelog-1.22.0.xml', NOW(), 506, '8:3a759e92d54d14ea83f54ec05c7e9e90', 'insert tableName=CORE_CONFIG', 'add system parameter for autoconnect on connection configuration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.2.xml', NOW(), 507, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.2' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2', 'jprioux', 'tm/tm.changelog-1.22.2.xml', NOW(), 508, '8:1d09c980a897f71d3d73c0ca2c47ce70', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-1-add-tc-scm-repository-id-column::jprioux
--  Add a new column in test case for link to scm repository
ALTER TABLE TEST_CASE ADD SCM_REPOSITORY_ID BIGINT NULL COMMENT 'foreign key to SCM_REPOSITORY, link to associated scm repository.';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_tc_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

CREATE INDEX idx_fk_tc_scm_repository ON TEST_CASE(SCM_REPOSITORY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-1-add-tc-scm-repository-id-column', 'jprioux', 'tm/tm.changelog-1.22.2.xml', NOW(), 509, '8:fd3c66d334caa1b7a5d6069caf9439ab', 'addColumn tableName=TEST_CASE; createIndex indexName=idx_fk_tc_scm_repository, tableName=TEST_CASE', 'Add a new column in test case for link to scm repository', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-2-scm-repository-url-temporary-table::jprioux
--  Create temporary table for migration
CREATE TABLE SCM_REPOSITORY_URL_MIGRATION_TEMP (TCLN_ID BIGINT NOT NULL, SOURCE_CODE_REPOSITORY_URL VARCHAR(255) NULL, SERVER_URL_FROM_TC VARCHAR(255) NULL, REPOSITORY_NAME_FROM_TC VARCHAR(255) NULL, SCM_SERVER_ID BIGINT NULL, SCM_REPOSITORY_ID BIGINT NULL, CONSTRAINT PK_SCM_REPOSITORY_URL_MIGRATION_TEMP PRIMARY KEY (TCLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-2-scm-repository-url-temporary-table', 'jprioux', 'tm/tm.changelog-1.22.2.xml', NOW(), 510, '8:2847aa4932eaed45bfa918715620ac19', 'createTable tableName=SCM_REPOSITORY_URL_MIGRATION_TEMP', 'Create temporary table for migration', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-3-mysql-migration-for-scm-repo-url::jprioux
--  Migration part if scm repository url has been added in tc
INSERT INTO SCM_REPOSITORY_URL_MIGRATION_TEMP
      SELECT tc.TCLN_ID,
             TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL)),
             REPLACE(TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL)), CONCAT('/', REVERSE(SUBSTRING_INDEX(REVERSE(TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL))), '/', 1))), ''),
             REVERSE(SUBSTRING_INDEX(REVERSE(TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL))), '/', 1)),
             null,
             null
      FROM TEST_CASE tc
      WHERE tc.SOURCE_CODE_REPOSITORY_URL IS NOT NULL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN TEST_CASE_LIBRARY_NODE tcln ON mig.TCLN_ID = tcln.TCLN_ID
      JOIN PROJECT p ON tcln.PROJECT_ID = p.PROJECT_ID
      JOIN SCM_REPOSITORY repo ON p.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID AND mig.REPOSITORY_NAME_FROM_TC = repo.NAME
      JOIN THIRD_PARTY_SERVER server ON server.SERVER_ID = repo.SERVER_ID and (mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL)
      SET mig.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID, mig.SCM_SERVER_ID = repo.SERVER_ID;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN TEST_CASE_LIBRARY_NODE tcln ON mig.TCLN_ID = tcln.TCLN_ID
      JOIN PROJECT p ON tcln.PROJECT_ID = p.PROJECT_ID
      JOIN SCM_REPOSITORY repo ON p.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID
      JOIN THIRD_PARTY_SERVER server ON server.SERVER_ID = repo.SERVER_ID and (mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL)
      SET mig.SCM_SERVER_ID = repo.SERVER_ID
      WHERE mig.SCM_SERVER_ID IS NULL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN SCM_REPOSITORY repo ON mig.REPOSITORY_NAME_FROM_TC = repo.NAME
      JOIN THIRD_PARTY_SERVER server ON server.SERVER_ID = repo.SERVER_ID and (mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL)
      SET mig.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID, mig.SCM_SERVER_ID = repo.SERVER_ID
      WHERE mig.SCM_REPOSITORY_ID IS NULL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN THIRD_PARTY_SERVER server ON mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL
      JOIN SCM_SERVER scmserver ON server.SERVER_ID = scmserver.SERVER_ID
      SET mig.SCM_SERVER_ID = scmserver.SERVER_ID
      WHERE mig.SCM_SERVER_ID IS NULL;

INSERT INTO THIRD_PARTY_SERVER (NAME, URL, AUTH_POLICY, AUTH_PROTOCOL)
      SELECT CONCAT('mig_git_', mig.TCLN_ID),
              mig.SERVER_URL_FROM_TC,
              'APP_LEVEL',
              'BASIC_AUTH'
      FROM SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      WHERE mig.SCM_SERVER_ID IS NULL
      GROUP BY mig.SERVER_URL_FROM_TC;

INSERT INTO SCM_SERVER (SERVER_ID, KIND)
      SELECT server.SERVER_ID,
             'git'
      FROM THIRD_PARTY_SERVER server
      LEFT JOIN SCM_SERVER scm ON server.SERVER_ID = scm.SERVER_ID
      WHERE scm.SERVER_ID IS NULL and server.NAME LIKE 'mig_git_%';

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN THIRD_PARTY_SERVER server ON server.URL = mig.SERVER_URL_FROM_TC
      SET mig.SCM_SERVER_ID = server.SERVER_ID
      WHERE mig.SCM_SERVER_ID IS NULL;

INSERT INTO SCM_REPOSITORY (SERVER_ID, NAME, REPOSITORY_PATH, WORKING_BRANCH)
      SELECT server.SERVER_ID,
             mig.REPOSITORY_NAME_FROM_TC,
             '',
             'master'
      FROM SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN THIRD_PARTY_SERVER server ON mig.SCM_SERVER_ID = server.SERVER_ID
      WHERE mig.SCM_REPOSITORY_ID IS NULL
      GROUP BY mig.SOURCE_CODE_REPOSITORY_URL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN SCM_REPOSITORY repo ON mig.SCM_SERVER_ID = repo.SERVER_ID and mig.REPOSITORY_NAME_FROM_TC = repo.NAME
      SET mig.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID
      WHERE mig.SCM_REPOSITORY_ID IS NULL;

UPDATE TEST_CASE tc
      JOIN SCM_REPOSITORY_URL_MIGRATION_TEMP mig ON tc.tcln_id = mig.TCLN_ID
      SET tc.SCM_REPOSITORY_ID = mig.SCM_REPOSITORY_ID
      WHERE mig.SCM_REPOSITORY_ID IS NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-3-mysql-migration-for-scm-repo-url', 'jprioux', 'tm/tm.changelog-1.22.2.xml', NOW(), 511, '8:e601c8de15c2cbd7147a13ad12a181eb', 'sql; sql; sql; sql; sql', 'Migration part if scm repository url has been added in tc', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-4-drop-old-column-and-temp-table::jprioux
--  Drop unnecessary old column and the temporary table
ALTER TABLE TEST_CASE DROP COLUMN SOURCE_CODE_REPOSITORY_URL;

DROP TABLE SCM_REPOSITORY_URL_MIGRATION_TEMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-4-drop-old-column-and-temp-table', 'jprioux', 'tm/tm.changelog-1.22.2.xml', NOW(), 512, '8:f96bcbcab7834eff17cc6da7d75d0b1d', 'dropColumn columnName=SOURCE_CODE_REPOSITORY_URL, tableName=TEST_CASE; dropTable tableName=SCM_REPOSITORY_URL_MIGRATION_TEMP', 'Drop unnecessary old column and the temporary table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2834-modify-scm-repo-unique-constraint::jlor
--  Modify SCM_REPOSITORY unique constraint (name, server_id) to (name, working_branch, server_id)
CREATE TABLE SCM_REPOSITORY_DATA_TEMP (SCM_REPOSITORY_ID BIGINT NOT NULL, SERVER_ID BIGINT NOT NULL, NAME VARCHAR(255) NOT NULL, WORKING_BRANCH VARCHAR(255) NOT NULL, REPOSITORY_PATH VARCHAR(255) NOT NULL, WORKING_FOLDER_PATH VARCHAR(255) NULL, CONSTRAINT PK_SCM_REPOSITORY_DATA_TEMP PRIMARY KEY (SCM_REPOSITORY_ID), CONSTRAINT fk_scm_repository_data_temp_scm_server FOREIGN KEY (SERVER_ID) REFERENCES SCM_SERVER(SERVER_ID)) ENGINE = INNODB;

INSERT INTO SCM_REPOSITORY_DATA_TEMP (SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH)
      SELECT SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH
      FROM SCM_REPOSITORY;

ALTER TABLE PROJECT DROP FOREIGN KEY fk_project_scm_repository;

ALTER TABLE TEST_CASE DROP FOREIGN KEY fk_tc_scm_repository;

DROP TABLE SCM_REPOSITORY;

CREATE TABLE SCM_REPOSITORY (SCM_REPOSITORY_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id of the scm repository.', SERVER_ID BIGINT NOT NULL COMMENT 'The foreign key to the related SCM_SEVER', NAME VARCHAR(255) NOT NULL COMMENT 'The name of the repository.', WORKING_BRANCH VARCHAR(255) NOT NULL COMMENT 'The name of the working branch on which SquashTM will push.', REPOSITORY_PATH VARCHAR(255) NOT NULL COMMENT 'The absolute path to the local repository on the local server.', WORKING_FOLDER_PATH VARCHAR(255) NULL COMMENT 'The relative path of the working folder in which SquashTM will push.', CONSTRAINT PK_SCM_REPOSITORY PRIMARY KEY (SCM_REPOSITORY_ID), CONSTRAINT fk_scm_repository_scm_server FOREIGN KEY (SERVER_ID) REFERENCES SCM_SERVER(SERVER_ID)) ENGINE = INNODB;

ALTER TABLE SCM_REPOSITORY ADD CONSTRAINT uniq_scm_repo_name_branch_server_id UNIQUE (NAME, WORKING_BRANCH, SERVER_ID);

CREATE INDEX idx_fk_scm_repository_scm_server ON SCM_REPOSITORY(SERVER_ID);

INSERT INTO SCM_REPOSITORY (SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH)
      SELECT SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH
      FROM SCM_REPOSITORY_DATA_TEMP;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_tc_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

DROP TABLE SCM_REPOSITORY_DATA_TEMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2834-modify-scm-repo-unique-constraint', 'jlor', 'tm/tm.changelog-1.22.2.xml', NOW(), 513, '8:9be1e9071813ddbb3900c7789932d3ae', 'createTable tableName=SCM_REPOSITORY_DATA_TEMP; sql; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_scm_repository; dropForeignKeyConstraint baseTableName=TEST_CASE, constraintName=fk_tc_scm_repository; dropTable tableNa...', 'Modify SCM_REPOSITORY unique constraint (name, server_id) to (name, working_branch, server_id)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.2.xml::tm-1.22.2-add-auto-test-tech::aguilhem
--  Add new compatible auto. test tech.
insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('SoapUI', 'soapui/execute@v1'),
      ('Agilitest', 'agilitest/execute@v1'),
      ('UFT', 'uft/execute@v1'),
      ('Ranorex', 'ranorex/execute@v1');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-add-auto-test-tech', 'aguilhem', 'tm/tm.changelog-1.22.2.xml', NOW(), 514, '8:bfa1aaf9176fea66ebdcbf35bf9601a8', 'sql', 'Add new compatible auto. test tech.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.3.xml::tm-1.22.3-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.3-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.3.xml', NOW(), 515, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.3.xml::tm-1.22.3::abo
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.3' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.3', 'abo', 'tm/tm.changelog-1.22.3.xml', NOW(), 516, '8:af6bd86e995970c48070cb1e1c13a42c', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.3.xml::tm-1.22.3-grant-waa-permission-on-tc-to-atw::abo
--  Grant WRITE AS AUTOMATION permission on test case to automation test writer
insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values (10, 3, 16384);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.3-grant-waa-permission-on-tc-to-atw', 'abo', 'tm/tm.changelog-1.22.3.xml', NOW(), 517, '8:1695dc83448c8af047c88cad9136fa23', 'sql', 'Grant WRITE AS AUTOMATION permission on test case to automation test writer', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.5.xml::tm-1.22.5-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.5-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-1.22.5.xml', NOW(), 518, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.5.xml::tm-1.22.5::agu
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.5' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.5', 'agu', 'tm/tm.changelog-1.22.5.xml', NOW(), 519, '8:63b73c08d86b5a6b1ad3a371b25517a6', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-1.22.5.xml::tm-1.22.5-add-skf-auto-test-tech::aguilhem
--  Add SKF to compatible auto. test tech.
insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('SKF', 'skf/execute@v1');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.5-add-skf-auto-test-tech', 'aguilhem', 'tm/tm.changelog-1.22.5.xml', NOW(), 520, '8:3213d65b3721fa769d9788f6fc8baa0e', 'sql', 'Add SKF to compatible auto. test tech.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-2.00.0.xml', NOW(), 521, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0::jthebault
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
--  Update TM database version number
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

UPDATE CORE_CONFIG SET VALUE = '2.00.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0', 'jthebault', 'tm/tm.changelog-2.00.0.xml', NOW(), 522, '8:a825b30fff38e2efedfd83294c39b4bb', 'sql; update tableName=CORE_CONFIG', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-fix-missing-indexes::jthebault
CREATE INDEX idx_rln_created_by ON REQUIREMENT_LIBRARY_NODE(CREATED_BY);

CREATE INDEX idx_rln_last_modified_by ON REQUIREMENT_LIBRARY_NODE(LAST_MODIFIED_BY);

CREATE INDEX idx_tcln_created_by ON TEST_CASE_LIBRARY_NODE(CREATED_BY);

CREATE INDEX idx_tcln_last_modified_by ON TEST_CASE_LIBRARY_NODE(LAST_MODIFIED_BY);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-fix-missing-indexes', 'jthebault', 'tm/tm.changelog-2.00.0.xml', NOW(), 523, '8:0fa23315b4723e8ada698ed92f6fde51', 'createIndex indexName=idx_rln_created_by, tableName=REQUIREMENT_LIBRARY_NODE; createIndex indexName=idx_rln_last_modified_by, tableName=REQUIREMENT_LIBRARY_NODE; createIndex indexName=idx_tcln_created_by, tableName=TEST_CASE_LIBRARY_NODE; createIn...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-default-test-case-nature-icon-name::aboittiaux
--  Change default tc nature icons
UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE CODE = 'NAT_USER_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'dashboard' WHERE CODE = 'NAT_PERFORMANCE_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'protect' WHERE CODE = 'NAT_SECURITY_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'circular_arrows' WHERE CODE = 'NAT_ATDD';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox_empty' WHERE CODE = 'NAT_UNDEFINED';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE CODE = 'NAT_FUNCTIONAL_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'server' WHERE CODE = 'NAT_NON_FUNCTIONAL_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'briefcase' WHERE CODE = 'NAT_BUSINESS_TESTING';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-default-test-case-nature-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', NOW(), 524, '8:8e21e8667030f50886d49d42cc1ff565', 'sql', 'Change default tc nature icons', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-default-test-case-type-icon-name::aboittiaux
--  Change default tc type icons
UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox_empty' WHERE CODE = 'TYP_UNDEFINED';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'task_completed' WHERE CODE = 'TYP_COMPLIANCE_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bug' WHERE CODE = 'TYP_CORRECTION_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'circled_up_right' WHERE CODE = 'TYP_EVOLUTION_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'circular_arrows' WHERE CODE = 'TYP_REGRESSION_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'journey' WHERE CODE = 'TYP_END_TO_END_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'handshake' WHERE CODE = 'TYP_PARTNER_TESTING';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-default-test-case-type-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', NOW(), 525, '8:728c6a9327901a02b3e071a758d460d1', 'sql', 'Change default tc type icons', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-default-requirement-category-icon-name::aboittiaux
--  Change default requirement category icons
UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE CODE = 'CAT_FUNCTIONAL';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'server' WHERE CODE = 'CAT_NON_FUNCTIONAL';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE CODE = 'CAT_USE_CASE';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'briefcase' WHERE CODE = 'CAT_BUSINESS';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'checked_checkbox' WHERE CODE = 'CAT_TEST_REQUIREMENT';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox_empty' WHERE CODE = 'CAT_UNDEFINED';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'puzzle' WHERE CODE = 'CAT_ERGONOMIC';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'dashboard' WHERE CODE = 'CAT_PERFORMANCE';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'key' WHERE CODE = 'CAT_TECHNICAL';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE CODE = 'CAT_USER_STORY';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'protect' WHERE CODE = 'CAT_SECURITY';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-default-requirement-category-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', NOW(), 526, '8:3b7c9340baecc4c5d4005df2b61be813', 'sql', 'Change default requirement category icons', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-custom-infolist-icon-name::aboittiaux
--  Change infolist item icons
CREATE INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM(ICON_NAME);

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'checkmark' WHERE ICON_NAME = 'accept';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'checkmark' WHERE ICON_NAME = 'accept_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'add' WHERE ICON_NAME = 'add';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'alarm';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'anchor';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_add';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_cascade';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_double';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_edit';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_form';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_get';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_go';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_home';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_key';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_link';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_osx';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_osx_terminal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_put';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_boxes';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_contract';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_expand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_list';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_tree';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_split';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_tile_horizontal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_tile_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_columns';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_detail';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_gallery';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_icons';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_list';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_tile';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_xp';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_xp_terminal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'split' WHERE ICON_NAME = 'arrow_branch';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'split' WHERE ICON_NAME = 'arrow_divide';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_in';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_inout';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'merge' WHERE ICON_NAME = 'arrow_join';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'merge' WHERE ICON_NAME = 'arrow_merge';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_out';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_redo';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'restart' WHERE ICON_NAME = 'arrow_refresh';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_undo';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'asterisk_orange';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'attach' WHERE ICON_NAME = 'attach';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'attach' WHERE ICON_NAME = 'attach_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'award_star_gold';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bandaid';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'basket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bell';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bin_closed';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'blog';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'blueprint';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'blueprint_horizontal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bluetooth';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bomb';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_book';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_book_open';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_document';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_folder';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'books';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_addresses';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_next';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_open';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_previous';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'box';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'brick';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bricks';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'briefcase' WHERE ICON_NAME = 'briefcase';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bug' WHERE ICON_NAME = 'bug';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'buildings';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'add' WHERE ICON_NAME = 'bullet_add_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'add' WHERE ICON_NAME = 'bullet_add_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'key' WHERE ICON_NAME = 'bullet_key';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cake';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'calculator';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'calendar' WHERE ICON_NAME = 'calendar_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'calendar' WHERE ICON_NAME = 'calendar_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'camera';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cancel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'car';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cart';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bar_chart' WHERE ICON_NAME = 'chart_bar';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'combo_chart' WHERE ICON_NAME = 'chart_curve';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'combo_chart' WHERE ICON_NAME = 'chart_line';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'flow_chart' WHERE ICON_NAME = 'chart_organisation';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'pie_chart' WHERE ICON_NAME = 'chart_pie';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_document' WHERE ICON_NAME = 'clipboard_paste_image';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_document' WHERE ICON_NAME = 'clipboard_sign';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_document' WHERE ICON_NAME = 'clipboard_text';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'clock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'settings' WHERE ICON_NAME = 'cog';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'coins';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'send_backward' WHERE ICON_NAME = 'color_swatch_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'color_swatch_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'topic' WHERE ICON_NAME = 'comment';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'compass';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'compress';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE ICON_NAME = 'computer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'connect';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'contrast';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_eject';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_end';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_equalizer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_fastforward';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_pause';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_play';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_repeat';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_rewind';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_start';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_stop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_wheel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_count';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_count_up';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_reset';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_stop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_octagon';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_octagon_fram';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_shield';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_shield_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'crown';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'crown_bronze';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'crown_silver';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'css';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cursor';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cut';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'dashboard' WHERE ICON_NAME = 'dashboard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'calendar' WHERE ICON_NAME = 'data';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'database' WHERE ICON_NAME = 'database';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'database' WHERE ICON_NAME = 'databases';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'unavailable' WHERE ICON_NAME = 'delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'delivery';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'desktop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'desktop_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'direction';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'disconnect';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'disk';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_access';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_convert';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_excel_csv';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_excel_table';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_film';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_illustrator';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_music';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_music_playlist';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_offlice';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_page';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_page_previous';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_pdf';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_photoshop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_resize';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_resize_actual';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_shred';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_stand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_table';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_tag';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_text_image';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'door';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'door_in';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'drawer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'drink';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'drink_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_burn';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_cd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_cd_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_disk';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_go';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_link';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_network';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_rename';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'dvd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'email';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'email_open';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'email_open_image';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_evilgrin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_grin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_happy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_smile';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_surprised';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_tongue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_unhappy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_waii';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_wink';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'envelope';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'envelope_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'error' WHERE ICON_NAME = 'error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'box_important' WHERE ICON_NAME = 'exclamation';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'box_important' WHERE ICON_NAME = 'exclamation_octagon_fram';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'eye' WHERE ICON_NAME = 'eye';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'feed';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'feed_ballon';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'feed_document';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'female';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'film';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'films';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'find';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'flag_filled' WHERE ICON_NAME = 'flag_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'folder' WHERE ICON_NAME = 'folder';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'font_size' WHERE ICON_NAME = 'font';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'funnel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'grid';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'grid_dot';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user_account' WHERE ICON_NAME = 'group';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'maintenance' WHERE ICON_NAME = 'hammer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'maintenance' WHERE ICON_NAME = 'hammer_screwdriver';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'hand' WHERE ICON_NAME = 'hand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'hand' WHERE ICON_NAME = 'hand_point';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_half';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_small';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'help' WHERE ICON_NAME = 'help';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'edit' WHERE ICON_NAME = 'highlighter';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'house';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'html';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'images';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'image_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'image_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'inbox';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ipod';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ipod_cast';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'joystick';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'key' WHERE ICON_NAME = 'key';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'keyboard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layers';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layer_treansparent';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_header_footer_3';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_header_footer_3_mix';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_join';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_join_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select_content';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select_footer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select_sidebar';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_split';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_split_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'lifebuoy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'reflector_bulb' WHERE ICON_NAME = 'lightbulb';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'reflector_bulb' WHERE ICON_NAME = 'lightbulb_off';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'lightning_bolt' WHERE ICON_NAME = 'lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'link' WHERE ICON_NAME = 'link';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'link' WHERE ICON_NAME = 'link_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'lock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'lock_unlock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'magnet';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'magnifier';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'magnifier_zoom_in';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'male';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'map';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'marker';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'medal_bronze_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'medal_gold_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'media_player_small_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'microphone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'mobile_phone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_dollar';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_euro';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_pound';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_yen';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE ICON_NAME = 'monitor';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'mouse';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'music';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'music_beam';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'neutral';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'new';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'newspaper';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'note';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'nuclear';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'package';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_2_copy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_code';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_copy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_excel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_paste';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_red';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_refresh';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_save';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_cplusplus';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_csharp';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_cup';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_database';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_dvd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_edit';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_excel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_find';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_flash';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_freehand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_gear';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_get';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_paintbrush';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_paste';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_php';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_picture';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_powerpoint';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_put';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_ruby';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_stack';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_star';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_swoosh';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_text';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_text_width';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_tux';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_vector';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_visualstudio';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_width';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_word';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_world';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_wrench';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_zip';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'edit' WHERE ICON_NAME = 'paintbrush';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paintcan';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'palette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paper_bag';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paste_plain';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paste_word';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'edit' WHERE ICON_NAME = 'pencil';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'photo';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'photos';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'photo_album';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'piano';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'picture';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pilcrow';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pill';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pipette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'plaing_card';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'plug';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'puzzle' WHERE ICON_NAME = 'plugin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'printer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'projection_screen';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'projection_screen_present';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rainbow';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bar_chart' WHERE ICON_NAME = 'report';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bar_chart' WHERE ICON_NAME = 'reporting_chart';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'statistics' WHERE ICON_NAME = 'reporting_dashboard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'reporting_datatable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'traffic_light' WHERE ICON_NAME = 'reporting_indicator';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'reporting_report';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rocket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rosette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rss';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruby';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_crop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_triangle';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'safe';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'sheet_of_paper' WHERE ICON_NAME = 'script';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'selection';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'selection_select';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'server' WHERE ICON_NAME = 'server';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shading';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_bottom';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_center';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_middle';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_top';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_flip_horizontal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_flip_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_group';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_handles';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_back';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_backwards';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_forwards';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_front';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_square';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'protect' WHERE ICON_NAME = 'shield';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sitemap';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'slide';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'slides';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'slides_stack';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_confuse';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_cool';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_cry';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_fat';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_mad';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_red';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_roll';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_slim';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_yell';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'socket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sockets';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_alphabet';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_date';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_disable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_number';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_price';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_quantity';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_rating';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sound';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sound_note';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'spellcheck';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_8ball';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_basketball';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_football';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_golf';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_raquet';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_shuttlecock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_soccer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_tennis';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'stamp';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'star' WHERE ICON_NAME = 'star_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'star' WHERE ICON_NAME = 'star_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'status_online';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'stop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'style';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sum';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sum_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'switch';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'tab';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'table';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'price_tag' WHERE ICON_NAME = 'tag';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'price_tag' WHERE ICON_NAME = 'tag_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'accuracy' WHERE ICON_NAME = 'target';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'telephone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE ICON_NAME = 'television';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'textfield';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'textfield_rename';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_center';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_justify';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_allcaps';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_bold';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_columns';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_dropcaps';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_heading_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_horizontalrule';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_indent';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_indent_remove';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_italic';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_kerning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_letterspacing';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_letter_omega';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_linespacing';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_list_bullets';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_list_numbers';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_lowercase';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_bottom';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_top';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_signature';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_smallcaps';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_strikethrough';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_subscript';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'ticket' WHERE ICON_NAME = 'ticket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'timeline_marker';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'traffic_light' WHERE ICON_NAME = 'traffic';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'transmit';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'trophy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'trophy_bronze';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'trophy_silver';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_combo_box';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_saccordion';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_slider_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_slider_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_bottom';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_content';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_disable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_side';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_text_field_hidden';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_text_field_password';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'umbrella';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_black_female';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_business';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_business_boss';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_female';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_silhouette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_thief';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_thief_baldie';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'vcard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'vector';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'sand_watch' WHERE ICON_NAME = 'wait';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall_brick';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall_disable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cloud' WHERE ICON_NAME = 'weather_clouds';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'partly_cloudy_day' WHERE ICON_NAME = 'weather_cloudy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cloud_lightning' WHERE ICON_NAME = 'weather_lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'storm' WHERE ICON_NAME = 'weather_rain';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'storm' WHERE ICON_NAME = 'weather_snow';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'sun' WHERE ICON_NAME = 'weather_sun';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'webcam';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'world';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'zone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'zones';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'zone_money';

DROP INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-custom-infolist-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', NOW(), 527, '8:2702bbf2ef02825046f13812e3b21369', 'createIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM; sql; dropIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM', 'Change infolist item icons', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-execution-tc-nat-icon-name::aboittiaux
--  Change execution tc nat icon name
CREATE INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION(TC_NAT_ICON_NAME);

CREATE INDEX idx_exec_tc_nat_code_temp ON EXECUTION(TC_NAT_CODE);

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'checkmark' WHERE TC_NAT_ICON_NAME = 'accept';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'checkmark' WHERE TC_NAT_ICON_NAME = 'accept_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'add' WHERE TC_NAT_ICON_NAME = 'add';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'alarm';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'anchor';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_add';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_cascade';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_double';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_edit';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_form';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_get';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_go';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_home';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_key';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_link';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_osx';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_osx_terminal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_put';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_boxes';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_contract';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_expand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_list';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_tree';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_split';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_tile_horizontal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_tile_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_columns';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_detail';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_gallery';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_icons';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_list';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_tile';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_xp';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_xp_terminal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'split' WHERE TC_NAT_ICON_NAME = 'arrow_branch';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'split' WHERE TC_NAT_ICON_NAME = 'arrow_divide';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_in';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_inout';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'merge' WHERE TC_NAT_ICON_NAME = 'arrow_join';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'merge' WHERE TC_NAT_ICON_NAME = 'arrow_merge';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_out';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_redo';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'restart' WHERE TC_NAT_ICON_NAME = 'arrow_refresh';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_undo';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'asterisk_orange';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'attach' WHERE TC_NAT_ICON_NAME = 'attach';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'attach' WHERE TC_NAT_ICON_NAME = 'attach_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'award_star_gold';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bandaid';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'basket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bell';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bin_closed';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'blog';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'blueprint';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'blueprint_horizontal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bluetooth';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bomb';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_book';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_book_open';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_document';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_folder';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'books';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_addresses';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_next';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_open';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_previous';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'box';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'brick';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bricks';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'briefcase' WHERE TC_NAT_ICON_NAME = 'briefcase';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bug' WHERE TC_NAT_ICON_NAME = 'bug';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'buildings';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'add' WHERE TC_NAT_ICON_NAME = 'bullet_add_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'add' WHERE TC_NAT_ICON_NAME = 'bullet_add_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'key' WHERE TC_NAT_ICON_NAME = 'bullet_key';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cake';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'calculator';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'calendar' WHERE TC_NAT_ICON_NAME = 'calendar_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'calendar' WHERE TC_NAT_ICON_NAME = 'calendar_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'camera';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cancel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'car';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cart';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bar_chart' WHERE TC_NAT_ICON_NAME = 'chart_bar';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'combo_chart' WHERE TC_NAT_ICON_NAME = 'chart_curve';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'combo_chart' WHERE TC_NAT_ICON_NAME = 'chart_line';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'flow_chart' WHERE TC_NAT_ICON_NAME = 'chart_organisation';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'pie_chart' WHERE TC_NAT_ICON_NAME = 'chart_pie';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_document' WHERE TC_NAT_ICON_NAME = 'clipboard_paste_image';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_document' WHERE TC_NAT_ICON_NAME = 'clipboard_sign';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_document' WHERE TC_NAT_ICON_NAME = 'clipboard_text';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'clock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'settings' WHERE TC_NAT_ICON_NAME = 'cog';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'coins';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'send_backward' WHERE TC_NAT_ICON_NAME = 'color_swatch_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'color_swatch_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'topic' WHERE TC_NAT_ICON_NAME = 'comment';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'compass';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'compress';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'monitor' WHERE TC_NAT_ICON_NAME = 'computer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'connect';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'contrast';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_eject';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_end';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_equalizer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_fastforward';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_pause';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_play';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_repeat';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_rewind';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_start';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_stop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_wheel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_count';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_count_up';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_reset';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_stop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_octagon';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_octagon_fram';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_shield';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_shield_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'crown';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'crown_bronze';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'crown_silver';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'css';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cursor';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cut';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'dashboard' WHERE TC_NAT_ICON_NAME = 'dashboard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'calendar' WHERE TC_NAT_ICON_NAME = 'data';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'database' WHERE TC_NAT_ICON_NAME = 'database';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'database' WHERE TC_NAT_ICON_NAME = 'databases';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'unavailable' WHERE TC_NAT_ICON_NAME = 'delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'delivery';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'desktop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'desktop_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'direction';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'disconnect';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'disk';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_access';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_convert';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_excel_csv';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_excel_table';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_film';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_illustrator';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_music';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_music_playlist';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_offlice';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_page';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_page_previous';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_pdf';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_photoshop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_resize';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_resize_actual';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_shred';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_stand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_table';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_tag';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_text_image';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'door';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'door_in';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'drawer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'drink';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'drink_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_burn';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_cd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_cd_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_disk';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_go';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_link';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_network';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_rename';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'dvd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'email';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'email_open';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'email_open_image';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_evilgrin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_grin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_happy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_smile';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_surprised';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_tongue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_unhappy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_waii';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_wink';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'envelope';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'envelope_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'error' WHERE TC_NAT_ICON_NAME = 'error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'box_important' WHERE TC_NAT_ICON_NAME = 'exclamation';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'box_important' WHERE TC_NAT_ICON_NAME = 'exclamation_octagon_fram';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'eye' WHERE TC_NAT_ICON_NAME = 'eye';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'feed';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'feed_ballon';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'feed_document';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'female';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'film';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'films';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'find';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'flag_filled' WHERE TC_NAT_ICON_NAME = 'flag_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'folder' WHERE TC_NAT_ICON_NAME = 'folder';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'font_size' WHERE TC_NAT_ICON_NAME = 'font';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'funnel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'grid';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'grid_dot';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user_account' WHERE TC_NAT_ICON_NAME = 'group';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'maintenance' WHERE TC_NAT_ICON_NAME = 'hammer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'maintenance' WHERE TC_NAT_ICON_NAME = 'hammer_screwdriver';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'hand' WHERE TC_NAT_ICON_NAME = 'hand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'hand' WHERE TC_NAT_ICON_NAME = 'hand_point';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_half';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_small';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'help' WHERE TC_NAT_ICON_NAME = 'help';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'edit' WHERE TC_NAT_ICON_NAME = 'highlighter';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'house';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'html';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'images';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'image_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'image_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'inbox';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ipod';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ipod_cast';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'joystick';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'key' WHERE TC_NAT_ICON_NAME = 'key';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'keyboard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layers';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layer_treansparent';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'layout_header_footer_3';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'layout_header_footer_3_mix';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_join';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_join_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select_content';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select_footer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select_sidebar';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_split';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_split_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'lifebuoy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'reflector_bulb' WHERE TC_NAT_ICON_NAME = 'lightbulb';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'reflector_bulb' WHERE TC_NAT_ICON_NAME = 'lightbulb_off';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'lightning_bolt' WHERE TC_NAT_ICON_NAME = 'lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'link' WHERE TC_NAT_ICON_NAME = 'link';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'link' WHERE TC_NAT_ICON_NAME = 'link_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'lock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'lock_unlock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'magnet';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'magnifier';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'magnifier_zoom_in';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'male';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'map';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'marker';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'medal_bronze_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'medal_gold_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'media_player_small_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'microphone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'mobile_phone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_dollar';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_euro';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_pound';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_yen';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'monitor' WHERE TC_NAT_ICON_NAME = 'monitor';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'mouse';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'music';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'music_beam';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'neutral';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'new';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'newspaper';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_CODE in ('NAT_UNDEFINED',
      'NAT_FUNCTIONAL_TESTING','NAT_BUSINESS_TESTING','NAT_USER_TESTING','NAT_NON_FUNCTIONAL_TESTING','NAT_PERFORMANCE_TESTING','NAT_SECURITY_TESTING','NAT_ATDD');

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'note';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'nuclear';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'package';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_2_copy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_code';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_copy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_excel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_paste';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_red';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_refresh';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_save';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_cplusplus';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_csharp';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_cup';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_database';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_dvd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_edit';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_excel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_find';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_flash';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_freehand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_gear';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_get';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_paintbrush';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_paste';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_php';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_picture';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_powerpoint';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_put';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_ruby';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_stack';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_star';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_swoosh';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_text';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_text_width';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_tux';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_vector';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_visualstudio';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_width';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_word';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_world';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_wrench';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_zip';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'edit' WHERE TC_NAT_ICON_NAME = 'paintbrush';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paintcan';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'palette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paper_bag';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paste_plain';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paste_word';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'edit' WHERE TC_NAT_ICON_NAME = 'pencil';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'photo';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'photos';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'photo_album';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'piano';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'picture';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pilcrow';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pill';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pipette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'plaing_card';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'plug';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'puzzle' WHERE TC_NAT_ICON_NAME = 'plugin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'printer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'projection_screen';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'projection_screen_present';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rainbow';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bar_chart' WHERE TC_NAT_ICON_NAME = 'report';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bar_chart' WHERE TC_NAT_ICON_NAME = 'reporting_chart';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'statistics' WHERE TC_NAT_ICON_NAME = 'reporting_dashboard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'reporting_datatable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'traffic_light' WHERE TC_NAT_ICON_NAME = 'reporting_indicator';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'reporting_report';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rocket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rosette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rss';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruby';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_crop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_triangle';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'safe';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'sheet_of_paper' WHERE TC_NAT_ICON_NAME = 'script';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'selection';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'selection_select';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'server' WHERE TC_NAT_ICON_NAME = 'server';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shading';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_bottom';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_center';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_middle';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_top';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_flip_horizontal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_flip_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_group';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_handles';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_back';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_backwards';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_forwards';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_front';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_square';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'protect' WHERE TC_NAT_ICON_NAME = 'shield';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sitemap';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'slide';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'slides';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'slides_stack';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_confuse';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_cool';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_cry';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_fat';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_mad';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_red';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_roll';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_slim';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_yell';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'socket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sockets';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_alphabet';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_date';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_disable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_number';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_price';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_quantity';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_rating';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sound';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sound_note';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'spellcheck';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_8ball';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_basketball';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_football';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_golf';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_raquet';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_shuttlecock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_soccer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_tennis';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'stamp';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'star' WHERE TC_NAT_ICON_NAME = 'star_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'star' WHERE TC_NAT_ICON_NAME = 'star_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'status_online';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'stop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'style';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sum';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sum_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'switch';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'tab';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'table';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'price_tag' WHERE TC_NAT_ICON_NAME = 'tag';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'price_tag' WHERE TC_NAT_ICON_NAME = 'tag_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'accuracy' WHERE TC_NAT_ICON_NAME = 'target';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'telephone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'monitor' WHERE TC_NAT_ICON_NAME = 'television';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'textfield';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'textfield_rename';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_center';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_justify';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_allcaps';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_bold';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_columns';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_dropcaps';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_heading_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_horizontalrule';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_indent';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_indent_remove';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_italic';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_kerning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_letterspacing';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_letter_omega';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_linespacing';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_list_bullets';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_list_numbers';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_lowercase';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_bottom';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_top';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_signature';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_smallcaps';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_strikethrough';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_subscript';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'ticket' WHERE TC_NAT_ICON_NAME = 'ticket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'timeline_marker';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'traffic_light' WHERE TC_NAT_ICON_NAME = 'traffic';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'transmit';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'trophy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'trophy_bronze';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'trophy_silver';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_combo_box';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_saccordion';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_slider_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_slider_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_bottom';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_content';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_disable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_side';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_text_field_hidden';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'ui_text_field_password';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'umbrella';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_black_female';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_business';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_business_boss';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_female';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_silhouette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_thief';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_thief_baldie';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'vcard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'vector';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'sand_watch' WHERE TC_NAT_ICON_NAME = 'wait';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall_brick';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall_disable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cloud' WHERE TC_NAT_ICON_NAME = 'weather_clouds';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'partly_cloudy_day' WHERE TC_NAT_ICON_NAME = 'weather_cloudy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cloud_lightning' WHERE TC_NAT_ICON_NAME = 'weather_lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'storm' WHERE TC_NAT_ICON_NAME = 'weather_rain';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'storm' WHERE TC_NAT_ICON_NAME = 'weather_snow';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'sun' WHERE TC_NAT_ICON_NAME = 'weather_sun';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'webcam';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'world';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'zone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'zones';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'zone_money';

DROP INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION;

DROP INDEX idx_exec_tc_nat_code_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-execution-tc-nat-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', NOW(), 528, '8:da5ca52c754665dc5e7a0914c211a182', 'createIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; dropIndex indexName=idx_...', 'Change execution tc nat icon name', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-execution-tc-typ-icon-name::aboittiaux
--  Change execution tc typ icon name
CREATE INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION(TC_TYP_ICON_NAME);

CREATE INDEX idx_exec_tc_typ_code_temp ON EXECUTION(TC_TYP_CODE);

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'checkmark' WHERE TC_TYP_ICON_NAME = 'accept';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'checkmark' WHERE TC_TYP_ICON_NAME = 'accept_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'add' WHERE TC_TYP_ICON_NAME = 'add';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'alarm';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'anchor';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_add';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_cascade';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_double';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_edit';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_form';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_get';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_go';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_home';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_key';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_link';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_osx';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_osx_terminal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_put';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_boxes';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_contract';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_expand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_list';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_tree';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_split';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_tile_horizontal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_tile_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_columns';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_detail';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_gallery';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_icons';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_list';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_tile';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_xp';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_xp_terminal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'split' WHERE TC_TYP_ICON_NAME = 'arrow_branch';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'split' WHERE TC_TYP_ICON_NAME = 'arrow_divide';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_in';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_inout';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'merge' WHERE TC_TYP_ICON_NAME = 'arrow_join';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'merge' WHERE TC_TYP_ICON_NAME = 'arrow_merge';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_out';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_redo';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'restart' WHERE TC_TYP_ICON_NAME = 'arrow_refresh';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_undo';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'asterisk_orange';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'attach' WHERE TC_TYP_ICON_NAME = 'attach';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'attach' WHERE TC_TYP_ICON_NAME = 'attach_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'award_star_gold';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bandaid';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'basket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bell';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bin_closed';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'blog';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'blueprint';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'blueprint_horizontal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bluetooth';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bomb';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_book';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_book_open';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_document';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_folder';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'books';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_addresses';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_next';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_open';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_previous';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'box';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'brick';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bricks';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'briefcase' WHERE TC_TYP_ICON_NAME = 'briefcase';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bug' WHERE TC_TYP_ICON_NAME = 'bug';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'buildings';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'add' WHERE TC_TYP_ICON_NAME = 'bullet_add_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'add' WHERE TC_TYP_ICON_NAME = 'bullet_add_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'key' WHERE TC_TYP_ICON_NAME = 'bullet_key';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cake';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'calculator';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'calendar' WHERE TC_TYP_ICON_NAME = 'calendar_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'calendar' WHERE TC_TYP_ICON_NAME = 'calendar_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'camera';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cancel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'car';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cart';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bar_chart' WHERE TC_TYP_ICON_NAME = 'chart_bar';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'combo_chart' WHERE TC_TYP_ICON_NAME = 'chart_curve';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'combo_chart' WHERE TC_TYP_ICON_NAME = 'chart_line';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'flow_chart' WHERE TC_TYP_ICON_NAME = 'chart_organisation';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'pie_chart' WHERE TC_TYP_ICON_NAME = 'chart_pie';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_document' WHERE TC_TYP_ICON_NAME = 'clipboard_paste_image';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_document' WHERE TC_TYP_ICON_NAME = 'clipboard_sign';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_document' WHERE TC_TYP_ICON_NAME = 'clipboard_text';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'clock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'settings' WHERE TC_TYP_ICON_NAME = 'cog';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'coins';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'send_backward' WHERE TC_TYP_ICON_NAME = 'color_swatch_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'color_swatch_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'topic' WHERE TC_TYP_ICON_NAME = 'comment';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'compass';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'compress';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'monitor' WHERE TC_TYP_ICON_NAME = 'computer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'connect';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'contrast';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_eject';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_end';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_equalizer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_fastforward';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_pause';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_play';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_repeat';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_rewind';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_start';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_stop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_wheel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_count';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_count_up';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_reset';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_stop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_octagon';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_octagon_fram';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_shield';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_shield_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'crown';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'crown_bronze';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'crown_silver';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'css';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cursor';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cut';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'dashboard' WHERE TC_TYP_ICON_NAME = 'dashboard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'calendar' WHERE TC_TYP_ICON_NAME = 'data';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'database' WHERE TC_TYP_ICON_NAME = 'database';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'database' WHERE TC_TYP_ICON_NAME = 'databases';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'unavailable' WHERE TC_TYP_ICON_NAME = 'delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'delivery';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'desktop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'desktop_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'direction';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'disconnect';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'disk';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_access';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_convert';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_excel_csv';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_excel_table';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_film';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_illustrator';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_music';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_music_playlist';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_offlice';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_page';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_page_previous';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_pdf';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_photoshop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_resize';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_resize_actual';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_shred';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_stand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_table';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_tag';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_text_image';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'door';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'door_in';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'drawer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'drink';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'drink_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_burn';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_cd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_cd_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_disk';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_go';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_link';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_network';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_rename';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'dvd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'email';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'email_open';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'email_open_image';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_evilgrin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_grin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_happy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_smile';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_surprised';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_tongue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_unhappy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_waii';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_wink';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'envelope';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'envelope_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'error' WHERE TC_TYP_ICON_NAME = 'error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'box_important' WHERE TC_TYP_ICON_NAME = 'exclamation';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'box_important' WHERE TC_TYP_ICON_NAME = 'exclamation_octagon_fram';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'eye' WHERE TC_TYP_ICON_NAME = 'eye';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'feed';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'feed_ballon';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'feed_document';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'female';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'film';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'films';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'find';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'flag_filled' WHERE TC_TYP_ICON_NAME = 'flag_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'folder' WHERE TC_TYP_ICON_NAME = 'folder';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'font_size' WHERE TC_TYP_ICON_NAME = 'font';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'funnel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'grid';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'grid_dot';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user_account' WHERE TC_TYP_ICON_NAME = 'group';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'maintenance' WHERE TC_TYP_ICON_NAME = 'hammer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'maintenance' WHERE TC_TYP_ICON_NAME = 'hammer_screwdriver';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'hand' WHERE TC_TYP_ICON_NAME = 'hand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'hand' WHERE TC_TYP_ICON_NAME = 'hand_point';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_half';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_small';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'help' WHERE TC_TYP_ICON_NAME = 'help';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'edit' WHERE TC_TYP_ICON_NAME = 'highlighter';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'house';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'html';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'images';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'image_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'image_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'inbox';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ipod';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ipod_cast';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'joystick';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'key' WHERE TC_TYP_ICON_NAME = 'key';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'keyboard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layers';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layer_treansparent';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'layout_header_footer_3';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'layout_header_footer_3_mix';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_join';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_join_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select_content';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select_footer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select_sidebar';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_split';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_split_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'lifebuoy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'reflector_bulb' WHERE TC_TYP_ICON_NAME = 'lightbulb';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'reflector_bulb' WHERE TC_TYP_ICON_NAME = 'lightbulb_off';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'lightning_bolt' WHERE TC_TYP_ICON_NAME = 'lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'link' WHERE TC_TYP_ICON_NAME = 'link';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'link' WHERE TC_TYP_ICON_NAME = 'link_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'lock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'lock_unlock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'magnet';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'magnifier';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'magnifier_zoom_in';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'male';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'map';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'marker';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'medal_bronze_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'medal_gold_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'media_player_small_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'microphone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'mobile_phone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_dollar';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_euro';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_pound';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_yen';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'monitor' WHERE TC_TYP_ICON_NAME = 'monitor';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'mouse';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'music';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'music_beam';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'neutral';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'new';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'newspaper';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_CODE in ('TYP_UNDEFINED',
      'TYP_COMPLIANCE_TESTING', 'TYP_CORRECTION_TESTING', 'TYP_EVOLUTION_TESTING', 'TYP_REGRESSION_TESTING',
      'TYP_END_TO_END_TESTING', 'TYP_PARTNER_TESTING');

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'note';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'nuclear';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'package';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_2_copy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_code';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_copy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_excel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_paste';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_red';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_refresh';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_save';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_cplusplus';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_csharp';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_cup';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_database';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_dvd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_edit';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_excel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_find';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_flash';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_freehand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_gear';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_get';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_paintbrush';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_paste';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_php';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_picture';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_powerpoint';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_put';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_ruby';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_stack';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_star';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_swoosh';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_text';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_text_width';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_tux';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_vector';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_visualstudio';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_width';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_word';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_world';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_wrench';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_zip';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'edit' WHERE TC_TYP_ICON_NAME = 'paintbrush';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paintcan';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'palette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paper_bag';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paste_plain';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paste_word';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'edit' WHERE TC_TYP_ICON_NAME = 'pencil';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'photo';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'photos';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'photo_album';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'piano';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'picture';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pilcrow';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pill';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pipette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'plaing_card';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'plug';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'puzzle' WHERE TC_TYP_ICON_NAME = 'plugin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'printer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'projection_screen';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'projection_screen_present';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rainbow';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bar_chart' WHERE TC_TYP_ICON_NAME = 'report';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bar_chart' WHERE TC_TYP_ICON_NAME = 'reporting_chart';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'statistics' WHERE TC_TYP_ICON_NAME = 'reporting_dashboard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'reporting_datatable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'traffic_light' WHERE TC_TYP_ICON_NAME = 'reporting_indicator';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'reporting_report';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rocket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rosette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rss';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruby';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_crop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_triangle';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'safe';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'sheet_of_paper' WHERE TC_TYP_ICON_NAME = 'script';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'selection';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'selection_select';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'server' WHERE TC_TYP_ICON_NAME = 'server';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shading';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_bottom';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_center';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_middle';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_top';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_flip_horizontal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_flip_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_group';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_handles';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_back';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_backwards';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_forwards';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_front';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_square';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'protect' WHERE TC_TYP_ICON_NAME = 'shield';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sitemap';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'slide';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'slides';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'slides_stack';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_confuse';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_cool';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_cry';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_fat';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_mad';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_red';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_roll';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_slim';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_yell';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'socket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sockets';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_alphabet';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_date';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_disable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_number';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_price';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_quantity';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_rating';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sound';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sound_note';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'spellcheck';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_8ball';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_basketball';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_football';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_golf';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_raquet';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_shuttlecock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_soccer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_tennis';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'stamp';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'star' WHERE TC_TYP_ICON_NAME = 'star_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'star' WHERE TC_TYP_ICON_NAME = 'star_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'status_online';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'stop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'style';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sum';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sum_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'switch';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'tab';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'table';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'price_tag' WHERE TC_TYP_ICON_NAME = 'tag';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'price_tag' WHERE TC_TYP_ICON_NAME = 'tag_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'accuracy' WHERE TC_TYP_ICON_NAME = 'target';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'telephone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'monitor' WHERE TC_TYP_ICON_NAME = 'television';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'textfield';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'textfield_rename';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_center';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_justify';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_allcaps';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_bold';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_columns';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_dropcaps';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_heading_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_horizontalrule';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_indent';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_indent_remove';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_italic';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_kerning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_letterspacing';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_letter_omega';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_linespacing';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_list_bullets';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_list_numbers';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_lowercase';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_bottom';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_top';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_signature';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_smallcaps';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_strikethrough';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_subscript';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'ticket' WHERE TC_TYP_ICON_NAME = 'ticket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'timeline_marker';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'traffic_light' WHERE TC_TYP_ICON_NAME = 'traffic';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'transmit';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'trophy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'trophy_bronze';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'trophy_silver';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_combo_box';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_saccordion';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_slider_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_slider_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_bottom';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_content';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_disable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_side';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_text_field_hidden';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'ui_text_field_password';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'umbrella';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_black_female';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_business';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_business_boss';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_female';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_silhouette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_thief';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_thief_baldie';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'vcard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'vector';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'sand_watch' WHERE TC_TYP_ICON_NAME = 'wait';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall_brick';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall_disable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cloud' WHERE TC_TYP_ICON_NAME = 'weather_clouds';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'partly_cloudy_day' WHERE TC_TYP_ICON_NAME = 'weather_cloudy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cloud_lightning' WHERE TC_TYP_ICON_NAME = 'weather_lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'storm' WHERE TC_TYP_ICON_NAME = 'weather_rain';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'storm' WHERE TC_TYP_ICON_NAME = 'weather_snow';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'sun' WHERE TC_TYP_ICON_NAME = 'weather_sun';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'webcam';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'world';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'zone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'zones';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'zone_money';

DROP INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION;

DROP INDEX idx_exec_tc_typ_code_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-execution-tc-typ-icon-name', 'aboittiaux', 'tm/tm.changelog-2.00.0.xml', NOW(), 529, '8:6936047ac4dc1fd64de93ce250aa272a', 'createIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_typ_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; dropIndex indexName=idx_...', 'Change execution tc typ icon name', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-grant-attach-permission-on-projects-to-pms::pckerneis
--  Grant ATTACH permission on projects to project managers
insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values
      (5, 1, 1024);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-grant-attach-permission-on-projects-to-pms', 'pckerneis', 'tm/tm.changelog-2.00.0.xml', NOW(), 530, '8:fab951e5be1a6abbdeda2f0ab7bdb3ef', 'sql', 'Grant ATTACH permission on projects to project managers', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-missing-entries-in-awln_relationship_closure::jlor
--  insert missing entries in awln_relationship_closure: former projects data were not inserted.
INSERT INTO AWLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID, DESCENDANT_ID, DEPTH)
      SELECT n.awln_id, n.awln_id, 0
      FROM ACTION_WORD_LIBRARY_NODE n
      LEFT JOIN AWLN_RELATIONSHIP_CLOSURE cl on n.awln_id = cl.ancestor_id
      WHERE n.entity_type = 'LIBRARY' and cl.ancestor_id is null
      UNION
      SELECT parent.awln_id, child.awln_id, 1
      FROM ACTION_WORD_LIBRARY_NODE child
      JOIN ACTION_WORD_LIBRARY_NODE parent on child.awl_id = parent.entity_id and parent.entity_type = 'LIBRARY'
      LEFT JOIN AWLN_RELATIONSHIP_CLOSURE cl on child.awln_id = cl.descendant_id and cl.depth = 1
      WHERE child.entity_type = 'ACTION_WORD' and cl.ANCESTOR_ID is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-missing-entries-in-awln_relationship_closure', 'jlor', 'tm/tm.changelog-2.00.0.xml', NOW(), 531, '8:43287961f9dd755fe8da39bfc5d09c7a', 'sql', 'insert missing entries in awln_relationship_closure: former projects data were not inserted.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-grant-read-permission-on-projects-to-atw::abo
--  Grant READ permission on projects to automation test writer
insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values (10, 1, 1);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-grant-read-permission-on-projects-to-atw', 'abo', 'tm/tm.changelog-2.00.0.xml', NOW(), 532, '8:244707d9175446e17e41de62745396ee', 'sql', 'Grant READ permission on projects to automation test writer', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-fix-resource-missing-indexes::jthebault
CREATE INDEX idx_resource_created_by ON `RESOURCE`(CREATED_BY);

CREATE INDEX idx_resource_last_modified_by ON `RESOURCE`(LAST_MODIFIED_BY);

CREATE INDEX idx_resource_name ON `RESOURCE`(NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-fix-resource-missing-indexes', 'jthebault', 'tm/tm.changelog-2.00.0.xml', NOW(), 533, '8:be2dd0b9c7be8c624c5680eca0717f21', 'createIndex indexName=idx_resource_created_by, tableName=RESOURCE; createIndex indexName=idx_resource_last_modified_by, tableName=RESOURCE; createIndex indexName=idx_resource_name, tableName=RESOURCE', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-change-item_test_plan_lastexecby-entity-type::jthebault
--  Fix sort on ITEM_TEST_PLAN_LASTEXECBY column - issue 3768
UPDATE QUERY_COLUMN_PROTOTYPE SET ENTITY_TYPE = 'ITEM_TEST_PLAN' WHERE LABEL = 'ITEM_TEST_PLAN_LASTEXECBY';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-change-item_test_plan_lastexecby-entity-type', 'jthebault', 'tm/tm.changelog-2.00.0.xml', NOW(), 534, '8:f19960fbaf5bbd347ed3424f4e8b8a88', 'sql', 'Fix sort on ITEM_TEST_PLAN_LASTEXECBY column - issue 3768', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.00.0.xml::tm-2.00.0-add-dataset-name-column-prototype::jthebault
--  Fix sort on ITEM_TEST_PLAN_DATASET_LABEL column - issue 3988
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS) VALUES
        ('ATTRIBUTE', 'DATASET', NULL, 'DATASET_NAME', 'name', 'STRING', FALSE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-add-dataset-name-column-prototype', 'jthebault', 'tm/tm.changelog-2.00.0.xml', NOW(), 535, '8:b554be85fc5bd66e2885a094f79775ae', 'sql', 'Fix sort on ITEM_TEST_PLAN_DATASET_LABEL column - issue 3988', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.1.0.xml::tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-2.1.0.xml', NOW(), 536, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.1.0.xml::tm-2.1.0::dclaerhout
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '2.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0', 'dclaerhout', 'tm/tm.changelog-2.1.0.xml', NOW(), 537, '8:58af94593b5537caa99340aa72618824', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.1.0.xml::tm-2.1.0-add-remote-req-perimeter-status::dclaerhout
ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD REMOTE_REQ_PERIMETER_STATUS VARCHAR(30) DEFAULT 'UNKNOWN' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-add-remote-req-perimeter-status', 'dclaerhout', 'tm/tm.changelog-2.1.0.xml', NOW(), 538, '8:692f8c68acac6e331b0a29eb8c086a4d', 'addColumn tableName=REQUIREMENT_SYNC_EXTENDER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.1.0.xml::tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart::jprioux
--  Remove the USER_ID columns and associated foreign keys
ALTER TABLE CHART_DEFINITION DROP FOREIGN KEY fk_chart_owner;

ALTER TABLE CHART_DEFINITION DROP COLUMN USER_ID;

ALTER TABLE REPORT_DEFINITION DROP FOREIGN KEY fk_report_owner;

ALTER TABLE REPORT_DEFINITION DROP COLUMN USER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart', 'jprioux', 'tm/tm.changelog-2.1.0.xml', NOW(), 539, '8:7742eb5108ca31bae3ac8987b55f2a92', 'dropForeignKeyConstraint baseTableName=CHART_DEFINITION, constraintName=fk_chart_owner; dropColumn columnName=USER_ID, tableName=CHART_DEFINITION; dropForeignKeyConstraint baseTableName=REPORT_DEFINITION, constraintName=fk_report_owner; dropColumn...', 'Remove the USER_ID columns and associated foreign keys', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-2.1.0.xml::tm-2.1.0-add-template-configurable-plugin-binding::pckerneis
--  Add the template_configurable_plugin_binding table.
CREATE TABLE TEMPLATE_CONFIGURABLE_PLUGIN_BINDING (BINDING_ID BIGINT AUTO_INCREMENT NOT NULL, PROJECT_TEMPLATE_ID BIGINT NOT NULL, PROJECT_ID BIGINT NOT NULL, PLUGIN_ID VARCHAR(50) NOT NULL, CONSTRAINT PK_TEMPLATE_CONFIGURABLE_PLUGIN_BINDING PRIMARY KEY (BINDING_ID), CONSTRAINT fk_template_configurable_plugin_binding__template__project_id FOREIGN KEY (PROJECT_TEMPLATE_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_template_configurable_plugin_binding__project__project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-add-template-configurable-plugin-binding', 'pckerneis', 'tm/tm.changelog-2.1.0.xml', NOW(), 540, '8:94099c234b0589cdc0de65e2700f67c6', 'createTable tableName=TEMPLATE_CONFIGURABLE_PLUGIN_BINDING', 'Add the template_configurable_plugin_binding table.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-3.0.0.xml', NOW(), 541, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '3.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0', 'jprioux', 'tm/tm.changelog-3.0.0.xml', NOW(), 542, '8:9254911af0917cdffe1fae5d26ededaa', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4293-update-execution-nat-and-typ-icon-name::jprioux
--  Update nature and type icon name for execution with native info list
CREATE INDEX idx_exec_tc_nat_code_temp ON EXECUTION(TC_NAT_CODE);

CREATE INDEX idx_exec_tc_typ_code_temp ON EXECUTION(TC_TYP_CODE);

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'user'
      WHERE TC_NAT_CODE = 'NAT_USER_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'dashboard'
      WHERE TC_NAT_CODE = 'NAT_PERFORMANCE_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'protect'
      WHERE TC_NAT_CODE = 'NAT_SECURITY_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'circular_arrows'
      WHERE TC_NAT_CODE = 'NAT_ATDD';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'indeterminate_checkbox_empty'
      WHERE TC_NAT_CODE = 'NAT_UNDEFINED';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'monitor'
      WHERE TC_NAT_CODE = 'NAT_FUNCTIONAL_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'server'
      WHERE TC_NAT_CODE = 'NAT_NON_FUNCTIONAL_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'briefcase'
      WHERE TC_NAT_CODE = 'NAT_BUSINESS_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'indeterminate_checkbox_empty'
      WHERE TC_TYP_CODE = 'TYP_UNDEFINED';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'task_completed'
      WHERE TC_TYP_CODE = 'TYP_COMPLIANCE_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'bug'
      WHERE TC_TYP_CODE = 'TYP_CORRECTION_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'circled_up_right'
      WHERE TC_TYP_CODE = 'TYP_EVOLUTION_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'circular_arrows'
      WHERE TC_TYP_CODE = 'TYP_REGRESSION_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'journey'
      WHERE TC_TYP_CODE = 'TYP_END_TO_END_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'handshake'
      WHERE TC_TYP_CODE = 'TYP_PARTNER_TESTING';

DROP INDEX idx_exec_tc_nat_code_temp ON EXECUTION;

DROP INDEX idx_exec_tc_typ_code_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4293-update-execution-nat-and-typ-icon-name', 'jprioux', 'tm/tm.changelog-3.0.0.xml', NOW(), 543, '8:ce9cc7b5d5edf3f2464876428719a92d', 'createIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_typ_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; dropIndex indexName=idx_exec_tc_ty...', 'Update nature and type icon name for execution with native info list', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-increase-varchar-number-for-dataset-param-value::dclaerhout
--  Change varchar from 255 to 1024 for dataset param value
ALTER TABLE DATASET_PARAM_VALUE MODIFY PARAM_VALUE VARCHAR(1024);

ALTER TABLE DATASET_PARAM_VALUE MODIFY PARAM_VALUE VARCHAR(1024) NOT NULL;

ALTER TABLE DATASET_PARAM_VALUE ALTER PARAM_VALUE SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-increase-varchar-number-for-dataset-param-value', 'dclaerhout', 'tm/tm.changelog-3.0.0.xml', NOW(), 544, '8:412f61602b04daa0d1ef4fddb206e7c1', 'modifyDataType columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE; addNotNullConstraint columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE; addDefaultValue columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE', 'Change varchar from 255 to 1024 for dataset param value', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4299-update-def-icon-name-001::jprioux
--  Update all def icon name when used in info list item
CREATE INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM(ICON_NAME);

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'monitor'
      WHERE ICON_NAME = 'def_cat_functional';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'server'
      WHERE ICON_NAME = 'def_cat_non-functional';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'read'
      WHERE ICON_NAME = 'def_cat_use-case';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'briefcase'
      WHERE ICON_NAME = 'def_cat_business';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'checked_checkbox'
      WHERE ICON_NAME in ('def_cat_test-requirement', 'def_cat_noicon');

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'checkmark'
      WHERE ICON_NAME = 'def_cat_undefined';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'puzzle'
      WHERE ICON_NAME = 'def_cat_ergonomic';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'dashboard'
      WHERE ICON_NAME = 'def_cat_performance';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'key'
      WHERE ICON_NAME in ('def_cat_technical', 'def_cat_technic');

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'bookmark'
      WHERE ICON_NAME = 'def_cat_user-story';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'protect'
      WHERE ICON_NAME = 'def_cat_security';

DROP INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-001', 'jprioux', 'tm/tm.changelog-3.0.0.xml', NOW(), 545, '8:e32b9db731ddcc8b919467de6bfb6aa4', 'createIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM; sql; dropIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM', 'Update all def icon name when used in info list item', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4299-update-def-icon-name-002::jprioux
--  Update all def icon name when used in tc nat execution
CREATE INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION(TC_NAT_ICON_NAME);

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'monitor'
      WHERE TC_NAT_ICON_NAME = 'def_cat_functional';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'server'
      WHERE TC_NAT_ICON_NAME = 'def_cat_non-functional';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'read'
      WHERE TC_NAT_ICON_NAME = 'def_cat_use-case';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'briefcase'
      WHERE TC_NAT_ICON_NAME = 'def_cat_business';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'checked_checkbox'
      WHERE TC_NAT_ICON_NAME in ('def_cat_test-requirement', 'def_cat_noicon');

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'checkmark'
      WHERE TC_NAT_ICON_NAME = 'def_cat_undefined';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'puzzle'
      WHERE TC_NAT_ICON_NAME = 'def_cat_ergonomic';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'dashboard'
      WHERE TC_NAT_ICON_NAME = 'def_cat_performance';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'key'
      WHERE TC_NAT_ICON_NAME in ('def_cat_technical', 'def_cat_technic');

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'bookmark'
      WHERE TC_NAT_ICON_NAME = 'def_cat_user-story';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'protect'
      WHERE TC_NAT_ICON_NAME = 'def_cat_security';

DROP INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-002', 'jprioux', 'tm/tm.changelog-3.0.0.xml', NOW(), 546, '8:004dced576c006518dee7d135d6a892f', 'createIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION', 'Update all def icon name when used in tc nat execution', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4299-update-def-icon-name-003::jprioux
--  Update all def icon name when used in tc type execution
CREATE INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION(TC_TYP_ICON_NAME);

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'monitor'
      WHERE TC_TYP_ICON_NAME = 'def_cat_functional';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'server'
      WHERE TC_TYP_ICON_NAME = 'def_cat_non-functional';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'read'
      WHERE TC_TYP_ICON_NAME = 'def_cat_use-case';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'briefcase'
      WHERE TC_TYP_ICON_NAME = 'def_cat_business';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'checked_checkbox'
      WHERE TC_TYP_ICON_NAME in ('def_cat_test-requirement', 'def_cat_noicon');

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'checkmark'
      WHERE TC_TYP_ICON_NAME = 'def_cat_undefined';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'puzzle'
      WHERE TC_TYP_ICON_NAME = 'def_cat_ergonomic';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'dashboard'
      WHERE TC_TYP_ICON_NAME = 'def_cat_performance';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'key'
      WHERE TC_TYP_ICON_NAME in ('def_cat_technical', 'def_cat_technic');

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'bookmark'
      WHERE TC_TYP_ICON_NAME = 'def_cat_user-story';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'protect'
      WHERE TC_TYP_ICON_NAME = 'def_cat_security';

DROP INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-003', 'jprioux', 'tm/tm.changelog-3.0.0.xml', NOW(), 547, '8:6dc0390299da83f2394166d22ec2a521', 'createIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION', 'Update all def icon name when used in tc type execution', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQMAP-636-add-new-attributes-to-custom-chart::dclaerhout
--  Add new attributes concerning test cases to generate custom charts
UPDATE QUERY_COLUMN_PROTOTYPE SET BUSINESS = 1 WHERE LABEL = 'TEST_CASE_AUTOMATABLE';

UPDATE QUERY_COLUMN_PROTOTYPE SET BUSINESS = 1 WHERE LABEL = 'AUTOMATION_REQUEST_STATUS';

INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) VALUES ('TEST_CASE_HAS_BOUND_SCM_REPOSITORY_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
                                         DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES ('ENTITY', FALSE, 'SCM_REPOSITORY_ENTITY', 'SCM_REPOSITORY', null, 'ENTITY', null, null),
             ('ATTRIBUTE', FALSE, 'SCM_REPOSITORY_ID', 'SCM_REPOSITORY', null, 'NUMERIC', 'id', null),
             ('ATTRIBUTE', FALSE, 'TEST_CASE_AUTOMATED_TEST_REFERENCE', 'TEST_CASE', null, 'STRING',
              'automatedTestReference', null),
             ('CALCULATED', TRUE, 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY', 'TEST_CASE', null, 'BOOLEAN',
              'notnull(scmRepository)', (select max(QUERY_MODEL_ID) from QUERY_MODEL));

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
      VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'SCM_REPOSITORY_ID'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'NOT_NULL', 0, null
      );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION,
      AGGREGATION_RANK, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        null, 'NONE', 0, null
      );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) VALUES ('TEST_CASE_HAS_BOUND_AUTOMATED_TEST_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
      DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES
      ('CALCULATED', TRUE, 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE', 'TEST_CASE', null, 'BOOLEAN',
      'notnull(automatedTestReference)', (select max(QUERY_MODEL_ID) from QUERY_MODEL)),
      ('ATTRIBUTE', TRUE, 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY', 'TEST_CASE', null,
      'AUTOMATED_TEST_TECHNOLOGY', 'automatedTestTechnology.name', null),
      ('ATTRIBUTE', TRUE, 'AUTOMATION_REQUEST_TRANSMISSION_DATE', 'AUTOMATION_REQUEST', null, 'DATE',
      'transmissionDate', null),
      ('ATTRIBUTE', TRUE, 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY', 'AUTOMATION_REQUEST', null, 'NUMERIC',
      'automationPriority', null);

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
       VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_REFERENCE'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'NOT_NULL', 0, null
       );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION, AGGREGATION_RANK, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        null, 'NONE', 0, null
      );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_REFERENCE'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      VALUES ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_STATUS'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_STATUS'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_STATUS'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATABLE'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATABLE'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATABLE'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_TRANSMISSION_DATE'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_TRANSMISSION_DATE'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_TRANSMISSION_DATE'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY'), 'FILTER');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQMAP-636-add-new-attributes-to-custom-chart', 'dclaerhout', 'tm/tm.changelog-3.0.0.xml', NOW(), 548, '8:4b3258866993dcd3dcdf54efe16d6d4d', 'update tableName=QUERY_COLUMN_PROTOTYPE; update tableName=QUERY_COLUMN_PROTOTYPE; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql', 'Add new attributes concerning test cases to generate custom charts', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4310-create-delete-working-table::jthebault
CREATE TABLE WORK_DELETE_ENTITIES (ENTITY_ID BIGINT NOT NULL, ENTITY_TYPE VARCHAR(100) NOT NULL, OPERATION_ID VARCHAR(50) NOT NULL) ENGINE = INNODB;

CREATE INDEX work_delete_entities_entity_type_idx ON WORK_DELETE_ENTITIES(ENTITY_TYPE);

CREATE INDEX work_delete_entities_entity_id_idx ON WORK_DELETE_ENTITIES(ENTITY_ID);

CREATE INDEX work_delete_entities_operation_id_idx ON WORK_DELETE_ENTITIES(OPERATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4310-create-delete-working-table', 'jthebault', 'tm/tm.changelog-3.0.0.xml', NOW(), 549, '8:86bc0ae3fb7afdbac79014f8cfcacf0b', 'createTable tableName=WORK_DELETE_ENTITIES; createIndex indexName=work_delete_entities_entity_type_idx, tableName=WORK_DELETE_ENTITIES; createIndex indexName=work_delete_entities_entity_id_idx, tableName=WORK_DELETE_ENTITIES; createIndex indexName...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-add-bt-project-reference-in-issue::jthebault
--  Changing the type to allow storage of large jsonified object, without using jsonb for backward compat
ALTER TABLE ISSUE ADD ADDITIONAL_DATA TEXT NULL COMMENT 'Column for json info. Use it only when remote_key is not enough to fetch issue';

CREATE INDEX issue_remote_issue_id_idx ON ISSUE(REMOTE_ISSUE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-add-bt-project-reference-in-issue', 'jthebault', 'tm/tm.changelog-3.0.0.xml', NOW(), 550, '8:bc71f44e17c49046a2f7a665ed29c0fa', 'addColumn tableName=ISSUE; createIndex indexName=issue_remote_issue_id_idx, tableName=ISSUE', 'Changing the type to allow storage of large jsonified object, without using jsonb for backward compat', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-TM-632-01-add-high-lvl-req-table::jthebault
CREATE TABLE HIGH_LEVEL_REQUIREMENT (RLN_ID BIGINT NOT NULL, CONSTRAINT pk_high_lvl_requirement PRIMARY KEY (RLN_ID), CONSTRAINT fk_high_lvl_requirement_requirement FOREIGN KEY (RLN_ID) REFERENCES REQUIREMENT(RLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-TM-632-01-add-high-lvl-req-table', 'jthebault', 'tm/tm.changelog-3.0.0.xml', NOW(), 551, '8:5bb19cfcfa3c1a84806c2884e15bf4c3', 'createTable tableName=HIGH_LEVEL_REQUIREMENT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-TM-632-02-add-query-column-proto::jthebault
--  Inserting column proto for high level requirements
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME,
                                          DATA_TYPE, BUSINESS)
      VALUES ('ENTITY', 'REQUIREMENT', NULL, 'REQUIREMENT_KIND', NULL, 'ENTITY', FALSE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-TM-632-02-add-query-column-proto', 'jthebault', 'tm/tm.changelog-3.0.0.xml', NOW(), 552, '8:ca600dfdb9b6b41aa24c4503d60a2448', 'sql', 'Inserting column proto for high level requirements', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-TM-632-03-add-high-lvl-req-reference::jthebault
--  add reference column to allow requirement to be linked to high level requirements
ALTER TABLE REQUIREMENT ADD HIGH_LEVEL_REQUIREMENT_ID BIGINT NULL;

ALTER TABLE REQUIREMENT ADD CONSTRAINT fk_requirement_high_lvl_requirement FOREIGN KEY (HIGH_LEVEL_REQUIREMENT_ID) REFERENCES HIGH_LEVEL_REQUIREMENT (RLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-TM-632-03-add-high-lvl-req-reference', 'jthebault', 'tm/tm.changelog-3.0.0.xml', NOW(), 553, '8:47f7ed5dee2f57838291212d723c51b6', 'addColumn tableName=REQUIREMENT', 'add reference column to allow requirement to be linked to high level requirements', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4196-add-new-attributes-to-requirement-search::dclaerhout
--  Add new attributes for high level requirement in search
INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) VALUES ('REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
                                         DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES ('CALCULATED', FALSE, 'REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT', 'REQUIREMENT', null, 'BOOLEAN',
              'notnull(highLevelRequirement)', (select max(QUERY_MODEL_ID) from QUERY_MODEL)),
             ('ENTITY', FALSE, 'HIGH_LEVEL_REQUIREMENT_ENTITY', 'HIGH_LEVEL_REQUIREMENT', null, 'ENTITY', null,
              null),
             ('ATTRIBUTE', FALSE, 'HIGH_LEVEL_REQUIREMENT_ID', 'HIGH_LEVEL_REQUIREMENT', null, 'NUMERIC', 'id',
              null);

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
      VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'HIGH_LEVEL_REQUIREMENT_ID'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'NOT_NULL', 0, null
      );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION,
                                           AGGREGATION_RANK, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'REQUIREMENT_ID'),
        null, 'NONE', 0, null);

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'REQUIREMENT_ID'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4196-add-new-attributes-to-requirement-search', 'dclaerhout', 'tm/tm.changelog-3.0.0.xml', NOW(), 554, '8:cb590fdfcfaa788d30085cdcf1835437', 'sql; sql; sql; sql; sql', 'Add new attributes for high level requirement in search', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4436-add-automated_test_technologies::pckerneis
--  Add automated test technologies (Cucumber 5+ and Postman)
insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('Postman', 'postman/execute@v1'),
             ('Cucumber 5+', 'cucumber5/execute@v1'),
             ('Katalon', 'katalon/execute@v1');

update AUTOMATED_TEST_TECHNOLOGY
      set NAME = 'Cucumber 4'
      where ACTION_PROVIDER_KEY = 'cucumber/execute@v1';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4436-add-automated_test_technologies', 'pckerneis', 'tm/tm.changelog-3.0.0.xml', NOW(), 555, '8:d6978b6d4a1c68fe50b6e304ab8d1738', 'sql; sql', 'Add automated test technologies (Cucumber 5+ and Postman)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4584-apply_InfoList_default_value::cduvigneau
--  Set InfoList default value for old Test Case and Requirement
UPDATE TEST_CASE CDT
        JOIN TEST_CASE_LIBRARY_NODE TCLN ON CDT.TCLN_ID = TCLN.TCLN_ID
        JOIN PROJECT P ON TCLN.PROJECT_ID = P.PROJECT_ID
        JOIN INFO_LIST_ITEM ILI ON CDT.TC_NATURE = ILI.ITEM_ID AND ILI.LIST_ID != P.TC_NATURES_LIST
        JOIN INFO_LIST_ITEM VAL ON VAL.LIST_ID = P.TC_NATURES_LIST AND VAL.IS_DEFAULT = 1
        SET CDT.TC_NATURE = VAL.ITEM_ID;

UPDATE TEST_CASE CDT
        JOIN TEST_CASE_LIBRARY_NODE TCLN ON CDT.TCLN_ID = TCLN.TCLN_ID
        JOIN PROJECT P ON TCLN.PROJECT_ID = P.PROJECT_ID
        JOIN INFO_LIST_ITEM ILI ON CDT.TC_TYPE = ILI.ITEM_ID AND ILI.LIST_ID != P.TC_TYPES_LIST
        JOIN INFO_LIST_ITEM VAL ON VAL.LIST_ID = P.TC_TYPES_LIST AND VAL.IS_DEFAULT = 1
        SET CDT.TC_TYPE = VAL.ITEM_ID;

UPDATE REQUIREMENT_VERSION RV
        JOIN REQUIREMENT_LIBRARY_NODE RLN ON RV.REQUIREMENT_ID = RLN.RLN_ID
        JOIN PROJECT P ON RLN.PROJECT_ID = P.PROJECT_ID
        JOIN INFO_LIST_ITEM ILI ON RV.CATEGORY = ILI.ITEM_ID AND ILI.LIST_ID != P.REQ_CATEGORIES_LIST
        JOIN INFO_LIST_ITEM VAL ON VAL.LIST_ID = P.REQ_CATEGORIES_LIST AND VAL.IS_DEFAULT = 1
        SET RV.CATEGORY = VAL.ITEM_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4584-apply_InfoList_default_value', 'cduvigneau', 'tm/tm.changelog-3.0.0.xml', NOW(), 556, '8:03834030f6b7da3ced9f2d64c5bbb964', 'sql', 'Set InfoList default value for old Test Case and Requirement', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4436-add-premium-column::pckerneis
--  Add 'premium' column for test technologies
ALTER TABLE AUTOMATED_TEST_TECHNOLOGY ADD PREMIUM BIT(1) DEFAULT 0 NOT NULL;

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='Agilitest';

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='Katalon';

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='Ranorex';

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='UFT';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4436-add-premium-column', 'pckerneis', 'tm/tm.changelog-3.0.0.xml', NOW(), 557, '8:a218dea8a3efc6882bd40c170f647e2c', 'addColumn tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY', 'Add ''premium'' column for test technologies', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', 'tm/tm.changelog-4.0.0.xml', NOW(), 558, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0::jlor
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '4.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0', 'jlor', 'tm/tm.changelog-4.0.0.xml', NOW(), 559, '8:025f887ac0f9e3e270627db101013aa0', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-projects-data-migration::jlor
--  Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_4'
UPDATE PROJECT SET BDD_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER_4' WHERE BDD_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-projects-data-migration', 'jlor', 'tm/tm.changelog-4.0.0.xml', NOW(), 560, '8:475f0a521671864f5e605ab2289c8831', 'update tableName=PROJECT', 'Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-projects-default-value-modification::jlor
--  Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_5_PLUS'
ALTER TABLE PROJECT ALTER BDD_IMPLEMENTATION_TECHNOLOGY SET DEFAULT 'CUCUMBER_5_PLUS';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-projects-default-value-modification', 'jlor', 'tm/tm.changelog-4.0.0.xml', NOW(), 561, '8:2c1b71469d4348feecc17ae521bbc030', 'addDefaultValue columnName=BDD_IMPLEMENTATION_TECHNOLOGY, tableName=PROJECT', 'Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_5_PLUS''', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-action-words-data-migration::jlor
--  Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_4'
UPDATE ACTION_WORD SET LAST_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER_4' WHERE LAST_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-action-words-data-migration', 'jlor', 'tm/tm.changelog-4.0.0.xml', NOW(), 562, '8:0b655a20f2467fba73a1e177ca742c28', 'update tableName=ACTION_WORD', 'Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5025-token-auth-migration-for-mantis::bms
--  Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table
UPDATE THIRD_PARTY_SERVER server
        INNER JOIN BUGTRACKER bt ON server.SERVER_ID = bt.BUGTRACKER_ID
        SET AUTH_PROTOCOL = 'TOKEN_AUTH'
        WHERE bt.KIND = 'mantis';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5025-token-auth-migration-for-mantis', 'bms', 'tm/tm.changelog-4.0.0.xml', NOW(), 563, '8:07a476b6374767f3d4851a834c9934a4', 'sql', 'Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation::cduvigneau
--  Add Owner Column to REMOTE_SYNCHRONISATION Table
ALTER TABLE REMOTE_SYNCHRONISATION ADD OWNER_ID BIGINT NULL;

ALTER TABLE REMOTE_SYNCHRONISATION ADD CONSTRAINT fk_remote_sync_owner FOREIGN KEY (OWNER_ID) REFERENCES CORE_USER (PARTY_ID);

CREATE INDEX idx_fk_remote_sync_owner ON REMOTE_SYNCHRONISATION(OWNER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation', 'cduvigneau', 'tm/tm.changelog-4.0.0.xml', NOW(), 564, '8:40f17eb9122b6900038675ec503289e9', 'addColumn tableName=REMOTE_SYNCHRONISATION; createIndex indexName=idx_fk_remote_sync_owner, tableName=REMOTE_SYNCHRONISATION', 'Add Owner Column to REMOTE_SYNCHRONISATION Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-delete-column-test-case-version::jlor
--  Delete TEST_CASE.VERSION which is not and was never used
ALTER TABLE TEST_CASE DROP COLUMN VERSION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-delete-column-test-case-version', 'jlor', 'tm/tm.changelog-4.0.0.xml', NOW(), 565, '8:159df6b73e57c91cc93be6589b236122', 'dropColumn columnName=VERSION, tableName=TEST_CASE', 'Delete TEST_CASE.VERSION which is not and was never used', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-automation-environment-tag::jlor
--  Create table AUTOMATION_ENVIRONMENT_TAG
CREATE TABLE AUTOMATION_ENVIRONMENT_TAG (VALUE VARCHAR(255) NULL, ENTITY_TYPE VARCHAR(50) NOT NULL, ENTITY_ID BIGINT NOT NULL) ENGINE = INNODB;

ALTER TABLE AUTOMATION_ENVIRONMENT_TAG ADD CONSTRAINT uniq_value_entity_type_entity_id UNIQUE (VALUE, ENTITY_TYPE, ENTITY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-automation-environment-tag', 'jlor', 'tm/tm.changelog-4.0.0.xml', NOW(), 566, '8:2a3fc3b94331a522eaf3fd685c97773a', 'createTable tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG', 'Create table AUTOMATION_ENVIRONMENT_TAG', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column::pckerneis
ALTER TABLE PROJECT ADD INHERITS_ENVIRONMENT_TAGS BIT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column', 'pckerneis', 'tm/tm.changelog-4.0.0.xml', NOW(), 567, '8:d978baa2a38d4182fe4c50c1da0ab300', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-add-project-level-credentials::pckerneis
ALTER TABLE STORED_CREDENTIALS ADD PROJECT_ID BIGINT DEFAULT null NULL COMMENT 'Foreign key to the project bound to these credentials. NULL for app-level and user-level credentials.';

ALTER TABLE STORED_CREDENTIALS ADD CONSTRAINT fk_stored_credentials_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-add-project-level-credentials', 'pckerneis', 'tm/tm.changelog-4.0.0.xml', NOW(), 568, '8:9309f9f9fa4752b65ca68bfb504c872f', 'addColumn tableName=STORED_CREDENTIALS', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-SQUASH-4923-remove-orphan-project-filters::dclaerhout
DELETE FROM PROJECT_FILTER_ENTRY
      WHERE FILTER_ID in(
          SELECT pf.PROJECT_FILTER_ID
          FROM PROJECT_FILTER AS pf
          LEFT JOIN CORE_USER AS cu ON cu.LOGIN = pf.USER_LOGIN
          WHERE cu.LOGIN IS NULL
      );

DELETE FROM PROJECT_FILTER
      WHERE USER_LOGIN in(
        SELECT * FROM (
                        SELECT pf.USER_LOGIN
                        FROM PROJECT_FILTER AS pf
                               LEFT JOIN CORE_USER AS cu ON cu.LOGIN = pf.USER_LOGIN
                        WHERE cu.LOGIN IS NULL
                      ) AS user_logins
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-SQUASH-4923-remove-orphan-project-filters', 'dclaerhout', 'tm/tm.changelog-4.0.0.xml', NOW(), 569, '8:49763b942b13245884a80c6c3cabce0c', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5384-taserver-observer-url-column::pckerneis
--  Add OBSERVER_URL column to TEST_AUTOMATION_SERVER
ALTER TABLE TEST_AUTOMATION_SERVER ADD OBSERVER_URL VARCHAR(255) DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5384-taserver-observer-url-column', 'pckerneis', 'tm/tm.changelog-4.0.0.xml', NOW(), 570, '8:c2d0bb202997d68a0a96a0c7e3371188', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add OBSERVER_URL column to TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0::bmsaddek
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '4.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 571, '8:e23ead1b9d0bb7b58a91a48c3b8cb738', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable::bmsaddek
--  Create table ENVIRONMENT_VARIABLE
CREATE TABLE ENVIRONMENT_VARIABLE (EV_ID BIGINT AUTO_INCREMENT NOT NULL, FIELD_TYPE VARCHAR(5) NOT NULL, NAME VARCHAR(255) NOT NULL, INPUT_TYPE VARCHAR(30) NOT NULL, CONSTRAINT PK_ENVIRONMENT_VARIABLE PRIMARY KEY (EV_ID)) ENGINE = INNODB;

CREATE INDEX idx_ev_name ON ENVIRONMENT_VARIABLE(NAME);

ALTER TABLE ENVIRONMENT_VARIABLE ADD CONSTRAINT uc_ev_name UNIQUE (NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 572, '8:cd633867f6f5f4f83702a1ecb98c1c8c', 'createTable tableName=ENVIRONMENT_VARIABLE; createIndex indexName=idx_ev_name, tableName=ENVIRONMENT_VARIABLE; addUniqueConstraint constraintName=uc_ev_name, tableName=ENVIRONMENT_VARIABLE', 'Create table ENVIRONMENT_VARIABLE', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable_option::bmsaddek
--  Creates a table for Environment Variable Options
CREATE TABLE ENVIRONMENT_VARIABLE_OPTION (EV_ID BIGINT NOT NULL, LABEL VARCHAR(255) NOT NULL, POSITION INT NOT NULL, CONSTRAINT fk_ev_option_ev FOREIGN KEY (EV_ID) REFERENCES ENVIRONMENT_VARIABLE(EV_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_ev_option_ev ON ENVIRONMENT_VARIABLE_OPTION(EV_ID);

ALTER TABLE ENVIRONMENT_VARIABLE_OPTION ADD CONSTRAINT uc_ev_option_label UNIQUE (EV_ID, LABEL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable_option', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 573, '8:2eed485efc3eb8548585dd25a5306515', 'createTable tableName=ENVIRONMENT_VARIABLE_OPTION; createIndex indexName=idx_fk_ev_option_ev, tableName=ENVIRONMENT_VARIABLE_OPTION; addUniqueConstraint constraintName=uc_ev_option_label, tableName=ENVIRONMENT_VARIABLE_OPTION', 'Creates a table for Environment Variable Options', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable_binding::bmsaddek
--  Creates a table for Environment Variable Binding
CREATE TABLE ENVIRONMENT_VARIABLE_BINDING (EVB_ID BIGINT AUTO_INCREMENT NOT NULL, EV_ID BIGINT NOT NULL, BOUND_SERVER_ID BIGINT NOT NULL, CONSTRAINT PK_EV_BINDING PRIMARY KEY (EVB_ID), CONSTRAINT fk_ev_binding_ev FOREIGN KEY (EV_ID) REFERENCES ENVIRONMENT_VARIABLE(EV_ID), CONSTRAINT fk_ev_binding_server FOREIGN KEY (BOUND_SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER(SERVER_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_ev_binding_ev ON ENVIRONMENT_VARIABLE_BINDING(EV_ID);

CREATE INDEX idx_fk_ev_binding_server ON ENVIRONMENT_VARIABLE_BINDING(BOUND_SERVER_ID);

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD CONSTRAINT uc_ev_server_bnd UNIQUE (BOUND_SERVER_ID, EV_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable_binding', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 574, '8:ce1612f975708be70df55888e085a811', 'createTable tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_fk_ev_binding_ev, tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_fk_ev_binding_server, tableName=ENVIRONMENT_VARIABLE_BINDING; addUniqueConstraint con...', 'Creates a table for Environment Variable Binding', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-environment-variable_value::bmsaddek
CREATE TABLE ENVIRONMENT_VARIABLE_VALUE (EVV_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', BOUND_ENTITY_ID BIGINT NOT NULL COMMENT 'the id of the bound entity', BOUND_ENTITY_TYPE VARCHAR(30) NOT NULL, EVB_ID BIGINT NOT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular environment variable value', CONSTRAINT PK_ENVIRONMENT_VARIABLE_VALUE PRIMARY KEY (EVV_ID), CONSTRAINT fk_ev_value_binding FOREIGN KEY (EVB_ID) REFERENCES ENVIRONMENT_VARIABLE_BINDING(EVB_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_ev_value_binding ON ENVIRONMENT_VARIABLE_VALUE(EVB_ID);

CREATE INDEX idx_evv_entity_id ON ENVIRONMENT_VARIABLE_VALUE(BOUND_ENTITY_ID);

CREATE INDEX idx_evv_entity_type ON ENVIRONMENT_VARIABLE_VALUE(BOUND_ENTITY_TYPE);

ALTER TABLE ENVIRONMENT_VARIABLE_VALUE ADD CONSTRAINT uc_evv_id_type_binding UNIQUE (BOUND_ENTITY_ID, BOUND_ENTITY_TYPE, EVB_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-environment-variable_value', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 575, '8:65be21f7c45926ea0b31d1906333f96d', 'createTable tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_fk_ev_value_binding, tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_evv_entity_id, tableName=ENVIRONMENT_VARIABLE_VALUE; createIndex indexName=idx_evv_ent...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-denormalized-environment-variable::bmsaddek
CREATE TABLE DENORMALIZED_ENVIRONMENT_VARIABLE (DEV_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', EV_ID BIGINT NULL, HOLDER_ID BIGINT NOT NULL, HOLDER_TYPE VARCHAR(30) NOT NULL, NAME VARCHAR(255) NOT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular environment variable value', CONSTRAINT PK_DENORMALIZED_ENVIRONMENT_VARIABLE PRIMARY KEY (DEV_ID), CONSTRAINT fk_dev_environment_variable FOREIGN KEY (EV_ID) REFERENCES ENVIRONMENT_VARIABLE(EV_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_dev_environment_variable ON DENORMALIZED_ENVIRONMENT_VARIABLE(EV_ID);

CREATE INDEX idx_dev_holder_id ON DENORMALIZED_ENVIRONMENT_VARIABLE(HOLDER_ID);

CREATE INDEX idx_dev_holder_type ON DENORMALIZED_ENVIRONMENT_VARIABLE(HOLDER_TYPE);

ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE ADD CONSTRAINT uc_dev_id_type_name UNIQUE (HOLDER_ID, HOLDER_TYPE, NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-denormalized-environment-variable', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 576, '8:ee179aababb312a8dee75c67785c094d', 'createTable tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; createIndex indexName=idx_fk_dev_environment_variable, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; createIndex indexName=idx_dev_holder_id, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; crea...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-4.1.0.xml::tm-4.1.0-sqmap-879-denormalized-environment-tag::bmsaddek
CREATE TABLE DENORMALIZED_ENVIRONMENT_TAG (DET_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'technical id', HOLDER_ID BIGINT NOT NULL, HOLDER_TYPE VARCHAR(30) NOT NULL, VALUE VARCHAR(255) NULL COMMENT 'the value of that particular environment tag value', CONSTRAINT PK_DENORMALIZED_ENVIRONMENT_TAG PRIMARY KEY (DET_ID)) ENGINE = INNODB;

CREATE INDEX idx_det_holder_id ON DENORMALIZED_ENVIRONMENT_TAG(HOLDER_ID);

CREATE INDEX idx_det_holder_type ON DENORMALIZED_ENVIRONMENT_TAG(HOLDER_TYPE);

ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG ADD CONSTRAINT uc_det_id_type_value UNIQUE (HOLDER_ID, HOLDER_TYPE, VALUE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.1.0-sqmap-879-denormalized-environment-tag', 'bmsaddek', 'tm/tm.changelog-4.1.0.xml', NOW(), 577, '8:fe1806eef598e87ccacce2dcdf8a7d1e', 'createTable tableName=DENORMALIZED_ENVIRONMENT_TAG; createIndex indexName=idx_det_holder_id, tableName=DENORMALIZED_ENVIRONMENT_TAG; createIndex indexName=idx_det_holder_type, tableName=DENORMALIZED_ENVIRONMENT_TAG; addUniqueConstraint constraintN...', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0::bmsaddek
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '5.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', NOW(), 578, '8:ddd83a5610bd728072f355a2b538db35', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5923-increase-max-size-for-databasechangelog::jprioux
--  Increase max size for ID and author columns in databasechangelog table
ALTER TABLE DATABASECHANGELOG MODIFY ID VARCHAR(255);

ALTER TABLE DATABASECHANGELOG MODIFY AUTHOR VARCHAR(255);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5923-increase-max-size-for-databasechangelog', 'jprioux', 'tm/tm.changelog-5.0.0.xml', NOW(), 579, '8:c07f3378fe9a5eefabb12c39b0fa3a08', 'modifyDataType columnName=ID, tableName=DATABASECHANGELOG; modifyDataType columnName=AUTHOR, tableName=DATABASECHANGELOG', 'Increase max size for ID and author columns in databasechangelog table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-Add-environment-variables-to-project::bmsaddek
--  Add VALUE, ENTITY_TYPE columns to ENVIRONMENT_VARIABLE_BINDING Table
ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD ENTITY_ID BIGINT NULL, ADD ENTITY_TYPE VARCHAR(30) NULL, ADD VALUE VARCHAR(255) NULL;

CREATE INDEX idx_evb_entity_id ON ENVIRONMENT_VARIABLE_BINDING(ENTITY_ID);

CREATE INDEX idx_evb_entity_type ON ENVIRONMENT_VARIABLE_BINDING(ENTITY_TYPE);

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP FOREIGN KEY fk_ev_binding_server;

DROP INDEX idx_fk_ev_binding_server ON ENVIRONMENT_VARIABLE_BINDING;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP KEY uc_ev_server_bnd;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-Add-environment-variables-to-project', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', NOW(), 580, '8:9f17e23b3e0705d47adc71a2d6c90833', 'addColumn tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_evb_entity_id, tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_evb_entity_type, tableName=ENVIRONMENT_VARIABLE_BINDING; dropForeignKeyConstraint baseTabl...', 'Add VALUE, ENTITY_TYPE columns to ENVIRONMENT_VARIABLE_BINDING Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-environment-variable-data-migration-server-value::lmurat
--  Migrate environment variable values in environment_variable_binding table it's a server value
UPDATE ENVIRONMENT_VARIABLE_BINDING binding
      INNER JOIN ENVIRONMENT_VARIABLE_VALUE environmentvalue ON environmentvalue.EVB_ID = binding.EVB_ID
      SET binding.ENTITY_TYPE = environmentvalue.BOUND_ENTITY_TYPE, binding.ENTITY_ID = environmentvalue.BOUND_ENTITY_ID, binding.VALUE = environmentvalue.VALUE
      WHERE environmentvalue.BOUND_ENTITY_TYPE = 'TEST_AUTOMATION_SERVER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-server-value', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 581, '8:5537a8373d62f421d1753c6e536b2c31', 'sql', 'Migrate environment variable values in environment_variable_binding table it''s a server value', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-environment-variable-data-migration-default-value::lmurat
--  Migrate environment variable values in environment_variable_binding table when project value doesn't exist in environment variable value table
INSERT INTO ENVIRONMENT_VARIABLE_BINDING (EV_ID, ENTITY_ID, ENTITY_TYPE, VALUE, BOUND_SERVER_ID)
        (SELECT binding.EV_ID, project.PROJECT_ID as ENTITY_ID, 'PROJECT' as ENTITY_TYPE, servervalue.VALUE, binding.BOUND_SERVER_ID as BOUND_SERVER_ID
         FROM ENVIRONMENT_VARIABLE_BINDING binding
                INNER JOIN PROJECT project ON project.TA_SERVER_ID = binding.BOUND_SERVER_ID
                LEFT JOIN ENVIRONMENT_VARIABLE_VALUE servervalue ON servervalue.EVB_ID = binding.EVB_ID AND servervalue.BOUND_ENTITY_TYPE = 'TEST_AUTOMATION_SERVER'
                LEFT JOIN ENVIRONMENT_VARIABLE_VALUE projectvalue ON projectvalue.EVB_ID = binding.EVB_ID AND projectvalue.BOUND_ENTITY_TYPE = 'PROJECT' AND projectvalue.BOUND_ENTITY_ID = project.PROJECT_ID
         WHERE projectvalue.EVB_ID IS NULL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-default-value', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 582, '8:7f39425624e0fa1f975a8fca8e3b6437', 'sql', 'Migrate environment variable values in environment_variable_binding table when project value doesn''t exist in environment variable value table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-environment-variable-data-migration-project-value::lmurat
--  Migrate environment variable values in environment_variable_binding table when project value exist in environment variable value table
INSERT INTO ENVIRONMENT_VARIABLE_BINDING (EV_ID, ENTITY_ID, ENTITY_TYPE, VALUE, BOUND_SERVER_ID)
        (SELECT binding.EV_ID, environmentvalue.BOUND_ENTITY_ID as ENTITY_ID, environmentvalue.BOUND_ENTITY_TYPE as ENTITY_TYPE, environmentvalue.VALUE, binding.BOUND_SERVER_ID
         FROM ENVIRONMENT_VARIABLE_BINDING binding
        INNER JOIN ENVIRONMENT_VARIABLE_VALUE environmentvalue ON environmentvalue.EVB_ID = binding.EVB_ID
        WHERE environmentvalue.BOUND_ENTITY_TYPE = 'PROJECT');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-project-value', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 583, '8:0a01a8b66eadd5c42daa00227460d393', 'sql', 'Migrate environment variable values in environment_variable_binding table when project value exist in environment variable value table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-Drop-environment-variable-value-table::lmurat
--  Drop old environment variable values
ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP COLUMN bound_server_id;

DROP TABLE ENVIRONMENT_VARIABLE_VALUE;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD CONSTRAINT uc_evb_id_type_ev_id_binding UNIQUE (ENTITY_ID, ENTITY_TYPE, EV_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-Drop-environment-variable-value-table', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 584, '8:231d11cf680fe71bc8f25eb3df9f0c1b', 'dropColumn columnName=bound_server_id, tableName=ENVIRONMENT_VARIABLE_BINDING; dropTable tableName=ENVIRONMENT_VARIABLE_VALUE; addUniqueConstraint constraintName=uc_evb_id_type_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING', 'Drop old environment variable values', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-Add-environment-variables-type-to-denormalized-environment-variable::bmsaddek
--  Add TYPE column to DENORMALIZED_ENVIRONMENT_VARIABLE Table
ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE ADD TYPE VARCHAR(30) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-Add-environment-variables-type-to-denormalized-environment-variable', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', NOW(), 585, '8:1fb134d3b3e63fc03f56419b952cd1cc', 'addColumn tableName=DENORMALIZED_ENVIRONMENT_VARIABLE', 'Add TYPE column to DENORMALIZED_ENVIRONMENT_VARIABLE Table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5890-environment-variable-data-migration-variable-type::bmsaddek
--  Copy environment variable type in denormalized_environment_variable table if the variable has not been deleted
UPDATE DENORMALIZED_ENVIRONMENT_VARIABLE denormalized
        INNER JOIN ENVIRONMENT_VARIABLE environmentvariable ON environmentvariable.EV_ID = denormalized.EV_ID
      SET denormalized.TYPE = environmentvariable.INPUT_TYPE
      WHERE denormalized.EV_ID IS NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5890-environment-variable-data-migration-variable-type', 'bmsaddek', 'tm/tm.changelog-5.0.0.xml', NOW(), 586, '8:70a968f47cd20a7dcfaedf26dc408bbc', 'sql', 'Copy environment variable type in denormalized_environment_variable table if the variable has not been deleted', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-add-user-custom-delete-permission::pckerneis
--  Add a column for custom delete permissions on CORE_USER table
ALTER TABLE CORE_USER ADD CAN_DELETE_FROM_FRONT BIT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-add-user-custom-delete-permission', 'pckerneis', 'tm/tm.changelog-5.0.0.xml', NOW(), 587, '8:de173256e065f48609f2a9d900c4575d', 'addColumn tableName=CORE_USER', 'Add a column for custom delete permissions on CORE_USER table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5665-update-welcome-and-login-message::lmurat
--  Adapt default welcome and login message to new front
UPDATE CORE_CONFIG
      SET VALUE = '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the bottom left corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>'
WHERE STR_KEY = 'LOGIN_MESSAGE' AND VALUE = '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the upper right corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>'
   OR STR_KEY = 'WELCOME_MESSAGE' AND VALUE = '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the upper right corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5665-update-welcome-and-login-message', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 588, '8:c570593a856701eeaef40e261906ca49', 'sql', 'Adapt default welcome and login message to new front', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5881-update-length-for-test-suite-name::lmurat
--  Increase character limit for test suite name to 255
ALTER TABLE TEST_SUITE MODIFY NAME VARCHAR(255);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5881-update-length-for-test-suite-name', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 589, '8:616136c4a235c82336eac693310da3da', 'modifyDataType columnName=NAME, tableName=TEST_SUITE', 'Increase character limit for test suite name to 255', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5384-taserver-eventbus-url-column::pckerneis
--  Add EVENT_BUS_URL column to TEST_AUTOMATION_SERVER
ALTER TABLE TEST_AUTOMATION_SERVER ADD EVENT_BUS_URL VARCHAR(255) DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5384-taserver-eventbus-url-column', 'pckerneis', 'tm/tm.changelog-5.0.0.xml', NOW(), 590, '8:91348b0e8aca3f2b2fa893d2294cf5d1', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add EVENT_BUS_URL column to TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5749-add-test-technology-tag-to-automated-execution-extender::lmurat
--  Add the automated test technology tag to the automated execution extender
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD TEST_TECHNOLOGY VARCHAR(36) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5749-add-test-technology-tag-to-automated-execution-extender', 'lmurat', 'tm/tm.changelog-5.0.0.xml', NOW(), 591, '8:740bdcd4f3747a8a58221d76e1444adf', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add the automated test technology tag to the automated execution extender', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0::lmurat
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '6.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0', 'lmurat', 'tm/tm.changelog-6.0.0.xml', NOW(), 592, '8:58f17ae7fc8eee68e0b45d9a115f3784', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table::lmurat
--  Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY
DELETE FROM CORE_PARTY_AUTHORITY
    WHERE AUTHORITY = 'ROLE_TM_USER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table', 'lmurat', 'tm/tm.changelog-6.0.0.xml', NOW(), 593, '8:e9c6db4305989db996f20fbc3f141c15', 'sql', 'Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-SQUASH-6284-login-up-to-100-characters::mbrugniere
--  Update login maxlength for all tables concerned (from 50 to 100)
ALTER TABLE ACTION_WORD MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE ACTION_WORD MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ACTION_WORD MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE AUTH_USER MODIFY LOGIN VARCHAR(100);

ALTER TABLE AUTH_USER MODIFY LOGIN VARCHAR(100) NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CHART_DEFINITION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CHART_DEFINITION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CHART_DEFINITION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CONNECTION_ATTEMPT_LOG MODIFY LOGIN VARCHAR(100);

ALTER TABLE CORE_TEAM MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CORE_TEAM MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CORE_TEAM MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CORE_USER MODIFY LOGIN VARCHAR(100);

ALTER TABLE CORE_USER MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CORE_USER MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CORE_USER MODIFY LOGIN VARCHAR(100) NOT NULL;

ALTER TABLE CORE_USER MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE EXECUTION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE EXECUTION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE EXECUTION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE EXECUTION_STEP MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE EXECUTION_STEP MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE EXECUTION_STEP MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE INFO_LIST MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE INFO_LIST MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE INFO_LIST MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ITERATION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE ITERATION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE ITERATION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE MILESTONE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE MILESTONE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE MILESTONE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE PROJECT MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE PROJECT MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE PROJECT MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE REPORT_DEFINITION MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE REPORT_DEFINITION MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE REPORT_DEFINITION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER MODIFY LAST_SYNCHRONIZED_BY VARCHAR(100);

ALTER TABLE `RESOURCE` MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE `RESOURCE` MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE `RESOURCE` MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE TEST_AUTOMATION_SERVER MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE TEST_AUTOMATION_SERVER MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE TEST_AUTOMATION_SERVER ALTER CREATED_BY SET DEFAULT '(nobody)';

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE TEST_SUITE MODIFY CREATED_BY VARCHAR(100);

ALTER TABLE TEST_SUITE MODIFY LAST_MODIFIED_BY VARCHAR(100);

ALTER TABLE TEST_SUITE MODIFY CREATED_BY VARCHAR(100) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-SQUASH-6284-login-up-to-100-characters', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', NOW(), 594, '8:aa6203fbbef514e97eabeed812f50af1', 'modifyDataType columnName=CREATED_BY, tableName=ACTION_WORD; addNotNullConstraint columnName=CREATED_BY, tableName=ACTION_WORD; modifyDataType columnName=LAST_MODIFIED_BY, tableName=ACTION_WORD; modifyDataType columnName=LOGIN, tableName=AUTH_USER...', 'Update login maxlength for all tables concerned (from 50 to 100)', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-test-case::pckerneis
--  Create the exploratory test case table
CREATE TABLE EXPLORATORY_TEST_CASE (TCLN_ID BIGINT NOT NULL COMMENT 'primary key shared with TEST_CASE', CHARTER LONGTEXT DEFAULT null NULL COMMENT 'the charter for an exploratory test_case', SESSION_DURATION INT DEFAULT null NULL COMMENT 'the test session planned duration in minutes', CONSTRAINT pk_exploratory_test_case PRIMARY KEY (TCLN_ID), CONSTRAINT fk_exploratory_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID)) ENGINE = INNODB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-test-case', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', NOW(), 595, '8:d6da1d9d969d794b17ee935215a2fe51', 'createTable tableName=EXPLORATORY_TEST_CASE', 'Create the exploratory test case table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-execution::pckerneis
--  Create the exploratory execution table
CREATE TABLE EXPLORATORY_EXECUTION (EXECUTION_ID BIGINT NOT NULL COMMENT 'primary key shared with EXECUTION', ASSIGNEE_ID BIGINT DEFAULT null NULL, TASK_DIVISION VARCHAR(255) DEFAULT null NULL, REVIEWED BIT(1) DEFAULT 0 NOT NULL, CONSTRAINT pk_exploratory_execution PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_exploratory_execution_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_exploratory_execution_core_user FOREIGN KEY (ASSIGNEE_ID) REFERENCES CORE_USER(PARTY_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_exploratory_execution_assignee ON EXPLORATORY_EXECUTION(ASSIGNEE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-execution', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', NOW(), 596, '8:2fdd0cc5a94cb40c2062cc8582d3af5c', 'createTable tableName=EXPLORATORY_EXECUTION; createIndex indexName=idx_fk_exploratory_execution_assignee, tableName=EXPLORATORY_EXECUTION', 'Create the exploratory execution table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-session-note-for-exploratory-execution::mbrugniere
--  Create the session note table
CREATE TABLE SESSION_NOTE (NOTE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for SESSION_NOTE', EXECUTION_ID BIGINT NOT NULL COMMENT 'foreign key to EXECUTION', KIND VARCHAR(30) DEFAULT 'COMMENT' NOT NULL, CONTENT LONGTEXT DEFAULT '' NOT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to attachment list', ISSUE_LIST_ID BIGINT NULL COMMENT 'Foreign key to issue list', NOTE_ORDER INT NULL COMMENT 'Order in the note list', CONSTRAINT pk_session_note PRIMARY KEY (NOTE_ID), CONSTRAINT fk_session_note_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID), CONSTRAINT fk_session_note_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_session_note_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_session_note_execution ON SESSION_NOTE(EXECUTION_ID);

CREATE INDEX idx_fk_session_note_issue_list_id ON SESSION_NOTE(ISSUE_LIST_ID);

CREATE INDEX idx_session_note_created_by ON SESSION_NOTE(CREATED_BY);

CREATE INDEX idx_session_note_last_modified_by ON SESSION_NOTE(LAST_MODIFIED_BY);

CREATE INDEX idx_fk_session_note_attachment_list ON SESSION_NOTE(ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-session-note-for-exploratory-execution', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', NOW(), 597, '8:5d4e3cbd2cd18de34195e9c16bc613b3', 'createTable tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_execution, tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_issue_list_id, tableName=SESSION_NOTE; createIndex indexName=idx_session_note_created_by, ta...', 'Create the session note table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference::dclaerhout
--  Increase max size for automated test reference in test case table
ALTER TABLE TEST_CASE MODIFY AUTOMATED_TEST_REFERENCE VARCHAR(512);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference', 'dclaerhout', 'tm/tm.changelog-6.0.0.xml', NOW(), 598, '8:a21dc7000c7d5844f60f7b8095bc3bfd', 'modifyDataType columnName=AUTOMATED_TEST_REFERENCE, tableName=TEST_CASE', 'Increase max size for automated test reference in test case table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server::fahadi
--  Add additional configuration to the test automation server
ALTER TABLE TEST_AUTOMATION_SERVER ADD ADDITIONAL_CONFIGURATION LONGTEXT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server', 'fahadi', 'tm/tm.changelog-6.0.0.xml', NOW(), 599, '8:ae13402136cbb1b79a45e90dec8a42b0', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add additional configuration to the test automation server', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-update-execution_issues_closure::mbrugniere
--  Consider session notes to get all known issues for an execution
DROP VIEW EXECUTION_ISSUES_CLOSURE;

CREATE VIEW EXECUTION_ISSUES_CLOSURE AS select exec.execution_id, issue.issue_id
      from EXECUTION exec
         inner join ISSUE issue on exec.issue_list_id = issue.issue_list_id
      UNION
      select eesteps.execution_id, issue.issue_id
      from EXECUTION_EXECUTION_STEPS eesteps
             inner join EXECUTION_STEP estep on eesteps.execution_step_id = estep.execution_step_id
             inner join ISSUE issue on estep.issue_list_id = issue.issue_list_id
      UNION
      select sn.execution_id, ISSUE.issue_id
      from SESSION_NOTE sn
             inner join ISSUE on ISSUE.issue_list_id = sn.issue_list_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-update-execution_issues_closure', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', NOW(), 600, '8:63142af44781509e4550973a244cc317', 'dropView viewName=EXECUTION_ISSUES_CLOSURE; createView viewName=EXECUTION_ISSUES_CLOSURE', 'Consider session notes to get all known issues for an execution', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-grid-column-display-reference-table::jmarque
--  Create the grid reference table
CREATE TABLE GRID_COLUMN_DISPLAY_REFERENCE (GCDR_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for GRID_COLUMN_DISPLAY_REFERENCE', PARTY_ID BIGINT NOT NULL COMMENT 'foreign key to CORE_USER', GRID_ID VARCHAR(100) NOT NULL, PROJECT_ID BIGINT NULL COMMENT 'foreign key to PROJECT', CONSTRAINT pk_grid_column_display_reference PRIMARY KEY (GCDR_ID), CONSTRAINT fk_grid_column_display_reference_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_grid_column_display_reference_core_user FOREIGN KEY (PARTY_ID) REFERENCES CORE_USER(PARTY_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_grid_column_display_reference_party_id ON GRID_COLUMN_DISPLAY_REFERENCE(PARTY_ID);

CREATE INDEX idx_fk_grid_column_display_reference_project_id ON GRID_COLUMN_DISPLAY_REFERENCE(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-grid-column-display-reference-table', 'jmarque', 'tm/tm.changelog-6.0.0.xml', NOW(), 601, '8:e47ff361f4ee9d8fd94b75322b9692ba', 'createTable tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_party_id, tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_project_id, tableName=GRI...', 'Create the grid reference table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-grid-column-display-configuration-table::jmarque
--  Create the grid configuration table
CREATE TABLE GRID_COLUMN_DISPLAY_CONFIGURATION (GCDC_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for GRID_COLUMN_DISPLAY_CONFIGURATION', GCDR_ID BIGINT NOT NULL COMMENT 'foreign key to GRID_COLUMN_DISPLAY_REFERENCE', ACTIVE_COLUMN_ID VARCHAR(100) NOT NULL, CONSTRAINT pk_grid_column_display_configuration PRIMARY KEY (GCDC_ID), CONSTRAINT fk_grid_col_display_config_grid_col_display_ref FOREIGN KEY (GCDR_ID) REFERENCES GRID_COLUMN_DISPLAY_REFERENCE(GCDR_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_grid_column_display_configuration_gcdr_id ON GRID_COLUMN_DISPLAY_CONFIGURATION(GCDR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-grid-column-display-configuration-table', 'jmarque', 'tm/tm.changelog-6.0.0.xml', NOW(), 602, '8:e95b4bb90b311b5f84648616241b6e5d', 'createTable tableName=GRID_COLUMN_DISPLAY_CONFIGURATION; createIndex indexName=idx_fk_grid_column_display_configuration_gcdr_id, tableName=GRID_COLUMN_DISPLAY_CONFIGURATION', 'Create the grid configuration table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-execution-event-table::pckerneis
--  Create the exploratory session event table
CREATE TABLE EXPLORATORY_EXECUTION_EVENT (EVENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for EXPLORATORY_EXECUTION_EVENT', EXECUTION_ID BIGINT NOT NULL COMMENT 'foreign key to EXECUTION', EVENT_DATE datetime(3) NOT NULL, AUTHOR VARCHAR(100) NOT NULL, EVENT_TYPE VARCHAR(30) NOT NULL, CONSTRAINT pk_exploratory_execution_event PRIMARY KEY (EVENT_ID), CONSTRAINT fk_exploratory_execution_event_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID)) ENGINE = INNODB;

ALTER TABLE EXPLORATORY_EXECUTION_EVENT ADD CONSTRAINT uc_exploratory_execution_event_execution_id_event_date UNIQUE (EXECUTION_ID, EVENT_DATE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-execution-event-table', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', NOW(), 603, '8:3244ed07a4fbf493862937af300edcf9', 'createTable tableName=EXPLORATORY_EXECUTION_EVENT; addUniqueConstraint constraintName=uc_exploratory_execution_event_execution_id_event_date, tableName=EXPLORATORY_EXECUTION_EVENT', 'Create the exploratory session event table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-dataset-parameter-order::pckerneis
--  add an order to parameters
ALTER TABLE PARAMETER ADD PARAM_ORDER INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-dataset-parameter-order', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', NOW(), 604, '8:4009792036fb3f54151827a230cca8cf', 'addColumn tableName=PARAMETER', 'add an order to parameters', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-dataset-parameter-order-generation::pckerneis
UPDATE PARAMETER P1
      SET PARAM_ORDER = (
        SELECT SUBQUERY.COMPUTED_ORDER - 1
        FROM (
               SELECT P2.PARAM_ID as ID2,
                      ROW_NUMBER() over (PARTITION BY TEST_CASE_ID ORDER BY PARAM_ID) as COMPUTED_ORDER
               FROM PARAMETER P2) SUBQUERY
        WHERE SUBQUERY.ID2 = P1.PARAM_ID
      );

ALTER TABLE PARAMETER MODIFY PARAM_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-dataset-parameter-order-generation', 'pckerneis', 'tm/tm.changelog-6.0.0.xml', NOW(), 605, '8:d4ce63dae76f992f49574be99c6bdcd7', 'sql; addNotNullConstraint columnName=PARAM_ORDER, tableName=PARAMETER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-exploratory-session-overview::mbrugniere
--  Create the exploratory session overview table
CREATE TABLE EXPLORATORY_SESSION_OVERVIEW (OVERVIEW_ID BIGINT AUTO_INCREMENT NOT NULL, ITEM_TEST_PLAN_ID BIGINT NOT NULL COMMENT 'foreign key to ITERATION_TEST_PLAN_ITEM', CHARTER LONGTEXT DEFAULT null NULL COMMENT 'the charter for an exploratory session overview', SESSION_DURATION INT DEFAULT null NULL COMMENT 'the test session planned duration in minutes', NAME VARCHAR(255) NOT NULL, `REFERENCE` VARCHAR(50) DEFAULT '' NOT NULL, DUE_DATE datetime DEFAULT null NULL, SESSION_STATUS VARCHAR(50) DEFAULT 'TO_DO' NOT NULL, COMMENTS LONGTEXT DEFAULT null NULL, ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to attachment list', CONSTRAINT pk_exploratory_session_overview PRIMARY KEY (OVERVIEW_ID), CONSTRAINT fk_exploratory_session_overview FOREIGN KEY (ITEM_TEST_PLAN_ID) REFERENCES ITERATION_TEST_PLAN_ITEM(ITEM_TEST_PLAN_ID), CONSTRAINT fk_exploratory_session_overview_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_exploratory_session_overview_itpi ON EXPLORATORY_SESSION_OVERVIEW(ITEM_TEST_PLAN_ID);

CREATE INDEX idx_fk_exploratory_session_overview_attachment_list ON EXPLORATORY_SESSION_OVERVIEW(ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-exploratory-session-overview', 'mbrugniere', 'tm/tm.changelog-6.0.0.xml', NOW(), 606, '8:ee55c8c1aa5423a03523dc4b5f506522', 'createTable tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_itpi, tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_attachment_list, tableName=EXPLOR...', 'Create the exploratory session overview table', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-squash-remove-resultpublisher-plugin-binding::bms
DELETE FROM LIBRARY_PLUGIN_BINDING_PROPERTY
      WHERE PLUGIN_BINDING_ID IN (
        SELECT PLUGIN_BINDING_ID
        FROM LIBRARY_PLUGIN_BINDING WHERE PLUGIN_ID = 'squash.tm.plugin.resultpublisher'
      );

DELETE FROM LIBRARY_PLUGIN_BINDING WHERE PLUGIN_ID = 'squash.tm.plugin.resultpublisher';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-squash-remove-resultpublisher-plugin-binding', 'bms', 'tm/tm.changelog-6.0.0.xml', NOW(), 607, '8:0b1332faad6e21410756b12d60f8ff92', 'sql', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-6.0.0.xml::tm-6.0.0-667-rename-squashautom-ta-server-kind::jprioux
UPDATE TEST_AUTOMATION_SERVER SET KIND = 'squashOrchestrator' WHERE KIND = 'squashAutom';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-667-rename-squashautom-ta-server-kind', 'jprioux', 'tm/tm.changelog-6.0.0.xml', NOW(), 608, '8:a0980811d3c54a8db982dc315e878f94', 'update tableName=TEST_AUTOMATION_SERVER', '', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-7.0.0.xml::tm-7.0.0::mbrugniere
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '7.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', NOW(), 609, '8:4d84039428ec1c6e75236450ae5a2b45', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-7.0.0.xml::tm-7.0.0-45-clean-database-of-nulls-in-action-steps::mbrugniere
--  Clean database of null values in test steps and execution steps
UPDATE ACTION_TEST_STEP SET ACTION = '' WHERE ACTION IS NULL;

UPDATE ACTION_TEST_STEP SET EXPECTED_RESULT = '' WHERE EXPECTED_RESULT IS NULL;

UPDATE EXECUTION_STEP SET ACTION = '' WHERE ACTION IS NULL;

UPDATE EXECUTION_STEP SET EXPECTED_RESULT = '' WHERE EXPECTED_RESULT IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-45-clean-database-of-nulls-in-action-steps', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', NOW(), 610, '8:15d6f2ec592778bc044a2ec3442f2b70', 'update tableName=ACTION_TEST_STEP; update tableName=ACTION_TEST_STEP; update tableName=EXECUTION_STEP; update tableName=EXECUTION_STEP', 'Clean database of null values in test steps and execution steps', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-7.0.0.xml::tm-7.0.0-895-action-and-expected_result_should_not_be_nullable::mbrugniere
--  Add not null constraint on columns action and expected_result
ALTER TABLE ACTION_TEST_STEP MODIFY ACTION LONGTEXT NOT NULL;

ALTER TABLE ACTION_TEST_STEP ALTER ACTION SET DEFAULT '';

ALTER TABLE ACTION_TEST_STEP MODIFY EXPECTED_RESULT LONGTEXT NOT NULL;

ALTER TABLE ACTION_TEST_STEP ALTER EXPECTED_RESULT SET DEFAULT '';

ALTER TABLE EXECUTION_STEP MODIFY ACTION LONGTEXT NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER ACTION SET DEFAULT '';

ALTER TABLE EXECUTION_STEP MODIFY EXPECTED_RESULT LONGTEXT NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER EXPECTED_RESULT SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-895-action-and-expected_result_should_not_be_nullable', 'mbrugniere', 'tm/tm.changelog-7.0.0.xml', NOW(), 611, '8:c73ee0e5cd76bc2fda03748af103f49f', 'addNotNullConstraint columnName=ACTION, tableName=ACTION_TEST_STEP; addDefaultValue columnName=ACTION, tableName=ACTION_TEST_STEP; addNotNullConstraint columnName=EXPECTED_RESULT, tableName=ACTION_TEST_STEP; addDefaultValue columnName=EXPECTED_RES...', 'Add not null constraint on columns action and expected_result', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-7.0.0.xml::tm-7.0.0-876-update-cufs-in-column-configuration::jma
--  Delete active_column_id if it does not match any cuf code. Replace the cuf's code with the cuf's id.
DELETE
      FROM GRID_COLUMN_DISPLAY_CONFIGURATION
      WHERE active_column_id LIKE 'cuf|%'
        AND active_column_id NOT IN (SELECT CONCAT('cuf|', code) FROM CUSTOM_FIELD);

UPDATE GRID_COLUMN_DISPLAY_CONFIGURATION AS gcdc
      SET active_column_id = (SELECT CONCAT('cuf|', cf.cf_id)
                              FROM CUSTOM_FIELD AS cf
                              WHERE SUBSTRING(gcdc.active_column_id, LENGTH('cuf|') + 1) = cf.code)
      WHERE gcdc.active_column_id LIKE 'cuf|%';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-876-update-cufs-in-column-configuration', 'jma', 'tm/tm.changelog-7.0.0.xml', NOW(), 612, '8:cde1f300d157fb293173c7e75fdf4cfa', 'sql', 'Delete active_column_id if it does not match any cuf code. Replace the cuf''s code with the cuf''s id.', 'EXECUTED', NULL, 'legacy', '4.19.0', '7869434667');

--  Changeset tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-table::jprioux
--  Create the sprint table
CREATE TABLE SPRINT (CLN_ID BIGINT NOT NULL COMMENT 'Shared key with CAMPAIGN_LIBRARY_NODE table', STATUS VARCHAR(50) DEFAULT 'UPCOMING' NOT NULL, REMOTE_SYNCHRONISATION_ID BIGINT NULL, REMOTE_SPRINT_ID BIGINT NULL, REMOTE_NAME VARCHAR(255) NULL, REMOTE_STATE VARCHAR(50) NULL, START_DATE datetime NULL, END_DATE datetime NULL, `REFERENCE` VARCHAR(255) NULL, CONSTRAINT pk_sprint PRIMARY KEY (CLN_ID), CONSTRAINT fk_sprint_remote_synchronisation FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION(REMOTE_SYNCHRONISATION_ID), CONSTRAINT fk_sprint_campaign_library_node FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID)) ENGINE = INNODB;

CREATE INDEX idx_fk_sprint_remote_synchronisation ON SPRINT(REMOTE_SYNCHRONISATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-table', 'jprioux', 'tm/tm.changelog-7.0.0.xml', NOW