@REM
@REM     This file is part of the Squashtest platform.
@REM     Copyright (C) Henix, henix.fr
@REM
@REM     See the NOTICE file distributed with this work for additional
@REM     information regarding copyright ownership.
@REM
@REM     This is free software: you can redistribute it and/or modify
@REM     it under the terms of the GNU Lesser General Public License as published by
@REM     the Free Software Foundation, either version 3 of the License, or
@REM     (at your option) any later version.
@REM
@REM     this software is distributed in the hope that it will be useful,
@REM     but WITHOUT ANY WARRANTY; without even the implied warranty of
@REM     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@REM     GNU Lesser General Public License for more details.
@REM
@REM     You should have received a copy of the GNU Lesser General Public License
@REM     along with this software.  If not, see <http://www.gnu.org/licenses/>.
@REM

@echo off

IF "%SQUASH_TM_HOME%" == "" set SQUASH_TM_HOME=..

REM Default variables
set JAR_NAME=%SQUASH_TM_HOME%/bundles/squash-tm.war
set HTTP_PORT=8080
REM Set directory variables
set TMP_DIR=%SQUASH_TM_HOME%\tmp
IF NOT EXIST %TMP_DIR% MKDIR %TMP_DIR%
set BUNDLES_DIR=%SQUASH_TM_HOME%/bundles
set CONF_DIR=%SQUASH_TM_HOME%/conf
set LOG_DIR=%SQUASH_TM_HOME%\logs
set TOMCAT_HOME=%SQUASH_TM_HOME%\tomcat-home
IF NOT EXIST %LOG_DIR% MKDIR %LOG_DIR%\service
set PLUGINS_DIR=%SQUASH_TM_HOME%/plugins
REM DataBase parameters
REM DB_TYPE can be one of h2, mariadb, postgresql
set DB_TYPE=h2
set DB_URL=jdbc:h2:%SQUASH_TM_HOME%/data/squash-tm;NON_KEYWORDS=ROW,VALUE
set DB_USERNAME=sa
set DB_PASSWORD=sa
REM Extra Java args
REM Uncomment below for server mode. It requires a JDK instead of a JRE
REM set SERVER_MODE=-server
set JAVA_ARGS=-Xms128m -Xmx2048m %SERVER_MODE%

REM Java arguments
set APP_OPTS=-Dspring.datasource.url=%DB_URL% -Dspring.datasource.username=%DB_USERNAME% -Dspring.datasource.password=%DB_PASSWORD% -Duser.language=en

set DAEMON_ARGS=%JAVA_ARGS% %APP_OPTS% %JAVA_TOOL_OPTIONS% -Djava.io.tmpdir=%TMP_DIR% -Dlogging.dir=%LOG_DIR% -jar %JAR_NAME% --spring.profiles.active=%DB_TYPE% --spring.config.additional-location=file:%CONF_DIR%/ --spring.config.name=application,squash.tm.cfg --squash.path.root=%SQUASH_TM_HOME% --squash.path.bundles-path=%BUNDLES_DIR% --squash.path.plugins-path=%PLUGINS_DIR% --server.port=%HTTP_PORT% --server.tomcat.basedir=%TOMCAT_HOME% --logging.config=%CONF_DIR%/log4j2.xml

REM Start java process
echo Cleaning temporary files...
FOR /D %%d IN (%TMP_DIR%\*) DO @rmdir /S /Q %%d
DEL /S /Q %TMP_DIR%\*

REM set REMOTE_DEBUG=-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005 -Ddebug

echo Starting Squash TM...
java %DAEMON_ARGS%

