/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define([ "jquery", "backbone", "workspace.routing", "squash.translator",
	"./steps/sideView", "./steps/actionChoiceStepView", "./steps/sourceIterationStepView", "./steps/simpleCriteriaStepView", "./steps/advancedCriteriaStepView",
	"./steps/previewStepView", "./steps/targetIterationStepView", "jquery.squash.togglepanel", "jquery.squash.confirmdialog" ],
	function($, Backbone, router, translator,
		SideView, ActionChoiceStepView, SourceIterationStepView, SimpleCriteriaStepView,
		AdvancedCriteriaStepView, PreviewStepView, TargetIterationStepView) {

	"use strict";

	var steps = [
	  {
        name : "actionChoiceStep",
        prevStep : "",
        nextStepDeterminant: "action",
        nextStep : {
            // Next step depends on the chosen action.
            "iterationReplication": "sourceIterationStep",
            // Other actions are not implemented Yet.
            "iterationCreation": "",
            "iterationModification": ""
        },
        viewTitle : "campaignassistant.wizard.actionChoiceStep.title",
        stepNumber : 1,
        buttons : ["next"],
        clickable : true,
        validationParameters: ["action"]
      },
      {
        name : "sourceIterationStep",
        prevStep : "actionChoiceStep",
        nextStepDeterminant: "criteriaType",
        nextStep : {
            // Next step depends on criteria type.
            "simple": "simpleCriteriaStep",
            "advanced": "advancedCriteriaStep"
        },
        viewTitle : "campaignassistant.wizard.sourceIterationStep.title",
        stepNumber : 2,
        buttons : ["previous", "next"],
        clickable : true,
        neededParameters : ["action"],
        validationParameters: ["criteriaType", "replicationParameters"]
      },
      {
        name : "simpleCriteriaStep",
        prevStep : "sourceIterationStep",
        nextStep : "previewStep",
        viewTitle : "campaignassistant.wizard.simpleCriteriaStep.title",
        stepNumber : 3,
        determinant: {
                    attribute: "criteriaType",
                    value: "simple"
        },
        buttons : ["previous", "generate"],
        clickable : true,
        neededParameters : ["criteriaType", "replicationParameters"],
        validationParameters: ["simpleCriteria"]
      },
      {
        name : "advancedCriteriaStep",
        prevStep : "sourceIterationStep",
        nextStep : "previewStep",
        viewTitle : "campaignassistant.wizard.advancedCriteriaStep.title",
        stepNumber : 3,
        determinant: {
            attribute: "criteriaType",
            value: "advanced"
        },
        buttons : ["previous", "generate"],
        clickable : true,
        neededParameters : ["criteriaType", "replicationParameters"],
        validationParameters: ["advancedCriteria"]
      },
      {
        name : "previewStep",
        previousStepDeterminant: "criteriaType",
        prevStep : {
            // Previous step depends on the criteria type.
            "simple": "simpleCriteriaStep",
            "advanced": "advancedCriteriaStep"
        },
        nextStep : "targetIterationStep",
        viewTitle : "campaignassistant.wizard.previewStep.title",
        stepNumber : 4,
        buttons : ["previous", "next"],
        clickable : true,
        neededParameters : ["testPlan", "replicationParameters"],
        validationParameters: ["testPlan"]
      },
      {
        name : "targetIterationStep",
        prevStep : "previewStep",
        nextStep : "",
        viewTitle : "campaignassistant.wizard.targetIterationStep.title",
        stepNumber : 5,
        buttons : ["previous", "create"],
        clickable : true,
        neededParameters : ["testPlan", "replicationParameters"],
        validationParameters: ["newIteration"]
      }];
    var entityTypes = {
        TEST_PLAN_ITEM: "icon-wizard-test-plan-item",
        TEST_CASE: "icon-wizard-test-case",
        REQUIREMENT: "icon-wizard-requirement",
        TEST_SUITE: "icon-wizard-test-suite",
        ISSUE: "icon-wizard-issue"
    };
    var totalStepNumberByAction = {

        "iterationReplication": 5
    };

	var wizardView = Backbone.View.extend({

		el : "#wizard",

		initialize : function(options) {

			this.model = options.model;
			this.model.set({
				steps: steps,
				entityTypes: entityTypes,
				totalStepNumberByAction: totalStepNumberByAction
			});
		},

		events : {
			"click #next" : "navigateNext",
			"click #previous" : "navigatePrevious",
            "click #generate" : "navigateNext",
			"click #create" : "createIteration"
		},

		navigateNext : function (){

			this.currentView.navigateNext();
		},
		navigatePrevious : function (){

			this.currentView.navigatePrevious();
		},

		createIteration : function() {

			this.currentView.createIteration();
		},

		showSideView : function(){
			this.resetSideView();
			this.currentSideView = new SideView(this.model);
		},

		showNewStepView : function (View, wizrouter){
			if (this.currentView !== undefined && this.currentView.updateMode === true) {
				this.currentView.updateModel();
			}

			this.resetView();
			this.currentView = new View(this.model, wizrouter);
			this.showSideView();
		},

		showActionChoiceStep: function(wizrouter) {

			this.showNewStepView(ActionChoiceStepView, wizrouter);
		},
		showSourceIterationStep: function(wizrouter) {

			this.showNewStepView(SourceIterationStepView, wizrouter);
		},
		showSimpleCriteriaStep: function(wizrouter) {

			this.showNewStepView(SimpleCriteriaStepView, wizrouter);
		},
		showAdvancedCriteriaStep: function(wizrouter) {

			this.showNewStepView(AdvancedCriteriaStepView, wizrouter);
		},
		showPreviewStep: function(wizrouter) {

			this.showNewStepView(PreviewStepView, wizrouter);
		},
		showTargetIterationStep: function(wizrouter) {

			this.showNewStepView(TargetIterationStepView, wizrouter);
		},

		resetView : function() {

			if (this.currentView !== undefined) {
				this.currentView.destroy_view();
				$("#current-step-container").html('<span id="current-step" />');
			}
		},

		resetSideView : function() {

            if (this.currentSideView !== undefined) {
                this.currentSideView.destroy_view();
                    $("#current-side-view-container").html('<span style="display : table; height:100%" id="side-view" />');
                }
            }

	});

	return wizardView;

});
