select distinct TCLN.TCLN_ID,
       R2.RLN_ID,
	   PROJ.NAME as PROJECTNAME,
	   TC.REFERENCE as REFERENCE,
	   TCLN.NAME as TESTCASENAME,
	   GROUP_CONCAT(case when MSTONES.LABEL is not null then concat(MSTONES.LABEL, '=Sep=') end) as MILESTONE,
	   TC.TC_STATUS as STATUS,
	   TC.IMPORTANCE,
	   VERSION.RES_ID
from TEST_CASE_LIBRARY_NODE TCLN
		 inner join TEST_CASE TC on TC.TCLN_ID = TCLN.TCLN_ID
		 inner join PROJECT PROJ on PROJ.PROJECT_ID = TCLN.PROJECT_ID
		 inner join REQUIREMENT_VERSION_COVERAGE VERIF on VERIF.VERIFYING_TEST_CASE_ID = TCLN.TCLN_ID
		 inner join REQUIREMENT_VERSION VERSION on VERSION.RES_ID = VERIF.VERIFIED_REQ_VERSION_ID
    	 inner join REQUIREMENT R on VERSION.RES_ID = R.CURRENT_VERSION_ID
    	 left join REQUIREMENT R2 on R.HIGH_LEVEL_REQUIREMENT_ID = R2.RLN_ID
		 left join MILESTONE_TEST_CASE TCSTONES on TC.TCLN_ID = TCSTONES.TEST_CASE_ID
		 left join MILESTONE MSTONES on TCSTONES.MILESTONE_ID = MSTONES.MILESTONE_ID
where R.HIGH_LEVEL_REQUIREMENT_ID in (:hlrIds)
group by TCLN.TCLN_ID, VERSION.RES_ID, PROJ.NAME, TC.REFERENCE, TCLN.NAME, TC.IMPORTANCE, TC.TCLN_ID, R2.RLN_ID
order by VERSION.RES_ID, TC.IMPORTANCE, PROJ.NAME, TC.REFERENCE, TCLN.NAME
