/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.repository.RestRequirementRepository;
import org.squashtest.tm.plugin.rest.repository.RestRequirementVersionRepository;
import org.squashtest.tm.plugin.rest.validators.helper.RequirementVersionDtoValidationHelper;

@Component
public class RequirementVersionValidator
implements Validator {
    private static final String POST_REQUIREMENT_VERSION = "post-requirement-version";
    private static final String PATCH_REQUIREMENT_VERSION = "patch-requirement-version";
    public static final String ASSOCIATE_TEST_CASES = "associate-test-cases";
    public static final String DISASSOCIATE_TEST_CASES = "disassociate-test-cases";
    @Inject
    private RequirementVersionDtoValidationHelper requirementVersionDtoValidationHelper;
    @Inject
    private RestRequirementRepository restRequirementRepository;
    @Inject
    private RestRequirementVersionRepository restRequirementVersionRepository;

    public boolean supports(Class<?> clazz) {
        return RequirementVersionDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RequirementVersionDto requirementVersionDto = (RequirementVersionDto)target;
        if (requirementVersionDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing requirement version, please do a patch request to the requirement version id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.requirementVersionDtoValidationHelper.checkAndAssignValues(errors, requirementVersionDto);
    }

    public void validateRequirementVersion(RequirementVersionDto requirementVersionDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementVersionDto, POST_REQUIREMENT_VERSION);
        this.validate(requirementVersionDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(requirementVersionDto, errors, POST_REQUIREMENT_VERSION);
    }

    public void validatePostRequirementVersion(Long requirementId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        RequirementVersionDto dummyRequirementVersionDto = new RequirementVersionDto();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)dummyRequirementVersionDto, POST_REQUIREMENT_VERSION);
        Requirement requirement = (Requirement)this.restRequirementRepository.getReferenceById(requirementId);
        if (requirement.isSynchronized()) {
            validation.rejectValue("requirement", "synchronised requirement", "Can not create version for a synchronized requirement");
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(dummyRequirementVersionDto, errors, POST_REQUIREMENT_VERSION);
    }

    public void validatePatchRequirementVersion(RequirementVersionDto requirementVersionDto, Long requirementId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementVersionDto, PATCH_REQUIREMENT_VERSION);
        Requirement requirement = (Requirement)this.restRequirementRepository.getReferenceById(requirementId);
        requirementVersionDto.setProjectId(requirement.getProject().getId());
        if (requirement.getStatus().equals((Object)RequirementStatus.OBSOLETE)) {
            validation.rejectValue("status", "obsolete requirement", "Can not change an obsolete requirement");
        }
        if (requirement.getStatus().equals((Object)RequirementStatus.APPROVED) && !requirementVersionDto.isHasStatus()) {
            validation.rejectValue("status", "approved requirement", "Can not change an approved requirement");
        }
        if (requirementVersionDto.isHasName()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)validation, (String)"name", (String)"required", (String)"This attribute can't be empty");
        }
        this.requirementVersionDtoValidationHelper.checkAndAssignValuesPatch((Errors)validation, requirementVersionDto, requirement);
        if (requirementVersionDto.isHasCufs()) {
            this.requirementVersionDtoValidationHelper.checkCufs((Errors)validation, requirementVersionDto);
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(requirementVersionDto, errors, PATCH_REQUIREMENT_VERSION);
    }

    public void validateAssociateTestCases(long requirementVersionId, List<Long> testCaseIds) throws BindException {
        this.doValidateVerifyingTestCasesToRequirementVersion(requirementVersionId, testCaseIds, ASSOCIATE_TEST_CASES);
    }

    public void validateDisassociateTestCases(long requirementVersionId, List<Long> testCaseIds) throws BindException {
        this.doValidateVerifyingTestCasesToRequirementVersion(requirementVersionId, testCaseIds, DISASSOCIATE_TEST_CASES);
    }

    private void doValidateVerifyingTestCasesToRequirementVersion(long requirementVersionId, List<Long> testCaseIds, String errorMessage) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        RequirementVersionDto dummyRequirementVersionDto = new RequirementVersionDto();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)dummyRequirementVersionDto, errorMessage);
        this.requirementVersionDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.REQUIREMENT_VERSION, requirementVersionId);
        for (Long id : testCaseIds) {
            this.requirementVersionDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.TEST_CASE, id);
            if (!errorMessage.equalsIgnoreCase(ASSOCIATE_TEST_CASES)) continue;
            this.checkIfTestCaseIsAleadyBindInAnotherVersion((Errors)validationBean, requirementVersionId, id);
        }
        if (validationBean.hasErrors()) {
            errors.add((Errors)validationBean);
        }
        ErrorHandlerHelper.throwIfError(dummyRequirementVersionDto, errors, errorMessage);
    }

    private void checkIfTestCaseIsAleadyBindInAnotherVersion(Errors errors, long requirementVersionId, long testCaseId) {
        List<Long> allVerifyingTestcaseIds = this.getAllVerifyingTestcaseIds(requirementVersionId);
        if (allVerifyingTestcaseIds.contains(testCaseId)) {
            String message = String.format("Can not bind the test case %s on this requirement version (id:%d) because is already bind in another version.", testCaseId, requirementVersionId);
            errors.rejectValue("requirement", "invalid test case id", message);
        }
    }

    private List<Long> getAllVerifyingTestcaseIds(long requirementVersionId) {
        RequirementVersion reqVersion = (RequirementVersion)this.restRequirementVersionRepository.getReferenceById(requirementVersionId);
        List allRequirementVersion = reqVersion.getRequirement().getRequirementVersions();
        return allRequirementVersion.stream().flatMap(sys -> sys.getVerifyingTestCases().stream().map(TestCaseLibraryNode::getId)).collect(Collectors.toList());
    }
}

