/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectCopyParameterDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTemplateDto;

@Component
public class GenericProjectPostValidator
implements Validator {
    private static final String PARAMS_FIELD = "params";
    private static final String INCONSISTENT_PARAM_VALUES_ERROR_CODE = "inconsistent parameter values";
    @PersistenceContext
    protected EntityManager entityManager;

    public boolean supports(Class<?> clazz) {
        return GenericProjectDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, final Errors errors) {
        GenericProjectDto genericProjectDto = (GenericProjectDto)target;
        if (genericProjectDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing generic project, please do a patch request to the generic project id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        GenericProjectDtoVisitor visitor = new GenericProjectDtoVisitor(){

            @Override
            public void visit(ProjectDto projectDto) {
                if (projectDto.getTemplateId() != null) {
                    GenericProjectPostValidator.this.checkAndAssignValues(projectDto);
                    GenericProjectPostValidator.this.validateTemplateBindingConsistency(errors, projectDto);
                    GenericProjectPostValidator.this.validatePluginBindingConsistency(errors, projectDto);
                    GenericProjectPostValidator.this.checkIfEntityExist(errors, projectDto.getTemplateId());
                }
            }

            @Override
            public void visit(ProjectTemplateDto projectTemplateDto) {
                if (projectTemplateDto.getProjectId() != null) {
                    GenericProjectPostValidator.this.checkAndAssignValues(projectTemplateDto);
                    GenericProjectPostValidator.this.validateCopyParametersConsistency(errors, projectTemplateDto);
                    GenericProjectPostValidator.this.checkIfEntityExist(errors, projectTemplateDto.getProjectId());
                }
            }
        };
        genericProjectDto.accept(visitor);
    }

    private void checkAndAssignValues(GenericProjectDto genericProjectDto) {
        if (genericProjectDto.getParams() == null) {
            genericProjectDto.setParams(new GenericProjectCopyParameterDto());
        }
    }

    private void checkIfEntityExist(Errors errors, Long id) {
        GenericProject genericProject = (GenericProject)this.entityManager.find(GenericProject.class, (Object)id);
        if (genericProject == null) {
            String message = String.format("No project of project template known for id %d", id);
            errors.rejectValue("id", "invalid id", message);
        }
    }

    private void validatePluginBindingConsistency(Errors errors, GenericProjectDto genericProjectDto) {
        GenericProjectCopyParameterDto copyParams = genericProjectDto.getParams();
        boolean keepTemplateBinding = copyParams.isKeepTemplateBinding();
        boolean keepPluginsBinding = copyParams.isKeepPluginsBinding();
        boolean copyPluginsConfiguration = copyParams.isCopyPluginsConfiguration();
        boolean copyCuf = copyParams.isCopyCUF();
        boolean copyInfolists = copyParams.isCopyInfolists();
        if (!(!copyPluginsConfiguration || copyCuf && copyInfolists)) {
            errors.rejectValue(PARAMS_FIELD, INCONSISTENT_PARAM_VALUES_ERROR_CODE, "Inconsistent parameter values: 'copy_cuf' and 'copy_infolists' must be both set to true when 'copy_plugins_configuration' is true.");
        }
        if (!(!keepPluginsBinding || copyPluginsConfiguration && keepTemplateBinding)) {
            errors.rejectValue(PARAMS_FIELD, INCONSISTENT_PARAM_VALUES_ERROR_CODE, "Inconsistent parameter values: 'copy_plugins_configuration' and 'keep_template_binding' must be both set to true when 'keep_plugins_binding' is true.");
        }
    }

    private void validateTemplateBindingConsistency(Errors errors, GenericProjectDto genericProjectDto) {
        GenericProjectCopyParameterDto copyParams = genericProjectDto.getParams();
        boolean keepTemplateBinding = copyParams.isKeepTemplateBinding();
        boolean copyCuf = copyParams.isCopyCUF();
        boolean copyInfolists = copyParams.isCopyInfolists();
        boolean copyAllowTcModifFromExec = copyParams.isCopyAllowTcModifFromExec();
        boolean copyOptionalExecStatuses = copyParams.isCopyOptionalExecStatuses();
        if (!(!keepTemplateBinding || copyCuf && copyInfolists && copyAllowTcModifFromExec && copyOptionalExecStatuses)) {
            errors.rejectValue(PARAMS_FIELD, INCONSISTENT_PARAM_VALUES_ERROR_CODE, "Inconsistent parameter values: 'copy_cuf', 'copy_infolists', 'copy_allow_tc_modif_from_exec' and 'copy_optional_exec_statuses' must be all true when 'keep_template_binding' is true.");
        }
    }

    private void validateCopyParametersConsistency(Errors errors, GenericProjectDto genericProjectDto) {
        GenericProjectCopyParameterDto copyParams = genericProjectDto.getParams();
        boolean copyCuf = copyParams.isCopyCUF();
        boolean copyInfolists = copyParams.isCopyInfolists();
        boolean copyPluginsActivation = copyParams.isCopyPluginsActivation();
        boolean copyPluginsConfiguration = copyParams.isCopyPluginsConfiguration();
        if (!(!copyPluginsConfiguration || copyCuf && copyInfolists && copyPluginsActivation)) {
            errors.rejectValue(PARAMS_FIELD, INCONSISTENT_PARAM_VALUES_ERROR_CODE, "Inconsistent parameter values: 'copy_cuf', 'copy_infolists' and 'copy_plugins_activation' must be all true when 'copy_plugins_configuration' is true.");
        }
    }
}

