/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.exception.IllegalPremiumFeatureAccessException;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDto;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyClearance;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyProfileDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestUserPermission;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.plugin.rest.repository.RestPartyRepository;
import org.squashtest.tm.plugin.rest.repository.RestTeamRepository;
import org.squashtest.tm.plugin.rest.repository.RestUserRepository;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.impl.UserPatcher;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Transactional
public class RestPartyServiceImpl
implements RestPartyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestPartyServiceImpl.class);
    @Inject
    private UserManagerService userManagerService;
    @Inject
    private TeamModificationService teamModificationService;
    @Inject
    private GenericProjectManagerService projectManagerService;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private RestTeamRepository teamDao;
    @Inject
    private RestUserRepository userDao;
    @Inject
    private DSLContext dslContext;
    @Inject
    private UserAdministrationService userAdministrationService;
    @Inject
    private RestPartyRepository partyRepository;
    @Inject
    private UserPatcher userPatcher;
    @Inject
    private ProjectsPermissionManagementService permissionService;
    @Inject
    private ProjectsPermissionFinder permissionFinder;
    @Inject
    private PluginFinderService pluginFinderService;
    private static final String NAMESPACE = "squashtest.acl.group.tm.";

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Team findTeamByPartyId(long id) {
        return (Team)this.findById(id);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public User findUserByPartyId(long id) {
        return (User)this.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Party findById(long id) {
        Optional party = this.partyRepository.findById(id);
        if (!party.isPresent()) {
            throw new EntityNotFoundException("The user/team with id: " + id + " does not exist.");
        }
        final Party[] result = new Party[1];
        PartyVisitor visitor = new PartyVisitor(){

            public void visit(User user) {
                result[0] = user;
            }

            public void visit(Team team) {
                result[0] = team;
            }
        };
        ((Party)party.get()).accept(visitor);
        return result[0];
    }

    @Override
    @Transactional(readOnly=true)
    public List<Party> findByIds(List<Long> partyIds) {
        return this.partyRepository.findAllById(partyIds).stream().map(party -> {
            final Party[] result = new Party[1];
            PartyVisitor visitor = new PartyVisitor(){

                public void visit(User user) {
                    result[0] = user;
                }

                public void visit(Team team) {
                    result[0] = team;
                }
            };
            party.accept(visitor);
            return result[0];
        }).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public Party getOne(long id) {
        Party party = this.projectManagerService.findPartyById(id);
        if (party == null) {
            throw new EntityNotFoundException("The user/team with id: " + id + " does not exist.");
        }
        return party;
    }

    @Override
    public User findUserByLogin(String login) {
        return this.userManagerService.findByLogin(login);
    }

    @Override
    @PostAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<User> findAllUsers(Pageable pageable) {
        return this.userDao.findAll(pageable);
    }

    @Override
    @PostAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<Team> findAllTeams(Pageable pageable) {
        return this.teamDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<Team> findTeamsByUser(long userId, Pageable pageable) {
        return this.teamDao.findTeamsByUserId(userId, pageable);
    }

    @Override
    public Party createParty(PartyDto partyDto) {
        final Party[] parties = new Party[1];
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                User user = new User();
                if (userDto.getFirstName() != null) {
                    user.setFirstName(userDto.getFirstName());
                }
                user.setLastName(userDto.getLastName());
                user.setLogin(userDto.getLogin());
                if (userDto.getEmail() != null) {
                    user.setEmail(userDto.getEmail());
                }
                user.setActive(userDto.getActive());
                RestPartyServiceImpl.this.userManagerService.addUser(user, userDto.getGroupId().longValue(), userDto.getPassword());
                if (userDto.getCanDeleteFromFront() != null) {
                    RestPartyServiceImpl.this.assertPremiumPluginIsInstalled();
                    user.setCanDeleteFromFront(userDto.getCanDeleteFromFront().booleanValue());
                }
                parties[0] = user;
            }

            @Override
            public void visit(TeamDto teamDto) {
                Team team = new Team();
                team.setName(teamDto.getName());
                team.setDescription(teamDto.getDescription());
                RestPartyServiceImpl.this.teamModificationService.persist(team);
                parties[0] = team;
            }
        };
        partyDto.accept(visitor);
        return parties[0];
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Party patchParty(PartyDto patch, final long id) {
        final Party party = this.findById(id);
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                if (userDto.getPassword() != null) {
                    RestPartyServiceImpl.this.userManagerService.resetUserPassword(id, userDto.getPassword());
                }
                if (userDto.getLogin() != null) {
                    RestPartyServiceImpl.this.userManagerService.modifyUserLogin(id, userDto.getLogin());
                }
                if (userDto.getGroupId() != null) {
                    RestPartyServiceImpl.this.userManagerService.setUserGroupAuthority(id, userDto.getGroupId().longValue());
                }
                if (userDto.getActive() != null) {
                    RestPartyServiceImpl.this.activateOrDeactivateUser(id, userDto.getActive());
                }
                if (userDto.getCanDeleteFromFront() != null) {
                    RestPartyServiceImpl.this.assertPremiumPluginIsInstalled();
                    RestPartyServiceImpl.this.userManagerService.changeCanDeleteFromFront(id, userDto.getCanDeleteFromFront().booleanValue());
                }
                RestPartyServiceImpl.this.userPatcher.patch(party, userDto);
            }

            @Override
            public void visit(TeamDto teamDto) {
                if (teamDto.getName() != null) {
                    RestPartyServiceImpl.this.teamModificationService.changeName(id, teamDto.getName());
                }
                if (teamDto.getDescription() != null) {
                    RestPartyServiceImpl.this.teamModificationService.changeDescription(id, teamDto.getDescription());
                }
            }
        };
        patch.accept(visitor);
        return party;
    }

    @Override
    public void deleteUsers(List<Long> ids) {
        this.userManagerService.deleteUsers(ids);
    }

    @Override
    public void deleteTeams(List<Long> ids) {
        this.teamModificationService.deleteTeam(ids);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<User> findAllTeamMembers(long teamId, Pageable pageable) {
        return this.userDao.findMembersByTeamId(teamId, pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addMembersToTeam(long teamId, List<Long> userIds) {
        List userLogins = this.dslContext.select((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.PARTY_ID.in(userIds)).fetchInto(String.class);
        this.teamModificationService.addMembers(teamId, userLogins);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeMembersFromTeam(long teamId, List<Long> userIds) {
        try {
            Team cfr_ignored_0 = (Team)this.findById(teamId);
            this.teamModificationService.removeMembers(teamId, userIds);
        }
        catch (ClassCastException classCastException) {
            throw new EntityNotFoundException("The team with id: " + teamId + " does not exist.");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Set<String> addTeamsToUser(long userId, List<Long> teamIds) {
        return this.userAdministrationService.associateToTeams(userId, teamIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void disassociateUserFromTeams(long userId, List<Long> teamIds) {
        try {
            this.userManagerService.deassociateTeams(userId, teamIds);
        }
        catch (ClassCastException classCastException) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not exist.");
        }
    }

    @Override
    @PostAuthorize(value="hasRole('ROLE_ADMIN')")
    public RestPartyClearance getAllClearancesForGivenUser(long userId) {
        List projectPermissions = this.permissionFinder.findProjectPermissionByParty(userId);
        if (projectPermissions.isEmpty()) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not have any permissions.");
        }
        return this.getUserClearances(projectPermissions);
    }

    @Override
    @PostAuthorize(value="hasRole('ROLE_ADMIN')")
    public RestUserPermission getAllPermissionsForGivenUser(long userId) {
        List projectPermissions = this.permissionFinder.findProjectPermissionByParty(userId);
        if (projectPermissions.isEmpty()) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not have any permissions.");
        }
        return this.getUserPermissions(projectPermissions);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addClearanceToUser(long userId, List<Long> projectIds, long profileId) {
        if (!this.ifUserExist(userId)) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not exist.");
        }
        this.permissionService.addNewPermissionToProject(userId, projectIds, profileId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addPermissionToUser(long userId, List<Long> projectIds, String permission) {
        if (!this.ifUserExist(userId)) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not exist.");
        }
        try {
            this.permissionService.addNewPermissionToProject(userId, projectIds, NAMESPACE + permission);
        }
        catch (RuntimeException e) {
            LOGGER.debug("An error occurred trying to add permission {} to user {} on following project ids : {}", new Object[]{permission, userId, projectIds, e});
            throw new EntityNotFoundException(e.getMessage());
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removePermissionToUser(long userId, List<Long> projectIds) {
        if (!this.ifUserExist(userId)) {
            throw new EntityNotFoundException("The user with id: " + userId + " does not exist.");
        }
        try {
            this.permissionService.removeProjectPermission(userId, projectIds);
        }
        catch (RuntimeException e) {
            LOGGER.debug("An error occurred trying to remove permission to user {} on following project ids : {}", new Object[]{userId, projectIds, e});
            throw new EntityNotFoundException(e.getMessage());
        }
    }

    private RestPartyClearance getUserClearances(List<ProjectPermission> projectPermissions) {
        RestPartyClearance clearances = new RestPartyClearance();
        for (ProjectPermission projPermission : projectPermissions) {
            AclGroup profile = projPermission.getPermissionGroup();
            String profileName = profile.getSimpleName();
            if ("advanceTester".equalsIgnoreCase(profileName)) {
                profileName = "advancedTester";
            }
            GenericProject currentProject = projPermission.getProject();
            RestPartyProfileDto targetList = clearances.getPartyClearances().get(profileName);
            if (targetList == null) {
                long profileId = profile.getId();
                boolean isSystem = profile.isSystem();
                ArrayList<GenericProject> projects = new ArrayList<GenericProject>();
                projects.add(currentProject);
                targetList = new RestPartyProfileDto(projects, profileId, profileName, isSystem);
                clearances.getPartyClearances().put(profileName, targetList);
                continue;
            }
            targetList.getProjects().add(currentProject);
        }
        return clearances;
    }

    private RestUserPermission getUserPermissions(List<ProjectPermission> projectPermissions) {
        RestUserPermission userPermissions = new RestUserPermission();
        for (ProjectPermission projPermission : projectPermissions) {
            String groupName = projPermission.getPermissionGroup().getSimpleName();
            if ("advanceTester".equalsIgnoreCase(groupName)) {
                groupName = "advancedTester";
            }
            GenericProject currentProject = projPermission.getProject();
            List<GenericProject> targetList = userPermissions.getUserPermissions().get(groupName);
            if (targetList == null) {
                targetList = new ArrayList<GenericProject>();
                targetList.add(currentProject);
                userPermissions.getUserPermissions().put(groupName, targetList);
                continue;
            }
            targetList.add(currentProject);
        }
        return userPermissions;
    }

    private boolean ifUserExist(long userId) {
        return this.userDao.existsById(userId);
    }

    private void activateOrDeactivateUser(long userId, boolean active) {
        if (active) {
            this.userManagerService.activateUser(userId);
        } else {
            this.userManagerService.deactivateUser(userId);
        }
    }

    private void assertPremiumPluginIsInstalled() throws IllegalPremiumFeatureAccessException {
        if (!this.pluginFinderService.isPremiumPluginInstalled()) {
            throw new IllegalPremiumFeatureAccessException();
        }
    }
}

