/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.plugin.rest.service.RestTestSuiteService;

@Component
public class TestSuiteStatusWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private RestTestSuiteService restTestSuiteService;

    public TestSuiteStatusWriter() {
    }

    private TestSuiteStatusWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, RestTestSuiteService restTestSuiteService) {
        super(propDef, contextAnnotations, declaredType);
        this.restTestSuiteService = restTestSuiteService;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) {
        TestSuite holder = (TestSuite)bean;
        TestPlanStatistics testPlanStatistics = this.restTestSuiteService.getTestSuiteStatisticsByTestSuiteIds(holder.getId());
        return testPlanStatistics.getStatus();
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new TestSuiteStatusWriter(propDef, declaringClass.getAnnotations(), type, this.restTestSuiteService);
    }
}

