/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Configurable;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.plugin.rest.jackson.serializer.HateoasWrapperConverter;
import org.squashtest.tm.service.internal.repository.IssueDao;

@Configurable
public class IssueExecutionPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private IssueDao issueDao;
    @Inject
    private HateoasWrapperConverter<Execution> hateoasWrapperConverter;

    public IssueExecutionPropertyWriter() {
    }

    public IssueExecutionPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, IssueDao issueDao, HateoasWrapperConverter<Execution> hateoasWrapperConverter) {
        super(propDef, contextAnnotations, declaredType);
        this.issueDao = issueDao;
        this.hateoasWrapperConverter = hateoasWrapperConverter;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Issue issue = (Issue)bean;
        Execution execution = this.issueDao.findExecutionRelatedToIssue(issue.getId().longValue());
        return this.hateoasWrapperConverter.convert(execution);
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new IssueExecutionPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.issueDao, this.hateoasWrapperConverter);
    }
}

