/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.util.Comparator;
import java.util.List;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEvent;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEventType;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;

public class ExploratoryExecutionProgressStatusWriter
extends VirtualBeanPropertyWriter {
    public ExploratoryExecutionProgressStatusWriter() {
    }

    public ExploratoryExecutionProgressStatusWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        ExploratoryExecution exploratoryExecution = (ExploratoryExecution)bean;
        if (exploratoryExecution.getEvents().isEmpty()) {
            return ExploratoryExecutionRunningState.NEVER_STARTED;
        }
        List<ExploratoryExecutionEvent> events = exploratoryExecution.getEvents().stream().sorted(Comparator.comparing(ExploratoryExecutionEvent::getDate).reversed()).toList();
        return switch (events.get(0).getEventType()) {
            case ExploratoryExecutionEventType.STOP -> ExploratoryExecutionRunningState.STOPPED;
            case ExploratoryExecutionEventType.PAUSE -> ExploratoryExecutionRunningState.PAUSED;
            case ExploratoryExecutionEventType.START, ExploratoryExecutionEventType.RESUME -> ExploratoryExecutionRunningState.RUNNING;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType) {
        return new ExploratoryExecutionProgressStatusWriter(beanPropertyDefinition, annotatedClass.getAnnotations(), javaType);
    }
}

