/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.service.RestTestStepService;
import org.squashtest.tm.plugin.rest.service.RestVerifyingRequirementManagerService;
import org.squashtest.tm.plugin.rest.validators.TestStepPatchValidator;
import org.squashtest.tm.plugin.rest.validators.TestStepPostValidator;

@RestApiController(value=TestStep.class)
@UseDefaultRestApiConfiguration
public class RestTestStepController
extends BaseRestController {
    @Inject
    private RestTestStepService restTestStepService;
    @Inject
    private RestTestCaseService restTestCaseService;
    @Inject
    private TestStepPostValidator testStepPostValidator;
    @Inject
    private TestStepPatchValidator testStepPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestVerifyingRequirementManagerService restVerifyingRequirementManagerService;
    public static final String LINK_REQUIREMENTS = "link-requirements";
    public static final String UNLINK_REQUIREMENTS = "unlink-requirements";

    @GetMapping(value={"/test-steps/{id}"})
    @EntityGetter(value={ActionTestStep.class, CallTestStep.class, KeywordTestStep.class})
    @DynamicFilterExpression(value="*, test_case[name] ,called_test_case[name], called_dataset[name],verified_requirements[name]")
    public ResponseEntity<EntityModel<TestStep>> findTestStep(@PathVariable(value="id") long id) {
        TestStep step = this.restTestStepService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)step);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/test-cases/{testCaseId}/steps"})
    @ResponseBody
    @DynamicFilterExpression(value="*, test_case[name],verified_requirements[name],called_test_case[name], called_dataset[name]")
    public ResponseEntity<EntityModel<TestStep>> createTestStep(@RequestBody TestStepDto testStepDto, @PathVariable(value="testCaseId") long testCaseId) throws BindException, InvocationTargetException, IllegalAccessException {
        TestCase testCase = this.restTestCaseService.getOne(testCaseId);
        testStepDto.setProjectId(testCase.getProject().getId());
        this.validatePostTestStep(testStepDto);
        TestStep ats = this.restTestStepService.createTestStep(testStepDto, testCase);
        EntityModel res = this.toEntityModel((Identified)ats);
        this.linksHelper.populateLinks((EntityModel<TestStep>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/test-steps/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, test_case[name],verified_requirements[name],called_test_case[name], called_dataset[name]")
    public ResponseEntity<EntityModel<TestStep>> patchTestStep(@RequestBody TestStepDto patch, @PathVariable(value="id") long id) throws BindException {
        TestStep testStep = this.restTestStepService.getOne(id);
        patch.setId(id);
        patch.setProjectId(testStep.getTestCase().getProject().getId());
        this.validatePatchTestStep(patch);
        testStep = this.restTestStepService.patchTestStep(patch, id);
        EntityModel res = this.toEntityModel((Identified)testStep);
        this.linksHelper.populateLinks((EntityModel<TestStep>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/test-steps/{ids}"})
    public ResponseEntity<Void> deleteTestStep(@PathVariable(value="ids") List<Long> ids) {
        this.restTestStepService.deleteTestStepsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @PostMapping(value={"/test-steps/{id}/coverages/{requirementIds}"})
    @DynamicFilterExpression(value="*, test_case[name],verified_requirements[name],called_test_case[name], called_dataset[name]")
    public ResponseEntity<EntityModel<TestStep>> linkRequirements(@PathVariable(value="id") Long id, @PathVariable(value="requirementIds") List<Long> requirementIds) throws BindException {
        this.testStepPostValidator.validateRequirements(id, requirementIds, LINK_REQUIREMENTS);
        TestStep step = this.restTestStepService.getOne(id);
        this.restVerifyingRequirementManagerService.linkRequirementsToTestStep(requirementIds, id);
        EntityModel res = this.toEntityModel((Identified)step);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/test-steps/{id}/coverages/{requirementIds}"})
    public ResponseEntity<Void> unlinkRequirementFromTestCase(@PathVariable(value="id") Long id, @PathVariable(value="requirementIds") List<Long> requirementIds) throws BindException {
        this.testStepPostValidator.validateRequirements(id, requirementIds, UNLINK_REQUIREMENTS);
        this.restVerifyingRequirementManagerService.unlinkRequirementsFromTestStep(requirementIds, id);
        return ResponseEntity.noContent().build();
    }

    private void validatePatchTestStep(TestStepDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-test-step");
        this.testStepPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-test-step");
    }

    private void validatePostTestStep(TestStepDto testStepDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testStepDto, "post-test-step");
        this.testStepPostValidator.validate(testStepDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(testStepDto, errors, "post-test-step");
    }
}

