/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignTestPlanItemDto;
import org.squashtest.tm.plugin.rest.service.RestCampaignTestPlanItemService;
import org.squashtest.tm.plugin.rest.validators.CampaignTestPlanItemValidator;

@RestApiController(value=CampaignTestPlanItem.class)
@UseDefaultRestApiConfiguration
public class RestCampaignTestPlanItemController
extends BaseRestController {
    public static final String CTPI_DYNAMIC_FILTER = "*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference]";
    @Inject
    private RestCampaignTestPlanItemService service;
    @Inject
    private CampaignTestPlanItemValidator campaignTestPlanItemValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @GetMapping(value={"/campaign-test-plan-items/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference]")
    public ResponseEntity<EntityModel<CampaignTestPlanItem>> findCampaignTestPlanItem(@PathVariable(value="id") long id) {
        Dataset referencedDataset;
        CampaignTestPlanItem itpi = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)itpi);
        res.add(this.linkService.createLinkTo((Identified)itpi.getCampaign().getProject()));
        TestCase referencedTestCase = itpi.getReferencedTestCase();
        if (referencedTestCase != null) {
            res.add(this.linkService.createLinkTo((Identified)referencedTestCase));
        }
        if ((referencedDataset = itpi.getReferencedDataset()) != null) {
            res.add(this.linkService.createLinkTo((Identified)referencedDataset));
        }
        res.add(this.linkService.createLinkTo((Identified)itpi.getCampaign()));
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/campaign/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference]")
    public ResponseEntity<EntityModel<CampaignTestPlanItem>> addTestPlanItemToCampaign(@RequestBody CampaignTestPlanItemDto ctpiDto, @PathVariable(value="id") long campaignId) throws BindException {
        this.campaignTestPlanItemValidator.validatePostTestPlanItem(ctpiDto, campaignId);
        CampaignTestPlanItem ctpi = this.service.addTestCaseToCampaign(ctpiDto, campaignId);
        EntityModel res = this.toEntityModel((Identified)ctpi);
        this.linksHelper.addAllLinksForCampaignTestPlanItem((EntityModel<CampaignTestPlanItem>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/campaign-test-plan-items/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference]")
    public ResponseEntity<EntityModel<CampaignTestPlanItem>> modifyTestPlanItemToCampaign(@RequestBody CampaignTestPlanItemDto ctpiDto, @PathVariable(value="id") long testPlanId) throws BindException {
        this.campaignTestPlanItemValidator.validatePatchTestPlanItem(ctpiDto, testPlanId);
        CampaignTestPlanItem ctpi = this.service.modifyCampaignTestPlan(ctpiDto, testPlanId);
        EntityModel res = this.toEntityModel((Identified)ctpi);
        this.linksHelper.addAllLinksForCampaignTestPlanItem((EntityModel<CampaignTestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/campaign-test-plan-items/{testPlanItemsIds}"})
    public ResponseEntity<Void> removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds) {
        this.service.deleteCampaignTestPlan(testPlanItemsIds);
        return ResponseEntity.noContent().build();
    }
}

