/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.squashtest.tm.plugin.openid.connect.exception.SquashOidcAuthenticationException;
import org.squashtest.tm.plugin.openid.connect.properties.OidcAccessProperties;

public class SquashOidcGrantedAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    private static final String ACCESS_DENIED = "Access denied !";
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashOidcGrantedAuthoritiesMapper.class);
    @Autowired
    private OAuth2ClientProperties oAuth2ClientProperties;
    @Autowired(required=false)
    private OidcAccessProperties oidcAccessProperties;
    @Autowired
    private UserDetailsService userDetailsService;

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        HashSet mappedAuthorities = new HashSet();
        authorities.forEach(authority -> {
            if (authority instanceof OAuth2UserAuthority var3_4 && this.oAuth2ClientProperties != null && !this.oAuth2ClientProperties.getProvider().keySet().isEmpty()) {
                Map userAttributes = oauth2UserAuthority.getAttributes();
                OAuth2ClientProperties.Provider authProvider = this.getAuthProviderFromTokenAndProperties(userAttributes);
                if (!this.isUserWhitelisted((String)userAttributes.get("email"))) {
                    throw new SquashOidcAuthenticationException(ACCESS_DENIED, (Throwable)new AccessDeniedException("You are not authorized to access this application with this account. If this is an error, please contact your administrator."));
                }
                UserDetails springUser = this.findUserDetailsByLoginIfExists(authProvider, userAttributes);
                if (springUser != null) {
                    if (!springUser.isEnabled()) {
                        throw new SquashOidcAuthenticationException(ACCESS_DENIED, (Throwable)new AccessDeniedException("The authentication attempt has failed because the user account associated with this login request has been disabled. Please contact the system administrator for assistance or to reactivate your account."));
                    }
                    mappedAuthorities.addAll(springUser.getAuthorities());
                }
            }
        });
        return mappedAuthorities;
    }

    private boolean isUserWhitelisted(String userEmail) {
        String[] whitelist = this.oidcAccessProperties.getEmailDomainWhitelist();
        if (whitelist != null && whitelist.length > 0) {
            if (userEmail != null && !userEmail.isBlank()) {
                return Arrays.stream(whitelist).anyMatch(userEmail::contains);
            }
            throw new SquashOidcAuthenticationException(ACCESS_DENIED, (Throwable)new AccessDeniedException("Your permissions could not be verified since no email claim was received from the Identity Provider. If this is an error, please contact your administrator."));
        }
        return true;
    }

    private OAuth2ClientProperties.Provider getAuthProviderFromTokenAndProperties(Map<String, Object> userAttributes) {
        Map providerMap = this.oAuth2ClientProperties.getProvider();
        Map registrationMap = this.oAuth2ClientProperties.getRegistration();
        Map.Entry idpClientProperties = registrationMap.entrySet().stream().filter(registrationEntry -> {
            ArrayList audList = (ArrayList)userAttributes.get("aud");
            return ((OAuth2ClientProperties.Registration)registrationEntry.getValue()).getClientId().equals(audList.get(0));
        }).findFirst().orElseThrow();
        OAuth2ClientProperties.Provider provider = (OAuth2ClientProperties.Provider)providerMap.get(idpClientProperties.getKey());
        if (EnumUtils.isValidEnum(CommonOAuth2Provider.class, (String)((String)idpClientProperties.getKey()).toUpperCase())) {
            this.retrieveAdditionalProviderInformationForCommonOAuth2Providers(provider, idpClientProperties);
        }
        return provider;
    }

    private UserDetails findUserDetailsByLoginIfExists(OAuth2ClientProperties.Provider authProvider, Map<String, Object> userAttributes) {
        String usernameValue = (String)userAttributes.get(authProvider.getUserNameAttribute());
        if (usernameValue == null || usernameValue.isBlank()) {
            throw new SquashOidcAuthenticationException(ACCESS_DENIED, (Throwable)new AccessDeniedException("Your permissions could not be verified since no username claim was received from the Identity Provider. If this is an error, please contact your administrator."));
        }
        try {
            return this.userDetailsService.loadUserByUsername(usernameValue);
        }
        catch (UsernameNotFoundException e) {
            LOGGER.info(String.format("No user with the username %s was found. A new user will be created.", usernameValue), (Throwable)e);
            return null;
        }
    }

    private void retrieveAdditionalProviderInformationForCommonOAuth2Providers(OAuth2ClientProperties.Provider provider, Map.Entry<String, OAuth2ClientProperties.Registration> idpClientProperties) {
        CommonOAuth2Provider commonOAuth2Provider = CommonOAuth2Provider.valueOf((String)idpClientProperties.getKey().toUpperCase());
        ClientRegistration.Builder commonOAuth2ProviderBuilder = commonOAuth2Provider.getBuilder(idpClientProperties.getKey());
        commonOAuth2ProviderBuilder.clientId(idpClientProperties.getValue().getClientId());
        commonOAuth2ProviderBuilder.clientSecret(idpClientProperties.getValue().getClientSecret());
        if (provider.getAuthorizationUri() != null) {
            commonOAuth2ProviderBuilder.authorizationUri(provider.getAuthorizationUri());
        }
        if (provider.getTokenUri() != null) {
            commonOAuth2ProviderBuilder.tokenUri(provider.getTokenUri());
        }
        ClientRegistration commonOAuth2ProviderRegistration = commonOAuth2ProviderBuilder.build();
        if (provider.getIssuerUri() == null) {
            provider.setIssuerUri(commonOAuth2ProviderRegistration.getProviderDetails().getIssuerUri());
        }
    }
}

