/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils.RestTemplateAbstractFactory;

@Component
@ConditionalOnProperty(prefix="plugin.bugtracker.tuleap", name={"deactivate-ssl-domain-name-check"}, havingValue="false", matchIfMissing=true)
public class RestTemplateDefaultFactory
extends RestTemplateAbstractFactory {
    @Override
    protected void initSpringRequestFactory() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableCookieManagement();
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            httpClientBuilder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
        }
        proxyHost = System.getProperty("https.proxyHost");
        proxyPort = System.getProperty("https.proxyPort");
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            httpClientBuilder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        this.springRequestFactory = () -> new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }
}

