/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.command.DelegateCommands;

@Component
public class BugzillaWidgetMapping {
    private final ThreadLocal<String> projectKeyHolder = new ThreadLocal();
    private static final Map<String, String> WIDGET_MAP = new HashMap<String, String>();
    private static final Map<String, Map<String, String>> ADDITIONAL_PARAMS = new HashMap<String, Map<String, String>>();

    static {
        WIDGET_MAP.put("BUG_ID", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("DATE_PICKER", InputType.TypeName.DATE_PICKER.value);
        WIDGET_MAP.put("DATE_TIME", InputType.TypeName.DATE_TIME.value);
        WIDGET_MAP.put("DROP_DOWN", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("FREE_TEXT", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("LARGE_TEXT_BOX", InputType.TypeName.TEXT_AREA.value);
        WIDGET_MAP.put("MULTIPLE_SELECTION_BOX", InputType.TypeName.MULTI_SELECT.value);
        WIDGET_MAP.put("INTEGER", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("attachment", InputType.TypeName.FILE_UPLOAD.value);
        WIDGET_MAP.put("users", InputType.TypeName.TEXT_FIELD.value);
        HashMap datepickerformat = new HashMap(1);
        ADDITIONAL_PARAMS.put(InputType.TypeName.DATE_PICKER.value, datepickerformat);
    }

    public ThreadLocal<String> getProjectKeyHolder() {
        return this.projectKeyHolder;
    }

    public String getCorrespondingSquashWidget(String redmineName) {
        String widgetName = WIDGET_MAP.get(redmineName);
        return widgetName != null ? widgetName : InputType.TypeName.UNKNOWN.value;
    }

    public Map<String, String> getAdditionalParams(InputType inputType) {
        HashMap<String, String> finalParams = new HashMap<String, String>();
        Map<String, String> params = ADDITIONAL_PARAMS.get(inputType.getName());
        if (params != null) {
            finalParams.putAll(params);
        }
        if ((params = ADDITIONAL_PARAMS.get(inputType.getOriginal())) != null) {
            finalParams.putAll(params);
        }
        if ((params = this.getSpecialParams(inputType.getOriginal())) != null) {
            finalParams.putAll(params);
        }
        return finalParams;
    }

    private Map<String, String> getSpecialParams(String name) {
        HashMap<String, String> toReturn = null;
        String projectKey = this.projectKeyHolder.get();
        if ("users".equals(name)) {
            toReturn = new HashMap<String, String>(1);
            DelegateCommand searchCommand = DelegateCommands.buildSearchAssignableCommand(projectKey);
            toReturn.put(CommonConfigurationKey.ONCHANGE.value, searchCommand.getCommand());
        }
        return toReturn;
    }
}

