/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RequirementVersionLinkTypeDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;

@Component
public class RequirementVersionLinkTypeValidator
implements Validator {
    private static final String POST_LINK_TYPE = "post-link_type";
    private static final String PATCH_LINK_TYPE = "patch-link_type";
    @Inject
    private RequirementVersionLinkTypeDao linkTypeDao;
    @Inject
    private HelpValidator helpValidator;

    public boolean supports(Class<?> aClass) {
        return RequirementVersionLinkTypeDto.class.equals(aClass);
    }

    public void validate(Object o, Errors errors) {
        RequirementVersionLinkType linkTypeCode2;
        RequirementVersionLinkTypeDto linkTypeDto = (RequirementVersionLinkTypeDto)o;
        this.helpValidator.validateAttributes("role1", errors);
        this.helpValidator.validateAttributes("role2", errors);
        this.helpValidator.validateAttributes("role1Code", errors);
        this.helpValidator.validateAttributes("role2Code", errors);
        RequirementVersionLinkType linkTypeCode1 = this.linkTypeDao.findByRoleCode(linkTypeDto.getRole1Code());
        if (linkTypeCode1 != null) {
            errors.rejectValue("role1Code", "invalid value", "A link type with the same role code already exists in the database");
        }
        if ((linkTypeCode2 = this.linkTypeDao.findByRoleCode(linkTypeDto.getRole2Code())) != null) {
            errors.rejectValue("role2Code", "invalid value", "A link type with the same role code already exists in the database");
        }
    }

    public void linkTypePostValidator(RequirementVersionLinkTypeDto linkTypeDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)linkTypeDto, POST_LINK_TYPE);
        if (linkTypeDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing dataset, please do a patch request to the dataset id. ");
        }
        this.validate(linkTypeDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)linkTypeDto, errors, (String)POST_LINK_TYPE);
    }

    public void linkTypePatchValidator(Long linkTypeId, RequirementVersionLinkTypeDto linkTypeDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)linkTypeDto, PATCH_LINK_TYPE);
        if (this.linkTypeDao.getReferenceById((Object)linkTypeId) == null) {
            String message = String.format("No entity known for type Requirement version link type and id %d", linkTypeId);
            validation.rejectValue("id", "invalid id", message);
        }
        this.validate(linkTypeDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)linkTypeDto, errors, (String)PATCH_LINK_TYPE);
    }
}

