/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmRepositoryDto;
import org.squashtest.tm.plugin.rest.admin.service.RestScmRepositoryService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.ScmRepositoryPatcher;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.service.internal.repository.ScmRepositoryDao;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;

@Service
@Transactional
public class RestScmRepositoryServiceImpl
implements RestScmRepositoryService {
    @Inject
    private ScmRepositoryDao scmRepositoryDao;
    @Inject
    private ScmRepositoryManagerService scmRepositoryManagerService;
    @Inject
    private ScmRepositoryPatcher scmRepositoryPatcher;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<ScmRepository> getAllScmRepositoryForScmServer(Long id, Pageable pageable) {
        return this.scmRepositoryDao.findByScmServerId(id, pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmRepository findScmRepositoryById(Long repoId) {
        return (ScmRepository)this.scmRepositoryDao.findById((Object)repoId).orElseThrow(() -> ExceptionUtils.entityNotFoundException(ScmRepository.class, (Long)repoId));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmRepository addScmRepository(Long serverId, ScmRepositoryDto scmRepositoryDto) throws IOException {
        ScmRepository newScmRepository = new ScmRepository();
        this.scmRepositoryPatcher.patch(newScmRepository, scmRepositoryDto);
        boolean cloneRepository = scmRepositoryDto.getParams().isCloneRepository();
        try {
            return this.scmRepositoryManagerService.createNewScmRepository(serverId.longValue(), newScmRepository.getName(), newScmRepository.getWorkingBranch(), newScmRepository.getWorkingFolderPath(), cloneRepository);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmRepository updateBranch(Long repoId, String newBranch) throws IOException {
        ScmRepository repo = this.findScmRepositoryById(repoId);
        if (repo != null) {
            this.scmRepositoryManagerService.updateBranch(repoId.longValue(), newBranch);
        }
        return repo;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteRepository(List<Long> scmRepositoriesIds) {
        this.scmRepositoryManagerService.deleteScmRepositories(scmRepositoriesIds);
    }
}

