/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RequirementVersionLinkTypeDto;
import org.squashtest.tm.plugin.rest.admin.service.RestLinkTypeService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.RequirementVersionLinkTypePatcher;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.requirement.RequirementVersionLinkTypeManagerService;

@Service
@Transactional
public class RestLinkTypeServiceImpl
implements RestLinkTypeService {
    @Inject
    private RequirementVersionLinkTypeDao requirementVersionLinkTypeDao;
    @Inject
    private RequirementVersionLinkTypePatcher linkTypePatcher;
    @Inject
    private RequirementVersionLinkTypeManagerService linkTypeManagerService;
    @Inject
    private RequirementVersionLinkTypeDao linkTypeDao;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public RequirementVersionLinkType findLinkTypeByCodeRole(String codeRole) {
        return this.requirementVersionLinkTypeDao.findByRoleCode(codeRole);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public RequirementVersionLinkType findLinkTypeById(Long linkTypeId) {
        return (RequirementVersionLinkType)this.requirementVersionLinkTypeDao.getReferenceById((Object)linkTypeId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public RequirementVersionLinkType addLinkType(RequirementVersionLinkTypeDto linkTypeDto) {
        RequirementVersionLinkType linkType = new RequirementVersionLinkType();
        this.linkTypePatcher.patch(linkType, linkTypeDto);
        this.linkTypeManagerService.addLinkType(linkType);
        return this.linkTypeDao.findByRoleCode(linkType.getRole1Code());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public RequirementVersionLinkType updateLinkType(Long linkTypeId, RequirementVersionLinkTypeDto linkTypeDto) {
        RequirementVersionLinkType linkType = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById((Object)linkTypeId);
        this.linkTypePatcher.patch(linkType, linkTypeDto);
        return linkType;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<RequirementVersionLinkType> findAllLinkTypes(Pageable pageable) {
        return this.requirementVersionLinkTypeDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteLinkType(List<Long> linkTypeIds) {
        this.linkTypeManagerService.deleteLinkTypes(linkTypeIds);
    }
}

