/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.controller.RestScmRepositoryController;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmRepositoryDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestScmRepositoryService;
import org.squashtest.tm.plugin.rest.admin.service.RestScmServerService;
import org.squashtest.tm.plugin.rest.admin.validators.CredentialsValidator;
import org.squashtest.tm.plugin.rest.admin.validators.ScmRepositoryValidator;
import org.squashtest.tm.plugin.rest.admin.validators.ScmServerValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestScmServerController
extends RestAdminBaseController {
    @Inject
    private RestScmServerService scmServerService;
    @Inject
    private ThirdPartyServerCredentialsService serverCredentialsService;
    @Inject
    private RestScmRepositoryService scmRepositoryService;
    @Inject
    private ScmServerValidator scmServerValidator;
    @Inject
    private ScmRepositoryValidator scmRepositoryValidator;
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    private CredentialsValidator credentialsValidator;
    private ScmServerResourceAssembler scmResourceAssembler = new ScmServerResourceAssembler();
    private ScmRepositoryResourceAssembler scmRepoResourceAssembler = new ScmRepositoryResourceAssembler();

    @GetMapping(value={"/scm-servers"})
    @ResponseBody
    @DynamicFilterExpression(value="*, scm-repository[_type, id, name, repository_path, working_folder_path, working_branch]")
    public ResponseEntity<PagedModel<EntityModel<ScmServer>>> findAllScmServer(Pageable pageable) {
        Page<ScmServer> page = this.scmServerService.getAllScmServer(pageable);
        PagedModel res = this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.scmResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/scm-servers/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression
    public ResponseEntity findScmServerById(@PathVariable(value="id") Long scmServerId) throws NoSuchMethodException {
        ScmServer server = this.scmServerService.findScmServerById(scmServerId);
        EntityModel<ScmServer> res = this.customResource(server);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/scm-servers"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EntityModel<ScmServer>> addScmServer(@RequestBody ScmServerDto scmServerDto) throws BindException {
        this.scmServerValidator.scmServerPostValidator(scmServerDto);
        ScmServer scmServer = this.scmServerService.addScmServer(scmServerDto);
        EntityModel res = this.customResource(scmServer, scmServer.getId());
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/scm-servers/{id}"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<ScmServer>> patchScmServer(@PathVariable(value="id") Long scmServerId, @RequestBody ScmServerDto scmServerDto) throws BindException {
        this.scmServerValidator.scmServerPatchValidator(scmServerId, scmServerDto);
        ScmServer scmServer = this.scmServerService.updateScmServer(scmServerId, scmServerDto);
        EntityModel<ScmServer> res = this.customResource(scmServer);
        return ResponseEntity.ok(res);
    }

    @ResponseBody
    @DeleteMapping(value={"/scm-servers/{ids}"})
    public ResponseEntity<Void> removeScmServer(@PathVariable(value="ids") List<Long> scmServerIds) {
        this.scmServerService.deleteScmServer(scmServerIds);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/scm-servers/{id}/scm-repositories"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -scm-server")
    public ResponseEntity<PagedModel<EntityModel<ScmRepository>>> findAllScmRepositoryForScmServer(@PathVariable(value="id") Long scmServerId, Pageable pageable) {
        Page<ScmRepository> page = this.scmRepositoryService.getAllScmRepositoryForScmServer(scmServerId, pageable);
        PagedModel res = this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.scmRepoResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/scm-servers/{id}/scm-repositories"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @DynamicFilterExpression(value="*,scm_server[*]")
    public ResponseEntity<EntityModel<ScmRepository>> addScmRepository(@PathVariable(value="id") Long serverId, @RequestBody ScmRepositoryDto scmRepositoryDto) throws BindException, IOException {
        this.scmRepositoryValidator.scmRepositoryPostValidator(serverId, scmRepositoryDto);
        ScmRepository scmRepository = this.scmRepositoryService.addScmRepository(serverId, scmRepositoryDto);
        EntityModel<ScmRepository> res = this.customResource(scmRepository);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @GetMapping(value={"/scm-servers/{id}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> getCredential(@PathVariable(value="id") Long scmServerId) {
        ManageableCredentials cred = this.serverCredentialsService.findCredentials(scmServerId.longValue());
        if (Objects.isNull(cred)) {
            return ResponseEntity.noContent().build();
        }
        EntityModel<ManageableCredentials> res = this.customResource(cred);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/scm-servers/{id}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> setCredentials(@PathVariable(value="id") Long scmServerId, @RequestBody ManageableCredentialsDto credentialsDto) throws BindException {
        this.credentialsValidator.validatePostCredentialsForScmServer(scmServerId, credentialsDto);
        ManageableCredentials credentials = credentialsDto.convertDto();
        this.serverCredentialsService.storeCredentials(scmServerId.longValue(), credentials);
        EntityModel<ManageableCredentials> res = this.customToResourceForCredential(scmServerId, credentials);
        return ResponseEntity.ok(res);
    }

    private EntityModel<ManageableCredentials> customToResourceForCredential(long scmServerId, ManageableCredentials credentials) {
        EntityModel res = EntityModel.of((Object)credentials);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestScmServerController)WebMvcLinkBuilder.methodOn(RestScmServerController.class, (Object[])new Object[0])).getCredential(scmServerId)));
        res.add(builder.withSelfRel());
        return res;
    }

    private class ScmRepositoryResourceAssembler
    implements RepresentationModelAssembler<ScmRepository, EntityModel<ScmRepository>> {
        private ScmRepositoryResourceAssembler() {
        }

        public EntityModel<ScmRepository> toModel(ScmRepository entity) {
            EntityModel res = EntityModel.of((Object)entity);
            LinkBuilder builder = RestScmServerController.this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestScmRepositoryController)WebMvcLinkBuilder.methodOn(RestScmRepositoryController.class, (Object[])new Object[0])).findScmRepositoryById(entity.getId())));
            res.add(Link.of((String)builder.toString(), (String)"self"));
            return res;
        }
    }

    private class ScmServerResourceAssembler
    implements RepresentationModelAssembler<ScmServer, EntityModel<ScmServer>> {
        private ScmServerResourceAssembler() {
        }

        public EntityModel<ScmServer> toModel(ScmServer entity) {
            EntityModel res = EntityModel.of((Object)entity);
            try {
                LinkBuilder builder = RestScmServerController.this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestScmServerController)WebMvcLinkBuilder.methodOn(RestScmServerController.class, (Object[])new Object[0])).findScmServerById(entity.getId())));
                res.add(Link.of((String)builder.toString(), (String)"self"));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return res;
        }
    }
}

