/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.plugin.rest.admin.jackson.model.CustomFieldDto;
import org.squashtest.tm.plugin.rest.admin.service.RestCustomFieldService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestCustomFieldController
extends BaseRestController {
    @Autowired(required=true)
    private CustomFieldManagerService cufManagerService;
    @Autowired(required=true)
    private RestCustomFieldService cufService;
    private CustomFieldResourceAssembler cufRessourceAssembler = new CustomFieldResourceAssembler();

    @GetMapping(value={"/custom-fields"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<CustomFieldDto>>> findAllCustomField(Pageable pageable) {
        Page<CustomField> pageCustoField = this.cufService.findSortedCustomFields(pageable);
        Page<CustomFieldDto> pageCustomFieldDto = this.pageCustomFieldToPageCustomFieldDto(pageCustoField);
        PagedModel res = this.pageAssembler.toModel(pageCustomFieldDto, (RepresentationModelAssembler)this.cufRessourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/custom-fields/{id}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> findOneCustomFieldById(@PathVariable(value="id") long cufId) {
        CustomField cuf = this.cufService.findById(cufId);
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/custom-fields"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> createCustomField(@RequestBody CustomFieldDto cufDto) {
        CustomField cuf = this.customFieldDtoToCustomField(cufDto);
        CustomField newCuf = this.cufService.addCustomField(cuf);
        EntityModel<CustomFieldDto> res = this.customToResource(newCuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(newCuf.getId())));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/custom-fields/{id}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> updateCustomField(@PathVariable(value="id") long cufId, @RequestBody CustomFieldDto cufDto) {
        this.cufService.updateCustomField(cufId, cufDto);
        CustomField cuf = this.cufManagerService.findById(Long.valueOf(cufId));
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(cufId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/custom-fields/{ids}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<String> deleteCustomFieldById(@PathVariable(value="ids") List<Long> cufIds) {
        this.cufManagerService.deleteCustomField(cufIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/custom-fields/{id}/options"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> addCustomFieldOption(@PathVariable(value="id") long cufId, @RequestBody CustomFieldOption cufOption) {
        this.cufManagerService.addOption(Long.valueOf(cufId), cufOption);
        CustomField cuf = this.cufManagerService.findById(Long.valueOf(cufId));
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(cufId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/custom-fields/{id}/options/{optionLabel}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> updateCustomFieldOption(@PathVariable(value="id") long cufId, @PathVariable(value="optionLabel") String optionLabel, @RequestBody CustomFieldOption cufOption) {
        this.cufService.updateCustomFieldOption(cufId, optionLabel, cufOption);
        CustomField cuf = this.cufManagerService.findById(Long.valueOf(cufId));
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(cufId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @PatchMapping(value={"/custom-fields/{id}/options/{optionLabel}/code/{newValue}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> updateCustomFieldOptionCode(@PathVariable(value="id") long cufId, @PathVariable(value="optionLabel") String optionLabel, @PathVariable(value="newValue") String newValue) {
        this.cufManagerService.changeOptionCode(cufId, optionLabel, newValue);
        CustomField cuf = this.cufManagerService.findById(Long.valueOf(cufId));
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(cufId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @PatchMapping(value={"/custom-fields/{id}/options/{optionLabel}/label/{newValue}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> updateCustomFieldOptionLabel(@PathVariable(value="id") long cufId, @PathVariable(value="optionLabel") String optionLabel, @PathVariable(value="newValue") String newValue) {
        this.cufManagerService.changeOptionLabel(Long.valueOf(cufId), optionLabel, newValue);
        CustomField cuf = this.cufManagerService.findById(Long.valueOf(cufId));
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(cufId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @PatchMapping(value={"/custom-fields/{id}/options/{optionLabel}/color/{newValue}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<CustomFieldDto>> updateCustomFieldOptionColor(@PathVariable(value="id") long cufId, @PathVariable(value="optionLabel") String optionLabel, @PathVariable(value="newValue") String newValue) {
        newValue = "#" + newValue;
        this.cufManagerService.changeOptionColour(cufId, optionLabel, newValue);
        CustomField cuf = this.cufManagerService.findById(Long.valueOf(cufId));
        EntityModel<CustomFieldDto> res = this.customToResource(cuf);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(cufId)));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/custom-fields/{id}/options/{optionLabel}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteCustomFieldOption(@PathVariable(value="id") long cufId, @PathVariable(value="optionLabel") String optionLabel) {
        this.cufManagerService.removeOption(cufId, optionLabel);
        return ResponseEntity.noContent().build();
    }

    private CustomField customFieldDtoToCustomField(CustomFieldDto cufDto) {
        CustomField cuf = new CustomField(cufDto.getInputType());
        cuf = switch (cuf.getInputType()) {
            case InputType.DROPDOWN_LIST -> this.createSingleSelectField(cufDto.getOptions());
            case InputType.RICH_TEXT -> this.createRichTextField();
            case InputType.TAG -> this.createTag();
            case InputType.NUMERIC -> this.createNumeric();
            default -> cuf;
        };
        cuf.setName(cufDto.getName());
        cuf.setLabel(cufDto.getLabel());
        cuf.setCode(cufDto.getCode());
        cuf.setDefaultValue(cufDto.getDefaultValue());
        cuf.setOptional(cufDto.isOptional());
        return cuf;
    }

    private CustomField createNumeric() {
        return new NumericField();
    }

    private CustomField createSingleSelectField(List<CustomFieldOption> options) {
        SingleSelectField ssf = new SingleSelectField();
        for (CustomFieldOption option : options) {
            ssf.addOption(option);
        }
        SingleSelectField res = ssf;
        return res;
    }

    private CustomField createRichTextField() {
        return new RichTextField();
    }

    private CustomField createTag() {
        return new MultiSelectField();
    }

    private CustomFieldDto customFieldToCustomFieldDto(CustomField cuf) {
        CustomFieldDto cufDto = new CustomFieldDto();
        ArrayList<CustomFieldOption> options = new ArrayList();
        if (cuf.getInputType() == InputType.DROPDOWN_LIST) {
            SingleSelectField singleSelectField = this.cufManagerService.findSingleSelectFieldById(cuf.getId());
            options = singleSelectField.getOptions();
        }
        cufDto.setId(cuf.getId());
        cufDto.setName(cuf.getName());
        cufDto.setLabel(cuf.getLabel());
        cufDto.setCode(cuf.getCode());
        cufDto.setDefaultValue(cuf.getDefaultValue());
        cufDto.setInputType(cuf.getInputType());
        cufDto.setOptional(cuf.isOptional());
        cufDto.setOptions(options);
        return cufDto;
    }

    private Page<CustomFieldDto> pageCustomFieldToPageCustomFieldDto(Page<CustomField> pageCuf) {
        return pageCuf.map(this::customFieldToCustomFieldDto);
    }

    private EntityModel<CustomFieldDto> customToResource(CustomField customField) {
        CustomFieldDto cufDto = this.customFieldToCustomFieldDto(customField);
        return EntityModel.of((Object)cufDto);
    }

    private class CustomFieldResourceAssembler
    implements RepresentationModelAssembler<CustomFieldDto, EntityModel<CustomFieldDto>> {
        private CustomFieldResourceAssembler() {
        }

        public EntityModel<CustomFieldDto> toModel(CustomFieldDto entity) {
            EntityModel res = EntityModel.of((Object)entity);
            LinkBuilder builder = RestCustomFieldController.this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestCustomFieldController)((Object)WebMvcLinkBuilder.methodOn(RestCustomFieldController.class, (Object[])new Object[0]))).findOneCustomFieldById(entity.getId())));
            res.add(Link.of((String)builder.toString(), (String)"self"));
            return res;
        }
    }
}

