/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import javax.inject.Inject;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ImportSizeLimitDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.SquashCallbackUrlDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.UploadExtentionWhitelistDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.UploadSizeLimitDto;
import org.squashtest.tm.plugin.rest.core.web.IRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.system.SystemAdministrationService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestConfigSystemController
implements IRestController {
    @Inject
    FeatureManager featureManager;
    @Inject
    SystemAdministrationService systemAdministrationService;

    @GetMapping(value={"/configuration/upload-extention-whitelist"})
    public ResponseEntity<UploadExtentionWhitelistDto> getUploadExtentionWhitelist() {
        String whiteList = this.systemAdministrationService.findWhiteList();
        UploadExtentionWhitelistDto whiteListDto = new UploadExtentionWhitelistDto(whiteList);
        return ResponseEntity.ok((Object)whiteListDto);
    }

    @PostMapping(value={"/configuration/upload-extention-whitelist"})
    public ResponseEntity<UploadExtentionWhitelistDto> setUploadExtentionWhitelist(@RequestBody UploadExtentionWhitelistDto whiteList) {
        this.systemAdministrationService.changeWhiteList(whiteList.getWhitelist());
        return ResponseEntity.ok((Object)whiteList);
    }

    @GetMapping(value={"/configuration/upload-size-limit"})
    public ResponseEntity<UploadSizeLimitDto> getUploadSizeLimit() {
        String uploadSizeLimit = this.systemAdministrationService.findUploadSizeLimit();
        UploadSizeLimitDto sizeLimit = new UploadSizeLimitDto(uploadSizeLimit);
        return ResponseEntity.ok((Object)sizeLimit);
    }

    @PostMapping(value={"/configuration/upload-size-limit"})
    public ResponseEntity<UploadSizeLimitDto> setUploadSizeLimit(@RequestBody UploadSizeLimitDto uploadSizeLimit) {
        this.systemAdministrationService.changeUploadSizeLimit(uploadSizeLimit.getSize());
        return ResponseEntity.ok((Object)uploadSizeLimit);
    }

    @GetMapping(value={"/configuration/import-size-limit"})
    public ResponseEntity<ImportSizeLimitDto> getImportSizeLimit() {
        String importSizeLimit = this.systemAdministrationService.findImportSizeLimit();
        ImportSizeLimitDto sizeLimit = new ImportSizeLimitDto(importSizeLimit);
        return ResponseEntity.ok((Object)sizeLimit);
    }

    @PostMapping(value={"/configuration/import-size-limit"})
    public ResponseEntity<ImportSizeLimitDto> setImportSizeLimit(@RequestBody ImportSizeLimitDto importSizeLimit) {
        this.systemAdministrationService.changeImportSizeLimit(importSizeLimit.getSize());
        return ResponseEntity.ok((Object)importSizeLimit);
    }

    @GetMapping(value={"/configuration/squash-callback-url"})
    public ResponseEntity<SquashCallbackUrlDto> getSquashCallBackUrl() {
        String callBackUrl = this.systemAdministrationService.findCallbackUrl();
        SquashCallbackUrlDto callBackUrlDto = new SquashCallbackUrlDto(callBackUrl);
        return ResponseEntity.ok((Object)callBackUrlDto);
    }

    @PostMapping(value={"/configuration/squash-callback-url"})
    public ResponseEntity<SquashCallbackUrlDto> setSquashCallBackUrl(@RequestBody SquashCallbackUrlDto callBackUrl) {
        this.systemAdministrationService.changeCallbackUrl(callBackUrl.getUrl());
        return ResponseEntity.ok((Object)callBackUrl);
    }

    @GetMapping(value={"/configuration/case-insensitive-login"})
    @Secured(value={"ROLE_ADMIN"})
    public ResponseEntity<String> getCaseInsensitiveLogin() {
        boolean isEnabled = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN);
        return ResponseEntity.ok((Object)"case insentive login: %s".formatted(isEnabled));
    }

    @PostMapping(value={"/configuration/case-insensitive-login"})
    public ResponseEntity<String> setCaseInsensitiveLogin(@RequestParam(name="enabled", defaultValue="true") String enabled) {
        boolean isEnabled = Boolean.parseBoolean(enabled);
        this.featureManager.setEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN, isEnabled);
        return ResponseEntity.ok((Object)"case insentive login: %s".formatted(isEnabled));
    }

    @GetMapping(value={"/configuration/case-insensitive-action-word"})
    @Secured(value={"ROLE_ADMIN"})
    public ResponseEntity<String> getCaseInsensitiveActionWord() {
        boolean isEnabled = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS);
        return ResponseEntity.ok((Object)"case insentive action word: %s".formatted(isEnabled));
    }
}

