/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;
import org.squashtest.tm.plugin.rest.core.web.IRestController;

public abstract class RestAdminBaseController
implements IRestController {
    @Inject
    protected PagedResourcesAssembler pageAssembler;
    @Inject
    private BasicResourceAssembler resAssembler;

    protected RestAdminBaseController() {
    }

    protected <ENTITY> EntityModel<ENTITY> customResource(ENTITY object) {
        EntityModel res = EntityModel.of(object);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return res;
    }

    protected <ENTITY> EntityModel<ENTITY> customResource(Object object, Long id) {
        EntityModel res = EntityModel.of((Object)object);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        builder.path("/" + id);
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return res;
    }

    protected <ENTITY> PagedModel<ENTITY> customPagedResources(Map<Long, Object> map) {
        ArrayList resources = new ArrayList();
        map.forEach((k, v) -> resources.add(this.customResource(v, (Long)k)));
        PagedModel.PageMetadata metadata = new PagedModel.PageMetadata((long)resources.size(), 0L, (long)resources.size());
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        return PagedModel.of(resources, (PagedModel.PageMetadata)metadata, (Link[])new Link[]{Link.of((String)builder.toUriString(), (String)"self")});
    }

    protected <ENTITY extends Identified> EntityModel<ENTITY> toEntityModel(ENTITY object) {
        return this.resAssembler.toModel(object);
    }

    protected <T> PagedModel<EntityModel<T>> toPagedModel(Page<T> page) {
        return this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.resAssembler);
    }

    protected <T> SingleRelPagedResources<EntityModel<T>> toPagedResourcesWithRel(Page<T> page, String rel) {
        PagedModel res = this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.resAssembler);
        return new SingleRelPagedResources(res, rel);
    }
}

