/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap.licensevalidator;

import java.util.Date;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.License;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.exceptions.LicenseSecurityException;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.dto.LicenseInfo;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.dto.LicenseType;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.service.ValidationService;
import org.squashtest.tm.service.license.LicenseInfoExtender;
import org.squashtest.tm.service.system.BasicLicenseInfo;

public class LicenseValidator
implements LicenseInfoExtender {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseValidator.class);
    private static final String LICENSE_LOCATION = "/license/squash-tm.lic";
    private String pluginToCheck;
    @Value(value="${squash.path.plugins-path}")
    private String pluginsPath;
    private ValidationService validationService;
    @Inject
    private Environment environment;
    private License licenseToCheck;

    @Inject
    public LicenseValidator(ValidationService service) {
        this.validationService = service;
    }

    public void validate(String plugin) {
        this.pluginToCheck = plugin;
        if (this.licenseToCheck == null) {
            this.retrieveLicense();
        }
        this.doLicenseValidation();
    }

    @Scheduled(cron="0 0 3 * * ?")
    public void periodicLicenseCheck() {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        if (isLogUsed.booleanValue()) {
            LOGGER.debug("Running periodic license check, {}", (Object)this.pluginToCheck);
        }
        this.doLicenseValidation();
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseToCheck != null ? this.validationService.getLicenseInfo(this.licenseToCheck) : null;
    }

    private void doLicenseValidation() {
        if (this.licenseToCheck != null) {
            try {
                this.validationService.validateLicenseForPlugin(this.licenseToCheck, this.pluginToCheck);
                this.validationService.checkTotalActivatedUsers(this.licenseToCheck);
            }
            catch (LicenseSecurityException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.validationService.shutDownApp();
            }
        } else {
            LOGGER.warn("You do not have any license on your Squash instance. Shut down initialized.");
            this.validationService.shutDownApp();
        }
    }

    private void retrieveLicense() {
        String licenseFromFile = this.validationService.readLicenseFile(String.valueOf(this.pluginsPath) + LICENSE_LOCATION);
        if (licenseFromFile != null) {
            this.licenseToCheck = this.validationService.validateLicense(licenseFromFile);
        }
    }

    public BasicLicenseInfo getBasicLicenseInfo() {
        if (this.licenseToCheck != null) {
            LicenseInfo licenseInfo = this.validationService.getLicenseInfo(this.licenseToCheck);
            Date expirationDate = licenseInfo.getExpirationDate();
            int maxUsers = licenseInfo.getMaxUsers();
            return new BasicLicenseInfo(expirationDate, maxUsers);
        }
        return null;
    }

    public boolean isValidLicense() {
        return this.licenseToCheck != null && this.validationService.isValidLicense(this.licenseToCheck);
    }

    public boolean isPluginEnabled(String key) {
        return this.licenseToCheck != null && this.validationService.isPluginEnabled(this.licenseToCheck, key);
    }

    public String getLicenseType() {
        return this.licenseToCheck != null ? this.validationService.getLicenseType(this.licenseToCheck) : null;
    }

    public boolean isLicenseTypeUltimate() {
        return LicenseType.ULTIMATE.name().equals(this.getLicenseType());
    }
}

