/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap;

import javax.inject.Inject;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.api.security.authentication.FeaturesAwareAuthentication;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.security.ad.ldap.AbstractActiveDirectoryLdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryLdapAuthenticationProvider;
import org.squashtest.tm.service.user.UserManagerService;

public class SquashActiveDirectoryLdapAuthenticationProvider
extends ActiveDirectoryLdapAuthenticationProvider {
    @Inject
    private AbstractActiveDirectoryLdapAuthenticationProviderFeatures features;
    private UserManagerService userFinder;

    public SquashActiveDirectoryLdapAuthenticationProvider(String domain, String url) {
        super(domain, url);
    }

    public AbstractActiveDirectoryLdapAuthenticationProviderFeatures getFeatures() {
        return this.features;
    }

    public void setFeatures(AbstractActiveDirectoryLdapAuthenticationProviderFeatures features) {
        this.features = features;
    }

    public void setUserFinder(UserManagerService userFinder) {
        this.userFinder = userFinder;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LdapUserDetails userDetails;
        User squashUser;
        Authentication auth = super.authenticate(authentication);
        if (auth.isAuthenticated() && (squashUser = this.userFinder.findByLogin((userDetails = (LdapUserDetails)auth.getPrincipal()).getUsername())) != null && !squashUser.getActive().booleanValue()) {
            throw new BadCredentialsException("User is not active");
        }
        return new FeatureAwareActiveDirectoryLdapAuthenticationToken((UsernamePasswordAuthenticationToken)auth, this.features);
    }

    public static final class FeatureAwareActiveDirectoryLdapAuthenticationToken
    extends UsernamePasswordAuthenticationToken
    implements FeaturesAwareAuthentication {
        private static final long serialVersionUID = 1L;
        private AuthenticationProviderFeatures features;

        public FeatureAwareActiveDirectoryLdapAuthenticationToken(UsernamePasswordAuthenticationToken token, AuthenticationProviderFeatures features) {
            super(token.getPrincipal(), token.getCredentials(), token.getAuthorities());
            this.features = features;
        }

        public AuthenticationProviderFeatures getFeatures() {
            return this.features;
        }
    }
}

