/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class DefaultActiveDirectoryLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActiveDirectoryLdapAuthoritiesPopulator.class);

    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        String[] groups = userData.getStringAttributes("memberOf");
        if (groups == null) {
            LOGGER.debug("No values for 'memberOf' attribute.");
            return AuthorityUtils.NO_AUTHORITIES;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("'memberOf' attribute values: " + Arrays.asList(groups));
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(groups.length);
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            authorities.add(new SimpleGrantedAuthority(new DistinguishedName(group).removeLast().getValue()));
            ++n2;
        }
        return authorities;
    }
}

