/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.conversion;

import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.DelegateCommands;

class WidgetMapping {
    public static final String GH_EPIC_LINK = "com.pyxis.greenhopper.jira:gh-epic-link";
    private static final Map<String, String> WIDGET_MAP = new HashMap<String, String>();
    private static final Map<String, Map<String, String>> ADDITIONAL_PARAMS = new HashMap<String, Map<String, String>>();
    private ThreadLocal<String> projectKeyHolder = new ThreadLocal();

    static {
        WIDGET_MAP.put("issuetype", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("duedate", InputType.TypeName.DATE_PICKER.value);
        WIDGET_MAP.put("priority", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("project", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("attachment", InputType.TypeName.FILE_UPLOAD.value);
        WIDGET_MAP.put("labels", InputType.TypeName.FREE_TAG_LIST.value);
        WIDGET_MAP.put("components", InputType.TypeName.TAG_LIST.value);
        WIDGET_MAP.put("versions", InputType.TypeName.TAG_LIST.value);
        WIDGET_MAP.put("fixVersions", InputType.TypeName.TAG_LIST.value);
        WIDGET_MAP.put("description", InputType.TypeName.TEXT_AREA.value);
        WIDGET_MAP.put("environment", InputType.TypeName.TEXT_AREA.value);
        WIDGET_MAP.put("reporter", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("summary", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("assignee", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("security", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("parent", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:datetime", InputType.TypeName.DATE_TIME.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:float", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:url", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:version", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:multiselect", InputType.TypeName.MULTI_SELECT.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:project", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:textarea", InputType.TypeName.TEXT_AREA.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:textfield", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", InputType.TypeName.CHECKBOX_LIST.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", InputType.TypeName.RADIO_BUTTON.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:select", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:importid", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", InputType.TypeName.CASCADING_SELECT.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:multiversion", InputType.TypeName.TAG_LIST.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:datepicker", InputType.TypeName.DATE_PICKER.value);
        WIDGET_MAP.put("com.atlassian.jira.plugin.system.customfieldtypes:labels", InputType.TypeName.FREE_TAG_LIST.value);
        WIDGET_MAP.put("com.atlassian.jirafisheyeplugin:jobcheckbox", InputType.TypeName.CHECKBOX.value);
        WIDGET_MAP.put("com.atlassian.jirafisheyeplugin:hiddenjobswitch", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.atlassian.jira.plugins.jira-importers-plugin:bug-importid", InputType.TypeName.TEXT_FIELD.value);
        WIDGET_MAP.put("com.pyxis.greenhopper.jira:gh-sprint", InputType.TypeName.DROPDOWN_LIST.value);
        WIDGET_MAP.put(GH_EPIC_LINK, InputType.TypeName.TEXT_FIELD.value);
        HashMap datepickerformat = new HashMap(1);
        ADDITIONAL_PARAMS.put(InputType.TypeName.DATE_PICKER.value, datepickerformat);
        HashMap jiraTextFieldParams = new HashMap(1);
        String escapedOriginalTextFieldName = InputType.formatName((String)"com.atlassian.jira.plugin.system.customfieldtypes:textfield");
        ADDITIONAL_PARAMS.put(escapedOriginalTextFieldName, jiraTextFieldParams);
        HashMap<String, String> reporterParams = new HashMap<String, String>(1);
        reporterParams.put(CommonConfigurationKey.ONCHANGE.value, DelegateCommands.buildSearchReporterCommand().getCommand());
        ADDITIONAL_PARAMS.put("reporter", reporterParams);
    }

    WidgetMapping() {
    }

    ThreadLocal<String> getProjectKeyHolder() {
        return this.projectKeyHolder;
    }

    void setProjectKeyHolder(ThreadLocal<String> projectKeyHolder) {
        this.projectKeyHolder = projectKeyHolder;
    }

    String getCorrespondingSquashWidget(String jiraName) {
        String widgetName = WIDGET_MAP.get(jiraName);
        return widgetName != null ? widgetName : InputType.TypeName.UNKNOWN.value;
    }

    Map<String, String> getAdditionalParams(InputType inputType) {
        HashMap<String, String> finalParams = new HashMap<String, String>();
        Map<String, String> params = ADDITIONAL_PARAMS.get(inputType.getName());
        if (params != null) {
            finalParams.putAll(params);
        }
        if ((params = ADDITIONAL_PARAMS.get(inputType.getOriginal())) != null) {
            finalParams.putAll(params);
        }
        if ((params = this.getSpecialParams(inputType.getOriginal())) != null) {
            finalParams.putAll(params);
        }
        return finalParams;
    }

    private Map<String, String> getSpecialParams(String name) {
        HashMap<String, String> toReturn;
        String projectKey = this.projectKeyHolder.get();
        if (name.equals("assignee")) {
            toReturn = new HashMap<String, String>(1);
            DelegateCommand searchCommand = DelegateCommands.buildSearchAssignableCommand(projectKey);
            toReturn.put(CommonConfigurationKey.ONCHANGE.value, searchCommand.getCommand());
        } else if (name.equals(InputType.formatName((String)GH_EPIC_LINK))) {
            toReturn = new HashMap(1);
            DelegateCommand searchCommand = DelegateCommands.buildSeachEpicCommand(projectKey);
            toReturn.put(CommonConfigurationKey.ONCHANGE.value, searchCommand.getCommand());
        } else {
            toReturn = null;
        }
        return toReturn;
    }
}

