/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Attachment;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicComponent;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicPriority;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicProject;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicProjectRole;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicVotes;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicWatchers;
import jiracloud.com.atlassian.jira.rest.client.api.domain.ChangelogGroup;
import jiracloud.com.atlassian.jira.rest.client.api.domain.ChangelogItem;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Comment;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CustomFieldOption;
import jiracloud.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import jiracloud.com.atlassian.jira.rest.client.api.domain.IssueType;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Resolution;
import jiracloud.com.atlassian.jira.rest.client.api.domain.SecurityLevel;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Status;
import jiracloud.com.atlassian.jira.rest.client.api.domain.TimeTracking;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Version;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Worklog;
import jiracloud.org.codehaus.jettison.json.JSONArray;
import jiracloud.org.codehaus.jettison.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.JiraClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.SimpleSprint;

@Component
@Scope(value="prototype")
public class CloudEntityMapping {
    public static final Long NULL_ID = -1L;
    private static final String AGILE_SPRINT_FIELD = "com.pyxis.greenhopper.jira:gh-sprint";
    private static final String COMPONENT_TYPE = "component";
    private static final String PRIORITY = "priority";
    private static final String PROJECT = "project";
    private static final String VERSION = "version";
    private static final String RESOLUTION = "resolution";
    private static final String USER = "user";
    private static final String PROJECTROLE = "projectrole";
    private static final String STATUS = "status";
    private static final String VOTES = "votes";
    private static final String WATCHERS = "watchers";
    private static final String ATTACHMENT = "attachment";
    private static final String CHANGELOGGROUP = "changeloggroup";
    private static final String COMMENT = "comment";
    private static final String WORKLOG = "worklog";
    private static final String TIMETRACKING = "timetracking";
    private static final String ISSUETYPE = "issuetype";
    private static final String JSONOBJECT = "JSONObject";
    private static final String SECURITY_LEVEL = "securitylevel";
    private static final String NONE = "interface.widget.none";
    private static final String OPTION = "option";
    private static final String OPTION_WITH_CHILD = "option-with-child";
    private static final Set<String> HAS_REMOTE_VALUES = new HashSet<String>();
    private Map<String, List<FieldValue>> remoteValuesCache = new HashMap<String, List<FieldValue>>();
    @Inject
    @Named(value="jiraCloudConnectorMessageSource")
    private MessageSource messageSource;
    private JiraClient jiraClient;

    static {
        HAS_REMOTE_VALUES.add(AGILE_SPRINT_FIELD);
    }

    public void setJiraClient(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
    }

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    List<FieldValue> createFieldValues(CimFieldInfo fieldInfo) {
        List<Object> values = new ArrayList();
        if (fieldInfo.getAllowedValues() == null) {
            values = this.hasRemoteValues(fieldInfo) ? this.handleRemoteAllowedValues(fieldInfo) : Collections.emptyList();
        } else {
            String itemType;
            FieldSchema schema = fieldInfo.getSchema();
            String string = itemType = schema.getItems() != null ? schema.getItems() : schema.getType();
            if (this.needsEmptyValue(schema)) {
                this.addEmptyValue(values);
            }
            for (Object aValue : fieldInfo.getAllowedValues()) {
                FieldValue newValue = this.createFieldValue(itemType, aValue);
                values.add(newValue);
            }
        }
        return values;
    }

    private boolean needsEmptyValue(FieldSchema schema) {
        boolean result;
        block20: {
            block18: {
                result = false;
                if (schema.getCustom() == null) break block18;
                switch (schema.getCustom()) {
                    case "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons": 
                    case "com.atlassian.jira.plugin.system.customfieldtypes:project": 
                    case "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect": 
                    case "com.atlassian.jira.plugin.system.customfieldtypes:version": 
                    case "com.atlassian.jira.plugin.system.customfieldtypes:multiselect": 
                    case "com.atlassian.jira.plugin.system.customfieldtypes:select": {
                        result = true;
                        break;
                    }
                }
                break block20;
            }
            if (PRIORITY.equals(schema.getType())) {
                return true;
            }
        }
        return result;
    }

    private void addEmptyValue(List<FieldValue> values) {
        FieldValue fieldValue = new FieldValue();
        fieldValue.setId(NULL_ID.toString());
        fieldValue.setScalar(this.messageSource.getMessage(NONE, null, this.getLocale()));
        fieldValue.setTypename("string");
        values.add(fieldValue);
    }

    FieldValue createFieldValue(String itemType, Object aValue) {
        FieldValue newValue;
        block64: {
            block65: {
                newValue = new FieldValue();
                newValue.setTypename(itemType);
                if (itemType == null) break block64;
                if (!CustomFieldOption.class.isAssignableFrom(aValue.getClass())) break block65;
                newValue = this.castAsCustomFieldOption(aValue);
                break block64;
            }
            switch (itemType) {
                case "component": {
                    newValue = this.castAsComponent(aValue);
                    break;
                }
                case "priority": {
                    newValue = this.castAsBasicPriority(aValue);
                    break;
                }
                case "project": {
                    newValue = this.castAsBasicProject(aValue);
                    break;
                }
                case "version": {
                    newValue = this.castAsBasicVersion(aValue, itemType);
                    break;
                }
                case "resolution": {
                    newValue = this.castAsResolution(aValue);
                    break;
                }
                case "user": {
                    newValue = this.castAsBasicUser(aValue);
                    break;
                }
                case "projectrole": {
                    newValue = this.castAsBasicProjectRole(aValue);
                    break;
                }
                case "status": {
                    newValue = this.castAsStatus(aValue);
                    break;
                }
                case "votes": {
                    newValue = this.castAsBasicVotes(aValue);
                    break;
                }
                case "watchers": {
                    newValue = this.castAsBasicWatchers(aValue);
                    break;
                }
                case "attachment": {
                    newValue = this.castAsAttachment(aValue);
                    break;
                }
                case "changeloggroup": {
                    newValue = this.castAsChangelogGroup(aValue);
                    break;
                }
                case "comment": {
                    newValue = this.castAsComment(aValue);
                    break;
                }
                case "worklog": {
                    newValue = this.castAsWorklog(aValue);
                    break;
                }
                case "timetracking": {
                    newValue = this.castAsTimeTracking(aValue);
                    break;
                }
                case "issuetype": {
                    newValue = this.castAsIssueType(aValue);
                    break;
                }
                case "JSONObject": {
                    newValue = this.castAsJSONObject(aValue);
                    break;
                }
                case "securitylevel": {
                    newValue = this.castAsSecurityLevel(aValue);
                    break;
                }
                case "option": {
                    newValue = this.createOptionValue(aValue);
                    break;
                }
                case "option-with-child": {
                    newValue = this.createOptionWithChild(aValue);
                    break;
                }
            }
        }
        return newValue;
    }

    private FieldValue castAsSecurityLevel(Object aValue) {
        SecurityLevel securityLevel = (SecurityLevel)aValue;
        return new FieldValue(securityLevel.getId().toString(), securityLevel.getName());
    }

    private FieldValue createOptionValue(Object optValue) {
        JSONObject json = (JSONObject)optValue;
        String id = json.optString("id");
        String strVal = json.optString("value");
        FieldValue value = new FieldValue();
        value.setId(id);
        value.setTypename(OPTION);
        value.setScalar(strVal);
        return value;
    }

    private FieldValue createOptionWithChild(Object optValue) {
        JSONArray childrenOpts;
        JSONObject json = (JSONObject)optValue;
        String id = json.optString("id");
        String strVal = json.optString("value");
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        JSONObject childOpt = json.optJSONObject("child");
        if (childOpt != null) {
            FieldValue childVal = this.createOptionValue(childOpt);
            values.add(childVal);
        }
        if ((childrenOpts = json.optJSONArray("children")) != null) {
            int i = 0;
            while (i < childrenOpts.length()) {
                JSONObject chopt = childrenOpts.optJSONObject(i);
                if (chopt != null) {
                    FieldValue chval = this.createOptionValue(chopt);
                    values.add(chval);
                }
                ++i;
            }
        }
        FieldValue fieldvalue = new FieldValue();
        fieldvalue.setId(id);
        fieldvalue.setTypename(OPTION_WITH_CHILD);
        fieldvalue.setScalar(strVal);
        fieldvalue.setComposite(values.toArray(new FieldValue[values.size()]));
        return fieldvalue;
    }

    private FieldValue castAsJSONObject(Object aValue) {
        FieldValue value = new FieldValue();
        JSONObject jsonObject = (JSONObject)aValue;
        Iterator keys = jsonObject.keys();
        ArrayList<FieldValue> composite = new ArrayList<FieldValue>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            composite.add(this.createFieldValue("", jsonObject.opt(key)));
        }
        value.setId("jsonObject");
        value.setComposite(composite.toArray(new FieldValue[composite.size()]));
        return value;
    }

    FieldValue castAsComponent(Object comp) {
        BasicComponent component = (BasicComponent)comp;
        String id = component.getId().toString();
        String name = component.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicPriority(Object priority) {
        BasicPriority basicPriority = (BasicPriority)priority;
        String id = basicPriority.getId().toString();
        String name = basicPriority.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicProject(Object project) {
        BasicProject basicProject = (BasicProject)project;
        String id = basicProject.getKey();
        String name = basicProject.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicVersion(Object version, String itemType) {
        Version basicVersion = (Version)version;
        String id = basicVersion.getId().toString();
        String name = basicVersion.getName();
        FieldValue fieldValue = new FieldValue(id, name);
        fieldValue.setTypename(itemType);
        return fieldValue;
    }

    FieldValue castAsResolution(Object resolution) {
        Resolution Resolution2 = (Resolution)resolution;
        String id = Resolution2.getName();
        String name = Resolution2.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicUser(Object user) {
        BasicUser basicUser = (BasicUser)user;
        String id = basicUser.getName();
        String name = basicUser.getDisplayName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicProjectRole(Object projectRole) {
        BasicProjectRole basicProjectRole = (BasicProjectRole)projectRole;
        String id = basicProjectRole.getName();
        String name = basicProjectRole.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsStatus(Object status) {
        Status Status2 = (Status)status;
        String id = Status2.getName();
        String name = Status2.getName();
        return new FieldValue(id, name);
    }

    FieldValue castAsBasicVotes(Object votes) {
        BasicVotes basicVotes = (BasicVotes)votes;
        FieldValue[] composite = new FieldValue[2];
        FieldValue numVotes = new FieldValue();
        numVotes.setId(VOTES);
        numVotes.setScalar(String.valueOf(basicVotes.getVotes()));
        FieldValue hasVoted = new FieldValue();
        hasVoted.setId("hasVoted");
        hasVoted.setScalar(String.valueOf(basicVotes.hasVoted()));
        composite[0] = numVotes;
        composite[1] = hasVoted;
        FieldValue result = new FieldValue();
        result.setId(VOTES);
        result.setComposite(composite);
        return result;
    }

    FieldValue castAsBasicWatchers(Object watchers) {
        BasicWatchers basicWatchers = (BasicWatchers)watchers;
        FieldValue[] composite = new FieldValue[2];
        FieldValue numWatchers = new FieldValue();
        numWatchers.setId("numWatchers");
        numWatchers.setScalar(String.valueOf(basicWatchers.getNumWatchers()));
        FieldValue isWatching = new FieldValue();
        numWatchers.setId("isWatching");
        isWatching.setScalar(String.valueOf(basicWatchers.isWatching()));
        composite[0] = numWatchers;
        composite[1] = isWatching;
        FieldValue result = new FieldValue();
        result.setId(WATCHERS);
        result.setComposite(composite);
        return result;
    }

    FieldValue castAsAttachment(Object object) {
        FieldValue value = new FieldValue();
        Attachment attachment = (Attachment)object;
        FieldValue[] composite = new FieldValue[]{this.castAsBasicUser(attachment.getAuthor()), new FieldValue("contenturi", attachment.getContentUri().toString()), new FieldValue("creationdate", attachment.getCreationDate().toString()), new FieldValue("filename", attachment.getFilename().toString()), new FieldValue("mimetype", attachment.getMimeType().toString())};
        value.setId(ATTACHMENT);
        value.setComposite(composite);
        return value;
    }

    FieldValue castAsChangelogGroup(Object object) {
        FieldValue value = new FieldValue();
        ChangelogGroup changelogGroup = (ChangelogGroup)object;
        FieldValue[] composite = new FieldValue[3];
        composite[0] = this.castAsBasicUser(changelogGroup.getAuthor());
        composite[1] = new FieldValue("created", changelogGroup.getCreated().toString());
        FieldValue items = new FieldValue();
        ArrayList<FieldValue> changelogList = new ArrayList<FieldValue>();
        for (ChangelogItem changelogitem : changelogGroup.getItems()) {
            changelogList.add(this.castAsChangelogItem(changelogitem));
        }
        items.setId("items");
        items.setComposite(changelogList.toArray(new FieldValue[changelogList.size()]));
        composite[2] = items;
        value.setId("changelogGroup");
        value.setComposite(composite);
        return value;
    }

    FieldValue castAsChangelogItem(Object object) {
        FieldValue value = new FieldValue();
        ChangelogItem changelogitem = (ChangelogItem)object;
        FieldValue[] composite = new FieldValue[]{new FieldValue("field", changelogitem.getField()), new FieldValue("fieldtype", changelogitem.getFieldType().name()), new FieldValue("from", changelogitem.getFrom()), new FieldValue("fromString", changelogitem.getFromString()), new FieldValue("to", changelogitem.getTo()), new FieldValue("toString", changelogitem.getToString())};
        value.setId("changelogItem");
        value.setComposite(composite);
        return value;
    }

    FieldValue castAsComment(Object object) {
        FieldValue value = new FieldValue();
        Comment comment = (Comment)object;
        FieldValue[] composite = new FieldValue[]{this.castAsBasicUser(comment.getAuthor()), new FieldValue("body", comment.getBody().toString()), new FieldValue("creationdate", comment.getCreationDate().toString()), this.castAsBasicUser(comment.getUpdateAuthor()), new FieldValue("updatedate", comment.getUpdateDate().toString()), new FieldValue("visibility", comment.getVisibility().getValue())};
        value.setId(COMMENT);
        value.setComposite(composite);
        return value;
    }

    FieldValue castAsWorklog(Object object) {
        FieldValue value = new FieldValue();
        Worklog worklog = (Worklog)object;
        FieldValue[] composite = new FieldValue[]{this.castAsBasicUser(worklog.getAuthor()), this.castAsComment(worklog.getComment()), new FieldValue("creationdate", worklog.getCreationDate().toString()), new FieldValue("issueuri", worklog.getIssueUri().toString()), new FieldValue("minutespent", String.valueOf(worklog.getMinutesSpent())), new FieldValue("startdate", worklog.getStartDate().toString()), this.castAsBasicUser(worklog.getUpdateAuthor()), new FieldValue("duedate", worklog.getUpdateDate().toString()), new FieldValue("visibility", worklog.getVisibility().getValue())};
        value.setId(WORKLOG);
        value.setComposite(composite);
        return value;
    }

    FieldValue castAsTimeTracking(Object object) {
        FieldValue value = new FieldValue();
        TimeTracking timeTracking = (TimeTracking)object;
        FieldValue[] composite = new FieldValue[]{new FieldValue("originalEstimateMinutes", String.valueOf(timeTracking.getOriginalEstimateMinutes())), new FieldValue("remainingEstimateMinutes", String.valueOf(timeTracking.getRemainingEstimateMinutes())), new FieldValue("timeSpentMinutes", String.valueOf(timeTracking.getTimeSpentMinutes()))};
        value.setId(TIMETRACKING);
        value.setComposite(composite);
        return value;
    }

    FieldValue castAsIssueType(Object object) {
        FieldValue value = new FieldValue();
        IssueType issueType = (IssueType)object;
        value.setId(ISSUETYPE);
        value.setScalar(issueType.getName());
        return value;
    }

    FieldValue castAsCustomFieldOption(Object object) {
        FieldValue value = new FieldValue();
        CustomFieldOption option = (CustomFieldOption)object;
        value.setId(option.getId().toString());
        value.setScalar(option.getValue());
        ArrayList<FieldValue> childrenValues = new ArrayList<FieldValue>();
        for (CustomFieldOption childOption : option.getChildren()) {
            childrenValues.add(this.castAsCustomFieldOption(childOption));
        }
        value.setComposite(childrenValues.toArray(new FieldValue[0]));
        return value;
    }

    boolean hasRemoteValues(CimFieldInfo fieldInfo) {
        FieldSchema schema = fieldInfo.getSchema();
        String custom = schema.getCustom();
        return HAS_REMOTE_VALUES.contains(custom);
    }

    List<FieldValue> handleRemoteAllowedValues(CimFieldInfo fieldInfo) {
        List<FieldValue> values = new ArrayList<FieldValue>();
        FieldSchema schema = fieldInfo.getSchema();
        String custom = schema.getCustom();
        if (AGILE_SPRINT_FIELD.equals(custom)) {
            this.addEmptyValue(values);
            if (this.remoteValuesCache.containsKey(AGILE_SPRINT_FIELD)) {
                values = this.remoteValuesCache.get(AGILE_SPRINT_FIELD);
            } else {
                Iterable<SimpleSprint> sprints = this.jiraClient.searchAvailableSprints();
                for (SimpleSprint sprint : sprints) {
                    FieldValue fieldValue = new FieldValue(String.valueOf(sprint.getId()), sprint.getName());
                    fieldValue.setTypename("string");
                    values.add(fieldValue);
                }
                this.remoteValuesCache.put(AGILE_SPRINT_FIELD, values);
            }
        }
        return values;
    }
}

