/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimIssueType;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimProject;
import jirarest.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import jirarest.com.atlassian.jira.rest.client.api.domain.Issue;
import jirarest.com.atlassian.jira.rest.client.api.domain.StandardOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.MovedIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.conversion.EntityMapping;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.conversion.WidgetMapping;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.BasicEntity;

@Component
@Scope(value="prototype")
class JiraToSquashEntityConverter {
    public static final String ISSUE_TYPE_DEGRADED = "Issue type";
    private static final String ISSUETYPE_FIELD_ID = "issuetype";
    private static final String PROJECTS_FIELD_ID = "project";
    @Inject
    private EntityMapping entityMapping;
    private final WidgetMapping widgetMapping = new WidgetMapping();

    JiraToSquashEntityConverter() {
    }

    public void setJiraClient(JiraClient client) {
        this.entityMapping.setJiraClient(client);
    }

    AdvancedProject jira2SquashProject(CimProject jiraProject) {
        AdvancedProject squashProject = new AdvancedProject();
        this.widgetMapping.getProjectKeyHolder().set(jiraProject.getKey());
        squashProject.setId(jiraProject.getKey());
        squashProject.setName(jiraProject.getName());
        Iterator<CimIssueType> issueTypes = jiraProject.getIssueTypes().iterator();
        squashProject.setSchemeMap(this.buildSchemeMap(issueTypes));
        return squashProject;
    }

    private Map<String, List<Field>> buildSchemeMap(Iterator<CimIssueType> issueTypes) {
        HashMap<String, List<Field>> schemes = new HashMap<String, List<Field>>();
        Field issueTypeField = this.createEmptyIssueTypeField();
        ArrayList<FieldValue> possibleIssueTypes = new ArrayList<FieldValue>();
        while (issueTypes.hasNext()) {
            CimIssueType issueType = issueTypes.next();
            FieldValue newIssueType = new FieldValue(issueType.getId().toString(), issueType.getName());
            newIssueType.setTypename(ISSUETYPE_FIELD_ID);
            possibleIssueTypes.add(newIssueType);
            String schemeKey = "issuetype:" + issueType.getName();
            ArrayList<Field> schemeFields = new ArrayList<Field>();
            schemes.put(schemeKey, schemeFields);
            schemeFields.add(issueTypeField);
            Map<String, CimFieldInfo> fields = issueType.getFields();
            for (Map.Entry<String, CimFieldInfo> entry : fields.entrySet()) {
                CimFieldInfo fieldInfo = entry.getValue();
                String key = entry.getKey();
                if (key.equals(PROJECTS_FIELD_ID)) continue;
                if (key.equals(ISSUETYPE_FIELD_ID)) {
                    issueTypeField.setLabel(fieldInfo.getName());
                    continue;
                }
                Field squashField = this.jiraCimField2SquashField(fieldInfo);
                schemeFields.add(squashField);
            }
        }
        if (issueTypeField.getLabel() == null) {
            issueTypeField.setLabel(ISSUE_TYPE_DEGRADED);
        }
        issueTypeField.setPossibleValues(possibleIssueTypes.toArray(new FieldValue[possibleIssueTypes.size()]));
        return schemes;
    }

    private Field createEmptyIssueTypeField() {
        Field issueTypeField = new Field();
        issueTypeField.setId(ISSUETYPE_FIELD_ID);
        InputType inputType = new InputType(InputType.TypeName.DROPDOWN_LIST.value, ISSUETYPE_FIELD_ID);
        inputType.setFieldSchemeSelector(true);
        Rendering rendering = new Rendering(new String[]{"SET"}, inputType, true);
        issueTypeField.setRendering(rendering);
        return issueTypeField;
    }

    private void fixBrokenFields(Field field) {
        if (field.getLabel() == null) {
            field.setLabel(field.getRendering().getInputType().getDataType());
        }
    }

    private Field jiraCimField2SquashField(CimFieldInfo fieldInfo) {
        Field field = new Field();
        field.setId(fieldInfo.getId());
        field.setLabel(fieldInfo.getName());
        List<FieldValue> possibleValues = this.entityMapping.createFieldValues(fieldInfo);
        field.setPossibleValues(possibleValues.toArray(new FieldValue[possibleValues.size()]));
        field.setRendering(this.jira2SquashRendering(fieldInfo));
        this.fixBrokenFields(field);
        return field;
    }

    private Rendering jira2SquashRendering(CimFieldInfo fieldInfo) {
        Rendering rendering = new Rendering();
        ArrayList<String> operations = new ArrayList<String>();
        if (fieldInfo.getOperations() != null) {
            for (StandardOperation operation : fieldInfo.getOperations()) {
                operations.add(operation.name());
            }
        }
        rendering.setOperations(operations.toArray(new String[operations.size()]));
        rendering.setInputType(this.jira2SquashInputType(fieldInfo.getSchema()));
        rendering.setRequired(fieldInfo.isRequired());
        return rendering;
    }

    private InputType jira2SquashInputType(FieldSchema fieldSchema) {
        InputType inputType = new InputType();
        String originalName = fieldSchema.isCustom() ? fieldSchema.getCustom() : fieldSchema.getSystem();
        inputType.setOriginal(originalName);
        String squashName = this.widgetMapping.getCorrespondingSquashWidget(originalName);
        inputType.setName(squashName);
        Map<String, String> params = this.widgetMapping.getAdditionalParams(inputType);
        inputType.setConfiguration(params);
        String type = fieldSchema.getType();
        if (type.equals("array")) {
            type = String.valueOf(fieldSchema.getItems()) + "-" + fieldSchema.getType();
        }
        if (type.equals("string-array")) {
            type = squashName;
        }
        if (originalName.equals("com.atlassian.jira.plugin.system.customfieldtypes:select") || originalName.equals("com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons")) {
            type = "select_option";
        }
        inputType.setDataType(type);
        return inputType;
    }

    AdvancedIssue jira2SquashIssue(Issue jiraIssue) {
        JiraAdvancedIssue squashIssue = new JiraAdvancedIssue();
        this.fillSquashIssue(squashIssue, jiraIssue);
        return squashIssue;
    }

    List<AdvancedIssue> jira2SquashIssues(Iterable<Issue> jiraIssues) {
        ArrayList<AdvancedIssue> issues = new ArrayList<AdvancedIssue>();
        for (Issue jiraIssue : jiraIssues) {
            JiraAdvancedIssue squashIssue = new JiraAdvancedIssue();
            this.fillSquashIssue(squashIssue, jiraIssue);
            issues.add(squashIssue);
        }
        return issues;
    }

    private void fillSquashIssue(JiraAdvancedIssue squashIssue, Issue jiraIssue) {
        AdvancedProject projectStub = new AdvancedProject();
        projectStub.setId(jiraIssue.getProject().getKey());
        projectStub.setName(jiraIssue.getProject().getName());
        squashIssue.setProject(projectStub);
        if (!(jiraIssue instanceof MovedIssue)) {
            squashIssue.setId(jiraIssue.getKey());
        } else {
            squashIssue.setId(((MovedIssue)jiraIssue).getPreviousKey());
            squashIssue.setNewKey(jiraIssue.getKey());
        }
        this.setIssueType(squashIssue, jiraIssue);
        this.setSummary(squashIssue, jiraIssue);
        this.setPriority(squashIssue, jiraIssue);
        this.setStatus(squashIssue, jiraIssue);
        this.setAssignee(squashIssue, jiraIssue);
        this.setDescription(squashIssue, jiraIssue);
        this.setCurrentScheme(squashIssue, jiraIssue);
    }

    private void setIssueType(AdvancedIssue squashIssue, Issue jiraIssue) {
        if (jiraIssue.getIssueType() != null) {
            squashIssue.setFieldValue(ISSUETYPE_FIELD_ID, new FieldValue("", jiraIssue.getIssueType().getName()));
        }
    }

    private void setSummary(AdvancedIssue squashIssue, Issue jiraIssue) {
        if (jiraIssue.getSummary() != null) {
            squashIssue.setFieldValue("summary", new FieldValue("", jiraIssue.getSummary()));
        }
    }

    private void setDescription(AdvancedIssue squashIssue, Issue jiraIssue) {
        if (!StringUtils.isBlank((String)jiraIssue.getDescription())) {
            squashIssue.setFieldValue("description", new FieldValue("", jiraIssue.getDescription()));
        }
    }

    private void setPriority(AdvancedIssue squashIssue, Issue jiraIssue) {
        if (jiraIssue.getPriority() != null) {
            String id = String.valueOf(jiraIssue.getPriority().getId());
            String name = jiraIssue.getPriority().getName();
            squashIssue.setFieldValue("priority", new FieldValue(id, name));
        }
    }

    private void setStatus(AdvancedIssue squashIssue, Issue jiraIssue) {
        if (jiraIssue.getStatus() != null) {
            squashIssue.setFieldValue("status", new FieldValue("", jiraIssue.getStatus().getName()));
        }
    }

    private void setAssignee(AdvancedIssue squashIssue, Issue jiraIssue) {
        if (jiraIssue.getAssignee() != null) {
            String id = jiraIssue.getAssignee().getName();
            String name = jiraIssue.getAssignee().getDisplayName();
            squashIssue.setFieldValue("assignee", new FieldValue(id, name));
        }
    }

    private void setCurrentScheme(AdvancedIssue squashIssue, Issue jiraIssue) {
        squashIssue.setCurrentScheme("issuetype:" + jiraIssue.getIssueType().getName());
    }

    AdvancedProject createReadOnlyProjectStub(String schemeName, BugTrackerInterfaceDescriptor descriptor) {
        AdvancedProject project = new AdvancedProject();
        Field summaryField = this.createReadOnlyField("summary", descriptor.getReportSummaryLabel());
        Field descriptionField = this.createReadOnlyField("description", descriptor.getReportDescriptionLabel());
        descriptionField.getRendering().getInputType().setName(InputType.TypeName.TEXT_AREA.value);
        Field statusField = this.createReadOnlyField("status", descriptor.getTableStatusHeader());
        Field assigneeField = this.createReadOnlyField("assignee", descriptor.getReportAssigneeLabel());
        Field priorityField = this.createReadOnlyField("priority", descriptor.getReportPriorityLabel());
        project.setSchemeMap(Collections.singletonMap(schemeName, Arrays.asList(summaryField, priorityField, statusField, assigneeField, descriptionField)));
        return project;
    }

    private Field createReadOnlyField(String id, String label) {
        Field field = new Field(id, label);
        Rendering rendering = new Rendering(new String[0], new InputType(InputType.TypeName.TEXT_FIELD.value, "unknown"), false);
        field.setRendering(rendering);
        return field;
    }

    FieldValue convertToEpicCompositeFieldValue(Iterable<? extends BasicEntity> entities, String typename) {
        FieldValue newValue = new FieldValue();
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        for (BasicEntity basicEntity : entities) {
            FieldValue eValue = new FieldValue(basicEntity.getKey(), basicEntity.getKey());
            eValue.setTypename(typename);
            result.add(eValue);
        }
        newValue.setComposite(result.toArray(new FieldValue[result.size()]));
        return newValue;
    }

    FieldValue convertToUserCompositeFieldValue(Iterable<BasicUser> users) {
        FieldValue newValue = new FieldValue();
        ArrayList<FieldValue> resultUsers = new ArrayList<FieldValue>();
        for (BasicUser user : users) {
            FieldValue uValue = new FieldValue(user.getName(), user.getName());
            uValue.setTypename("user");
            resultUsers.add(uValue);
        }
        newValue.setComposite(resultUsers.toArray(new FieldValue[resultUsers.size()]));
        return newValue;
    }
}

